// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/registry/plugin/v1beta1/check_service.proto

package pluginv1beta1connect

import (
	v1beta1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// CheckServiceName is the fully-qualified name of the CheckService service.
	CheckServiceName = "buf.registry.plugin.v1beta1.CheckService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// CheckServiceListRulesProcedure is the fully-qualified name of the CheckService's ListRules RPC.
	CheckServiceListRulesProcedure = "/buf.registry.plugin.v1beta1.CheckService/ListRules"
	// CheckServiceListCategoriesProcedure is the fully-qualified name of the CheckService's
	// ListCategories RPC.
	CheckServiceListCategoriesProcedure = "/buf.registry.plugin.v1beta1.CheckService/ListCategories"
)

// CheckServiceClient is a client for the buf.registry.plugin.v1beta1.CheckService service.
type CheckServiceClient interface {
	// List Rules for a given Plugin, Label, or Commit.
	ListRules(context.Context, *connect.Request[v1beta1.ListRulesRequest]) (*connect.Response[v1beta1.ListRulesResponse], error)
	// List Categories for a given Plugin, Label, or Commit.
	ListCategories(context.Context, *connect.Request[v1beta1.ListCategoriesRequest]) (*connect.Response[v1beta1.ListCategoriesResponse], error)
}

// NewCheckServiceClient constructs a client for the buf.registry.plugin.v1beta1.CheckService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewCheckServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) CheckServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	checkServiceMethods := v1beta1.File_buf_registry_plugin_v1beta1_check_service_proto.Services().ByName("CheckService").Methods()
	return &checkServiceClient{
		listRules: connect.NewClient[v1beta1.ListRulesRequest, v1beta1.ListRulesResponse](
			httpClient,
			baseURL+CheckServiceListRulesProcedure,
			connect.WithSchema(checkServiceMethods.ByName("ListRules")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listCategories: connect.NewClient[v1beta1.ListCategoriesRequest, v1beta1.ListCategoriesResponse](
			httpClient,
			baseURL+CheckServiceListCategoriesProcedure,
			connect.WithSchema(checkServiceMethods.ByName("ListCategories")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
	}
}

// checkServiceClient implements CheckServiceClient.
type checkServiceClient struct {
	listRules      *connect.Client[v1beta1.ListRulesRequest, v1beta1.ListRulesResponse]
	listCategories *connect.Client[v1beta1.ListCategoriesRequest, v1beta1.ListCategoriesResponse]
}

// ListRules calls buf.registry.plugin.v1beta1.CheckService.ListRules.
func (c *checkServiceClient) ListRules(ctx context.Context, req *connect.Request[v1beta1.ListRulesRequest]) (*connect.Response[v1beta1.ListRulesResponse], error) {
	return c.listRules.CallUnary(ctx, req)
}

// ListCategories calls buf.registry.plugin.v1beta1.CheckService.ListCategories.
func (c *checkServiceClient) ListCategories(ctx context.Context, req *connect.Request[v1beta1.ListCategoriesRequest]) (*connect.Response[v1beta1.ListCategoriesResponse], error) {
	return c.listCategories.CallUnary(ctx, req)
}

// CheckServiceHandler is an implementation of the buf.registry.plugin.v1beta1.CheckService service.
type CheckServiceHandler interface {
	// List Rules for a given Plugin, Label, or Commit.
	ListRules(context.Context, *connect.Request[v1beta1.ListRulesRequest]) (*connect.Response[v1beta1.ListRulesResponse], error)
	// List Categories for a given Plugin, Label, or Commit.
	ListCategories(context.Context, *connect.Request[v1beta1.ListCategoriesRequest]) (*connect.Response[v1beta1.ListCategoriesResponse], error)
}

// NewCheckServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewCheckServiceHandler(svc CheckServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	checkServiceMethods := v1beta1.File_buf_registry_plugin_v1beta1_check_service_proto.Services().ByName("CheckService").Methods()
	checkServiceListRulesHandler := connect.NewUnaryHandler(
		CheckServiceListRulesProcedure,
		svc.ListRules,
		connect.WithSchema(checkServiceMethods.ByName("ListRules")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	checkServiceListCategoriesHandler := connect.NewUnaryHandler(
		CheckServiceListCategoriesProcedure,
		svc.ListCategories,
		connect.WithSchema(checkServiceMethods.ByName("ListCategories")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.registry.plugin.v1beta1.CheckService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case CheckServiceListRulesProcedure:
			checkServiceListRulesHandler.ServeHTTP(w, r)
		case CheckServiceListCategoriesProcedure:
			checkServiceListCategoriesHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedCheckServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedCheckServiceHandler struct{}

func (UnimplementedCheckServiceHandler) ListRules(context.Context, *connect.Request[v1beta1.ListRulesRequest]) (*connect.Response[v1beta1.ListRulesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.plugin.v1beta1.CheckService.ListRules is not implemented"))
}

func (UnimplementedCheckServiceHandler) ListCategories(context.Context, *connect.Request[v1beta1.ListCategoriesRequest]) (*connect.Response[v1beta1.ListCategoriesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.plugin.v1beta1.CheckService.ListCategories is not implemented"))
}
