// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/registry/policy/v1beta1/policy_service.proto

package policyv1beta1connect

import (
	v1beta1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/policy/v1beta1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// PolicyServiceName is the fully-qualified name of the PolicyService service.
	PolicyServiceName = "buf.registry.policy.v1beta1.PolicyService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// PolicyServiceGetPoliciesProcedure is the fully-qualified name of the PolicyService's GetPolicies
	// RPC.
	PolicyServiceGetPoliciesProcedure = "/buf.registry.policy.v1beta1.PolicyService/GetPolicies"
	// PolicyServiceListPoliciesProcedure is the fully-qualified name of the PolicyService's
	// ListPolicies RPC.
	PolicyServiceListPoliciesProcedure = "/buf.registry.policy.v1beta1.PolicyService/ListPolicies"
	// PolicyServiceCreatePoliciesProcedure is the fully-qualified name of the PolicyService's
	// CreatePolicies RPC.
	PolicyServiceCreatePoliciesProcedure = "/buf.registry.policy.v1beta1.PolicyService/CreatePolicies"
	// PolicyServiceUpdatePoliciesProcedure is the fully-qualified name of the PolicyService's
	// UpdatePolicies RPC.
	PolicyServiceUpdatePoliciesProcedure = "/buf.registry.policy.v1beta1.PolicyService/UpdatePolicies"
	// PolicyServiceDeletePoliciesProcedure is the fully-qualified name of the PolicyService's
	// DeletePolicies RPC.
	PolicyServiceDeletePoliciesProcedure = "/buf.registry.policy.v1beta1.PolicyService/DeletePolicies"
)

// PolicyServiceClient is a client for the buf.registry.policy.v1beta1.PolicyService service.
type PolicyServiceClient interface {
	// Get Policies by id or name.
	GetPolicies(context.Context, *connect.Request[v1beta1.GetPoliciesRequest]) (*connect.Response[v1beta1.GetPoliciesResponse], error)
	// List Policies, usually for a specific User or Organization.
	ListPolicies(context.Context, *connect.Request[v1beta1.ListPoliciesRequest]) (*connect.Response[v1beta1.ListPoliciesResponse], error)
	// Create new Policies.
	//
	// This operation is atomic. Either all Policies are created or an error is returned.
	CreatePolicies(context.Context, *connect.Request[v1beta1.CreatePoliciesRequest]) (*connect.Response[v1beta1.CreatePoliciesResponse], error)
	// Update exiting Policies.
	//
	// This operation is atomic. Either all Policies are updated or an error is returned.
	UpdatePolicies(context.Context, *connect.Request[v1beta1.UpdatePoliciesRequest]) (*connect.Response[v1beta1.UpdatePoliciesResponse], error)
	// Delete existing Policies.
	//
	// This operation is atomic. Either all Policies are deleted or an error is returned.
	DeletePolicies(context.Context, *connect.Request[v1beta1.DeletePoliciesRequest]) (*connect.Response[v1beta1.DeletePoliciesResponse], error)
}

// NewPolicyServiceClient constructs a client for the buf.registry.policy.v1beta1.PolicyService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewPolicyServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) PolicyServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	policyServiceMethods := v1beta1.File_buf_registry_policy_v1beta1_policy_service_proto.Services().ByName("PolicyService").Methods()
	return &policyServiceClient{
		getPolicies: connect.NewClient[v1beta1.GetPoliciesRequest, v1beta1.GetPoliciesResponse](
			httpClient,
			baseURL+PolicyServiceGetPoliciesProcedure,
			connect.WithSchema(policyServiceMethods.ByName("GetPolicies")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listPolicies: connect.NewClient[v1beta1.ListPoliciesRequest, v1beta1.ListPoliciesResponse](
			httpClient,
			baseURL+PolicyServiceListPoliciesProcedure,
			connect.WithSchema(policyServiceMethods.ByName("ListPolicies")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		createPolicies: connect.NewClient[v1beta1.CreatePoliciesRequest, v1beta1.CreatePoliciesResponse](
			httpClient,
			baseURL+PolicyServiceCreatePoliciesProcedure,
			connect.WithSchema(policyServiceMethods.ByName("CreatePolicies")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		updatePolicies: connect.NewClient[v1beta1.UpdatePoliciesRequest, v1beta1.UpdatePoliciesResponse](
			httpClient,
			baseURL+PolicyServiceUpdatePoliciesProcedure,
			connect.WithSchema(policyServiceMethods.ByName("UpdatePolicies")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		deletePolicies: connect.NewClient[v1beta1.DeletePoliciesRequest, v1beta1.DeletePoliciesResponse](
			httpClient,
			baseURL+PolicyServiceDeletePoliciesProcedure,
			connect.WithSchema(policyServiceMethods.ByName("DeletePolicies")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
	}
}

// policyServiceClient implements PolicyServiceClient.
type policyServiceClient struct {
	getPolicies    *connect.Client[v1beta1.GetPoliciesRequest, v1beta1.GetPoliciesResponse]
	listPolicies   *connect.Client[v1beta1.ListPoliciesRequest, v1beta1.ListPoliciesResponse]
	createPolicies *connect.Client[v1beta1.CreatePoliciesRequest, v1beta1.CreatePoliciesResponse]
	updatePolicies *connect.Client[v1beta1.UpdatePoliciesRequest, v1beta1.UpdatePoliciesResponse]
	deletePolicies *connect.Client[v1beta1.DeletePoliciesRequest, v1beta1.DeletePoliciesResponse]
}

// GetPolicies calls buf.registry.policy.v1beta1.PolicyService.GetPolicies.
func (c *policyServiceClient) GetPolicies(ctx context.Context, req *connect.Request[v1beta1.GetPoliciesRequest]) (*connect.Response[v1beta1.GetPoliciesResponse], error) {
	return c.getPolicies.CallUnary(ctx, req)
}

// ListPolicies calls buf.registry.policy.v1beta1.PolicyService.ListPolicies.
func (c *policyServiceClient) ListPolicies(ctx context.Context, req *connect.Request[v1beta1.ListPoliciesRequest]) (*connect.Response[v1beta1.ListPoliciesResponse], error) {
	return c.listPolicies.CallUnary(ctx, req)
}

// CreatePolicies calls buf.registry.policy.v1beta1.PolicyService.CreatePolicies.
func (c *policyServiceClient) CreatePolicies(ctx context.Context, req *connect.Request[v1beta1.CreatePoliciesRequest]) (*connect.Response[v1beta1.CreatePoliciesResponse], error) {
	return c.createPolicies.CallUnary(ctx, req)
}

// UpdatePolicies calls buf.registry.policy.v1beta1.PolicyService.UpdatePolicies.
func (c *policyServiceClient) UpdatePolicies(ctx context.Context, req *connect.Request[v1beta1.UpdatePoliciesRequest]) (*connect.Response[v1beta1.UpdatePoliciesResponse], error) {
	return c.updatePolicies.CallUnary(ctx, req)
}

// DeletePolicies calls buf.registry.policy.v1beta1.PolicyService.DeletePolicies.
func (c *policyServiceClient) DeletePolicies(ctx context.Context, req *connect.Request[v1beta1.DeletePoliciesRequest]) (*connect.Response[v1beta1.DeletePoliciesResponse], error) {
	return c.deletePolicies.CallUnary(ctx, req)
}

// PolicyServiceHandler is an implementation of the buf.registry.policy.v1beta1.PolicyService
// service.
type PolicyServiceHandler interface {
	// Get Policies by id or name.
	GetPolicies(context.Context, *connect.Request[v1beta1.GetPoliciesRequest]) (*connect.Response[v1beta1.GetPoliciesResponse], error)
	// List Policies, usually for a specific User or Organization.
	ListPolicies(context.Context, *connect.Request[v1beta1.ListPoliciesRequest]) (*connect.Response[v1beta1.ListPoliciesResponse], error)
	// Create new Policies.
	//
	// This operation is atomic. Either all Policies are created or an error is returned.
	CreatePolicies(context.Context, *connect.Request[v1beta1.CreatePoliciesRequest]) (*connect.Response[v1beta1.CreatePoliciesResponse], error)
	// Update exiting Policies.
	//
	// This operation is atomic. Either all Policies are updated or an error is returned.
	UpdatePolicies(context.Context, *connect.Request[v1beta1.UpdatePoliciesRequest]) (*connect.Response[v1beta1.UpdatePoliciesResponse], error)
	// Delete existing Policies.
	//
	// This operation is atomic. Either all Policies are deleted or an error is returned.
	DeletePolicies(context.Context, *connect.Request[v1beta1.DeletePoliciesRequest]) (*connect.Response[v1beta1.DeletePoliciesResponse], error)
}

// NewPolicyServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewPolicyServiceHandler(svc PolicyServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	policyServiceMethods := v1beta1.File_buf_registry_policy_v1beta1_policy_service_proto.Services().ByName("PolicyService").Methods()
	policyServiceGetPoliciesHandler := connect.NewUnaryHandler(
		PolicyServiceGetPoliciesProcedure,
		svc.GetPolicies,
		connect.WithSchema(policyServiceMethods.ByName("GetPolicies")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	policyServiceListPoliciesHandler := connect.NewUnaryHandler(
		PolicyServiceListPoliciesProcedure,
		svc.ListPolicies,
		connect.WithSchema(policyServiceMethods.ByName("ListPolicies")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	policyServiceCreatePoliciesHandler := connect.NewUnaryHandler(
		PolicyServiceCreatePoliciesProcedure,
		svc.CreatePolicies,
		connect.WithSchema(policyServiceMethods.ByName("CreatePolicies")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	policyServiceUpdatePoliciesHandler := connect.NewUnaryHandler(
		PolicyServiceUpdatePoliciesProcedure,
		svc.UpdatePolicies,
		connect.WithSchema(policyServiceMethods.ByName("UpdatePolicies")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	policyServiceDeletePoliciesHandler := connect.NewUnaryHandler(
		PolicyServiceDeletePoliciesProcedure,
		svc.DeletePolicies,
		connect.WithSchema(policyServiceMethods.ByName("DeletePolicies")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.registry.policy.v1beta1.PolicyService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case PolicyServiceGetPoliciesProcedure:
			policyServiceGetPoliciesHandler.ServeHTTP(w, r)
		case PolicyServiceListPoliciesProcedure:
			policyServiceListPoliciesHandler.ServeHTTP(w, r)
		case PolicyServiceCreatePoliciesProcedure:
			policyServiceCreatePoliciesHandler.ServeHTTP(w, r)
		case PolicyServiceUpdatePoliciesProcedure:
			policyServiceUpdatePoliciesHandler.ServeHTTP(w, r)
		case PolicyServiceDeletePoliciesProcedure:
			policyServiceDeletePoliciesHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedPolicyServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedPolicyServiceHandler struct{}

func (UnimplementedPolicyServiceHandler) GetPolicies(context.Context, *connect.Request[v1beta1.GetPoliciesRequest]) (*connect.Response[v1beta1.GetPoliciesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.policy.v1beta1.PolicyService.GetPolicies is not implemented"))
}

func (UnimplementedPolicyServiceHandler) ListPolicies(context.Context, *connect.Request[v1beta1.ListPoliciesRequest]) (*connect.Response[v1beta1.ListPoliciesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.policy.v1beta1.PolicyService.ListPolicies is not implemented"))
}

func (UnimplementedPolicyServiceHandler) CreatePolicies(context.Context, *connect.Request[v1beta1.CreatePoliciesRequest]) (*connect.Response[v1beta1.CreatePoliciesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.policy.v1beta1.PolicyService.CreatePolicies is not implemented"))
}

func (UnimplementedPolicyServiceHandler) UpdatePolicies(context.Context, *connect.Request[v1beta1.UpdatePoliciesRequest]) (*connect.Response[v1beta1.UpdatePoliciesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.policy.v1beta1.PolicyService.UpdatePolicies is not implemented"))
}

func (UnimplementedPolicyServiceHandler) DeletePolicies(context.Context, *connect.Request[v1beta1.DeletePoliciesRequest]) (*connect.Response[v1beta1.DeletePoliciesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.policy.v1beta1.PolicyService.DeletePolicies is not implemented"))
}
