//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by conversion-gen. DO NOT EDIT.

package v1

import (
	unsafe "unsafe"

	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	apismetav1 "github.com/cert-manager/cert-manager/pkg/apis/meta/v1"
	acme "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/acme"
	meta "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/meta"
	metav1 "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/meta/v1"
	corev1 "k8s.io/api/core/v1"
	apiextensionsv1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1"
	pkgapismetav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEAuthorization)(nil), (*acme.ACMEAuthorization)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEAuthorization_To_acme_ACMEAuthorization(a.(*acmev1.ACMEAuthorization), b.(*acme.ACMEAuthorization), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEAuthorization)(nil), (*acmev1.ACMEAuthorization)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEAuthorization_To_v1_ACMEAuthorization(a.(*acme.ACMEAuthorization), b.(*acmev1.ACMEAuthorization), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallenge)(nil), (*acme.ACMEChallenge)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallenge_To_acme_ACMEChallenge(a.(*acmev1.ACMEChallenge), b.(*acme.ACMEChallenge), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallenge)(nil), (*acmev1.ACMEChallenge)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallenge_To_v1_ACMEChallenge(a.(*acme.ACMEChallenge), b.(*acmev1.ACMEChallenge), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolver)(nil), (*acme.ACMEChallengeSolver)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(a.(*acmev1.ACMEChallengeSolver), b.(*acme.ACMEChallengeSolver), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolver)(nil), (*acmev1.ACMEChallengeSolver)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolver_To_v1_ACMEChallengeSolver(a.(*acme.ACMEChallengeSolver), b.(*acmev1.ACMEChallengeSolver), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverDNS01)(nil), (*acme.ACMEChallengeSolverDNS01)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(a.(*acmev1.ACMEChallengeSolverDNS01), b.(*acme.ACMEChallengeSolverDNS01), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverDNS01)(nil), (*acmev1.ACMEChallengeSolverDNS01)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverDNS01_To_v1_ACMEChallengeSolverDNS01(a.(*acme.ACMEChallengeSolverDNS01), b.(*acmev1.ACMEChallengeSolverDNS01), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01)(nil), (*acme.ACMEChallengeSolverHTTP01)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01(a.(*acmev1.ACMEChallengeSolverHTTP01), b.(*acme.ACMEChallengeSolverHTTP01), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01)(nil), (*acmev1.ACMEChallengeSolverHTTP01)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01_To_v1_ACMEChallengeSolverHTTP01(a.(*acme.ACMEChallengeSolverHTTP01), b.(*acmev1.ACMEChallengeSolverHTTP01), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute)(nil), (*acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute(a.(*acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute), b.(*acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute)(nil), (*acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute(a.(*acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute), b.(*acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01Ingress)(nil), (*acme.ACMEChallengeSolverHTTP01Ingress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress(a.(*acmev1.ACMEChallengeSolverHTTP01Ingress), b.(*acme.ACMEChallengeSolverHTTP01Ingress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01Ingress)(nil), (*acmev1.ACMEChallengeSolverHTTP01Ingress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1_ACMEChallengeSolverHTTP01Ingress(a.(*acme.ACMEChallengeSolverHTTP01Ingress), b.(*acmev1.ACMEChallengeSolverHTTP01Ingress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01IngressObjectMeta)(nil), (*acme.ACMEChallengeSolverHTTP01IngressObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(a.(*acmev1.ACMEChallengeSolverHTTP01IngressObjectMeta), b.(*acme.ACMEChallengeSolverHTTP01IngressObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressObjectMeta)(nil), (*acmev1.ACMEChallengeSolverHTTP01IngressObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressObjectMeta(a.(*acme.ACMEChallengeSolverHTTP01IngressObjectMeta), b.(*acmev1.ACMEChallengeSolverHTTP01IngressObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01IngressPodObjectMeta)(nil), (*acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(a.(*acmev1.ACMEChallengeSolverHTTP01IngressPodObjectMeta), b.(*acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta)(nil), (*acmev1.ACMEChallengeSolverHTTP01IngressPodObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta(a.(*acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta), b.(*acmev1.ACMEChallengeSolverHTTP01IngressPodObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01IngressPodResources)(nil), (*acme.ACMEChallengeSolverHTTP01IngressPodResources)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01IngressPodResources_To_acme_ACMEChallengeSolverHTTP01IngressPodResources(a.(*acmev1.ACMEChallengeSolverHTTP01IngressPodResources), b.(*acme.ACMEChallengeSolverHTTP01IngressPodResources), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressPodResources)(nil), (*acmev1.ACMEChallengeSolverHTTP01IngressPodResources)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressPodResources_To_v1_ACMEChallengeSolverHTTP01IngressPodResources(a.(*acme.ACMEChallengeSolverHTTP01IngressPodResources), b.(*acmev1.ACMEChallengeSolverHTTP01IngressPodResources), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext)(nil), (*acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext(a.(*acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext), b.(*acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext)(nil), (*acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext(a.(*acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext), b.(*acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01IngressPodSpec)(nil), (*acme.ACMEChallengeSolverHTTP01IngressPodSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(a.(*acmev1.ACMEChallengeSolverHTTP01IngressPodSpec), b.(*acme.ACMEChallengeSolverHTTP01IngressPodSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressPodSpec)(nil), (*acmev1.ACMEChallengeSolverHTTP01IngressPodSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1_ACMEChallengeSolverHTTP01IngressPodSpec(a.(*acme.ACMEChallengeSolverHTTP01IngressPodSpec), b.(*acmev1.ACMEChallengeSolverHTTP01IngressPodSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate)(nil), (*acme.ACMEChallengeSolverHTTP01IngressPodTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate(a.(*acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate), b.(*acme.ACMEChallengeSolverHTTP01IngressPodTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressPodTemplate)(nil), (*acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1_ACMEChallengeSolverHTTP01IngressPodTemplate(a.(*acme.ACMEChallengeSolverHTTP01IngressPodTemplate), b.(*acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEChallengeSolverHTTP01IngressTemplate)(nil), (*acme.ACMEChallengeSolverHTTP01IngressTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate(a.(*acmev1.ACMEChallengeSolverHTTP01IngressTemplate), b.(*acme.ACMEChallengeSolverHTTP01IngressTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressTemplate)(nil), (*acmev1.ACMEChallengeSolverHTTP01IngressTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1_ACMEChallengeSolverHTTP01IngressTemplate(a.(*acme.ACMEChallengeSolverHTTP01IngressTemplate), b.(*acmev1.ACMEChallengeSolverHTTP01IngressTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEExternalAccountBinding)(nil), (*acme.ACMEExternalAccountBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(a.(*acmev1.ACMEExternalAccountBinding), b.(*acme.ACMEExternalAccountBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEExternalAccountBinding)(nil), (*acmev1.ACMEExternalAccountBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEExternalAccountBinding_To_v1_ACMEExternalAccountBinding(a.(*acme.ACMEExternalAccountBinding), b.(*acmev1.ACMEExternalAccountBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderAcmeDNS)(nil), (*acme.ACMEIssuerDNS01ProviderAcmeDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(a.(*acmev1.ACMEIssuerDNS01ProviderAcmeDNS), b.(*acme.ACMEIssuerDNS01ProviderAcmeDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderAcmeDNS)(nil), (*acmev1.ACMEIssuerDNS01ProviderAcmeDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1_ACMEIssuerDNS01ProviderAcmeDNS(a.(*acme.ACMEIssuerDNS01ProviderAcmeDNS), b.(*acmev1.ACMEIssuerDNS01ProviderAcmeDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderAkamai)(nil), (*acme.ACMEIssuerDNS01ProviderAkamai)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(a.(*acmev1.ACMEIssuerDNS01ProviderAkamai), b.(*acme.ACMEIssuerDNS01ProviderAkamai), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderAkamai)(nil), (*acmev1.ACMEIssuerDNS01ProviderAkamai)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1_ACMEIssuerDNS01ProviderAkamai(a.(*acme.ACMEIssuerDNS01ProviderAkamai), b.(*acmev1.ACMEIssuerDNS01ProviderAkamai), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderAzureDNS)(nil), (*acme.ACMEIssuerDNS01ProviderAzureDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(a.(*acmev1.ACMEIssuerDNS01ProviderAzureDNS), b.(*acme.ACMEIssuerDNS01ProviderAzureDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderAzureDNS)(nil), (*acmev1.ACMEIssuerDNS01ProviderAzureDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1_ACMEIssuerDNS01ProviderAzureDNS(a.(*acme.ACMEIssuerDNS01ProviderAzureDNS), b.(*acmev1.ACMEIssuerDNS01ProviderAzureDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderCloudDNS)(nil), (*acme.ACMEIssuerDNS01ProviderCloudDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(a.(*acmev1.ACMEIssuerDNS01ProviderCloudDNS), b.(*acme.ACMEIssuerDNS01ProviderCloudDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderCloudDNS)(nil), (*acmev1.ACMEIssuerDNS01ProviderCloudDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1_ACMEIssuerDNS01ProviderCloudDNS(a.(*acme.ACMEIssuerDNS01ProviderCloudDNS), b.(*acmev1.ACMEIssuerDNS01ProviderCloudDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderCloudflare)(nil), (*acme.ACMEIssuerDNS01ProviderCloudflare)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(a.(*acmev1.ACMEIssuerDNS01ProviderCloudflare), b.(*acme.ACMEIssuerDNS01ProviderCloudflare), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderCloudflare)(nil), (*acmev1.ACMEIssuerDNS01ProviderCloudflare)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1_ACMEIssuerDNS01ProviderCloudflare(a.(*acme.ACMEIssuerDNS01ProviderCloudflare), b.(*acmev1.ACMEIssuerDNS01ProviderCloudflare), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderDigitalOcean)(nil), (*acme.ACMEIssuerDNS01ProviderDigitalOcean)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(a.(*acmev1.ACMEIssuerDNS01ProviderDigitalOcean), b.(*acme.ACMEIssuerDNS01ProviderDigitalOcean), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderDigitalOcean)(nil), (*acmev1.ACMEIssuerDNS01ProviderDigitalOcean)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1_ACMEIssuerDNS01ProviderDigitalOcean(a.(*acme.ACMEIssuerDNS01ProviderDigitalOcean), b.(*acmev1.ACMEIssuerDNS01ProviderDigitalOcean), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderRFC2136)(nil), (*acme.ACMEIssuerDNS01ProviderRFC2136)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(a.(*acmev1.ACMEIssuerDNS01ProviderRFC2136), b.(*acme.ACMEIssuerDNS01ProviderRFC2136), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderRFC2136)(nil), (*acmev1.ACMEIssuerDNS01ProviderRFC2136)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1_ACMEIssuerDNS01ProviderRFC2136(a.(*acme.ACMEIssuerDNS01ProviderRFC2136), b.(*acmev1.ACMEIssuerDNS01ProviderRFC2136), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderRoute53)(nil), (*acme.ACMEIssuerDNS01ProviderRoute53)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(a.(*acmev1.ACMEIssuerDNS01ProviderRoute53), b.(*acme.ACMEIssuerDNS01ProviderRoute53), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderRoute53)(nil), (*acmev1.ACMEIssuerDNS01ProviderRoute53)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1_ACMEIssuerDNS01ProviderRoute53(a.(*acme.ACMEIssuerDNS01ProviderRoute53), b.(*acmev1.ACMEIssuerDNS01ProviderRoute53), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerDNS01ProviderWebhook)(nil), (*acme.ACMEIssuerDNS01ProviderWebhook)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook(a.(*acmev1.ACMEIssuerDNS01ProviderWebhook), b.(*acme.ACMEIssuerDNS01ProviderWebhook), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderWebhook)(nil), (*acmev1.ACMEIssuerDNS01ProviderWebhook)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1_ACMEIssuerDNS01ProviderWebhook(a.(*acme.ACMEIssuerDNS01ProviderWebhook), b.(*acmev1.ACMEIssuerDNS01ProviderWebhook), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ACMEIssuerStatus)(nil), (*acme.ACMEIssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuerStatus_To_acme_ACMEIssuerStatus(a.(*acmev1.ACMEIssuerStatus), b.(*acme.ACMEIssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerStatus)(nil), (*acmev1.ACMEIssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerStatus_To_v1_ACMEIssuerStatus(a.(*acme.ACMEIssuerStatus), b.(*acmev1.ACMEIssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.AzureManagedIdentity)(nil), (*acme.AzureManagedIdentity)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_AzureManagedIdentity_To_acme_AzureManagedIdentity(a.(*acmev1.AzureManagedIdentity), b.(*acme.AzureManagedIdentity), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.AzureManagedIdentity)(nil), (*acmev1.AzureManagedIdentity)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_AzureManagedIdentity_To_v1_AzureManagedIdentity(a.(*acme.AzureManagedIdentity), b.(*acmev1.AzureManagedIdentity), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.CertificateDNSNameSelector)(nil), (*acme.CertificateDNSNameSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector(a.(*acmev1.CertificateDNSNameSelector), b.(*acme.CertificateDNSNameSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.CertificateDNSNameSelector)(nil), (*acmev1.CertificateDNSNameSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_CertificateDNSNameSelector_To_v1_CertificateDNSNameSelector(a.(*acme.CertificateDNSNameSelector), b.(*acmev1.CertificateDNSNameSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.Challenge)(nil), (*acme.Challenge)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Challenge_To_acme_Challenge(a.(*acmev1.Challenge), b.(*acme.Challenge), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.Challenge)(nil), (*acmev1.Challenge)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_Challenge_To_v1_Challenge(a.(*acme.Challenge), b.(*acmev1.Challenge), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ChallengeList)(nil), (*acme.ChallengeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ChallengeList_To_acme_ChallengeList(a.(*acmev1.ChallengeList), b.(*acme.ChallengeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ChallengeList)(nil), (*acmev1.ChallengeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ChallengeList_To_v1_ChallengeList(a.(*acme.ChallengeList), b.(*acmev1.ChallengeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ChallengeSpec)(nil), (*acme.ChallengeSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ChallengeSpec_To_acme_ChallengeSpec(a.(*acmev1.ChallengeSpec), b.(*acme.ChallengeSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ChallengeSpec)(nil), (*acmev1.ChallengeSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ChallengeSpec_To_v1_ChallengeSpec(a.(*acme.ChallengeSpec), b.(*acmev1.ChallengeSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ChallengeStatus)(nil), (*acme.ChallengeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ChallengeStatus_To_acme_ChallengeStatus(a.(*acmev1.ChallengeStatus), b.(*acme.ChallengeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ChallengeStatus)(nil), (*acmev1.ChallengeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ChallengeStatus_To_v1_ChallengeStatus(a.(*acme.ChallengeStatus), b.(*acmev1.ChallengeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.Order)(nil), (*acme.Order)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Order_To_acme_Order(a.(*acmev1.Order), b.(*acme.Order), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.Order)(nil), (*acmev1.Order)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_Order_To_v1_Order(a.(*acme.Order), b.(*acmev1.Order), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.OrderList)(nil), (*acme.OrderList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_OrderList_To_acme_OrderList(a.(*acmev1.OrderList), b.(*acme.OrderList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.OrderList)(nil), (*acmev1.OrderList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_OrderList_To_v1_OrderList(a.(*acme.OrderList), b.(*acmev1.OrderList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.OrderSpec)(nil), (*acme.OrderSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_OrderSpec_To_acme_OrderSpec(a.(*acmev1.OrderSpec), b.(*acme.OrderSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.OrderSpec)(nil), (*acmev1.OrderSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_OrderSpec_To_v1_OrderSpec(a.(*acme.OrderSpec), b.(*acmev1.OrderSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.OrderStatus)(nil), (*acme.OrderStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_OrderStatus_To_acme_OrderStatus(a.(*acmev1.OrderStatus), b.(*acme.OrderStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.OrderStatus)(nil), (*acmev1.OrderStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_OrderStatus_To_v1_OrderStatus(a.(*acme.OrderStatus), b.(*acmev1.OrderStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.Route53Auth)(nil), (*acme.Route53Auth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Route53Auth_To_acme_Route53Auth(a.(*acmev1.Route53Auth), b.(*acme.Route53Auth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.Route53Auth)(nil), (*acmev1.Route53Auth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_Route53Auth_To_v1_Route53Auth(a.(*acme.Route53Auth), b.(*acmev1.Route53Auth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.Route53KubernetesAuth)(nil), (*acme.Route53KubernetesAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Route53KubernetesAuth_To_acme_Route53KubernetesAuth(a.(*acmev1.Route53KubernetesAuth), b.(*acme.Route53KubernetesAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.Route53KubernetesAuth)(nil), (*acmev1.Route53KubernetesAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_Route53KubernetesAuth_To_v1_Route53KubernetesAuth(a.(*acme.Route53KubernetesAuth), b.(*acmev1.Route53KubernetesAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acmev1.ServiceAccountRef)(nil), (*acme.ServiceAccountRef)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ServiceAccountRef_To_acme_ServiceAccountRef(a.(*acmev1.ServiceAccountRef), b.(*acme.ServiceAccountRef), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ServiceAccountRef)(nil), (*acmev1.ServiceAccountRef)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ServiceAccountRef_To_v1_ServiceAccountRef(a.(*acme.ServiceAccountRef), b.(*acmev1.ServiceAccountRef), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*acme.ACMEIssuer)(nil), (*acmev1.ACMEIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuer_To_v1_ACMEIssuer(a.(*acme.ACMEIssuer), b.(*acmev1.ACMEIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*acmev1.ACMEIssuer)(nil), (*acme.ACMEIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ACMEIssuer_To_acme_ACMEIssuer(a.(*acmev1.ACMEIssuer), b.(*acme.ACMEIssuer), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_ACMEAuthorization_To_acme_ACMEAuthorization(in *acmev1.ACMEAuthorization, out *acme.ACMEAuthorization, s conversion.Scope) error {
	out.URL = in.URL
	out.Identifier = in.Identifier
	out.Wildcard = (*bool)(unsafe.Pointer(in.Wildcard))
	out.InitialState = acme.State(in.InitialState)
	out.Challenges = *(*[]acme.ACMEChallenge)(unsafe.Pointer(&in.Challenges))
	return nil
}

// Convert_v1_ACMEAuthorization_To_acme_ACMEAuthorization is an autogenerated conversion function.
func Convert_v1_ACMEAuthorization_To_acme_ACMEAuthorization(in *acmev1.ACMEAuthorization, out *acme.ACMEAuthorization, s conversion.Scope) error {
	return autoConvert_v1_ACMEAuthorization_To_acme_ACMEAuthorization(in, out, s)
}

func autoConvert_acme_ACMEAuthorization_To_v1_ACMEAuthorization(in *acme.ACMEAuthorization, out *acmev1.ACMEAuthorization, s conversion.Scope) error {
	out.URL = in.URL
	out.Identifier = in.Identifier
	out.Wildcard = (*bool)(unsafe.Pointer(in.Wildcard))
	out.InitialState = acmev1.State(in.InitialState)
	out.Challenges = *(*[]acmev1.ACMEChallenge)(unsafe.Pointer(&in.Challenges))
	return nil
}

// Convert_acme_ACMEAuthorization_To_v1_ACMEAuthorization is an autogenerated conversion function.
func Convert_acme_ACMEAuthorization_To_v1_ACMEAuthorization(in *acme.ACMEAuthorization, out *acmev1.ACMEAuthorization, s conversion.Scope) error {
	return autoConvert_acme_ACMEAuthorization_To_v1_ACMEAuthorization(in, out, s)
}

func autoConvert_v1_ACMEChallenge_To_acme_ACMEChallenge(in *acmev1.ACMEChallenge, out *acme.ACMEChallenge, s conversion.Scope) error {
	out.URL = in.URL
	out.Token = in.Token
	out.Type = in.Type
	return nil
}

// Convert_v1_ACMEChallenge_To_acme_ACMEChallenge is an autogenerated conversion function.
func Convert_v1_ACMEChallenge_To_acme_ACMEChallenge(in *acmev1.ACMEChallenge, out *acme.ACMEChallenge, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallenge_To_acme_ACMEChallenge(in, out, s)
}

func autoConvert_acme_ACMEChallenge_To_v1_ACMEChallenge(in *acme.ACMEChallenge, out *acmev1.ACMEChallenge, s conversion.Scope) error {
	out.URL = in.URL
	out.Token = in.Token
	out.Type = in.Type
	return nil
}

// Convert_acme_ACMEChallenge_To_v1_ACMEChallenge is an autogenerated conversion function.
func Convert_acme_ACMEChallenge_To_v1_ACMEChallenge(in *acme.ACMEChallenge, out *acmev1.ACMEChallenge, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallenge_To_v1_ACMEChallenge(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(in *acmev1.ACMEChallengeSolver, out *acme.ACMEChallengeSolver, s conversion.Scope) error {
	out.Selector = (*acme.CertificateDNSNameSelector)(unsafe.Pointer(in.Selector))
	out.HTTP01 = (*acme.ACMEChallengeSolverHTTP01)(unsafe.Pointer(in.HTTP01))
	if in.DNS01 != nil {
		in, out := &in.DNS01, &out.DNS01
		*out = new(acme.ACMEChallengeSolverDNS01)
		if err := Convert_v1_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DNS01 = nil
	}
	return nil
}

// Convert_v1_ACMEChallengeSolver_To_acme_ACMEChallengeSolver is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(in *acmev1.ACMEChallengeSolver, out *acme.ACMEChallengeSolver, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolver_To_v1_ACMEChallengeSolver(in *acme.ACMEChallengeSolver, out *acmev1.ACMEChallengeSolver, s conversion.Scope) error {
	out.Selector = (*acmev1.CertificateDNSNameSelector)(unsafe.Pointer(in.Selector))
	out.HTTP01 = (*acmev1.ACMEChallengeSolverHTTP01)(unsafe.Pointer(in.HTTP01))
	if in.DNS01 != nil {
		in, out := &in.DNS01, &out.DNS01
		*out = new(acmev1.ACMEChallengeSolverDNS01)
		if err := Convert_acme_ACMEChallengeSolverDNS01_To_v1_ACMEChallengeSolverDNS01(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DNS01 = nil
	}
	return nil
}

// Convert_acme_ACMEChallengeSolver_To_v1_ACMEChallengeSolver is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolver_To_v1_ACMEChallengeSolver(in *acme.ACMEChallengeSolver, out *acmev1.ACMEChallengeSolver, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolver_To_v1_ACMEChallengeSolver(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(in *acmev1.ACMEChallengeSolverDNS01, out *acme.ACMEChallengeSolverDNS01, s conversion.Scope) error {
	out.CNAMEStrategy = acme.CNAMEStrategy(in.CNAMEStrategy)
	if in.Akamai != nil {
		in, out := &in.Akamai, &out.Akamai
		*out = new(acme.ACMEIssuerDNS01ProviderAkamai)
		if err := Convert_v1_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Akamai = nil
	}
	if in.CloudDNS != nil {
		in, out := &in.CloudDNS, &out.CloudDNS
		*out = new(acme.ACMEIssuerDNS01ProviderCloudDNS)
		if err := Convert_v1_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CloudDNS = nil
	}
	if in.Cloudflare != nil {
		in, out := &in.Cloudflare, &out.Cloudflare
		*out = new(acme.ACMEIssuerDNS01ProviderCloudflare)
		if err := Convert_v1_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Cloudflare = nil
	}
	if in.Route53 != nil {
		in, out := &in.Route53, &out.Route53
		*out = new(acme.ACMEIssuerDNS01ProviderRoute53)
		if err := Convert_v1_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Route53 = nil
	}
	if in.AzureDNS != nil {
		in, out := &in.AzureDNS, &out.AzureDNS
		*out = new(acme.ACMEIssuerDNS01ProviderAzureDNS)
		if err := Convert_v1_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AzureDNS = nil
	}
	if in.DigitalOcean != nil {
		in, out := &in.DigitalOcean, &out.DigitalOcean
		*out = new(acme.ACMEIssuerDNS01ProviderDigitalOcean)
		if err := Convert_v1_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DigitalOcean = nil
	}
	if in.AcmeDNS != nil {
		in, out := &in.AcmeDNS, &out.AcmeDNS
		*out = new(acme.ACMEIssuerDNS01ProviderAcmeDNS)
		if err := Convert_v1_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AcmeDNS = nil
	}
	if in.RFC2136 != nil {
		in, out := &in.RFC2136, &out.RFC2136
		*out = new(acme.ACMEIssuerDNS01ProviderRFC2136)
		if err := Convert_v1_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RFC2136 = nil
	}
	out.Webhook = (*acme.ACMEIssuerDNS01ProviderWebhook)(unsafe.Pointer(in.Webhook))
	return nil
}

// Convert_v1_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01 is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(in *acmev1.ACMEChallengeSolverDNS01, out *acme.ACMEChallengeSolverDNS01, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverDNS01_To_v1_ACMEChallengeSolverDNS01(in *acme.ACMEChallengeSolverDNS01, out *acmev1.ACMEChallengeSolverDNS01, s conversion.Scope) error {
	out.CNAMEStrategy = acmev1.CNAMEStrategy(in.CNAMEStrategy)
	if in.Akamai != nil {
		in, out := &in.Akamai, &out.Akamai
		*out = new(acmev1.ACMEIssuerDNS01ProviderAkamai)
		if err := Convert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1_ACMEIssuerDNS01ProviderAkamai(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Akamai = nil
	}
	if in.CloudDNS != nil {
		in, out := &in.CloudDNS, &out.CloudDNS
		*out = new(acmev1.ACMEIssuerDNS01ProviderCloudDNS)
		if err := Convert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1_ACMEIssuerDNS01ProviderCloudDNS(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CloudDNS = nil
	}
	if in.Cloudflare != nil {
		in, out := &in.Cloudflare, &out.Cloudflare
		*out = new(acmev1.ACMEIssuerDNS01ProviderCloudflare)
		if err := Convert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1_ACMEIssuerDNS01ProviderCloudflare(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Cloudflare = nil
	}
	if in.Route53 != nil {
		in, out := &in.Route53, &out.Route53
		*out = new(acmev1.ACMEIssuerDNS01ProviderRoute53)
		if err := Convert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1_ACMEIssuerDNS01ProviderRoute53(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Route53 = nil
	}
	if in.AzureDNS != nil {
		in, out := &in.AzureDNS, &out.AzureDNS
		*out = new(acmev1.ACMEIssuerDNS01ProviderAzureDNS)
		if err := Convert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1_ACMEIssuerDNS01ProviderAzureDNS(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AzureDNS = nil
	}
	if in.DigitalOcean != nil {
		in, out := &in.DigitalOcean, &out.DigitalOcean
		*out = new(acmev1.ACMEIssuerDNS01ProviderDigitalOcean)
		if err := Convert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1_ACMEIssuerDNS01ProviderDigitalOcean(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DigitalOcean = nil
	}
	if in.AcmeDNS != nil {
		in, out := &in.AcmeDNS, &out.AcmeDNS
		*out = new(acmev1.ACMEIssuerDNS01ProviderAcmeDNS)
		if err := Convert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1_ACMEIssuerDNS01ProviderAcmeDNS(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AcmeDNS = nil
	}
	if in.RFC2136 != nil {
		in, out := &in.RFC2136, &out.RFC2136
		*out = new(acmev1.ACMEIssuerDNS01ProviderRFC2136)
		if err := Convert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1_ACMEIssuerDNS01ProviderRFC2136(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RFC2136 = nil
	}
	out.Webhook = (*acmev1.ACMEIssuerDNS01ProviderWebhook)(unsafe.Pointer(in.Webhook))
	return nil
}

// Convert_acme_ACMEChallengeSolverDNS01_To_v1_ACMEChallengeSolverDNS01 is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverDNS01_To_v1_ACMEChallengeSolverDNS01(in *acme.ACMEChallengeSolverDNS01, out *acmev1.ACMEChallengeSolverDNS01, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverDNS01_To_v1_ACMEChallengeSolverDNS01(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01(in *acmev1.ACMEChallengeSolverHTTP01, out *acme.ACMEChallengeSolverHTTP01, s conversion.Scope) error {
	out.Ingress = (*acme.ACMEChallengeSolverHTTP01Ingress)(unsafe.Pointer(in.Ingress))
	out.GatewayHTTPRoute = (*acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute)(unsafe.Pointer(in.GatewayHTTPRoute))
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01 is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01(in *acmev1.ACMEChallengeSolverHTTP01, out *acme.ACMEChallengeSolverHTTP01, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01_To_v1_ACMEChallengeSolverHTTP01(in *acme.ACMEChallengeSolverHTTP01, out *acmev1.ACMEChallengeSolverHTTP01, s conversion.Scope) error {
	out.Ingress = (*acmev1.ACMEChallengeSolverHTTP01Ingress)(unsafe.Pointer(in.Ingress))
	out.GatewayHTTPRoute = (*acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute)(unsafe.Pointer(in.GatewayHTTPRoute))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01_To_v1_ACMEChallengeSolverHTTP01 is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01_To_v1_ACMEChallengeSolverHTTP01(in *acme.ACMEChallengeSolverHTTP01, out *acmev1.ACMEChallengeSolverHTTP01, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01_To_v1_ACMEChallengeSolverHTTP01(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute(in *acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute, out *acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute, s conversion.Scope) error {
	out.ServiceType = corev1.ServiceType(in.ServiceType)
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.ParentRefs = *(*[]apisv1.ParentReference)(unsafe.Pointer(&in.ParentRefs))
	out.PodTemplate = (*acme.ACMEChallengeSolverHTTP01IngressPodTemplate)(unsafe.Pointer(in.PodTemplate))
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute(in *acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute, out *acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute(in *acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute, out *acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute, s conversion.Scope) error {
	out.ServiceType = corev1.ServiceType(in.ServiceType)
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.ParentRefs = *(*[]apisv1.ParentReference)(unsafe.Pointer(&in.ParentRefs))
	out.PodTemplate = (*acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate)(unsafe.Pointer(in.PodTemplate))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute(in *acme.ACMEChallengeSolverHTTP01GatewayHTTPRoute, out *acmev1.ACMEChallengeSolverHTTP01GatewayHTTPRoute, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01GatewayHTTPRoute_To_v1_ACMEChallengeSolverHTTP01GatewayHTTPRoute(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress(in *acmev1.ACMEChallengeSolverHTTP01Ingress, out *acme.ACMEChallengeSolverHTTP01Ingress, s conversion.Scope) error {
	out.ServiceType = corev1.ServiceType(in.ServiceType)
	out.IngressClassName = (*string)(unsafe.Pointer(in.IngressClassName))
	out.Class = (*string)(unsafe.Pointer(in.Class))
	out.Name = in.Name
	out.PodTemplate = (*acme.ACMEChallengeSolverHTTP01IngressPodTemplate)(unsafe.Pointer(in.PodTemplate))
	out.IngressTemplate = (*acme.ACMEChallengeSolverHTTP01IngressTemplate)(unsafe.Pointer(in.IngressTemplate))
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress(in *acmev1.ACMEChallengeSolverHTTP01Ingress, out *acme.ACMEChallengeSolverHTTP01Ingress, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1_ACMEChallengeSolverHTTP01Ingress(in *acme.ACMEChallengeSolverHTTP01Ingress, out *acmev1.ACMEChallengeSolverHTTP01Ingress, s conversion.Scope) error {
	out.ServiceType = corev1.ServiceType(in.ServiceType)
	out.IngressClassName = (*string)(unsafe.Pointer(in.IngressClassName))
	out.Class = (*string)(unsafe.Pointer(in.Class))
	out.Name = in.Name
	out.PodTemplate = (*acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate)(unsafe.Pointer(in.PodTemplate))
	out.IngressTemplate = (*acmev1.ACMEChallengeSolverHTTP01IngressTemplate)(unsafe.Pointer(in.IngressTemplate))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1_ACMEChallengeSolverHTTP01Ingress is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1_ACMEChallengeSolverHTTP01Ingress(in *acme.ACMEChallengeSolverHTTP01Ingress, out *acmev1.ACMEChallengeSolverHTTP01Ingress, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1_ACMEChallengeSolverHTTP01Ingress(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(in *acmev1.ACMEChallengeSolverHTTP01IngressObjectMeta, out *acme.ACMEChallengeSolverHTTP01IngressObjectMeta, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(in *acmev1.ACMEChallengeSolverHTTP01IngressObjectMeta, out *acme.ACMEChallengeSolverHTTP01IngressObjectMeta, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressObjectMeta(in *acme.ACMEChallengeSolverHTTP01IngressObjectMeta, out *acmev1.ACMEChallengeSolverHTTP01IngressObjectMeta, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressObjectMeta is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressObjectMeta(in *acme.ACMEChallengeSolverHTTP01IngressObjectMeta, out *acmev1.ACMEChallengeSolverHTTP01IngressObjectMeta, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressObjectMeta(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in *acmev1.ACMEChallengeSolverHTTP01IngressPodObjectMeta, out *acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in *acmev1.ACMEChallengeSolverHTTP01IngressPodObjectMeta, out *acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in *acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta, out *acmev1.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in *acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta, out *acmev1.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodResources_To_acme_ACMEChallengeSolverHTTP01IngressPodResources(in *acmev1.ACMEChallengeSolverHTTP01IngressPodResources, out *acme.ACMEChallengeSolverHTTP01IngressPodResources, s conversion.Scope) error {
	out.Limits = *(*corev1.ResourceList)(unsafe.Pointer(&in.Limits))
	out.Requests = *(*corev1.ResourceList)(unsafe.Pointer(&in.Requests))
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01IngressPodResources_To_acme_ACMEChallengeSolverHTTP01IngressPodResources is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01IngressPodResources_To_acme_ACMEChallengeSolverHTTP01IngressPodResources(in *acmev1.ACMEChallengeSolverHTTP01IngressPodResources, out *acme.ACMEChallengeSolverHTTP01IngressPodResources, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodResources_To_acme_ACMEChallengeSolverHTTP01IngressPodResources(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodResources_To_v1_ACMEChallengeSolverHTTP01IngressPodResources(in *acme.ACMEChallengeSolverHTTP01IngressPodResources, out *acmev1.ACMEChallengeSolverHTTP01IngressPodResources, s conversion.Scope) error {
	out.Limits = *(*corev1.ResourceList)(unsafe.Pointer(&in.Limits))
	out.Requests = *(*corev1.ResourceList)(unsafe.Pointer(&in.Requests))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressPodResources_To_v1_ACMEChallengeSolverHTTP01IngressPodResources is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressPodResources_To_v1_ACMEChallengeSolverHTTP01IngressPodResources(in *acme.ACMEChallengeSolverHTTP01IngressPodResources, out *acmev1.ACMEChallengeSolverHTTP01IngressPodResources, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodResources_To_v1_ACMEChallengeSolverHTTP01IngressPodResources(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext(in *acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext, out *acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext, s conversion.Scope) error {
	out.SELinuxOptions = (*corev1.SELinuxOptions)(unsafe.Pointer(in.SELinuxOptions))
	out.RunAsUser = (*int64)(unsafe.Pointer(in.RunAsUser))
	out.RunAsGroup = (*int64)(unsafe.Pointer(in.RunAsGroup))
	out.RunAsNonRoot = (*bool)(unsafe.Pointer(in.RunAsNonRoot))
	out.SupplementalGroups = *(*[]int64)(unsafe.Pointer(&in.SupplementalGroups))
	out.FSGroup = (*int64)(unsafe.Pointer(in.FSGroup))
	out.Sysctls = *(*[]corev1.Sysctl)(unsafe.Pointer(&in.Sysctls))
	out.FSGroupChangePolicy = (*corev1.PodFSGroupChangePolicy)(unsafe.Pointer(in.FSGroupChangePolicy))
	out.SeccompProfile = (*corev1.SeccompProfile)(unsafe.Pointer(in.SeccompProfile))
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext(in *acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext, out *acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext(in *acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext, out *acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext, s conversion.Scope) error {
	out.SELinuxOptions = (*corev1.SELinuxOptions)(unsafe.Pointer(in.SELinuxOptions))
	out.RunAsUser = (*int64)(unsafe.Pointer(in.RunAsUser))
	out.RunAsGroup = (*int64)(unsafe.Pointer(in.RunAsGroup))
	out.RunAsNonRoot = (*bool)(unsafe.Pointer(in.RunAsNonRoot))
	out.SupplementalGroups = *(*[]int64)(unsafe.Pointer(&in.SupplementalGroups))
	out.FSGroup = (*int64)(unsafe.Pointer(in.FSGroup))
	out.Sysctls = *(*[]corev1.Sysctl)(unsafe.Pointer(&in.Sysctls))
	out.FSGroupChangePolicy = (*corev1.PodFSGroupChangePolicy)(unsafe.Pointer(in.FSGroupChangePolicy))
	out.SeccompProfile = (*corev1.SeccompProfile)(unsafe.Pointer(in.SeccompProfile))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext(in *acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext, out *acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodSecurityContext_To_v1_ACMEChallengeSolverHTTP01IngressPodSecurityContext(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(in *acmev1.ACMEChallengeSolverHTTP01IngressPodSpec, out *acme.ACMEChallengeSolverHTTP01IngressPodSpec, s conversion.Scope) error {
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	out.Affinity = (*corev1.Affinity)(unsafe.Pointer(in.Affinity))
	out.Tolerations = *(*[]corev1.Toleration)(unsafe.Pointer(&in.Tolerations))
	out.PriorityClassName = in.PriorityClassName
	out.ServiceAccountName = in.ServiceAccountName
	out.ImagePullSecrets = *(*[]corev1.LocalObjectReference)(unsafe.Pointer(&in.ImagePullSecrets))
	out.SecurityContext = (*acme.ACMEChallengeSolverHTTP01IngressPodSecurityContext)(unsafe.Pointer(in.SecurityContext))
	out.Resources = (*acme.ACMEChallengeSolverHTTP01IngressPodResources)(unsafe.Pointer(in.Resources))
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(in *acmev1.ACMEChallengeSolverHTTP01IngressPodSpec, out *acme.ACMEChallengeSolverHTTP01IngressPodSpec, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1_ACMEChallengeSolverHTTP01IngressPodSpec(in *acme.ACMEChallengeSolverHTTP01IngressPodSpec, out *acmev1.ACMEChallengeSolverHTTP01IngressPodSpec, s conversion.Scope) error {
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	out.Affinity = (*corev1.Affinity)(unsafe.Pointer(in.Affinity))
	out.Tolerations = *(*[]corev1.Toleration)(unsafe.Pointer(&in.Tolerations))
	out.PriorityClassName = in.PriorityClassName
	out.ServiceAccountName = in.ServiceAccountName
	out.ImagePullSecrets = *(*[]corev1.LocalObjectReference)(unsafe.Pointer(&in.ImagePullSecrets))
	out.SecurityContext = (*acmev1.ACMEChallengeSolverHTTP01IngressPodSecurityContext)(unsafe.Pointer(in.SecurityContext))
	out.Resources = (*acmev1.ACMEChallengeSolverHTTP01IngressPodResources)(unsafe.Pointer(in.Resources))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1_ACMEChallengeSolverHTTP01IngressPodSpec is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1_ACMEChallengeSolverHTTP01IngressPodSpec(in *acme.ACMEChallengeSolverHTTP01IngressPodSpec, out *acmev1.ACMEChallengeSolverHTTP01IngressPodSpec, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1_ACMEChallengeSolverHTTP01IngressPodSpec(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate(in *acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate, out *acme.ACMEChallengeSolverHTTP01IngressPodTemplate, s conversion.Scope) error {
	if err := Convert_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(&in.ACMEChallengeSolverHTTP01IngressPodObjectMeta, &out.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate(in *acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate, out *acme.ACMEChallengeSolverHTTP01IngressPodTemplate, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1_ACMEChallengeSolverHTTP01IngressPodTemplate(in *acme.ACMEChallengeSolverHTTP01IngressPodTemplate, out *acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate, s conversion.Scope) error {
	if err := Convert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressPodObjectMeta(&in.ACMEChallengeSolverHTTP01IngressPodObjectMeta, &out.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1_ACMEChallengeSolverHTTP01IngressPodSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1_ACMEChallengeSolverHTTP01IngressPodTemplate is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1_ACMEChallengeSolverHTTP01IngressPodTemplate(in *acme.ACMEChallengeSolverHTTP01IngressPodTemplate, out *acmev1.ACMEChallengeSolverHTTP01IngressPodTemplate, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1_ACMEChallengeSolverHTTP01IngressPodTemplate(in, out, s)
}

func autoConvert_v1_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate(in *acmev1.ACMEChallengeSolverHTTP01IngressTemplate, out *acme.ACMEChallengeSolverHTTP01IngressTemplate, s conversion.Scope) error {
	if err := Convert_v1_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(&in.ACMEChallengeSolverHTTP01IngressObjectMeta, &out.ACMEChallengeSolverHTTP01IngressObjectMeta, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate is an autogenerated conversion function.
func Convert_v1_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate(in *acmev1.ACMEChallengeSolverHTTP01IngressTemplate, out *acme.ACMEChallengeSolverHTTP01IngressTemplate, s conversion.Scope) error {
	return autoConvert_v1_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1_ACMEChallengeSolverHTTP01IngressTemplate(in *acme.ACMEChallengeSolverHTTP01IngressTemplate, out *acmev1.ACMEChallengeSolverHTTP01IngressTemplate, s conversion.Scope) error {
	if err := Convert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1_ACMEChallengeSolverHTTP01IngressObjectMeta(&in.ACMEChallengeSolverHTTP01IngressObjectMeta, &out.ACMEChallengeSolverHTTP01IngressObjectMeta, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1_ACMEChallengeSolverHTTP01IngressTemplate is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1_ACMEChallengeSolverHTTP01IngressTemplate(in *acme.ACMEChallengeSolverHTTP01IngressTemplate, out *acmev1.ACMEChallengeSolverHTTP01IngressTemplate, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1_ACMEChallengeSolverHTTP01IngressTemplate(in, out, s)
}

func autoConvert_v1_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(in *acmev1.ACMEExternalAccountBinding, out *acme.ACMEExternalAccountBinding, s conversion.Scope) error {
	out.KeyID = in.KeyID
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.Key, &out.Key, s); err != nil {
		return err
	}
	out.KeyAlgorithm = acme.HMACKeyAlgorithm(in.KeyAlgorithm)
	return nil
}

// Convert_v1_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding is an autogenerated conversion function.
func Convert_v1_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(in *acmev1.ACMEExternalAccountBinding, out *acme.ACMEExternalAccountBinding, s conversion.Scope) error {
	return autoConvert_v1_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(in, out, s)
}

func autoConvert_acme_ACMEExternalAccountBinding_To_v1_ACMEExternalAccountBinding(in *acme.ACMEExternalAccountBinding, out *acmev1.ACMEExternalAccountBinding, s conversion.Scope) error {
	out.KeyID = in.KeyID
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.Key, &out.Key, s); err != nil {
		return err
	}
	out.KeyAlgorithm = acmev1.HMACKeyAlgorithm(in.KeyAlgorithm)
	return nil
}

// Convert_acme_ACMEExternalAccountBinding_To_v1_ACMEExternalAccountBinding is an autogenerated conversion function.
func Convert_acme_ACMEExternalAccountBinding_To_v1_ACMEExternalAccountBinding(in *acme.ACMEExternalAccountBinding, out *acmev1.ACMEExternalAccountBinding, s conversion.Scope) error {
	return autoConvert_acme_ACMEExternalAccountBinding_To_v1_ACMEExternalAccountBinding(in, out, s)
}

func autoConvert_v1_ACMEIssuer_To_acme_ACMEIssuer(in *acmev1.ACMEIssuer, out *acme.ACMEIssuer, s conversion.Scope) error {
	out.Email = in.Email
	out.Server = in.Server
	out.PreferredChain = in.PreferredChain
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	out.SkipTLSVerify = in.SkipTLSVerify
	if in.ExternalAccountBinding != nil {
		in, out := &in.ExternalAccountBinding, &out.ExternalAccountBinding
		*out = new(acme.ACMEExternalAccountBinding)
		if err := Convert_v1_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExternalAccountBinding = nil
	}
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.PrivateKey, &out.PrivateKey, s); err != nil {
		return err
	}
	if in.Solvers != nil {
		in, out := &in.Solvers, &out.Solvers
		*out = make([]acme.ACMEChallengeSolver, len(*in))
		for i := range *in {
			if err := Convert_v1_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Solvers = nil
	}
	out.DisableAccountKeyGeneration = in.DisableAccountKeyGeneration
	out.EnableDurationFeature = in.EnableDurationFeature
	out.Profile = in.Profile
	return nil
}

func autoConvert_acme_ACMEIssuer_To_v1_ACMEIssuer(in *acme.ACMEIssuer, out *acmev1.ACMEIssuer, s conversion.Scope) error {
	out.Email = in.Email
	out.Server = in.Server
	out.PreferredChain = in.PreferredChain
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	out.SkipTLSVerify = in.SkipTLSVerify
	if in.ExternalAccountBinding != nil {
		in, out := &in.ExternalAccountBinding, &out.ExternalAccountBinding
		*out = new(acmev1.ACMEExternalAccountBinding)
		if err := Convert_acme_ACMEExternalAccountBinding_To_v1_ACMEExternalAccountBinding(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExternalAccountBinding = nil
	}
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.PrivateKey, &out.PrivateKey, s); err != nil {
		return err
	}
	if in.Solvers != nil {
		in, out := &in.Solvers, &out.Solvers
		*out = make([]acmev1.ACMEChallengeSolver, len(*in))
		for i := range *in {
			if err := Convert_acme_ACMEChallengeSolver_To_v1_ACMEChallengeSolver(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Solvers = nil
	}
	out.DisableAccountKeyGeneration = in.DisableAccountKeyGeneration
	out.EnableDurationFeature = in.EnableDurationFeature
	out.Profile = in.Profile
	return nil
}

func autoConvert_v1_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(in *acmev1.ACMEIssuerDNS01ProviderAcmeDNS, out *acme.ACMEIssuerDNS01ProviderAcmeDNS, s conversion.Scope) error {
	out.Host = in.Host
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.AccountSecret, &out.AccountSecret, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(in *acmev1.ACMEIssuerDNS01ProviderAcmeDNS, out *acme.ACMEIssuerDNS01ProviderAcmeDNS, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1_ACMEIssuerDNS01ProviderAcmeDNS(in *acme.ACMEIssuerDNS01ProviderAcmeDNS, out *acmev1.ACMEIssuerDNS01ProviderAcmeDNS, s conversion.Scope) error {
	out.Host = in.Host
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.AccountSecret, &out.AccountSecret, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1_ACMEIssuerDNS01ProviderAcmeDNS is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1_ACMEIssuerDNS01ProviderAcmeDNS(in *acme.ACMEIssuerDNS01ProviderAcmeDNS, out *acmev1.ACMEIssuerDNS01ProviderAcmeDNS, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1_ACMEIssuerDNS01ProviderAcmeDNS(in, out, s)
}

func autoConvert_v1_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(in *acmev1.ACMEIssuerDNS01ProviderAkamai, out *acme.ACMEIssuerDNS01ProviderAkamai, s conversion.Scope) error {
	out.ServiceConsumerDomain = in.ServiceConsumerDomain
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.ClientToken, &out.ClientToken, s); err != nil {
		return err
	}
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.ClientSecret, &out.ClientSecret, s); err != nil {
		return err
	}
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.AccessToken, &out.AccessToken, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(in *acmev1.ACMEIssuerDNS01ProviderAkamai, out *acme.ACMEIssuerDNS01ProviderAkamai, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1_ACMEIssuerDNS01ProviderAkamai(in *acme.ACMEIssuerDNS01ProviderAkamai, out *acmev1.ACMEIssuerDNS01ProviderAkamai, s conversion.Scope) error {
	out.ServiceConsumerDomain = in.ServiceConsumerDomain
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.ClientToken, &out.ClientToken, s); err != nil {
		return err
	}
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.ClientSecret, &out.ClientSecret, s); err != nil {
		return err
	}
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.AccessToken, &out.AccessToken, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1_ACMEIssuerDNS01ProviderAkamai is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1_ACMEIssuerDNS01ProviderAkamai(in *acme.ACMEIssuerDNS01ProviderAkamai, out *acmev1.ACMEIssuerDNS01ProviderAkamai, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1_ACMEIssuerDNS01ProviderAkamai(in, out, s)
}

func autoConvert_v1_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(in *acmev1.ACMEIssuerDNS01ProviderAzureDNS, out *acme.ACMEIssuerDNS01ProviderAzureDNS, s conversion.Scope) error {
	out.ClientID = in.ClientID
	if in.ClientSecret != nil {
		in, out := &in.ClientSecret, &out.ClientSecret
		*out = new(meta.SecretKeySelector)
		if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientSecret = nil
	}
	out.SubscriptionID = in.SubscriptionID
	out.TenantID = in.TenantID
	out.ResourceGroupName = in.ResourceGroupName
	out.HostedZoneName = in.HostedZoneName
	out.Environment = acme.AzureDNSEnvironment(in.Environment)
	out.ManagedIdentity = (*acme.AzureManagedIdentity)(unsafe.Pointer(in.ManagedIdentity))
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(in *acmev1.ACMEIssuerDNS01ProviderAzureDNS, out *acme.ACMEIssuerDNS01ProviderAzureDNS, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1_ACMEIssuerDNS01ProviderAzureDNS(in *acme.ACMEIssuerDNS01ProviderAzureDNS, out *acmev1.ACMEIssuerDNS01ProviderAzureDNS, s conversion.Scope) error {
	out.ClientID = in.ClientID
	if in.ClientSecret != nil {
		in, out := &in.ClientSecret, &out.ClientSecret
		*out = new(apismetav1.SecretKeySelector)
		if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientSecret = nil
	}
	out.SubscriptionID = in.SubscriptionID
	out.TenantID = in.TenantID
	out.ResourceGroupName = in.ResourceGroupName
	out.HostedZoneName = in.HostedZoneName
	out.Environment = acmev1.AzureDNSEnvironment(in.Environment)
	out.ManagedIdentity = (*acmev1.AzureManagedIdentity)(unsafe.Pointer(in.ManagedIdentity))
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1_ACMEIssuerDNS01ProviderAzureDNS is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1_ACMEIssuerDNS01ProviderAzureDNS(in *acme.ACMEIssuerDNS01ProviderAzureDNS, out *acmev1.ACMEIssuerDNS01ProviderAzureDNS, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1_ACMEIssuerDNS01ProviderAzureDNS(in, out, s)
}

func autoConvert_v1_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(in *acmev1.ACMEIssuerDNS01ProviderCloudDNS, out *acme.ACMEIssuerDNS01ProviderCloudDNS, s conversion.Scope) error {
	if in.ServiceAccount != nil {
		in, out := &in.ServiceAccount, &out.ServiceAccount
		*out = new(meta.SecretKeySelector)
		if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ServiceAccount = nil
	}
	out.Project = in.Project
	out.HostedZoneName = in.HostedZoneName
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(in *acmev1.ACMEIssuerDNS01ProviderCloudDNS, out *acme.ACMEIssuerDNS01ProviderCloudDNS, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1_ACMEIssuerDNS01ProviderCloudDNS(in *acme.ACMEIssuerDNS01ProviderCloudDNS, out *acmev1.ACMEIssuerDNS01ProviderCloudDNS, s conversion.Scope) error {
	if in.ServiceAccount != nil {
		in, out := &in.ServiceAccount, &out.ServiceAccount
		*out = new(apismetav1.SecretKeySelector)
		if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ServiceAccount = nil
	}
	out.Project = in.Project
	out.HostedZoneName = in.HostedZoneName
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1_ACMEIssuerDNS01ProviderCloudDNS is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1_ACMEIssuerDNS01ProviderCloudDNS(in *acme.ACMEIssuerDNS01ProviderCloudDNS, out *acmev1.ACMEIssuerDNS01ProviderCloudDNS, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1_ACMEIssuerDNS01ProviderCloudDNS(in, out, s)
}

func autoConvert_v1_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(in *acmev1.ACMEIssuerDNS01ProviderCloudflare, out *acme.ACMEIssuerDNS01ProviderCloudflare, s conversion.Scope) error {
	out.Email = in.Email
	if in.APIKey != nil {
		in, out := &in.APIKey, &out.APIKey
		*out = new(meta.SecretKeySelector)
		if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.APIKey = nil
	}
	if in.APIToken != nil {
		in, out := &in.APIToken, &out.APIToken
		*out = new(meta.SecretKeySelector)
		if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.APIToken = nil
	}
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(in *acmev1.ACMEIssuerDNS01ProviderCloudflare, out *acme.ACMEIssuerDNS01ProviderCloudflare, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1_ACMEIssuerDNS01ProviderCloudflare(in *acme.ACMEIssuerDNS01ProviderCloudflare, out *acmev1.ACMEIssuerDNS01ProviderCloudflare, s conversion.Scope) error {
	out.Email = in.Email
	if in.APIKey != nil {
		in, out := &in.APIKey, &out.APIKey
		*out = new(apismetav1.SecretKeySelector)
		if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.APIKey = nil
	}
	if in.APIToken != nil {
		in, out := &in.APIToken, &out.APIToken
		*out = new(apismetav1.SecretKeySelector)
		if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.APIToken = nil
	}
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1_ACMEIssuerDNS01ProviderCloudflare is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1_ACMEIssuerDNS01ProviderCloudflare(in *acme.ACMEIssuerDNS01ProviderCloudflare, out *acmev1.ACMEIssuerDNS01ProviderCloudflare, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1_ACMEIssuerDNS01ProviderCloudflare(in, out, s)
}

func autoConvert_v1_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(in *acmev1.ACMEIssuerDNS01ProviderDigitalOcean, out *acme.ACMEIssuerDNS01ProviderDigitalOcean, s conversion.Scope) error {
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.Token, &out.Token, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(in *acmev1.ACMEIssuerDNS01ProviderDigitalOcean, out *acme.ACMEIssuerDNS01ProviderDigitalOcean, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1_ACMEIssuerDNS01ProviderDigitalOcean(in *acme.ACMEIssuerDNS01ProviderDigitalOcean, out *acmev1.ACMEIssuerDNS01ProviderDigitalOcean, s conversion.Scope) error {
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.Token, &out.Token, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1_ACMEIssuerDNS01ProviderDigitalOcean is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1_ACMEIssuerDNS01ProviderDigitalOcean(in *acme.ACMEIssuerDNS01ProviderDigitalOcean, out *acmev1.ACMEIssuerDNS01ProviderDigitalOcean, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1_ACMEIssuerDNS01ProviderDigitalOcean(in, out, s)
}

func autoConvert_v1_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(in *acmev1.ACMEIssuerDNS01ProviderRFC2136, out *acme.ACMEIssuerDNS01ProviderRFC2136, s conversion.Scope) error {
	out.Nameserver = in.Nameserver
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.TSIGSecret, &out.TSIGSecret, s); err != nil {
		return err
	}
	out.TSIGKeyName = in.TSIGKeyName
	out.TSIGAlgorithm = in.TSIGAlgorithm
	out.Protocol = acme.RFC2136UpdateProtocol(in.Protocol)
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136 is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(in *acmev1.ACMEIssuerDNS01ProviderRFC2136, out *acme.ACMEIssuerDNS01ProviderRFC2136, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1_ACMEIssuerDNS01ProviderRFC2136(in *acme.ACMEIssuerDNS01ProviderRFC2136, out *acmev1.ACMEIssuerDNS01ProviderRFC2136, s conversion.Scope) error {
	out.Nameserver = in.Nameserver
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.TSIGSecret, &out.TSIGSecret, s); err != nil {
		return err
	}
	out.TSIGKeyName = in.TSIGKeyName
	out.TSIGAlgorithm = in.TSIGAlgorithm
	out.Protocol = acmev1.RFC2136UpdateProtocol(in.Protocol)
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1_ACMEIssuerDNS01ProviderRFC2136 is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1_ACMEIssuerDNS01ProviderRFC2136(in *acme.ACMEIssuerDNS01ProviderRFC2136, out *acmev1.ACMEIssuerDNS01ProviderRFC2136, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1_ACMEIssuerDNS01ProviderRFC2136(in, out, s)
}

func autoConvert_v1_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(in *acmev1.ACMEIssuerDNS01ProviderRoute53, out *acme.ACMEIssuerDNS01ProviderRoute53, s conversion.Scope) error {
	out.Auth = (*acme.Route53Auth)(unsafe.Pointer(in.Auth))
	out.AccessKeyID = in.AccessKeyID
	if in.SecretAccessKeyID != nil {
		in, out := &in.SecretAccessKeyID, &out.SecretAccessKeyID
		*out = new(meta.SecretKeySelector)
		if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SecretAccessKeyID = nil
	}
	if err := metav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.SecretAccessKey, &out.SecretAccessKey, s); err != nil {
		return err
	}
	out.Role = in.Role
	out.HostedZoneID = in.HostedZoneID
	out.Region = in.Region
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53 is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(in *acmev1.ACMEIssuerDNS01ProviderRoute53, out *acme.ACMEIssuerDNS01ProviderRoute53, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1_ACMEIssuerDNS01ProviderRoute53(in *acme.ACMEIssuerDNS01ProviderRoute53, out *acmev1.ACMEIssuerDNS01ProviderRoute53, s conversion.Scope) error {
	out.Auth = (*acmev1.Route53Auth)(unsafe.Pointer(in.Auth))
	out.AccessKeyID = in.AccessKeyID
	if in.SecretAccessKeyID != nil {
		in, out := &in.SecretAccessKeyID, &out.SecretAccessKeyID
		*out = new(apismetav1.SecretKeySelector)
		if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SecretAccessKeyID = nil
	}
	if err := metav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.SecretAccessKey, &out.SecretAccessKey, s); err != nil {
		return err
	}
	out.Role = in.Role
	out.HostedZoneID = in.HostedZoneID
	out.Region = in.Region
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1_ACMEIssuerDNS01ProviderRoute53 is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1_ACMEIssuerDNS01ProviderRoute53(in *acme.ACMEIssuerDNS01ProviderRoute53, out *acmev1.ACMEIssuerDNS01ProviderRoute53, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1_ACMEIssuerDNS01ProviderRoute53(in, out, s)
}

func autoConvert_v1_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook(in *acmev1.ACMEIssuerDNS01ProviderWebhook, out *acme.ACMEIssuerDNS01ProviderWebhook, s conversion.Scope) error {
	out.GroupName = in.GroupName
	out.SolverName = in.SolverName
	out.Config = (*apiextensionsv1.JSON)(unsafe.Pointer(in.Config))
	return nil
}

// Convert_v1_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook is an autogenerated conversion function.
func Convert_v1_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook(in *acmev1.ACMEIssuerDNS01ProviderWebhook, out *acme.ACMEIssuerDNS01ProviderWebhook, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1_ACMEIssuerDNS01ProviderWebhook(in *acme.ACMEIssuerDNS01ProviderWebhook, out *acmev1.ACMEIssuerDNS01ProviderWebhook, s conversion.Scope) error {
	out.GroupName = in.GroupName
	out.SolverName = in.SolverName
	out.Config = (*apiextensionsv1.JSON)(unsafe.Pointer(in.Config))
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1_ACMEIssuerDNS01ProviderWebhook is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1_ACMEIssuerDNS01ProviderWebhook(in *acme.ACMEIssuerDNS01ProviderWebhook, out *acmev1.ACMEIssuerDNS01ProviderWebhook, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1_ACMEIssuerDNS01ProviderWebhook(in, out, s)
}

func autoConvert_v1_ACMEIssuerStatus_To_acme_ACMEIssuerStatus(in *acmev1.ACMEIssuerStatus, out *acme.ACMEIssuerStatus, s conversion.Scope) error {
	out.URI = in.URI
	out.LastRegisteredEmail = in.LastRegisteredEmail
	out.LastPrivateKeyHash = in.LastPrivateKeyHash
	return nil
}

// Convert_v1_ACMEIssuerStatus_To_acme_ACMEIssuerStatus is an autogenerated conversion function.
func Convert_v1_ACMEIssuerStatus_To_acme_ACMEIssuerStatus(in *acmev1.ACMEIssuerStatus, out *acme.ACMEIssuerStatus, s conversion.Scope) error {
	return autoConvert_v1_ACMEIssuerStatus_To_acme_ACMEIssuerStatus(in, out, s)
}

func autoConvert_acme_ACMEIssuerStatus_To_v1_ACMEIssuerStatus(in *acme.ACMEIssuerStatus, out *acmev1.ACMEIssuerStatus, s conversion.Scope) error {
	out.URI = in.URI
	out.LastRegisteredEmail = in.LastRegisteredEmail
	out.LastPrivateKeyHash = in.LastPrivateKeyHash
	return nil
}

// Convert_acme_ACMEIssuerStatus_To_v1_ACMEIssuerStatus is an autogenerated conversion function.
func Convert_acme_ACMEIssuerStatus_To_v1_ACMEIssuerStatus(in *acme.ACMEIssuerStatus, out *acmev1.ACMEIssuerStatus, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerStatus_To_v1_ACMEIssuerStatus(in, out, s)
}

func autoConvert_v1_AzureManagedIdentity_To_acme_AzureManagedIdentity(in *acmev1.AzureManagedIdentity, out *acme.AzureManagedIdentity, s conversion.Scope) error {
	out.ClientID = in.ClientID
	out.ResourceID = in.ResourceID
	out.TenantID = in.TenantID
	return nil
}

// Convert_v1_AzureManagedIdentity_To_acme_AzureManagedIdentity is an autogenerated conversion function.
func Convert_v1_AzureManagedIdentity_To_acme_AzureManagedIdentity(in *acmev1.AzureManagedIdentity, out *acme.AzureManagedIdentity, s conversion.Scope) error {
	return autoConvert_v1_AzureManagedIdentity_To_acme_AzureManagedIdentity(in, out, s)
}

func autoConvert_acme_AzureManagedIdentity_To_v1_AzureManagedIdentity(in *acme.AzureManagedIdentity, out *acmev1.AzureManagedIdentity, s conversion.Scope) error {
	out.ClientID = in.ClientID
	out.ResourceID = in.ResourceID
	out.TenantID = in.TenantID
	return nil
}

// Convert_acme_AzureManagedIdentity_To_v1_AzureManagedIdentity is an autogenerated conversion function.
func Convert_acme_AzureManagedIdentity_To_v1_AzureManagedIdentity(in *acme.AzureManagedIdentity, out *acmev1.AzureManagedIdentity, s conversion.Scope) error {
	return autoConvert_acme_AzureManagedIdentity_To_v1_AzureManagedIdentity(in, out, s)
}

func autoConvert_v1_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector(in *acmev1.CertificateDNSNameSelector, out *acme.CertificateDNSNameSelector, s conversion.Scope) error {
	out.MatchLabels = *(*map[string]string)(unsafe.Pointer(&in.MatchLabels))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.DNSZones = *(*[]string)(unsafe.Pointer(&in.DNSZones))
	return nil
}

// Convert_v1_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector is an autogenerated conversion function.
func Convert_v1_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector(in *acmev1.CertificateDNSNameSelector, out *acme.CertificateDNSNameSelector, s conversion.Scope) error {
	return autoConvert_v1_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector(in, out, s)
}

func autoConvert_acme_CertificateDNSNameSelector_To_v1_CertificateDNSNameSelector(in *acme.CertificateDNSNameSelector, out *acmev1.CertificateDNSNameSelector, s conversion.Scope) error {
	out.MatchLabels = *(*map[string]string)(unsafe.Pointer(&in.MatchLabels))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.DNSZones = *(*[]string)(unsafe.Pointer(&in.DNSZones))
	return nil
}

// Convert_acme_CertificateDNSNameSelector_To_v1_CertificateDNSNameSelector is an autogenerated conversion function.
func Convert_acme_CertificateDNSNameSelector_To_v1_CertificateDNSNameSelector(in *acme.CertificateDNSNameSelector, out *acmev1.CertificateDNSNameSelector, s conversion.Scope) error {
	return autoConvert_acme_CertificateDNSNameSelector_To_v1_CertificateDNSNameSelector(in, out, s)
}

func autoConvert_v1_Challenge_To_acme_Challenge(in *acmev1.Challenge, out *acme.Challenge, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ChallengeSpec_To_acme_ChallengeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ChallengeStatus_To_acme_ChallengeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Challenge_To_acme_Challenge is an autogenerated conversion function.
func Convert_v1_Challenge_To_acme_Challenge(in *acmev1.Challenge, out *acme.Challenge, s conversion.Scope) error {
	return autoConvert_v1_Challenge_To_acme_Challenge(in, out, s)
}

func autoConvert_acme_Challenge_To_v1_Challenge(in *acme.Challenge, out *acmev1.Challenge, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_acme_ChallengeSpec_To_v1_ChallengeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_acme_ChallengeStatus_To_v1_ChallengeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_Challenge_To_v1_Challenge is an autogenerated conversion function.
func Convert_acme_Challenge_To_v1_Challenge(in *acme.Challenge, out *acmev1.Challenge, s conversion.Scope) error {
	return autoConvert_acme_Challenge_To_v1_Challenge(in, out, s)
}

func autoConvert_v1_ChallengeList_To_acme_ChallengeList(in *acmev1.ChallengeList, out *acme.ChallengeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]acme.Challenge, len(*in))
		for i := range *in {
			if err := Convert_v1_Challenge_To_acme_Challenge(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ChallengeList_To_acme_ChallengeList is an autogenerated conversion function.
func Convert_v1_ChallengeList_To_acme_ChallengeList(in *acmev1.ChallengeList, out *acme.ChallengeList, s conversion.Scope) error {
	return autoConvert_v1_ChallengeList_To_acme_ChallengeList(in, out, s)
}

func autoConvert_acme_ChallengeList_To_v1_ChallengeList(in *acme.ChallengeList, out *acmev1.ChallengeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]acmev1.Challenge, len(*in))
		for i := range *in {
			if err := Convert_acme_Challenge_To_v1_Challenge(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_acme_ChallengeList_To_v1_ChallengeList is an autogenerated conversion function.
func Convert_acme_ChallengeList_To_v1_ChallengeList(in *acme.ChallengeList, out *acmev1.ChallengeList, s conversion.Scope) error {
	return autoConvert_acme_ChallengeList_To_v1_ChallengeList(in, out, s)
}

func autoConvert_v1_ChallengeSpec_To_acme_ChallengeSpec(in *acmev1.ChallengeSpec, out *acme.ChallengeSpec, s conversion.Scope) error {
	out.URL = in.URL
	out.AuthorizationURL = in.AuthorizationURL
	out.DNSName = in.DNSName
	out.Wildcard = in.Wildcard
	out.Type = acme.ACMEChallengeType(in.Type)
	out.Token = in.Token
	out.Key = in.Key
	if err := Convert_v1_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(&in.Solver, &out.Solver, s); err != nil {
		return err
	}
	if err := metav1.Convert_v1_IssuerReference_To_meta_IssuerReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ChallengeSpec_To_acme_ChallengeSpec is an autogenerated conversion function.
func Convert_v1_ChallengeSpec_To_acme_ChallengeSpec(in *acmev1.ChallengeSpec, out *acme.ChallengeSpec, s conversion.Scope) error {
	return autoConvert_v1_ChallengeSpec_To_acme_ChallengeSpec(in, out, s)
}

func autoConvert_acme_ChallengeSpec_To_v1_ChallengeSpec(in *acme.ChallengeSpec, out *acmev1.ChallengeSpec, s conversion.Scope) error {
	out.URL = in.URL
	out.AuthorizationURL = in.AuthorizationURL
	out.DNSName = in.DNSName
	out.Wildcard = in.Wildcard
	out.Type = acmev1.ACMEChallengeType(in.Type)
	out.Token = in.Token
	out.Key = in.Key
	if err := Convert_acme_ACMEChallengeSolver_To_v1_ACMEChallengeSolver(&in.Solver, &out.Solver, s); err != nil {
		return err
	}
	if err := metav1.Convert_meta_IssuerReference_To_v1_IssuerReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ChallengeSpec_To_v1_ChallengeSpec is an autogenerated conversion function.
func Convert_acme_ChallengeSpec_To_v1_ChallengeSpec(in *acme.ChallengeSpec, out *acmev1.ChallengeSpec, s conversion.Scope) error {
	return autoConvert_acme_ChallengeSpec_To_v1_ChallengeSpec(in, out, s)
}

func autoConvert_v1_ChallengeStatus_To_acme_ChallengeStatus(in *acmev1.ChallengeStatus, out *acme.ChallengeStatus, s conversion.Scope) error {
	out.Processing = in.Processing
	out.Presented = in.Presented
	out.Reason = in.Reason
	out.State = acme.State(in.State)
	return nil
}

// Convert_v1_ChallengeStatus_To_acme_ChallengeStatus is an autogenerated conversion function.
func Convert_v1_ChallengeStatus_To_acme_ChallengeStatus(in *acmev1.ChallengeStatus, out *acme.ChallengeStatus, s conversion.Scope) error {
	return autoConvert_v1_ChallengeStatus_To_acme_ChallengeStatus(in, out, s)
}

func autoConvert_acme_ChallengeStatus_To_v1_ChallengeStatus(in *acme.ChallengeStatus, out *acmev1.ChallengeStatus, s conversion.Scope) error {
	out.Processing = in.Processing
	out.Presented = in.Presented
	out.Reason = in.Reason
	out.State = acmev1.State(in.State)
	return nil
}

// Convert_acme_ChallengeStatus_To_v1_ChallengeStatus is an autogenerated conversion function.
func Convert_acme_ChallengeStatus_To_v1_ChallengeStatus(in *acme.ChallengeStatus, out *acmev1.ChallengeStatus, s conversion.Scope) error {
	return autoConvert_acme_ChallengeStatus_To_v1_ChallengeStatus(in, out, s)
}

func autoConvert_v1_Order_To_acme_Order(in *acmev1.Order, out *acme.Order, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_OrderSpec_To_acme_OrderSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_OrderStatus_To_acme_OrderStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Order_To_acme_Order is an autogenerated conversion function.
func Convert_v1_Order_To_acme_Order(in *acmev1.Order, out *acme.Order, s conversion.Scope) error {
	return autoConvert_v1_Order_To_acme_Order(in, out, s)
}

func autoConvert_acme_Order_To_v1_Order(in *acme.Order, out *acmev1.Order, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_acme_OrderSpec_To_v1_OrderSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_acme_OrderStatus_To_v1_OrderStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_Order_To_v1_Order is an autogenerated conversion function.
func Convert_acme_Order_To_v1_Order(in *acme.Order, out *acmev1.Order, s conversion.Scope) error {
	return autoConvert_acme_Order_To_v1_Order(in, out, s)
}

func autoConvert_v1_OrderList_To_acme_OrderList(in *acmev1.OrderList, out *acme.OrderList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]acme.Order, len(*in))
		for i := range *in {
			if err := Convert_v1_Order_To_acme_Order(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_OrderList_To_acme_OrderList is an autogenerated conversion function.
func Convert_v1_OrderList_To_acme_OrderList(in *acmev1.OrderList, out *acme.OrderList, s conversion.Scope) error {
	return autoConvert_v1_OrderList_To_acme_OrderList(in, out, s)
}

func autoConvert_acme_OrderList_To_v1_OrderList(in *acme.OrderList, out *acmev1.OrderList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]acmev1.Order, len(*in))
		for i := range *in {
			if err := Convert_acme_Order_To_v1_Order(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_acme_OrderList_To_v1_OrderList is an autogenerated conversion function.
func Convert_acme_OrderList_To_v1_OrderList(in *acme.OrderList, out *acmev1.OrderList, s conversion.Scope) error {
	return autoConvert_acme_OrderList_To_v1_OrderList(in, out, s)
}

func autoConvert_v1_OrderSpec_To_acme_OrderSpec(in *acmev1.OrderSpec, out *acme.OrderSpec, s conversion.Scope) error {
	out.Request = *(*[]byte)(unsafe.Pointer(&in.Request))
	if err := metav1.Convert_v1_IssuerReference_To_meta_IssuerReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	out.CommonName = in.CommonName
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	out.Duration = (*pkgapismetav1.Duration)(unsafe.Pointer(in.Duration))
	out.Profile = in.Profile
	return nil
}

// Convert_v1_OrderSpec_To_acme_OrderSpec is an autogenerated conversion function.
func Convert_v1_OrderSpec_To_acme_OrderSpec(in *acmev1.OrderSpec, out *acme.OrderSpec, s conversion.Scope) error {
	return autoConvert_v1_OrderSpec_To_acme_OrderSpec(in, out, s)
}

func autoConvert_acme_OrderSpec_To_v1_OrderSpec(in *acme.OrderSpec, out *acmev1.OrderSpec, s conversion.Scope) error {
	out.Request = *(*[]byte)(unsafe.Pointer(&in.Request))
	if err := metav1.Convert_meta_IssuerReference_To_v1_IssuerReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	out.CommonName = in.CommonName
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	out.Duration = (*pkgapismetav1.Duration)(unsafe.Pointer(in.Duration))
	out.Profile = in.Profile
	return nil
}

// Convert_acme_OrderSpec_To_v1_OrderSpec is an autogenerated conversion function.
func Convert_acme_OrderSpec_To_v1_OrderSpec(in *acme.OrderSpec, out *acmev1.OrderSpec, s conversion.Scope) error {
	return autoConvert_acme_OrderSpec_To_v1_OrderSpec(in, out, s)
}

func autoConvert_v1_OrderStatus_To_acme_OrderStatus(in *acmev1.OrderStatus, out *acme.OrderStatus, s conversion.Scope) error {
	out.URL = in.URL
	out.FinalizeURL = in.FinalizeURL
	out.Authorizations = *(*[]acme.ACMEAuthorization)(unsafe.Pointer(&in.Authorizations))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.State = acme.State(in.State)
	out.Reason = in.Reason
	out.FailureTime = (*pkgapismetav1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_v1_OrderStatus_To_acme_OrderStatus is an autogenerated conversion function.
func Convert_v1_OrderStatus_To_acme_OrderStatus(in *acmev1.OrderStatus, out *acme.OrderStatus, s conversion.Scope) error {
	return autoConvert_v1_OrderStatus_To_acme_OrderStatus(in, out, s)
}

func autoConvert_acme_OrderStatus_To_v1_OrderStatus(in *acme.OrderStatus, out *acmev1.OrderStatus, s conversion.Scope) error {
	out.URL = in.URL
	out.FinalizeURL = in.FinalizeURL
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.State = acmev1.State(in.State)
	out.Reason = in.Reason
	out.Authorizations = *(*[]acmev1.ACMEAuthorization)(unsafe.Pointer(&in.Authorizations))
	out.FailureTime = (*pkgapismetav1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_acme_OrderStatus_To_v1_OrderStatus is an autogenerated conversion function.
func Convert_acme_OrderStatus_To_v1_OrderStatus(in *acme.OrderStatus, out *acmev1.OrderStatus, s conversion.Scope) error {
	return autoConvert_acme_OrderStatus_To_v1_OrderStatus(in, out, s)
}

func autoConvert_v1_Route53Auth_To_acme_Route53Auth(in *acmev1.Route53Auth, out *acme.Route53Auth, s conversion.Scope) error {
	out.Kubernetes = (*acme.Route53KubernetesAuth)(unsafe.Pointer(in.Kubernetes))
	return nil
}

// Convert_v1_Route53Auth_To_acme_Route53Auth is an autogenerated conversion function.
func Convert_v1_Route53Auth_To_acme_Route53Auth(in *acmev1.Route53Auth, out *acme.Route53Auth, s conversion.Scope) error {
	return autoConvert_v1_Route53Auth_To_acme_Route53Auth(in, out, s)
}

func autoConvert_acme_Route53Auth_To_v1_Route53Auth(in *acme.Route53Auth, out *acmev1.Route53Auth, s conversion.Scope) error {
	out.Kubernetes = (*acmev1.Route53KubernetesAuth)(unsafe.Pointer(in.Kubernetes))
	return nil
}

// Convert_acme_Route53Auth_To_v1_Route53Auth is an autogenerated conversion function.
func Convert_acme_Route53Auth_To_v1_Route53Auth(in *acme.Route53Auth, out *acmev1.Route53Auth, s conversion.Scope) error {
	return autoConvert_acme_Route53Auth_To_v1_Route53Auth(in, out, s)
}

func autoConvert_v1_Route53KubernetesAuth_To_acme_Route53KubernetesAuth(in *acmev1.Route53KubernetesAuth, out *acme.Route53KubernetesAuth, s conversion.Scope) error {
	out.ServiceAccountRef = (*acme.ServiceAccountRef)(unsafe.Pointer(in.ServiceAccountRef))
	return nil
}

// Convert_v1_Route53KubernetesAuth_To_acme_Route53KubernetesAuth is an autogenerated conversion function.
func Convert_v1_Route53KubernetesAuth_To_acme_Route53KubernetesAuth(in *acmev1.Route53KubernetesAuth, out *acme.Route53KubernetesAuth, s conversion.Scope) error {
	return autoConvert_v1_Route53KubernetesAuth_To_acme_Route53KubernetesAuth(in, out, s)
}

func autoConvert_acme_Route53KubernetesAuth_To_v1_Route53KubernetesAuth(in *acme.Route53KubernetesAuth, out *acmev1.Route53KubernetesAuth, s conversion.Scope) error {
	out.ServiceAccountRef = (*acmev1.ServiceAccountRef)(unsafe.Pointer(in.ServiceAccountRef))
	return nil
}

// Convert_acme_Route53KubernetesAuth_To_v1_Route53KubernetesAuth is an autogenerated conversion function.
func Convert_acme_Route53KubernetesAuth_To_v1_Route53KubernetesAuth(in *acme.Route53KubernetesAuth, out *acmev1.Route53KubernetesAuth, s conversion.Scope) error {
	return autoConvert_acme_Route53KubernetesAuth_To_v1_Route53KubernetesAuth(in, out, s)
}

func autoConvert_v1_ServiceAccountRef_To_acme_ServiceAccountRef(in *acmev1.ServiceAccountRef, out *acme.ServiceAccountRef, s conversion.Scope) error {
	out.Name = in.Name
	out.TokenAudiences = *(*[]string)(unsafe.Pointer(&in.TokenAudiences))
	return nil
}

// Convert_v1_ServiceAccountRef_To_acme_ServiceAccountRef is an autogenerated conversion function.
func Convert_v1_ServiceAccountRef_To_acme_ServiceAccountRef(in *acmev1.ServiceAccountRef, out *acme.ServiceAccountRef, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccountRef_To_acme_ServiceAccountRef(in, out, s)
}

func autoConvert_acme_ServiceAccountRef_To_v1_ServiceAccountRef(in *acme.ServiceAccountRef, out *acmev1.ServiceAccountRef, s conversion.Scope) error {
	out.Name = in.Name
	out.TokenAudiences = *(*[]string)(unsafe.Pointer(&in.TokenAudiences))
	return nil
}

// Convert_acme_ServiceAccountRef_To_v1_ServiceAccountRef is an autogenerated conversion function.
func Convert_acme_ServiceAccountRef_To_v1_ServiceAccountRef(in *acme.ServiceAccountRef, out *acmev1.ServiceAccountRef, s conversion.Scope) error {
	return autoConvert_acme_ServiceAccountRef_To_v1_ServiceAccountRef(in, out, s)
}
