/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration represents a declarative configuration of the ACMEChallengeSolverHTTP01IngressPodSpec type for use
// with apply.
type ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration struct {
	NodeSelector       map[string]string                                                     `json:"nodeSelector,omitempty"`
	Affinity           *corev1.Affinity                                                      `json:"affinity,omitempty"`
	Tolerations        []corev1.Toleration                                                   `json:"tolerations,omitempty"`
	PriorityClassName  *string                                                               `json:"priorityClassName,omitempty"`
	ServiceAccountName *string                                                               `json:"serviceAccountName,omitempty"`
	ImagePullSecrets   []corev1.LocalObjectReference                                         `json:"imagePullSecrets,omitempty"`
	SecurityContext    *ACMEChallengeSolverHTTP01IngressPodSecurityContextApplyConfiguration `json:"securityContext,omitempty"`
	Resources          *ACMEChallengeSolverHTTP01IngressPodResourcesApplyConfiguration       `json:"resources,omitempty"`
}

// ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration constructs a declarative configuration of the ACMEChallengeSolverHTTP01IngressPodSpec type for use with
// apply.
func ACMEChallengeSolverHTTP01IngressPodSpec() *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	return &ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration{}
}

// WithNodeSelector puts the entries into the NodeSelector field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the NodeSelector field,
// overwriting an existing map entries in NodeSelector field with the same key.
func (b *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration) WithNodeSelector(entries map[string]string) *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	if b.NodeSelector == nil && len(entries) > 0 {
		b.NodeSelector = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.NodeSelector[k] = v
	}
	return b
}

// WithAffinity sets the Affinity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Affinity field is set to the value of the last call.
func (b *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration) WithAffinity(value corev1.Affinity) *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	b.Affinity = &value
	return b
}

// WithTolerations adds the given value to the Tolerations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Tolerations field.
func (b *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration) WithTolerations(values ...corev1.Toleration) *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	for i := range values {
		b.Tolerations = append(b.Tolerations, values[i])
	}
	return b
}

// WithPriorityClassName sets the PriorityClassName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PriorityClassName field is set to the value of the last call.
func (b *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration) WithPriorityClassName(value string) *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	b.PriorityClassName = &value
	return b
}

// WithServiceAccountName sets the ServiceAccountName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountName field is set to the value of the last call.
func (b *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration) WithServiceAccountName(value string) *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	b.ServiceAccountName = &value
	return b
}

// WithImagePullSecrets adds the given value to the ImagePullSecrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ImagePullSecrets field.
func (b *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration) WithImagePullSecrets(values ...corev1.LocalObjectReference) *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	for i := range values {
		b.ImagePullSecrets = append(b.ImagePullSecrets, values[i])
	}
	return b
}

// WithSecurityContext sets the SecurityContext field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecurityContext field is set to the value of the last call.
func (b *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration) WithSecurityContext(value *ACMEChallengeSolverHTTP01IngressPodSecurityContextApplyConfiguration) *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	b.SecurityContext = value
	return b
}

// WithResources sets the Resources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Resources field is set to the value of the last call.
func (b *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration) WithResources(value *ACMEChallengeSolverHTTP01IngressPodResourcesApplyConfiguration) *ACMEChallengeSolverHTTP01IngressPodSpecApplyConfiguration {
	b.Resources = value
	return b
}
