/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
)

// VaultAuthApplyConfiguration represents a declarative configuration of the VaultAuth type for use
// with apply.
type VaultAuthApplyConfiguration struct {
	TokenSecretRef    *metav1.SecretKeySelectorApplyConfiguration   `json:"tokenSecretRef,omitempty"`
	AppRole           *VaultAppRoleApplyConfiguration               `json:"appRole,omitempty"`
	ClientCertificate *VaultClientCertificateAuthApplyConfiguration `json:"clientCertificate,omitempty"`
	Kubernetes        *VaultKubernetesAuthApplyConfiguration        `json:"kubernetes,omitempty"`
}

// VaultAuthApplyConfiguration constructs a declarative configuration of the VaultAuth type for use with
// apply.
func VaultAuth() *VaultAuthApplyConfiguration {
	return &VaultAuthApplyConfiguration{}
}

// WithTokenSecretRef sets the TokenSecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TokenSecretRef field is set to the value of the last call.
func (b *VaultAuthApplyConfiguration) WithTokenSecretRef(value *metav1.SecretKeySelectorApplyConfiguration) *VaultAuthApplyConfiguration {
	b.TokenSecretRef = value
	return b
}

// WithAppRole sets the AppRole field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AppRole field is set to the value of the last call.
func (b *VaultAuthApplyConfiguration) WithAppRole(value *VaultAppRoleApplyConfiguration) *VaultAuthApplyConfiguration {
	b.AppRole = value
	return b
}

// WithClientCertificate sets the ClientCertificate field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientCertificate field is set to the value of the last call.
func (b *VaultAuthApplyConfiguration) WithClientCertificate(value *VaultClientCertificateAuthApplyConfiguration) *VaultAuthApplyConfiguration {
	b.ClientCertificate = value
	return b
}

// WithKubernetes sets the Kubernetes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kubernetes field is set to the value of the last call.
func (b *VaultAuthApplyConfiguration) WithKubernetes(value *VaultKubernetesAuthApplyConfiguration) *VaultAuthApplyConfiguration {
	b.Kubernetes = value
	return b
}
