/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/api/storagemigration/v1alpha1/generated.proto

package v1alpha1

import (
	fmt "fmt"

	io "io"

	proto "github.com/gogo/protobuf/proto"

	k8s_io_api_core_v1 "k8s.io/api/core/v1"

	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func (m *GroupVersionResource) Reset()      { *m = GroupVersionResource{} }
func (*GroupVersionResource) ProtoMessage() {}
func (*GroupVersionResource) Descriptor() ([]byte, []int) {
	return fileDescriptor_0117377a57b172b9, []int{0}
}
func (m *GroupVersionResource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupVersionResource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *GroupVersionResource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupVersionResource.Merge(m, src)
}
func (m *GroupVersionResource) XXX_Size() int {
	return m.Size()
}
func (m *GroupVersionResource) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupVersionResource.DiscardUnknown(m)
}

var xxx_messageInfo_GroupVersionResource proto.InternalMessageInfo

func (m *MigrationCondition) Reset()      { *m = MigrationCondition{} }
func (*MigrationCondition) ProtoMessage() {}
func (*MigrationCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_0117377a57b172b9, []int{1}
}
func (m *MigrationCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MigrationCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *MigrationCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MigrationCondition.Merge(m, src)
}
func (m *MigrationCondition) XXX_Size() int {
	return m.Size()
}
func (m *MigrationCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_MigrationCondition.DiscardUnknown(m)
}

var xxx_messageInfo_MigrationCondition proto.InternalMessageInfo

func (m *StorageVersionMigration) Reset()      { *m = StorageVersionMigration{} }
func (*StorageVersionMigration) ProtoMessage() {}
func (*StorageVersionMigration) Descriptor() ([]byte, []int) {
	return fileDescriptor_0117377a57b172b9, []int{2}
}
func (m *StorageVersionMigration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersionMigration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersionMigration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersionMigration.Merge(m, src)
}
func (m *StorageVersionMigration) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersionMigration) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersionMigration.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersionMigration proto.InternalMessageInfo

func (m *StorageVersionMigrationList) Reset()      { *m = StorageVersionMigrationList{} }
func (*StorageVersionMigrationList) ProtoMessage() {}
func (*StorageVersionMigrationList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0117377a57b172b9, []int{3}
}
func (m *StorageVersionMigrationList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersionMigrationList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersionMigrationList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersionMigrationList.Merge(m, src)
}
func (m *StorageVersionMigrationList) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersionMigrationList) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersionMigrationList.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersionMigrationList proto.InternalMessageInfo

func (m *StorageVersionMigrationSpec) Reset()      { *m = StorageVersionMigrationSpec{} }
func (*StorageVersionMigrationSpec) ProtoMessage() {}
func (*StorageVersionMigrationSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_0117377a57b172b9, []int{4}
}
func (m *StorageVersionMigrationSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersionMigrationSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersionMigrationSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersionMigrationSpec.Merge(m, src)
}
func (m *StorageVersionMigrationSpec) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersionMigrationSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersionMigrationSpec.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersionMigrationSpec proto.InternalMessageInfo

func (m *StorageVersionMigrationStatus) Reset()      { *m = StorageVersionMigrationStatus{} }
func (*StorageVersionMigrationStatus) ProtoMessage() {}
func (*StorageVersionMigrationStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_0117377a57b172b9, []int{5}
}
func (m *StorageVersionMigrationStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersionMigrationStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersionMigrationStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersionMigrationStatus.Merge(m, src)
}
func (m *StorageVersionMigrationStatus) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersionMigrationStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersionMigrationStatus.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersionMigrationStatus proto.InternalMessageInfo

func init() {
	proto.RegisterType((*GroupVersionResource)(nil), "k8s.io.api.storagemigration.v1alpha1.GroupVersionResource")
	proto.RegisterType((*MigrationCondition)(nil), "k8s.io.api.storagemigration.v1alpha1.MigrationCondition")
	proto.RegisterType((*StorageVersionMigration)(nil), "k8s.io.api.storagemigration.v1alpha1.StorageVersionMigration")
	proto.RegisterType((*StorageVersionMigrationList)(nil), "k8s.io.api.storagemigration.v1alpha1.StorageVersionMigrationList")
	proto.RegisterType((*StorageVersionMigrationSpec)(nil), "k8s.io.api.storagemigration.v1alpha1.StorageVersionMigrationSpec")
	proto.RegisterType((*StorageVersionMigrationStatus)(nil), "k8s.io.api.storagemigration.v1alpha1.StorageVersionMigrationStatus")
}

func init() {
	proto.RegisterFile("k8s.io/api/storagemigration/v1alpha1/generated.proto", fileDescriptor_0117377a57b172b9)
}

var fileDescriptor_0117377a57b172b9 = []byte{
	// 719 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0xcf, 0x4f, 0x13, 0x4f,
	0x14, 0xef, 0x42, 0x0b, 0x7c, 0xa7, 0x5f, 0xc0, 0x4c, 0x14, 0x1a, 0x8c, 0x5b, 0x53, 0x09, 0x41,
	0xa3, 0xb3, 0xd2, 0x10, 0x43, 0x30, 0x1e, 0x28, 0x07, 0xa3, 0x81, 0x98, 0x0c, 0xc8, 0xc1, 0x78,
	0x70, 0xba, 0x1d, 0xb7, 0x43, 0xd9, 0x9d, 0xcd, 0xce, 0x6c, 0x13, 0x6e, 0xfe, 0x09, 0x1e, 0xfc,
	0x93, 0x3c, 0x70, 0x31, 0xe1, 0xc8, 0xc5, 0x2a, 0xf5, 0xbf, 0xe0, 0x64, 0x66, 0x76, 0x76, 0xfb,
	0x8b, 0x62, 0x13, 0x6e, 0x3b, 0xef, 0xbd, 0xcf, 0x67, 0xde, 0x7b, 0x9f, 0x79, 0x6f, 0xc1, 0x66,
	0x6b, 0x4b, 0x20, 0xc6, 0x1d, 0x12, 0x32, 0x47, 0x48, 0x1e, 0x11, 0x8f, 0xfa, 0xcc, 0x8b, 0x88,
	0x64, 0x3c, 0x70, 0xda, 0x1b, 0xe4, 0x24, 0x6c, 0x92, 0x0d, 0xc7, 0xa3, 0x01, 0x8d, 0x88, 0xa4,
	0x0d, 0x14, 0x46, 0x5c, 0x72, 0xb8, 0x9a, 0xa0, 0x10, 0x09, 0x19, 0x1a, 0x46, 0xa1, 0x14, 0xb5,
	0xf2, 0xcc, 0x63, 0xb2, 0x19, 0xd7, 0x91, 0xcb, 0x7d, 0xc7, 0xe3, 0x1e, 0x77, 0x34, 0xb8, 0x1e,
	0x7f, 0xd6, 0x27, 0x7d, 0xd0, 0x5f, 0x09, 0xe9, 0x4a, 0xa5, 0x2f, 0x15, 0x97, 0x47, 0xd4, 0x69,
	0x8f, 0x5c, 0xbc, 0xd2, 0x97, 0xae, 0x4f, 0xdc, 0x26, 0x0b, 0x68, 0x74, 0xea, 0x84, 0x2d, 0x4f,
	0x19, 0x84, 0xe3, 0x53, 0x49, 0xae, 0x43, 0x39, 0xe3, 0x50, 0x51, 0x1c, 0x48, 0xe6, 0xd3, 0x11,
	0xc0, 0x8b, 0x7f, 0x01, 0x84, 0xdb, 0xa4, 0x3e, 0x19, 0xc6, 0x55, 0xbe, 0x59, 0xe0, 0xee, 0xeb,
	0x88, 0xc7, 0xe1, 0x11, 0x8d, 0x04, 0xe3, 0x01, 0xa6, 0x82, 0xc7, 0x91, 0x4b, 0xe1, 0x23, 0x50,
	0xf0, 0x94, 0xbd, 0x64, 0x3d, 0xb4, 0xd6, 0xff, 0xab, 0xcd, 0x9f, 0x75, 0xca, 0xb9, 0x6e, 0xa7,
	0x5c, 0xd0, 0xc1, 0x38, 0xf1, 0xc1, 0xc7, 0x60, 0xb6, 0x9d, 0xe0, 0x4a, 0x53, 0x3a, 0x6c, 0xd1,
	0x84, 0xcd, 0xa6, 0x74, 0xa9, 0x1f, 0x3e, 0x05, 0x73, 0x91, 0xe1, 0x2e, 0x4d, 0xeb, 0xd8, 0x3b,
	0x26, 0x76, 0x2e, 0xbd, 0x13, 0x67, 0x11, 0x95, 0x9f, 0x53, 0x00, 0xee, 0xa7, 0xfa, 0xec, 0xf2,
	0xa0, 0xc1, 0xd4, 0x07, 0xdc, 0x06, 0x79, 0x79, 0x1a, 0x52, 0x93, 0xd3, 0x9a, 0x21, 0xc8, 0x1f,
	0x9e, 0x86, 0xf4, 0xaa, 0x53, 0x5e, 0x1a, 0x45, 0x28, 0x0f, 0xd6, 0x18, 0xb8, 0x07, 0x66, 0x84,
	0x24, 0x32, 0x16, 0x26, 0xd5, 0x4d, 0x83, 0x9e, 0x39, 0xd0, 0xd6, 0xab, 0x4e, 0xf9, 0x1a, 0x39,
	0x51, 0xc6, 0x94, 0x44, 0x61, 0xc3, 0x01, 0x8f, 0xc1, 0xc2, 0x09, 0x11, 0xf2, 0x7d, 0xd8, 0x20,
	0x92, 0x1e, 0x32, 0x3f, 0x29, 0xaa, 0x58, 0x7d, 0x82, 0x7a, 0x0f, 0x2d, 0x13, 0x02, 0x85, 0x2d,
	0x4f, 0x19, 0x04, 0x52, 0x7a, 0xa3, 0xf6, 0x06, 0x52, 0x88, 0xda, 0x92, 0xc9, 0x60, 0x61, 0x6f,
	0x80, 0x09, 0x0f, 0x31, 0xc3, 0x35, 0x30, 0x13, 0x51, 0x22, 0x78, 0x50, 0xca, 0xeb, 0xcc, 0x17,
	0xd2, 0xcc, 0xb1, 0xb6, 0x62, 0xe3, 0x55, 0x6a, 0xf8, 0x54, 0x08, 0xe2, 0xd1, 0x52, 0x61, 0x50,
	0x8d, 0xfd, 0xc4, 0x8c, 0x53, 0x7f, 0xe5, 0xc7, 0x14, 0x58, 0x3e, 0x48, 0xc6, 0xc0, 0x28, 0x95,
	0xf5, 0x0e, 0x7e, 0x02, 0x73, 0x2a, 0xcd, 0x06, 0x91, 0x44, 0x37, 0xba, 0x58, 0x7d, 0x3e, 0x59,
	0x51, 0xef, 0xea, 0xc7, 0xd4, 0x95, 0xfb, 0x54, 0x92, 0x1a, 0x34, 0x37, 0x83, 0x9e, 0x0d, 0x67,
	0xac, 0xd0, 0x05, 0x79, 0x11, 0x52, 0x57, 0x0b, 0x51, 0xac, 0xee, 0xa0, 0x49, 0x66, 0x13, 0x8d,
	0x49, 0xf7, 0x20, 0xa4, 0x6e, 0xed, 0xff, 0xf4, 0x25, 0xa8, 0x13, 0xd6, 0xe4, 0xb0, 0x95, 0xe9,
	0x9d, 0x28, 0xb3, 0x7b, 0xbb, 0x6b, 0x34, 0x55, 0xaf, 0xf5, 0x83, 0xcf, 0xa1, 0xf2, 0xcb, 0x02,
	0xf7, 0xc7, 0x20, 0xf7, 0x98, 0x90, 0xf0, 0xe3, 0x48, 0x4f, 0xd1, 0x64, 0x3d, 0x55, 0x68, 0xdd,
	0xd1, 0x6c, 0x5a, 0x52, 0x4b, 0x5f, 0x3f, 0xeb, 0xa0, 0xc0, 0x24, 0xf5, 0xd5, 0xcb, 0x9e, 0x5e,
	0x2f, 0x56, 0x5f, 0xdd, 0xaa, 0xd2, 0xde, 0xa8, 0xbf, 0x51, 0x9c, 0x38, 0xa1, 0xae, 0x7c, 0x1f,
	0x5f, 0xa1, 0x6a, 0x3a, 0x6c, 0xf6, 0xcd, 0x77, 0x52, 0xe1, 0xf6, 0x64, 0x69, 0x5c, 0xb7, 0x7d,
	0x6e, 0xda, 0x0d, 0xf0, 0x25, 0x98, 0x77, 0x79, 0x20, 0x59, 0x10, 0xd3, 0x43, 0xde, 0xa2, 0xe9,
	0xea, 0xb9, 0x67, 0x20, 0xf3, 0xbb, 0xfd, 0x4e, 0x3c, 0x18, 0x5b, 0x39, 0xb7, 0xc0, 0x83, 0x1b,
	0x25, 0x86, 0x27, 0x00, 0xb8, 0xe9, 0xd0, 0x8b, 0x92, 0xa5, 0x3b, 0xba, 0x35, 0x59, 0x29, 0xa3,
	0xfb, 0xa7, 0x37, 0x08, 0x99, 0x49, 0xe0, 0x3e, 0x7e, 0xb8, 0x03, 0x16, 0xd3, 0xc2, 0x8e, 0x06,
	0x36, 0xe9, 0xb2, 0x01, 0x2e, 0xe2, 0x41, 0x37, 0x1e, 0x8e, 0xaf, 0xbd, 0x3d, 0xbb, 0xb4, 0x73,
	0xe7, 0x97, 0x76, 0xee, 0xe2, 0xd2, 0xce, 0x7d, 0xe9, 0xda, 0xd6, 0x59, 0xd7, 0xb6, 0xce, 0xbb,
	0xb6, 0x75, 0xd1, 0xb5, 0xad, 0xdf, 0x5d, 0xdb, 0xfa, 0xfa, 0xc7, 0xce, 0x7d, 0x58, 0x9d, 0xe4,
	0xb7, 0xf9, 0x37, 0x00, 0x00, 0xff, 0xff, 0x01, 0xc1, 0xb1, 0xd8, 0x5d, 0x07, 0x00, 0x00,
}

func (m *GroupVersionResource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupVersionResource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupVersionResource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Resource)
	copy(dAtA[i:], m.Resource)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Resource)))
	i--
	dAtA[i] = 0x1a
	i -= len(m.Version)
	copy(dAtA[i:], m.Version)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Version)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Group)
	copy(dAtA[i:], m.Group)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Group)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *MigrationCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MigrationCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MigrationCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Message)
	copy(dAtA[i:], m.Message)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Message)))
	i--
	dAtA[i] = 0x2a
	i -= len(m.Reason)
	copy(dAtA[i:], m.Reason)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Reason)))
	i--
	dAtA[i] = 0x22
	{
		size, err := m.LastUpdateTime.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	i -= len(m.Status)
	copy(dAtA[i:], m.Status)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Status)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Type)
	copy(dAtA[i:], m.Type)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Type)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *StorageVersionMigration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersionMigration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersionMigration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	{
		size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *StorageVersionMigrationList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersionMigrationList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersionMigrationList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ListMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *StorageVersionMigrationSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersionMigrationSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersionMigrationSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.ContinueToken)
	copy(dAtA[i:], m.ContinueToken)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ContinueToken)))
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *StorageVersionMigrationStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersionMigrationStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersionMigrationStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.ResourceVersion)
	copy(dAtA[i:], m.ResourceVersion)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ResourceVersion)))
	i--
	dAtA[i] = 0x12
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GroupVersionResource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Group)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Version)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Resource)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *MigrationCondition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Status)
	n += 1 + l + sovGenerated(uint64(l))
	l = m.LastUpdateTime.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Reason)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Message)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *StorageVersionMigration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ObjectMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Status.Size()
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *StorageVersionMigrationList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ListMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *StorageVersionMigrationSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Resource.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.ContinueToken)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *StorageVersionMigrationStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	l = len(m.ResourceVersion)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *GroupVersionResource) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GroupVersionResource{`,
		`Group:` + fmt.Sprintf("%v", this.Group) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`Resource:` + fmt.Sprintf("%v", this.Resource) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MigrationCondition) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MigrationCondition{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`LastUpdateTime:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.LastUpdateTime), "Time", "v1.Time", 1), `&`, ``, 1) + `,`,
		`Reason:` + fmt.Sprintf("%v", this.Reason) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersionMigration) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StorageVersionMigration{`,
		`ObjectMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ObjectMeta), "ObjectMeta", "v1.ObjectMeta", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "StorageVersionMigrationSpec", "StorageVersionMigrationSpec", 1), `&`, ``, 1) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "StorageVersionMigrationStatus", "StorageVersionMigrationStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersionMigrationList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]StorageVersionMigration{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(strings.Replace(f.String(), "StorageVersionMigration", "StorageVersionMigration", 1), `&`, ``, 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&StorageVersionMigrationList{`,
		`ListMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ListMeta), "ListMeta", "v1.ListMeta", 1), `&`, ``, 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersionMigrationSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StorageVersionMigrationSpec{`,
		`Resource:` + strings.Replace(strings.Replace(this.Resource.String(), "GroupVersionResource", "GroupVersionResource", 1), `&`, ``, 1) + `,`,
		`ContinueToken:` + fmt.Sprintf("%v", this.ContinueToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersionMigrationStatus) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForConditions := "[]MigrationCondition{"
	for _, f := range this.Conditions {
		repeatedStringForConditions += strings.Replace(strings.Replace(f.String(), "MigrationCondition", "MigrationCondition", 1), `&`, ``, 1) + ","
	}
	repeatedStringForConditions += "}"
	s := strings.Join([]string{`&StorageVersionMigrationStatus{`,
		`Conditions:` + repeatedStringForConditions + `,`,
		`ResourceVersion:` + fmt.Sprintf("%v", this.ResourceVersion) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *GroupVersionResource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupVersionResource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupVersionResource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Group = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MigrationCondition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MigrationCondition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MigrationCondition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = MigrationConditionType(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = k8s_io_api_core_v1.ConditionStatus(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LastUpdateTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersionMigration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersionMigration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersionMigration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersionMigrationList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersionMigrationList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersionMigrationList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ListMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, StorageVersionMigration{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersionMigrationSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersionMigrationSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersionMigrationSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContinueToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContinueToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersionMigrationStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersionMigrationStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersionMigrationStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conditions = append(m.Conditions, MigrationCondition{})
			if err := m.Conditions[len(m.Conditions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGenerated
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGenerated
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGenerated        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGenerated = fmt.Errorf("proto: unexpected end of group")
)
