// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/kde-output-management-v2.xml

#ifndef QT_WAYLAND_SERVER_KDE_OUTPUT_MANAGEMENT_V2
#define QT_WAYLAND_SERVER_KDE_OUTPUT_MANAGEMENT_V2

#include "wayland-server-core.h"
#include "wayland-kde-output-management-v2-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  kde_output_management_v2
    {
    public:
        kde_output_management_v2(struct ::wl_client *client, int id, int version);
        kde_output_management_v2(struct ::wl_display *display, int version);
        kde_output_management_v2(struct ::wl_resource *resource);
        kde_output_management_v2();

        virtual ~kde_output_management_v2();

        class Resource
        {
        public:
            Resource() : kde_output_management_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            kde_output_management_v2 *kde_output_management_v2_object;
            kde_output_management_v2 *object() { return kde_output_management_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


    protected:
        virtual Resource *kde_output_management_v2_allocate();

        virtual void kde_output_management_v2_destroy_global();

        virtual void kde_output_management_v2_bind_resource(Resource *resource);
        virtual void kde_output_management_v2_destroy_resource(Resource *resource);

        virtual void kde_output_management_v2_create_configuration(Resource *resource, uint32_t id);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::kde_output_management_v2_interface m_kde_output_management_v2_interface;

        static void handle_create_configuration(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            kde_output_management_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  kde_output_configuration_v2
    {
    public:
        kde_output_configuration_v2(struct ::wl_client *client, int id, int version);
        kde_output_configuration_v2(struct ::wl_display *display, int version);
        kde_output_configuration_v2(struct ::wl_resource *resource);
        kde_output_configuration_v2();

        virtual ~kde_output_configuration_v2();

        class Resource
        {
        public:
            Resource() : kde_output_configuration_v2_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            kde_output_configuration_v2 *kde_output_configuration_v2_object;
            kde_output_configuration_v2 *object() { return kde_output_configuration_v2_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_already_applied = 0, // the config is already applied
        };

        enum vrr_policy {
            vrr_policy_never = 0,
            vrr_policy_always = 1,
            vrr_policy_automatic = 2,
        };

        enum rgb_range {
            rgb_range_automatic = 0,
            rgb_range_full = 1,
            rgb_range_limited = 2,
        };

        enum color_mode {
            color_mode_native = 0,
            color_mode_photo = 1,
            color_mode_adobe = 2,
            color_mode_web = 3,
            color_mode_ebook = 4,
        };

        void send_applied();
        void send_applied(struct ::wl_resource *resource);
        void send_failed();
        void send_failed(struct ::wl_resource *resource);

    protected:
        virtual Resource *kde_output_configuration_v2_allocate();

        virtual void kde_output_configuration_v2_destroy_global();

        virtual void kde_output_configuration_v2_bind_resource(Resource *resource);
        virtual void kde_output_configuration_v2_destroy_resource(Resource *resource);

        virtual void kde_output_configuration_v2_enable(Resource *resource, struct ::wl_resource *outputdevice, int32_t enable);
        virtual void kde_output_configuration_v2_mode(Resource *resource, struct ::wl_resource *outputdevice, struct ::wl_resource *mode);
        virtual void kde_output_configuration_v2_transform(Resource *resource, struct ::wl_resource *outputdevice, int32_t transform);
        virtual void kde_output_configuration_v2_position(Resource *resource, struct ::wl_resource *outputdevice, int32_t x, int32_t y);
        virtual void kde_output_configuration_v2_scale(Resource *resource, struct ::wl_resource *outputdevice, wl_fixed_t scale);
        virtual void kde_output_configuration_v2_apply(Resource *resource);
        virtual void kde_output_configuration_v2_destroy(Resource *resource);
        virtual void kde_output_configuration_v2_overscan(Resource *resource, struct ::wl_resource *outputdevice, uint32_t overscan);
        virtual void kde_output_configuration_v2_set_vrr_policy(Resource *resource, struct ::wl_resource *outputdevice, uint32_t policy);
        virtual void kde_output_configuration_v2_set_rgb_range(Resource *resource, struct ::wl_resource *outputdevice, uint32_t rgb_range);
        virtual void kde_output_configuration_v2_set_primary_output(Resource *resource, struct ::wl_resource *output);
        virtual void kde_output_configuration_v2_set_priority(Resource *resource, struct ::wl_resource *outputdevice, uint32_t priority);
        virtual void kde_output_configuration_v2_brightness(Resource *resource, struct ::wl_resource *outputdevice, int32_t brightness);
        virtual void kde_output_configuration_v2_ctm(Resource *resource, struct ::wl_resource *outputdevice, int32_t red, int32_t green, int32_t blue);
        virtual void kde_output_configuration_v2_set_color_mode(Resource *resource, struct ::wl_resource *outputdevice, uint32_t color_mode);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::kde_output_configuration_v2_interface m_kde_output_configuration_v2_interface;

        static void handle_enable(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t enable);
        static void handle_mode(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            struct ::wl_resource *mode);
        static void handle_transform(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t transform);
        static void handle_position(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t x,
            int32_t y);
        static void handle_scale(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            wl_fixed_t scale);
        static void handle_apply(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_overscan(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t overscan);
        static void handle_set_vrr_policy(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t policy);
        static void handle_set_rgb_range(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t rgb_range);
        static void handle_set_primary_output(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *output);
        static void handle_set_priority(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t priority);
        static void handle_brightness(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t brightness);
        static void handle_ctm(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            int32_t red,
            int32_t green,
            int32_t blue);
        static void handle_set_color_mode(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *outputdevice,
            uint32_t color_mode);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            kde_output_configuration_v2 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
