/*
 * This file was generated by qdbusxml2cpp-fix version 0.8
 * Command line was: qdbusxml2cpp-fix -c DBus -p /build/deepin-session/src/dde-session/dbusinterface/org_freedesktop_DBus /build/deepin-session/src/dde-session/dbus/interface/org.freedesktop.DBus.xml
 *
 * qdbusxml2cpp-fix is Copyright (C) 2016 Deepin Technology Co., Ltd.
 *
 * This is an auto-generated file.
 * This file may have been hand-edited. Look for HAND-EDIT comments
 * before re-generating it.
 */

#include "/build/deepin-session/src/dde-session/dbusinterface/org_freedesktop_DBus.h"

DCORE_USE_NAMESPACE
/*
 * Implementation of interface class __DBus
 */

class __DBusPrivate
{
public:
   __DBusPrivate() = default;

    // begin member variables
    QStringList Features;
    QStringList Interfaces;

public:
    QMap<QString, QDBusPendingCallWatcher *> m_processingCalls;
    QMap<QString, QList<QVariant>> m_waittingCalls;
};

__DBus::__DBus(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent)
    : DDBusExtendedAbstractInterface(service, path, staticInterfaceName(), connection, parent)
    , d_ptr(new __DBusPrivate)
{
    connect(this, &__DBus::propertyChanged, this, &__DBus::onPropertyChanged);

    if (QMetaType::fromName("EnvInfoList").id() == QMetaType::UnknownType)
        registerEnvInfoListMetaType();
}

__DBus::~__DBus()
{
    qDeleteAll(d_ptr->m_processingCalls.values());
    delete d_ptr;
}

void __DBus::onPropertyChanged(const QString &propName, const QVariant &value)
{
    if (propName == QStringLiteral("Features"))
    {
        const QStringList &Features = qvariant_cast<QStringList>(value);
        if (d_ptr->Features != Features)
        {
            d_ptr->Features = Features;
            Q_EMIT FeaturesChanged(d_ptr->Features);
        }
        return;
    }

    if (propName == QStringLiteral("Interfaces"))
    {
        const QStringList &Interfaces = qvariant_cast<QStringList>(value);
        if (d_ptr->Interfaces != Interfaces)
        {
            d_ptr->Interfaces = Interfaces;
            Q_EMIT InterfacesChanged(d_ptr->Interfaces);
        }
        return;
    }

    qWarning() << "property not handle: " << propName;
    return;
}

QStringList __DBus::features()
{
    return qvariant_cast<QStringList>(internalPropGet("Features", &d_ptr->Features));
}

QStringList __DBus::interfaces()
{
    return qvariant_cast<QStringList>(internalPropGet("Interfaces", &d_ptr->Interfaces));
}

void __DBus::CallQueued(const QString &callName, const QList<QVariant> &args)
{
    if (d_ptr->m_waittingCalls.contains(callName))
    {
        d_ptr->m_waittingCalls[callName] = args;
        return;
    }
    if (d_ptr->m_processingCalls.contains(callName))
    {
        d_ptr->m_waittingCalls.insert(callName, args);
    } else {
        QDBusPendingCallWatcher *watcher = new QDBusPendingCallWatcher(asyncCallWithArgumentList(callName, args));
        connect(watcher, &QDBusPendingCallWatcher::finished, this, &__DBus::onPendingCallFinished);
        d_ptr->m_processingCalls.insert(callName, watcher);
    }
}

void __DBus::onPendingCallFinished(QDBusPendingCallWatcher *w)
{
    w->deleteLater();
    const auto callName = d_ptr->m_processingCalls.key(w);
    Q_ASSERT(!callName.isEmpty());
    if (callName.isEmpty())
        return;
    d_ptr->m_processingCalls.remove(callName);
    if (!d_ptr->m_waittingCalls.contains(callName))
        return;
    const auto args = d_ptr->m_waittingCalls.take(callName);
    CallQueued(callName, args);
}
