
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "pageformdata_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_PageFormData_Type = nullptr;
static PyTypeObject *Sbk_PageFormData_TypeF(void)
{
    return _Sbk_PageFormData_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PageFormData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PageFormData >()))
        return -1;

    ::PageFormData *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "PageFormData", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: PageFormData::PageFormData()
    // 1: PageFormData::PageFormData(PageFormData)
    if (numArgs == 0) {
        overloadId = 0; // PageFormData()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), (pyArgs[0])))) {
        overloadId = 1; // PageFormData(PageFormData)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // PageFormData()
        {

            // PageFormData()
            cptr = new ::PageFormData();
            break;
        }
        case 1: // PageFormData(const PageFormData &PageFormData)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::PageFormData cppArg0_local;
            ::PageFormData *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // PageFormData(PageFormData)
                cptr = new ::PageFormData(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PageFormData >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_PageFormDataFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::PageFormData *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PageFormData__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_PageFormData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PageFormData_methods[] = {
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_PageFormDataFunc_isValid), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_PageFormData__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_PageFormData_get_username(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->username);
}
static int Sbk_PageFormData_set_username(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("username");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("username", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->username;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PageFormData_get_password(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->password);
}
static int Sbk_PageFormData_set_password(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("password");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("password", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->password;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PageFormData_get_postData(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->postData), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->postData), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_PageFormData_set_postData(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("postData");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("postData", "QByteArray");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->postData;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for PageFormData
static PyGetSetDef Sbk_PageFormData_getsetlist[] = {
    {const_cast<char *>("username"), Sbk_PageFormData_get_username, Sbk_PageFormData_set_username, nullptr, nullptr},
    {const_cast<char *>("password"), Sbk_PageFormData_get_password, Sbk_PageFormData_set_password, nullptr, nullptr},
    {const_cast<char *>("postData"), Sbk_PageFormData_get_postData, Sbk_PageFormData_set_postData, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_PageFormData_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_PageFormData_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_PageFormData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PageFormData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PageFormData_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PageFormData_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_PageFormData_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PageFormData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_PageFormData_spec = {
    "1:PyFalkon.PageFormData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_PageFormData_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PageFormData_PythonToCpp_PageFormData_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_PageFormData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PageFormData_PythonToCpp_PageFormData_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_PageFormData_TypeF()))
        return PageFormData_PythonToCpp_PageFormData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PageFormData_PTR_CppToPython_PageFormData(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_PageFormData_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_PageFormData_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *PageFormData_COPY_CppToPython_PageFormData(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::PageFormData *>(cppIn);
    return Shiboken::Object::newObject(Sbk_PageFormData_TypeF(), new ::PageFormData(*source), true, true);
}

// Python to C++ copy conversion.
static void PageFormData_PythonToCpp_PageFormData_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::PageFormData *>(cppOut) = *reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_PageFormData_PythonToCpp_PageFormData_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_PageFormData_TypeF()))
        return PageFormData_PythonToCpp_PageFormData_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *PageFormData_SignatureStrings[] = {
    "1:PyFalkon.PageFormData(self)",
    "0:PyFalkon.PageFormData(self,PageFormData:PyFalkon.PageFormData)",
    "PyFalkon.PageFormData.isValid(self)->bool",
    "PyFalkon.PageFormData.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t PageFormData_SignatureByteSize = 90;
static constexpr uint8_t PageFormData_SignatureBytes[90] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0x48, 0x4c,
    0x4f, 0x75, 0xcb, 0x2f, 0xca, 0x75, 0x49, 0x2c, 0x49, 0xd4, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4,
    0x32, 0xc0, 0x23, 0xab, 0x83, 0x2c, 0x82, 0x5d, 0x9d, 0x26, 0x17, 0x56, 0x61, 0xbd, 0xcc, 0xe2,
    0xb0, 0xc4, 0x9c, 0xcc, 0x14, 0x88, 0x25, 0xba, 0x76, 0x49, 0xf9, 0xf9, 0x39, 0x38, 0x54, 0xc6,
    0xc7, 0x27, 0xe7, 0x17, 0x54, 0xc6, 0xc7, 0xc3, 0x94, 0x96, 0x54, 0x16, 0x64, 0xe6, 0xa5, 0xeb,
    0xc5, 0x07, 0x03, 0xb9, 0x5c, 0x00, 0x90, 0xe4, 0x42, 0xbf
};
#endif

PyTypeObject *init_PageFormData(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_PageFormData_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_PageFormData_IDX].type;

    Shiboken::AutoDecRef Sbk_PageFormData_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_PageFormData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PageFormData",
        "PageFormData",
        &Sbk_PageFormData_spec,
        &Shiboken::callCppDestructor< ::PageFormData >,
        Sbk_PageFormData_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = Sbk_PageFormData_TypeF(); // references _Sbk_PageFormData_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, PageFormData_SignatureStrings);
#else
    InitSignatureBytes(pyType, PageFormData_SignatureBytes, PageFormData_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_PageFormData_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_PageFormData_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        PageFormData_PythonToCpp_PageFormData_PTR,
        is_PageFormData_PythonToCpp_PageFormData_PTR_Convertible,
        PageFormData_PTR_CppToPython_PageFormData,
        PageFormData_COPY_CppToPython_PageFormData);

    Shiboken::Conversions::registerConverterName(converter, "PageFormData");
    Shiboken::Conversions::registerConverterName(converter, "PageFormData*");
    Shiboken::Conversions::registerConverterName(converter, "PageFormData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PageFormData).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PageFormData_PythonToCpp_PageFormData_COPY,
        is_PageFormData_PythonToCpp_PageFormData_COPY_Convertible);

    qRegisterMetaType< ::PageFormData >("PageFormData");

    return pyType;
}
