#ifndef SBK_BOOKMARKSMODELWRAPPER_H
#define SBK_BOOKMARKSMODELWRAPPER_H

#include <bookmarksmodel.h>


// Argument includes
#include <QHash>
#include <QList>
#include <QMap>
#include <QStringList>
#include <bookmarkitem.h>
#include <bookmarks.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qmimedata.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qvariant.h>
#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class BookmarksModelWrapper : public BookmarksModel
{
public:
    BookmarksModelWrapper(::BookmarkItem * root, ::Bookmarks * bookmarks, ::QObject * parent = nullptr);
    BookmarksModelWrapper(const BookmarksModelWrapper &) = delete;
    BookmarksModelWrapper& operator=(const BookmarksModelWrapper &) = delete;
    BookmarksModelWrapper(BookmarksModelWrapper &&) = delete;
    BookmarksModelWrapper& operator=(BookmarksModelWrapper &&) = delete;
    ~BookmarksModelWrapper() override;

    ::QModelIndex buddy(const ::QModelIndex & index) const override;
    bool canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const override;
    bool canFetchMore(const ::QModelIndex & parent) const override;
    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    bool clearItemData(const ::QModelIndex & index) override;
    int columnCount(const ::QModelIndex & parent) const override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    ::QVariant data(const ::QModelIndex & index, int role) const override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void fetchMore(const ::QModelIndex & parent) override;
    ::QFlags<Qt::ItemFlag> flags(const ::QModelIndex & index) const override;
    bool hasChildren(const ::QModelIndex & parent) const override;
    ::QVariant headerData(int section, ::Qt::Orientation orientation, int role) const override;
    ::QModelIndex index(int row, int column, const ::QModelIndex & parent = QModelIndex()) const override;
    // Inherited overloads, because the using keyword sux
    ::QModelIndex index(::BookmarkItem * item, int column = 0) const { return BookmarksModel::index(item, column); }

    bool insertColumns(int column, int count, const ::QModelIndex & parent = QModelIndex()) override;
    bool insertRows(int row, int count, const ::QModelIndex & parent = QModelIndex()) override;
    ::QMap<int,QVariant> itemData(const ::QModelIndex & index) const override;
    ::QList<QModelIndex> match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits = 1, ::QFlags<Qt::MatchFlag> flags = Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)) const override;
    ::QMimeData * mimeData(const ::QList<QModelIndex> & indexes) const override;
    ::QStringList mimeTypes() const override;
    bool moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild) override;
    bool moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild) override;
    void multiData(const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan) const override;
    ::QModelIndex parent(const ::QModelIndex & child) const override;
    bool removeColumns(int column, int count, const ::QModelIndex & parent = QModelIndex()) override;
    bool removeRows(int row, int count, const ::QModelIndex & parent = QModelIndex()) override;
    void resetInternalData_protected() { QAbstractItemModel::resetInternalData(); }
    void resetInternalData() override;
    void revert() override;
    ::QHash<int,QByteArray> roleNames() const override;
    int rowCount(const ::QModelIndex & parent) const override;
    bool setData(const ::QModelIndex & index, const ::QVariant & value, int role = Qt::EditRole) override;
    bool setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role = Qt::EditRole) override;
    bool setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant> & roles) override;
    ::QModelIndex sibling(int row, int column, const ::QModelIndex & idx) const override;
    void sort(int column, ::Qt::SortOrder order = Qt::AscendingOrder) override;
    ::QSize span(const ::QModelIndex & index) const override;
    bool submit() override;
    ::QFlags<Qt::DropAction> supportedDragActions() const override;
    ::QFlags<Qt::DropAction> supportedDropActions() const override;
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 44> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  ifndef SBK_QABSTRACTITEMMODELWRAPPER_H
#  define SBK_QABSTRACTITEMMODELWRAPPER_H

// Inherited base class:
class QAbstractItemModelWrapper : public QAbstractItemModel
{
public:
    QAbstractItemModelWrapper(::QObject * parent = nullptr);
    QAbstractItemModelWrapper(const QAbstractItemModelWrapper &) = delete;
    QAbstractItemModelWrapper& operator=(const QAbstractItemModelWrapper &) = delete;
    QAbstractItemModelWrapper(QAbstractItemModelWrapper &&) = delete;
    QAbstractItemModelWrapper& operator=(QAbstractItemModelWrapper &&) = delete;
    ~QAbstractItemModelWrapper() override;

    void beginInsertColumns_protected(const ::QModelIndex & parent, int first, int last) { QAbstractItemModel::beginInsertColumns(parent, first, last); }
    void beginInsertRows_protected(const ::QModelIndex & parent, int first, int last) { QAbstractItemModel::beginInsertRows(parent, first, last); }
    bool beginMoveColumns_protected(const ::QModelIndex & sourceParent, int sourceFirst, int sourceLast, const ::QModelIndex & destinationParent, int destinationColumn) { return QAbstractItemModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn); }
    bool beginMoveRows_protected(const ::QModelIndex & sourceParent, int sourceFirst, int sourceLast, const ::QModelIndex & destinationParent, int destinationRow) { return QAbstractItemModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow); }
    void beginRemoveColumns_protected(const ::QModelIndex & parent, int first, int last) { QAbstractItemModel::beginRemoveColumns(parent, first, last); }
    void beginRemoveRows_protected(const ::QModelIndex & parent, int first, int last) { QAbstractItemModel::beginRemoveRows(parent, first, last); }
    void beginResetModel_protected() { QAbstractItemModel::beginResetModel(); }
    ::QModelIndex buddy(const ::QModelIndex & index) const override;
    bool canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const override;
    bool canFetchMore(const ::QModelIndex & parent) const override;
    void changePersistentIndex_protected(const ::QModelIndex & from, const ::QModelIndex & to) { QAbstractItemModel::changePersistentIndex(from, to); }
    void changePersistentIndexList_protected(const ::QList<QModelIndex> & from, const ::QList<QModelIndex> & to) { QAbstractItemModel::changePersistentIndexList(from, to); }
    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    bool clearItemData(const ::QModelIndex & index) override;
    int columnCount(const ::QModelIndex & parent = QModelIndex()) const override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QModelIndex createIndex_protected(int row, int column, const void * data = nullptr) const { return QAbstractItemModel::createIndex(row, column, data); }
    ::QModelIndex createIndex_protected(int row, int column, ::quintptr id) const { return QAbstractItemModel::createIndex(row, column, id); }
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    ::QVariant data(const ::QModelIndex & index, int role = Qt::DisplayRole) const override;
    static ::QVariant sbk_o_data(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, int role = Qt::DisplayRole);
    bool decodeData_protected(int row, int column, const ::QModelIndex & parent, ::QDataStream & stream) { return QAbstractItemModel::decodeData(row, column, parent, stream); }
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) override;
    void encodeData_protected(const ::QList<QModelIndex> & indexes, ::QDataStream & stream) const { QAbstractItemModel::encodeData(indexes, stream); }
    void endInsertColumns_protected() { QAbstractItemModel::endInsertColumns(); }
    void endInsertRows_protected() { QAbstractItemModel::endInsertRows(); }
    void endMoveColumns_protected() { QAbstractItemModel::endMoveColumns(); }
    void endMoveRows_protected() { QAbstractItemModel::endMoveRows(); }
    void endRemoveColumns_protected() { QAbstractItemModel::endRemoveColumns(); }
    void endRemoveRows_protected() { QAbstractItemModel::endRemoveRows(); }
    void endResetModel_protected() { QAbstractItemModel::endResetModel(); }
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void fetchMore(const ::QModelIndex & parent) override;
    ::QFlags<Qt::ItemFlag> flags(const ::QModelIndex & index) const override;
    bool hasChildren(const ::QModelIndex & parent = QModelIndex()) const override;
    ::QVariant headerData(int section, ::Qt::Orientation orientation, int role = Qt::DisplayRole) const override;
    ::QModelIndex index(int row, int column, const ::QModelIndex & parent = QModelIndex()) const override;
    bool insertColumns(int column, int count, const ::QModelIndex & parent = QModelIndex()) override;
    bool insertRows(int row, int count, const ::QModelIndex & parent = QModelIndex()) override;
    ::QMap<int,QVariant> itemData(const ::QModelIndex & index) const override;
    ::QList<QModelIndex> match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits = 1, ::QFlags<Qt::MatchFlag> flags = Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)) const override;
    ::QMimeData * mimeData(const ::QList<QModelIndex> & indexes) const override;
    static ::QMimeData * sbk_o_mimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QList<QModelIndex> & indexes);
    ::QStringList mimeTypes() const override;
    bool moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild) override;
    bool moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild) override;
    void multiData(const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan) const override;
    ::QModelIndex parent(const ::QModelIndex & child) const override;
    ::QList<QModelIndex> persistentIndexList_protected() const { return QAbstractItemModel::persistentIndexList(); }
    bool removeColumns(int column, int count, const ::QModelIndex & parent = QModelIndex()) override;
    bool removeRows(int row, int count, const ::QModelIndex & parent = QModelIndex()) override;
    void resetInternalData_protected() { QAbstractItemModel::resetInternalData(); }
    void resetInternalData() override;
    void revert() override;
    ::QHash<int,QByteArray> roleNames() const override;
    int rowCount(const ::QModelIndex & parent = QModelIndex()) const override;
    bool setData(const ::QModelIndex & index, const ::QVariant & value, int role = Qt::EditRole) override;
    bool setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role = Qt::EditRole) override;
    bool setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant> & roles) override;
    ::QModelIndex sibling(int row, int column, const ::QModelIndex & idx) const override;
    void sort(int column, ::Qt::SortOrder order = Qt::AscendingOrder) override;
    ::QSize span(const ::QModelIndex & index) const override;
    bool submit() override;
    ::QFlags<Qt::DropAction> supportedDragActions() const override;
    ::QFlags<Qt::DropAction> supportedDropActions() const override;
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 44> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QABSTRACTITEMMODELWRAPPER_H

#  ifndef SBK_QOBJECTWRAPPER_H
#  define SBK_QOBJECTWRAPPER_H

// Inherited base class:
class QObjectWrapper : public QObject
{
public:
    QObjectWrapper(::QObject * parent = nullptr);
    QObjectWrapper(const QObjectWrapper &) = delete;
    QObjectWrapper& operator=(const QObjectWrapper &) = delete;
    QObjectWrapper(QObjectWrapper &&) = delete;
    QObjectWrapper& operator=(QObjectWrapper &&) = delete;
    ~QObjectWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    bool isSignalConnected_protected(const ::QMetaMethod & signal) const { return QObject::isSignalConnected(signal); }
    int receivers_protected(const char * signal) const { return QObject::receivers(signal); }
    ::QObject * sender_protected() const { return QObject::sender(); }
    int senderSignalIndex_protected() const { return QObject::senderSignalIndex(); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QOBJECTWRAPPER_H

#endif // SBK_BOOKMARKSMODELWRAPPER_H
