
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "autofill_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_AutoFill_Type = nullptr;
static PyTypeObject *Sbk_AutoFill_TypeF(void)
{
    return _Sbk_AutoFill_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void AutoFillWrapper::pysideInitQtMetaTypes()
{
}

void AutoFillWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

AutoFillWrapper::AutoFillWrapper(::QObject * parent) : AutoFill(parent)
{
}

void AutoFillWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoFill_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("AutoFill", funcName, gil, pyOverride, event);
}

void AutoFillWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoFill_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("AutoFill", funcName, gil, pyOverride, signal);
}

void AutoFillWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoFill_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("AutoFill", funcName, gil, pyOverride, event);
}

void AutoFillWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoFill_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("AutoFill", funcName, gil, pyOverride, signal);
}

bool AutoFillWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoFill_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("AutoFill", funcName, gil, pyOverride, event);
}

bool AutoFillWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoFill_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("AutoFill", funcName, gil, pyOverride, watched, event);
}

void AutoFillWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoFill_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("AutoFill", funcName, gil, pyOverride, event);
}

const QMetaObject *AutoFillWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return AutoFill::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int AutoFillWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = AutoFill::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *AutoFillWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< AutoFillWrapper *>(this));
    }
    return AutoFill::qt_metacast(_clname);
}

AutoFillWrapper::~AutoFillWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_AutoFill_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_AutoFill_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::AutoFill >()))
        return -1;

    AutoFillWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:AutoFill", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: AutoFill::AutoFill(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // AutoFill(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // AutoFill(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // AutoFill(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) AutoFillWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new AutoFillWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< AutoFill >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);
    };


    return 1;
}

static PyObject *Sbk_AutoFillFunc_addEntry(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addEntry", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: AutoFill::addEntry(QUrl,PageFormData)
    // 1: AutoFill::addEntry(QUrl,QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            overloadId = 1; // addEntry(QUrl,QString,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addEntry(QUrl,PageFormData)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addEntry", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addEntry(const QUrl &url, const PageFormData &formData)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::PageFormData cppArg1_local;
            ::PageFormData *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (Shiboken::Errors::occurred() == nullptr) {
                // addEntry(QUrl,PageFormData)
                cppSelf->addEntry(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // addEntry(const QUrl &url, const QString &name, const QString &pass)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addEntry(QUrl,QString,QString)
                cppSelf->addEntry(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AutoFillFunc_blockStoringforUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AutoFill::blockStoringforUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // blockStoringforUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "blockStoringforUrl", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // blockStoringforUrl(QUrl)
            cppSelf->blockStoringforUrl(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AutoFillFunc_completePage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "completePage", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: AutoFill::completePage(WebPage*,QUrl)->QStringList
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))) {
        overloadId = 0; // completePage(WebPage*,QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "completePage", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // completePage(WebPage*,QUrl)
            QStringList cppResult = cppSelf->completePage(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_exportPasswords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // exportPasswords()
        QByteArray cppResult = cppSelf->exportPasswords();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_getAllFormData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAllFormData()
        QList<PasswordEntry> cppResult = cppSelf->getAllFormData();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_getFormData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AutoFill::getFormData(QUrl)->QList<PasswordEntry>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // getFormData(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getFormData", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getFormData(QUrl)
            QList<PasswordEntry> cppResult = cppSelf->getFormData(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_importPasswords(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AutoFill::importPasswords(QByteArray)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // importPasswords(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "importPasswords", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // importPasswords(QByteArray)
            bool cppResult = cppSelf->importPasswords(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_isStored(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AutoFill::isStored(QUrl)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // isStored(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isStored", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // isStored(QUrl)
            bool cppResult = cppSelf->isStored(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_isStoringEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AutoFill::isStoringEnabled(QUrl)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // isStoringEnabled(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isStoringEnabled", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // isStoringEnabled(QUrl)
            bool cppResult = cppSelf->isStoringEnabled(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AutoFillFunc_passwordManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // passwordManager()const
        PasswordManager * cppResult = const_cast<const AutoFillWrapper *>(cppSelf)->passwordManager();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_removeAllEntries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // removeAllEntries()
        cppSelf->removeAllEntries();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AutoFillFunc_removeEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AutoFill::removeEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // removeEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeEntry", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // removeEntry(PasswordEntry)
            cppSelf->removeEntry(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AutoFillFunc_saveForm(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "saveForm", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: AutoFill::saveForm(WebPage*,QUrl,PageFormData)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PageFormData_IDX]), (pyArgs[2])))) {
        overloadId = 0; // saveForm(WebPage*,QUrl,PageFormData)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "saveForm", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::PageFormData cppArg2_local;
        ::PageFormData *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2].isValue())
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (Shiboken::Errors::occurred() == nullptr) {
            // saveForm(WebPage*,QUrl,PageFormData)
            cppSelf->saveForm(cppArg0, *cppArg1, *cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AutoFillFunc_updateEntry(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    if (numArgs == 2)
        return Shiboken::returnWrongArguments(args, "updateEntry", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    if (PyArg_UnpackTuple(args, "updateEntry", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: AutoFill::updateEntry(PasswordEntry)->bool
    // 1: AutoFill::updateEntry(QUrl,QString,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 1; // updateEntry(QUrl,QString,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArgs[0])))) {
        overloadId = 0; // updateEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "updateEntry", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // updateEntry(const PasswordEntry &entry)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::PasswordEntry cppArg0_local;
            ::PasswordEntry *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // updateEntry(PasswordEntry)
                bool cppResult = cppSelf->updateEntry(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // updateEntry(const QUrl &url, const QString &name, const QString &pass)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // updateEntry(QUrl,QString,QString)
                cppSelf->updateEntry(*cppArg0, cppArg1, cppArg2);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_AutoFillFunc_updateLastUsed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoFillWrapper *>(reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AutoFill::updateLastUsed(PasswordEntry&)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // updateLastUsed(PasswordEntry&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "updateLastUsed", errInfo, SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // updateLastUsed(PasswordEntry&)
            cppSelf->updateLastUsed(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_AutoFill_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_AutoFill_methods[] = {
    {"addEntry", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_addEntry), METH_VARARGS, nullptr},
    {"blockStoringforUrl", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_blockStoringforUrl), METH_O, nullptr},
    {"completePage", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_completePage), METH_VARARGS, nullptr},
    {"exportPasswords", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_exportPasswords), METH_NOARGS, nullptr},
    {"getAllFormData", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_getAllFormData), METH_NOARGS, nullptr},
    {"getFormData", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_getFormData), METH_O, nullptr},
    {"importPasswords", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_importPasswords), METH_O, nullptr},
    {"isStored", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_isStored), METH_O, nullptr},
    {"isStoringEnabled", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_isStoringEnabled), METH_O, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_loadSettings), METH_NOARGS, nullptr},
    {"passwordManager", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_passwordManager), METH_NOARGS, nullptr},
    {"removeAllEntries", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_removeAllEntries), METH_NOARGS, nullptr},
    {"removeEntry", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_removeEntry), METH_O, nullptr},
    {"saveForm", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_saveForm), METH_VARARGS, nullptr},
    {"updateEntry", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_updateEntry), METH_VARARGS, nullptr},
    {"updateLastUsed", reinterpret_cast<PyCFunction>(Sbk_AutoFillFunc_updateLastUsed), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_AutoFill_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::AutoFill *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<AutoFillWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_AutoFill_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_AutoFill_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_AutoFill_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_AutoFill_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_AutoFill_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_AutoFill_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_AutoFill_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_AutoFill_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_AutoFill_spec = {
    "1:PyFalkon.AutoFill",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_AutoFill_slots
};

} //extern "C"

static void *Sbk_AutoFill_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::AutoFill *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void AutoFill_PythonToCpp_AutoFill_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_AutoFill_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_AutoFill_PythonToCpp_AutoFill_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_AutoFill_TypeF()))
        return AutoFill_PythonToCpp_AutoFill_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *AutoFill_PTR_CppToPython_AutoFill(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::AutoFill *>(const_cast<void *>(cppIn)), Sbk_AutoFill_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *AutoFill_SignatureStrings[] = {
    "PyFalkon.AutoFill(self,parent:PySide6.QtCore.QObject=nullptr)",
    "1:PyFalkon.AutoFill.addEntry(self,url:typing.Union[PySide6.QtCore.QUrl, QString],formData:PyFalkon.PageFormData)",
    "0:PyFalkon.AutoFill.addEntry(self,url:typing.Union[PySide6.QtCore.QUrl, QString],name:QString,pass:QString)",
    "PyFalkon.AutoFill.blockStoringforUrl(self,url:typing.Union[PySide6.QtCore.QUrl, QString])",
    "PyFalkon.AutoFill.completePage(self,page:PyFalkon.WebPage,frameUrl:typing.Union[PySide6.QtCore.QUrl, QString])->QStringList",
    "PyFalkon.AutoFill.exportPasswords(self)->PySide6.QtCore.QByteArray",
    "PyFalkon.AutoFill.getAllFormData(self)->QList[PyFalkon.PasswordEntry]",
    "PyFalkon.AutoFill.getFormData(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->QList[PyFalkon.PasswordEntry]",
    "PyFalkon.AutoFill.importPasswords(self,data:typing.Union[PySide6.QtCore.QByteArray, char*])->bool",
    "PyFalkon.AutoFill.isStored(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->bool",
    "PyFalkon.AutoFill.isStoringEnabled(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->bool",
    "PyFalkon.AutoFill.loadSettings(self)",
    "PyFalkon.AutoFill.passwordManager(self)->PyFalkon.PasswordManager",
    "PyFalkon.AutoFill.removeAllEntries(self)",
    "PyFalkon.AutoFill.removeEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.AutoFill.saveForm(self,page:PyFalkon.WebPage,frameUrl:typing.Union[PySide6.QtCore.QUrl, QString],formData:PyFalkon.PageFormData)",
    "1:PyFalkon.AutoFill.updateEntry(self,entry:PyFalkon.PasswordEntry)->bool",
    "0:PyFalkon.AutoFill.updateEntry(self,url:typing.Union[PySide6.QtCore.QUrl, QString],name:QString,pass:QString)",
    "PyFalkon.AutoFill.updateLastUsed(self,data:PyFalkon.PasswordEntry)",
    nullptr}; // Sentinel
#else
static constexpr size_t AutoFill_SignatureByteSize = 397;
static constexpr uint8_t AutoFill_SignatureBytes[397] = {
    0x78, 0xda, 0xb5, 0x54, 0x41, 0x4f, 0xc2, 0x30, 0x18, 0xbd, 0xf3, 0x2b, 0x38, 0x8a, 0x99, 0x0b,
    0x5e, 0x3c, 0x2c, 0xd1, 0x04, 0x15, 0x4e, 0x18, 0xb7, 0x2c, 0x8b, 0x07, 0xc2, 0xa1, 0x5b, 0x3f,
    0xe6, 0xa4, 0x6b, 0x97, 0xf6, 0x1b, 0xba, 0x7f, 0x6f, 0xcb, 0x36, 0x81, 0x51, 0x11, 0x08, 0xde,
    0xd6, 0xf5, 0xeb, 0x7b, 0x7d, 0xdf, 0x7b, 0xfd, 0xfc, 0x6a, 0x42, 0xd8, 0x52, 0x70, 0x77, 0x54,
    0xa2, 0x98, 0x64, 0x8c, 0x5d, 0x29, 0x60, 0x0b, 0xa7, 0x20, 0x12, 0x38, 0x7a, 0x7e, 0x15, 0x66,
    0x14, 0xee, 0xdc, 0x00, 0x9f, 0x84, 0x04, 0x37, 0x78, 0x8d, 0x3f, 0x20, 0xc1, 0x7b, 0x5e, 0x32,
    0x56, 0xa0, 0x1c, 0xf4, 0x6e, 0x75, 0x45, 0xe7, 0xbc, 0x4b, 0x28, 0x1d, 0x73, 0x94, 0x55, 0x0d,
    0x54, 0x4a, 0xe6, 0x61, 0x55, 0x64, 0x3c, 0x75, 0x23, 0x9e, 0x09, 0x3e, 0xeb, 0x42, 0x46, 0x92,
    0x39, 0xfd, 0x20, 0x44, 0xa9, 0x4b, 0xe6, 0xce, 0x42, 0xc8, 0xfc, 0x99, 0x20, 0xd9, 0xe0, 0xfa,
    0x24, 0x85, 0x49, 0xf3, 0x77, 0xd0, 0x1b, 0x5e, 0x9a, 0x90, 0x93, 0x1c, 0xbc, 0x66, 0xa5, 0x55,
    0x2b, 0xd5, 0x2e, 0x06, 0xbd, 0x7d, 0xa6, 0x98, 0x89, 0x64, 0x19, 0xa2, 0x30, 0xfb, 0xfa, 0xa6,
    0x1a, 0xe9, 0x1c, 0x4e, 0x1b, 0x72, 0x22, 0xf2, 0x82, 0x01, 0x82, 0x51, 0xdb, 0x3a, 0x90, 0xc2,
    0x46, 0xec, 0x1b, 0xc4, 0x66, 0xcb, 0x59, 0x48, 0x7d, 0xdf, 0xe8, 0x34, 0xba, 0x9b, 0x87, 0xe6,
    0x73, 0x9a, 0x29, 0xb4, 0x70, 0xc3, 0x57, 0x21, 0x24, 0xfa, 0x5a, 0xfb, 0xa7, 0x90, 0x54, 0xad,
    0xe9, 0xf5, 0xa1, 0x2e, 0xe8, 0x63, 0x85, 0x30, 0x92, 0x92, 0x54, 0x16, 0x88, 0x14, 0x70, 0xc4,
    0x58, 0x6b, 0x53, 0x8b, 0x10, 0x18, 0xc2, 0xd9, 0x96, 0x93, 0x35, 0xc3, 0xda, 0xac, 0xb9, 0x1d,
    0x65, 0x07, 0xe2, 0xd4, 0xbe, 0x9e, 0xce, 0x98, 0xe5, 0xfb, 0xd2, 0x1d, 0x6a, 0xf2, 0x77, 0x90,
    0xf6, 0xa7, 0x15, 0x4e, 0x3f, 0x79, 0x27, 0xf2, 0xda, 0x50, 0xc7, 0x42, 0x30, 0x1b, 0x83, 0x32,
    0x79, 0x01, 0x7a, 0xa6, 0xa0, 0x83, 0xa8, 0xba, 0x66, 0xcc, 0x49, 0xcc, 0x2e, 0x8d, 0xce, 0x04,
    0xa1, 0x21, 0x20, 0xea, 0xaa, 0x26, 0x0d, 0x96, 0xa2, 0xa2, 0x69, 0xda, 0x0b, 0xe1, 0x3a, 0x98,
    0x72, 0x93, 0x9a, 0x4e, 0xef, 0x9b, 0x7d, 0x0b, 0x82, 0x84, 0x5c, 0xac, 0x40, 0xe7, 0xc6, 0xd8,
    0x93, 0xc1, 0xef, 0x54, 0x75, 0xe1, 0xd6, 0x1b, 0x07, 0xf3, 0xe9, 0xd9, 0x6d, 0xb6, 0x01, 0x28,
    0xb2, 0x5a, 0xcf, 0x90, 0x0b, 0xbf, 0xac, 0x3f, 0xa7, 0x95, 0x6d, 0x3c, 0x96, 0x85, 0xce, 0xd7,
    0xd1, 0x62, 0x1a, 0x8f, 0x86, 0xc7, 0x00, 0xfd, 0xe7, 0xe4, 0xab, 0xc9, 0xa6, 0x44, 0x61, 0xa4,
    0xda, 0xb8, 0xd1, 0x8e, 0xf2, 0x1d, 0x13, 0xbe, 0x01, 0x09, 0xc7, 0x52, 0x89
};
#endif

PyTypeObject *init_AutoFill(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_AutoFill_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_AutoFill_IDX].type;

    Shiboken::AutoDecRef Sbk_AutoFill_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_AutoFill_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "AutoFill",
        "AutoFill*",
        &Sbk_AutoFill_spec,
        &Shiboken::callCppDestructor< AutoFill >,
        Sbk_AutoFill_Type_bases.object(),
        0);
    auto *pyType = _Sbk_AutoFill_Type; // references _Sbk_AutoFill_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, AutoFill_SignatureStrings);
#else
    InitSignatureBytes(pyType, AutoFill_SignatureBytes, AutoFill_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_AutoFill_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_AutoFill_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        AutoFill_PythonToCpp_AutoFill_PTR,
        is_AutoFill_PythonToCpp_AutoFill_PTR_Convertible,
        AutoFill_PTR_CppToPython_AutoFill);

    Shiboken::Conversions::registerConverterName(converter, "AutoFill");
    Shiboken::Conversions::registerConverterName(converter, "AutoFill*");
    Shiboken::Conversions::registerConverterName(converter, "AutoFill&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::AutoFill).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(AutoFillWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_AutoFill_TypeF(), &Sbk_AutoFill_typeDiscovery);

    AutoFillWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::AutoFill::staticMetaObject, sizeof(AutoFillWrapper));

    return pyType;
}
