#ifndef SBK_MAINAPPLICATIONWRAPPER_H
#define SBK_MAINAPPLICATIONWRAPPER_H

#include <mainapplication.h>


// Argument includes
#include <QList>
#include <QString>
#include <autofill.h>
#include <bookmarks.h>
#include <browserwindow.h>
#include <cookiejar.h>
#include <desktopnotificationsfactory.h>
#include <downloadmanager.h>
#include <history.h>
#include <mainapplication.h>
#include <networkmanager.h>
#include <pluginproxy.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qurl.h>
#include <qwebenginedownloadrequest.h>
#include <qwebengineprofile.h>
#include <qwebenginesettings.h>
#include <qzcommon.h>
#include <searchenginesmanager.h>
#include <sitesettingsmanager.h>
#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class MainApplicationWrapper : public MainApplication
{
public:
    MainApplicationWrapper(const MainApplicationWrapper &) = delete;
    MainApplicationWrapper& operator=(const MainApplicationWrapper &) = delete;
    MainApplicationWrapper(MainApplicationWrapper &&) = delete;
    MainApplicationWrapper& operator=(MainApplicationWrapper &&) = delete;
    ~MainApplicationWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event_protected(::QEvent * arg__1) { return QApplication::event(arg__1); }
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool notify(::QObject * arg__1, ::QEvent * arg__2) override;
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 8> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  ifndef SBK_QAPPLICATIONWRAPPER_H
#  define SBK_QAPPLICATIONWRAPPER_H

// Inherited base class:
class QApplicationWrapper : public QApplication
{
public:
    QApplicationWrapper(int & argc, char ** argv, int arg__3 = QCoreApplication::ApplicationFlags);
    QApplicationWrapper(const QApplicationWrapper &) = delete;
    QApplicationWrapper& operator=(const QApplicationWrapper &) = delete;
    QApplicationWrapper(QApplicationWrapper &&) = delete;
    QApplicationWrapper& operator=(QApplicationWrapper &&) = delete;
    ~QApplicationWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event_protected(::QEvent * arg__1) { return QApplication::event(arg__1); }
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool notify(::QObject * arg__1, ::QEvent * arg__2) override;
    static bool sbk_o_notify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * arg__1, ::QEvent * arg__2);
    void * resolveInterface_protected(const char * name, int revision) const { return QApplication::resolveInterface(name, revision); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 8> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QAPPLICATIONWRAPPER_H

#  ifndef SBK_QGUIAPPLICATIONWRAPPER_H
#  define SBK_QGUIAPPLICATIONWRAPPER_H

// Inherited base class:
class QGuiApplicationWrapper : public QGuiApplication
{
public:
    QGuiApplicationWrapper(int & argc, char ** argv, int arg__3 = QCoreApplication::ApplicationFlags);
    QGuiApplicationWrapper(const QGuiApplicationWrapper &) = delete;
    QGuiApplicationWrapper& operator=(const QGuiApplicationWrapper &) = delete;
    QGuiApplicationWrapper(QGuiApplicationWrapper &&) = delete;
    QGuiApplicationWrapper& operator=(QGuiApplicationWrapper &&) = delete;
    ~QGuiApplicationWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event_protected(::QEvent * arg__1) { return QGuiApplication::event(arg__1); }
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool notify(::QObject * arg__1, ::QEvent * arg__2) override;
    static bool sbk_o_notify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * arg__1, ::QEvent * arg__2);
    void * resolveInterface_protected(const char * name, int revision) const { return QGuiApplication::resolveInterface(name, revision); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 8> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QGUIAPPLICATIONWRAPPER_H

#  ifndef SBK_QCOREAPPLICATIONWRAPPER_H
#  define SBK_QCOREAPPLICATIONWRAPPER_H

// Inherited base class:
class QCoreApplicationWrapper : public QCoreApplication
{
public:
    QCoreApplicationWrapper(int & argc, char ** argv, int arg__3 = QCoreApplication::ApplicationFlags);
    QCoreApplicationWrapper(const QCoreApplicationWrapper &) = delete;
    QCoreApplicationWrapper& operator=(const QCoreApplicationWrapper &) = delete;
    QCoreApplicationWrapper(QCoreApplicationWrapper &&) = delete;
    QCoreApplicationWrapper& operator=(QCoreApplicationWrapper &&) = delete;
    ~QCoreApplicationWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event_protected(::QEvent * arg__1) { return QCoreApplication::event(arg__1); }
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool notify(::QObject * arg__1, ::QEvent * arg__2) override;
    static bool sbk_o_notify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * arg__1, ::QEvent * arg__2);
    void * resolveInterface_protected(const char * name, int revision) const { return QCoreApplication::resolveInterface(name, revision); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 8> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QCOREAPPLICATIONWRAPPER_H

#  ifndef SBK_QOBJECTWRAPPER_H
#  define SBK_QOBJECTWRAPPER_H

// Inherited base class:
class QObjectWrapper : public QObject
{
public:
    QObjectWrapper(::QObject * parent = nullptr);
    QObjectWrapper(const QObjectWrapper &) = delete;
    QObjectWrapper& operator=(const QObjectWrapper &) = delete;
    QObjectWrapper(QObjectWrapper &&) = delete;
    QObjectWrapper& operator=(QObjectWrapper &&) = delete;
    ~QObjectWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    bool isSignalConnected_protected(const ::QMetaMethod & signal) const { return QObject::isSignalConnected(signal); }
    int receivers_protected(const char * signal) const { return QObject::receivers(signal); }
    ::QObject * sender_protected() const { return QObject::sender(); }
    int senderSignalIndex_protected() const { return QObject::senderSignalIndex(); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QOBJECTWRAPPER_H

#endif // SBK_MAINAPPLICATIONWRAPPER_H
