/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/protocol/http/nsIHttpChannel.idl
 */

#ifndef __gen_nsIHttpChannel_h__
#define __gen_nsIHttpChannel_h__


#include "nsIChannel.h"

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Assertions.h"
#include "mozilla/DebugOnly.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIHttpHeaderVisitor; /* forward declaration */

class nsIReferrerInfo; /* forward declaration */

#include "GeckoProfiler.h"
namespace mozilla::net {
class DictionaryCacheEntry;
}

/* starting interface:    nsIHttpChannel */
#define NS_IHTTPCHANNEL_IID_STR "c5a4a073-4539-49c7-a3f2-cec3f0619c6c"

#define NS_IHTTPCHANNEL_IID \
  {0xc5a4a073, 0x4539, 0x49c7, \
    { 0xa3, 0xf2, 0xce, 0xc3, 0xf0, 0x61, 0x9c, 0x6c }}

class NS_NO_VTABLE nsIHttpChannel : public nsIIdentChannel {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IHTTPCHANNEL_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIHttpChannel;

  /* [must_use] attribute ACString requestMethod; */
  [[nodiscard]] NS_IMETHOD GetRequestMethod(nsACString& aRequestMethod) = 0;
  [[nodiscard]] NS_IMETHOD SetRequestMethod(const nsACString& aRequestMethod) = 0;

  /* [infallible,must_use] attribute nsIReferrerInfo referrerInfo; */
  [[nodiscard]] NS_IMETHOD GetReferrerInfo(nsIReferrerInfo **aReferrerInfo) = 0;
  [[nodiscard]]  inline already_AddRefed<nsIReferrerInfo> GetReferrerInfo()
  {
    nsIReferrerInfo* result = nullptr;
    mozilla::DebugOnly<nsresult> rv = GetReferrerInfo(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return already_AddRefed<nsIReferrerInfo>(result);
  }
  [[nodiscard]] NS_IMETHOD SetReferrerInfo(nsIReferrerInfo *aReferrerInfo) = 0;

  /* [must_use,noscript] void setReferrerInfoWithoutClone (in nsIReferrerInfo aReferrerInfo); */
  [[nodiscard]] NS_IMETHOD SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo) = 0;

  /* [must_use] readonly attribute ACString protocolVersion; */
  [[nodiscard]] NS_IMETHOD GetProtocolVersion(nsACString& aProtocolVersion) = 0;

  /* [must_use] readonly attribute uint64_t transferSize; */
  [[nodiscard]] NS_IMETHOD GetTransferSize(uint64_t *aTransferSize) = 0;

  /* [must_use] readonly attribute uint64_t requestSize; */
  [[nodiscard]] NS_IMETHOD GetRequestSize(uint64_t *aRequestSize) = 0;

  /* [must_use] readonly attribute uint64_t decodedBodySize; */
  [[nodiscard]] NS_IMETHOD GetDecodedBodySize(uint64_t *aDecodedBodySize) = 0;

  /* [must_use] readonly attribute uint64_t encodedBodySize; */
  [[nodiscard]] NS_IMETHOD GetEncodedBodySize(uint64_t *aEncodedBodySize) = 0;

  /* [must_use] ACString getRequestHeader (in ACString aHeader); */
  [[nodiscard]] NS_IMETHOD GetRequestHeader(const nsACString& aHeader, nsACString& _retval) = 0;

  /* [must_use] void setRequestHeader (in ACString aHeader, in ACString aValue, in boolean aMerge); */
  [[nodiscard]] NS_IMETHOD SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge) = 0;

  /* [must_use] void setNewReferrerInfo (in ACString aUrl, in nsIReferrerInfo_ReferrerPolicyIDL aPolicy, in boolean aSendReferrer); */
  [[nodiscard]] NS_IMETHOD SetNewReferrerInfo(const nsACString& aUrl, nsIReferrerInfo::ReferrerPolicyIDL aPolicy, bool aSendReferrer) = 0;

  /* [must_use] void setEmptyRequestHeader (in ACString aHeader); */
  [[nodiscard]] NS_IMETHOD SetEmptyRequestHeader(const nsACString& aHeader) = 0;

  /* [must_use] void visitRequestHeaders (in nsIHttpHeaderVisitor aVisitor); */
  [[nodiscard]] NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] void visitNonDefaultRequestHeaders (in nsIHttpHeaderVisitor aVisitor); */
  [[nodiscard]] NS_IMETHOD VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] boolean ShouldStripRequestBodyHeader (in ACString aMethod); */
  [[nodiscard]] NS_IMETHOD ShouldStripRequestBodyHeader(const nsACString& aMethod, bool *_retval) = 0;

  /* [must_use] attribute boolean allowSTS; */
  [[nodiscard]] NS_IMETHOD GetAllowSTS(bool *aAllowSTS) = 0;
  [[nodiscard]] NS_IMETHOD SetAllowSTS(bool aAllowSTS) = 0;

  /* [must_use] attribute unsigned long redirectionLimit; */
  [[nodiscard]] NS_IMETHOD GetRedirectionLimit(uint32_t *aRedirectionLimit) = 0;
  [[nodiscard]] NS_IMETHOD SetRedirectionLimit(uint32_t aRedirectionLimit) = 0;

  /* [must_use] readonly attribute unsigned long responseStatus; */
  [[nodiscard]] NS_IMETHOD GetResponseStatus(uint32_t *aResponseStatus) = 0;

  /* [must_use] readonly attribute ACString responseStatusText; */
  [[nodiscard]] NS_IMETHOD GetResponseStatusText(nsACString& aResponseStatusText) = 0;

  /* [must_use] readonly attribute boolean requestSucceeded; */
  [[nodiscard]] NS_IMETHOD GetRequestSucceeded(bool *aRequestSucceeded) = 0;

  /* [must_use] attribute boolean isMainDocumentChannel; */
  [[nodiscard]] NS_IMETHOD GetIsMainDocumentChannel(bool *aIsMainDocumentChannel) = 0;
  [[nodiscard]] NS_IMETHOD SetIsMainDocumentChannel(bool aIsMainDocumentChannel) = 0;

  /* [must_use] ACString getResponseHeader (in ACString header); */
  [[nodiscard]] NS_IMETHOD GetResponseHeader(const nsACString& header, nsACString& _retval) = 0;

  /* [must_use] void setResponseHeader (in ACString header, in ACString value, in boolean merge); */
  [[nodiscard]] NS_IMETHOD SetResponseHeader(const nsACString& header, const nsACString& value, bool merge) = 0;

  /* [must_use] void visitResponseHeaders (in nsIHttpHeaderVisitor aVisitor); */
  [[nodiscard]] NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] void getOriginalResponseHeader (in ACString aHeader, in nsIHttpHeaderVisitor aVisitor); */
  [[nodiscard]] NS_IMETHOD GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] void visitOriginalResponseHeaders (in nsIHttpHeaderVisitor aVisitor); */
  [[nodiscard]] NS_IMETHOD VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] boolean isNoStoreResponse (); */
  [[nodiscard]] NS_IMETHOD IsNoStoreResponse(bool *_retval) = 0;

  /* [must_use] boolean isNoCacheResponse (); */
  [[nodiscard]] NS_IMETHOD IsNoCacheResponse(bool *_retval) = 0;

  /* [must_use] void redirectTo (in nsIURI aTargetURI); */
  [[nodiscard]] NS_IMETHOD RedirectTo(nsIURI *aTargetURI) = 0;

  /* [must_use] void upgradeToSecure (); */
  [[nodiscard]] NS_IMETHOD UpgradeToSecure(void) = 0;

  /* [must_use,noscript] attribute uint64_t requestContextID; */
  [[nodiscard]] NS_IMETHOD GetRequestContextID(uint64_t *aRequestContextID) = 0;
  [[nodiscard]] NS_IMETHOD SetRequestContextID(uint64_t aRequestContextID) = 0;

  /* [must_use] attribute uint64_t topLevelContentWindowId; */
  [[nodiscard]] NS_IMETHOD GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId) = 0;
  [[nodiscard]] NS_IMETHOD SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId) = 0;

  /* [must_use] attribute uint64_t browserId; */
  [[nodiscard]] NS_IMETHOD GetBrowserId(uint64_t *aBrowserId) = 0;
  [[nodiscard]] NS_IMETHOD SetBrowserId(uint64_t aBrowserId) = 0;

  /* void logBlockedCORSRequest (in AString aMessage, in ACString aCategory, in boolean aIsWarning); */
  NS_IMETHOD LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory, bool aIsWarning) = 0;

  /* void logMimeTypeMismatch (in ACString aMessageName, in boolean aWarning, in AString aURL, in AString aContentType); */
  NS_IMETHOD LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType) = 0;

  /* [nostdcall,notxpcom] void setSource (in UniqueProfileChunkedBuffer aSource); */
  virtual void SetSource(mozilla::UniquePtr<mozilla::ProfileChunkedBuffer> aSource) = 0;

  /* [must_use] attribute AString classicScriptHintCharset; */
  [[nodiscard]] NS_IMETHOD GetClassicScriptHintCharset(nsAString& aClassicScriptHintCharset) = 0;
  [[nodiscard]] NS_IMETHOD SetClassicScriptHintCharset(const nsAString& aClassicScriptHintCharset) = 0;

  /* [must_use] attribute AString documentCharacterSet; */
  [[nodiscard]] NS_IMETHOD GetDocumentCharacterSet(nsAString& aDocumentCharacterSet) = 0;
  [[nodiscard]] NS_IMETHOD SetDocumentCharacterSet(const nsAString& aDocumentCharacterSet) = 0;

  /* [must_use] attribute boolean requestObserversCalled; */
  [[nodiscard]] NS_IMETHOD GetRequestObserversCalled(bool *aRequestObserversCalled) = 0;
  [[nodiscard]] NS_IMETHOD SetRequestObserversCalled(bool aRequestObserversCalled) = 0;

  /* [must_use,noscript] attribute boolean isUserAgentHeaderOutdated; */
  [[nodiscard]] NS_IMETHOD GetIsUserAgentHeaderOutdated(bool *aIsUserAgentHeaderOutdated) = 0;
  [[nodiscard]] NS_IMETHOD SetIsUserAgentHeaderOutdated(bool aIsUserAgentHeaderOutdated) = 0;

  /* [noscript] attribute DictionaryCacheEntry decompressDictionary; */
  NS_IMETHOD GetDecompressDictionary(mozilla::net::DictionaryCacheEntry * * aDecompressDictionary) = 0;
  NS_IMETHOD SetDecompressDictionary(mozilla::net::DictionaryCacheEntry * aDecompressDictionary) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPCHANNEL \
  [[nodiscard]] NS_IMETHOD GetRequestMethod(nsACString& aRequestMethod) override; \
  [[nodiscard]] NS_IMETHOD SetRequestMethod(const nsACString& aRequestMethod) override; \
  using nsIHttpChannel::GetReferrerInfo; \
  [[nodiscard]] NS_IMETHOD GetReferrerInfo(nsIReferrerInfo **aReferrerInfo) override; \
  [[nodiscard]] NS_IMETHOD SetReferrerInfo(nsIReferrerInfo *aReferrerInfo) override; \
  [[nodiscard]] NS_IMETHOD SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo) override; \
  [[nodiscard]] NS_IMETHOD GetProtocolVersion(nsACString& aProtocolVersion) override; \
  [[nodiscard]] NS_IMETHOD GetTransferSize(uint64_t *aTransferSize) override; \
  [[nodiscard]] NS_IMETHOD GetRequestSize(uint64_t *aRequestSize) override; \
  [[nodiscard]] NS_IMETHOD GetDecodedBodySize(uint64_t *aDecodedBodySize) override; \
  [[nodiscard]] NS_IMETHOD GetEncodedBodySize(uint64_t *aEncodedBodySize) override; \
  [[nodiscard]] NS_IMETHOD GetRequestHeader(const nsACString& aHeader, nsACString& _retval) override; \
  [[nodiscard]] NS_IMETHOD SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge) override; \
  [[nodiscard]] NS_IMETHOD SetNewReferrerInfo(const nsACString& aUrl, nsIReferrerInfo::ReferrerPolicyIDL aPolicy, bool aSendReferrer) override; \
  [[nodiscard]] NS_IMETHOD SetEmptyRequestHeader(const nsACString& aHeader) override; \
  [[nodiscard]] NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override; \
  [[nodiscard]] NS_IMETHOD VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override; \
  [[nodiscard]] NS_IMETHOD ShouldStripRequestBodyHeader(const nsACString& aMethod, bool *_retval) override; \
  [[nodiscard]] NS_IMETHOD GetAllowSTS(bool *aAllowSTS) override; \
  [[nodiscard]] NS_IMETHOD SetAllowSTS(bool aAllowSTS) override; \
  [[nodiscard]] NS_IMETHOD GetRedirectionLimit(uint32_t *aRedirectionLimit) override; \
  [[nodiscard]] NS_IMETHOD SetRedirectionLimit(uint32_t aRedirectionLimit) override; \
  [[nodiscard]] NS_IMETHOD GetResponseStatus(uint32_t *aResponseStatus) override; \
  [[nodiscard]] NS_IMETHOD GetResponseStatusText(nsACString& aResponseStatusText) override; \
  [[nodiscard]] NS_IMETHOD GetRequestSucceeded(bool *aRequestSucceeded) override; \
  [[nodiscard]] NS_IMETHOD GetIsMainDocumentChannel(bool *aIsMainDocumentChannel) override; \
  [[nodiscard]] NS_IMETHOD SetIsMainDocumentChannel(bool aIsMainDocumentChannel) override; \
  [[nodiscard]] NS_IMETHOD GetResponseHeader(const nsACString& header, nsACString& _retval) override; \
  [[nodiscard]] NS_IMETHOD SetResponseHeader(const nsACString& header, const nsACString& value, bool merge) override; \
  [[nodiscard]] NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override; \
  [[nodiscard]] NS_IMETHOD GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor) override; \
  [[nodiscard]] NS_IMETHOD VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override; \
  [[nodiscard]] NS_IMETHOD IsNoStoreResponse(bool *_retval) override; \
  [[nodiscard]] NS_IMETHOD IsNoCacheResponse(bool *_retval) override; \
  [[nodiscard]] NS_IMETHOD RedirectTo(nsIURI *aTargetURI) override; \
  [[nodiscard]] NS_IMETHOD UpgradeToSecure(void) override; \
  [[nodiscard]] NS_IMETHOD GetRequestContextID(uint64_t *aRequestContextID) override; \
  [[nodiscard]] NS_IMETHOD SetRequestContextID(uint64_t aRequestContextID) override; \
  [[nodiscard]] NS_IMETHOD GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId) override; \
  [[nodiscard]] NS_IMETHOD SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId) override; \
  [[nodiscard]] NS_IMETHOD GetBrowserId(uint64_t *aBrowserId) override; \
  [[nodiscard]] NS_IMETHOD SetBrowserId(uint64_t aBrowserId) override; \
  NS_IMETHOD LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory, bool aIsWarning) override; \
  NS_IMETHOD LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType) override; \
  virtual void SetSource(mozilla::UniquePtr<mozilla::ProfileChunkedBuffer> aSource) override; \
  [[nodiscard]] NS_IMETHOD GetClassicScriptHintCharset(nsAString& aClassicScriptHintCharset) override; \
  [[nodiscard]] NS_IMETHOD SetClassicScriptHintCharset(const nsAString& aClassicScriptHintCharset) override; \
  [[nodiscard]] NS_IMETHOD GetDocumentCharacterSet(nsAString& aDocumentCharacterSet) override; \
  [[nodiscard]] NS_IMETHOD SetDocumentCharacterSet(const nsAString& aDocumentCharacterSet) override; \
  [[nodiscard]] NS_IMETHOD GetRequestObserversCalled(bool *aRequestObserversCalled) override; \
  [[nodiscard]] NS_IMETHOD SetRequestObserversCalled(bool aRequestObserversCalled) override; \
  [[nodiscard]] NS_IMETHOD GetIsUserAgentHeaderOutdated(bool *aIsUserAgentHeaderOutdated) override; \
  [[nodiscard]] NS_IMETHOD SetIsUserAgentHeaderOutdated(bool aIsUserAgentHeaderOutdated) override; \
  NS_IMETHOD GetDecompressDictionary(mozilla::net::DictionaryCacheEntry * * aDecompressDictionary) override; \
  NS_IMETHOD SetDecompressDictionary(mozilla::net::DictionaryCacheEntry * aDecompressDictionary) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIHTTPCHANNEL \
  [[nodiscard]] nsresult GetRequestMethod(nsACString& aRequestMethod); \
  [[nodiscard]] nsresult SetRequestMethod(const nsACString& aRequestMethod); \
  using nsIHttpChannel::GetReferrerInfo; \
  [[nodiscard]] nsresult GetReferrerInfo(nsIReferrerInfo **aReferrerInfo); \
  [[nodiscard]] nsresult SetReferrerInfo(nsIReferrerInfo *aReferrerInfo); \
  [[nodiscard]] nsresult SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo); \
  [[nodiscard]] nsresult GetProtocolVersion(nsACString& aProtocolVersion); \
  [[nodiscard]] nsresult GetTransferSize(uint64_t *aTransferSize); \
  [[nodiscard]] nsresult GetRequestSize(uint64_t *aRequestSize); \
  [[nodiscard]] nsresult GetDecodedBodySize(uint64_t *aDecodedBodySize); \
  [[nodiscard]] nsresult GetEncodedBodySize(uint64_t *aEncodedBodySize); \
  [[nodiscard]] nsresult GetRequestHeader(const nsACString& aHeader, nsACString& _retval); \
  [[nodiscard]] nsresult SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge); \
  [[nodiscard]] nsresult SetNewReferrerInfo(const nsACString& aUrl, nsIReferrerInfo::ReferrerPolicyIDL aPolicy, bool aSendReferrer); \
  [[nodiscard]] nsresult SetEmptyRequestHeader(const nsACString& aHeader); \
  [[nodiscard]] nsresult VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor); \
  [[nodiscard]] nsresult VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor); \
  [[nodiscard]] nsresult ShouldStripRequestBodyHeader(const nsACString& aMethod, bool *_retval); \
  [[nodiscard]] nsresult GetAllowSTS(bool *aAllowSTS); \
  [[nodiscard]] nsresult SetAllowSTS(bool aAllowSTS); \
  [[nodiscard]] nsresult GetRedirectionLimit(uint32_t *aRedirectionLimit); \
  [[nodiscard]] nsresult SetRedirectionLimit(uint32_t aRedirectionLimit); \
  [[nodiscard]] nsresult GetResponseStatus(uint32_t *aResponseStatus); \
  [[nodiscard]] nsresult GetResponseStatusText(nsACString& aResponseStatusText); \
  [[nodiscard]] nsresult GetRequestSucceeded(bool *aRequestSucceeded); \
  [[nodiscard]] nsresult GetIsMainDocumentChannel(bool *aIsMainDocumentChannel); \
  [[nodiscard]] nsresult SetIsMainDocumentChannel(bool aIsMainDocumentChannel); \
  [[nodiscard]] nsresult GetResponseHeader(const nsACString& header, nsACString& _retval); \
  [[nodiscard]] nsresult SetResponseHeader(const nsACString& header, const nsACString& value, bool merge); \
  [[nodiscard]] nsresult VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor); \
  [[nodiscard]] nsresult GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor); \
  [[nodiscard]] nsresult VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor); \
  [[nodiscard]] nsresult IsNoStoreResponse(bool *_retval); \
  [[nodiscard]] nsresult IsNoCacheResponse(bool *_retval); \
  [[nodiscard]] nsresult RedirectTo(nsIURI *aTargetURI); \
  [[nodiscard]] nsresult UpgradeToSecure(void); \
  [[nodiscard]] nsresult GetRequestContextID(uint64_t *aRequestContextID); \
  [[nodiscard]] nsresult SetRequestContextID(uint64_t aRequestContextID); \
  [[nodiscard]] nsresult GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId); \
  [[nodiscard]] nsresult SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId); \
  [[nodiscard]] nsresult GetBrowserId(uint64_t *aBrowserId); \
  [[nodiscard]] nsresult SetBrowserId(uint64_t aBrowserId); \
  nsresult LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory, bool aIsWarning); \
  nsresult LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType); \
  void SetSource(mozilla::UniquePtr<mozilla::ProfileChunkedBuffer> aSource); \
  [[nodiscard]] nsresult GetClassicScriptHintCharset(nsAString& aClassicScriptHintCharset); \
  [[nodiscard]] nsresult SetClassicScriptHintCharset(const nsAString& aClassicScriptHintCharset); \
  [[nodiscard]] nsresult GetDocumentCharacterSet(nsAString& aDocumentCharacterSet); \
  [[nodiscard]] nsresult SetDocumentCharacterSet(const nsAString& aDocumentCharacterSet); \
  [[nodiscard]] nsresult GetRequestObserversCalled(bool *aRequestObserversCalled); \
  [[nodiscard]] nsresult SetRequestObserversCalled(bool aRequestObserversCalled); \
  [[nodiscard]] nsresult GetIsUserAgentHeaderOutdated(bool *aIsUserAgentHeaderOutdated); \
  [[nodiscard]] nsresult SetIsUserAgentHeaderOutdated(bool aIsUserAgentHeaderOutdated); \
  nsresult GetDecompressDictionary(mozilla::net::DictionaryCacheEntry * * aDecompressDictionary); \
  nsresult SetDecompressDictionary(mozilla::net::DictionaryCacheEntry * aDecompressDictionary); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPCHANNEL(_to) \
  [[nodiscard]] NS_IMETHOD GetRequestMethod(nsACString& aRequestMethod) override { return _to GetRequestMethod(aRequestMethod); } \
  [[nodiscard]] NS_IMETHOD SetRequestMethod(const nsACString& aRequestMethod) override { return _to SetRequestMethod(aRequestMethod); } \
  using nsIHttpChannel::GetReferrerInfo; \
  [[nodiscard]] NS_IMETHOD GetReferrerInfo(nsIReferrerInfo **aReferrerInfo) override { return _to GetReferrerInfo(aReferrerInfo); } \
  [[nodiscard]] NS_IMETHOD SetReferrerInfo(nsIReferrerInfo *aReferrerInfo) override { return _to SetReferrerInfo(aReferrerInfo); } \
  [[nodiscard]] NS_IMETHOD SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo) override { return _to SetReferrerInfoWithoutClone(aReferrerInfo); } \
  [[nodiscard]] NS_IMETHOD GetProtocolVersion(nsACString& aProtocolVersion) override { return _to GetProtocolVersion(aProtocolVersion); } \
  [[nodiscard]] NS_IMETHOD GetTransferSize(uint64_t *aTransferSize) override { return _to GetTransferSize(aTransferSize); } \
  [[nodiscard]] NS_IMETHOD GetRequestSize(uint64_t *aRequestSize) override { return _to GetRequestSize(aRequestSize); } \
  [[nodiscard]] NS_IMETHOD GetDecodedBodySize(uint64_t *aDecodedBodySize) override { return _to GetDecodedBodySize(aDecodedBodySize); } \
  [[nodiscard]] NS_IMETHOD GetEncodedBodySize(uint64_t *aEncodedBodySize) override { return _to GetEncodedBodySize(aEncodedBodySize); } \
  [[nodiscard]] NS_IMETHOD GetRequestHeader(const nsACString& aHeader, nsACString& _retval) override { return _to GetRequestHeader(aHeader, _retval); } \
  [[nodiscard]] NS_IMETHOD SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge) override { return _to SetRequestHeader(aHeader, aValue, aMerge); } \
  [[nodiscard]] NS_IMETHOD SetNewReferrerInfo(const nsACString& aUrl, nsIReferrerInfo::ReferrerPolicyIDL aPolicy, bool aSendReferrer) override { return _to SetNewReferrerInfo(aUrl, aPolicy, aSendReferrer); } \
  [[nodiscard]] NS_IMETHOD SetEmptyRequestHeader(const nsACString& aHeader) override { return _to SetEmptyRequestHeader(aHeader); } \
  [[nodiscard]] NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override { return _to VisitRequestHeaders(aVisitor); } \
  [[nodiscard]] NS_IMETHOD VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override { return _to VisitNonDefaultRequestHeaders(aVisitor); } \
  [[nodiscard]] NS_IMETHOD ShouldStripRequestBodyHeader(const nsACString& aMethod, bool *_retval) override { return _to ShouldStripRequestBodyHeader(aMethod, _retval); } \
  [[nodiscard]] NS_IMETHOD GetAllowSTS(bool *aAllowSTS) override { return _to GetAllowSTS(aAllowSTS); } \
  [[nodiscard]] NS_IMETHOD SetAllowSTS(bool aAllowSTS) override { return _to SetAllowSTS(aAllowSTS); } \
  [[nodiscard]] NS_IMETHOD GetRedirectionLimit(uint32_t *aRedirectionLimit) override { return _to GetRedirectionLimit(aRedirectionLimit); } \
  [[nodiscard]] NS_IMETHOD SetRedirectionLimit(uint32_t aRedirectionLimit) override { return _to SetRedirectionLimit(aRedirectionLimit); } \
  [[nodiscard]] NS_IMETHOD GetResponseStatus(uint32_t *aResponseStatus) override { return _to GetResponseStatus(aResponseStatus); } \
  [[nodiscard]] NS_IMETHOD GetResponseStatusText(nsACString& aResponseStatusText) override { return _to GetResponseStatusText(aResponseStatusText); } \
  [[nodiscard]] NS_IMETHOD GetRequestSucceeded(bool *aRequestSucceeded) override { return _to GetRequestSucceeded(aRequestSucceeded); } \
  [[nodiscard]] NS_IMETHOD GetIsMainDocumentChannel(bool *aIsMainDocumentChannel) override { return _to GetIsMainDocumentChannel(aIsMainDocumentChannel); } \
  [[nodiscard]] NS_IMETHOD SetIsMainDocumentChannel(bool aIsMainDocumentChannel) override { return _to SetIsMainDocumentChannel(aIsMainDocumentChannel); } \
  [[nodiscard]] NS_IMETHOD GetResponseHeader(const nsACString& header, nsACString& _retval) override { return _to GetResponseHeader(header, _retval); } \
  [[nodiscard]] NS_IMETHOD SetResponseHeader(const nsACString& header, const nsACString& value, bool merge) override { return _to SetResponseHeader(header, value, merge); } \
  [[nodiscard]] NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override { return _to VisitResponseHeaders(aVisitor); } \
  [[nodiscard]] NS_IMETHOD GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor) override { return _to GetOriginalResponseHeader(aHeader, aVisitor); } \
  [[nodiscard]] NS_IMETHOD VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override { return _to VisitOriginalResponseHeaders(aVisitor); } \
  [[nodiscard]] NS_IMETHOD IsNoStoreResponse(bool *_retval) override { return _to IsNoStoreResponse(_retval); } \
  [[nodiscard]] NS_IMETHOD IsNoCacheResponse(bool *_retval) override { return _to IsNoCacheResponse(_retval); } \
  [[nodiscard]] NS_IMETHOD RedirectTo(nsIURI *aTargetURI) override { return _to RedirectTo(aTargetURI); } \
  [[nodiscard]] NS_IMETHOD UpgradeToSecure(void) override { return _to UpgradeToSecure(); } \
  [[nodiscard]] NS_IMETHOD GetRequestContextID(uint64_t *aRequestContextID) override { return _to GetRequestContextID(aRequestContextID); } \
  [[nodiscard]] NS_IMETHOD SetRequestContextID(uint64_t aRequestContextID) override { return _to SetRequestContextID(aRequestContextID); } \
  [[nodiscard]] NS_IMETHOD GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId) override { return _to GetTopLevelContentWindowId(aTopLevelContentWindowId); } \
  [[nodiscard]] NS_IMETHOD SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId) override { return _to SetTopLevelContentWindowId(aTopLevelContentWindowId); } \
  [[nodiscard]] NS_IMETHOD GetBrowserId(uint64_t *aBrowserId) override { return _to GetBrowserId(aBrowserId); } \
  [[nodiscard]] NS_IMETHOD SetBrowserId(uint64_t aBrowserId) override { return _to SetBrowserId(aBrowserId); } \
  NS_IMETHOD LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory, bool aIsWarning) override { return _to LogBlockedCORSRequest(aMessage, aCategory, aIsWarning); } \
  NS_IMETHOD LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType) override { return _to LogMimeTypeMismatch(aMessageName, aWarning, aURL, aContentType); } \
  virtual void SetSource(mozilla::UniquePtr<mozilla::ProfileChunkedBuffer> aSource) override { return _to SetSource(aSource); } \
  [[nodiscard]] NS_IMETHOD GetClassicScriptHintCharset(nsAString& aClassicScriptHintCharset) override { return _to GetClassicScriptHintCharset(aClassicScriptHintCharset); } \
  [[nodiscard]] NS_IMETHOD SetClassicScriptHintCharset(const nsAString& aClassicScriptHintCharset) override { return _to SetClassicScriptHintCharset(aClassicScriptHintCharset); } \
  [[nodiscard]] NS_IMETHOD GetDocumentCharacterSet(nsAString& aDocumentCharacterSet) override { return _to GetDocumentCharacterSet(aDocumentCharacterSet); } \
  [[nodiscard]] NS_IMETHOD SetDocumentCharacterSet(const nsAString& aDocumentCharacterSet) override { return _to SetDocumentCharacterSet(aDocumentCharacterSet); } \
  [[nodiscard]] NS_IMETHOD GetRequestObserversCalled(bool *aRequestObserversCalled) override { return _to GetRequestObserversCalled(aRequestObserversCalled); } \
  [[nodiscard]] NS_IMETHOD SetRequestObserversCalled(bool aRequestObserversCalled) override { return _to SetRequestObserversCalled(aRequestObserversCalled); } \
  [[nodiscard]] NS_IMETHOD GetIsUserAgentHeaderOutdated(bool *aIsUserAgentHeaderOutdated) override { return _to GetIsUserAgentHeaderOutdated(aIsUserAgentHeaderOutdated); } \
  [[nodiscard]] NS_IMETHOD SetIsUserAgentHeaderOutdated(bool aIsUserAgentHeaderOutdated) override { return _to SetIsUserAgentHeaderOutdated(aIsUserAgentHeaderOutdated); } \
  NS_IMETHOD GetDecompressDictionary(mozilla::net::DictionaryCacheEntry * * aDecompressDictionary) override { return _to GetDecompressDictionary(aDecompressDictionary); } \
  NS_IMETHOD SetDecompressDictionary(mozilla::net::DictionaryCacheEntry * aDecompressDictionary) override { return _to SetDecompressDictionary(aDecompressDictionary); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPCHANNEL(_to) \
  [[nodiscard]] NS_IMETHOD GetRequestMethod(nsACString& aRequestMethod) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestMethod(aRequestMethod); } \
  [[nodiscard]] NS_IMETHOD SetRequestMethod(const nsACString& aRequestMethod) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestMethod(aRequestMethod); } \
  [[nodiscard]] NS_IMETHOD GetReferrerInfo(nsIReferrerInfo **aReferrerInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReferrerInfo(aReferrerInfo); } \
  [[nodiscard]] NS_IMETHOD SetReferrerInfo(nsIReferrerInfo *aReferrerInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReferrerInfo(aReferrerInfo); } \
  [[nodiscard]] NS_IMETHOD SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReferrerInfoWithoutClone(aReferrerInfo); } \
  [[nodiscard]] NS_IMETHOD GetProtocolVersion(nsACString& aProtocolVersion) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProtocolVersion(aProtocolVersion); } \
  [[nodiscard]] NS_IMETHOD GetTransferSize(uint64_t *aTransferSize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTransferSize(aTransferSize); } \
  [[nodiscard]] NS_IMETHOD GetRequestSize(uint64_t *aRequestSize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestSize(aRequestSize); } \
  [[nodiscard]] NS_IMETHOD GetDecodedBodySize(uint64_t *aDecodedBodySize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDecodedBodySize(aDecodedBodySize); } \
  [[nodiscard]] NS_IMETHOD GetEncodedBodySize(uint64_t *aEncodedBodySize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEncodedBodySize(aEncodedBodySize); } \
  [[nodiscard]] NS_IMETHOD GetRequestHeader(const nsACString& aHeader, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestHeader(aHeader, _retval); } \
  [[nodiscard]] NS_IMETHOD SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestHeader(aHeader, aValue, aMerge); } \
  [[nodiscard]] NS_IMETHOD SetNewReferrerInfo(const nsACString& aUrl, nsIReferrerInfo::ReferrerPolicyIDL aPolicy, bool aSendReferrer) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetNewReferrerInfo(aUrl, aPolicy, aSendReferrer); } \
  [[nodiscard]] NS_IMETHOD SetEmptyRequestHeader(const nsACString& aHeader) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEmptyRequestHeader(aHeader); } \
  [[nodiscard]] NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitRequestHeaders(aVisitor); } \
  [[nodiscard]] NS_IMETHOD VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitNonDefaultRequestHeaders(aVisitor); } \
  [[nodiscard]] NS_IMETHOD ShouldStripRequestBodyHeader(const nsACString& aMethod, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ShouldStripRequestBodyHeader(aMethod, _retval); } \
  [[nodiscard]] NS_IMETHOD GetAllowSTS(bool *aAllowSTS) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowSTS(aAllowSTS); } \
  [[nodiscard]] NS_IMETHOD SetAllowSTS(bool aAllowSTS) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowSTS(aAllowSTS); } \
  [[nodiscard]] NS_IMETHOD GetRedirectionLimit(uint32_t *aRedirectionLimit) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRedirectionLimit(aRedirectionLimit); } \
  [[nodiscard]] NS_IMETHOD SetRedirectionLimit(uint32_t aRedirectionLimit) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRedirectionLimit(aRedirectionLimit); } \
  [[nodiscard]] NS_IMETHOD GetResponseStatus(uint32_t *aResponseStatus) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseStatus(aResponseStatus); } \
  [[nodiscard]] NS_IMETHOD GetResponseStatusText(nsACString& aResponseStatusText) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseStatusText(aResponseStatusText); } \
  [[nodiscard]] NS_IMETHOD GetRequestSucceeded(bool *aRequestSucceeded) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestSucceeded(aRequestSucceeded); } \
  [[nodiscard]] NS_IMETHOD GetIsMainDocumentChannel(bool *aIsMainDocumentChannel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsMainDocumentChannel(aIsMainDocumentChannel); } \
  [[nodiscard]] NS_IMETHOD SetIsMainDocumentChannel(bool aIsMainDocumentChannel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsMainDocumentChannel(aIsMainDocumentChannel); } \
  [[nodiscard]] NS_IMETHOD GetResponseHeader(const nsACString& header, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseHeader(header, _retval); } \
  [[nodiscard]] NS_IMETHOD SetResponseHeader(const nsACString& header, const nsACString& value, bool merge) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetResponseHeader(header, value, merge); } \
  [[nodiscard]] NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitResponseHeaders(aVisitor); } \
  [[nodiscard]] NS_IMETHOD GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOriginalResponseHeader(aHeader, aVisitor); } \
  [[nodiscard]] NS_IMETHOD VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitOriginalResponseHeaders(aVisitor); } \
  [[nodiscard]] NS_IMETHOD IsNoStoreResponse(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsNoStoreResponse(_retval); } \
  [[nodiscard]] NS_IMETHOD IsNoCacheResponse(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsNoCacheResponse(_retval); } \
  [[nodiscard]] NS_IMETHOD RedirectTo(nsIURI *aTargetURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RedirectTo(aTargetURI); } \
  [[nodiscard]] NS_IMETHOD UpgradeToSecure(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->UpgradeToSecure(); } \
  [[nodiscard]] NS_IMETHOD GetRequestContextID(uint64_t *aRequestContextID) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestContextID(aRequestContextID); } \
  [[nodiscard]] NS_IMETHOD SetRequestContextID(uint64_t aRequestContextID) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestContextID(aRequestContextID); } \
  [[nodiscard]] NS_IMETHOD GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTopLevelContentWindowId(aTopLevelContentWindowId); } \
  [[nodiscard]] NS_IMETHOD SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTopLevelContentWindowId(aTopLevelContentWindowId); } \
  [[nodiscard]] NS_IMETHOD GetBrowserId(uint64_t *aBrowserId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBrowserId(aBrowserId); } \
  [[nodiscard]] NS_IMETHOD SetBrowserId(uint64_t aBrowserId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBrowserId(aBrowserId); } \
  NS_IMETHOD LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory, bool aIsWarning) override { return !_to ? NS_ERROR_NULL_POINTER : _to->LogBlockedCORSRequest(aMessage, aCategory, aIsWarning); } \
  NS_IMETHOD LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->LogMimeTypeMismatch(aMessageName, aWarning, aURL, aContentType); } \
  virtual void SetSource(mozilla::UniquePtr<mozilla::ProfileChunkedBuffer> aSource) override; \
  [[nodiscard]] NS_IMETHOD GetClassicScriptHintCharset(nsAString& aClassicScriptHintCharset) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetClassicScriptHintCharset(aClassicScriptHintCharset); } \
  [[nodiscard]] NS_IMETHOD SetClassicScriptHintCharset(const nsAString& aClassicScriptHintCharset) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetClassicScriptHintCharset(aClassicScriptHintCharset); } \
  [[nodiscard]] NS_IMETHOD GetDocumentCharacterSet(nsAString& aDocumentCharacterSet) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentCharacterSet(aDocumentCharacterSet); } \
  [[nodiscard]] NS_IMETHOD SetDocumentCharacterSet(const nsAString& aDocumentCharacterSet) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentCharacterSet(aDocumentCharacterSet); } \
  [[nodiscard]] NS_IMETHOD GetRequestObserversCalled(bool *aRequestObserversCalled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestObserversCalled(aRequestObserversCalled); } \
  [[nodiscard]] NS_IMETHOD SetRequestObserversCalled(bool aRequestObserversCalled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestObserversCalled(aRequestObserversCalled); } \
  [[nodiscard]] NS_IMETHOD GetIsUserAgentHeaderOutdated(bool *aIsUserAgentHeaderOutdated) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsUserAgentHeaderOutdated(aIsUserAgentHeaderOutdated); } \
  [[nodiscard]] NS_IMETHOD SetIsUserAgentHeaderOutdated(bool aIsUserAgentHeaderOutdated) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsUserAgentHeaderOutdated(aIsUserAgentHeaderOutdated); } \
  NS_IMETHOD GetDecompressDictionary(mozilla::net::DictionaryCacheEntry * * aDecompressDictionary) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDecompressDictionary(aDecompressDictionary); } \
  NS_IMETHOD SetDecompressDictionary(mozilla::net::DictionaryCacheEntry * aDecompressDictionary) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDecompressDictionary(aDecompressDictionary); } 


#endif /* __gen_nsIHttpChannel_h__ */
