/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM CaretStateChangedEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "CaretStateChangedEvent.h"
#include "CaretStateChangedEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/CaretStateChangedEvent.h"
#include "mozilla/dom/DOMRect.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(CaretStateChangedEvent)

NS_IMPL_ADDREF_INHERITED(CaretStateChangedEvent, Event)
NS_IMPL_RELEASE_INHERITED(CaretStateChangedEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(CaretStateChangedEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mBoundingClientRect)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(CaretStateChangedEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(CaretStateChangedEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mBoundingClientRect)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(CaretStateChangedEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

CaretStateChangedEvent::CaretStateChangedEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

CaretStateChangedEvent::~CaretStateChangedEvent()
{
}

CaretStateChangedEvent*
CaretStateChangedEvent::AsCaretStateChangedEvent()
{
  return this;
}

JSObject*
CaretStateChangedEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return CaretStateChangedEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<CaretStateChangedEvent>
CaretStateChangedEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const CaretStateChangedEventInit& aEventInit)
{
  RefPtr<CaretStateChangedEvent> e = new CaretStateChangedEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInit.mBubbles, aEventInit.mCancelable);
  e->mCollapsed = aEventInit.mCollapsed;
  e->mBoundingClientRect = aEventInit.mBoundingClientRect;
  e->mReason = aEventInit.mReason;
  e->mCaretVisible = aEventInit.mCaretVisible;
  e->mCaretVisuallyVisible = aEventInit.mCaretVisuallyVisible;
  e->mSelectionVisible = aEventInit.mSelectionVisible;
  e->mSelectionEditable = aEventInit.mSelectionEditable;
  e->mSelectedTextContent = aEventInit.mSelectedTextContent;
  e->mClientX = aEventInit.mClientX;
  e->mClientY = aEventInit.mClientY;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInit.mComposed);
  return e.forget();
}

already_AddRefed<CaretStateChangedEvent>
CaretStateChangedEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const CaretStateChangedEventInit& aEventInit)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInit);
}

bool
CaretStateChangedEvent::Collapsed() const
{
  return mCollapsed;
}

DOMRectReadOnly*
CaretStateChangedEvent::GetBoundingClientRect() const
{
  return mBoundingClientRect;
}

CaretChangedReason
CaretStateChangedEvent::Reason() const
{
  return mReason;
}

bool
CaretStateChangedEvent::CaretVisible() const
{
  return mCaretVisible;
}

bool
CaretStateChangedEvent::CaretVisuallyVisible() const
{
  return mCaretVisuallyVisible;
}

bool
CaretStateChangedEvent::SelectionVisible() const
{
  return mSelectionVisible;
}

bool
CaretStateChangedEvent::SelectionEditable() const
{
  return mSelectionEditable;
}

void
CaretStateChangedEvent::GetSelectedTextContent(nsString& aRetVal) const
{
  aRetVal = mSelectedTextContent;
}

int32_t
CaretStateChangedEvent::ClientX() const
{
  return mClientX;
}

int32_t
CaretStateChangedEvent::ClientY() const
{
  return mClientY;
}


} // namespace mozilla::dom
