/* THIS FILE IS AUTOGENERATED FROM CookieStore.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "CookieStoreBinding.h"
#include "EventHandlerBinding.h"
#include "EventTargetBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/UseCounter.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CookieStore.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsThreadUtils.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<CookieSameSite>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, CookieSameSite aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<CookieSameSite>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<CookieSameSite>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<CookieSameSite>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



CookieInit::CookieInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
CookieInit::InitIds(JSContext* cx, CookieInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->value_id.init(cx, "value") ||
      !atomsCache->sameSite_id.init(cx, "sameSite") ||
      !atomsCache->path_id.init(cx, "path") ||
      !atomsCache->partitioned_id.init(cx, "partitioned") ||
      !atomsCache->name_id.init(cx, "name") ||
      !atomsCache->expires_id.init(cx, "expires") ||
      !atomsCache->domain_id.init(cx, "domain")) {
    return false;
  }
  return true;
}

bool
CookieInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CookieInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CookieInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->domain_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, mDomain)) {
      return false;
    }
    if (!NormalizeUSVString(mDomain)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
  } else {
    mDomain.SetIsVoid(true);
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->expires_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mExpires.SetNull();
  } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'expires' member of CookieInit", &mExpires.SetValue())) {
    return false;
  } else if (!std::isfinite(mExpires.Value())) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("'expires' member of CookieInit");
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mName)) {
      return false;
    }
    if (!NormalizeUSVString(mName)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'name' member of CookieInit");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->partitioned_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'partitioned' member of CookieInit", &mPartitioned)) {
      return false;
    }
  } else {
    mPartitioned = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->path_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mPath)) {
      return false;
    }
    if (!NormalizeUSVString(mPath)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
  } else {
    mPath.AssignLiteral(u"/");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->sameSite_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<CookieSameSite>::Values,
                                                                         "CookieSameSite", "'sameSite' member of CookieInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mSameSite = static_cast<CookieSameSite>(index);
    }
  } else {
    mSameSite = CookieSameSite::Strict;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->value_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mValue)) {
      return false;
    }
    if (!NormalizeUSVString(mValue)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'value' member of CookieInit");
  }
  return true;
}

bool
CookieInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
CookieInit::TraceDictionary(JSTracer* trc)
{
}

CookieInit&
CookieInit::operator=(const CookieInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mDomain = aOther.mDomain;
  mExpires = aOther.mExpires;
  mName = aOther.mName;
  mPartitioned = aOther.mPartitioned;
  mPath = aOther.mPath;
  mSameSite = aOther.mSameSite;
  mValue = aOther.mValue;
  return *this;
}



CookieListItem::CookieListItem()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
CookieListItem::InitIds(JSContext* cx, CookieListItemAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->value_id.init(cx, "value") ||
      !atomsCache->secure_id.init(cx, "secure") ||
      !atomsCache->sameSite_id.init(cx, "sameSite") ||
      !atomsCache->path_id.init(cx, "path") ||
      !atomsCache->partitioned_id.init(cx, "partitioned") ||
      !atomsCache->name_id.init(cx, "name") ||
      !atomsCache->expires_id.init(cx, "expires") ||
      !atomsCache->domain_id.init(cx, "domain")) {
    return false;
  }
  return true;
}

bool
CookieListItem::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CookieListItemAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CookieListItemAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (StaticPrefs::dom_cookieStore_extra_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->domain_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDomain.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, (mDomain.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (StaticPrefs::dom_cookieStore_extra_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->expires_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mExpires.Construct();
    if (temp.ref().isNullOrUndefined()) {
      (mExpires.Value()).SetNull();
    } else if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'expires' member of CookieListItem", &(mExpires.Value()).SetValue())) {
      return false;
    } else if (!std::isfinite((mExpires.Value()).Value())) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'expires' member of CookieListItem");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mName.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mName.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (StaticPrefs::dom_cookieStore_extra_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->partitioned_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPartitioned.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'partitioned' member of CookieListItem", &(mPartitioned.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (StaticPrefs::dom_cookieStore_extra_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->path_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPath.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mPath.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (StaticPrefs::dom_cookieStore_extra_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->sameSite_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSameSite.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<CookieSameSite>::Values,
                                                                         "CookieSameSite", "'sameSite' member of CookieListItem",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mSameSite.Value()) = static_cast<CookieSameSite>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (StaticPrefs::dom_cookieStore_extra_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->secure_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSecure.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'secure' member of CookieListItem", &(mSecure.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->value_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mValue.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mValue.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
CookieListItem::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
CookieListItem::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  CookieListItemAtoms* atomsCache = GetAtomCache<CookieListItemAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (StaticPrefs::dom_cookieStore_extra_enabled()) {
    if (mDomain.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        nsCString const & currentValue = mDomain.InternalValue();
        if (!UTF8StringToJsval(cx, currentValue, &temp)) {
          return false;
        }
        if (!JS_DefinePropertyById(cx, obj, atomsCache->domain_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  if (StaticPrefs::dom_cookieStore_extra_enabled()) {
    if (mExpires.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        Nullable<double> const & currentValue = mExpires.InternalValue();
        if (currentValue.IsNull()) {
          temp.setNull();
          if (!JS_DefinePropertyById(cx, obj, atomsCache->expires_id, temp, JSPROP_ENUMERATE)) {
            return false;
          }
          break;
        }
        temp.set(JS_NumberValue(double(currentValue.Value())));
        if (!JS_DefinePropertyById(cx, obj, atomsCache->expires_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  if (mName.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mName.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (StaticPrefs::dom_cookieStore_extra_enabled()) {
    if (mPartitioned.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        bool const & currentValue = mPartitioned.InternalValue();
        temp.setBoolean(currentValue);
        if (!JS_DefinePropertyById(cx, obj, atomsCache->partitioned_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  if (StaticPrefs::dom_cookieStore_extra_enabled()) {
    if (mPath.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        nsCString const & currentValue = mPath.InternalValue();
        if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
          return false;
        }
        if (!JS_DefinePropertyById(cx, obj, atomsCache->path_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  if (StaticPrefs::dom_cookieStore_extra_enabled()) {
    if (mSameSite.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        CookieSameSite const & currentValue = mSameSite.InternalValue();
        if (!ToJSValue(cx, currentValue, &temp)) {
          return false;
        }
        if (!JS_DefinePropertyById(cx, obj, atomsCache->sameSite_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  if (StaticPrefs::dom_cookieStore_extra_enabled()) {
    if (mSecure.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        bool const & currentValue = mSecure.InternalValue();
        temp.setBoolean(currentValue);
        if (!JS_DefinePropertyById(cx, obj, atomsCache->secure_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  if (mValue.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mValue.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->value_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
CookieListItem::TraceDictionary(JSTracer* trc)
{
}

CookieListItem&
CookieListItem::operator=(const CookieListItem& aOther)
{
  DictionaryBase::operator=(aOther);
  mDomain.Reset();
  if (aOther.mDomain.WasPassed()) {
    mDomain.Construct(aOther.mDomain.Value());
  }
  mExpires.Reset();
  if (aOther.mExpires.WasPassed()) {
    mExpires.Construct(aOther.mExpires.Value());
  }
  mName.Reset();
  if (aOther.mName.WasPassed()) {
    mName.Construct(aOther.mName.Value());
  }
  mPartitioned.Reset();
  if (aOther.mPartitioned.WasPassed()) {
    mPartitioned.Construct(aOther.mPartitioned.Value());
  }
  mPath.Reset();
  if (aOther.mPath.WasPassed()) {
    mPath.Construct(aOther.mPath.Value());
  }
  mSameSite.Reset();
  if (aOther.mSameSite.WasPassed()) {
    mSameSite.Construct(aOther.mSameSite.Value());
  }
  mSecure.Reset();
  if (aOther.mSecure.WasPassed()) {
    mSecure.Construct(aOther.mSecure.Value());
  }
  mValue.Reset();
  if (aOther.mValue.WasPassed()) {
    mValue.Construct(aOther.mValue.Value());
  }
  return *this;
}



CookieStoreDeleteOptions::CookieStoreDeleteOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
CookieStoreDeleteOptions::InitIds(JSContext* cx, CookieStoreDeleteOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->path_id.init(cx, "path") ||
      !atomsCache->partitioned_id.init(cx, "partitioned") ||
      !atomsCache->name_id.init(cx, "name") ||
      !atomsCache->domain_id.init(cx, "domain")) {
    return false;
  }
  return true;
}

bool
CookieStoreDeleteOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CookieStoreDeleteOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CookieStoreDeleteOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->domain_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, mDomain)) {
      return false;
    }
    if (!NormalizeUSVString(mDomain)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
  } else {
    mDomain.SetIsVoid(true);
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mName)) {
      return false;
    }
    if (!NormalizeUSVString(mName)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'name' member of CookieStoreDeleteOptions");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->partitioned_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'partitioned' member of CookieStoreDeleteOptions", &mPartitioned)) {
      return false;
    }
  } else {
    mPartitioned = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->path_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mPath)) {
      return false;
    }
    if (!NormalizeUSVString(mPath)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
  } else {
    mPath.AssignLiteral(u"/");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
CookieStoreDeleteOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
CookieStoreDeleteOptions::TraceDictionary(JSTracer* trc)
{
}

CookieStoreDeleteOptions&
CookieStoreDeleteOptions::operator=(const CookieStoreDeleteOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mDomain = aOther.mDomain;
  mName = aOther.mName;
  mPartitioned = aOther.mPartitioned;
  mPath = aOther.mPath;
  return *this;
}



CookieStoreGetOptions::CookieStoreGetOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
CookieStoreGetOptions::InitIds(JSContext* cx, CookieStoreGetOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->url_id.init(cx, "url") ||
      !atomsCache->name_id.init(cx, "name")) {
    return false;
  }
  return true;
}

bool
CookieStoreGetOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CookieStoreGetOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CookieStoreGetOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mName.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mName.Value()))) {
      return false;
    }
    if (!NormalizeUSVString((mName.Value()))) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->url_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mUrl.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mUrl.Value()))) {
      return false;
    }
    if (!NormalizeUSVString((mUrl.Value()))) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
CookieStoreGetOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
CookieStoreGetOptions::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  CookieStoreGetOptionsAtoms* atomsCache = GetAtomCache<CookieStoreGetOptionsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mName.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mName.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mUrl.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mUrl.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->url_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
CookieStoreGetOptions::TraceDictionary(JSTracer* trc)
{
}

CookieStoreGetOptions&
CookieStoreGetOptions::operator=(const CookieStoreGetOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mName.Reset();
  if (aOther.mName.WasPassed()) {
    mName.Construct(aOther.mName.Value());
  }
  mUrl.Reset();
  if (aOther.mUrl.WasPassed()) {
    mUrl.Construct(aOther.mUrl.Value());
  }
  return *this;
}


namespace CookieStore_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<EventTarget_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CookieStore.get");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CookieStore", "get", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CookieStore*>(void_self);
  unsigned argcount = std::min(args.length(), 1u);
  switch (argcount) {
    case 0: {
      binding_detail::FastCookieStoreGetOptions arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Get(Constify(arg0), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.get"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (NS_IsMainThread()) {
        SetUseCounter(obj, eUseCounter_CookieStore_get);

      } else {
        SetUseCounter(UseCounterWorker::CookieStore_get);

      }
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 1: {
      if (args[0].isNullOrUndefined()) {
        binding_detail::FastCookieStoreGetOptions arg0;
        if (!arg0.Init(cx, args[0], "Argument 1", false)) {
          return false;
        }
        FastErrorResult rv;
        auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Get(Constify(arg0), rv)));
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.get"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        if (NS_IsMainThread()) {
          SetUseCounter(obj, eUseCounter_CookieStore_get);

        } else {
          SetUseCounter(UseCounterWorker::CookieStore_get);

        }
        if (!ToJSValue(cx, result, args.rval())) {
          return false;
        }
        return true;
      }
      if (args[0].isObject()) {
        do {
          binding_detail::FastCookieStoreGetOptions arg0;
          if (!arg0.Init(cx, args[0], "Argument 1", false)) {
            return false;
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Get(Constify(arg0), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.get"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          if (NS_IsMainThread()) {
            SetUseCounter(obj, eUseCounter_CookieStore_get);

          } else {
            SetUseCounter(UseCounterWorker::CookieStore_get);

          }
          if (!ToJSValue(cx, result, args.rval())) {
            return false;
          }
          return true;
        } while (false);
      }
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      if (!NormalizeUSVString(arg0)) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Get(Constify(arg0), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.get"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (NS_IsMainThread()) {
        SetUseCounter(obj, eUseCounter_CookieStore_get);

      } else {
        SetUseCounter(UseCounterWorker::CookieStore_get);

      }
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
get_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = get(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo get_methodinfo = {
  { (JSJitGetterOp)get_promiseWrapper },
  { prototypes::id::CookieStore },
  { PrototypeTraits<prototypes::id::CookieStore>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getAll(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CookieStore.getAll");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CookieStore", "getAll", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CookieStore*>(void_self);
  unsigned argcount = std::min(args.length(), 1u);
  switch (argcount) {
    case 0: {
      binding_detail::FastCookieStoreGetOptions arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetAll(Constify(arg0), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.getAll"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (NS_IsMainThread()) {
        SetUseCounter(obj, eUseCounter_CookieStore_getAll);

      } else {
        SetUseCounter(UseCounterWorker::CookieStore_getAll);

      }
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 1: {
      if (args[0].isNullOrUndefined()) {
        binding_detail::FastCookieStoreGetOptions arg0;
        if (!arg0.Init(cx, args[0], "Argument 1", false)) {
          return false;
        }
        FastErrorResult rv;
        auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetAll(Constify(arg0), rv)));
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.getAll"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        if (NS_IsMainThread()) {
          SetUseCounter(obj, eUseCounter_CookieStore_getAll);

        } else {
          SetUseCounter(UseCounterWorker::CookieStore_getAll);

        }
        if (!ToJSValue(cx, result, args.rval())) {
          return false;
        }
        return true;
      }
      if (args[0].isObject()) {
        do {
          binding_detail::FastCookieStoreGetOptions arg0;
          if (!arg0.Init(cx, args[0], "Argument 1", false)) {
            return false;
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetAll(Constify(arg0), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.getAll"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          if (NS_IsMainThread()) {
            SetUseCounter(obj, eUseCounter_CookieStore_getAll);

          } else {
            SetUseCounter(UseCounterWorker::CookieStore_getAll);

          }
          if (!ToJSValue(cx, result, args.rval())) {
            return false;
          }
          return true;
        } while (false);
      }
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      if (!NormalizeUSVString(arg0)) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetAll(Constify(arg0), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.getAll"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (NS_IsMainThread()) {
        SetUseCounter(obj, eUseCounter_CookieStore_getAll);

      } else {
        SetUseCounter(UseCounterWorker::CookieStore_getAll);

      }
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
getAll_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = getAll(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo getAll_methodinfo = {
  { (JSJitGetterOp)getAll_promiseWrapper },
  { prototypes::id::CookieStore },
  { PrototypeTraits<prototypes::id::CookieStore>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
set(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CookieStore.set");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CookieStore", "set", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CookieStore*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 1: {
      binding_detail::FastCookieInit arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", false)) {
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Set(Constify(arg0), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.set"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (NS_IsMainThread()) {
        SetUseCounter(obj, eUseCounter_CookieStore_set);

      } else {
        SetUseCounter(UseCounterWorker::CookieStore_set);

      }
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 2: {
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      if (!NormalizeUSVString(arg0)) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      binding_detail::FakeString<char16_t> arg1;
      if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
        return false;
      }
      if (!NormalizeUSVString(arg1)) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Set(Constify(arg0), Constify(arg1), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.set"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (NS_IsMainThread()) {
        SetUseCounter(obj, eUseCounter_CookieStore_set);

      } else {
        SetUseCounter(UseCounterWorker::CookieStore_set);

      }
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
set_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = set(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo set_methodinfo = {
  { (JSJitGetterOp)set_promiseWrapper },
  { prototypes::id::CookieStore },
  { PrototypeTraits<prototypes::id::CookieStore>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
_delete_(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "CookieStore.delete");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CookieStore", "delete", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CookieStore*>(void_self);
  unsigned argcount = std::min(args.length(), 1u);
  switch (argcount) {
    case 1: {
      if (args[0].isNullOrUndefined()) {
        binding_detail::FastCookieStoreDeleteOptions arg0;
        if (!arg0.Init(cx, args[0], "Argument 1", false)) {
          return false;
        }
        FastErrorResult rv;
        auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Delete(Constify(arg0), rv)));
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.delete"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        if (NS_IsMainThread()) {
          SetUseCounter(obj, eUseCounter_CookieStore_delete);

        } else {
          SetUseCounter(UseCounterWorker::CookieStore_delete);

        }
        if (!ToJSValue(cx, result, args.rval())) {
          return false;
        }
        return true;
      }
      if (args[0].isObject()) {
        do {
          binding_detail::FastCookieStoreDeleteOptions arg0;
          if (!arg0.Init(cx, args[0], "Argument 1", false)) {
            return false;
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Delete(Constify(arg0), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.delete"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          if (NS_IsMainThread()) {
            SetUseCounter(obj, eUseCounter_CookieStore_delete);

          } else {
            SetUseCounter(UseCounterWorker::CookieStore_delete);

          }
          if (!ToJSValue(cx, result, args.rval())) {
            return false;
          }
          return true;
        } while (false);
      }
      binding_detail::FakeString<char16_t> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      if (!NormalizeUSVString(arg0)) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Delete(Constify(arg0), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CookieStore.delete"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (NS_IsMainThread()) {
        SetUseCounter(obj, eUseCounter_CookieStore_delete);

      } else {
        SetUseCounter(UseCounterWorker::CookieStore_delete);

      }
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
_delete__promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = _delete_(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo delete_methodinfo = {
  { (JSJitGetterOp)_delete__promiseWrapper },
  { prototypes::id::CookieStore },
  { PrototypeTraits<prototypes::id::CookieStore>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CookieStore", "onchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CookieStore*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CookieStore", "onchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CookieStore*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onchange_getterinfo = {
  { get_onchange },
  { prototypes::id::CookieStore },
  { PrototypeTraits<prototypes::id::CookieStore>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onchange_setterinfo = {
  { (JSJitGetterOp)set_onchange },
  { prototypes::id::CookieStore },
  { PrototypeTraits<prototypes::id::CookieStore>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::CookieStore* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::CookieStore>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::CookieStore>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("get", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&get_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getAll", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&getAll_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("set", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&set_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("delete", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&delete_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sMethods_disablers0 = {
  WebIDLPrefIndex::NoPref, 0, true, OriginTrial(0), nullptr
};

static const Prefable<const JSFunctionSpec> sMethods[] = {
  { &sMethods_disablers0, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("onchange", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onchange_getterinfo, GenericSetter<NormalThisPolicy>, &onchange_setterinfo),
  JS_PS_END
};

static const PrefableDisablers sAttributes_disablers0 = {
  WebIDLPrefIndex::NoPref, GlobalNames::ServiceWorkerGlobalScope, true, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sAttributes[] = {
  { &sAttributes_disablers0, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[5];
static PropertyInfo sNativeProperties_propertyInfos[5];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  5,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[4] }
  }
};
static_assert(5 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::CookieStore,
  constructors::id::CookieStore,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  EventTarget_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::CookieStore>::Depth,
  prototypes::id::CookieStore,
  true,
  0,
  "CookieStore",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "CookieStorePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::CookieStore,
  PrototypeTraits<prototypes::id::CookieStore>::Depth,
  &sNativePropertyHooks,
  EventTarget_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  if (!NS_IsMainThread()) {
    const char* name = JS::GetClass(aObj)->name;
    if (strcmp(name, "ServiceWorkerGlobalScope")) {
      return false;
    }
  }

  return StaticPrefs::dom_cookieStore_enabled() &&
         mozilla::dom::IsSecureContextOrObjectIsFromSecureContext(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "CookieStore",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::CookieStore>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::CookieStore, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::CookieStore>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::CookieStore>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::CookieStore>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::CookieStore>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::CookieStore* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::CookieStore>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::CookieStore*>);
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::CookieStore> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::CookieStore);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::CookieStore);

  JS::Handle<JSObject*> parentProto(EventTarget_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(EventTarget_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "CookieStore",
                              ShouldExpose<CookieStore_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::CookieStore,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::CookieStore,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace CookieStore_Binding



} // namespace dom


} // namespace mozilla
