/* THIS FILE IS AUTOGENERATED FROM DebuggerUtils.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "DebuggerUtilsBinding.h"
#include "MainThreadUtils.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



HTMLContent::HTMLContent()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
HTMLContent::InitIds(JSContext* cx, HTMLContentAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->uri_id.init(cx, "uri") ||
      !atomsCache->parserID_id.init(cx, "parserID") ||
      !atomsCache->contents_id.init(cx, "contents") ||
      !atomsCache->complete_id.init(cx, "complete") ||
      !atomsCache->browsingContextID_id.init(cx, "browsingContextID") ||
      !atomsCache->browserId_id.init(cx, "browserId")) {
    return false;
  }
  return true;
}

bool
HTMLContent::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
HTMLContent::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  HTMLContentAtoms* atomsCache = GetAtomCache<HTMLContentAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mBrowserId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mBrowserId.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->browserId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mBrowsingContextID.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mBrowsingContextID.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->browsingContextID_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mComplete.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mComplete.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->complete_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mContents.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mContents.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->contents_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mParserID.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mParserID.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->parserID_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mUri.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mUri.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->uri_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

bool
HTMLContent::ToJSON(nsAString& aJSON) const
{
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext *cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here
  // because we'll only be creating objects, in ways that have no
  // side-effects, followed by a call to JS::ToJSONMaybeSafely,
  // which likewise guarantees no side-effects for the sorts of
  // things we will pass it.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    JS_ReportOutOfMemory(cx);
    return false;
  }
  JSAutoRealm ar(cx, scope);
  JS::Rooted<JS::Value> val(cx);
  if (!ToObjectInternal(cx, &val)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &val.toObject());
  return StringifyToJSON(cx, obj, aJSON);
}

void
HTMLContent::TraceDictionary(JSTracer* trc)
{
}

HTMLContent&
HTMLContent::operator=(const HTMLContent& aOther)
{
  DictionaryBase::operator=(aOther);
  mBrowserId.Reset();
  if (aOther.mBrowserId.WasPassed()) {
    mBrowserId.Construct(aOther.mBrowserId.Value());
  }
  mBrowsingContextID.Reset();
  if (aOther.mBrowsingContextID.WasPassed()) {
    mBrowsingContextID.Construct(aOther.mBrowsingContextID.Value());
  }
  mComplete.Reset();
  if (aOther.mComplete.WasPassed()) {
    mComplete.Construct(aOther.mComplete.Value());
  }
  mContents.Reset();
  if (aOther.mContents.WasPassed()) {
    mContents.Construct(aOther.mContents.Value());
  }
  mParserID.Reset();
  if (aOther.mParserID.WasPassed()) {
    mParserID.Construct(aOther.mParserID.Value());
  }
  mUri.Reset();
  if (aOther.mUri.WasPassed()) {
    mUri.Construct(aOther.mUri.Value());
  }
  return *this;
}


} // namespace mozilla::dom
