/* THIS FILE IS AUTOGENERATED FROM SVGLengthList.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "DOMSVGLength.h"
#include "DOMSVGLengthList.h"
#include "MainThreadUtils.h"
#include "SVGLengthListBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace SVGLengthList_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_numberOfItems(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "numberOfItems", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->NumberOfItems());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo numberOfItems_getterinfo = {
  { get_numberOfItems },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clear(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "clear", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Clear(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Clear(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.clear"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clear_methodinfo = {
  { (JSJitGetterOp)clear },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
initialize(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGLengthList.initialize");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "initialize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGLengthList.initialize", 1)) {
    return false;
  }
  NonNull<mozilla::dom::DOMSVGLength> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::SVGLength, mozilla::dom::DOMSVGLength>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "SVGLength");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->Initialize(MOZ_KnownLive(NonNullHelper(arg0)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.initialize"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo initialize_methodinfo = {
  { (JSJitGetterOp)initialize },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getItem(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "getItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGLengthList.getItem", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->GetItem(arg0, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.getItem"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getItem_methodinfo = {
  { (JSJitGetterOp)getItem },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
insertItemBefore(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGLengthList.insertItemBefore");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "insertItemBefore", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGLengthList.insertItemBefore", 2)) {
    return false;
  }
  NonNull<mozilla::dom::DOMSVGLength> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::SVGLength, mozilla::dom::DOMSVGLength>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "SVGLength");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->InsertItemBefore(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.insertItemBefore"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo insertItemBefore_methodinfo = {
  { (JSJitGetterOp)insertItemBefore },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
replaceItem(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGLengthList.replaceItem");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "replaceItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGLengthList.replaceItem", 2)) {
    return false;
  }
  NonNull<mozilla::dom::DOMSVGLength> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::SVGLength, mozilla::dom::DOMSVGLength>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "SVGLength");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->ReplaceItem(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.replaceItem"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo replaceItem_methodinfo = {
  { (JSJitGetterOp)replaceItem },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
removeItem(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "removeItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGLengthList.removeItem", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->RemoveItem(arg0, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.removeItem"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo removeItem_methodinfo = {
  { (JSJitGetterOp)removeItem },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
appendItem(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "SVGLengthList.appendItem");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "appendItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  if (!args.requireAtLeast(cx, "SVGLengthList.appendItem", 1)) {
    return false;
  }
  NonNull<mozilla::dom::DOMSVGLength> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::SVGLength, mozilla::dom::DOMSVGLength>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "SVGLength");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->AppendItem(MOZ_KnownLive(NonNullHelper(arg0)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.appendItem"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo appendItem_methodinfo = {
  { (JSJitGetterOp)appendItem },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_length(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SVGLengthList", "length", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::DOMSVGLengthList*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Length());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo length_getterinfo = {
  { get_length },
  { prototypes::id::SVGLengthList },
  { PrototypeTraits<prototypes::id::SVGLengthList>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("clear", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clear_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("initialize", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&initialize_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getItem_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("insertItemBefore", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&insertItemBefore_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("replaceItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&replaceItem_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&removeItem_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("appendItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&appendItem_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_SYM_FNSPEC(iterator, nullptr, nullptr, 0, 0, "$ArrayValues"),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(8 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("numberOfItems", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &numberOfItems_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("length", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &length_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[10];
static PropertyInfo sNativeProperties_propertyInfos[10];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  10,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[8] }
  }
};
static_assert(10 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static_assert(std::is_base_of_v<nsISupports, mozilla::dom::DOMSVGLengthList>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public mozilla::dom::DOMProxyHandler
{
public:
  using Base = mozilla::dom::DOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  bool
  getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const override;

  bool
  setCustom(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::Value> v, bool* done) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE mozilla::dom::DOMSVGLengthList*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<mozilla::dom::DOMSVGLengthList*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::SVGLengthList,
  constructors::id::SVGLengthList,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::SVGLengthList>::Depth,
  prototypes::id::SVGLengthList,
  true,
  0,
  "SVGLengthList",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "SVGLengthListPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::SVGLengthList,
  PrototypeTraits<prototypes::id::SVGLengthList>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    JS::Rooted<JS::Value> value(cx);
    mozilla::dom::DOMSVGLengthList* self = UnwrapProxy(proxy);
    bool found = false;
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, &value)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable, JS::PropertyAttribute::Writable })));
      return true;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    BindingCallContext cx(cx_, "SVGLengthList indexed setter");
    *done = true;
    // https://webidl.spec.whatwg.org/#legacy-platform-object-defineownproperty
    // Step 1.1.  The no-indexed-setter case is handled by step 1.2.
    if (!desc.isDataDescriptor()) {
      return opresult.failNotDataDescriptor();
    }

    mozilla::dom::DOMSVGLengthList* self = UnwrapProxy(proxy);
    JS::Rooted<JS::Value> rootedValue(cx, desc.value());
    NonNull<mozilla::dom::DOMSVGLength> newItem;
    if (desc.value().isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::SVGLength, mozilla::dom::DOMSVGLength>(&rootedValue, newItem, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Value being assigned to SVGLengthList setter", "SVGLength");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Value being assigned to SVGLengthList setter");
      return false;
    }
    FastErrorResult rv;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->IndexedSetter(index, MOZ_KnownLive(NonNullHelper(newItem)), rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->IndexedSetter(index, MOZ_KnownLive(NonNullHelper(newItem)), rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList indexed setter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    return opresult.succeed();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  uint32_t length = UnwrapProxy(proxy)->Length();
  MOZ_ASSERT(int32_t(length) >= 0);
  for (int32_t i = 0; i < int32_t(length); ++i) {
    if (!props.append(JS::PropertyKey::Int(i))) {
      return false;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool found = false;
    mozilla::dom::DOMSVGLengthList* self = UnwrapProxy(proxy);
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;

    *bp = found;
    return true;
  }


  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  *bp = false;
  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    mozilla::dom::DOMSVGLengthList* self = UnwrapProxy(proxy);
    bool found = false;
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, vp)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    // Even if we don't have this index, we don't forward the
    // get on to our expando object.
  } else {
    bool expandoHasProp = false;
    { // Scope for expando
      JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
      if (expando) {
        if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
          return false;
        }

        if (expandoHasProp) {
          // Forward the get to the expando object, but our receiver is whatever our
          // receiver is.
          if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
            return false;
          }
        }
      }
    }

    if (expandoHasProp) {
      return true;
    }
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "SVGLengthList";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  mozilla::dom::DOMSVGLengthList* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::DOMSVGLengthList>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::DOMSVGLengthList>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool deleteSucceeded;
    bool found = false;
    mozilla::dom::DOMSVGLengthList* self = UnwrapProxy(proxy);
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
    deleteSucceeded = !found;
    return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

bool
DOMProxyHandler::getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const
{
  JS::Rooted<JS::Value> temp(cx);
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
             "Should not have a XrayWrapper here");

  mozilla::dom::DOMSVGLengthList* self = UnwrapProxy(proxy);
  uint32_t length = self->Length();
  // Compute the end of the indices we'll get ourselves
  uint32_t ourEnd = std::clamp(length, begin, end);

  for (uint32_t index = begin; index < ourEnd; ++index) {
    bool found = false;
    FastErrorResult rv;
    auto result(StrongOrRawPtr<mozilla::dom::DOMSVGLength>(MOZ_KnownLive(self)->IndexedGetter(index, found, rv)));
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList.getItem"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    MOZ_ASSERT(found);
    if (!GetOrCreateDOMReflector(cx, result, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!adder->append(cx, temp)) return false;
    continue;
  }

  if (end > ourEnd) {
    JS::Rooted<JSObject*> proto(cx);
    if (!js::GetObjectProto(cx, proxy, &proto)) {
      return false;
    }
    return js::GetElementsWithAdder(cx, proto, proxy, ourEnd, end, adder);
  }

  return true;
}

bool
DOMProxyHandler::setCustom(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::Value> v, bool* done) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
             "Should not have a XrayWrapper here");
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    BindingCallContext cx(cx_, "SVGLengthList indexed setter");
    mozilla::dom::DOMSVGLengthList* self = UnwrapProxy(proxy);
    JS::Rooted<JS::Value> rootedValue(cx, v);
    NonNull<mozilla::dom::DOMSVGLength> newItem;
    if (v.isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::SVGLength, mozilla::dom::DOMSVGLength>(&rootedValue, newItem, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Value being assigned to SVGLengthList setter", "SVGLength");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Value being assigned to SVGLengthList setter");
      return false;
    }
    FastErrorResult rv;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->IndexedSetter(index, MOZ_KnownLive(NonNullHelper(newItem)), rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->IndexedSetter(index, MOZ_KnownLive(NonNullHelper(newItem)), rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SVGLengthList indexed setter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    *done = true;
    return true;
  }

  *done = false;
  return true;
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<mozilla::dom::DOMSVGLengthList>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("SVGLengthList",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(1)),
  { prototypes::id::SVGLengthList, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::DOMSVGLengthList>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::DOMSVGLengthList>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::DOMSVGLengthList>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, mozilla::dom::DOMSVGLengthList* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::DOMSVGLengthList>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::DOMSVGLengthList*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::DOMSVGLengthList> creator(aCx);
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false,
                            aObject, JS::UndefinedHandleValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::SVGLengthList);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::SVGLengthList);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "SVGLengthList",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::SVGLengthList,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::SVGLengthList,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace SVGLengthList_Binding



} // namespace mozilla::dom
