/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM WebGLContextEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "WebGLContextEvent.h"
#include "WebGLContextEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/WebGLContextEvent.h"

namespace mozilla::dom {


WebGLContextEvent::WebGLContextEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

WebGLContextEvent::~WebGLContextEvent()
{
}

WebGLContextEvent*
WebGLContextEvent::AsWebGLContextEvent()
{
  return this;
}

JSObject*
WebGLContextEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return WebGLContextEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<WebGLContextEvent>
WebGLContextEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const WebGLContextEventInit& aEventInit)
{
  RefPtr<WebGLContextEvent> e = new WebGLContextEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInit.mBubbles, aEventInit.mCancelable);
  e->mStatusMessage = aEventInit.mStatusMessage;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInit.mComposed);
  return e.forget();
}

already_AddRefed<WebGLContextEvent>
WebGLContextEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const WebGLContextEventInit& aEventInit)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInit);
}

void
WebGLContextEvent::GetStatusMessage(nsString& aRetVal) const
{
  aRetVal = mStatusMessage;
}


} // namespace mozilla::dom
