//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PExternalHelperAppParent.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/dom/PBrowserParent.h"
#include "mozilla/dom/PContentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PExternalHelperAppParent::PExternalHelperAppParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PExternalHelperAppParent);
}

PExternalHelperAppParent::~PExternalHelperAppParent()
{
    MOZ_COUNT_DTOR(PExternalHelperAppParent);
}

auto PExternalHelperAppParent::ActorAlloc() -> void
{
    AddRef();
}

auto PExternalHelperAppParent::ActorDealloc() -> void
{
    Release();
}

auto PExternalHelperAppParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PExternalHelperAppParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PExternalHelperAppParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PExternalHelperAppParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PExternalHelperAppParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PExternalHelperAppParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PExternalHelperAppParent::SendCancel(const nsresult& aStatus) -> bool
{
    UniquePtr<IPC::Message> msg__ = PExternalHelperApp::Msg_Cancel(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aStatus);
    // Sentinel = 'aStatus'
    ((&(writer__)))->WriteSentinel(186712806);


    if (mozilla::ipc::LoggingEnabledFor("PExternalHelperApp", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PExternalHelperAppParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PExternalHelperApp::Msg_Cancel", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PExternalHelperAppParent::Send__delete__(PExternalHelperAppParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PExternalHelperApp::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PExternalHelperApp", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PExternalHelperAppParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PExternalHelperApp::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PExternalHelperAppParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PExternalHelperAppParent::OnMessageReceived(const Message& msg__) -> PExternalHelperAppParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PExternalHelperApp::Msg_OnStartRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PExternalHelperApp", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PExternalHelperAppParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PExternalHelperApp::Msg_OnStartRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__entityID = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__entityID) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& entityID = *maybe__entityID;
            // Sentinel = 'entityID'
            if ((!(((&(reader__)))->ReadSentinel(252183339)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvOnStartRequest(std::move(entityID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PExternalHelperApp::Msg_OnDataAvailable__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PExternalHelperApp", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PExternalHelperAppParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PExternalHelperApp::Msg_OnDataAvailable", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__data = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__offset = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__offset) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& offset = *maybe__offset;
            // Sentinel = 'offset'
            if ((!(((&(reader__)))->ReadSentinel(147653256)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__count = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__count) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& count = *maybe__count;
            // Sentinel = 'count'
            if ((!(((&(reader__)))->ReadSentinel(106889770)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvOnDataAvailable(std::move(data), std::move(offset), std::move(count));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PExternalHelperApp::Msg_OnStopRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PExternalHelperApp", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PExternalHelperAppParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PExternalHelperApp::Msg_OnStopRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__code = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__code) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& code = *maybe__code;
            // Sentinel = 'code'
            if ((!(((&(reader__)))->ReadSentinel(67764636)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvOnStopRequest(std::move(code));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PExternalHelperApp::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PExternalHelperAppParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PExternalHelperAppParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PExternalHelperAppParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PExternalHelperApp'
    (aWriter)->WriteSentinel(1116079893);
}

auto ParamTraits<::mozilla::dom::PExternalHelperAppParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PExternalHelperApp actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PExternalHelperApp'
    if ((!((aReader)->ReadSentinel(1116079893)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PExternalHelperApp actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PExternalHelperAppMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PExternalHelperApp)");

        return {};
    }
    return static_cast<::mozilla::dom::PExternalHelperAppParent*>(actor);
}

} // namespace IPC
