//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PWebIdentityParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/IdentityCredentialSerializationHelpers.h"
#include "mozilla/dom/WebIdentityParent.h"
#include "mozilla/ipc/URIUtils.h"

#include "mozilla/dom/PWindowGlobalParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PWebIdentityParent::PWebIdentityParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebIdentityParent);
}

PWebIdentityParent::~PWebIdentityParent()
{
    MOZ_COUNT_DTOR(PWebIdentityParent);
}

auto PWebIdentityParent::ActorAlloc() -> void
{
    AddRef();
}

auto PWebIdentityParent::ActorDealloc() -> void
{
    Release();
}

auto PWebIdentityParent::Manager() const -> PWindowGlobalParent*
{
    return static_cast<PWindowGlobalParent*>(IProtocol::Manager());
}

auto PWebIdentityParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebIdentityParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebIdentityParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PWebIdentityParent::SendOpenContinuationWindow(
        mozilla::NotNull<nsIURI*> aContinueURI,
        mozilla::ipc::ResolveCallback<OpenContinuationWindowResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PWebIdentity::Msg_OpenContinuationWindow(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aContinueURI);
    // Sentinel = 'aContinueURI'
    ((&(writer__)))->WriteSentinel(512296087);


    if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebIdentityParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebIdentity::Msg_OpenContinuationWindow", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PWebIdentity::Reply_OpenContinuationWindow__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<OpenContinuationWindowResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'OpenContinuationWindowResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OpenContinuationWindowResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PWebIdentityParent::SendOpenContinuationWindow(mozilla::NotNull<nsIURI*> aContinueURI) -> RefPtr<OpenContinuationWindowPromise>
{
    RefPtr<MozPromise<OpenContinuationWindowResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<OpenContinuationWindowResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendOpenContinuationWindow(std::move(aContinueURI), [promise__](OpenContinuationWindowResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PWebIdentityParent::Send__delete__(PWebIdentityParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PWebIdentity::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebIdentityParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebIdentity::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PWebIdentityParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebIdentityParent::OnMessageReceived(const Message& msg__) -> PWebIdentityParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebIdentity::Msg_RequestCancel__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebIdentityParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebIdentity::Msg_RequestCancel", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<WebIdentityParent*>(this))->RecvRequestCancel();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebIdentity::Msg_GetIdentityCredential__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebIdentityParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebIdentity::Msg_GetIdentityCredential", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aOptions = IPC::ReadParam<IdentityCredentialRequestOptions>((&(reader__)));
            if (!maybe__aOptions) {
                FatalError("Error deserializing 'IdentityCredentialRequestOptions'");
                return MsgValueError;

            }
            auto& aOptions = *maybe__aOptions;
            // Sentinel = 'aOptions'
            if ((!(((&(reader__)))->ReadSentinel(240976718)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IdentityCredentialRequestOptions'");
                return MsgValueError;
            }
            auto maybe__aMediationRequirement = IPC::ReadParam<CredentialMediationRequirement>((&(reader__)));
            if (!maybe__aMediationRequirement) {
                FatalError("Error deserializing 'CredentialMediationRequirement'");
                return MsgValueError;

            }
            auto& aMediationRequirement = *maybe__aMediationRequirement;
            // Sentinel = 'aMediationRequirement'
            if ((!(((&(reader__)))->ReadSentinel(1539508365)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CredentialMediationRequirement'");
                return MsgValueError;
            }
            auto maybe__aHasUserActivation = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aHasUserActivation) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aHasUserActivation = *maybe__aHasUserActivation;
            // Sentinel = 'aHasUserActivation'
            if ((!(((&(reader__)))->ReadSentinel(1109133103)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebIdentity::Reply_GetIdentityCredential(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetIdentityCredentialResolver resolver = [resolver__ = std::move(resolver__)](const WebIdentityGetCredentialResponse& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'response'
                    ((&(writer__)))->WriteSentinel(260965232);

                    if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebIdentityParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebIdentityParent*>(this))->RecvGetIdentityCredential(std::move(aOptions), std::move(aMediationRequirement), std::move(aHasUserActivation), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebIdentity::Msg_DisconnectIdentityCredential__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebIdentityParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebIdentity::Msg_DisconnectIdentityCredential", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aOptions = IPC::ReadParam<IdentityCredentialDisconnectOptions>((&(reader__)));
            if (!maybe__aOptions) {
                FatalError("Error deserializing 'IdentityCredentialDisconnectOptions'");
                return MsgValueError;

            }
            auto& aOptions = *maybe__aOptions;
            // Sentinel = 'aOptions'
            if ((!(((&(reader__)))->ReadSentinel(240976718)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IdentityCredentialDisconnectOptions'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebIdentity::Reply_DisconnectIdentityCredential(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            DisconnectIdentityCredentialResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'rv'
                    ((&(writer__)))->WriteSentinel(22806761);

                    if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebIdentityParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebIdentityParent*>(this))->RecvDisconnectIdentityCredential(std::move(aOptions), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebIdentity::Msg_PreventSilentAccess__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebIdentityParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebIdentity::Msg_PreventSilentAccess", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebIdentity::Reply_PreventSilentAccess(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            PreventSilentAccessResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'rv'
                    ((&(writer__)))->WriteSentinel(22806761);

                    if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebIdentityParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebIdentityParent*>(this))->RecvPreventSilentAccess(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebIdentity::Msg_SetLoginStatus__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebIdentityParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebIdentity::Msg_SetLoginStatus", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__foo = IPC::ReadParam<LoginStatus>((&(reader__)));
            if (!maybe__foo) {
                FatalError("Error deserializing 'LoginStatus'");
                return MsgValueError;

            }
            auto& foo = *maybe__foo;
            // Sentinel = 'foo'
            if ((!(((&(reader__)))->ReadSentinel(42074437)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LoginStatus'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebIdentity::Reply_SetLoginStatus(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            SetLoginStatusResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'rv'
                    ((&(writer__)))->WriteSentinel(22806761);

                    if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebIdentityParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebIdentityParent*>(this))->RecvSetLoginStatus(std::move(foo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebIdentity::Msg_ResolveContinuationWindow__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebIdentityParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebIdentity::Msg_ResolveContinuationWindow", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__token = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__token) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& token = *maybe__token;
            // Sentinel = 'token'
            if ((!(((&(reader__)))->ReadSentinel(108921378)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__options = IPC::ReadParam<IdentityResolveOptions>((&(reader__)));
            if (!maybe__options) {
                FatalError("Error deserializing 'IdentityResolveOptions'");
                return MsgValueError;

            }
            auto& options = *maybe__options;
            // Sentinel = 'options'
            if ((!(((&(reader__)))->ReadSentinel(204735245)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IdentityResolveOptions'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebIdentity::Reply_ResolveContinuationWindow(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ResolveContinuationWindowResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'rv'
                    ((&(writer__)))->WriteSentinel(22806761);

                    if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebIdentityParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebIdentityParent*>(this))->RecvResolveContinuationWindow(std::move(token), std::move(options), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebIdentity::Msg_IsActiveContinuationWindow__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebIdentityParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebIdentity::Msg_IsActiveContinuationWindow", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PWebIdentity::Reply_IsActiveContinuationWindow(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            IsActiveContinuationWindowResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PWebIdentityParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<WebIdentityParent*>(this))->RecvIsActiveContinuationWindow(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebIdentity::Reply_OpenContinuationWindow__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebIdentity", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebIdentityParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PWebIdentity::Msg_OpenContinuationWindow", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PWebIdentity::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebIdentityParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebIdentityParent::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PWebIdentityParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PWebIdentity'
    (aWriter)->WriteSentinel(484508857);
}

auto ParamTraits<::mozilla::dom::PWebIdentityParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PWebIdentity actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PWebIdentity'
    if ((!((aReader)->ReadSentinel(484508857)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PWebIdentity actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PWebIdentityMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PWebIdentity)");

        return {};
    }
    return static_cast<::mozilla::dom::PWebIdentityParent*>(actor);
}

} // namespace IPC
