//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PBackgroundIDBSharedTypes_h
#define PBackgroundIDBSharedTypes_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/dom/IDBCursor.h"
#include "mozilla/dom/IndexedDatabase.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/quota/PersistenceType.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/SerializedStructuredCloneBuffer.h"
#include "mozilla/ipc/SideVariant.h"
#include "mozilla/dom/DOMTypes.h"
#include "mozilla/dom/IPCBlob.h"
#include "mozilla/ipc/ProtocolTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SerializedKeyRange|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class SerializedKeyRange final
{
private:
    typedef ::mozilla::dom::indexedDB::Key Key;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SerializedKeyRange() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SerializedKeyRange(
            const Key& _lower,
            const Key& _upper,
            const bool& _lowerOpen,
            const bool& _upperOpen,
            const bool& _isOnly) :
        lower_(_lower),
        upper_(_upper),
        lowerOpen_(_lowerOpen),
        upperOpen_(_upperOpen),
        isOnly_(_isOnly)
    {
    }

    MOZ_IMPLICIT SerializedKeyRange(
            Key&& _lower,
            Key&& _upper,
            bool&& _lowerOpen,
            bool&& _upperOpen,
            bool&& _isOnly) :
        lower_(std::move(_lower)),
        upper_(std::move(_upper)),
        lowerOpen_(std::move(_lowerOpen)),
        upperOpen_(std::move(_upperOpen)),
        isOnly_(std::move(_isOnly))
    {
    }

    Key&
    lower()
    {
        return lower_;
    }
    const Key&
    lower() const
    {
        return lower_;
    }

    Key&
    upper()
    {
        return upper_;
    }
    const Key&
    upper() const
    {
        return upper_;
    }

    bool&
    lowerOpen()
    {
        return lowerOpen_;
    }
    const bool&
    lowerOpen() const
    {
        return lowerOpen_;
    }

    bool&
    upperOpen()
    {
        return upperOpen_;
    }
    const bool&
    upperOpen() const
    {
        return upperOpen_;
    }

    bool&
    isOnly()
    {
        return isOnly_;
    }
    const bool&
    isOnly() const
    {
        return isOnly_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<Key> lower_;
    ::mozilla::ipc::IPDLStructMember<Key> upper_;
    ::mozilla::ipc::IPDLStructMember<bool> lowerOpen_;
    ::mozilla::ipc::IPDLStructMember<bool> upperOpen_;
    ::mozilla::ipc::IPDLStructMember<bool> isOnly_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::SerializedKeyRange>
{
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union NullableBlob|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class NullableBlob final
{
public:
    enum Type {
        T__None,
        Tnull_t = 1,
        TIPCBlob,
        T__Last = TIPCBlob
    };

private:
    typedef ::mozilla::null_t null_t;
    typedef ::mozilla::dom::IPCBlob IPCBlob;
    typedef null_t null_t__tdef;
    typedef IPCBlob IPCBlob__tdef;

    null_t*
    ptr_null_t()
    {
        return (&(mVnull_t));
    }
    const null_t*
    constptr_null_t() const
    {
        return (&(mVnull_t));
    }
    IPCBlob*
    ptr_IPCBlob()
    {
        return (&(mVIPCBlob));
    }
    const IPCBlob*
    constptr_IPCBlob() const
    {
        return (&(mVIPCBlob));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT NullableBlob() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT NullableBlob(const null_t& aOther);

    MOZ_IMPLICIT NullableBlob(null_t&& aOther);

    MOZ_IMPLICIT NullableBlob(const IPCBlob& aOther);

    MOZ_IMPLICIT NullableBlob(IPCBlob&& aOther);

    MOZ_IMPLICIT NullableBlob(const NullableBlob& aOther);

    MOZ_IMPLICIT NullableBlob(NullableBlob&& aOther);

    ~NullableBlob();

    Type
    type() const
    {
        return mType;
    }

    NullableBlob&
    operator=(const null_t& aRhs);

    NullableBlob&
    operator=(null_t&& aRhs);

    NullableBlob&
    operator=(const IPCBlob& aRhs);

    NullableBlob&
    operator=(IPCBlob&& aRhs);

    NullableBlob&
    operator=(const NullableBlob& aRhs);

    NullableBlob&
    operator=(NullableBlob&& aRhs);

    null_t&
    get_null_t()
    {
        AssertSanity(Tnull_t);
        return (*(ptr_null_t()));
    }
    const null_t&
    get_null_t() const
    {
        AssertSanity(Tnull_t);
        return (*(constptr_null_t()));
    }
    operator null_t&()
    {
        return get_null_t();
    }
    operator const null_t&() const
    {
        return get_null_t();
    }

    IPCBlob&
    get_IPCBlob()
    {
        AssertSanity(TIPCBlob);
        return (*(ptr_IPCBlob()));
    }
    const IPCBlob&
    get_IPCBlob() const
    {
        AssertSanity(TIPCBlob);
        return (*(constptr_IPCBlob()));
    }
    operator IPCBlob&()
    {
        return get_IPCBlob();
    }
    operator const IPCBlob&() const
    {
        return get_IPCBlob();
    }

private:
    union {
        null_t mVnull_t;
        IPCBlob mVIPCBlob;
    };
    Type mType;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::NullableBlob>
{
    typedef ::mozilla::dom::indexedDB::NullableBlob paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SerializedStructuredCloneFile|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class SerializedStructuredCloneFile final
{
private:
    typedef ::mozilla::dom::indexedDB::NullableBlob NullableBlob;
    typedef ::mozilla::dom::indexedDB::StructuredCloneFileBase::FileType FileType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SerializedStructuredCloneFile() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SerializedStructuredCloneFile(
            const NullableBlob& _file,
            const FileType& _type) :
        file_(_file),
        type_(_type)
    {
    }

    MOZ_IMPLICIT SerializedStructuredCloneFile(
            NullableBlob&& _file,
            FileType&& _type) :
        file_(std::move(_file)),
        type_(std::move(_type))
    {
    }

    NullableBlob&
    file()
    {
        return file_;
    }
    const NullableBlob&
    file() const
    {
        return file_;
    }

    FileType&
    type()
    {
        return type_;
    }
    const FileType&
    type() const
    {
        return type_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<NullableBlob> file_;
    ::mozilla::ipc::IPDLStructMember<FileType> type_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::SerializedStructuredCloneFile>
{
    typedef ::mozilla::dom::indexedDB::SerializedStructuredCloneFile paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SerializedStructuredCloneReadInfo|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class SerializedStructuredCloneReadInfo final
{
private:
    typedef ::mozilla::SerializedStructuredCloneBuffer SerializedStructuredCloneBuffer;
    typedef ::mozilla::dom::indexedDB::SerializedStructuredCloneFile SerializedStructuredCloneFile;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SerializedStructuredCloneReadInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SerializedStructuredCloneReadInfo(
            SerializedStructuredCloneBuffer&& _data,
            const nsTArray<SerializedStructuredCloneFile>& _files,
            const bool& _hasPreprocessInfo) :
        data_(std::move(_data)),
        files_(_files),
        hasPreprocessInfo_(_hasPreprocessInfo)
    {
    }

    MOZ_IMPLICIT SerializedStructuredCloneReadInfo(
            SerializedStructuredCloneBuffer&& _data,
            nsTArray<SerializedStructuredCloneFile>&& _files,
            bool&& _hasPreprocessInfo) :
        data_(std::move(_data)),
        files_(std::move(_files)),
        hasPreprocessInfo_(std::move(_hasPreprocessInfo))
    {
    }

    SerializedStructuredCloneBuffer&
    data()
    {
        return data_;
    }
    const SerializedStructuredCloneBuffer&
    data() const
    {
        return data_;
    }

    nsTArray<SerializedStructuredCloneFile>&
    files()
    {
        return files_;
    }
    const nsTArray<SerializedStructuredCloneFile>&
    files() const
    {
        return files_;
    }

    bool&
    hasPreprocessInfo()
    {
        return hasPreprocessInfo_;
    }
    const bool&
    hasPreprocessInfo() const
    {
        return hasPreprocessInfo_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SerializedStructuredCloneBuffer> data_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<SerializedStructuredCloneFile>> files_;
    ::mozilla::ipc::IPDLStructMember<bool> hasPreprocessInfo_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::SerializedStructuredCloneReadInfo>
{
    typedef ::mozilla::dom::indexedDB::SerializedStructuredCloneReadInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct SerializedStructuredCloneWriteInfo|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class SerializedStructuredCloneWriteInfo final
{
private:
    typedef ::mozilla::SerializedStructuredCloneBuffer SerializedStructuredCloneBuffer;
    typedef ::uint64_t uint64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    SerializedStructuredCloneWriteInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT SerializedStructuredCloneWriteInfo(
            SerializedStructuredCloneBuffer&& _data,
            const uint64_t& _offsetToKeyProp) :
        data_(std::move(_data)),
        offsetToKeyProp_(_offsetToKeyProp)
    {
    }

    MOZ_IMPLICIT SerializedStructuredCloneWriteInfo(
            SerializedStructuredCloneBuffer&& _data,
            uint64_t&& _offsetToKeyProp) :
        data_(std::move(_data)),
        offsetToKeyProp_(std::move(_offsetToKeyProp))
    {
    }

    SerializedStructuredCloneBuffer&
    data()
    {
        return data_;
    }
    const SerializedStructuredCloneBuffer&
    data() const
    {
        return data_;
    }

    uint64_t&
    offsetToKeyProp()
    {
        return offsetToKeyProp_;
    }
    const uint64_t&
    offsetToKeyProp() const
    {
        return offsetToKeyProp_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SerializedStructuredCloneBuffer> data_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> offsetToKeyProp_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::SerializedStructuredCloneWriteInfo>
{
    typedef ::mozilla::dom::indexedDB::SerializedStructuredCloneWriteInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexUpdateInfo|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexUpdateInfo final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::Key Key;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexUpdateInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexUpdateInfo(
            const int64_t& _indexId,
            const Key& _value,
            const Key& _localizedValue) :
        value_(_value),
        localizedValue_(_localizedValue),
        indexId_(_indexId)
    {
    }

    MOZ_IMPLICIT IndexUpdateInfo(
            int64_t&& _indexId,
            Key&& _value,
            Key&& _localizedValue) :
        value_(std::move(_value)),
        localizedValue_(std::move(_localizedValue)),
        indexId_(std::move(_indexId))
    {
    }

    int64_t&
    indexId()
    {
        return indexId_;
    }
    const int64_t&
    indexId() const
    {
        return indexId_;
    }

    Key&
    value()
    {
        return value_;
    }
    const Key&
    value() const
    {
        return value_;
    }

    Key&
    localizedValue()
    {
        return localizedValue_;
    }
    const Key&
    localizedValue() const
    {
        return localizedValue_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<Key> value_;
    ::mozilla::ipc::IPDLStructMember<Key> localizedValue_;
    ::mozilla::ipc::IPDLStructMember<int64_t> indexId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexUpdateInfo>
{
    typedef ::mozilla::dom::indexedDB::IndexUpdateInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct DatabaseMetadata|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class DatabaseMetadata final
{
private:
    typedef ::nsString nsString;
    typedef ::uint64_t uint64_t;
    typedef ::mozilla::dom::quota::PersistenceType PersistenceType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    DatabaseMetadata() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT DatabaseMetadata(
            const nsString& _name,
            const uint64_t& _version,
            const PersistenceType& _persistenceType) :
        name_(_name),
        persistenceType_(_persistenceType),
        version_(_version)
    {
    }

    MOZ_IMPLICIT DatabaseMetadata(
            nsString&& _name,
            uint64_t&& _version,
            PersistenceType&& _persistenceType) :
        name_(std::move(_name)),
        persistenceType_(std::move(_persistenceType)),
        version_(std::move(_version))
    {
    }

    nsString&
    name()
    {
        return name_;
    }
    const nsString&
    name() const
    {
        return name_;
    }

    uint64_t&
    version()
    {
        return version_;
    }
    const uint64_t&
    version() const
    {
        return version_;
    }

    PersistenceType&
    persistenceType()
    {
        return persistenceType_;
    }
    const PersistenceType&
    persistenceType() const
    {
        return persistenceType_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> name_;
    ::mozilla::ipc::IPDLStructMember<PersistenceType> persistenceType_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> version_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::DatabaseMetadata>
{
    typedef ::mozilla::dom::indexedDB::DatabaseMetadata paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreMetadata|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreMetadata final
{
private:
    typedef ::int64_t int64_t;
    typedef ::nsString nsString;
    typedef ::mozilla::dom::indexedDB::KeyPath KeyPath;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreMetadata() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreMetadata(
            const int64_t& _id,
            const nsString& _name,
            const KeyPath& _keyPath,
            const bool& _autoIncrement) :
        name_(_name),
        keyPath_(_keyPath),
        autoIncrement_(_autoIncrement),
        id_(_id)
    {
    }

    MOZ_IMPLICIT ObjectStoreMetadata(
            int64_t&& _id,
            nsString&& _name,
            KeyPath&& _keyPath,
            bool&& _autoIncrement) :
        name_(std::move(_name)),
        keyPath_(std::move(_keyPath)),
        autoIncrement_(std::move(_autoIncrement)),
        id_(std::move(_id))
    {
    }

    int64_t&
    id()
    {
        return id_;
    }
    const int64_t&
    id() const
    {
        return id_;
    }

    nsString&
    name()
    {
        return name_;
    }
    const nsString&
    name() const
    {
        return name_;
    }

    KeyPath&
    keyPath()
    {
        return keyPath_;
    }
    const KeyPath&
    keyPath() const
    {
        return keyPath_;
    }

    bool&
    autoIncrement()
    {
        return autoIncrement_;
    }
    const bool&
    autoIncrement() const
    {
        return autoIncrement_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> name_;
    ::mozilla::ipc::IPDLStructMember<KeyPath> keyPath_;
    ::mozilla::ipc::IPDLStructMember<bool> autoIncrement_;
    ::mozilla::ipc::IPDLStructMember<int64_t> id_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreMetadata>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreMetadata paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexMetadata|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexMetadata final
{
private:
    typedef ::int64_t int64_t;
    typedef ::nsString nsString;
    typedef ::mozilla::dom::indexedDB::KeyPath KeyPath;
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexMetadata() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexMetadata(
            const int64_t& _id,
            const nsString& _name,
            const KeyPath& _keyPath,
            const nsCString& _locale,
            const bool& _unique,
            const bool& _multiEntry,
            const bool& _autoLocale) :
        name_(_name),
        keyPath_(_keyPath),
        locale_(_locale),
        unique_(_unique),
        multiEntry_(_multiEntry),
        autoLocale_(_autoLocale),
        id_(_id)
    {
    }

    MOZ_IMPLICIT IndexMetadata(
            int64_t&& _id,
            nsString&& _name,
            KeyPath&& _keyPath,
            nsCString&& _locale,
            bool&& _unique,
            bool&& _multiEntry,
            bool&& _autoLocale) :
        name_(std::move(_name)),
        keyPath_(std::move(_keyPath)),
        locale_(std::move(_locale)),
        unique_(std::move(_unique)),
        multiEntry_(std::move(_multiEntry)),
        autoLocale_(std::move(_autoLocale)),
        id_(std::move(_id))
    {
    }

    int64_t&
    id()
    {
        return id_;
    }
    const int64_t&
    id() const
    {
        return id_;
    }

    nsString&
    name()
    {
        return name_;
    }
    const nsString&
    name() const
    {
        return name_;
    }

    KeyPath&
    keyPath()
    {
        return keyPath_;
    }
    const KeyPath&
    keyPath() const
    {
        return keyPath_;
    }

    nsCString&
    locale()
    {
        return locale_;
    }
    const nsCString&
    locale() const
    {
        return locale_;
    }

    bool&
    unique()
    {
        return unique_;
    }
    const bool&
    unique() const
    {
        return unique_;
    }

    bool&
    multiEntry()
    {
        return multiEntry_;
    }
    const bool&
    multiEntry() const
    {
        return multiEntry_;
    }

    bool&
    autoLocale()
    {
        return autoLocale_;
    }
    const bool&
    autoLocale() const
    {
        return autoLocale_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> name_;
    ::mozilla::ipc::IPDLStructMember<KeyPath> keyPath_;
    ::mozilla::ipc::IPDLStructMember<nsCString> locale_;
    ::mozilla::ipc::IPDLStructMember<bool> unique_;
    ::mozilla::ipc::IPDLStructMember<bool> multiEntry_;
    ::mozilla::ipc::IPDLStructMember<bool> autoLocale_;
    ::mozilla::ipc::IPDLStructMember<int64_t> id_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexMetadata>
{
    typedef ::mozilla::dom::indexedDB::IndexMetadata paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreSpec|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreSpec final
{
private:
    typedef ::mozilla::dom::indexedDB::ObjectStoreMetadata ObjectStoreMetadata;
    typedef ::mozilla::dom::indexedDB::IndexMetadata IndexMetadata;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreSpec() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreSpec(
            const ObjectStoreMetadata& _metadata,
            const nsTArray<IndexMetadata>& _indexes) :
        metadata_(_metadata),
        indexes_(_indexes)
    {
    }

    MOZ_IMPLICIT ObjectStoreSpec(
            ObjectStoreMetadata&& _metadata,
            nsTArray<IndexMetadata>&& _indexes) :
        metadata_(std::move(_metadata)),
        indexes_(std::move(_indexes))
    {
    }

    ObjectStoreMetadata&
    metadata()
    {
        return metadata_;
    }
    const ObjectStoreMetadata&
    metadata() const
    {
        return metadata_;
    }

    nsTArray<IndexMetadata>&
    indexes()
    {
        return indexes_;
    }
    const nsTArray<IndexMetadata>&
    indexes() const
    {
        return indexes_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ObjectStoreMetadata> metadata_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<IndexMetadata>> indexes_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreSpec>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreSpec paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct DatabaseSpec|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class DatabaseSpec final
{
private:
    typedef ::mozilla::dom::indexedDB::DatabaseMetadata DatabaseMetadata;
    typedef ::mozilla::dom::indexedDB::ObjectStoreSpec ObjectStoreSpec;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    DatabaseSpec() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT DatabaseSpec(
            const DatabaseMetadata& _metadata,
            const nsTArray<ObjectStoreSpec>& _objectStores) :
        metadata_(_metadata),
        objectStores_(_objectStores)
    {
    }

    MOZ_IMPLICIT DatabaseSpec(
            DatabaseMetadata&& _metadata,
            nsTArray<ObjectStoreSpec>&& _objectStores) :
        metadata_(std::move(_metadata)),
        objectStores_(std::move(_objectStores))
    {
    }

    DatabaseMetadata&
    metadata()
    {
        return metadata_;
    }
    const DatabaseMetadata&
    metadata() const
    {
        return metadata_;
    }

    nsTArray<ObjectStoreSpec>&
    objectStores()
    {
        return objectStores_;
    }
    const nsTArray<ObjectStoreSpec>&
    objectStores() const
    {
        return objectStores_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<DatabaseMetadata> metadata_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<ObjectStoreSpec>> objectStores_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::DatabaseSpec>
{
    typedef ::mozilla::dom::indexedDB::DatabaseSpec paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CommonOpenCursorParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class CommonOpenCursorParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;
    typedef ::mozilla::dom::IDBCursor::Direction Direction;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CommonOpenCursorParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CommonOpenCursorParams(
            const int64_t& _objectStoreId,
            const mozilla::Maybe<SerializedKeyRange>& _optionalKeyRange,
            const Direction& _direction) :
        optionalKeyRange_(_optionalKeyRange),
        direction_(_direction),
        objectStoreId_(_objectStoreId)
    {
    }

    MOZ_IMPLICIT CommonOpenCursorParams(
            int64_t&& _objectStoreId,
            mozilla::Maybe<SerializedKeyRange>&& _optionalKeyRange,
            Direction&& _direction) :
        optionalKeyRange_(std::move(_optionalKeyRange)),
        direction_(std::move(_direction)),
        objectStoreId_(std::move(_objectStoreId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange()
    {
        return optionalKeyRange_;
    }
    const mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange() const
    {
        return optionalKeyRange_;
    }

    Direction&
    direction()
    {
        return direction_;
    }
    const Direction&
    direction() const
    {
        return direction_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<SerializedKeyRange>> optionalKeyRange_;
    ::mozilla::ipc::IPDLStructMember<Direction> direction_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::CommonOpenCursorParams>
{
    typedef ::mozilla::dom::indexedDB::CommonOpenCursorParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreOpenCursorParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreOpenCursorParams final
{
private:
    typedef ::mozilla::dom::indexedDB::CommonOpenCursorParams CommonOpenCursorParams;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreOpenCursorParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreOpenCursorParams(const CommonOpenCursorParams& _commonParams) :
        commonParams_(_commonParams)
    {
    }

    MOZ_IMPLICIT ObjectStoreOpenCursorParams(CommonOpenCursorParams&& _commonParams) :
        commonParams_(std::move(_commonParams))
    {
    }

    CommonOpenCursorParams&
    commonParams()
    {
        return commonParams_;
    }
    const CommonOpenCursorParams&
    commonParams() const
    {
        return commonParams_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CommonOpenCursorParams> commonParams_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreOpenCursorParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreOpenCursorParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreOpenKeyCursorParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreOpenKeyCursorParams final
{
private:
    typedef ::mozilla::dom::indexedDB::CommonOpenCursorParams CommonOpenCursorParams;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreOpenKeyCursorParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreOpenKeyCursorParams(const CommonOpenCursorParams& _commonParams) :
        commonParams_(_commonParams)
    {
    }

    MOZ_IMPLICIT ObjectStoreOpenKeyCursorParams(CommonOpenCursorParams&& _commonParams) :
        commonParams_(std::move(_commonParams))
    {
    }

    CommonOpenCursorParams&
    commonParams()
    {
        return commonParams_;
    }
    const CommonOpenCursorParams&
    commonParams() const
    {
        return commonParams_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CommonOpenCursorParams> commonParams_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreOpenKeyCursorParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreOpenKeyCursorParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CommonIndexOpenCursorParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class CommonIndexOpenCursorParams final
{
private:
    typedef ::mozilla::dom::indexedDB::CommonOpenCursorParams CommonOpenCursorParams;
    typedef ::int64_t int64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CommonIndexOpenCursorParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CommonIndexOpenCursorParams(
            const CommonOpenCursorParams& _commonParams,
            const int64_t& _indexId) :
        commonParams_(_commonParams),
        indexId_(_indexId)
    {
    }

    MOZ_IMPLICIT CommonIndexOpenCursorParams(
            CommonOpenCursorParams&& _commonParams,
            int64_t&& _indexId) :
        commonParams_(std::move(_commonParams)),
        indexId_(std::move(_indexId))
    {
    }

    CommonOpenCursorParams&
    commonParams()
    {
        return commonParams_;
    }
    const CommonOpenCursorParams&
    commonParams() const
    {
        return commonParams_;
    }

    int64_t&
    indexId()
    {
        return indexId_;
    }
    const int64_t&
    indexId() const
    {
        return indexId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CommonOpenCursorParams> commonParams_;
    ::mozilla::ipc::IPDLStructMember<int64_t> indexId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::CommonIndexOpenCursorParams>
{
    typedef ::mozilla::dom::indexedDB::CommonIndexOpenCursorParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexOpenCursorParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexOpenCursorParams final
{
private:
    typedef ::mozilla::dom::indexedDB::CommonIndexOpenCursorParams CommonIndexOpenCursorParams;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexOpenCursorParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexOpenCursorParams(const CommonIndexOpenCursorParams& _commonIndexParams) :
        commonIndexParams_(_commonIndexParams)
    {
    }

    MOZ_IMPLICIT IndexOpenCursorParams(CommonIndexOpenCursorParams&& _commonIndexParams) :
        commonIndexParams_(std::move(_commonIndexParams))
    {
    }

    CommonIndexOpenCursorParams&
    commonIndexParams()
    {
        return commonIndexParams_;
    }
    const CommonIndexOpenCursorParams&
    commonIndexParams() const
    {
        return commonIndexParams_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CommonIndexOpenCursorParams> commonIndexParams_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexOpenCursorParams>
{
    typedef ::mozilla::dom::indexedDB::IndexOpenCursorParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexOpenKeyCursorParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexOpenKeyCursorParams final
{
private:
    typedef ::mozilla::dom::indexedDB::CommonIndexOpenCursorParams CommonIndexOpenCursorParams;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexOpenKeyCursorParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexOpenKeyCursorParams(const CommonIndexOpenCursorParams& _commonIndexParams) :
        commonIndexParams_(_commonIndexParams)
    {
    }

    MOZ_IMPLICIT IndexOpenKeyCursorParams(CommonIndexOpenCursorParams&& _commonIndexParams) :
        commonIndexParams_(std::move(_commonIndexParams))
    {
    }

    CommonIndexOpenCursorParams&
    commonIndexParams()
    {
        return commonIndexParams_;
    }
    const CommonIndexOpenCursorParams&
    commonIndexParams() const
    {
        return commonIndexParams_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CommonIndexOpenCursorParams> commonIndexParams_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexOpenKeyCursorParams>
{
    typedef ::mozilla::dom::indexedDB::IndexOpenKeyCursorParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union OpenCursorParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class OpenCursorParams final
{
public:
    enum Type {
        T__None,
        TObjectStoreOpenCursorParams = 1,
        TObjectStoreOpenKeyCursorParams,
        TIndexOpenCursorParams,
        TIndexOpenKeyCursorParams,
        T__Last = TIndexOpenKeyCursorParams
    };

private:
    typedef ::mozilla::dom::indexedDB::ObjectStoreOpenCursorParams ObjectStoreOpenCursorParams;
    typedef ::mozilla::dom::indexedDB::ObjectStoreOpenKeyCursorParams ObjectStoreOpenKeyCursorParams;
    typedef ::mozilla::dom::indexedDB::IndexOpenCursorParams IndexOpenCursorParams;
    typedef ::mozilla::dom::indexedDB::IndexOpenKeyCursorParams IndexOpenKeyCursorParams;
    typedef ObjectStoreOpenCursorParams ObjectStoreOpenCursorParams__tdef;
    typedef ObjectStoreOpenKeyCursorParams ObjectStoreOpenKeyCursorParams__tdef;
    typedef IndexOpenCursorParams IndexOpenCursorParams__tdef;
    typedef IndexOpenKeyCursorParams IndexOpenKeyCursorParams__tdef;

    ObjectStoreOpenCursorParams*
    ptr_ObjectStoreOpenCursorParams()
    {
        return (&(mVObjectStoreOpenCursorParams));
    }
    const ObjectStoreOpenCursorParams*
    constptr_ObjectStoreOpenCursorParams() const
    {
        return (&(mVObjectStoreOpenCursorParams));
    }
    ObjectStoreOpenKeyCursorParams*
    ptr_ObjectStoreOpenKeyCursorParams()
    {
        return (&(mVObjectStoreOpenKeyCursorParams));
    }
    const ObjectStoreOpenKeyCursorParams*
    constptr_ObjectStoreOpenKeyCursorParams() const
    {
        return (&(mVObjectStoreOpenKeyCursorParams));
    }
    IndexOpenCursorParams*
    ptr_IndexOpenCursorParams()
    {
        return (&(mVIndexOpenCursorParams));
    }
    const IndexOpenCursorParams*
    constptr_IndexOpenCursorParams() const
    {
        return (&(mVIndexOpenCursorParams));
    }
    IndexOpenKeyCursorParams*
    ptr_IndexOpenKeyCursorParams()
    {
        return (&(mVIndexOpenKeyCursorParams));
    }
    const IndexOpenKeyCursorParams*
    constptr_IndexOpenKeyCursorParams() const
    {
        return (&(mVIndexOpenKeyCursorParams));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT OpenCursorParams() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT OpenCursorParams(const ObjectStoreOpenCursorParams& aOther);

    MOZ_IMPLICIT OpenCursorParams(ObjectStoreOpenCursorParams&& aOther);

    MOZ_IMPLICIT OpenCursorParams(const ObjectStoreOpenKeyCursorParams& aOther);

    MOZ_IMPLICIT OpenCursorParams(ObjectStoreOpenKeyCursorParams&& aOther);

    MOZ_IMPLICIT OpenCursorParams(const IndexOpenCursorParams& aOther);

    MOZ_IMPLICIT OpenCursorParams(IndexOpenCursorParams&& aOther);

    MOZ_IMPLICIT OpenCursorParams(const IndexOpenKeyCursorParams& aOther);

    MOZ_IMPLICIT OpenCursorParams(IndexOpenKeyCursorParams&& aOther);

    MOZ_IMPLICIT OpenCursorParams(const OpenCursorParams& aOther);

    MOZ_IMPLICIT OpenCursorParams(OpenCursorParams&& aOther);

    ~OpenCursorParams();

    Type
    type() const
    {
        return mType;
    }

    OpenCursorParams&
    operator=(const ObjectStoreOpenCursorParams& aRhs);

    OpenCursorParams&
    operator=(ObjectStoreOpenCursorParams&& aRhs);

    OpenCursorParams&
    operator=(const ObjectStoreOpenKeyCursorParams& aRhs);

    OpenCursorParams&
    operator=(ObjectStoreOpenKeyCursorParams&& aRhs);

    OpenCursorParams&
    operator=(const IndexOpenCursorParams& aRhs);

    OpenCursorParams&
    operator=(IndexOpenCursorParams&& aRhs);

    OpenCursorParams&
    operator=(const IndexOpenKeyCursorParams& aRhs);

    OpenCursorParams&
    operator=(IndexOpenKeyCursorParams&& aRhs);

    OpenCursorParams&
    operator=(const OpenCursorParams& aRhs);

    OpenCursorParams&
    operator=(OpenCursorParams&& aRhs);

    ObjectStoreOpenCursorParams&
    get_ObjectStoreOpenCursorParams()
    {
        AssertSanity(TObjectStoreOpenCursorParams);
        return (*(ptr_ObjectStoreOpenCursorParams()));
    }
    const ObjectStoreOpenCursorParams&
    get_ObjectStoreOpenCursorParams() const
    {
        AssertSanity(TObjectStoreOpenCursorParams);
        return (*(constptr_ObjectStoreOpenCursorParams()));
    }
    operator ObjectStoreOpenCursorParams&()
    {
        return get_ObjectStoreOpenCursorParams();
    }
    operator const ObjectStoreOpenCursorParams&() const
    {
        return get_ObjectStoreOpenCursorParams();
    }

    ObjectStoreOpenKeyCursorParams&
    get_ObjectStoreOpenKeyCursorParams()
    {
        AssertSanity(TObjectStoreOpenKeyCursorParams);
        return (*(ptr_ObjectStoreOpenKeyCursorParams()));
    }
    const ObjectStoreOpenKeyCursorParams&
    get_ObjectStoreOpenKeyCursorParams() const
    {
        AssertSanity(TObjectStoreOpenKeyCursorParams);
        return (*(constptr_ObjectStoreOpenKeyCursorParams()));
    }
    operator ObjectStoreOpenKeyCursorParams&()
    {
        return get_ObjectStoreOpenKeyCursorParams();
    }
    operator const ObjectStoreOpenKeyCursorParams&() const
    {
        return get_ObjectStoreOpenKeyCursorParams();
    }

    IndexOpenCursorParams&
    get_IndexOpenCursorParams()
    {
        AssertSanity(TIndexOpenCursorParams);
        return (*(ptr_IndexOpenCursorParams()));
    }
    const IndexOpenCursorParams&
    get_IndexOpenCursorParams() const
    {
        AssertSanity(TIndexOpenCursorParams);
        return (*(constptr_IndexOpenCursorParams()));
    }
    operator IndexOpenCursorParams&()
    {
        return get_IndexOpenCursorParams();
    }
    operator const IndexOpenCursorParams&() const
    {
        return get_IndexOpenCursorParams();
    }

    IndexOpenKeyCursorParams&
    get_IndexOpenKeyCursorParams()
    {
        AssertSanity(TIndexOpenKeyCursorParams);
        return (*(ptr_IndexOpenKeyCursorParams()));
    }
    const IndexOpenKeyCursorParams&
    get_IndexOpenKeyCursorParams() const
    {
        AssertSanity(TIndexOpenKeyCursorParams);
        return (*(constptr_IndexOpenKeyCursorParams()));
    }
    operator IndexOpenKeyCursorParams&()
    {
        return get_IndexOpenKeyCursorParams();
    }
    operator const IndexOpenKeyCursorParams&() const
    {
        return get_IndexOpenKeyCursorParams();
    }

private:
    union {
        ObjectStoreOpenCursorParams mVObjectStoreOpenCursorParams;
        ObjectStoreOpenKeyCursorParams mVObjectStoreOpenKeyCursorParams;
        IndexOpenCursorParams mVIndexOpenCursorParams;
        IndexOpenKeyCursorParams mVIndexOpenKeyCursorParams;
    };
    Type mType;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::OpenCursorParams>
{
    typedef ::mozilla::dom::indexedDB::OpenCursorParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
namespace indexedDB {
class PBackgroundIDBDatabaseFileParent;
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
namespace indexedDB {
class PBackgroundIDBDatabaseFileChild;
} // namespace indexedDB
} // namespace dom
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileAddInfo|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class FileAddInfo final
{
private:
    typedef ::mozilla::dom::indexedDB::PBackgroundIDBDatabaseFileParent PBackgroundIDBDatabaseFileParent;
    typedef ::mozilla::dom::indexedDB::PBackgroundIDBDatabaseFileChild PBackgroundIDBDatabaseFileChild;
    typedef ::mozilla::dom::indexedDB::StructuredCloneFileBase::FileType FileType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileAddInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileAddInfo(
            const mozilla::NotNull<::mozilla::ipc::SideVariant<PBackgroundIDBDatabaseFileParent*, PBackgroundIDBDatabaseFileChild*>>& _file,
            const FileType& _type) :
        file_(_file),
        type_(_type)
    {
    }

    MOZ_IMPLICIT FileAddInfo(
            mozilla::NotNull<::mozilla::ipc::SideVariant<PBackgroundIDBDatabaseFileParent*, PBackgroundIDBDatabaseFileChild*>>&& _file,
            FileType&& _type) :
        file_(std::move(_file)),
        type_(std::move(_type))
    {
    }

    mozilla::NotNull<::mozilla::ipc::SideVariant<PBackgroundIDBDatabaseFileParent*, PBackgroundIDBDatabaseFileChild*>>&
    file()
    {
        return file_;
    }
    const mozilla::NotNull<::mozilla::ipc::SideVariant<PBackgroundIDBDatabaseFileParent*, PBackgroundIDBDatabaseFileChild*>>&
    file() const
    {
        return file_;
    }

    FileType&
    type()
    {
        return type_;
    }
    const FileType&
    type() const
    {
        return type_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::NotNull<::mozilla::ipc::SideVariant<PBackgroundIDBDatabaseFileParent*, PBackgroundIDBDatabaseFileChild*>>> file_;
    ::mozilla::ipc::IPDLStructMember<FileType> type_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::FileAddInfo>
{
    typedef ::mozilla::dom::indexedDB::FileAddInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreAddPutParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreAddPutParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedStructuredCloneWriteInfo SerializedStructuredCloneWriteInfo;
    typedef ::mozilla::dom::indexedDB::Key Key;
    typedef ::mozilla::dom::indexedDB::IndexUpdateInfo IndexUpdateInfo;
    typedef ::mozilla::dom::indexedDB::FileAddInfo FileAddInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreAddPutParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreAddPutParams(
            const int64_t& _objectStoreId,
            SerializedStructuredCloneWriteInfo&& _cloneInfo,
            const Key& _key,
            const nsTArray<IndexUpdateInfo>& _indexUpdateInfos,
            const nsTArray<FileAddInfo>& _fileAddInfos) :
        cloneInfo_(std::move(_cloneInfo)),
        key_(_key),
        indexUpdateInfos_(_indexUpdateInfos),
        fileAddInfos_(_fileAddInfos),
        objectStoreId_(_objectStoreId)
    {
    }

    MOZ_IMPLICIT ObjectStoreAddPutParams(
            int64_t&& _objectStoreId,
            SerializedStructuredCloneWriteInfo&& _cloneInfo,
            Key&& _key,
            nsTArray<IndexUpdateInfo>&& _indexUpdateInfos,
            nsTArray<FileAddInfo>&& _fileAddInfos) :
        cloneInfo_(std::move(_cloneInfo)),
        key_(std::move(_key)),
        indexUpdateInfos_(std::move(_indexUpdateInfos)),
        fileAddInfos_(std::move(_fileAddInfos)),
        objectStoreId_(std::move(_objectStoreId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    SerializedStructuredCloneWriteInfo&
    cloneInfo()
    {
        return cloneInfo_;
    }
    const SerializedStructuredCloneWriteInfo&
    cloneInfo() const
    {
        return cloneInfo_;
    }

    Key&
    key()
    {
        return key_;
    }
    const Key&
    key() const
    {
        return key_;
    }

    nsTArray<IndexUpdateInfo>&
    indexUpdateInfos()
    {
        return indexUpdateInfos_;
    }
    const nsTArray<IndexUpdateInfo>&
    indexUpdateInfos() const
    {
        return indexUpdateInfos_;
    }

    nsTArray<FileAddInfo>&
    fileAddInfos()
    {
        return fileAddInfos_;
    }
    const nsTArray<FileAddInfo>&
    fileAddInfos() const
    {
        return fileAddInfos_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SerializedStructuredCloneWriteInfo> cloneInfo_;
    ::mozilla::ipc::IPDLStructMember<Key> key_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<IndexUpdateInfo>> indexUpdateInfos_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<FileAddInfo>> fileAddInfos_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreAddPutParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreAddPutParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreAddParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreAddParams final
{
private:
    typedef ::mozilla::dom::indexedDB::ObjectStoreAddPutParams ObjectStoreAddPutParams;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreAddParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreAddParams(ObjectStoreAddPutParams&& _commonParams) :
        commonParams_(std::move(_commonParams))
    {
    }

    ObjectStoreAddPutParams&
    commonParams()
    {
        return commonParams_;
    }
    const ObjectStoreAddPutParams&
    commonParams() const
    {
        return commonParams_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ObjectStoreAddPutParams> commonParams_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreAddParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreAddParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStorePutParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStorePutParams final
{
private:
    typedef ::mozilla::dom::indexedDB::ObjectStoreAddPutParams ObjectStoreAddPutParams;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStorePutParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStorePutParams(ObjectStoreAddPutParams&& _commonParams) :
        commonParams_(std::move(_commonParams))
    {
    }

    ObjectStoreAddPutParams&
    commonParams()
    {
        return commonParams_;
    }
    const ObjectStoreAddPutParams&
    commonParams() const
    {
        return commonParams_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ObjectStoreAddPutParams> commonParams_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStorePutParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStorePutParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreGetParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreGetParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreGetParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreGetParams(
            const int64_t& _objectStoreId,
            const SerializedKeyRange& _keyRange) :
        keyRange_(_keyRange),
        objectStoreId_(_objectStoreId)
    {
    }

    MOZ_IMPLICIT ObjectStoreGetParams(
            int64_t&& _objectStoreId,
            SerializedKeyRange&& _keyRange) :
        keyRange_(std::move(_keyRange)),
        objectStoreId_(std::move(_objectStoreId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    SerializedKeyRange&
    keyRange()
    {
        return keyRange_;
    }
    const SerializedKeyRange&
    keyRange() const
    {
        return keyRange_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SerializedKeyRange> keyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreGetParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreGetParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreGetKeyParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreGetKeyParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreGetKeyParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreGetKeyParams(
            const int64_t& _objectStoreId,
            const SerializedKeyRange& _keyRange) :
        keyRange_(_keyRange),
        objectStoreId_(_objectStoreId)
    {
    }

    MOZ_IMPLICIT ObjectStoreGetKeyParams(
            int64_t&& _objectStoreId,
            SerializedKeyRange&& _keyRange) :
        keyRange_(std::move(_keyRange)),
        objectStoreId_(std::move(_objectStoreId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    SerializedKeyRange&
    keyRange()
    {
        return keyRange_;
    }
    const SerializedKeyRange&
    keyRange() const
    {
        return keyRange_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SerializedKeyRange> keyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreGetKeyParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreGetKeyParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreGetAllParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreGetAllParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreGetAllParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreGetAllParams(
            const int64_t& _objectStoreId,
            const mozilla::Maybe<SerializedKeyRange>& _optionalKeyRange,
            const uint32_t& _limit) :
        optionalKeyRange_(_optionalKeyRange),
        objectStoreId_(_objectStoreId),
        limit_(_limit)
    {
    }

    MOZ_IMPLICIT ObjectStoreGetAllParams(
            int64_t&& _objectStoreId,
            mozilla::Maybe<SerializedKeyRange>&& _optionalKeyRange,
            uint32_t&& _limit) :
        optionalKeyRange_(std::move(_optionalKeyRange)),
        objectStoreId_(std::move(_objectStoreId)),
        limit_(std::move(_limit))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange()
    {
        return optionalKeyRange_;
    }
    const mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange() const
    {
        return optionalKeyRange_;
    }

    uint32_t&
    limit()
    {
        return limit_;
    }
    const uint32_t&
    limit() const
    {
        return limit_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<SerializedKeyRange>> optionalKeyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> limit_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreGetAllParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreGetAllParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreGetAllKeysParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreGetAllKeysParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreGetAllKeysParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreGetAllKeysParams(
            const int64_t& _objectStoreId,
            const mozilla::Maybe<SerializedKeyRange>& _optionalKeyRange,
            const uint32_t& _limit) :
        optionalKeyRange_(_optionalKeyRange),
        objectStoreId_(_objectStoreId),
        limit_(_limit)
    {
    }

    MOZ_IMPLICIT ObjectStoreGetAllKeysParams(
            int64_t&& _objectStoreId,
            mozilla::Maybe<SerializedKeyRange>&& _optionalKeyRange,
            uint32_t&& _limit) :
        optionalKeyRange_(std::move(_optionalKeyRange)),
        objectStoreId_(std::move(_objectStoreId)),
        limit_(std::move(_limit))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange()
    {
        return optionalKeyRange_;
    }
    const mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange() const
    {
        return optionalKeyRange_;
    }

    uint32_t&
    limit()
    {
        return limit_;
    }
    const uint32_t&
    limit() const
    {
        return limit_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<SerializedKeyRange>> optionalKeyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> limit_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreGetAllKeysParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreGetAllKeysParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreDeleteParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreDeleteParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreDeleteParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreDeleteParams(
            const int64_t& _objectStoreId,
            const SerializedKeyRange& _keyRange) :
        keyRange_(_keyRange),
        objectStoreId_(_objectStoreId)
    {
    }

    MOZ_IMPLICIT ObjectStoreDeleteParams(
            int64_t&& _objectStoreId,
            SerializedKeyRange&& _keyRange) :
        keyRange_(std::move(_keyRange)),
        objectStoreId_(std::move(_objectStoreId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    SerializedKeyRange&
    keyRange()
    {
        return keyRange_;
    }
    const SerializedKeyRange&
    keyRange() const
    {
        return keyRange_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SerializedKeyRange> keyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreDeleteParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreDeleteParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreClearParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreClearParams final
{
private:
    typedef ::int64_t int64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreClearParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreClearParams(const int64_t& _objectStoreId) :
        objectStoreId_(_objectStoreId)
    {
    }

    MOZ_IMPLICIT ObjectStoreClearParams(int64_t&& _objectStoreId) :
        objectStoreId_(std::move(_objectStoreId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreClearParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreClearParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ObjectStoreCountParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class ObjectStoreCountParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ObjectStoreCountParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ObjectStoreCountParams(
            const int64_t& _objectStoreId,
            const mozilla::Maybe<SerializedKeyRange>& _optionalKeyRange) :
        optionalKeyRange_(_optionalKeyRange),
        objectStoreId_(_objectStoreId)
    {
    }

    MOZ_IMPLICIT ObjectStoreCountParams(
            int64_t&& _objectStoreId,
            mozilla::Maybe<SerializedKeyRange>&& _optionalKeyRange) :
        optionalKeyRange_(std::move(_optionalKeyRange)),
        objectStoreId_(std::move(_objectStoreId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange()
    {
        return optionalKeyRange_;
    }
    const mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange() const
    {
        return optionalKeyRange_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<SerializedKeyRange>> optionalKeyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::ObjectStoreCountParams>
{
    typedef ::mozilla::dom::indexedDB::ObjectStoreCountParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexGetParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexGetParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexGetParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexGetParams(
            const int64_t& _objectStoreId,
            const int64_t& _indexId,
            const SerializedKeyRange& _keyRange) :
        keyRange_(_keyRange),
        objectStoreId_(_objectStoreId),
        indexId_(_indexId)
    {
    }

    MOZ_IMPLICIT IndexGetParams(
            int64_t&& _objectStoreId,
            int64_t&& _indexId,
            SerializedKeyRange&& _keyRange) :
        keyRange_(std::move(_keyRange)),
        objectStoreId_(std::move(_objectStoreId)),
        indexId_(std::move(_indexId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    int64_t&
    indexId()
    {
        return indexId_;
    }
    const int64_t&
    indexId() const
    {
        return indexId_;
    }

    SerializedKeyRange&
    keyRange()
    {
        return keyRange_;
    }
    const SerializedKeyRange&
    keyRange() const
    {
        return keyRange_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<SerializedKeyRange> keyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
    ::mozilla::ipc::IPDLStructMember<int64_t> indexId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexGetParams>
{
    typedef ::mozilla::dom::indexedDB::IndexGetParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexGetKeyParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexGetKeyParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexGetKeyParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexGetKeyParams(
            const int64_t& _objectStoreId,
            const int64_t& _indexId,
            const SerializedKeyRange& _keyRange) :
        keyRange_(_keyRange),
        objectStoreId_(_objectStoreId),
        indexId_(_indexId)
    {
    }

    MOZ_IMPLICIT IndexGetKeyParams(
            int64_t&& _objectStoreId,
            int64_t&& _indexId,
            SerializedKeyRange&& _keyRange) :
        keyRange_(std::move(_keyRange)),
        objectStoreId_(std::move(_objectStoreId)),
        indexId_(std::move(_indexId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    int64_t&
    indexId()
    {
        return indexId_;
    }
    const int64_t&
    indexId() const
    {
        return indexId_;
    }

    SerializedKeyRange&
    keyRange()
    {
        return keyRange_;
    }
    const SerializedKeyRange&
    keyRange() const
    {
        return keyRange_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<SerializedKeyRange> keyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
    ::mozilla::ipc::IPDLStructMember<int64_t> indexId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexGetKeyParams>
{
    typedef ::mozilla::dom::indexedDB::IndexGetKeyParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexGetAllParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexGetAllParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexGetAllParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexGetAllParams(
            const int64_t& _objectStoreId,
            const int64_t& _indexId,
            const mozilla::Maybe<SerializedKeyRange>& _optionalKeyRange,
            const uint32_t& _limit) :
        optionalKeyRange_(_optionalKeyRange),
        objectStoreId_(_objectStoreId),
        indexId_(_indexId),
        limit_(_limit)
    {
    }

    MOZ_IMPLICIT IndexGetAllParams(
            int64_t&& _objectStoreId,
            int64_t&& _indexId,
            mozilla::Maybe<SerializedKeyRange>&& _optionalKeyRange,
            uint32_t&& _limit) :
        optionalKeyRange_(std::move(_optionalKeyRange)),
        objectStoreId_(std::move(_objectStoreId)),
        indexId_(std::move(_indexId)),
        limit_(std::move(_limit))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    int64_t&
    indexId()
    {
        return indexId_;
    }
    const int64_t&
    indexId() const
    {
        return indexId_;
    }

    mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange()
    {
        return optionalKeyRange_;
    }
    const mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange() const
    {
        return optionalKeyRange_;
    }

    uint32_t&
    limit()
    {
        return limit_;
    }
    const uint32_t&
    limit() const
    {
        return limit_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<SerializedKeyRange>> optionalKeyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
    ::mozilla::ipc::IPDLStructMember<int64_t> indexId_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> limit_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexGetAllParams>
{
    typedef ::mozilla::dom::indexedDB::IndexGetAllParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexGetAllKeysParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexGetAllKeysParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexGetAllKeysParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexGetAllKeysParams(
            const int64_t& _objectStoreId,
            const int64_t& _indexId,
            const mozilla::Maybe<SerializedKeyRange>& _optionalKeyRange,
            const uint32_t& _limit) :
        optionalKeyRange_(_optionalKeyRange),
        objectStoreId_(_objectStoreId),
        indexId_(_indexId),
        limit_(_limit)
    {
    }

    MOZ_IMPLICIT IndexGetAllKeysParams(
            int64_t&& _objectStoreId,
            int64_t&& _indexId,
            mozilla::Maybe<SerializedKeyRange>&& _optionalKeyRange,
            uint32_t&& _limit) :
        optionalKeyRange_(std::move(_optionalKeyRange)),
        objectStoreId_(std::move(_objectStoreId)),
        indexId_(std::move(_indexId)),
        limit_(std::move(_limit))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    int64_t&
    indexId()
    {
        return indexId_;
    }
    const int64_t&
    indexId() const
    {
        return indexId_;
    }

    mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange()
    {
        return optionalKeyRange_;
    }
    const mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange() const
    {
        return optionalKeyRange_;
    }

    uint32_t&
    limit()
    {
        return limit_;
    }
    const uint32_t&
    limit() const
    {
        return limit_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<SerializedKeyRange>> optionalKeyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
    ::mozilla::ipc::IPDLStructMember<int64_t> indexId_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> limit_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexGetAllKeysParams>
{
    typedef ::mozilla::dom::indexedDB::IndexGetAllKeysParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IndexCountParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class IndexCountParams final
{
private:
    typedef ::int64_t int64_t;
    typedef ::mozilla::dom::indexedDB::SerializedKeyRange SerializedKeyRange;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IndexCountParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IndexCountParams(
            const int64_t& _objectStoreId,
            const int64_t& _indexId,
            const mozilla::Maybe<SerializedKeyRange>& _optionalKeyRange) :
        optionalKeyRange_(_optionalKeyRange),
        objectStoreId_(_objectStoreId),
        indexId_(_indexId)
    {
    }

    MOZ_IMPLICIT IndexCountParams(
            int64_t&& _objectStoreId,
            int64_t&& _indexId,
            mozilla::Maybe<SerializedKeyRange>&& _optionalKeyRange) :
        optionalKeyRange_(std::move(_optionalKeyRange)),
        objectStoreId_(std::move(_objectStoreId)),
        indexId_(std::move(_indexId))
    {
    }

    int64_t&
    objectStoreId()
    {
        return objectStoreId_;
    }
    const int64_t&
    objectStoreId() const
    {
        return objectStoreId_;
    }

    int64_t&
    indexId()
    {
        return indexId_;
    }
    const int64_t&
    indexId() const
    {
        return indexId_;
    }

    mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange()
    {
        return optionalKeyRange_;
    }
    const mozilla::Maybe<SerializedKeyRange>&
    optionalKeyRange() const
    {
        return optionalKeyRange_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<SerializedKeyRange>> optionalKeyRange_;
    ::mozilla::ipc::IPDLStructMember<int64_t> objectStoreId_;
    ::mozilla::ipc::IPDLStructMember<int64_t> indexId_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::IndexCountParams>
{
    typedef ::mozilla::dom::indexedDB::IndexCountParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union RequestParams|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class RequestParams final
{
public:
    enum Type {
        T__None,
        TObjectStoreAddParams = 1,
        TObjectStorePutParams,
        TObjectStoreGetParams,
        TObjectStoreGetKeyParams,
        TObjectStoreGetAllParams,
        TObjectStoreGetAllKeysParams,
        TObjectStoreDeleteParams,
        TObjectStoreClearParams,
        TObjectStoreCountParams,
        TIndexGetParams,
        TIndexGetKeyParams,
        TIndexGetAllParams,
        TIndexGetAllKeysParams,
        TIndexCountParams,
        T__Last = TIndexCountParams
    };

private:
    typedef ::mozilla::dom::indexedDB::ObjectStoreAddParams ObjectStoreAddParams;
    typedef ::mozilla::dom::indexedDB::ObjectStorePutParams ObjectStorePutParams;
    typedef ::mozilla::dom::indexedDB::ObjectStoreGetParams ObjectStoreGetParams;
    typedef ::mozilla::dom::indexedDB::ObjectStoreGetKeyParams ObjectStoreGetKeyParams;
    typedef ::mozilla::dom::indexedDB::ObjectStoreGetAllParams ObjectStoreGetAllParams;
    typedef ::mozilla::dom::indexedDB::ObjectStoreGetAllKeysParams ObjectStoreGetAllKeysParams;
    typedef ::mozilla::dom::indexedDB::ObjectStoreDeleteParams ObjectStoreDeleteParams;
    typedef ::mozilla::dom::indexedDB::ObjectStoreClearParams ObjectStoreClearParams;
    typedef ::mozilla::dom::indexedDB::ObjectStoreCountParams ObjectStoreCountParams;
    typedef ::mozilla::dom::indexedDB::IndexGetParams IndexGetParams;
    typedef ::mozilla::dom::indexedDB::IndexGetKeyParams IndexGetKeyParams;
    typedef ::mozilla::dom::indexedDB::IndexGetAllParams IndexGetAllParams;
    typedef ::mozilla::dom::indexedDB::IndexGetAllKeysParams IndexGetAllKeysParams;
    typedef ::mozilla::dom::indexedDB::IndexCountParams IndexCountParams;
    typedef ObjectStoreAddParams ObjectStoreAddParams__tdef;
    typedef ObjectStorePutParams ObjectStorePutParams__tdef;
    typedef ObjectStoreGetParams ObjectStoreGetParams__tdef;
    typedef ObjectStoreGetKeyParams ObjectStoreGetKeyParams__tdef;
    typedef ObjectStoreGetAllParams ObjectStoreGetAllParams__tdef;
    typedef ObjectStoreGetAllKeysParams ObjectStoreGetAllKeysParams__tdef;
    typedef ObjectStoreDeleteParams ObjectStoreDeleteParams__tdef;
    typedef ObjectStoreClearParams ObjectStoreClearParams__tdef;
    typedef ObjectStoreCountParams ObjectStoreCountParams__tdef;
    typedef IndexGetParams IndexGetParams__tdef;
    typedef IndexGetKeyParams IndexGetKeyParams__tdef;
    typedef IndexGetAllParams IndexGetAllParams__tdef;
    typedef IndexGetAllKeysParams IndexGetAllKeysParams__tdef;
    typedef IndexCountParams IndexCountParams__tdef;

    ObjectStoreAddParams*
    ptr_ObjectStoreAddParams()
    {
        return (&(mVObjectStoreAddParams));
    }
    const ObjectStoreAddParams*
    constptr_ObjectStoreAddParams() const
    {
        return (&(mVObjectStoreAddParams));
    }
    ObjectStorePutParams*
    ptr_ObjectStorePutParams()
    {
        return (&(mVObjectStorePutParams));
    }
    const ObjectStorePutParams*
    constptr_ObjectStorePutParams() const
    {
        return (&(mVObjectStorePutParams));
    }
    ObjectStoreGetParams*
    ptr_ObjectStoreGetParams()
    {
        return (&(mVObjectStoreGetParams));
    }
    const ObjectStoreGetParams*
    constptr_ObjectStoreGetParams() const
    {
        return (&(mVObjectStoreGetParams));
    }
    ObjectStoreGetKeyParams*
    ptr_ObjectStoreGetKeyParams()
    {
        return (&(mVObjectStoreGetKeyParams));
    }
    const ObjectStoreGetKeyParams*
    constptr_ObjectStoreGetKeyParams() const
    {
        return (&(mVObjectStoreGetKeyParams));
    }
    ObjectStoreGetAllParams*
    ptr_ObjectStoreGetAllParams()
    {
        return (&(mVObjectStoreGetAllParams));
    }
    const ObjectStoreGetAllParams*
    constptr_ObjectStoreGetAllParams() const
    {
        return (&(mVObjectStoreGetAllParams));
    }
    ObjectStoreGetAllKeysParams*
    ptr_ObjectStoreGetAllKeysParams()
    {
        return (&(mVObjectStoreGetAllKeysParams));
    }
    const ObjectStoreGetAllKeysParams*
    constptr_ObjectStoreGetAllKeysParams() const
    {
        return (&(mVObjectStoreGetAllKeysParams));
    }
    ObjectStoreDeleteParams*
    ptr_ObjectStoreDeleteParams()
    {
        return (&(mVObjectStoreDeleteParams));
    }
    const ObjectStoreDeleteParams*
    constptr_ObjectStoreDeleteParams() const
    {
        return (&(mVObjectStoreDeleteParams));
    }
    ObjectStoreClearParams*
    ptr_ObjectStoreClearParams()
    {
        return (&(mVObjectStoreClearParams));
    }
    const ObjectStoreClearParams*
    constptr_ObjectStoreClearParams() const
    {
        return (&(mVObjectStoreClearParams));
    }
    ObjectStoreCountParams*
    ptr_ObjectStoreCountParams()
    {
        return (&(mVObjectStoreCountParams));
    }
    const ObjectStoreCountParams*
    constptr_ObjectStoreCountParams() const
    {
        return (&(mVObjectStoreCountParams));
    }
    IndexGetParams*
    ptr_IndexGetParams()
    {
        return (&(mVIndexGetParams));
    }
    const IndexGetParams*
    constptr_IndexGetParams() const
    {
        return (&(mVIndexGetParams));
    }
    IndexGetKeyParams*
    ptr_IndexGetKeyParams()
    {
        return (&(mVIndexGetKeyParams));
    }
    const IndexGetKeyParams*
    constptr_IndexGetKeyParams() const
    {
        return (&(mVIndexGetKeyParams));
    }
    IndexGetAllParams*
    ptr_IndexGetAllParams()
    {
        return (&(mVIndexGetAllParams));
    }
    const IndexGetAllParams*
    constptr_IndexGetAllParams() const
    {
        return (&(mVIndexGetAllParams));
    }
    IndexGetAllKeysParams*
    ptr_IndexGetAllKeysParams()
    {
        return (&(mVIndexGetAllKeysParams));
    }
    const IndexGetAllKeysParams*
    constptr_IndexGetAllKeysParams() const
    {
        return (&(mVIndexGetAllKeysParams));
    }
    IndexCountParams*
    ptr_IndexCountParams()
    {
        return (&(mVIndexCountParams));
    }
    const IndexCountParams*
    constptr_IndexCountParams() const
    {
        return (&(mVIndexCountParams));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT RequestParams() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT RequestParams(ObjectStoreAddParams&& aOther);

    MOZ_IMPLICIT RequestParams(ObjectStorePutParams&& aOther);

    MOZ_IMPLICIT RequestParams(const ObjectStoreGetParams& aOther);

    MOZ_IMPLICIT RequestParams(ObjectStoreGetParams&& aOther);

    MOZ_IMPLICIT RequestParams(const ObjectStoreGetKeyParams& aOther);

    MOZ_IMPLICIT RequestParams(ObjectStoreGetKeyParams&& aOther);

    MOZ_IMPLICIT RequestParams(const ObjectStoreGetAllParams& aOther);

    MOZ_IMPLICIT RequestParams(ObjectStoreGetAllParams&& aOther);

    MOZ_IMPLICIT RequestParams(const ObjectStoreGetAllKeysParams& aOther);

    MOZ_IMPLICIT RequestParams(ObjectStoreGetAllKeysParams&& aOther);

    MOZ_IMPLICIT RequestParams(const ObjectStoreDeleteParams& aOther);

    MOZ_IMPLICIT RequestParams(ObjectStoreDeleteParams&& aOther);

    MOZ_IMPLICIT RequestParams(const ObjectStoreClearParams& aOther);

    MOZ_IMPLICIT RequestParams(ObjectStoreClearParams&& aOther);

    MOZ_IMPLICIT RequestParams(const ObjectStoreCountParams& aOther);

    MOZ_IMPLICIT RequestParams(ObjectStoreCountParams&& aOther);

    MOZ_IMPLICIT RequestParams(const IndexGetParams& aOther);

    MOZ_IMPLICIT RequestParams(IndexGetParams&& aOther);

    MOZ_IMPLICIT RequestParams(const IndexGetKeyParams& aOther);

    MOZ_IMPLICIT RequestParams(IndexGetKeyParams&& aOther);

    MOZ_IMPLICIT RequestParams(const IndexGetAllParams& aOther);

    MOZ_IMPLICIT RequestParams(IndexGetAllParams&& aOther);

    MOZ_IMPLICIT RequestParams(const IndexGetAllKeysParams& aOther);

    MOZ_IMPLICIT RequestParams(IndexGetAllKeysParams&& aOther);

    MOZ_IMPLICIT RequestParams(const IndexCountParams& aOther);

    MOZ_IMPLICIT RequestParams(IndexCountParams&& aOther);

    MOZ_IMPLICIT RequestParams(RequestParams&& aOther);

    ~RequestParams();

    Type
    type() const
    {
        return mType;
    }

    RequestParams&
    operator=(ObjectStoreAddParams&& aRhs);

    RequestParams&
    operator=(ObjectStorePutParams&& aRhs);

    RequestParams&
    operator=(const ObjectStoreGetParams& aRhs);

    RequestParams&
    operator=(ObjectStoreGetParams&& aRhs);

    RequestParams&
    operator=(const ObjectStoreGetKeyParams& aRhs);

    RequestParams&
    operator=(ObjectStoreGetKeyParams&& aRhs);

    RequestParams&
    operator=(const ObjectStoreGetAllParams& aRhs);

    RequestParams&
    operator=(ObjectStoreGetAllParams&& aRhs);

    RequestParams&
    operator=(const ObjectStoreGetAllKeysParams& aRhs);

    RequestParams&
    operator=(ObjectStoreGetAllKeysParams&& aRhs);

    RequestParams&
    operator=(const ObjectStoreDeleteParams& aRhs);

    RequestParams&
    operator=(ObjectStoreDeleteParams&& aRhs);

    RequestParams&
    operator=(const ObjectStoreClearParams& aRhs);

    RequestParams&
    operator=(ObjectStoreClearParams&& aRhs);

    RequestParams&
    operator=(const ObjectStoreCountParams& aRhs);

    RequestParams&
    operator=(ObjectStoreCountParams&& aRhs);

    RequestParams&
    operator=(const IndexGetParams& aRhs);

    RequestParams&
    operator=(IndexGetParams&& aRhs);

    RequestParams&
    operator=(const IndexGetKeyParams& aRhs);

    RequestParams&
    operator=(IndexGetKeyParams&& aRhs);

    RequestParams&
    operator=(const IndexGetAllParams& aRhs);

    RequestParams&
    operator=(IndexGetAllParams&& aRhs);

    RequestParams&
    operator=(const IndexGetAllKeysParams& aRhs);

    RequestParams&
    operator=(IndexGetAllKeysParams&& aRhs);

    RequestParams&
    operator=(const IndexCountParams& aRhs);

    RequestParams&
    operator=(IndexCountParams&& aRhs);

    RequestParams&
    operator=(RequestParams&& aRhs);

    ObjectStoreAddParams&
    get_ObjectStoreAddParams()
    {
        AssertSanity(TObjectStoreAddParams);
        return (*(ptr_ObjectStoreAddParams()));
    }
    const ObjectStoreAddParams&
    get_ObjectStoreAddParams() const
    {
        AssertSanity(TObjectStoreAddParams);
        return (*(constptr_ObjectStoreAddParams()));
    }
    operator ObjectStoreAddParams&()
    {
        return get_ObjectStoreAddParams();
    }
    operator const ObjectStoreAddParams&() const
    {
        return get_ObjectStoreAddParams();
    }

    ObjectStorePutParams&
    get_ObjectStorePutParams()
    {
        AssertSanity(TObjectStorePutParams);
        return (*(ptr_ObjectStorePutParams()));
    }
    const ObjectStorePutParams&
    get_ObjectStorePutParams() const
    {
        AssertSanity(TObjectStorePutParams);
        return (*(constptr_ObjectStorePutParams()));
    }
    operator ObjectStorePutParams&()
    {
        return get_ObjectStorePutParams();
    }
    operator const ObjectStorePutParams&() const
    {
        return get_ObjectStorePutParams();
    }

    ObjectStoreGetParams&
    get_ObjectStoreGetParams()
    {
        AssertSanity(TObjectStoreGetParams);
        return (*(ptr_ObjectStoreGetParams()));
    }
    const ObjectStoreGetParams&
    get_ObjectStoreGetParams() const
    {
        AssertSanity(TObjectStoreGetParams);
        return (*(constptr_ObjectStoreGetParams()));
    }
    operator ObjectStoreGetParams&()
    {
        return get_ObjectStoreGetParams();
    }
    operator const ObjectStoreGetParams&() const
    {
        return get_ObjectStoreGetParams();
    }

    ObjectStoreGetKeyParams&
    get_ObjectStoreGetKeyParams()
    {
        AssertSanity(TObjectStoreGetKeyParams);
        return (*(ptr_ObjectStoreGetKeyParams()));
    }
    const ObjectStoreGetKeyParams&
    get_ObjectStoreGetKeyParams() const
    {
        AssertSanity(TObjectStoreGetKeyParams);
        return (*(constptr_ObjectStoreGetKeyParams()));
    }
    operator ObjectStoreGetKeyParams&()
    {
        return get_ObjectStoreGetKeyParams();
    }
    operator const ObjectStoreGetKeyParams&() const
    {
        return get_ObjectStoreGetKeyParams();
    }

    ObjectStoreGetAllParams&
    get_ObjectStoreGetAllParams()
    {
        AssertSanity(TObjectStoreGetAllParams);
        return (*(ptr_ObjectStoreGetAllParams()));
    }
    const ObjectStoreGetAllParams&
    get_ObjectStoreGetAllParams() const
    {
        AssertSanity(TObjectStoreGetAllParams);
        return (*(constptr_ObjectStoreGetAllParams()));
    }
    operator ObjectStoreGetAllParams&()
    {
        return get_ObjectStoreGetAllParams();
    }
    operator const ObjectStoreGetAllParams&() const
    {
        return get_ObjectStoreGetAllParams();
    }

    ObjectStoreGetAllKeysParams&
    get_ObjectStoreGetAllKeysParams()
    {
        AssertSanity(TObjectStoreGetAllKeysParams);
        return (*(ptr_ObjectStoreGetAllKeysParams()));
    }
    const ObjectStoreGetAllKeysParams&
    get_ObjectStoreGetAllKeysParams() const
    {
        AssertSanity(TObjectStoreGetAllKeysParams);
        return (*(constptr_ObjectStoreGetAllKeysParams()));
    }
    operator ObjectStoreGetAllKeysParams&()
    {
        return get_ObjectStoreGetAllKeysParams();
    }
    operator const ObjectStoreGetAllKeysParams&() const
    {
        return get_ObjectStoreGetAllKeysParams();
    }

    ObjectStoreDeleteParams&
    get_ObjectStoreDeleteParams()
    {
        AssertSanity(TObjectStoreDeleteParams);
        return (*(ptr_ObjectStoreDeleteParams()));
    }
    const ObjectStoreDeleteParams&
    get_ObjectStoreDeleteParams() const
    {
        AssertSanity(TObjectStoreDeleteParams);
        return (*(constptr_ObjectStoreDeleteParams()));
    }
    operator ObjectStoreDeleteParams&()
    {
        return get_ObjectStoreDeleteParams();
    }
    operator const ObjectStoreDeleteParams&() const
    {
        return get_ObjectStoreDeleteParams();
    }

    ObjectStoreClearParams&
    get_ObjectStoreClearParams()
    {
        AssertSanity(TObjectStoreClearParams);
        return (*(ptr_ObjectStoreClearParams()));
    }
    const ObjectStoreClearParams&
    get_ObjectStoreClearParams() const
    {
        AssertSanity(TObjectStoreClearParams);
        return (*(constptr_ObjectStoreClearParams()));
    }
    operator ObjectStoreClearParams&()
    {
        return get_ObjectStoreClearParams();
    }
    operator const ObjectStoreClearParams&() const
    {
        return get_ObjectStoreClearParams();
    }

    ObjectStoreCountParams&
    get_ObjectStoreCountParams()
    {
        AssertSanity(TObjectStoreCountParams);
        return (*(ptr_ObjectStoreCountParams()));
    }
    const ObjectStoreCountParams&
    get_ObjectStoreCountParams() const
    {
        AssertSanity(TObjectStoreCountParams);
        return (*(constptr_ObjectStoreCountParams()));
    }
    operator ObjectStoreCountParams&()
    {
        return get_ObjectStoreCountParams();
    }
    operator const ObjectStoreCountParams&() const
    {
        return get_ObjectStoreCountParams();
    }

    IndexGetParams&
    get_IndexGetParams()
    {
        AssertSanity(TIndexGetParams);
        return (*(ptr_IndexGetParams()));
    }
    const IndexGetParams&
    get_IndexGetParams() const
    {
        AssertSanity(TIndexGetParams);
        return (*(constptr_IndexGetParams()));
    }
    operator IndexGetParams&()
    {
        return get_IndexGetParams();
    }
    operator const IndexGetParams&() const
    {
        return get_IndexGetParams();
    }

    IndexGetKeyParams&
    get_IndexGetKeyParams()
    {
        AssertSanity(TIndexGetKeyParams);
        return (*(ptr_IndexGetKeyParams()));
    }
    const IndexGetKeyParams&
    get_IndexGetKeyParams() const
    {
        AssertSanity(TIndexGetKeyParams);
        return (*(constptr_IndexGetKeyParams()));
    }
    operator IndexGetKeyParams&()
    {
        return get_IndexGetKeyParams();
    }
    operator const IndexGetKeyParams&() const
    {
        return get_IndexGetKeyParams();
    }

    IndexGetAllParams&
    get_IndexGetAllParams()
    {
        AssertSanity(TIndexGetAllParams);
        return (*(ptr_IndexGetAllParams()));
    }
    const IndexGetAllParams&
    get_IndexGetAllParams() const
    {
        AssertSanity(TIndexGetAllParams);
        return (*(constptr_IndexGetAllParams()));
    }
    operator IndexGetAllParams&()
    {
        return get_IndexGetAllParams();
    }
    operator const IndexGetAllParams&() const
    {
        return get_IndexGetAllParams();
    }

    IndexGetAllKeysParams&
    get_IndexGetAllKeysParams()
    {
        AssertSanity(TIndexGetAllKeysParams);
        return (*(ptr_IndexGetAllKeysParams()));
    }
    const IndexGetAllKeysParams&
    get_IndexGetAllKeysParams() const
    {
        AssertSanity(TIndexGetAllKeysParams);
        return (*(constptr_IndexGetAllKeysParams()));
    }
    operator IndexGetAllKeysParams&()
    {
        return get_IndexGetAllKeysParams();
    }
    operator const IndexGetAllKeysParams&() const
    {
        return get_IndexGetAllKeysParams();
    }

    IndexCountParams&
    get_IndexCountParams()
    {
        AssertSanity(TIndexCountParams);
        return (*(ptr_IndexCountParams()));
    }
    const IndexCountParams&
    get_IndexCountParams() const
    {
        AssertSanity(TIndexCountParams);
        return (*(constptr_IndexCountParams()));
    }
    operator IndexCountParams&()
    {
        return get_IndexCountParams();
    }
    operator const IndexCountParams&() const
    {
        return get_IndexCountParams();
    }

private:
    union {
        ObjectStoreAddParams mVObjectStoreAddParams;
        ObjectStorePutParams mVObjectStorePutParams;
        ObjectStoreGetParams mVObjectStoreGetParams;
        ObjectStoreGetKeyParams mVObjectStoreGetKeyParams;
        ObjectStoreGetAllParams mVObjectStoreGetAllParams;
        ObjectStoreGetAllKeysParams mVObjectStoreGetAllKeysParams;
        ObjectStoreDeleteParams mVObjectStoreDeleteParams;
        ObjectStoreClearParams mVObjectStoreClearParams;
        ObjectStoreCountParams mVObjectStoreCountParams;
        IndexGetParams mVIndexGetParams;
        IndexGetKeyParams mVIndexGetKeyParams;
        IndexGetAllParams mVIndexGetAllParams;
        IndexGetAllKeysParams mVIndexGetAllKeysParams;
        IndexCountParams mVIndexCountParams;
    };
    Type mType;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::RequestParams>
{
    typedef ::mozilla::dom::indexedDB::RequestParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct LoggingInfo|
//
namespace mozilla {
namespace dom {
namespace indexedDB {
class LoggingInfo final
{
private:
    typedef ::nsID nsID;
    typedef ::int64_t int64_t;
    typedef ::uint64_t uint64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    LoggingInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT LoggingInfo(
            const nsID& _backgroundChildLoggingId,
            const int64_t& _nextTransactionSerialNumber,
            const int64_t& _nextVersionChangeTransactionSerialNumber,
            const uint64_t& _nextRequestSerialNumber) :
        backgroundChildLoggingId_(_backgroundChildLoggingId),
        nextTransactionSerialNumber_(_nextTransactionSerialNumber),
        nextVersionChangeTransactionSerialNumber_(_nextVersionChangeTransactionSerialNumber),
        nextRequestSerialNumber_(_nextRequestSerialNumber)
    {
    }

    MOZ_IMPLICIT LoggingInfo(
            nsID&& _backgroundChildLoggingId,
            int64_t&& _nextTransactionSerialNumber,
            int64_t&& _nextVersionChangeTransactionSerialNumber,
            uint64_t&& _nextRequestSerialNumber) :
        backgroundChildLoggingId_(std::move(_backgroundChildLoggingId)),
        nextTransactionSerialNumber_(std::move(_nextTransactionSerialNumber)),
        nextVersionChangeTransactionSerialNumber_(std::move(_nextVersionChangeTransactionSerialNumber)),
        nextRequestSerialNumber_(std::move(_nextRequestSerialNumber))
    {
    }

    nsID&
    backgroundChildLoggingId()
    {
        return backgroundChildLoggingId_;
    }
    const nsID&
    backgroundChildLoggingId() const
    {
        return backgroundChildLoggingId_;
    }

    int64_t&
    nextTransactionSerialNumber()
    {
        return nextTransactionSerialNumber_;
    }
    const int64_t&
    nextTransactionSerialNumber() const
    {
        return nextTransactionSerialNumber_;
    }

    int64_t&
    nextVersionChangeTransactionSerialNumber()
    {
        return nextVersionChangeTransactionSerialNumber_;
    }
    const int64_t&
    nextVersionChangeTransactionSerialNumber() const
    {
        return nextVersionChangeTransactionSerialNumber_;
    }

    uint64_t&
    nextRequestSerialNumber()
    {
        return nextRequestSerialNumber_;
    }
    const uint64_t&
    nextRequestSerialNumber() const
    {
        return nextRequestSerialNumber_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<nsID> backgroundChildLoggingId_;
    ::mozilla::ipc::IPDLStructMember<int64_t> nextTransactionSerialNumber_;
    ::mozilla::ipc::IPDLStructMember<int64_t> nextVersionChangeTransactionSerialNumber_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> nextRequestSerialNumber_;
};
} // namespace indexedDB
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::indexedDB::LoggingInfo>
{
    typedef ::mozilla::dom::indexedDB::LoggingInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef PBackgroundIDBSharedTypes_h
