/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file was automatically generated by getCTKnownLogs.py. */

#ifndef CTKnownLogs_h
#define CTKnownLogs_h

#include "CTLog.h"
#include "prtime.h"

#include <stddef.h>

static const PRTime kCTExpirationTime = INT64_C(1772103418000000);

namespace mozilla::ct {

enum class CTLogState {
  Admissible,  // Qualified, Usable, or ReadOnly
  Retired,
};

enum class CTLogFormat {
  RFC6962,
  Tiled,
};

struct CTLogInfo {
  // See bug 1338873 about making these fields const.
  const char* name;
  CTLogState state;
  CTLogFormat format;
  uint64_t timestamp;
  // Index within kCTLogOperatorList.
  size_t operatorIndex;
  const char* key;
  size_t keyLength;
};

struct CTLogOperatorInfo {
  // See bug 1338873 about making these fields const.
  const char* name;
  mozilla::ct::CTLogOperatorId id;
};

const CTLogInfo kCTLogList[] = {
    {"Google 'Argon2025h2' log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1701000000000,  // 2023-11-26T12:00:00Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xaf\xe4\xf3\x94\x2c\xdf\xa6\x27\xb5"
     "\xfe\xb2\x61\x83\x19\xc8\x21\x3a\x23\xa8\xa9\x3d\x54\xaf\xbc\x31\x9a\x1c"
     "\xd3\xc1\xe3\xb6\xc2\xf3\x0f\xc7\xb9\xca\x3b\x1d\x79\x65\x61\x22\x25\x82"
     "\x56\x4e\x98\xe8\xaa\x26\x29\x36\x1e\x28\x60\x6f\xeb\x15\x6e\xf7\x7c\xd0"
     "\xba",
     91},
    {"Google 'Argon2026h1' log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1727734767000,  // 2024-09-30T22:19:27Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x07\xfc\x1e\xe8\x63\x8e\xff\x1c\x31"
     "\x8a\xfc\xb8\x1e\x19\x2b\x60\x50\x00\x3e\x8e\x9e\xda\x77\x37\xe3\xa5\xa8"
     "\xda\x8d\x94\xf8\x6b\xe8\x3d\x64\x8f\x27\x3f\x75\xb3\xfc\x6b\x12\xf0\x37"
     "\x06\x4f\x64\x58\x75\x14\x5d\x56\x52\xe6\x6a\x2b\x14\x4c\xec\x81\xd1\xea"
     "\x3e",
     91},
    {"Google 'Argon2026h2' log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1727734767000,  // 2024-09-30T22:19:27Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x2a\x3a\x67\x8b\xfe\xba\x0c\x86\x2b"
     "\x4a\x51\x8a\xe9\x17\xfe\x7b\xa1\x76\x73\xfd\xbc\x65\x4b\xc3\x27\xbf\x4d"
     "\xf3\x5f\xa0\xca\x29\x80\x11\x20\x32\x78\xd6\x7e\xf9\x34\x60\x8c\x75\xa0"
     "\xf5\x35\x50\x9c\xa1\xd3\x49\x4d\x13\xd5\x3b\x6a\x0e\xea\x45\x9d\x24\x13"
     "\x22",
     91},
    {"Google 'Argon2027h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1760747400000,  // 2025-10-18T00:30:00Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x28\x74\x66\xd0\x7f\xf3\x51\xa1\x40"
     "\xe8\x87\x73\xe5\xc1\xaf\x18\xed\xed\x08\xf4\x32\x7c\x63\x20\x26\x65\x41"
     "\x38\xfc\x8a\x00\xfe\xa6\x18\xcd\x48\x88\xd5\xe2\xe0\x22\xe8\x98\xe5\x32"
     "\x62\x3d\x18\x37\xbe\x29\xf9\xe1\x95\x02\x91\x4c\xb0\xce\x21\xfe\x3c\xc2"
     "\xb0",
     91},
    {"Google 'Xenon2025h2' log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1701000000000,  // 2023-11-26T12:00:00Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x6b\xe0\xaf\xed\x06\x7c\x3d\xef\xd9"
     "\x0e\xe4\x58\x4b\x04\xd8\x2a\x47\x99\x90\x89\x7a\xb9\x36\xa5\x75\xc8\x04"
     "\xb8\xcb\xe2\xaa\x2b\xb5\x68\x9d\x88\x29\xa2\xa5\xcf\xce\x2b\x9a\x15\x9b"
     "\xa0\x3e\x9d\x94\x1c\xb2\xb7\x4a\xf2\x51\xec\x40\xed\x62\x47\xa4\x03\x49"
     "\x86",
     91},
    {"Google 'Xenon2026h1' log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1727734767000,  // 2024-09-30T22:19:27Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x3a\x1f\xc8\xbb\xce\xd5\x90\x47\x34"
     "\xca\xca\x01\x04\x27\x21\x1c\xe2\x29\x3d\x92\xbb\x91\x45\xc7\x5a\x3e\xa5"
     "\xd4\xf2\x12\xe6\xe8\xe6\x43\xba\xf3\x7b\xc2\x38\xaf\xfc\x23\x8a\x05\x56"
     "\xeb\x03\x0a\x30\xcc\x63\x6c\xd9\x3c\xbe\xf5\x7b\x94\xba\x94\xd3\xbf\x88"
     "\x4c",
     91},
    {"Google 'Xenon2026h2' log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1727734767000,  // 2024-09-30T22:19:27Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xe5\x77\x78\x95\x71\x28\xb3\x95\xc9"
     "\xa5\xcc\x7a\x4c\xe8\x32\x03\x96\x7b\xfc\x2e\x1d\xb9\xa4\xdb\x43\xa0\xbd"
     "\x69\x72\xf9\x45\xba\x9a\xc3\xe9\x96\xd5\x70\xe7\x0d\x7e\xc9\x95\x15\x27"
     "\x8a\x72\x30\x65\x86\x43\x53\xdc\x11\x44\x18\x49\x98\x25\x68\xa7\x3c\x05"
     "\xbf",
     91},
    {"Google 'Xenon2027h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1760747400000,  // 2025-10-18T00:30:00Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xff\xa5\x9c\x03\x85\x51\x4a\x58\xc8"
     "\x7d\x37\x58\xe3\xcf\xa9\x15\x12\xcb\xb4\xba\xe6\x4d\xbf\x3c\x70\x60\xdd"
     "\x97\xc1\xaf\xdc\x4d\x8b\x76\xe1\xb8\x8e\x02\x77\x00\xae\x62\x34\xc1\x46"
     "\x86\x96\xd1\x44\xb8\xb9\x07\x7a\xcf\x94\x16\x97\x57\x2c\x2e\x47\x92\x05"
     "\x0e",
     91},
    {"Cloudflare 'Nimbus2025'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1702969200000,  // 2023-12-19T07:00:00Z
     1,              // operated by Cloudflare
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x1a\x80\x1a\x15\x19\x19\x23\x79\xb4"
     "\xfa\xa0\x79\x8e\x8d\xd5\xc1\xdc\xc2\xb5\x96\x92\x7e\x94\xe0\xc3\x7e\x14"
     "\x7c\x0a\x0d\x2d\x46\xa8\x9d\x1b\xb1\x41\x65\x0c\x5f\x98\xc4\x5a\x17\x79"
     "\x81\x5b\x4a\x14\x41\xec\xaf\xa9\x5d\x0e\xab\x12\x19\x71\xcd\x43\xef\xbb"
     "\x97",
     91},
    {"Cloudflare 'Nimbus2026'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1731088800000,  // 2024-11-08T18:00:00Z
     1,              // operated by Cloudflare
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xd8\x5c\x61\x4f\xac\x6a\xd2\x20\x80"
     "\x4e\x8a\x42\xf6\x04\xad\x4b\xd4\xb1\x1c\x79\x8e\x29\x32\xde\x69\x53\x59"
     "\xeb\xad\x78\xf3\xc0\x2a\xf2\xd0\x11\x5d\x05\x7e\xeb\xe8\xc1\xd3\xdf\x37"
     "\xbf\x91\x64\x46\x6e\x0e\x27\x13\xea\xbb\x6f\x46\x27\x58\x86\xef\x40\x21"
     "\xa3",
     91},
    {"Cloudflare 'Nimbus2027'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1763164800000,  // 2025-11-15T00:00:00Z
     1,              // operated by Cloudflare
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x62\x37\x7f\x8c\x4d\x04\xa0\x08\x4d"
     "\x05\xb7\xdc\x36\x1a\xd3\x6f\xb1\x74\xc7\x5d\x0a\x64\xaf\x2b\xd9\x20\xe3"
     "\xc7\x51\x9d\x8c\x9e\xf9\x84\x9a\xc7\xc7\x63\x82\x43\xe0\x57\x46\x35\xe2"
     "\xf9\xcc\xe8\x44\x43\x75\xbb\x48\xfd\x71\x69\x7c\x77\xa3\xa8\x3c\xc3\xe8"
     "\x81",
     91},
    {"DigiCert Yeti2025 Log", CTLogState::Retired, CTLogFormat::RFC6962,
     1753315200000,  // 2025-07-24T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xdf\x95\x00\x5e\x10\xc1\x01\xf7\x37"
     "\xe3\x10\x74\xd1\xff\xb2\xca\x90\xed\x32\x99\x5f\x0c\x39\xfe\xa1\xd1\x13"
     "\x11\xac\xd1\xb3\x73\x93\x20\xc2\x13\x3c\x4c\xb5\x7a\x52\x86\x86\x3d\xe3"
     "\x95\x24\x7c\xd8\x91\x98\x48\x3b\xf0\xf0\xdf\x21\xf1\xb0\x81\x5a\x59\x25"
     "\x43",
     91},
    {"DigiCert Nessie2025 Log", CTLogState::Retired, CTLogFormat::RFC6962,
     1744758000000,  // 2025-04-15T23:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xf2\xf0\xf0\xa7\x8b\x81\x2e\x09\x39"
     "\x3b\x9f\x42\xda\x38\x44\x5f\xb4\xcc\xed\x36\xbb\xd8\x43\x7f\x16\x49\x57"
     "\x87\x04\x7f\xa5\x01\x34\xf7\xe8\x68\x3f\xb7\x78\x1f\x60\x66\x2d\x67\x9a"
     "\x75\x80\xb7\x53\xa7\x85\xd5\xbc\xab\x47\x06\x55\xdb\xb5\xdf\x88\xa1\x6f"
     "\x38",
     91},
    {"DigiCert 'Wyvern2025h2' Log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1724900983000,  // 2024-08-29T03:09:43Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xe0\xdb\x41\xef\xe4\x04\xbd\xcb\x6b"
     "\x2e\x4c\xcc\xf1\x6c\xde\x41\x58\x7f\xfe\x94\xf6\x7a\xf6\x60\xed\x8b\x76"
     "\x72\xa3\xa2\x1c\x31\x13\x32\x35\xa1\xf2\x08\xd2\x68\xc5\x34\xa7\x56\x08"
     "\x1c\x63\xde\x95\xe2\x81\x69\x97\x8d\x1e\xa8\xb7\x66\x51\x25\x75\x4d\x78"
     "\x2e",
     91},
    {"DigiCert 'Wyvern2026h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1731024000000,  // 2024-11-08T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xec\xbc\x34\x39\xe2\x9a\x8d\xb7\x99"
     "\x7a\x91\xf1\x05\x72\x52\xda\x93\x89\x5d\x3a\x07\x8b\x99\xed\x80\xa5\x16"
     "\xda\x73\x21\x20\xeb\x86\x96\x87\xc5\xc6\xd9\x17\xba\x6e\xb9\x4c\x13\x58"
     "\xd5\xd1\x83\xf8\x7a\xdf\x1e\x07\xbc\x15\xcd\xc0\x4a\xcd\x2a\x31\x71\x07"
     "\x55",
     91},
    {"DigiCert 'Wyvern2026h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1731024000000,  // 2024-11-08T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7a\x73\xdb\x4a\xf2\xde\x4f\xec\xe1"
     "\x14\x1b\xbe\xa6\xa9\x3c\x21\xb8\x45\x12\xcd\x7a\x88\x26\x91\x20\x56\xf5"
     "\x49\x32\xc3\x75\x6c\xcb\xe9\x7c\x13\x75\x35\x9c\x6c\xec\xf1\x31\x3c\xc1"
     "\xde\x9b\x8c\x13\x92\xb7\xad\x3d\x0f\xa1\x9c\x8f\x48\xce\x74\x27\x18\x23"
     "\x99",
     91},
    {"DigiCert 'Wyvern2027h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1760119200000,  // 2025-10-10T18:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x6a\xcb\x71\x62\x3d\x66\x9e\xd1\xae"
     "\xca\xfe\xf8\x93\x87\xfe\xc9\xa2\x31\xf9\x91\x33\x95\x22\x7e\x89\x54\xd8"
     "\x5a\x5c\x3c\x4a\x94\x8a\x27\x84\xdf\xc5\x85\xae\x06\x19\xc4\x4e\x58\x69"
     "\xc8\x6f\xf9\xb1\xe2\x67\xd2\x63\x92\x9d\x58\x17\xb1\x9d\x49\x45\xf9\x48"
     "\xee",
     91},
    {"DigiCert 'Wyvern2027h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1760119200000,  // 2025-10-10T18:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xb8\xe8\x3c\x85\xc8\x1a\x61\x3f\xcc"
     "\x4a\x1c\x69\x6a\x0d\x87\x8a\x07\xb4\xce\xc2\xf3\xcf\xcb\xce\x2d\x95\xe9"
     "\xe9\xf6\x82\x77\x33\x3e\x32\x7f\xe7\x8f\x25\x3d\x44\xe0\x2e\xc0\x3c\x6e"
     "\xbb\xcf\x3f\x1a\xbc\x67\xe3\xa9\x26\x7a\x17\x4e\x29\x50\xc5\x7b\x16\xdd"
     "\x4a",
     91},
    {"DigiCert 'Sphinx2025h2' Log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1724900983000,  // 2024-08-29T03:09:43Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x41\x8c\x50\x13\x54\xb1\x19\x05\xb7"
     "\x7f\x4a\x20\x6e\xa3\x75\x63\xca\x34\xf4\xcc\x74\xea\x32\x3b\xb6\x8b\x03"
     "\x14\xa8\x52\x7f\x32\x87\x5e\x59\x9e\x0f\xab\x18\x9e\x29\x6c\xb5\x72\x77"
     "\x1a\x27\x54\x85\x5d\xc1\x7b\x24\xa8\x34\xe3\xcd\x88\xce\xd4\x50\x1b\xbe"
     "\x69",
     91},
    {"DigiCert 'Sphinx2026h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1731024000000,  // 2024-11-08T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xab\x84\xbe\xf8\x3c\x87\xa2\x42\x25"
     "\x9a\x66\x9c\xae\x2b\x52\xe7\x5a\xf9\x21\x1b\x19\x03\xa5\x07\xe2\x46\x0b"
     "\x1f\x8a\x5e\x7c\x6c\xae\xff\x19\x77\x86\xe8\x7b\xfc\xee\x6b\x36\x4f\xf2"
     "\xbc\xc3\x9e\x05\x02\x9a\x08\x01\xb5\x49\x23\x35\xc4\xd3\x50\x2b\x51\xe9"
     "\xf4",
     91},
    {"DigiCert 'Sphinx2026h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1731024000000,  // 2024-11-08T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xaa\xe0\xf4\x26\x44\x50\x4f\xfd\xa2"
     "\x9e\xe6\x80\xe0\x70\xb5\xb1\xce\x94\xa5\xf8\x97\x81\x44\x55\x42\x64\x1c"
     "\x22\x79\xa7\x64\x59\xd3\x89\x93\x21\x66\xfb\x09\x81\x60\x1f\x62\x55\x34"
     "\x38\x8c\xa4\x38\x2e\xac\x95\x0c\xeb\xed\x4f\x64\xbc\x45\x42\xf7\x06\x7a"
     "\xcd",
     91},
    {"DigiCert 'sphinx2027h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1760119200000,  // 2025-10-10T18:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xbe\x2a\xc8\xab\x55\xcf\xc2\x0c\x06"
     "\xec\x19\xdb\x32\x1d\xb3\xa1\x46\xc4\xb7\xe4\xfc\xcf\xc5\xc0\xb6\x0f\x65"
     "\xa3\xc8\xe6\x6b\xe6\x9a\x4d\x09\x7c\x89\x50\xb2\xa5\x41\x57\xb4\xba\x6d"
     "\xe3\xf4\x87\x6a\x85\x33\x6e\xf7\x23\x0d\x7f\xfa\x07\x52\x1b\x2f\x73\xa8"
     "\x21",
     91},
    {"DigiCert 'sphinx2027h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1760119200000,  // 2025-10-10T18:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x50\x27\xb6\xdc\xcf\x3c\xf6\x60\x2c"
     "\x51\x57\x93\x4c\x17\x0d\xb0\x09\x8f\xdf\xbe\x19\x59\x06\xe8\x2d\xd4\x7c"
     "\x45\xd1\xb0\x33\x75\x59\xe8\xff\xec\x0f\x08\x6b\x2f\xbc\x0a\xe3\x3a\xd7"
     "\x3e\x1d\xc7\xc0\xb0\xc3\x2f\x10\xe3\xbd\x10\x5e\x8a\xf5\x12\x6e\x96\x52"
     "\xc0",
     91},
    {"Sectigo 'Sabre2025h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758216000000,  // 2025-09-18T17:20:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x85\x13\x11\x2d\x7b\xf3\x93\x81\xe4"
     "\xb9\x7c\xd9\x64\x3b\xe7\xb5\x83\x99\x66\x79\x59\x47\x6a\x42\x5e\xd6\xbd"
     "\x63\x2e\xb7\x91\x4b\xae\xbc\x56\xc4\xc5\x6e\x09\xa0\xd7\x64\x1a\xc8\xc1"
     "\xaf\x89\x8b\xf5\x58\xd8\xba\xeb\x7b\x83\x52\xe9\xf4\xe0\xa5\xcd\xcd\x92"
     "\xcc",
     91},
    {"Sectigo 'Mammoth2025h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1756500000000,  // 2025-08-29T20:40:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x88\xe2\xc7\xb3\xd7\x37\xa3\x91\xd7"
     "\xb3\xc5\xda\x07\x51\x04\x2b\x81\xed\xc2\x44\x3b\x75\xa0\xe6\x65\xe1\x4a"
     "\xba\x1b\xb1\x9c\xa9\x2a\x84\x31\x29\xae\x1d\x8b\xf1\x33\x9f\x12\x2e\x90"
     "\xb1\x15\x67\x66\xa0\x7c\x0b\x5b\x62\x7f\x6c\x9a\x6a\x30\x9b\x68\x02\x16"
     "\x6f",
     91},
    {"Sectigo 'Mammoth2026h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758216000000,  // 2025-09-18T17:20:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x9e\xcb\x0c\x8a\x51\xcc\x8a\xe2\x0b"
     "\xce\x85\xe6\xaf\x4d\x31\xdb\x1b\x6a\x4c\xfd\xb0\x79\x6b\x99\x97\xc0\x5d"
     "\xfb\x6e\x45\x50\x1d\x62\xaa\xc6\x9f\x9b\x6b\x05\x3d\xa2\xab\x2b\x5d\x88"
     "\x9b\x50\x28\xe2\x9e\x58\xa5\xa5\xfa\xf9\xe3\xfa\x15\x25\xe3\x14\x13\x32"
     "\xc4",
     91},
    {"Sectigo 'Mammoth2026h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758216000000,  // 2025-09-18T17:20:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xec\x83\x61\xf2\xd7\xb4\xbb\xe4\xe4"
     "\x3b\xeb\xc8\x63\x75\x98\xcf\x61\x90\x63\x14\x3d\x5f\x22\xdf\x74\xba\x50"
     "\xa7\x58\x9b\x69\x7d\xe6\x63\x89\x6d\xd9\xd7\x51\x84\x3f\xf8\x02\xd8\xc8"
     "\xff\xc2\x97\x71\xe5\x7e\x27\xf5\x72\xb1\x8f\x24\x27\x57\x0a\x0d\x74\xc0"
     "\xb6",
     91},
    {"Sectigo 'Sabre2026h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758216000000,  // 2025-09-18T17:20:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x84\x26\xbc\x36\xbd\xd8\x8d\x3c\x87"
     "\x9e\xe0\x10\xaf\xcd\x94\xd9\xd7\xb9\x51\x80\x34\x7e\xf7\x58\x5c\x73\xea"
     "\xeb\x09\x93\xb8\x10\x7b\x90\x9c\x7d\xc7\xcd\x96\x43\xed\x53\x6e\x95\x21"
     "\x46\x67\x51\xf0\xde\xb6\xc9\x9e\xaa\xe2\x80\x6d\xce\x25\x81\x34\xd7\x6a"
     "\x60",
     91},
    {"Sectigo 'Sabre2026h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758216000000,  // 2025-09-18T17:20:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xce\x35\xca\xec\x39\x07\x82\xda\x77"
     "\x27\x86\xe4\xf2\x7e\xc5\xdc\x38\xf2\x9b\xa9\xab\x8c\xa7\xc0\xed\x83\x1e"
     "\x3e\x6a\x1b\xc0\xf0\x95\x56\xba\x32\x33\x4c\x75\x7c\x09\x07\xe9\xe1\x3e"
     "\x65\x35\x63\xf0\x49\xbe\x72\xd1\xaa\x9d\xaf\x7d\x08\xc4\xb4\x8d\x59\x3d"
     "\x73",
     91},
    {"Sectigo 'Elephant2025h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1753148000000,  // 2025-07-22T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xd0\xe9\x4b\x78\x65\xb6\xa9\x46\x46"
     "\x52\x84\x04\x47\x27\x70\xdc\x69\x5a\xc8\x43\xb7\x64\xad\xf8\xd7\xcc\xd3"
     "\x85\x8d\x6d\x0d\x8a\xfc\xe4\x04\xa6\x7b\xa6\x4e\x2f\xfd\x83\x5f\x23\x97"
     "\xc3\xc4\x42\xc1\x5b\x0a\x85\x16\xce\xa8\xc1\x0e\xc5\x6e\x10\xda\x9e\x0a"
     "\x42",
     91},
    {"Sectigo 'Elephant2026h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1753148000000,  // 2025-07-22T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x53\x49\x6a\x9c\xf1\xe8\x5e\xe5\x3d"
     "\x15\xcf\x5d\x26\xfd\x47\x41\x90\xaf\xb2\xc2\x5f\xbf\x12\xec\x8a\xbc\x15"
     "\x43\xf7\xe4\x17\x25\x2a\x7a\xee\x22\x9f\x03\xca\x8a\x47\x93\xe0\x31\xb2"
     "\xc9\x65\x87\xe0\xd4\x7f\x0c\x22\x5a\xd9\xb0\x2e\x98\x7a\xd7\x25\xd0\x1c"
     "\x69",
     91},
    {"Sectigo 'Elephant2026h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1753148000000,  // 2025-07-22T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x3b\xfb\x78\x53\x09\x28\xa2\xee\xfc"
     "\xce\x40\x9c\x86\x1f\x6d\x7c\x02\x9b\x21\x42\x66\x6c\xea\x14\x01\xbf\x2c"
     "\xcc\x3f\x12\xb6\x79\xc7\x14\xa0\x15\x63\x99\x2a\xd4\xb8\xec\xf1\x80\xfb"
     "\x09\xfc\xdd\x0f\xbc\x5c\x56\x39\x90\x62\x96\xed\x35\x48\x71\x44\xc4\x6d"
     "\x98",
     91},
    {"Sectigo 'Elephant2027h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1753148000000,  // 2025-07-22T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xe1\xfb\xb7\xe8\x9c\xa0\x53\x06\x9a"
     "\x54\xef\x9d\x75\x62\x7d\xec\x52\x59\x94\x0e\x52\x8c\xf2\xe6\x4f\xe4\x47"
     "\xc2\x0d\x29\x6a\xf9\x08\xad\xb4\xf5\x6f\x92\xcd\x42\xbb\x1a\x13\x0d\x02"
     "\xa0\x6a\xda\x7f\xb0\x64\xcc\xa6\x5f\xec\xf0\xbc\x81\x80\x12\x73\x0d\xb0"
     "\xa0",
     91},
    {"Sectigo 'Elephant2027h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1753148000000,  // 2025-07-22T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x09\x33\xe1\xa4\x99\xd1\x16\xba\x11"
     "\x46\x93\xff\xd4\x37\x40\x9e\xcf\x8f\xae\x79\x94\xcb\x0b\x6a\x21\x5f\x84"
     "\x78\xbe\x09\x83\xcc\xca\xa2\xea\x16\xee\x4b\x80\x91\x8a\x3e\x91\x97\xa8"
     "\x1e\xdc\x8a\xec\x20\x61\x7e\x52\x25\x32\x4e\xd3\xd9\x0a\xe7\xe3\x0f\xed"
     "\xf2",
     91},
    {"Sectigo 'Tiger2025h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758236400000,  // 2025-09-18T23:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x15\x49\x79\x91\xe0\x5b\x59\x57\x24"
     "\x5c\xcb\xfa\x59\x25\x93\xa1\x37\x86\xc2\x2f\x43\x48\xd0\x88\xd9\x66\x65"
     "\x20\x43\x41\x90\x0f\xf3\x00\x39\xa6\x4b\x9f\x30\xdf\x7f\xdf\xd0\x98\x42"
     "\xd8\xa1\x24\x59\x2f\xb8\x4f\xbf\xdb\x60\xe5\xef\xe1\xd0\xcd\xcf\x3a\xc4"
     "\xc6",
     91},
    {"Sectigo 'Tiger2026h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758236400000,  // 2025-09-18T23:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xef\x77\x83\x27\x2b\x33\x0d\xbc\xec"
     "\x59\xc8\x08\xd2\x76\xed\x53\x4f\xb2\xd7\x58\x10\x5a\x33\x63\x4b\xf4\x52"
     "\x3b\x93\xf8\x84\xe4\x85\x13\xea\x4f\xac\x30\xad\x7c\xd3\xc7\x7b\xa7\x6a"
     "\xef\xf5\xd0\x63\x03\x85\xb7\xd1\x5e\x6f\xc4\xf0\x41\x6f\xa6\xa9\x73\x79"
     "\xc6",
     91},
    {"Sectigo 'Tiger2026h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758236400000,  // 2025-09-18T23:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7c\x91\x54\x0f\xf1\x51\x92\x89\xef"
     "\x64\x80\x3d\x65\x3d\x49\xdf\x2b\xc0\xe0\x4a\x52\xa7\x78\xa7\x9d\xb2\x15"
     "\xa4\xc4\xc3\x47\x5a\x02\x7b\x9b\xe0\xb9\xaa\x61\x79\x0e\xf0\x62\x25\x9a"
     "\x08\x44\xb5\x10\xbd\x41\xfb\x60\x44\x0b\xe3\xf9\x6d\x47\xf0\x17\x8e\x25"
     "\x9c",
     91},
    {"Sectigo 'Tiger2027h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758236400000,  // 2025-09-18T23:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x98\xc4\x28\x7e\x9b\x03\x8c\x25\x58"
     "\xcc\x5e\x23\x5d\xd1\x56\x33\xf8\xa8\x60\x12\x48\x3d\xcb\x10\x42\xb3\x40"
     "\x1c\x4e\xaf\xe2\x53\xac\x00\x3a\x08\xfb\xf8\xcd\xd6\x5a\x61\xf3\x1e\x0a"
     "\xdc\xd8\x27\x5c\x35\xf0\x9b\x22\x5c\x17\x04\x58\x81\x53\x81\x32\x16\x98"
     "\x84",
     91},
    {"Sectigo 'Tiger2027h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1758236400000,  // 2025-09-18T23:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x6f\x40\x20\x91\xe9\xa1\xb0\xf9\x98"
     "\x7b\x58\x28\x09\x2c\xb9\x9d\xc7\xf6\x94\x6f\x6f\xb4\xae\x9f\xf9\x2c\xce"
     "\x0c\xa2\x4c\x60\x48\x0f\x39\x3f\xb3\xf7\x77\x14\x10\xa3\x35\x11\xa4\xee"
     "\xa3\x4f\x6b\xa3\x37\xdd\xaa\x18\xde\x8a\x12\x25\xdb\x9c\xbd\x03\x72\x61"
     "\xc9",
     91},
    {"Let's Encrypt 'Oak2025h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1765578600000,  // 2025-12-12T22:30:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xb5\x76\x30\x07\xad\xc6\xc8\xd2\xe4"
     "\x4b\xd2\xf5\xbe\xa2\x8d\x9c\xfd\x74\xfa\x3a\xd6\xfa\x59\x5d\xb6\x1c\x60"
     "\xd3\xdd\x1f\x63\x87\x86\xe3\x45\xe0\xd5\x1b\xc0\x35\x6a\xab\x27\x91\x95"
     "\xc9\xd7\x3d\xbb\xc1\xf7\x71\x86\x69\xf4\xb3\x5f\x90\x09\xaa\xae\xbd\x8d"
     "\xa9",
     91},
    {"Let's Encrypt 'Oak2026h1'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1765578600000,  // 2025-12-12T22:30:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x99\xd4\x61\x70\x22\xfa\x77\x93\x0d"
     "\xb3\xc7\x80\x96\x22\x51\xbf\x25\x79\xb1\x01\x42\xe9\x41\x7b\x8b\x0c\xc7"
     "\xb2\x65\x5a\x89\xf4\xfa\xe2\x02\x46\xd4\x8a\xc7\xcc\x10\x07\x11\x27\x45"
     "\x48\x90\x23\x40\xde\x7a\x4d\x89\x32\xfb\xd7\x0a\xeb\x5e\x8c\xa2\xf1\xf6"
     "\x49",
     91},
    {"Let's Encrypt 'Oak2026h2'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1765578600000,  // 2025-12-12T22:30:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x6a\x70\x9d\xb3\x96\xe3\xec\x85\x36"
     "\x95\xc3\x4f\x9c\x8b\xd9\x7c\xc9\xd5\x91\x29\xae\xeb\xd6\x87\xdc\x04\xbc"
     "\x3b\xf6\x34\x0f\xf6\xdb\x08\xf7\x52\xa9\x88\xef\xbb\x3f\x59\xd6\xd4\xf6"
     "\xf4\xfc\x5c\xa9\x8c\x5f\xfb\x0d\x60\xe4\x2c\x0f\x16\xec\x2a\xb2\x6d\xeb"
     "\x15",
     91},
    {"Let's Encrypt 'Sycamore2025h2d'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x44\x8f\x20\xad\xdd\xeb\xb2\xe1\x3d"
     "\xe7\xfd\xd1\x93\xf2\x67\xf6\xb1\x81\xae\x97\x2f\x0e\xa0\xfa\x63\x93\xa8"
     "\xcf\x51\x3e\xc4\x00\x46\x97\x7c\x3a\x24\xb7\x45\x1d\xfc\xd2\x15\x9b\xc4"
     "\x15\x7f\xc6\xa1\xaa\xfa\x9d\xbc\xd0\x1e\xd5\x7b\xe6\xe7\x78\x47\x42\x1a"
     "\x7e",
     91},
    {"Let's Encrypt 'Sycamore2026h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7c\x41\x1e\xd0\x96\x64\x9c\x0f\x75"
     "\xfd\xce\x9e\x36\x5d\x5a\x7b\x18\x1e\x2b\x3b\x86\x41\x43\x2f\x44\x25\xcf"
     "\x5e\x0f\x4b\xdb\x6e\xce\xe4\x8e\x0f\x8b\xef\x80\x6d\xca\x6a\xea\xac\x65"
     "\x55\x42\x8f\x61\xa7\xc0\x25\xe9\x40\x9c\xc7\xc6\xce\xfd\xe5\x1c\x27\x3c"
     "\x80",
     91},
    {"Let's Encrypt 'Sycamore2026h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xc1\x1d\x45\xb6\x28\x8c\x6e\x9b\xf1"
     "\x47\xeb\x08\x7a\x26\x79\x25\x20\x88\x0c\x87\x53\x00\xf8\x7b\x3a\xba\x5d"
     "\x72\x17\x2b\x09\xcc\x8d\x54\x3b\xcd\x52\xad\xf9\xf2\x9a\x89\xc7\x6a\x9d"
     "\xca\xb3\x88\xf8\x48\xc6\xc5\x9e\xd4\x88\xf7\x0d\xdd\xb2\xf7\x43\xdf\x45"
     "\xa8",
     91},
    {"Let's Encrypt 'Sycamore2027h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x5a\xb1\x9d\x63\x26\x58\x07\xbb\x5e"
     "\x09\x2e\x0a\xfe\x82\x88\xb1\xb5\x74\xc9\x50\x52\x82\x39\x4e\xc0\xed\xb6"
     "\x38\xe0\xa8\x03\xa6\x36\xe7\x64\x21\x17\x30\xbc\x5a\x0e\xe8\x55\x75\x4a"
     "\xa9\xf9\x16\x69\x26\x8c\xfe\x7f\xb7\xa5\xf0\x81\x7f\x80\x40\x92\x97\x71"
     "\xf2",
     91},
    {"Let's Encrypt 'Sycamore2027h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x2b\xed\xb3\xcb\x65\x16\x44\xc2\x32"
     "\x0b\x68\xd4\xe3\xaf\xab\x8f\xc5\x2c\xc8\xc8\xcb\xb1\x02\x2b\xd5\x8f\xfa"
     "\x0a\x56\xdd\xa5\x61\xad\x85\x46\xfc\xcb\x73\x1a\x7f\x8c\xdf\x01\x94\xd6"
     "\x5b\xe0\x07\xf7\x00\x16\x3c\xb4\x4b\xe6\xf9\xad\xcf\xb6\x64\x87\x67\xf6"
     "\x9c",
     91},
    {"Let's Encrypt 'Willow2025h2d'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x95\x7e\xfc\x58\xe6\x6c\xac\x3a\x7b"
     "\xfc\xb0\xc5\xbe\xc1\xb2\xb5\xc9\x5a\x9d\x68\x49\xda\x81\x30\x76\x0c\xad"
     "\x2a\x8d\xb5\x66\xb0\xb3\x6c\x9e\xab\x68\x50\x26\x67\x56\xcc\x16\x1e\x01"
     "\xff\x4f\x9e\xd5\xa5\xad\x7e\x11\xb6\xc2\x00\x8c\xd9\xec\x7f\x68\x38\x19"
     "\xb8",
     91},
    {"Let's Encrypt 'Willow2026h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xb6\x91\x72\xba\x5c\x20\xcb\x5f\xae"
     "\xfb\x06\x10\xdf\xb9\x5b\x57\xe1\xec\x3c\x53\x58\xa2\x2e\x2c\xcb\xa7\x59"
     "\x3f\xae\xb6\x37\xf6\x7f\xba\xc7\x4d\x8b\x8f\x90\xdd\x12\xc4\x4b\x54\x58"
     "\xd8\xf3\x64\xef\x32\xff\xed\x53\xd2\x9f\x72\x44\x44\xc3\xee\xfe\xce\x1e"
     "\xe0",
     91},
    {"Let's Encrypt 'Willow2026h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xa7\xcc\x07\xf1\x1e\xb3\x7c\xcf\x94"
     "\x86\xc4\x2a\xe6\xe9\xfe\x94\xf7\x4d\x4c\x39\x33\x72\x09\x16\x2e\x2d\x43"
     "\xc3\x2a\x94\xe9\x3d\x34\x9a\xd3\xf9\xfc\x2b\x86\x8e\xfa\x70\xe2\x62\x33"
     "\xf3\xd2\x3a\x29\x5e\x59\xbe\x14\x47\xb7\x96\x53\x17\xaa\x9e\xdb\x8a\x6a"
     "\x88",
     91},
    {"Let's Encrypt 'Willow2027h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xce\xc3\x0a\xb6\x88\xce\xd0\x15\x41"
     "\xe2\xde\x7d\x95\x5c\x80\x87\x1b\x6a\x39\xb5\x40\xfb\x02\x1d\xe4\x1a\x49"
     "\x18\x0f\x29\x66\xbc\x39\x19\x38\xf3\xba\x1a\x6f\x2e\xef\xe1\x79\x01\xa2"
     "\xd2\x11\xc2\x7a\x2b\x25\x90\x37\xb7\xe0\xdf\xf6\x0f\x44\xb0\x11\x40\x44"
     "\xd3",
     91},
    {"Let's Encrypt 'Willow2027h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x61\xb3\x03\x83\x4a\x90\x10\x46\x23"
     "\xb1\x3b\x6d\x74\x39\x68\xb9\x32\xa1\x83\x77\xd1\x88\xc2\x58\x34\x4f\x84"
     "\xa6\xbf\xf6\x6d\x7c\x9e\x41\xd4\x0e\x1c\xa4\x0d\x2a\xfe\x6c\x6c\x82\xb1"
     "\x8e\xd1\x3f\xe5\x5a\xa8\xf5\x88\xd0\x6e\x76\x8e\x78\x7e\x16\x9b\x83\xe1"
     "\x75",
     91},
    {"TrustAsia Log2025a", CTLogState::Admissible, CTLogFormat::RFC6962,
     1701000000000,  // 2023-11-26T12:00:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x70\xe5\xb1\xa4\x09\x79\x2b\x9d\xf8"
     "\xa3\xa0\xdf\x18\xef\x95\x5d\x03\x6c\x7b\xa1\x91\xa9\xb8\x80\x7d\xec\x5c"
     "\x02\x08\xe2\x6e\x2f\x7c\x32\x70\xbd\x96\x84\x5f\xa6\x62\xe9\x65\xb5\x7c"
     "\x90\x58\xba\x22\xd5\xf9\xf5\x69\x54\xb7\xa8\x94\x4e\x32\x09\xae\x26\x11"
     "\x4d",
     91},
    {"TrustAsia Log2025b", CTLogState::Admissible, CTLogFormat::RFC6962,
     1701000000000,  // 2023-11-26T12:00:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xaa\xa0\x8b\xdb\x67\x14\x5d\x97\x89"
     "\x1d\x08\x8d\x06\xd7\xc1\x94\x8e\xb0\xfa\x4c\x46\xd5\x53\x08\x78\x2b\x04"
     "\x53\x6c\xf3\xde\xb1\xd1\x53\x40\xda\x90\x57\xe6\x1a\x9e\x3c\xc7\x03\xb8"
     "\xbd\x2f\xa9\xcf\xe8\x7b\x5e\xe1\x4b\x60\xe5\x38\x43\x60\x97\xc1\x5b\x2f"
     "\x65",
     91},
    {"TrustAsia 'log2026a'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1726790400000,  // 2024-09-20T00:00:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xa7\x4e\x7a\xc9\xa6\x07\xf9\xff\x74"
     "\xec\x98\xcb\x49\xe1\x00\x24\xb3\x59\x2e\x83\xfd\xc0\x70\x35\x33\x4c\x63"
     "\xca\x74\x83\xc0\x3c\x5b\x53\x40\x7c\x31\x1f\x35\xa4\x5f\x0f\xe4\xee\x4f"
     "\x89\x17\xe8\x5b\x2e\xc5\xac\x00\x05\xc9\x76\x37\x45\x97\x03\x15\xff\x60"
     "\x59",
     91},
    {"TrustAsia 'log2026b'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1726790400000,  // 2024-09-20T00:00:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x0f\x12\x8c\xa9\xe6\xe3\xec\x62\xee"
     "\xdf\x58\xc8\x50\xe6\x26\x70\x76\x10\xb7\x04\x39\xb3\xa7\xf8\x4c\x73\x3b"
     "\xc3\x38\x5a\x12\x00\x4c\xe0\xda\x0e\x16\x8a\x45\x32\x0a\x31\xaa\x22\xc7"
     "\x9d\x7d\x05\x53\xc7\x9e\x94\xea\x9b\x57\x46\xbf\x4f\xa4\x7e\xfb\xdf\xfa"
     "\x85",
     91},
    {"TrustAsia 'HETU2027'", CTLogState::Admissible, CTLogFormat::RFC6962,
     1760747400000,  // 2025-10-18T00:30:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xd7\x88\xc6\xf0\x3f\x6c\xba\xa2\x15"
     "\x58\xfb\x53\x34\xe2\xf7\xde\xe5\xca\x67\x89\x94\x9e\x73\x8c\xac\x8c\x0e"
     "\x59\xe6\x54\xec\x6b\x68\x0d\x10\x96\x21\x77\xf2\xff\xdf\xd2\x0b\xc9\x53"
     "\x01\xbb\x4f\xd8\xd3\x8f\xe3\x08\xc8\xb9\xf0\x24\xe9\xfe\xb8\xb1\x8e\x03"
     "\x5a",
     91},
    {"TrustAsia Luoshu2027", CTLogState::Admissible, CTLogFormat::Tiled,
     1764700200000,  // 2025-12-02T18:30:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xba\x64\x98\xcf\x2e\x9d\x51\x09\x70"
     "\x4d\xc9\x0f\xcc\xa3\x0a\x02\x93\x11\x8a\x7a\xb1\x1c\x80\x65\x2d\xf9\xab"
     "\xbf\x1d\x52\x74\xc1\xf5\x45\x30\x02\x8b\x5c\x1b\xd5\x5d\x7c\xb2\xcf\x18"
     "\x8e\x56\x82\xec\xf7\x21\xd8\xe4\x1a\xf0\xe7\xd1\x7a\xfb\x9b\xe1\x8f\x41"
     "\x0d",
     91},
    {"Bogus placeholder log to unbreak misbehaving CT libraries", CTLogState::Retired, CTLogFormat::RFC6962,
     1750489200000,  // 2025-06-21T07:00:00Z
     6,              // operated by Geomys
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x8f\x89\x42\x03\x15\x82\x63\xa4\xb3"
     "\x22\xd8\x64\xa9\x98\x70\x89\x45\x73\x70\xae\xb6\x8b\xa1\x5c\xfb\xf6\x12"
     "\xd1\x61\xda\x37\xa8\xe3\x3b\x52\x13\x50\x5b\xae\xf1\xb7\x8e\x89\x4f\x4f"
     "\x75\xe3\x66\x75\xa9\x59\x70\x2d\xe2\x5a\x8b\xc0\x7c\x0a\x6f\x5d\x2d\xf7"
     "\x37",
     91},
    {"Geomys 'Tuscolo2025h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1756623600000,  // 2025-08-31T07:00:00Z
     6,              // operated by Geomys
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x2b\xd7\x78\x18\x6b\x73\x6e\x4c\x30"
     "\xb1\x8a\x44\xb6\xf9\xd4\xf4\xa2\xa0\x66\xbe\xbb\x32\xc1\xa5\x07\xb9\xa7"
     "\x17\xc0\xd6\xf5\xb1\xe7\x9e\x01\xf3\x3f\x35\xcf\x6d\xda\x3b\x9f\xe1\x72"
     "\x0b\x04\x83\x62\xa1\x07\x6d\xa9\x75\x67\x40\x82\x57\x26\x43\xeb\x04\x3f"
     "\xa3",
     91},
    {"Geomys 'Tuscolo2026h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1756623600000,  // 2025-08-31T07:00:00Z
     6,              // operated by Geomys
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7e\x5c\x73\x32\x0d\x80\x8e\x38\x3b"
     "\x87\x5f\x99\x22\xf4\x3d\x2d\x5e\xb2\x16\xf7\x63\xea\xe4\x62\xf5\x86\xef"
     "\xb5\x19\xd2\x0a\x04\xb6\x49\xa9\xa4\x1f\x9e\x96\x70\xf4\x5a\x05\x34\x58"
     "\x01\x13\xc3\x22\xbe\x49\xc0\xba\xa0\x24\x05\x40\xfc\xdb\xc3\xc5\xd2\x57"
     "\x3b",
     91},
    {"Geomys 'Tuscolo2026h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1756623600000,  // 2025-08-31T07:00:00Z
     6,              // operated by Geomys
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x68\x0e\x8f\xd2\x2e\xc9\x4e\xc7\x7d"
     "\x5d\xfc\xc5\xd7\xfe\xfa\x6a\xf4\x56\x03\x75\xd7\x23\x83\x52\xb6\xc1\x4e"
     "\xfd\xa1\x6d\x06\x9e\x92\x63\xba\x25\x0c\x43\x22\x3d\x21\x52\xc4\x6c\xc5"
     "\x42\x32\x80\xd6\xbf\x6f\x80\x6f\xe8\x15\x0c\x2e\xae\x55\x8c\xcb\xd1\x50"
     "\x37",
     91},
    {"Geomys 'Tuscolo2027h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1759957200000,  // 2025-10-08T21:00:00Z
     6,              // operated by Geomys
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x39\x8c\x30\x1a\x86\x8d\xa5\x9f\xd2"
     "\x41\x6d\x15\x34\x62\x02\x3f\xbc\x06\x45\x0b\x12\x78\x4a\x30\x4d\x19\x78"
     "\x0c\xf4\x9d\x3e\x34\xa4\x3b\xff\xa8\xba\xf1\x47\xef\xc2\x3c\xb1\x04\xd1"
     "\xdc\x55\x8f\x64\x34\x9c\x00\xb6\xdc\x94\x1a\xa7\xa8\xbd\x29\xb5\x8f\x1b"
     "\x78",
     91},
    {"Geomys 'Tuscolo2027h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1759957200000,  // 2025-10-08T21:00:00Z
     6,              // operated by Geomys
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x20\x0c\xf6\x80\xe0\xfb\xc0\x8a\x6d"
     "\x6a\x22\xd3\x9e\x64\x78\x93\xb0\x10\xc2\x9e\x64\x16\x6a\xa6\x18\x76\x3f"
     "\xf0\x99\x8c\x27\x16\x92\x1f\x20\x22\xa6\x81\x40\xfd\x84\x81\x09\x35\xfb"
     "\x66\x8c\x31\x22\x44\x8a\xa5\x96\x06\x96\xa2\xed\x74\xb5\x5c\x2d\x60\xd2"
     "\xe7",
     91},
    {"Bogus RFC6962 log to avoid breaking misbehaving CT libraries", CTLogState::Retired, CTLogFormat::RFC6962,
     1750489200000,  // 2025-06-21T07:00:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x2f\x33\x56\x87\xe0\x6c\x02\x4d\x07"
     "\x9c\x41\x04\xed\x99\x35\x6c\x08\x5d\x1f\x54\x8c\xe6\xe7\x68\xd7\xe0\x93"
     "\x17\xa2\xc6\x70\xbe\x80\x55\x52\x17\x4a\xe3\x85\xf7\x9f\xd6\x83\x4a\x8b"
     "\x65\x5e\x3d\xd5\x06\xeb\x35\x18\x34\xea\x63\x3a\x2b\x01\x33\x0d\x75\xed"
     "\xaa",
     91},
    {"IPng Networks 'Halloumi2025h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1765996200000,  // 2025-12-17T18:30:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xa8\x9c\x52\x9c\x27\x0c\x85\x68\xa4"
     "\x08\x57\x96\xa3\x54\x62\xa6\x51\x9a\x54\x46\x4b\xe5\x59\xf8\x28\x42\x58"
     "\x64\xcf\x7b\x46\x8e\x57\xb9\x38\x38\x87\xaf\xa7\xf3\x4e\xee\xb5\xf3\xd2"
     "\xee\xaa\xa9\x2e\xfe\x66\x7b\xf7\x5d\x96\x92\x85\x1a\x81\x5f\x90\xc0\x6b"
     "\x01",
     91},
    {"IPng Networks 'Halloumi2026h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1765996200000,  // 2025-12-17T18:30:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xcd\xd7\x27\x1b\x04\x63\x9b\x66\x68"
     "\x03\xaf\x09\x15\x92\x9f\xa0\xce\x1c\x38\xf3\xc6\xd9\xfa\xf4\x89\x1e\xf6"
     "\xa7\x75\xda\x9f\x39\xce\x97\x0e\x7b\x1c\x9f\x51\x95\x84\x4d\xb7\xbe\x60"
     "\x20\xc2\x0a\x80\x1d\x6b\xd1\xdc\x58\xe4\x9a\x23\xab\x59\xbc\xba\x86\xd8"
     "\x8e",
     91},
    {"IPng Networks 'Halloumi2026h2a'", CTLogState::Admissible, CTLogFormat::Tiled,
     1761118200000,  // 2025-10-22T07:30:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x88\x68\x78\xcc\xcb\x1d\xba\x44\xe0"
     "\xad\xd9\x3d\x88\xf2\x30\xcf\xd3\x9f\x53\xd4\xd0\x56\x2e\x0c\xc6\xe7\xe9"
     "\x9a\x79\x6b\xce\xfd\xe2\xbc\x97\x31\x56\x1a\xd2\x4f\x85\xd0\x49\xe4\x28"
     "\x17\x92\xe5\x15\x52\x14\xe8\xf2\xf8\x23\x3a\xd8\x97\x5d\x81\x51\x69\xfd"
     "\xad",
     91},
    {"IPng Networks 'Halloumi2027h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1765996200000,  // 2025-12-17T18:30:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xc3\x94\x94\x97\x6c\x9f\x77\x94\xc5"
     "\x4a\xa5\x06\xbf\xb0\x3e\x23\x9f\x93\xa4\xb7\xbe\xcc\x47\x1c\x9a\xd5\x95"
     "\x41\xa9\x10\x42\xd3\x87\x60\xaa\x87\xf1\x36\xf2\x71\xa9\x45\xc7\x9c\x5a"
     "\xa8\x4e\x4f\x53\x83\x44\xc3\x09\xc0\x27\xd1\x56\x79\x3f\xfa\x41\xaa\x2f"
     "\x67",
     91},
    {"IPng Networks 'Halloumi2027h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1765996200000,  // 2025-12-17T18:30:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xae\x62\x9b\x16\x43\xc6\xed\x07\xd0"
     "\x50\x04\x61\x6c\x88\xa4\xf2\xf5\x5b\x22\x45\xe1\x2b\xe6\x0c\x07\xa4\xef"
     "\x2d\x99\x32\x86\x7c\xef\xef\x07\x9d\x9f\xe9\x7b\x54\x28\x6a\xa2\xf6\x47"
     "\x28\xe4\x17\x99\x91\x1d\xe0\x1f\xb7\x96\x3a\x2f\x22\x94\x33\xd8\x79\xb2"
     "\x1c",
     91},
    {"IPng Networks 'Gouda2025h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xa4\x78\x8f\xdb\x83\x0d\xa3\xca\x60"
     "\xb7\x94\x4d\xa1\xac\x2c\xbc\x62\x30\x49\xa5\x44\x28\xda\x9d\xcd\x80\x94"
     "\x5e\xd3\x2e\xd0\xc3\x35\xe6\xde\xb7\x77\x6e\x9e\x0d\x40\xf3\xfa\x79\x10"
     "\x8c\x00\xae\x46\x8e\x0b\x44\x97\x32\x89\xae\xc8\xd1\xa9\xc4\x74\xd1\xfd"
     "\xc0",
     91},
    {"IPng Networks 'Gouda2026h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x47\xac\x2f\xa9\x5c\x21\x7f\x98\xac"
     "\xb8\x2b\x70\x49\xf3\x63\x4c\xea\xea\xc1\x98\x34\xbd\x9b\x88\x30\xfe\xf1"
     "\x93\xc7\xcf\x98\x97\xda\x15\x90\xad\x7b\x5a\x6d\x42\x2a\x8d\x85\x13\x02"
     "\xb6\xa2\x20\x26\xf0\xdc\x27\x28\xe4\x19\x52\x3c\x8b\x8e\x2f\xc4\xbf\x3b"
     "\xec",
     91},
    {"IPng Networks 'Gouda2026h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x8d\xac\x9c\xce\x68\x54\x30\xd7\xed"
     "\x5b\x2e\x95\x8e\xf6\x17\x71\x35\x04\xa6\xf2\xfc\x2c\x80\x0a\x71\x87\x31"
     "\xaf\x1c\x79\xc7\x14\x06\x64\x45\x6f\x86\x76\x5e\x0a\x75\xd5\x96\xc3\x16"
     "\x86\xad\x61\xf4\x9e\x79\x79\x97\xd0\x58\xcf\xdd\xa8\x8a\xfa\x1a\x6a\x0d"
     "\xf5",
     91},
    {"IPng Networks 'Gouda2027h1'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x3a\x1d\x75\x07\x66\x91\x4f\xd0\x62"
     "\x4e\xaa\x3e\xea\x4b\xd0\xed\xc4\x86\x7f\xcd\x7d\x02\x2b\x7e\x8c\x67\x3a"
     "\x02\xe1\xe5\x19\x45\xf1\x58\x25\xf5\x60\x24\x3d\x38\x53\x67\xaf\xa3\x14"
     "\x29\x2b\x72\xc3\x8b\x15\x8a\x7e\x45\x0a\xfb\x5b\x91\xed\x66\x72\xd9\x77"
     "\x81",
     91},
    {"IPng Networks 'Gouda2027h2'", CTLogState::Admissible, CTLogFormat::Tiled,
     1764212400000,  // 2025-11-27T03:00:00Z
     7,              // operated by IPng Networks
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x3e\xec\x4f\x1f\x6d\x2c\x4a\xa5\x33"
     "\x1c\x69\x65\x65\xc7\x9c\x78\x5b\xf2\xa1\x27\xdf\xc0\x15\xa0\x5f\x82\xca"
     "\x77\xcc\x24\xdc\x0d\xda\xc9\x9b\xb0\xc2\x1d\xa9\x0e\xe1\x0e\xb2\x29\x8c"
     "\xc4\xb5\xc5\x87\x42\x14\x63\x3e\xf7\x6b\xd2\x3b\x93\x19\x14\xa8\xcf\x8d"
     "\xf3",
     91},
#ifdef DEBUG
    {"Mozilla Test RSA Log 1", CTLogState::Admissible, CTLogFormat::RFC6962,
     1721666666000,  // 2024-07-22T16:44:26Z
     8,              // operated by Mozilla Test Org 1
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xba\x88\x51"
     "\xa8\x44\x8e\x16\xd6\x41\xfd\x6e\xb6\x88\x06\x36\x10\x3d\x3c\x13\xd9\xea"
     "\xe4\x35\x4a\xb4\xec\xf5\x68\x57\x6c\x24\x7b\xc1\xc7\x25\xa8\xe0\xd8\x1f"
     "\xbd\xb1\x9c\x06\x9b\x6e\x1a\x86\xf2\x6b\xe2\xaf\x5a\x75\x6b\x6a\x64\x71"
     "\x08\x7a\xa5\x5a\xa7\x45\x87\xf7\x1c\xd5\x24\x9c\x02\x7e\xcd\x43\xfc\x1e"
     "\x69\xd0\x38\x20\x29\x93\xab\x20\xc3\x49\xe4\xdb\xb9\x4c\xc2\x6b\x6c\x0e"
     "\xed\x15\x82\x0f\xf1\x7e\xad\x69\x1a\xb1\xd3\x02\x3a\x8b\x2a\x41\xee\xa7"
     "\x70\xe0\x0f\x0d\x8d\xfd\x66\x0b\x2b\xb0\x24\x92\xa4\x7d\xb9\x88\x61\x79"
     "\x90\xb1\x57\x90\x3d\xd2\x3b\xc5\xe0\xb8\x48\x1f\xa8\x37\xd3\x88\x43\xef"
     "\x27\x16\xd8\x55\xb7\x66\x5a\xaa\x7e\x02\x90\x2f\x3a\x7b\x10\x80\x06\x24"
     "\xcc\x1c\x6c\x97\xad\x96\x61\x5b\xb7\xe2\x96\x12\xc0\x75\x31\xa3\x0c\x91"
     "\xdd\xb4\xca\xf7\xfc\xad\x1d\x25\xd3\x09\xef\xb9\x17\x0e\xa7\x68\xe1\xb3"
     "\x7b\x2f\x22\x6f\x69\xe3\xb4\x8a\x95\x61\x1d\xee\x26\xd6\x25\x9d\xab\x91"
     "\x08\x4e\x36\xcb\x1c\x24\x04\x2c\xbf\x16\x8b\x2f\xe5\xf1\x8f\x99\x17\x31"
     "\xb8\xb3\xfe\x49\x23\xfa\x72\x51\xc4\x31\xd5\x03\xac\xda\x18\x0a\x35\xed"
     "\x8d\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test EC Log", CTLogState::Admissible, CTLogFormat::RFC6962,
     1721666666000,  // 2024-07-22T16:44:26Z
     8,              // operated by Mozilla Test Org 1
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x4f\xbf\xbb\xbb\x61\xe0\xf8\xf9\xb1"
     "\xa6\x0a\x59\xac\x87\x04\xe2\xec\x05\x0b\x42\x3e\x3c\xf7\x2e\x92\x3f\x2c"
     "\x4f\x79\x4b\x45\x5c\x2a\x69\xd2\x33\x45\x6c\x36\xc4\x11\x9d\x07\x06\xe0"
     "\x0e\xed\xc8\xd1\x93\x90\xd7\x99\x1b\x7b\x2d\x07\xa3\x04\xea\xa0\x4a\xa6"
     "\xc0",
     91},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test RSA Log 2", CTLogState::Admissible, CTLogFormat::RFC6962,
     1721666666000,  // 2024-07-22T16:44:26Z
     9,              // operated by Mozilla Test Org 2
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xc1\x75\xc6"
     "\x52\x66\x09\x9f\x77\x08\x2a\x67\x91\xf1\xb8\x76\xc3\x7f\x5c\xe5\x38\xb0"
     "\x6c\x4a\xcd\x22\xb1\xcb\xd4\x6f\xa6\x5a\xda\x2a\xdd\x41\xc8\xc2\x49\x8a"
     "\xc4\xa3\xb3\xc1\xf6\x14\x87\xf4\x1b\x69\x89\x41\xbd\x80\xa5\x1c\x3c\x12"
     "\x02\x44\xc5\x84\xa4\xc4\x48\x33\x05\xe5\x13\x8c\x01\x06\xcf\x08\xbe\x9a"
     "\x86\x27\x60\xba\xe6\xa2\xe8\xf3\x6f\x23\xc5\xd9\x83\x13\xb9\xdf\xaf\x37"
     "\x83\x45\xda\xce\x51\xd4\xd6\xdc\xd2\xa6\xcb\x3c\xc7\x06\xeb\xcd\x30\x70"
     "\xec\x98\xcc\xe4\x0a\xa5\x91\xd7\x29\x5a\x7f\x71\xc5\xbe\x66\x69\x1d\x2b"
     "\x2d\xfe\xc8\x49\x44\x59\x0b\xc5\xa3\xea\x49\xfd\x93\xb1\xd7\x53\x40\x5f"
     "\x17\x73\x76\x99\x95\x86\x66\x25\x47\x97\xed\x42\x69\x08\x88\x08\x11\x42"
     "\x20\x69\x98\x8a\x43\xfe\xe4\x8c\xe6\x87\x81\xdd\x22\xb6\xa6\x9c\xd2\x83"
     "\x75\x13\x1f\x93\x2b\x12\x8c\xe2\x86\xfa\x7d\x25\x1c\x06\x2a\xd2\x7e\xf0"
     "\x16\xf1\x87\xcd\xd5\x4e\x83\x2b\x35\xb8\x93\x0f\x74\xba\x90\xaa\x8b\xc7"
     "\x61\x67\x24\x2a\xb1\xfd\x6d\x62\x14\x0d\x18\xc4\xc0\xb8\xc6\x8f\xc3\x74"
     "\x84\x57\x32\x4a\xd7\xde\x86\xe6\x55\x2f\x1d\x1e\x19\x1d\x71\x21\x68\xd3"
     "\xbb\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test RSA Log 4", CTLogState::Admissible, CTLogFormat::Tiled,
     1750853366000,  // 2025-06-25T12:09:26Z
     10,             // operated by Mozilla Test Org 3
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xb5\x49\x89"
     "\x5c\x9d\x00\x10\x8d\x11\xa1\xf9\x9f\x87\xa9\xe3\xd1\xa5\xdb\x5d\xfa\xec"
     "\xf1\x88\xda\x57\xbf\x64\x13\x68\x8f\x2c\xe4\x72\x2c\xff\x10\x90\x38\xc1"
     "\x74\x02\xc9\x3a\x2a\x47\x3d\xbd\x28\x6a\xed\x3f\xdc\xd3\x63\xcf\x5a\x29"
     "\x14\x77\x01\xbd\xd8\x18\xd7\x61\x5b\xf9\x35\x6b\xd5\xd3\xc8\x33\x6a\xaa"
     "\x8c\x09\x71\x36\x8a\x06\xc3\xcd\x44\x61\xb9\x3e\x51\x42\x4e\x17\x44\xbb"
     "\x2e\xaa\xd4\x6a\xab\x38\xce\x19\x68\x21\x96\x1f\x87\x71\x4a\x16\x63\x69"
     "\x3f\x09\x76\x1c\xdf\x4d\x6b\xa1\x25\xea\xce\xc7\xbe\x27\x0d\x38\x8f\x78"
     "\x9f\x6c\xdf\x78\xae\x31\x44\xed\x28\xc4\x5e\x79\x29\x38\x63\xa7\xa2\x2a"
     "\x48\x98\x0a\x36\xa4\x0e\x72\xd5\x79\xc9\xb9\x25\xdf\xf8\xc7\x93\x36\x2f"
     "\xfd\x68\x97\xa7\xc1\x75\x4c\x5e\x97\xc9\x67\xc3\xea\xdd\x1a\xae\x8a\xa2"
     "\xcc\xce\x34\x8a\x01\x69\xb8\x0e\x28\xa2\xd7\x0c\x1a\x96\x0c\x6f\x33\x5f"
     "\x2d\xa0\x9b\x9b\x64\x3f\x5a\xbf\xba\x49\xe8\xaa\xa9\x81\xe9\x60\xe2\x7d"
     "\x87\x48\x0b\xdd\x55\xdd\x94\x17\xfa\x18\x50\x9f\xbb\x55\x4c\xcf\x81\xa4"
     "\x39\x7e\x8b\xa8\x12\x8a\x34\xbd\xf2\x78\x65\xc1\x89\xe5\x73\x4f\xb2\x29"
     "\x05\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
};

const CTLogOperatorInfo kCTLogOperatorList[] = {
    {"Google", 0},
    {"Cloudflare", 1},
    {"DigiCert", 2},
    {"Sectigo", 3},
    {"Let's Encrypt", 4},
    {"TrustAsia", 5},
    {"Geomys", 6},
    {"IPng Networks", 7},
#ifdef DEBUG
    {"Mozilla Test Org 1", 8},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test Org 2", 9},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test Org 3", 10},
#endif  // DEBUG
};

}  // namespace mozilla::ct

#endif  // CTKnownLogs_h
