
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in SketchObjectPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Sketcher;

/// Type structure of SketchObjectPy
PyTypeObject SketchObjectPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Sketcher.SketchObject",     /*tp_name*/
    sizeof(SketchObjectPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Represents a sketch object",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Sketcher::SketchObjectPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Sketcher::SketchObjectPy::GetterSetter,                     /*tp_getset */
    &Part::Part2DObjectPy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Sketcher::SketchObjectPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of SketchObjectPy
PyMethodDef SketchObjectPy::Methods[] = {
    {"solve",
        reinterpret_cast<PyCFunction>( staticCallback_solve ),
        METH_VARARGS,
        "Solve the sketch and update the geometry.\n"
        "\n"
        "solve()\n"
        "\n"
        "    Returns:\n"
        "        0 in case of success, otherwise the following codes in this order of\n"
        "        priority:\n"
        "        -4 if over-constrained,\n"
        "        -3 if conflicting constraints,\n"
        "        -5 if malformed constraints\n"
        "        -1 if solver error,\n"
        "        -2 if redundant constraints."
    },
    {"addGeometry",
        reinterpret_cast<PyCFunction>( staticCallback_addGeometry ),
        METH_VARARGS,
        "Add geometric objects to the sketch.\n"
        "\n"
        "addGeometry(geo:Geometry, isConstruction=False) -> int\n"
        "    Add a single geometric object to the sketch.\n"
        "\n"
        "    Args:\n"
        "        geo: The geometry to add. e.g. a Part.LineSegement\n"
        "        isConstruction: Whether the added geometry is a \"construction geometry\".\n"
        "            Defaults to `False`, i.e. by omitting, a regular geometry is added.\n"
        "\n"
        "    Returns:\n"
        "        The zero-based index of the newly added geometry.\n"
        "\n"
        "addGeometry(geo:List(Geometry), isConstruction=False) -> Tuple(int)\n"
        "    Add many geometric objects to the sketch.\n"
        "\n"
        "    Args:\n"
        "        geo: The geometry to add.\n"
        "        isConstruction: see above.\n"
        "\n"
        "    Returns:\n"
        "        A tuple of zero-based indices of all newly added geometry."
    },
    {"delGeometry",
        reinterpret_cast<PyCFunction>( staticCallback_delGeometry ),
        METH_VARARGS,
        "Delete a geometric object from the sketch.\n"
        "\n"
        "delGeometry(geoId:int)\n"
        "\n"
        "    Args:\n"
        "        geoId: The zero-based index of the geometry to delete.\n"
        "            Any internal alignment geometry thereof will be deleted, too."
    },
    {"delGeometries",
        reinterpret_cast<PyCFunction>( staticCallback_delGeometries ),
        METH_VARARGS,
        "Delete a list of geometric objects from the sketch.\n"
        "\n"
        "delGeometries(geoIds:List(int))\n"
        "\n"
        "    Args:\n"
        "        geoId: A list of zero-based indices of the geometry to delete.\n"
        "            Any internal alignment geometry thereof will be deleted, too."
    },
    {"deleteAllGeometry",
        reinterpret_cast<PyCFunction>( staticCallback_deleteAllGeometry ),
        METH_VARARGS,
        "Delete all the geometry objects from the sketch, except external geometry.\n"
        "\n"
        "deleteAllGeometry()"
    },
    {"detectDegeneratedGeometries",
        reinterpret_cast<PyCFunction>( staticCallback_detectDegeneratedGeometries ),
        METH_VARARGS,
        "Detect degenerated geometries. A curve geometry is considered degenerated\n"
        "if the parameter range is less than the tolerance.\n"
        "\n"
        "detectDegeneratedGeometries(tolerance:float)\n"
        "\n"
        "    Args:\n"
        "        tolerance: The tolerance to check the parameter range of a curve.\n"
        "\n"
        "    Returns:\n"
        "        The number of degenerated geometries."
    },
    {"removeDegeneratedGeometries",
        reinterpret_cast<PyCFunction>( staticCallback_removeDegeneratedGeometries ),
        METH_VARARGS,
        "Remove degenerated geometries. A curve geometry is considered degenerated\n"
        "if the parameter range is less than the tolerance.\n"
        "\n"
        "removeDegeneratedGeometries(tolerance:float)\n"
        "\n"
        "    Args:\n"
        "        tolerance: The tolerance to check the parameter range of a curve.\n"
        "\n"
        "    Returns:\n"
        "        The number of degenerated geometries."
    },
    {"deleteAllConstraints",
        reinterpret_cast<PyCFunction>( staticCallback_deleteAllConstraints ),
        METH_VARARGS,
        "Delete all the constraints from the sketch.\n"
        "\n"
        "deleteAllConstraints()"
    },
    {"toggleConstruction",
        reinterpret_cast<PyCFunction>( staticCallback_toggleConstruction ),
        METH_VARARGS,
        "Toggles a geometry between regular and construction.\n"
        "\n"
        "toggleConstruction(geoId:int)\n"
        "\n"
        "    Args:\n"
        "        geoId: The zero-based index of the geometry to toggle."
    },
    {"setConstruction",
        reinterpret_cast<PyCFunction>( staticCallback_setConstruction ),
        METH_VARARGS,
        "Set construction mode of a geometry.\n"
        "\n"
        "setConstruction(geoId:int, state:bool)\n"
        "\n"
        "    Args:\n"
        "        geoId: The zero-based index of the geometry to configure.\n"
        "        state: `True` configures the geometry to \"construction geometry\",\n"
        "            `False` configures it to regular geometry."
    },
    {"getConstruction",
        reinterpret_cast<PyCFunction>( staticCallback_getConstruction ),
        METH_VARARGS,
        "Determine whether the given geometry is a \"construction geometry\".\n"
        "\n"
        "getConstruction(geoId:int)\n"
        "\n"
        "    Args:\n"
        "        geoId: The zero-based index of the geometry to query.\n"
        "\n"
        "    Returns:\n"
        "        `True` if the geometry is \"construction geometry\" and\n"
        "        `False` if it s a regular geometry."
    },
    {"addConstraint",
        reinterpret_cast<PyCFunction>( staticCallback_addConstraint ),
        METH_VARARGS,
        "Add constraints to the sketch.\n"
        "\n"
        "addConstraint(constraint:Constraint) -> int\n"
        "    Add a single constraint to the sketch and solves it.\n"
        "\n"
        "    Returns:\n"
        "        The zero-based index of the newly added constraint.\n"
        "\n"
        "addConstraint(constraints:List(Constraint)) -> Tuple(int)\n"
        "    Add many constraints to the sketch without solving.\n"
        "\n"
        "    Returns:\n"
        "        A tuple of zero-based indices of all newly added constraints."
    },
    {"delConstraint",
        reinterpret_cast<PyCFunction>( staticCallback_delConstraint ),
        METH_VARARGS,
        "Delete a constraint from the sketch.\n"
        "\n"
        "delConstraint(constraintIndex:int)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to delete."
    },
    {"renameConstraint",
        reinterpret_cast<PyCFunction>( staticCallback_renameConstraint ),
        METH_VARARGS,
        "Rename a constraint in the sketch.\n"
        "\n"
        "renameConstraint(constraintIndex:int, name:str)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to rename.\n"
        "        name: The new name for the constraint.\n"
        "            An empty string makes the constraint \"unnamed\" again."
    },
    {"getIndexByName",
        reinterpret_cast<PyCFunction>( staticCallback_getIndexByName ),
        METH_VARARGS,
        "Get the index of a constraint by name.\n"
        "\n"
        "getIndexByName(name:str)\n"
        "\n"
        "    Args:\n"
        "        name: The name for the constraint to look up.\n"
        "            If there is no such constraint an exception is raised."
    },
    {"carbonCopy",
        reinterpret_cast<PyCFunction>( staticCallback_carbonCopy ),
        METH_VARARGS,
        "Copy another sketch's geometry and constraints into this sketch.\n"
        "\n"
        "carbonCopy(objName:str, asConstruction=True)\n"
        "\n"
        "    Args:\n"
        "        ObjName: The name of the sketch object to copy from.\n"
        "        asConstruction: Whether to copy the geometry as \"construction geometry\"."
    },
    {"addExternal",
        reinterpret_cast<PyCFunction>( staticCallback_addExternal ),
        METH_VARARGS,
        "Add a link to an external geometry.\n"
        "\n"
        "addExternal(objName:str, subName:str)\n"
        "\n"
        "    Args:\n"
        "        objName: The name of the document object to reference.\n"
        "        subName: The name of the sub-element of the object's shape to link as\n"
        "            \"external geometry\"."
    },
    {"delExternal",
        reinterpret_cast<PyCFunction>( staticCallback_delExternal ),
        METH_VARARGS,
        "Delete an external geometry link from the sketch.\n"
        "\n"
        "delExternal(extGeoId:int)\n"
        "\n"
        "    Args:\n"
        "        extGeoId: The zero-based index of the external geometry to remove."
    },
    {"delConstraintOnPoint",
        reinterpret_cast<PyCFunction>( staticCallback_delConstraintOnPoint ),
        METH_VARARGS,
        "Delete coincident constraints associated with a sketch point.\n"
        "\n"
        "delConstraintOnPoint(vertexId:int)\n"
        "\n"
        "    Args:\n"
        "        vertexId: A zero-based index of the shape's vertices.\n"
        "\n"
        "delConstraintOnPoint(geoId:int, pointPos:int)\n"
        "\n"
        "    Args:\n"
        "        geoId: The zero-based index of the geometry that contains the point.\n"
        "        pointPos: Enum denoting which point on the geometry is meant:\n"
        "            1: the start of a line or bounded curve.\n"
        "            2: the end of a line or bounded curve.\n"
        "            3: the center of a circle or ellipse."
    },
    {"delConstraintsToExternal",
        reinterpret_cast<PyCFunction>( staticCallback_delConstraintsToExternal ),
        METH_NOARGS,
        "Deletes all constraints referencing an external geometry."
    },
    {"setDatum",
        reinterpret_cast<PyCFunction>( staticCallback_setDatum ),
        METH_VARARGS,
        "Set the value of a datum constraint (e.g. Distance or Angle)\n"
        "\n"
        "setDatum(constraint, value)\n"
        "\n"
        "    Args:\n"
        "        constraint (int or str): The index or name of the constraint to set.\n"
        "        value (float or Quantity): The value to set for the constraint. When\n"
        "            using floats, values for linear dimensions are interpreted as\n"
        "            millimeter, angular ones as radians."
    },
    {"getDatum",
        reinterpret_cast<PyCFunction>( staticCallback_getDatum ),
        METH_VARARGS,
        "Get the value of a datum constraint (e.g. Distance or Angle)\n"
        "\n"
        "getDatum(constraint) -> Quantity\n"
        "\n"
        "    Args:\n"
        "        constraint (int or str): The index or name of the constraint to query.\n"
        "\n"
        "    Returns:\n"
        "        The value of the constraint."
    },
    {"setDriving",
        reinterpret_cast<PyCFunction>( staticCallback_setDriving ),
        METH_VARARGS,
        "Set the Driving status of a datum constraint.\n"
        "\n"
        "setDriving(constraintIndex:int, state:bool)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to configure.\n"
        "        state: `True` sets the constraint to driving,\n"
        "            `False` configures it as non-driving, i.e. reference."
    },
    {"setDatumsDriving",
        reinterpret_cast<PyCFunction>( staticCallback_setDatumsDriving ),
        METH_VARARGS,
        "Set the Driving status of all datum constraints.\n"
        "\n"
        "setDatumsDriving(state:bool)\n"
        "\n"
        "    Args:\n"
        "        state: `True` set all datum constraints to driving,\n"
        "            `False` configures them as non-driving, i.e. reference."
    },
    {"moveDatumsToEnd",
        reinterpret_cast<PyCFunction>( staticCallback_moveDatumsToEnd ),
        METH_VARARGS,
        "Moves all datum constraints to the end of the constraint list.\n"
        "\n"
        "moveDatumsToEnd()\n"
        "\n"
        "    Warning: This method reorders the constraint indices. Previously hold\n"
        "        numeric references to constraints may reference different constraints\n"
        "        after this operation."
    },
    {"getDriving",
        reinterpret_cast<PyCFunction>( staticCallback_getDriving ),
        METH_VARARGS,
        "Get the Driving status of a datum constraint.\n"
        "\n"
        "getDriving(constraintIndex:int)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to query.\n"
        "\n"
        "    Returns:\n"
        "        `True` if the constraint is driving,\n"
        "        `False` if it is non-driving, i.e. reference."
    },
    {"toggleDriving",
        reinterpret_cast<PyCFunction>( staticCallback_toggleDriving ),
        METH_VARARGS,
        "Toggle the Driving status of a datum constraint.\n"
        "\n"
        "toggleDriving(constraintIndex:int)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to toggle."
    },
    {"setVirtualSpace",
        reinterpret_cast<PyCFunction>( staticCallback_setVirtualSpace ),
        METH_VARARGS,
        "set the VirtualSpace status of a constraint"
    },
    {"getVirtualSpace",
        reinterpret_cast<PyCFunction>( staticCallback_getVirtualSpace ),
        METH_VARARGS,
        "Get the VirtualSpace status of a constraint"
    },
    {"toggleVirtualSpace",
        reinterpret_cast<PyCFunction>( staticCallback_toggleVirtualSpace ),
        METH_VARARGS,
        "toggle the VirtualSpace status of a constraint"
    },
    {"setActive",
        reinterpret_cast<PyCFunction>( staticCallback_setActive ),
        METH_VARARGS,
        "Activates or deactivates a constraint (enforce it or not).\n"
        "\n"
        "setActive(constraintIndex:int, state:bool)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to configure.\n"
        "        state: `True` sets the constraint to active i.e. enforced,\n"
        "            `False` configures it as inactive, i.e. not enforced."
    },
    {"getActive",
        reinterpret_cast<PyCFunction>( staticCallback_getActive ),
        METH_VARARGS,
        "Get whether a constraint is active, i.e. enforced, or not.\n"
        "\n"
        "getActive(constraintIndex:int)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to query.\n"
        "\n"
        "    Returns:\n"
        "        `True` if the constraint is active, i.e. enforced,\n"
        "        `False` if it is inactive, i.e. not enforced."
    },
    {"toggleActive",
        reinterpret_cast<PyCFunction>( staticCallback_toggleActive ),
        METH_VARARGS,
        "Toggle the constraint between active (enforced) and inactive.\n"
        "\n"
        "toggleActive(constraintIndex:int)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to toggle."
    },
    {"getLabelPosition",
        reinterpret_cast<PyCFunction>( staticCallback_getLabelPosition ),
        METH_VARARGS,
        "Get label position of the constraint.\n"
        "\n"
        "getLabelPosition(constraintIndex:int)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to query.\n"
        "\n"
        "    Returns:\n"
        "        float with the current value."
    },
    {"setLabelPosition",
        reinterpret_cast<PyCFunction>( staticCallback_setLabelPosition ),
        METH_VARARGS,
        "Set label position of the constraint.\n"
        "\n"
        "setLabelPosition(constraintIndex:int, value:float)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to query.\n"
        "        value: Value of the label position."
    },
    {"getLabelDistance",
        reinterpret_cast<PyCFunction>( staticCallback_getLabelDistance ),
        METH_VARARGS,
        "Get label distance of the constraint.\n"
        "\n"
        "getLabelDistance(constraintIndex:int)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to query.\n"
        "\n"
        "    Returns:\n"
        "        float with the current value."
    },
    {"setLabelDistance",
        reinterpret_cast<PyCFunction>( staticCallback_setLabelDistance ),
        METH_VARARGS,
        "Set label distance of the constraint.\n"
        "\n"
        "setLabelDistance(constraintIndex:int, value:float)\n"
        "\n"
        "    Args:\n"
        "        constraintIndex: The zero-based index of the constraint to query.\n"
        "        value: Value of the label position."
    },
    {"movePoint",
        reinterpret_cast<PyCFunction>( staticCallback_movePoint ),
        METH_VARARGS,
        "movePoint(GeoIndex,PointPos,Vector,[relative]) - move a given point (or curve)\n"
        "          to another location.\n"
        "          It moves the specified point (or curve) to the given location by adding some\n"
        "          temporary weak constraints and solve the sketch.\n"
        "          This method is mostly used to allow the user to drag some portions of the sketch\n"
        "          in real time by e.g. the mouse and it works only for underconstrained portions of\n"
        "          the sketch.\n"
        "          The argument 'relative', if present, states if the new location is given\n"
        "          relatively to the current one."
    },
    {"getPoint",
        reinterpret_cast<PyCFunction>( staticCallback_getPoint ),
        METH_VARARGS,
        "getPoint(GeoIndex,PointPos) - retrieve the vector of a point in the sketch"
    },
    {"getGeoVertexIndex",
        reinterpret_cast<PyCFunction>( staticCallback_getGeoVertexIndex ),
        METH_VARARGS,
        "(geoId, posId) = getGeoVertexIndex(index) - retrieve the GeoId and PosId of a point in the sketch"
    },
    {"getAxis",
        reinterpret_cast<PyCFunction>( staticCallback_getAxis ),
        METH_VARARGS,
        "return an axis based on the corresponding construction line"
    },
    {"fillet",
        reinterpret_cast<PyCFunction>( staticCallback_fillet ),
        METH_VARARGS,
        "create fillet between two edges or at a point"
    },
    {"trim",
        reinterpret_cast<PyCFunction>( staticCallback_trim ),
        METH_VARARGS,
        "trim a curve with a given id at a given reference point"
    },
    {"extend",
        reinterpret_cast<PyCFunction>( staticCallback_extend ),
        METH_VARARGS,
        "extend a curve to new start and end positions"
    },
    {"split",
        reinterpret_cast<PyCFunction>( staticCallback_split ),
        METH_VARARGS,
        "split a curve with a given id at a given reference point"
    },
    {"join",
        reinterpret_cast<PyCFunction>( staticCallback_join ),
        METH_VARARGS,
        "join two curves at the given end points"
    },
    {"addSymmetric",
        reinterpret_cast<PyCFunction>( staticCallback_addSymmetric ),
        METH_VARARGS,
        "add a symmetric geometric objects to the sketch with respect to a reference point or line"
    },
    {"addCopy",
        reinterpret_cast<PyCFunction>( staticCallback_addCopy ),
        METH_VARARGS,
        "add a copy of geometric objects to the sketch displaced by a vector3d"
    },
    {"addMove",
        reinterpret_cast<PyCFunction>( staticCallback_addMove ),
        METH_VARARGS,
        "Moves the geometric objects in the sketch displaced by a vector3d"
    },
    {"addRectangularArray",
        reinterpret_cast<PyCFunction>( staticCallback_addRectangularArray ),
        METH_VARARGS,
        "add an array of size cols by rows where each element is a copy of the selected geometric objects displaced by a vector3d in the cols direction and by a vector perpendicular to it in the rows direction"
    },
    {"removeAxesAlignment",
        reinterpret_cast<PyCFunction>( staticCallback_removeAxesAlignment ),
        METH_VARARGS,
        "modifies constraints so that the shape is not forced to be aligned with axes."
    },
    {"ExposeInternalGeometry",
        reinterpret_cast<PyCFunction>( staticCallback_ExposeInternalGeometry ),
        METH_VARARGS,
        "Deprecated -- use exposeInternalGeometry"
    },
    {"DeleteUnusedInternalGeometry",
        reinterpret_cast<PyCFunction>( staticCallback_DeleteUnusedInternalGeometry ),
        METH_VARARGS,
        "Deprecated -- use deleteUnusedInternalGeometry"
    },
    {"exposeInternalGeometry",
        reinterpret_cast<PyCFunction>( staticCallback_exposeInternalGeometry ),
        METH_VARARGS,
        "Exposes all internal geometry of an object supporting internal geometry"
    },
    {"deleteUnusedInternalGeometry",
        reinterpret_cast<PyCFunction>( staticCallback_deleteUnusedInternalGeometry ),
        METH_VARARGS,
        "Deletes all unused (not further constrained) internal geometry"
    },
    {"convertToNURBS",
        reinterpret_cast<PyCFunction>( staticCallback_convertToNURBS ),
        METH_VARARGS,
        "Approximates the given geometry with a B-spline"
    },
    {"increaseBSplineDegree",
        reinterpret_cast<PyCFunction>( staticCallback_increaseBSplineDegree ),
        METH_VARARGS,
        "Increases the given B-spline Degree by a number of degrees"
    },
    {"decreaseBSplineDegree",
        reinterpret_cast<PyCFunction>( staticCallback_decreaseBSplineDegree ),
        METH_VARARGS,
        "Decreases the given B-spline Degree by a number of degrees by approximating this curve"
    },
    {"modifyBSplineKnotMultiplicity",
        reinterpret_cast<PyCFunction>( staticCallback_modifyBSplineKnotMultiplicity ),
        METH_VARARGS,
        "Increases or reduces the given BSpline knot multiplicity"
    },
    {"insertBSplineKnot",
        reinterpret_cast<PyCFunction>( staticCallback_insertBSplineKnot ),
        METH_VARARGS,
        "Inserts a knot into the BSpline at the given param with given multiplicity. If the knot already exists, this increases the knot multiplicity by the given multiplicity."
    },
    {"calculateAngleViaPoint",
        reinterpret_cast<PyCFunction>( staticCallback_calculateAngleViaPoint ),
        METH_VARARGS,
        "calculateAngleViaPoint(GeoId1, GeoId2, px, py) - calculates angle between\n"
        "          curves identified by GeoId1 and GeoId2 at point (x,y). The point must be\n"
        "          on intersection of the curves, otherwise the result may be useless (except\n"
        "          line-to-line, where (0,0) is OK). Returned value is in radians."
    },
    {"isPointOnCurve",
        reinterpret_cast<PyCFunction>( staticCallback_isPointOnCurve ),
        METH_VARARGS,
        "isPointOnObject(GeoIdCurve, float x, float y) - tests if the point (x,y)\n"
        "          geometrically lies on a curve (e.g. ellipse). It treats lines as infinite,\n"
        "          arcs as full circles/ellipses/etc. Returns boolean value."
    },
    {"calculateConstraintError",
        reinterpret_cast<PyCFunction>( staticCallback_calculateConstraintError ),
        METH_VARARGS,
        "calculateConstraintError(index) - calculates the error function of the\n"
        "          constraint identified by its index and returns the signed error value.\n"
        "          The error value roughly corresponds to by how much the constraint is\n"
        "          violated. If the constraint internally has more than one error function,\n"
        "          the returned value is RMS of all errors (sign is lost in this case)."
    },
    {"changeConstraintsLocking",
        reinterpret_cast<PyCFunction>( staticCallback_changeConstraintsLocking ),
        METH_VARARGS,
        "changeConstraintsLocking(bLock) - locks or unlocks all tangent and\n"
        "          perpendicular constraints. (Constraint locking prevents it from\n"
        "          flipping to another valid configuration, when e.g. external geometry\n"
        "          is updated from outside.) The sketch solve is not triggered by the\n"
        "          function, but the SketchObject is touched (a recompute will be\n"
        "          necessary). The geometry should not be affected by the function.\n"
        "\n"
        "          The bLock argument specifies, what to do. If true, all constraints\n"
        "          are unlocked and locked again. If false, all tangent and perp.\n"
        "          constraints are unlocked."
    },
    {"getGeometryWithDependentParameters",
        reinterpret_cast<PyCFunction>( staticCallback_getGeometryWithDependentParameters ),
        METH_VARARGS,
        "getGeometryWithDependentParameters - returns a list of geoid posid pairs\n"
        "                with all the geometry element edges and vertices which the solver regards\n"
        "                as being dependent on other parameters."
    },
    {"autoconstraint",
        reinterpret_cast<PyCFunction>( staticCallback_autoconstraint ),
        METH_VARARGS,
        "Automatic sketch constraining algorithm."
    },
    {"detectMissingPointOnPointConstraints",
        reinterpret_cast<PyCFunction>( staticCallback_detectMissingPointOnPointConstraints ),
        METH_VARARGS,
        "Detects Missing Point On Point Constraints. The Detect step just identifies possible missing constraints.\n"
        "                The result may be retrieved or applied using the corresponding Get / Make methods."
    },
    {"analyseMissingPointOnPointCoincident",
        reinterpret_cast<PyCFunction>( staticCallback_analyseMissingPointOnPointCoincident ),
        METH_VARARGS,
        "Analyses the already detected Missing Point On Point Constraints to detect endpoint tagency/perpendicular.\n"
        "                The result may be retrieved or applied using the corresponding Get / Make methods."
    },
    {"detectMissingVerticalHorizontalConstraints",
        reinterpret_cast<PyCFunction>( staticCallback_detectMissingVerticalHorizontalConstraints ),
        METH_VARARGS,
        "Detects Missing Horizontal/Vertical Constraints. The Detect step just identifies possible missing constraints.\n"
        "                The result may be retrieved or applied using the corresponding Get / Make methods."
    },
    {"detectMissingEqualityConstraints",
        reinterpret_cast<PyCFunction>( staticCallback_detectMissingEqualityConstraints ),
        METH_VARARGS,
        "Detects Missing Equality Constraints. The Detect step just identifies possible missing constraints.\n"
        "                The result may be retrieved or applied using the corresponding Get / Make methods."
    },
    {"makeMissingPointOnPointCoincident",
        reinterpret_cast<PyCFunction>( staticCallback_makeMissingPointOnPointCoincident ),
        METH_VARARGS,
        "Applies the detected / set Point On Point coincident constraints. If the argument is True, then solving and redundant removal is done after each individual addition."
    },
    {"makeMissingVerticalHorizontal",
        reinterpret_cast<PyCFunction>( staticCallback_makeMissingVerticalHorizontal ),
        METH_VARARGS,
        "Applies the detected / set Vertical/Horizontal constraints. If the argument is True, then solving and redundant removal is done after each individual addition."
    },
    {"makeMissingEquality",
        reinterpret_cast<PyCFunction>( staticCallback_makeMissingEquality ),
        METH_VARARGS,
        "Applies the detected / set Equality constraints. If the argument is True, then solving and redundant removal is done after each individual addition."
    },
    {"evaluateConstraints",
        reinterpret_cast<PyCFunction>( staticCallback_evaluateConstraints ),
        METH_NOARGS,
        "Check for constraints with invalid indexes. Returns True if invalid constraints are found, False otherwise."
    },
    {"validateConstraints",
        reinterpret_cast<PyCFunction>( staticCallback_validateConstraints ),
        METH_NOARGS,
        "Removes constraints with invalid indexes."
    },
    {"autoRemoveRedundants",
        reinterpret_cast<PyCFunction>( staticCallback_autoRemoveRedundants ),
        METH_VARARGS,
        "Removes constraints currently detected as redundant by the solver. If the argument is True, then the geometry is updated after solving."
    },
    {"toPythonCommands",
        reinterpret_cast<PyCFunction>( staticCallback_toPythonCommands ),
        METH_VARARGS,
        "Prints the commands that should be executed to recreate the Geometry and Constraints of the present sketch (excluding any External Geometry)."
    },
    {"setGeometryId",
        reinterpret_cast<PyCFunction>( staticCallback_setGeometryId ),
        METH_VARARGS,
        "sets the GeometryId of the SketchGeometryExtension of the geometry with the provided GeoId"
    },
    {"getGeometryId",
        reinterpret_cast<PyCFunction>( staticCallback_getGeometryId ),
        METH_VARARGS,
        "gets the GeometryId of the SketchGeometryExtension of the geometry with the provided GeoId"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of SketchObjectPy
PyGetSetDef SketchObjectPy::GetterSetter[] = {
    {"MissingPointOnPointConstraints",
        (getter) staticCallback_getMissingPointOnPointConstraints,
        (setter) staticCallback_setMissingPointOnPointConstraints,
        "returns a list of (First FirstPos Second SecondPos Type) tuples with all the detected endpoint constraints.",
        nullptr
    },
    {"MissingVerticalHorizontalConstraints",
        (getter) staticCallback_getMissingVerticalHorizontalConstraints,
        (setter) staticCallback_setMissingVerticalHorizontalConstraints,
        "returns a list of (First FirstPos Second SecondPos Type) tuples with all the detected vertical/horizontal constraints.",
        nullptr
    },
    {"MissingLineEqualityConstraints",
        (getter) staticCallback_getMissingLineEqualityConstraints,
        (setter) staticCallback_setMissingLineEqualityConstraints,
        "returns a list of (First FirstPos Second SecondPos) tuples with all the detected line segment equality constraints.",
        nullptr
    },
    {"MissingRadiusConstraints",
        (getter) staticCallback_getMissingRadiusConstraints,
        (setter) staticCallback_setMissingRadiusConstraints,
        "returns a list of (First FirstPos Second SecondPos) tuples with all the detected radius constraints.",
        nullptr
    },
    {"OpenVertices",
        (getter) staticCallback_getOpenVertices,
        (setter) staticCallback_setOpenVertices,
        "returns a list of vertices positions.",
        nullptr
    },
    {"ConstraintCount",
        (getter) staticCallback_getConstraintCount,
        (setter) staticCallback_setConstraintCount,
        "Number of Constraints in this sketch",
        nullptr
    },
    {"GeometryCount",
        (getter) staticCallback_getGeometryCount,
        (setter) staticCallback_setGeometryCount,
        "Number of geometric objects in this sketch",
        nullptr
    },
    {"AxisCount",
        (getter) staticCallback_getAxisCount,
        (setter) staticCallback_setAxisCount,
        "Return the number of construction lines in the sketch which can be used as axes",
        nullptr
    },
    {"GeometryFacadeList",
        (getter) staticCallback_getGeometryFacadeList,
        (setter) staticCallback_setGeometryFacadeList,
        "Return a list of GeometryFacade objects corresponding to the PropertyGeometryList",
        nullptr
    },
    {"DoF",
        (getter) staticCallback_getDoF,
        (setter) staticCallback_setDoF,
        "Return the DoFs of the current solved sketch",
        nullptr
    },
    {"ConflictingConstraints",
        (getter) staticCallback_getConflictingConstraints,
        (setter) staticCallback_setConflictingConstraints,
        "Return a list of integers indicating the constraints detected as conflicting",
        nullptr
    },
    {"RedundantConstraints",
        (getter) staticCallback_getRedundantConstraints,
        (setter) staticCallback_setRedundantConstraints,
        "Return a list of integers indicating the constraints detected as redundant",
        nullptr
    },
    {"PartiallyRedundantConstraints",
        (getter) staticCallback_getPartiallyRedundantConstraints,
        (setter) staticCallback_setPartiallyRedundantConstraints,
        "Return a list of integers indicating the constraints detected as partially redundant",
        nullptr
    },
    {"MalformedConstraints",
        (getter) staticCallback_getMalformedConstraints,
        (setter) staticCallback_setMalformedConstraints,
        "Return a list of integers indicating the constraints detected as malformed",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// solve() callback and implementer
// PyObject*  SketchObjectPy::solve(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_solve (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'solve' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->solve(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addGeometry() callback and implementer
// PyObject*  SketchObjectPy::addGeometry(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_addGeometry (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addGeometry' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->addGeometry(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// delGeometry() callback and implementer
// PyObject*  SketchObjectPy::delGeometry(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_delGeometry (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'delGeometry' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->delGeometry(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// delGeometries() callback and implementer
// PyObject*  SketchObjectPy::delGeometries(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_delGeometries (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'delGeometries' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->delGeometries(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// deleteAllGeometry() callback and implementer
// PyObject*  SketchObjectPy::deleteAllGeometry(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_deleteAllGeometry (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'deleteAllGeometry' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->deleteAllGeometry(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// detectDegeneratedGeometries() callback and implementer
// PyObject*  SketchObjectPy::detectDegeneratedGeometries(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_detectDegeneratedGeometries (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'detectDegeneratedGeometries' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->detectDegeneratedGeometries(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeDegeneratedGeometries() callback and implementer
// PyObject*  SketchObjectPy::removeDegeneratedGeometries(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_removeDegeneratedGeometries (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeDegeneratedGeometries' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->removeDegeneratedGeometries(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// deleteAllConstraints() callback and implementer
// PyObject*  SketchObjectPy::deleteAllConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_deleteAllConstraints (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'deleteAllConstraints' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->deleteAllConstraints(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toggleConstruction() callback and implementer
// PyObject*  SketchObjectPy::toggleConstruction(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_toggleConstruction (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toggleConstruction' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->toggleConstruction(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setConstruction() callback and implementer
// PyObject*  SketchObjectPy::setConstruction(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setConstruction (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setConstruction' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setConstruction(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getConstruction() callback and implementer
// PyObject*  SketchObjectPy::getConstruction(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getConstruction (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getConstruction' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getConstruction(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addConstraint() callback and implementer
// PyObject*  SketchObjectPy::addConstraint(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_addConstraint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addConstraint' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->addConstraint(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// delConstraint() callback and implementer
// PyObject*  SketchObjectPy::delConstraint(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_delConstraint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'delConstraint' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->delConstraint(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// renameConstraint() callback and implementer
// PyObject*  SketchObjectPy::renameConstraint(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_renameConstraint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'renameConstraint' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->renameConstraint(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getIndexByName() callback and implementer
// PyObject*  SketchObjectPy::getIndexByName(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getIndexByName (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getIndexByName' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getIndexByName(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// carbonCopy() callback and implementer
// PyObject*  SketchObjectPy::carbonCopy(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_carbonCopy (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'carbonCopy' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->carbonCopy(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addExternal() callback and implementer
// PyObject*  SketchObjectPy::addExternal(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_addExternal (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addExternal' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->addExternal(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// delExternal() callback and implementer
// PyObject*  SketchObjectPy::delExternal(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_delExternal (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'delExternal' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->delExternal(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// delConstraintOnPoint() callback and implementer
// PyObject*  SketchObjectPy::delConstraintOnPoint(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_delConstraintOnPoint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'delConstraintOnPoint' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->delConstraintOnPoint(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// delConstraintsToExternal() callback and implementer
// PyObject*  SketchObjectPy::delConstraintsToExternal(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_delConstraintsToExternal (PyObject *self, PyObject * Py_UNUSED(args))
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'delConstraintsToExternal' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->delConstraintsToExternal();
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setDatum() callback and implementer
// PyObject*  SketchObjectPy::setDatum(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setDatum (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setDatum' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setDatum(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getDatum() callback and implementer
// PyObject*  SketchObjectPy::getDatum(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getDatum (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getDatum' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getDatum(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setDriving() callback and implementer
// PyObject*  SketchObjectPy::setDriving(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setDriving (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setDriving' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setDriving(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setDatumsDriving() callback and implementer
// PyObject*  SketchObjectPy::setDatumsDriving(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setDatumsDriving (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setDatumsDriving' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setDatumsDriving(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// moveDatumsToEnd() callback and implementer
// PyObject*  SketchObjectPy::moveDatumsToEnd(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_moveDatumsToEnd (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'moveDatumsToEnd' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->moveDatumsToEnd(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getDriving() callback and implementer
// PyObject*  SketchObjectPy::getDriving(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getDriving (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getDriving' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getDriving(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toggleDriving() callback and implementer
// PyObject*  SketchObjectPy::toggleDriving(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_toggleDriving (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toggleDriving' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->toggleDriving(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setVirtualSpace() callback and implementer
// PyObject*  SketchObjectPy::setVirtualSpace(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setVirtualSpace (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setVirtualSpace' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setVirtualSpace(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getVirtualSpace() callback and implementer
// PyObject*  SketchObjectPy::getVirtualSpace(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getVirtualSpace (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getVirtualSpace' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getVirtualSpace(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toggleVirtualSpace() callback and implementer
// PyObject*  SketchObjectPy::toggleVirtualSpace(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_toggleVirtualSpace (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toggleVirtualSpace' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->toggleVirtualSpace(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setActive() callback and implementer
// PyObject*  SketchObjectPy::setActive(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setActive (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setActive' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setActive(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getActive() callback and implementer
// PyObject*  SketchObjectPy::getActive(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getActive (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getActive' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getActive(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toggleActive() callback and implementer
// PyObject*  SketchObjectPy::toggleActive(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_toggleActive (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toggleActive' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->toggleActive(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getLabelPosition() callback and implementer
// PyObject*  SketchObjectPy::getLabelPosition(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getLabelPosition (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getLabelPosition' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getLabelPosition(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setLabelPosition() callback and implementer
// PyObject*  SketchObjectPy::setLabelPosition(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setLabelPosition (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setLabelPosition' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setLabelPosition(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getLabelDistance() callback and implementer
// PyObject*  SketchObjectPy::getLabelDistance(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getLabelDistance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getLabelDistance' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getLabelDistance(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setLabelDistance() callback and implementer
// PyObject*  SketchObjectPy::setLabelDistance(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setLabelDistance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setLabelDistance' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setLabelDistance(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// movePoint() callback and implementer
// PyObject*  SketchObjectPy::movePoint(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_movePoint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'movePoint' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->movePoint(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getPoint() callback and implementer
// PyObject*  SketchObjectPy::getPoint(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getPoint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getPoint' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getPoint(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getGeoVertexIndex() callback and implementer
// PyObject*  SketchObjectPy::getGeoVertexIndex(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getGeoVertexIndex (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getGeoVertexIndex' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getGeoVertexIndex(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getAxis() callback and implementer
// PyObject*  SketchObjectPy::getAxis(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getAxis (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getAxis' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getAxis(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// fillet() callback and implementer
// PyObject*  SketchObjectPy::fillet(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_fillet (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'fillet' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->fillet(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// trim() callback and implementer
// PyObject*  SketchObjectPy::trim(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_trim (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'trim' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->trim(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// extend() callback and implementer
// PyObject*  SketchObjectPy::extend(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_extend (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'extend' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->extend(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// split() callback and implementer
// PyObject*  SketchObjectPy::split(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_split (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'split' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->split(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// join() callback and implementer
// PyObject*  SketchObjectPy::join(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_join (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'join' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->join(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addSymmetric() callback and implementer
// PyObject*  SketchObjectPy::addSymmetric(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_addSymmetric (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addSymmetric' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->addSymmetric(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addCopy() callback and implementer
// PyObject*  SketchObjectPy::addCopy(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_addCopy (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addCopy' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->addCopy(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addMove() callback and implementer
// PyObject*  SketchObjectPy::addMove(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_addMove (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addMove' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->addMove(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addRectangularArray() callback and implementer
// PyObject*  SketchObjectPy::addRectangularArray(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_addRectangularArray (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addRectangularArray' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->addRectangularArray(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeAxesAlignment() callback and implementer
// PyObject*  SketchObjectPy::removeAxesAlignment(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_removeAxesAlignment (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeAxesAlignment' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->removeAxesAlignment(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// ExposeInternalGeometry() callback and implementer
// PyObject*  SketchObjectPy::ExposeInternalGeometry(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_ExposeInternalGeometry (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'ExposeInternalGeometry' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->ExposeInternalGeometry(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// DeleteUnusedInternalGeometry() callback and implementer
// PyObject*  SketchObjectPy::DeleteUnusedInternalGeometry(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_DeleteUnusedInternalGeometry (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'DeleteUnusedInternalGeometry' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->DeleteUnusedInternalGeometry(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exposeInternalGeometry() callback and implementer
// PyObject*  SketchObjectPy::exposeInternalGeometry(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_exposeInternalGeometry (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exposeInternalGeometry' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->exposeInternalGeometry(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// deleteUnusedInternalGeometry() callback and implementer
// PyObject*  SketchObjectPy::deleteUnusedInternalGeometry(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_deleteUnusedInternalGeometry (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'deleteUnusedInternalGeometry' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->deleteUnusedInternalGeometry(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// convertToNURBS() callback and implementer
// PyObject*  SketchObjectPy::convertToNURBS(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_convertToNURBS (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'convertToNURBS' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->convertToNURBS(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// increaseBSplineDegree() callback and implementer
// PyObject*  SketchObjectPy::increaseBSplineDegree(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_increaseBSplineDegree (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'increaseBSplineDegree' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->increaseBSplineDegree(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// decreaseBSplineDegree() callback and implementer
// PyObject*  SketchObjectPy::decreaseBSplineDegree(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_decreaseBSplineDegree (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'decreaseBSplineDegree' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->decreaseBSplineDegree(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// modifyBSplineKnotMultiplicity() callback and implementer
// PyObject*  SketchObjectPy::modifyBSplineKnotMultiplicity(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_modifyBSplineKnotMultiplicity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'modifyBSplineKnotMultiplicity' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->modifyBSplineKnotMultiplicity(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertBSplineKnot() callback and implementer
// PyObject*  SketchObjectPy::insertBSplineKnot(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_insertBSplineKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertBSplineKnot' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->insertBSplineKnot(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// calculateAngleViaPoint() callback and implementer
// PyObject*  SketchObjectPy::calculateAngleViaPoint(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_calculateAngleViaPoint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'calculateAngleViaPoint' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->calculateAngleViaPoint(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isPointOnCurve() callback and implementer
// PyObject*  SketchObjectPy::isPointOnCurve(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_isPointOnCurve (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isPointOnCurve' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->isPointOnCurve(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// calculateConstraintError() callback and implementer
// PyObject*  SketchObjectPy::calculateConstraintError(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_calculateConstraintError (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'calculateConstraintError' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->calculateConstraintError(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// changeConstraintsLocking() callback and implementer
// PyObject*  SketchObjectPy::changeConstraintsLocking(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_changeConstraintsLocking (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'changeConstraintsLocking' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->changeConstraintsLocking(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getGeometryWithDependentParameters() callback and implementer
// PyObject*  SketchObjectPy::getGeometryWithDependentParameters(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getGeometryWithDependentParameters (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getGeometryWithDependentParameters' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getGeometryWithDependentParameters(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// autoconstraint() callback and implementer
// PyObject*  SketchObjectPy::autoconstraint(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_autoconstraint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'autoconstraint' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->autoconstraint(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// detectMissingPointOnPointConstraints() callback and implementer
// PyObject*  SketchObjectPy::detectMissingPointOnPointConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_detectMissingPointOnPointConstraints (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'detectMissingPointOnPointConstraints' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->detectMissingPointOnPointConstraints(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// analyseMissingPointOnPointCoincident() callback and implementer
// PyObject*  SketchObjectPy::analyseMissingPointOnPointCoincident(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_analyseMissingPointOnPointCoincident (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'analyseMissingPointOnPointCoincident' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->analyseMissingPointOnPointCoincident(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// detectMissingVerticalHorizontalConstraints() callback and implementer
// PyObject*  SketchObjectPy::detectMissingVerticalHorizontalConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_detectMissingVerticalHorizontalConstraints (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'detectMissingVerticalHorizontalConstraints' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->detectMissingVerticalHorizontalConstraints(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// detectMissingEqualityConstraints() callback and implementer
// PyObject*  SketchObjectPy::detectMissingEqualityConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_detectMissingEqualityConstraints (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'detectMissingEqualityConstraints' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->detectMissingEqualityConstraints(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeMissingPointOnPointCoincident() callback and implementer
// PyObject*  SketchObjectPy::makeMissingPointOnPointCoincident(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_makeMissingPointOnPointCoincident (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeMissingPointOnPointCoincident' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->makeMissingPointOnPointCoincident(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeMissingVerticalHorizontal() callback and implementer
// PyObject*  SketchObjectPy::makeMissingVerticalHorizontal(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_makeMissingVerticalHorizontal (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeMissingVerticalHorizontal' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->makeMissingVerticalHorizontal(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeMissingEquality() callback and implementer
// PyObject*  SketchObjectPy::makeMissingEquality(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_makeMissingEquality (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeMissingEquality' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->makeMissingEquality(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// evaluateConstraints() callback and implementer
// PyObject*  SketchObjectPy::evaluateConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_evaluateConstraints (PyObject *self, PyObject * Py_UNUSED(args))
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'evaluateConstraints' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->evaluateConstraints();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// validateConstraints() callback and implementer
// PyObject*  SketchObjectPy::validateConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_validateConstraints (PyObject *self, PyObject * Py_UNUSED(args))
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'validateConstraints' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->validateConstraints();
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// autoRemoveRedundants() callback and implementer
// PyObject*  SketchObjectPy::autoRemoveRedundants(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_autoRemoveRedundants (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'autoRemoveRedundants' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->autoRemoveRedundants(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toPythonCommands() callback and implementer
// PyObject*  SketchObjectPy::toPythonCommands(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_toPythonCommands (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toPythonCommands' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->toPythonCommands(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setGeometryId() callback and implementer
// PyObject*  SketchObjectPy::setGeometryId(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_setGeometryId (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setGeometryId' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->setGeometryId(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getGeometryId() callback and implementer
// PyObject*  SketchObjectPy::getGeometryId(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getGeometryId (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getGeometryId' of 'Sketcher.SketchObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SketchObjectPy*>(self)->getGeometryId(args);
        if (ret != nullptr)
            static_cast<SketchObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// MissingPointOnPointConstraints() callback and implementer
// PyObject*  SketchObjectPy::MissingPointOnPointConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getMissingPointOnPointConstraints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getMissingPointOnPointConstraints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MissingPointOnPointConstraints' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setMissingPointOnPointConstraints (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<SketchObjectPy*>(self)->setMissingPointOnPointConstraints(Py::List(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'MissingPointOnPointConstraints' of object 'SketchObject'");
        return -1;
    }
}

// MissingVerticalHorizontalConstraints() callback and implementer
// PyObject*  SketchObjectPy::MissingVerticalHorizontalConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getMissingVerticalHorizontalConstraints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getMissingVerticalHorizontalConstraints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MissingVerticalHorizontalConstraints' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setMissingVerticalHorizontalConstraints (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<SketchObjectPy*>(self)->setMissingVerticalHorizontalConstraints(Py::List(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'MissingVerticalHorizontalConstraints' of object 'SketchObject'");
        return -1;
    }
}

// MissingLineEqualityConstraints() callback and implementer
// PyObject*  SketchObjectPy::MissingLineEqualityConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getMissingLineEqualityConstraints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getMissingLineEqualityConstraints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MissingLineEqualityConstraints' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setMissingLineEqualityConstraints (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<SketchObjectPy*>(self)->setMissingLineEqualityConstraints(Py::List(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'MissingLineEqualityConstraints' of object 'SketchObject'");
        return -1;
    }
}

// MissingRadiusConstraints() callback and implementer
// PyObject*  SketchObjectPy::MissingRadiusConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getMissingRadiusConstraints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getMissingRadiusConstraints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MissingRadiusConstraints' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setMissingRadiusConstraints (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<SketchObjectPy*>(self)->setMissingRadiusConstraints(Py::List(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'MissingRadiusConstraints' of object 'SketchObject'");
        return -1;
    }
}

// OpenVertices() callback and implementer
// PyObject*  SketchObjectPy::OpenVertices(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getOpenVertices (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getOpenVertices());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'OpenVertices' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setOpenVertices (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'OpenVertices' of object 'SketchObject' is read-only");
    return -1;
}

// ConstraintCount() callback and implementer
// PyObject*  SketchObjectPy::ConstraintCount(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getConstraintCount (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getConstraintCount());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ConstraintCount' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setConstraintCount (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ConstraintCount' of object 'SketchObject' is read-only");
    return -1;
}

// GeometryCount() callback and implementer
// PyObject*  SketchObjectPy::GeometryCount(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getGeometryCount (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getGeometryCount());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'GeometryCount' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setGeometryCount (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'GeometryCount' of object 'SketchObject' is read-only");
    return -1;
}

// AxisCount() callback and implementer
// PyObject*  SketchObjectPy::AxisCount(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getAxisCount (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getAxisCount());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'AxisCount' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setAxisCount (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'AxisCount' of object 'SketchObject' is read-only");
    return -1;
}

// GeometryFacadeList() callback and implementer
// PyObject*  SketchObjectPy::GeometryFacadeList(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getGeometryFacadeList (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getGeometryFacadeList());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'GeometryFacadeList' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setGeometryFacadeList (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<SketchObjectPy*>(self)->setGeometryFacadeList(Py::List(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'GeometryFacadeList' of object 'SketchObject'");
        return -1;
    }
}

// DoF() callback and implementer
// PyObject*  SketchObjectPy::DoF(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getDoF (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getDoF());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'DoF' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setDoF (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'DoF' of object 'SketchObject' is read-only");
    return -1;
}

// ConflictingConstraints() callback and implementer
// PyObject*  SketchObjectPy::ConflictingConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getConflictingConstraints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getConflictingConstraints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ConflictingConstraints' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setConflictingConstraints (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ConflictingConstraints' of object 'SketchObject' is read-only");
    return -1;
}

// RedundantConstraints() callback and implementer
// PyObject*  SketchObjectPy::RedundantConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getRedundantConstraints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getRedundantConstraints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'RedundantConstraints' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setRedundantConstraints (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'RedundantConstraints' of object 'SketchObject' is read-only");
    return -1;
}

// PartiallyRedundantConstraints() callback and implementer
// PyObject*  SketchObjectPy::PartiallyRedundantConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getPartiallyRedundantConstraints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getPartiallyRedundantConstraints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PartiallyRedundantConstraints' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setPartiallyRedundantConstraints (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PartiallyRedundantConstraints' of object 'SketchObject' is read-only");
    return -1;
}

// MalformedConstraints() callback and implementer
// PyObject*  SketchObjectPy::MalformedConstraints(PyObject *args){};
// has to be implemented in SketchObjectPyImp.cpp
PyObject * SketchObjectPy::staticCallback_getMalformedConstraints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SketchObjectPy*>(self)->getMalformedConstraints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MalformedConstraints' of object 'SketchObject'");
        return nullptr;
    }
}

int SketchObjectPy::staticCallback_setMalformedConstraints (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'MalformedConstraints' of object 'SketchObject' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
SketchObjectPy::SketchObjectPy(SketchObject *pcObject, PyTypeObject *T)
    : Part2DObjectPy(static_cast<Part2DObjectPy::PointerType>(pcObject), T)
{
}

PyObject *SketchObjectPy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // never create such objects with the constructor
    PyErr_SetString(PyExc_RuntimeError, "You cannot create directly an instance of 'SketchObjectPy'.");

    return nullptr;
}

int SketchObjectPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}

//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
SketchObjectPy::~SketchObjectPy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// SketchObjectPy representation
//--------------------------------------------------------------------------
PyObject *SketchObjectPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// SketchObjectPy Attributes
//--------------------------------------------------------------------------
PyObject *SketchObjectPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return Part2DObjectPy::_getattr(attr);
}

int SketchObjectPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return Part2DObjectPy::_setattr(attr, value);
}

SketchObject *SketchObjectPy::getSketchObjectPtr() const
{
    return static_cast<SketchObject *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in SketchObjectPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */



// returns a string which represents the object e.g. when printed in python
std::string SketchObjectPy::representation() const
{
    return {"<SketchObject object>"};
}

PyObject* SketchObjectPy::solve(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::addGeometry(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::delGeometry(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::delGeometries(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::deleteAllGeometry(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::detectDegeneratedGeometries(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::removeDegeneratedGeometries(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::deleteAllConstraints(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::toggleConstruction(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setConstruction(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getConstruction(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::addConstraint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::delConstraint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::renameConstraint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getIndexByName(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::carbonCopy(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::addExternal(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::delExternal(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::delConstraintOnPoint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::delConstraintsToExternal()
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setDatum(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getDatum(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setDriving(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setDatumsDriving(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::moveDatumsToEnd(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getDriving(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::toggleDriving(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setVirtualSpace(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getVirtualSpace(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::toggleVirtualSpace(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setActive(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getActive(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::toggleActive(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getLabelPosition(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setLabelPosition(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getLabelDistance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setLabelDistance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::movePoint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getPoint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getGeoVertexIndex(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getAxis(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::fillet(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::trim(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::extend(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::split(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::join(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::addSymmetric(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::addCopy(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::addMove(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::addRectangularArray(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::removeAxesAlignment(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::ExposeInternalGeometry(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::DeleteUnusedInternalGeometry(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::exposeInternalGeometry(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::deleteUnusedInternalGeometry(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::convertToNURBS(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::increaseBSplineDegree(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::decreaseBSplineDegree(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::modifyBSplineKnotMultiplicity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::insertBSplineKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::calculateAngleViaPoint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::isPointOnCurve(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::calculateConstraintError(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::changeConstraintsLocking(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getGeometryWithDependentParameters(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::autoconstraint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::detectMissingPointOnPointConstraints(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::analyseMissingPointOnPointCoincident(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::detectMissingVerticalHorizontalConstraints(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::detectMissingEqualityConstraints(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::makeMissingPointOnPointCoincident(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::makeMissingVerticalHorizontal(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::makeMissingEquality(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::evaluateConstraints()
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::validateConstraints()
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::autoRemoveRedundants(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::toPythonCommands(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::setGeometryId(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SketchObjectPy::getGeometryId(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::List SketchObjectPy::getMissingPointOnPointConstraints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

void  SketchObjectPy::setMissingPointOnPointConstraints(Py::List arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getMissingVerticalHorizontalConstraints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

void  SketchObjectPy::setMissingVerticalHorizontalConstraints(Py::List arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getMissingLineEqualityConstraints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

void  SketchObjectPy::setMissingLineEqualityConstraints(Py::List arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getMissingRadiusConstraints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

void  SketchObjectPy::setMissingRadiusConstraints(Py::List arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getOpenVertices() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long SketchObjectPy::getConstraintCount() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long SketchObjectPy::getGeometryCount() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long SketchObjectPy::getAxisCount() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getGeometryFacadeList() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

void  SketchObjectPy::setGeometryFacadeList(Py::List arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Long SketchObjectPy::getDoF() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getConflictingConstraints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getRedundantConstraints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getPartiallyRedundantConstraints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List SketchObjectPy::getMalformedConstraints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *SketchObjectPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int SketchObjectPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



