/* FilterManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FilterManager.vala, do not modify */

/*
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include "gala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>

#define GALA_FILTER_MANAGER_TRANSITION_NAME "strength-transition"
#define GALA_FILTER_MANAGER_TRANSITION_DURATION 500
#define GALA_COLORBLINDNESS_CORRECTION_EFFECT_EFFECT_NAME "colorblindness-correction-filter"
#define GALA_MONOCHROME_EFFECT_EFFECT_NAME "monochrome-filter"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_FILTER_MANAGER (gala_filter_manager_get_type ())
#define GALA_FILTER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FILTER_MANAGER, GalaFilterManager))
#define GALA_FILTER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FILTER_MANAGER, GalaFilterManagerClass))
#define GALA_IS_FILTER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FILTER_MANAGER))
#define GALA_IS_FILTER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FILTER_MANAGER))
#define GALA_FILTER_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FILTER_MANAGER, GalaFilterManagerClass))

typedef struct _GalaFilterManager GalaFilterManager;
typedef struct _GalaFilterManagerClass GalaFilterManagerClass;
typedef struct _GalaFilterManagerPrivate GalaFilterManagerPrivate;
enum  {
	GALA_FILTER_MANAGER_0_PROPERTY,
	GALA_FILTER_MANAGER_WM_PROPERTY,
	GALA_FILTER_MANAGER_PAUSE_FOR_SCREENSHOT_PROPERTY,
	GALA_FILTER_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_filter_manager_properties[GALA_FILTER_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT (gala_colorblindness_correction_effect_get_type ())
#define GALA_COLORBLINDNESS_CORRECTION_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT, GalaColorblindnessCorrectionEffect))
#define GALA_COLORBLINDNESS_CORRECTION_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT, GalaColorblindnessCorrectionEffectClass))
#define GALA_IS_COLORBLINDNESS_CORRECTION_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT))
#define GALA_IS_COLORBLINDNESS_CORRECTION_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT))
#define GALA_COLORBLINDNESS_CORRECTION_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT, GalaColorblindnessCorrectionEffectClass))

typedef struct _GalaColorblindnessCorrectionEffect GalaColorblindnessCorrectionEffect;
typedef struct _GalaColorblindnessCorrectionEffectClass GalaColorblindnessCorrectionEffectClass;
typedef struct _Block44Data Block44Data;
typedef struct _Block45Data Block45Data;
typedef struct _Block46Data Block46Data;

#define GALA_TYPE_MONOCHROME_EFFECT (gala_monochrome_effect_get_type ())
#define GALA_MONOCHROME_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONOCHROME_EFFECT, GalaMonochromeEffect))
#define GALA_MONOCHROME_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONOCHROME_EFFECT, GalaMonochromeEffectClass))
#define GALA_IS_MONOCHROME_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONOCHROME_EFFECT))
#define GALA_IS_MONOCHROME_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONOCHROME_EFFECT))
#define GALA_MONOCHROME_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONOCHROME_EFFECT, GalaMonochromeEffectClass))

typedef struct _GalaMonochromeEffect GalaMonochromeEffect;
typedef struct _GalaMonochromeEffectClass GalaMonochromeEffectClass;
typedef struct _Block47Data Block47Data;
typedef struct _Block48Data Block48Data;

struct _GalaFilterManager {
	GObject parent_instance;
	GalaFilterManagerPrivate * priv;
};

struct _GalaFilterManagerClass {
	GObjectClass parent_class;
};

struct _GalaFilterManagerPrivate {
	GalaWindowManager* _wm;
};

struct _Block44Data {
	int _ref_count_;
	GalaFilterManager* self;
	GalaColorblindnessCorrectionEffect* new_effect;
};

struct _Block45Data {
	int _ref_count_;
	Block44Data * _data44_;
	GalaColorblindnessCorrectionEffect* effect;
};

struct _Block46Data {
	int _ref_count_;
	GalaFilterManager* self;
	GalaColorblindnessCorrectionEffect* effect;
};

struct _Block47Data {
	int _ref_count_;
	GalaFilterManager* self;
	GalaMonochromeEffect* effect;
	GalaMonochromeEffect* new_effect;
};

struct _Block48Data {
	int _ref_count_;
	GalaFilterManager* self;
	GalaMonochromeEffect* effect;
};

static gint GalaFilterManager_private_offset;
static gpointer gala_filter_manager_parent_class = NULL;
static GSettings* gala_filter_manager_settings;
static GSettings* gala_filter_manager_settings = NULL;

VALA_EXTERN GType gala_filter_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFilterManager, g_object_unref)
VALA_EXTERN GalaFilterManager* gala_filter_manager_new (GalaWindowManager* wm);
VALA_EXTERN GalaFilterManager* gala_filter_manager_construct (GType object_type,
                                                  GalaWindowManager* wm);
static void gala_filter_manager_load_filters (GalaFilterManager* self);
static void gala_filter_manager_load_colorblindness_filter (GalaFilterManager* self);
static void gala_filter_manager_load_monochrome_filter (GalaFilterManager* self);
VALA_EXTERN GalaWindowManager* gala_filter_manager_get_wm (GalaFilterManager* self);
VALA_EXTERN GalaColorblindnessCorrectionEffect* gala_colorblindness_correction_effect_new (gint mode,
                                                                               gdouble strength);
VALA_EXTERN GalaColorblindnessCorrectionEffect* gala_colorblindness_correction_effect_construct (GType object_type,
                                                                                     gint mode,
                                                                                     gdouble strength);
VALA_EXTERN GType gala_colorblindness_correction_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaColorblindnessCorrectionEffect, g_object_unref)
static void gala_filter_manager_update_colorblindness_filter (GalaFilterManager* self);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
VALA_EXTERN gint gala_colorblindness_correction_effect_get_mode (GalaColorblindnessCorrectionEffect* self);
VALA_EXTERN ClutterActor* gala_colorblindness_correction_effect_get_transition_actor (GalaColorblindnessCorrectionEffect* self);
VALA_EXTERN gdouble gala_colorblindness_correction_effect_get_strength (GalaColorblindnessCorrectionEffect* self);
VALA_EXTERN void gala_colorblindness_correction_effect_set_transition_actor (GalaColorblindnessCorrectionEffect* self,
                                                                 ClutterActor* value);
static void _____lambda94_ (Block45Data* _data45_);
static void ______lambda94__clutter_timeline_completed (ClutterTimeline* _sender,
                                                 gpointer self);
static void __lambda95_ (Block44Data* _data44_);
static void ___lambda95__clutter_timeline_completed (ClutterTimeline* _sender,
                                              gpointer self);
static void gala_filter_manager_update_colorblindness_strength (GalaFilterManager* self);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
static void _____lambda96_ (Block46Data* _data46_);
static void ______lambda96__clutter_timeline_completed (ClutterTimeline* _sender,
                                                 gpointer self);
VALA_EXTERN GalaMonochromeEffect* gala_monochrome_effect_new (gdouble strength);
VALA_EXTERN GalaMonochromeEffect* gala_monochrome_effect_construct (GType object_type,
                                                        gdouble strength);
VALA_EXTERN GType gala_monochrome_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonochromeEffect, g_object_unref)
static void gala_filter_manager_update_monochrome_filter (GalaFilterManager* self);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
VALA_EXTERN ClutterActor* gala_monochrome_effect_get_transition_actor (GalaMonochromeEffect* self);
VALA_EXTERN gdouble gala_monochrome_effect_get_strength (GalaMonochromeEffect* self);
VALA_EXTERN void gala_monochrome_effect_set_transition_actor (GalaMonochromeEffect* self,
                                                  ClutterActor* value);
static void ___lambda97_ (Block47Data* _data47_);
static void ____lambda97__clutter_timeline_completed (ClutterTimeline* _sender,
                                               gpointer self);
static void __lambda98_ (Block47Data* _data47_);
static void ___lambda98__clutter_timeline_completed (ClutterTimeline* _sender,
                                              gpointer self);
static void gala_filter_manager_update_monochrome_strength (GalaFilterManager* self);
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static void __lambda99_ (Block48Data* _data48_);
static void ___lambda99__clutter_timeline_completed (ClutterTimeline* _sender,
                                              gpointer self);
static void gala_filter_manager_set_wm (GalaFilterManager* self,
                                 GalaWindowManager* value);
VALA_EXTERN void gala_filter_manager_set_pause_for_screenshot (GalaFilterManager* self,
                                                   gboolean value);
VALA_EXTERN void gala_colorblindness_correction_effect_set_pause_for_screenshot (GalaColorblindnessCorrectionEffect* self,
                                                                     gboolean value);
VALA_EXTERN void gala_monochrome_effect_set_pause_for_screenshot (GalaMonochromeEffect* self,
                                                      gboolean value);
static GObject * gala_filter_manager_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _gala_filter_manager_update_colorblindness_filter_g_settings_changed (GSettings* _sender,
                                                                           const gchar* key,
                                                                           gpointer self);
static void _gala_filter_manager_update_colorblindness_strength_g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self);
static void _gala_filter_manager_update_monochrome_filter_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
static void _gala_filter_manager_update_monochrome_strength_g_settings_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self);
static void gala_filter_manager_finalize (GObject * obj);
static GType gala_filter_manager_get_type_once (void);
static void _vala_gala_filter_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gala_filter_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
gala_filter_manager_get_instance_private (GalaFilterManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaFilterManager_private_offset);
}

GalaFilterManager*
gala_filter_manager_construct (GType object_type,
                               GalaWindowManager* wm)
{
	GalaFilterManager * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaFilterManager*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaFilterManager*
gala_filter_manager_new (GalaWindowManager* wm)
{
	return gala_filter_manager_construct (GALA_TYPE_FILTER_MANAGER, wm);
}

static void
gala_filter_manager_load_filters (GalaFilterManager* self)
{
	g_return_if_fail (self != NULL);
	gala_filter_manager_load_colorblindness_filter (self);
	gala_filter_manager_load_monochrome_filter (self);
}

static void
gala_filter_manager_load_colorblindness_filter (GalaFilterManager* self)
{
	gint filter_variant = 0;
	GSettings* _tmp0_;
	gdouble strength = 0.0;
	GSettings* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_filter_manager_settings;
	filter_variant = g_settings_get_enum (_tmp0_, "colorblindness-correction-filter");
	_tmp1_ = gala_filter_manager_settings;
	strength = g_settings_get_double (_tmp1_, "colorblindness-correction-filter-strength");
	if (filter_variant != 0) {
		_tmp2_ = strength > 0.0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GalaWindowManager* _tmp3_;
		ClutterStage* _tmp4_;
		ClutterStage* _tmp5_;
		GalaColorblindnessCorrectionEffect* _tmp6_;
		GalaColorblindnessCorrectionEffect* _tmp7_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = gala_window_manager_get_stage (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gala_colorblindness_correction_effect_new (filter_variant, strength);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		clutter_actor_add_effect_with_name ((ClutterActor*) _tmp5_, GALA_COLORBLINDNESS_CORRECTION_EFFECT_EFFECT_NAME, (ClutterEffect*) _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		GalaFilterManager* self;
		self = _data44_->self;
		_g_object_unref0 (_data44_->new_effect);
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		GalaFilterManager* self;
		self = _data45_->_data44_->self;
		block44_data_unref (_data45_->_data44_);
		_data45_->_data44_ = NULL;
		g_slice_free (Block45Data, _data45_);
	}
}

static void
_____lambda94_ (Block45Data* _data45_)
{
	Block44Data* _data44_;
	GalaFilterManager* self;
	GalaColorblindnessCorrectionEffect* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	GalaWindowManager* _tmp3_;
	ClutterStage* _tmp4_;
	ClutterStage* _tmp5_;
	GalaColorblindnessCorrectionEffect* _tmp6_;
	_data44_ = _data45_->_data44_;
	self = _data44_->self;
	_tmp0_ = _data45_->effect;
	_tmp1_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp0_);
	_tmp2_ = _tmp1_;
	clutter_actor_destroy (_tmp2_);
	_tmp3_ = self->priv->_wm;
	_tmp4_ = gala_window_manager_get_stage (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _data45_->effect;
	clutter_actor_remove_effect ((ClutterActor*) _tmp5_, (ClutterEffect*) _tmp6_);
}

static void
______lambda94__clutter_timeline_completed (ClutterTimeline* _sender,
                                            gpointer self)
{
	_____lambda94_ (self);
}

static void
__lambda95_ (Block44Data* _data44_)
{
	GalaFilterManager* self;
	GalaColorblindnessCorrectionEffect* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	self = _data44_->self;
	_tmp0_ = _data44_->new_effect;
	_tmp1_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp0_);
	_tmp2_ = _tmp1_;
	clutter_actor_destroy (_tmp2_);
}

static void
___lambda95__clutter_timeline_completed (ClutterTimeline* _sender,
                                         gpointer self)
{
	__lambda95_ (self);
}

static void
gala_filter_manager_update_colorblindness_filter (GalaFilterManager* self)
{
	Block44Data* _data44_;
	gint filter_variant = 0;
	GSettings* _tmp0_;
	gdouble strength = 0.0;
	GSettings* _tmp1_;
	GalaWindowManager* _tmp2_;
	ClutterStage* _tmp3_;
	ClutterStage* _tmp4_;
	GList* _tmp5_;
	gboolean _tmp43_ = FALSE;
	GalaColorblindnessCorrectionEffect* _tmp44_;
	GalaWindowManager* _tmp45_;
	ClutterStage* _tmp46_;
	ClutterStage* _tmp47_;
	GalaColorblindnessCorrectionEffect* _tmp48_;
	ClutterPropertyTransition* new_transition = NULL;
	ClutterPropertyTransition* _tmp49_ = NULL;
	ClutterPropertyTransition* _tmp50_;
	GValue _tmp51_ = {0};
	ClutterPropertyTransition* _tmp52_;
	GValue _tmp53_ = {0};
	GalaColorblindnessCorrectionEffect* _tmp54_;
	ClutterActor* _tmp55_ = NULL;
	ClutterActor* _tmp56_;
	GalaWindowManager* _tmp57_;
	ClutterActor* _tmp58_;
	ClutterActor* _tmp59_;
	GalaColorblindnessCorrectionEffect* _tmp60_;
	ClutterActor* _tmp61_;
	ClutterActor* _tmp62_;
	GalaColorblindnessCorrectionEffect* _tmp63_;
	ClutterActor* _tmp64_;
	ClutterActor* _tmp65_;
	GalaColorblindnessCorrectionEffect* _tmp66_;
	ClutterPropertyTransition* _tmp67_;
	GalaColorblindnessCorrectionEffect* _tmp68_;
	ClutterActor* _tmp69_;
	ClutterActor* _tmp70_;
	ClutterPropertyTransition* _tmp71_;
	g_return_if_fail (self != NULL);
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_tmp0_ = gala_filter_manager_settings;
	filter_variant = g_settings_get_enum (_tmp0_, "colorblindness-correction-filter");
	_tmp1_ = gala_filter_manager_settings;
	strength = g_settings_get_double (_tmp1_, "colorblindness-correction-filter-strength");
	_tmp2_ = self->priv->_wm;
	_tmp3_ = gala_window_manager_get_stage (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = clutter_actor_get_effects ((ClutterActor*) _tmp4_);
	{
		GList* _effect_collection = NULL;
		GList* _effect_it = NULL;
		_effect_collection = _tmp5_;
		for (_effect_it = _effect_collection; _effect_it != NULL; _effect_it = _effect_it->next) {
			ClutterEffect* _effect = NULL;
			_effect = (ClutterEffect*) _effect_it->data;
			{
				ClutterEffect* _tmp6_;
				_tmp6_ = _effect;
				if (GALA_IS_COLORBLINDNESS_CORRECTION_EFFECT (_tmp6_)) {
					Block45Data* _data45_;
					ClutterEffect* _tmp7_;
					GalaColorblindnessCorrectionEffect* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					GalaColorblindnessCorrectionEffect* _tmp11_;
					ClutterActor* _tmp12_;
					ClutterActor* _tmp13_;
					ClutterPropertyTransition* transition = NULL;
					ClutterPropertyTransition* _tmp17_ = NULL;
					ClutterPropertyTransition* _tmp18_;
					GalaColorblindnessCorrectionEffect* _tmp19_;
					gdouble _tmp20_;
					gdouble _tmp21_;
					GValue _tmp22_ = {0};
					ClutterPropertyTransition* _tmp23_;
					GValue _tmp24_ = {0};
					GalaColorblindnessCorrectionEffect* _tmp25_;
					ClutterActor* _tmp26_ = NULL;
					ClutterActor* _tmp27_;
					GalaWindowManager* _tmp28_;
					ClutterActor* _tmp29_;
					ClutterActor* _tmp30_;
					GalaColorblindnessCorrectionEffect* _tmp31_;
					ClutterActor* _tmp32_;
					ClutterActor* _tmp33_;
					GalaColorblindnessCorrectionEffect* _tmp34_;
					ClutterActor* _tmp35_;
					ClutterActor* _tmp36_;
					GalaColorblindnessCorrectionEffect* _tmp37_;
					ClutterPropertyTransition* _tmp38_;
					GalaColorblindnessCorrectionEffect* _tmp39_;
					ClutterActor* _tmp40_;
					ClutterActor* _tmp41_;
					ClutterPropertyTransition* _tmp42_;
					_data45_ = g_slice_new0 (Block45Data);
					_data45_->_ref_count_ = 1;
					_data45_->_data44_ = block44_data_ref (_data44_);
					_tmp7_ = _effect;
					_data45_->effect = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT, GalaColorblindnessCorrectionEffect);
					_tmp8_ = _data45_->effect;
					_tmp9_ = gala_colorblindness_correction_effect_get_mode (_tmp8_);
					_tmp10_ = _tmp9_;
					if (_tmp10_ == filter_variant) {
						block45_data_unref (_data45_);
						_data45_ = NULL;
						continue;
					}
					_tmp11_ = _data45_->effect;
					_tmp12_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp11_);
					_tmp13_ = _tmp12_;
					if (_tmp13_ != NULL) {
						GalaColorblindnessCorrectionEffect* _tmp14_;
						ClutterActor* _tmp15_;
						ClutterActor* _tmp16_;
						_tmp14_ = _data45_->effect;
						_tmp15_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp14_);
						_tmp16_ = _tmp15_;
						clutter_actor_destroy (_tmp16_);
					}
					_tmp17_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale_x");
					clutter_timeline_set_duration ((ClutterTimeline*) _tmp17_, (guint) GALA_FILTER_MANAGER_TRANSITION_DURATION);
					clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp17_, CLUTTER_LINEAR);
					clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp17_, TRUE);
					transition = _tmp17_;
					_tmp18_ = transition;
					_tmp19_ = _data45_->effect;
					_tmp20_ = gala_colorblindness_correction_effect_get_strength (_tmp19_);
					_tmp21_ = _tmp20_;
					g_value_init (&_tmp22_, G_TYPE_DOUBLE);
					g_value_set_double (&_tmp22_, _tmp21_);
					clutter_transition_set_from_value ((ClutterTransition*) _tmp18_, &_tmp22_);
					G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
					_tmp23_ = transition;
					g_value_init (&_tmp24_, G_TYPE_DOUBLE);
					g_value_set_double (&_tmp24_, 0.0);
					clutter_transition_set_to_value ((ClutterTransition*) _tmp23_, &_tmp24_);
					G_IS_VALUE (&_tmp24_) ? (g_value_unset (&_tmp24_), NULL) : NULL;
					_tmp25_ = _data45_->effect;
					_tmp26_ = clutter_actor_new ();
					g_object_set (_tmp26_, "visible", FALSE, NULL);
					g_object_ref_sink (_tmp26_);
					_tmp27_ = _tmp26_;
					gala_colorblindness_correction_effect_set_transition_actor (_tmp25_, _tmp27_);
					_g_object_unref0 (_tmp27_);
					_tmp28_ = self->priv->_wm;
					_tmp29_ = gala_window_manager_get_ui_group (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = _data45_->effect;
					_tmp32_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp31_);
					_tmp33_ = _tmp32_;
					clutter_actor_add_child (_tmp30_, _tmp33_);
					_tmp34_ = _data45_->effect;
					_tmp35_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = _data45_->effect;
					g_object_bind_property_with_closures ((GObject*) _tmp36_, "scale_x", (GObject*) _tmp37_, "strength", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
					_tmp38_ = transition;
					g_signal_connect_data ((ClutterTimeline*) _tmp38_, "completed", (GCallback) ______lambda94__clutter_timeline_completed, block45_data_ref (_data45_), (GClosureNotify) block45_data_unref, 0);
					_tmp39_ = _data45_->effect;
					_tmp40_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = transition;
					clutter_actor_add_transition (_tmp41_, GALA_FILTER_MANAGER_TRANSITION_NAME, (ClutterTransition*) _tmp42_);
					_g_object_unref0 (transition);
					block45_data_unref (_data45_);
					_data45_ = NULL;
				}
			}
		}
		(_effect_collection == NULL) ? NULL : (_effect_collection = (g_list_free (_effect_collection), NULL));
	}
	if (filter_variant == 0) {
		_tmp43_ = TRUE;
	} else {
		_tmp43_ = strength == 0.0;
	}
	if (_tmp43_) {
		block44_data_unref (_data44_);
		_data44_ = NULL;
		return;
	}
	_tmp44_ = gala_colorblindness_correction_effect_new (filter_variant, 0.0);
	g_object_ref_sink (_tmp44_);
	_data44_->new_effect = _tmp44_;
	_tmp45_ = self->priv->_wm;
	_tmp46_ = gala_window_manager_get_stage (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = _data44_->new_effect;
	clutter_actor_add_effect_with_name ((ClutterActor*) _tmp47_, GALA_COLORBLINDNESS_CORRECTION_EFFECT_EFFECT_NAME, (ClutterEffect*) _tmp48_);
	_tmp49_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale_x");
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp49_, (guint) GALA_FILTER_MANAGER_TRANSITION_DURATION);
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp49_, CLUTTER_LINEAR);
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp49_, TRUE);
	new_transition = _tmp49_;
	_tmp50_ = new_transition;
	g_value_init (&_tmp51_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp51_, 0.0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp50_, &_tmp51_);
	G_IS_VALUE (&_tmp51_) ? (g_value_unset (&_tmp51_), NULL) : NULL;
	_tmp52_ = new_transition;
	g_value_init (&_tmp53_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp53_, strength);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp52_, &_tmp53_);
	G_IS_VALUE (&_tmp53_) ? (g_value_unset (&_tmp53_), NULL) : NULL;
	_tmp54_ = _data44_->new_effect;
	_tmp55_ = clutter_actor_new ();
	g_object_set (_tmp55_, "visible", FALSE, NULL);
	g_object_ref_sink (_tmp55_);
	_tmp56_ = _tmp55_;
	gala_colorblindness_correction_effect_set_transition_actor (_tmp54_, _tmp56_);
	_g_object_unref0 (_tmp56_);
	_tmp57_ = self->priv->_wm;
	_tmp58_ = gala_window_manager_get_ui_group (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = _data44_->new_effect;
	_tmp61_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp60_);
	_tmp62_ = _tmp61_;
	clutter_actor_add_child (_tmp59_, _tmp62_);
	_tmp63_ = _data44_->new_effect;
	_tmp64_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = _data44_->new_effect;
	g_object_bind_property_with_closures ((GObject*) _tmp65_, "scale_x", (GObject*) _tmp66_, "strength", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp67_ = new_transition;
	g_signal_connect_data ((ClutterTimeline*) _tmp67_, "completed", (GCallback) ___lambda95__clutter_timeline_completed, block44_data_ref (_data44_), (GClosureNotify) block44_data_unref, 0);
	_tmp68_ = _data44_->new_effect;
	_tmp69_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = new_transition;
	clutter_actor_add_transition (_tmp70_, GALA_FILTER_MANAGER_TRANSITION_NAME, (ClutterTransition*) _tmp71_);
	_g_object_unref0 (new_transition);
	block44_data_unref (_data44_);
	_data44_ = NULL;
}

static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		GalaFilterManager* self;
		self = _data46_->self;
		_g_object_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}

static void
_____lambda96_ (Block46Data* _data46_)
{
	GalaFilterManager* self;
	GalaColorblindnessCorrectionEffect* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	self = _data46_->self;
	_tmp0_ = _data46_->effect;
	_tmp1_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp0_);
	_tmp2_ = _tmp1_;
	clutter_actor_destroy (_tmp2_);
}

static void
______lambda96__clutter_timeline_completed (ClutterTimeline* _sender,
                                            gpointer self)
{
	_____lambda96_ (self);
}

static void
gala_filter_manager_update_colorblindness_strength (GalaFilterManager* self)
{
	gint filter_variant = 0;
	GSettings* _tmp0_;
	gdouble strength = 0.0;
	GSettings* _tmp1_;
	GalaWindowManager* _tmp2_;
	ClutterStage* _tmp3_;
	ClutterStage* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_filter_manager_settings;
	filter_variant = g_settings_get_enum (_tmp0_, "colorblindness-correction-filter");
	_tmp1_ = gala_filter_manager_settings;
	strength = g_settings_get_double (_tmp1_, "colorblindness-correction-filter-strength");
	_tmp2_ = self->priv->_wm;
	_tmp3_ = gala_window_manager_get_stage (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = clutter_actor_get_effects ((ClutterActor*) _tmp4_);
	{
		GList* _effect_collection = NULL;
		GList* _effect_it = NULL;
		_effect_collection = _tmp5_;
		for (_effect_it = _effect_collection; _effect_it != NULL; _effect_it = _effect_it->next) {
			ClutterEffect* _effect = NULL;
			_effect = (ClutterEffect*) _effect_it->data;
			{
				ClutterEffect* _tmp6_;
				_tmp6_ = _effect;
				if (GALA_IS_COLORBLINDNESS_CORRECTION_EFFECT (_tmp6_)) {
					Block46Data* _data46_;
					ClutterEffect* _tmp7_;
					GalaColorblindnessCorrectionEffect* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					GalaColorblindnessCorrectionEffect* _tmp11_;
					ClutterActor* _tmp12_;
					ClutterActor* _tmp13_;
					ClutterPropertyTransition* transition = NULL;
					ClutterPropertyTransition* _tmp17_ = NULL;
					ClutterPropertyTransition* _tmp18_;
					GalaColorblindnessCorrectionEffect* _tmp19_;
					gdouble _tmp20_;
					gdouble _tmp21_;
					GValue _tmp22_ = {0};
					ClutterPropertyTransition* _tmp23_;
					GValue _tmp24_ = {0};
					GalaColorblindnessCorrectionEffect* _tmp25_;
					ClutterActor* _tmp26_ = NULL;
					ClutterActor* _tmp27_;
					GalaWindowManager* _tmp28_;
					ClutterActor* _tmp29_;
					ClutterActor* _tmp30_;
					GalaColorblindnessCorrectionEffect* _tmp31_;
					ClutterActor* _tmp32_;
					ClutterActor* _tmp33_;
					GalaColorblindnessCorrectionEffect* _tmp34_;
					ClutterActor* _tmp35_;
					ClutterActor* _tmp36_;
					GalaColorblindnessCorrectionEffect* _tmp37_;
					ClutterPropertyTransition* _tmp38_;
					GalaColorblindnessCorrectionEffect* _tmp39_;
					ClutterActor* _tmp40_;
					ClutterActor* _tmp41_;
					ClutterPropertyTransition* _tmp42_;
					_data46_ = g_slice_new0 (Block46Data);
					_data46_->_ref_count_ = 1;
					_data46_->self = g_object_ref (self);
					_tmp7_ = _effect;
					_data46_->effect = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT, GalaColorblindnessCorrectionEffect);
					_tmp8_ = _data46_->effect;
					_tmp9_ = gala_colorblindness_correction_effect_get_mode (_tmp8_);
					_tmp10_ = _tmp9_;
					if (_tmp10_ != filter_variant) {
						block46_data_unref (_data46_);
						_data46_ = NULL;
						continue;
					}
					_tmp11_ = _data46_->effect;
					_tmp12_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp11_);
					_tmp13_ = _tmp12_;
					if (_tmp13_ != NULL) {
						GalaColorblindnessCorrectionEffect* _tmp14_;
						ClutterActor* _tmp15_;
						ClutterActor* _tmp16_;
						_tmp14_ = _data46_->effect;
						_tmp15_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp14_);
						_tmp16_ = _tmp15_;
						clutter_actor_destroy (_tmp16_);
					}
					_tmp17_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale_x");
					clutter_timeline_set_duration ((ClutterTimeline*) _tmp17_, (guint) GALA_FILTER_MANAGER_TRANSITION_DURATION);
					clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp17_, CLUTTER_LINEAR);
					clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp17_, TRUE);
					transition = _tmp17_;
					_tmp18_ = transition;
					_tmp19_ = _data46_->effect;
					_tmp20_ = gala_colorblindness_correction_effect_get_strength (_tmp19_);
					_tmp21_ = _tmp20_;
					g_value_init (&_tmp22_, G_TYPE_DOUBLE);
					g_value_set_double (&_tmp22_, _tmp21_);
					clutter_transition_set_from_value ((ClutterTransition*) _tmp18_, &_tmp22_);
					G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
					_tmp23_ = transition;
					g_value_init (&_tmp24_, G_TYPE_DOUBLE);
					g_value_set_double (&_tmp24_, strength);
					clutter_transition_set_to_value ((ClutterTransition*) _tmp23_, &_tmp24_);
					G_IS_VALUE (&_tmp24_) ? (g_value_unset (&_tmp24_), NULL) : NULL;
					_tmp25_ = _data46_->effect;
					_tmp26_ = clutter_actor_new ();
					g_object_set (_tmp26_, "visible", FALSE, NULL);
					g_object_ref_sink (_tmp26_);
					_tmp27_ = _tmp26_;
					gala_colorblindness_correction_effect_set_transition_actor (_tmp25_, _tmp27_);
					_g_object_unref0 (_tmp27_);
					_tmp28_ = self->priv->_wm;
					_tmp29_ = gala_window_manager_get_ui_group (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = _data46_->effect;
					_tmp32_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp31_);
					_tmp33_ = _tmp32_;
					clutter_actor_add_child (_tmp30_, _tmp33_);
					_tmp34_ = _data46_->effect;
					_tmp35_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = _data46_->effect;
					g_object_bind_property_with_closures ((GObject*) _tmp36_, "scale_x", (GObject*) _tmp37_, "strength", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
					_tmp38_ = transition;
					g_signal_connect_data ((ClutterTimeline*) _tmp38_, "completed", (GCallback) ______lambda96__clutter_timeline_completed, block46_data_ref (_data46_), (GClosureNotify) block46_data_unref, 0);
					_tmp39_ = _data46_->effect;
					_tmp40_ = gala_colorblindness_correction_effect_get_transition_actor (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = transition;
					clutter_actor_add_transition (_tmp41_, GALA_FILTER_MANAGER_TRANSITION_NAME, (ClutterTransition*) _tmp42_);
					_g_object_unref0 (transition);
					block46_data_unref (_data46_);
					_data46_ = NULL;
					(_effect_collection == NULL) ? NULL : (_effect_collection = (g_list_free (_effect_collection), NULL));
					return;
				}
			}
		}
		(_effect_collection == NULL) ? NULL : (_effect_collection = (g_list_free (_effect_collection), NULL));
	}
}

static void
gala_filter_manager_load_monochrome_filter (GalaFilterManager* self)
{
	gboolean enable = FALSE;
	GSettings* _tmp0_;
	gdouble strength = 0.0;
	GSettings* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_filter_manager_settings;
	enable = g_settings_get_boolean (_tmp0_, "enable-monochrome-filter");
	_tmp1_ = gala_filter_manager_settings;
	strength = g_settings_get_double (_tmp1_, "monochrome-filter-strength");
	if (enable) {
		_tmp2_ = strength > 0.0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GalaWindowManager* _tmp3_;
		ClutterStage* _tmp4_;
		ClutterStage* _tmp5_;
		GalaMonochromeEffect* _tmp6_;
		GalaMonochromeEffect* _tmp7_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = gala_window_manager_get_stage (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gala_monochrome_effect_new (strength);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		clutter_actor_add_effect_with_name ((ClutterActor*) _tmp5_, GALA_MONOCHROME_EFFECT_EFFECT_NAME, (ClutterEffect*) _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		GalaFilterManager* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->new_effect);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static void
___lambda97_ (Block47Data* _data47_)
{
	GalaFilterManager* self;
	GalaMonochromeEffect* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	GalaWindowManager* _tmp3_;
	ClutterStage* _tmp4_;
	ClutterStage* _tmp5_;
	GalaMonochromeEffect* _tmp6_;
	self = _data47_->self;
	_tmp0_ = _data47_->effect;
	_tmp1_ = gala_monochrome_effect_get_transition_actor (_tmp0_);
	_tmp2_ = _tmp1_;
	clutter_actor_destroy (_tmp2_);
	_tmp3_ = self->priv->_wm;
	_tmp4_ = gala_window_manager_get_stage (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _data47_->effect;
	clutter_actor_remove_effect ((ClutterActor*) _tmp5_, (ClutterEffect*) _tmp6_);
}

static void
____lambda97__clutter_timeline_completed (ClutterTimeline* _sender,
                                          gpointer self)
{
	___lambda97_ (self);
}

static void
__lambda98_ (Block47Data* _data47_)
{
	GalaFilterManager* self;
	GalaMonochromeEffect* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	self = _data47_->self;
	_tmp0_ = _data47_->new_effect;
	_tmp1_ = gala_monochrome_effect_get_transition_actor (_tmp0_);
	_tmp2_ = _tmp1_;
	clutter_actor_destroy (_tmp2_);
}

static void
___lambda98__clutter_timeline_completed (ClutterTimeline* _sender,
                                         gpointer self)
{
	__lambda98_ (self);
}

static void
gala_filter_manager_update_monochrome_filter (GalaFilterManager* self)
{
	Block47Data* _data47_;
	gboolean enabled = FALSE;
	GSettings* _tmp0_;
	gdouble strength = 0.0;
	GSettings* _tmp1_;
	GalaWindowManager* _tmp2_;
	ClutterStage* _tmp3_;
	ClutterStage* _tmp4_;
	ClutterEffect* _tmp5_;
	GalaMonochromeEffect* _tmp6_;
	GalaMonochromeEffect* _tmp7_;
	gboolean _tmp40_ = FALSE;
	GalaMonochromeEffect* _tmp41_;
	GalaWindowManager* _tmp42_;
	ClutterStage* _tmp43_;
	ClutterStage* _tmp44_;
	GalaMonochromeEffect* _tmp45_;
	ClutterPropertyTransition* new_transition = NULL;
	ClutterPropertyTransition* _tmp46_ = NULL;
	ClutterPropertyTransition* _tmp47_;
	GValue _tmp48_ = {0};
	ClutterPropertyTransition* _tmp49_;
	GValue _tmp50_ = {0};
	GalaMonochromeEffect* _tmp51_;
	ClutterActor* _tmp52_ = NULL;
	ClutterActor* _tmp53_;
	GalaWindowManager* _tmp54_;
	ClutterActor* _tmp55_;
	ClutterActor* _tmp56_;
	GalaMonochromeEffect* _tmp57_;
	ClutterActor* _tmp58_;
	ClutterActor* _tmp59_;
	GalaMonochromeEffect* _tmp60_;
	ClutterActor* _tmp61_;
	ClutterActor* _tmp62_;
	GalaMonochromeEffect* _tmp63_;
	ClutterPropertyTransition* _tmp64_;
	GalaMonochromeEffect* _tmp65_;
	ClutterActor* _tmp66_;
	ClutterActor* _tmp67_;
	ClutterPropertyTransition* _tmp68_;
	g_return_if_fail (self != NULL);
	_data47_ = g_slice_new0 (Block47Data);
	_data47_->_ref_count_ = 1;
	_data47_->self = g_object_ref (self);
	_tmp0_ = gala_filter_manager_settings;
	enabled = g_settings_get_boolean (_tmp0_, "enable-monochrome-filter");
	_tmp1_ = gala_filter_manager_settings;
	strength = g_settings_get_double (_tmp1_, "monochrome-filter-strength");
	_tmp2_ = self->priv->_wm;
	_tmp3_ = gala_window_manager_get_stage (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = clutter_actor_get_effect ((ClutterActor*) _tmp4_, GALA_MONOCHROME_EFFECT_EFFECT_NAME);
	_data47_->effect = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GALA_TYPE_MONOCHROME_EFFECT, GalaMonochromeEffect);
	_tmp6_ = _data47_->effect;
	if ((_tmp6_ != NULL) == enabled) {
		block47_data_unref (_data47_);
		_data47_ = NULL;
		return;
	}
	_tmp7_ = _data47_->effect;
	if (_tmp7_ != NULL) {
		GalaMonochromeEffect* _tmp8_;
		ClutterActor* _tmp9_;
		ClutterActor* _tmp10_;
		ClutterPropertyTransition* transition = NULL;
		ClutterPropertyTransition* _tmp14_ = NULL;
		ClutterPropertyTransition* _tmp15_;
		GalaMonochromeEffect* _tmp16_;
		gdouble _tmp17_;
		gdouble _tmp18_;
		GValue _tmp19_ = {0};
		ClutterPropertyTransition* _tmp20_;
		GValue _tmp21_ = {0};
		GalaMonochromeEffect* _tmp22_;
		ClutterActor* _tmp23_ = NULL;
		ClutterActor* _tmp24_;
		GalaWindowManager* _tmp25_;
		ClutterActor* _tmp26_;
		ClutterActor* _tmp27_;
		GalaMonochromeEffect* _tmp28_;
		ClutterActor* _tmp29_;
		ClutterActor* _tmp30_;
		GalaMonochromeEffect* _tmp31_;
		ClutterActor* _tmp32_;
		ClutterActor* _tmp33_;
		GalaMonochromeEffect* _tmp34_;
		ClutterPropertyTransition* _tmp35_;
		GalaMonochromeEffect* _tmp36_;
		ClutterActor* _tmp37_;
		ClutterActor* _tmp38_;
		ClutterPropertyTransition* _tmp39_;
		_tmp8_ = _data47_->effect;
		_tmp9_ = gala_monochrome_effect_get_transition_actor (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ != NULL) {
			GalaMonochromeEffect* _tmp11_;
			ClutterActor* _tmp12_;
			ClutterActor* _tmp13_;
			_tmp11_ = _data47_->effect;
			_tmp12_ = gala_monochrome_effect_get_transition_actor (_tmp11_);
			_tmp13_ = _tmp12_;
			clutter_actor_destroy (_tmp13_);
		}
		_tmp14_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale_x");
		clutter_timeline_set_duration ((ClutterTimeline*) _tmp14_, (guint) GALA_FILTER_MANAGER_TRANSITION_DURATION);
		clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp14_, CLUTTER_LINEAR);
		clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp14_, TRUE);
		transition = _tmp14_;
		_tmp15_ = transition;
		_tmp16_ = _data47_->effect;
		_tmp17_ = gala_monochrome_effect_get_strength (_tmp16_);
		_tmp18_ = _tmp17_;
		g_value_init (&_tmp19_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp19_, _tmp18_);
		clutter_transition_set_from_value ((ClutterTransition*) _tmp15_, &_tmp19_);
		G_IS_VALUE (&_tmp19_) ? (g_value_unset (&_tmp19_), NULL) : NULL;
		_tmp20_ = transition;
		g_value_init (&_tmp21_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp21_, 0.0);
		clutter_transition_set_to_value ((ClutterTransition*) _tmp20_, &_tmp21_);
		G_IS_VALUE (&_tmp21_) ? (g_value_unset (&_tmp21_), NULL) : NULL;
		_tmp22_ = _data47_->effect;
		_tmp23_ = clutter_actor_new ();
		g_object_set (_tmp23_, "visible", FALSE, NULL);
		g_object_ref_sink (_tmp23_);
		_tmp24_ = _tmp23_;
		gala_monochrome_effect_set_transition_actor (_tmp22_, _tmp24_);
		_g_object_unref0 (_tmp24_);
		_tmp25_ = self->priv->_wm;
		_tmp26_ = gala_window_manager_get_ui_group (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _data47_->effect;
		_tmp29_ = gala_monochrome_effect_get_transition_actor (_tmp28_);
		_tmp30_ = _tmp29_;
		clutter_actor_add_child (_tmp27_, _tmp30_);
		_tmp31_ = _data47_->effect;
		_tmp32_ = gala_monochrome_effect_get_transition_actor (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = _data47_->effect;
		g_object_bind_property_with_closures ((GObject*) _tmp33_, "scale_x", (GObject*) _tmp34_, "strength", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp35_ = transition;
		g_signal_connect_data ((ClutterTimeline*) _tmp35_, "completed", (GCallback) ____lambda97__clutter_timeline_completed, block47_data_ref (_data47_), (GClosureNotify) block47_data_unref, 0);
		_tmp36_ = _data47_->effect;
		_tmp37_ = gala_monochrome_effect_get_transition_actor (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = transition;
		clutter_actor_add_transition (_tmp38_, GALA_FILTER_MANAGER_TRANSITION_NAME, (ClutterTransition*) _tmp39_);
		_g_object_unref0 (transition);
	}
	if (!enabled) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = strength == 0.0;
	}
	if (_tmp40_) {
		block47_data_unref (_data47_);
		_data47_ = NULL;
		return;
	}
	_tmp41_ = gala_monochrome_effect_new (0.0);
	g_object_ref_sink (_tmp41_);
	_data47_->new_effect = _tmp41_;
	_tmp42_ = self->priv->_wm;
	_tmp43_ = gala_window_manager_get_stage (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = _data47_->new_effect;
	clutter_actor_add_effect_with_name ((ClutterActor*) _tmp44_, GALA_MONOCHROME_EFFECT_EFFECT_NAME, (ClutterEffect*) _tmp45_);
	_tmp46_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale_x");
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp46_, (guint) GALA_FILTER_MANAGER_TRANSITION_DURATION);
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp46_, CLUTTER_LINEAR);
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp46_, TRUE);
	new_transition = _tmp46_;
	_tmp47_ = new_transition;
	g_value_init (&_tmp48_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp48_, 0.0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp47_, &_tmp48_);
	G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
	_tmp49_ = new_transition;
	g_value_init (&_tmp50_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp50_, strength);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp49_, &_tmp50_);
	G_IS_VALUE (&_tmp50_) ? (g_value_unset (&_tmp50_), NULL) : NULL;
	_tmp51_ = _data47_->new_effect;
	_tmp52_ = clutter_actor_new ();
	g_object_set (_tmp52_, "visible", FALSE, NULL);
	g_object_ref_sink (_tmp52_);
	_tmp53_ = _tmp52_;
	gala_monochrome_effect_set_transition_actor (_tmp51_, _tmp53_);
	_g_object_unref0 (_tmp53_);
	_tmp54_ = self->priv->_wm;
	_tmp55_ = gala_window_manager_get_ui_group (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = _data47_->new_effect;
	_tmp58_ = gala_monochrome_effect_get_transition_actor (_tmp57_);
	_tmp59_ = _tmp58_;
	clutter_actor_add_child (_tmp56_, _tmp59_);
	_tmp60_ = _data47_->new_effect;
	_tmp61_ = gala_monochrome_effect_get_transition_actor (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = _data47_->new_effect;
	g_object_bind_property_with_closures ((GObject*) _tmp62_, "scale_x", (GObject*) _tmp63_, "strength", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp64_ = new_transition;
	g_signal_connect_data ((ClutterTimeline*) _tmp64_, "completed", (GCallback) ___lambda98__clutter_timeline_completed, block47_data_ref (_data47_), (GClosureNotify) block47_data_unref, 0);
	_tmp65_ = _data47_->new_effect;
	_tmp66_ = gala_monochrome_effect_get_transition_actor (_tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = new_transition;
	clutter_actor_add_transition (_tmp67_, GALA_FILTER_MANAGER_TRANSITION_NAME, (ClutterTransition*) _tmp68_);
	_g_object_unref0 (new_transition);
	block47_data_unref (_data47_);
	_data47_ = NULL;
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		GalaFilterManager* self;
		self = _data48_->self;
		_g_object_unref0 (self);
		g_slice_free (Block48Data, _data48_);
	}
}

static void
__lambda99_ (Block48Data* _data48_)
{
	GalaFilterManager* self;
	GalaMonochromeEffect* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	self = _data48_->self;
	_tmp0_ = _data48_->effect;
	_tmp1_ = gala_monochrome_effect_get_transition_actor (_tmp0_);
	_tmp2_ = _tmp1_;
	clutter_actor_destroy (_tmp2_);
}

static void
___lambda99__clutter_timeline_completed (ClutterTimeline* _sender,
                                         gpointer self)
{
	__lambda99_ (self);
}

static void
gala_filter_manager_update_monochrome_strength (GalaFilterManager* self)
{
	Block48Data* _data48_;
	gdouble strength = 0.0;
	GSettings* _tmp0_;
	GalaWindowManager* _tmp1_;
	ClutterStage* _tmp2_;
	ClutterStage* _tmp3_;
	ClutterEffect* _tmp4_;
	GalaMonochromeEffect* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterPropertyTransition* transition = NULL;
	ClutterPropertyTransition* _tmp11_ = NULL;
	GalaMonochromeEffect* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	GalaMonochromeEffect* _tmp17_;
	ClutterActor* _tmp18_ = NULL;
	ClutterActor* _tmp19_;
	GalaWindowManager* _tmp20_;
	ClutterActor* _tmp21_;
	ClutterActor* _tmp22_;
	GalaMonochromeEffect* _tmp23_;
	ClutterActor* _tmp24_;
	ClutterActor* _tmp25_;
	GalaMonochromeEffect* _tmp26_;
	ClutterActor* _tmp27_;
	ClutterActor* _tmp28_;
	GalaMonochromeEffect* _tmp29_;
	GalaMonochromeEffect* _tmp30_;
	ClutterActor* _tmp31_;
	ClutterActor* _tmp32_;
	g_return_if_fail (self != NULL);
	_data48_ = g_slice_new0 (Block48Data);
	_data48_->_ref_count_ = 1;
	_data48_->self = g_object_ref (self);
	_tmp0_ = gala_filter_manager_settings;
	strength = g_settings_get_double (_tmp0_, "monochrome-filter-strength");
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_stage (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = clutter_actor_get_effect ((ClutterActor*) _tmp3_, GALA_MONOCHROME_EFFECT_EFFECT_NAME);
	_data48_->effect = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GALA_TYPE_MONOCHROME_EFFECT, GalaMonochromeEffect);
	_tmp5_ = _data48_->effect;
	_tmp6_ = gala_monochrome_effect_get_transition_actor (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GalaMonochromeEffect* _tmp8_;
		ClutterActor* _tmp9_;
		ClutterActor* _tmp10_;
		_tmp8_ = _data48_->effect;
		_tmp9_ = gala_monochrome_effect_get_transition_actor (_tmp8_);
		_tmp10_ = _tmp9_;
		clutter_actor_destroy (_tmp10_);
	}
	_tmp11_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale_x");
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp11_, (guint) GALA_FILTER_MANAGER_TRANSITION_DURATION);
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp11_, CLUTTER_LINEAR);
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp11_, TRUE);
	transition = _tmp11_;
	_tmp12_ = _data48_->effect;
	_tmp13_ = gala_monochrome_effect_get_strength (_tmp12_);
	_tmp14_ = _tmp13_;
	g_value_init (&_tmp15_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp15_, _tmp14_);
	clutter_transition_set_from_value ((ClutterTransition*) transition, &_tmp15_);
	G_IS_VALUE (&_tmp15_) ? (g_value_unset (&_tmp15_), NULL) : NULL;
	g_value_init (&_tmp16_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp16_, strength);
	clutter_transition_set_to_value ((ClutterTransition*) transition, &_tmp16_);
	G_IS_VALUE (&_tmp16_) ? (g_value_unset (&_tmp16_), NULL) : NULL;
	_tmp17_ = _data48_->effect;
	_tmp18_ = clutter_actor_new ();
	g_object_set (_tmp18_, "visible", FALSE, NULL);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gala_monochrome_effect_set_transition_actor (_tmp17_, _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = self->priv->_wm;
	_tmp21_ = gala_window_manager_get_ui_group (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _data48_->effect;
	_tmp24_ = gala_monochrome_effect_get_transition_actor (_tmp23_);
	_tmp25_ = _tmp24_;
	clutter_actor_add_child (_tmp22_, _tmp25_);
	_tmp26_ = _data48_->effect;
	_tmp27_ = gala_monochrome_effect_get_transition_actor (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = _data48_->effect;
	g_object_bind_property_with_closures ((GObject*) _tmp28_, "scale_x", (GObject*) _tmp29_, "strength", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((ClutterTimeline*) transition, "completed", (GCallback) ___lambda99__clutter_timeline_completed, block48_data_ref (_data48_), (GClosureNotify) block48_data_unref, 0);
	_tmp30_ = _data48_->effect;
	_tmp31_ = gala_monochrome_effect_get_transition_actor (_tmp30_);
	_tmp32_ = _tmp31_;
	clutter_actor_add_transition (_tmp32_, GALA_FILTER_MANAGER_TRANSITION_NAME, (ClutterTransition*) transition);
	_g_object_unref0 (transition);
	block48_data_unref (_data48_);
	_data48_ = NULL;
}

GalaWindowManager*
gala_filter_manager_get_wm (GalaFilterManager* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_filter_manager_set_wm (GalaFilterManager* self,
                            GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_filter_manager_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_filter_manager_properties[GALA_FILTER_MANAGER_WM_PROPERTY]);
	}
}

void
gala_filter_manager_set_pause_for_screenshot (GalaFilterManager* self,
                                              gboolean value)
{
	GalaWindowManager* _tmp0_;
	ClutterStage* _tmp1_;
	ClutterStage* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_window_manager_get_stage (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = clutter_actor_get_effects ((ClutterActor*) _tmp2_);
	{
		GList* _effect_collection = NULL;
		GList* _effect_it = NULL;
		_effect_collection = _tmp3_;
		for (_effect_it = _effect_collection; _effect_it != NULL; _effect_it = _effect_it->next) {
			ClutterEffect* _effect = NULL;
			_effect = (ClutterEffect*) _effect_it->data;
			{
				ClutterEffect* _tmp4_;
				_tmp4_ = _effect;
				if (GALA_IS_COLORBLINDNESS_CORRECTION_EFFECT (_tmp4_)) {
					GalaColorblindnessCorrectionEffect* effect = NULL;
					ClutterEffect* _tmp5_;
					GalaColorblindnessCorrectionEffect* _tmp6_;
					_tmp5_ = _effect;
					effect = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GALA_TYPE_COLORBLINDNESS_CORRECTION_EFFECT, GalaColorblindnessCorrectionEffect);
					_tmp6_ = effect;
					gala_colorblindness_correction_effect_set_pause_for_screenshot (_tmp6_, value);
				} else {
					ClutterEffect* _tmp7_;
					_tmp7_ = _effect;
					if (GALA_IS_MONOCHROME_EFFECT (_tmp7_)) {
						GalaMonochromeEffect* effect = NULL;
						ClutterEffect* _tmp8_;
						GalaMonochromeEffect* _tmp9_;
						_tmp8_ = _effect;
						effect = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GALA_TYPE_MONOCHROME_EFFECT, GalaMonochromeEffect);
						_tmp9_ = effect;
						gala_monochrome_effect_set_pause_for_screenshot (_tmp9_, value);
					}
				}
			}
		}
		(_effect_collection == NULL) ? NULL : (_effect_collection = (g_list_free (_effect_collection), NULL));
	}
	g_object_notify_by_pspec ((GObject *) self, gala_filter_manager_properties[GALA_FILTER_MANAGER_PAUSE_FOR_SCREENSHOT_PROPERTY]);
}

static void
_gala_filter_manager_update_colorblindness_filter_g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self)
{
	gala_filter_manager_update_colorblindness_filter ((GalaFilterManager*) self);
}

static void
_gala_filter_manager_update_colorblindness_strength_g_settings_changed (GSettings* _sender,
                                                                        const gchar* key,
                                                                        gpointer self)
{
	gala_filter_manager_update_colorblindness_strength ((GalaFilterManager*) self);
}

static void
_gala_filter_manager_update_monochrome_filter_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	gala_filter_manager_update_monochrome_filter ((GalaFilterManager*) self);
}

static void
_gala_filter_manager_update_monochrome_strength_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self)
{
	gala_filter_manager_update_monochrome_strength ((GalaFilterManager*) self);
}

static GObject *
gala_filter_manager_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaFilterManager * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	parent_class = G_OBJECT_CLASS (gala_filter_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FILTER_MANAGER, GalaFilterManager);
	_tmp0_ = gala_filter_manager_settings;
	g_signal_connect_object (_tmp0_, "changed::colorblindness-correction-filter", (GCallback) _gala_filter_manager_update_colorblindness_filter_g_settings_changed, self, 0);
	_tmp1_ = gala_filter_manager_settings;
	g_signal_connect_object (_tmp1_, "changed::colorblindness-correction-filter-strength", (GCallback) _gala_filter_manager_update_colorblindness_strength_g_settings_changed, self, 0);
	_tmp2_ = gala_filter_manager_settings;
	g_signal_connect_object (_tmp2_, "changed::enable-monochrome-filter", (GCallback) _gala_filter_manager_update_monochrome_filter_g_settings_changed, self, 0);
	_tmp3_ = gala_filter_manager_settings;
	g_signal_connect_object (_tmp3_, "changed::monochrome-filter-strength", (GCallback) _gala_filter_manager_update_monochrome_strength_g_settings_changed, self, 0);
	gala_filter_manager_load_filters (self);
	return obj;
}

static void
gala_filter_manager_class_init (GalaFilterManagerClass * klass,
                                gpointer klass_data)
{
	GSettings* _tmp0_;
	gala_filter_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaFilterManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_filter_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_filter_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_filter_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_filter_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_FILTER_MANAGER_WM_PROPERTY, gala_filter_manager_properties[GALA_FILTER_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_FILTER_MANAGER_PAUSE_FOR_SCREENSHOT_PROPERTY, gala_filter_manager_properties[GALA_FILTER_MANAGER_PAUSE_FOR_SCREENSHOT_PROPERTY] = g_param_spec_boolean ("pause-for-screenshot", "pause-for-screenshot", "pause-for-screenshot", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	_tmp0_ = g_settings_new ("io.elementary.desktop.wm.accessibility");
	_g_object_unref0 (gala_filter_manager_settings);
	gala_filter_manager_settings = _tmp0_;
}

static void
gala_filter_manager_instance_init (GalaFilterManager * self,
                                   gpointer klass)
{
	self->priv = gala_filter_manager_get_instance_private (self);
}

static void
gala_filter_manager_finalize (GObject * obj)
{
	GalaFilterManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FILTER_MANAGER, GalaFilterManager);
	_g_object_unref0 (self->priv->_wm);
	G_OBJECT_CLASS (gala_filter_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_filter_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaFilterManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_filter_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaFilterManager), 0, (GInstanceInitFunc) gala_filter_manager_instance_init, NULL };
	GType gala_filter_manager_type_id;
	gala_filter_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaFilterManager", &g_define_type_info, 0);
	GalaFilterManager_private_offset = g_type_add_instance_private (gala_filter_manager_type_id, sizeof (GalaFilterManagerPrivate));
	return gala_filter_manager_type_id;
}

GType
gala_filter_manager_get_type (void)
{
	static gsize gala_filter_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_filter_manager_type_id__once)) {
		GType gala_filter_manager_type_id;
		gala_filter_manager_type_id = gala_filter_manager_get_type_once ();
		g_once_init_leave (&gala_filter_manager_type_id__once, gala_filter_manager_type_id);
	}
	return gala_filter_manager_type_id__once;
}

static void
_vala_gala_filter_manager_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GalaFilterManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_FILTER_MANAGER, GalaFilterManager);
	switch (property_id) {
		case GALA_FILTER_MANAGER_WM_PROPERTY:
		g_value_set_object (value, gala_filter_manager_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_filter_manager_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GalaFilterManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_FILTER_MANAGER, GalaFilterManager);
	switch (property_id) {
		case GALA_FILTER_MANAGER_WM_PROPERTY:
		gala_filter_manager_set_wm (self, g_value_get_object (value));
		break;
		case GALA_FILTER_MANAGER_PAUSE_FOR_SCREENSHOT_PROPERTY:
		gala_filter_manager_set_pause_for_screenshot (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

