/* ShellClientsManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ShellClientsManager.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <meta/window.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <meta/util.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/meta-wayland-client.h>
#include <meta/meta-x11-display.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <meta/meta-window-actor.h>
#include <float.h>
#include <math.h>
#include <errno.h>
#include <meta/common.h>
#include <mtk/mtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_SHELL_CLIENTS_MANAGER (gala_shell_clients_manager_get_type ())
#define GALA_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager))
#define GALA_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))
#define GALA_IS_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_IS_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_SHELL_CLIENTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))

typedef struct _GalaShellClientsManager GalaShellClientsManager;
typedef struct _GalaShellClientsManagerClass GalaShellClientsManagerClass;
typedef struct _GalaShellClientsManagerPrivate GalaShellClientsManagerPrivate;

#define GALA_TYPE_NOTIFICATIONS_CLIENT (gala_notifications_client_get_type ())
#define GALA_NOTIFICATIONS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_NOTIFICATIONS_CLIENT, GalaNotificationsClient))
#define GALA_NOTIFICATIONS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_NOTIFICATIONS_CLIENT, GalaNotificationsClientClass))
#define GALA_IS_NOTIFICATIONS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_NOTIFICATIONS_CLIENT))
#define GALA_IS_NOTIFICATIONS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_NOTIFICATIONS_CLIENT))
#define GALA_NOTIFICATIONS_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_NOTIFICATIONS_CLIENT, GalaNotificationsClientClass))

typedef struct _GalaNotificationsClient GalaNotificationsClient;
typedef struct _GalaNotificationsClientClass GalaNotificationsClientClass;

#define GALA_TYPE_MANAGED_CLIENT (gala_managed_client_get_type ())
#define GALA_MANAGED_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MANAGED_CLIENT, GalaManagedClient))
#define GALA_MANAGED_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MANAGED_CLIENT, GalaManagedClientClass))
#define GALA_IS_MANAGED_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MANAGED_CLIENT))
#define GALA_IS_MANAGED_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MANAGED_CLIENT))
#define GALA_MANAGED_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MANAGED_CLIENT, GalaManagedClientClass))

typedef struct _GalaManagedClient GalaManagedClient;
typedef struct _GalaManagedClientClass GalaManagedClientClass;

#define GALA_TYPE_POSITIONED_WINDOW (gala_positioned_window_get_type ())
#define GALA_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow))
#define GALA_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))
#define GALA_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))

typedef struct _GalaPositionedWindow GalaPositionedWindow;
typedef struct _GalaPositionedWindowClass GalaPositionedWindowClass;

#define GALA_TYPE_SHELL_WINDOW (gala_shell_window_get_type ())
#define GALA_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindow))
#define GALA_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))
#define GALA_IS_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_WINDOW))
#define GALA_IS_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_WINDOW))
#define GALA_SHELL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))

typedef struct _GalaShellWindow GalaShellWindow;
typedef struct _GalaShellWindowClass GalaShellWindowClass;

#define GALA_TYPE_PANEL_WINDOW (gala_panel_window_get_type ())
#define GALA_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindow))
#define GALA_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))
#define GALA_IS_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PANEL_WINDOW))
#define GALA_IS_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PANEL_WINDOW))
#define GALA_PANEL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))

typedef struct _GalaPanelWindow GalaPanelWindow;
typedef struct _GalaPanelWindowClass GalaPanelWindowClass;
enum  {
	GALA_SHELL_CLIENTS_MANAGER_0_PROPERTY,
	GALA_SHELL_CLIENTS_MANAGER_WM_PROPERTY,
	GALA_SHELL_CLIENTS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_shell_clients_manager_properties[GALA_SHELL_CLIENTS_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _GalaShellClientsManagerStartClientsData GalaShellClientsManagerStartClientsData;
typedef void (*GalaInternalUtilsWindowActorReadyCallback) (MetaWindowActor* window_actor, gpointer user_data);

#define GALA_TYPE_EXTENDED_BEHAVIOR_WINDOW (gala_extended_behavior_window_get_type ())
#define GALA_EXTENDED_BEHAVIOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_EXTENDED_BEHAVIOR_WINDOW, GalaExtendedBehaviorWindow))
#define GALA_EXTENDED_BEHAVIOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_EXTENDED_BEHAVIOR_WINDOW, GalaExtendedBehaviorWindowClass))
#define GALA_IS_EXTENDED_BEHAVIOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_EXTENDED_BEHAVIOR_WINDOW))
#define GALA_IS_EXTENDED_BEHAVIOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_EXTENDED_BEHAVIOR_WINDOW))
#define GALA_EXTENDED_BEHAVIOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_EXTENDED_BEHAVIOR_WINDOW, GalaExtendedBehaviorWindowClass))

typedef struct _GalaExtendedBehaviorWindow GalaExtendedBehaviorWindow;
typedef struct _GalaExtendedBehaviorWindowClass GalaExtendedBehaviorWindowClass;
typedef struct _Block51Data Block51Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaShellClientsManager {
	GObject parent_instance;
	GalaShellClientsManagerPrivate * priv;
};

struct _GalaShellClientsManagerClass {
	GObjectClass parent_class;
};

struct _GalaShellClientsManagerPrivate {
	GalaWindowManager* _wm;
	GalaNotificationsClient* notifications_client;
	GalaManagedClient** protocol_clients;
	gint protocol_clients_length1;
	gint _protocol_clients_size_;
	gint starting_panels;
	GHashTable* panel_windows;
	GHashTable* positioned_windows;
};

struct _GalaShellClientsManagerStartClientsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaShellClientsManager* self;
	const gchar** config_dirs;
	const gchar* _tmp0_;
	const gchar** _tmp1_;
	gint config_dirs_length1;
	gint _config_dirs_size_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** dir_collection;
	gint dir_collection_length1;
	gint _dir_collection_size_;
	gint dir_it;
	const gchar* dir;
	const gchar* _tmp4_;
	gchar* path;
	const gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar** _vala1_dir_collection;
	gint _vala1_dir_collection_length1;
	gint __vala1_dir_collection_size_;
	gint _vala1_dir_it;
	const gchar* _vala1_dir;
	gchar* file_path;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	GFile* file;
	const gchar* _tmp13_;
	GFile* _tmp14_;
	GBytes* bytes;
	GBytes* _tmp15_;
	GFile* _tmp16_;
	GBytes* _tmp17_;
	GBytes* _tmp18_;
	GError* e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GKeyFile* key_file;
	GKeyFile* _tmp21_;
	GKeyFile* _tmp22_;
	GBytes* _tmp23_;
	GError* _vala1_e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GKeyFile* _tmp26_;
	gsize _tmp27_;
	gchar** _tmp28_;
	gchar** group_collection;
	gint group_collection_length1;
	gint _group_collection_size_;
	gint group_it;
	gchar* _tmp29_;
	gchar* group;
	gboolean _tmp30_;
	GKeyFile* _tmp31_;
	const gchar* _tmp32_;
	GError* _vala2_e;
	GError* _tmp33_;
	const gchar* _tmp34_;
	gchar** args;
	GKeyFile* _tmp35_;
	const gchar* _tmp36_;
	gsize _tmp37_;
	gchar** _tmp38_;
	gint args_length1;
	gint _args_size_;
	GalaWindowManager* _tmp39_;
	MetaDisplay* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	GalaManagedClient* _tmp42_;
	GError* _vala3_e;
	const gchar* _tmp43_;
	GError* _tmp44_;
	const gchar* _tmp45_;
	GalaManagedClient** _tmp46_;
	gint _tmp46__length1;
	GError* _inner_error0_;
};

struct _Block51Data {
	int _ref_count_;
	GalaShellClientsManager* self;
	gboolean positioned;
};

static gint GalaShellClientsManager_private_offset;
static gpointer gala_shell_clients_manager_parent_class = NULL;
static GalaShellClientsManager* gala_shell_clients_manager_instance;
static GalaShellClientsManager* gala_shell_clients_manager_instance = NULL;
static GalaGestureTargetIface * gala_shell_clients_manager_gala_gesture_target_parent_iface = NULL;

VALA_EXTERN GType gala_shell_clients_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellClientsManager, g_object_unref)
VALA_EXTERN GType gala_notifications_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaNotificationsClient, g_object_unref)
VALA_EXTERN GType gala_managed_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaManagedClient, g_object_unref)
VALA_EXTERN GType gala_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPositionedWindow, g_object_unref)
VALA_EXTERN GType gala_shell_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellWindow, g_object_unref)
VALA_EXTERN GType gala_panel_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPanelWindow, g_object_unref)
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void gala_shell_clients_manager_init (GalaWindowManager* wm);
static GalaShellClientsManager* gala_shell_clients_manager_new (GalaWindowManager* wm);
static GalaShellClientsManager* gala_shell_clients_manager_construct (GType object_type,
                                                               GalaWindowManager* wm);
VALA_EXTERN GalaShellClientsManager* gala_shell_clients_manager_get_instance (void);
static void gala_shell_clients_manager_start_clients_data_free (gpointer _data);
static void gala_shell_clients_manager_start_clients (GalaShellClientsManager* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void gala_shell_clients_manager_start_clients_finish (GalaShellClientsManager* self,
                                                      GAsyncResult* _res_);
static gboolean gala_shell_clients_manager_start_clients_co (GalaShellClientsManagerStartClientsData* _data_);
static void _vala_array_add13 (const gchar** * array,
                        gint* length,
                        gint* size,
                        const gchar* value);
static void gala_shell_clients_manager_start_clients_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN GalaWindowManager* gala_shell_clients_manager_get_wm (GalaShellClientsManager* self);
VALA_EXTERN GalaManagedClient* gala_managed_client_new (MetaDisplay* display,
                                            gchar** args,
                                            gint args_length1);
VALA_EXTERN GalaManagedClient* gala_managed_client_construct (GType object_type,
                                                  MetaDisplay* display,
                                                  gchar** args,
                                                  gint args_length1);
static void _vala_array_add14 (GalaManagedClient** * array,
                        gint* length,
                        gint* size,
                        GalaManagedClient* value);
static void gala_shell_clients_manager_on_failsafe_timeout (GalaShellClientsManager* self);
VALA_EXTERN void gala_panel_window_animate_start (GalaPanelWindow* self);
VALA_EXTERN void gala_shell_clients_manager_make_dock (GalaShellClientsManager* self,
                                           MetaWindow* window);
static void gala_shell_clients_manager_make_dock_wayland (GalaShellClientsManager* self,
                                                   MetaWindow* window);
static void gala_shell_clients_manager_make_dock_x11 (GalaShellClientsManager* self,
                                               MetaWindow* window);
VALA_EXTERN MetaWaylandClient* gala_managed_client_get_wayland_client (GalaManagedClient* self);
VALA_EXTERN void gala_shell_clients_manager_set_anchor (GalaShellClientsManager* self,
                                            MetaWindow* window,
                                            enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN void gala_panel_window_set_anchor (GalaPanelWindow* self,
                                   enum io_elementary_pantheon_panel_v1_anchor value);
VALA_EXTERN GalaPanelWindow* gala_panel_window_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN GalaPanelWindow* gala_panel_window_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor_visible (MetaWindow* window,
                                                        GalaInternalUtilsWindowActorReadyCallback callback,
                                                        gpointer callback_target,
                                                        GDestroyNotify callback_target_destroy_notify);
static void gala_shell_clients_manager_on_panel_ready (GalaShellClientsManager* self,
                                                MetaWindowActor* actor);
static void _gala_shell_clients_manager_on_panel_ready_gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                                                 gpointer self);
static void __lambda23_ (GalaShellClientsManager* self,
                  MetaWindow* _window);
static void ___lambda23__meta_window_unmanaging (MetaWindow* _sender,
                                          gpointer self);
VALA_EXTERN void gala_shell_clients_manager_set_size (GalaShellClientsManager* self,
                                          MetaWindow* window,
                                          gint width,
                                          gint height);
VALA_EXTERN void gala_panel_window_set_size (GalaPanelWindow* self,
                                 gint width,
                                 gint height);
VALA_EXTERN void gala_shell_clients_manager_set_hide_mode (GalaShellClientsManager* self,
                                               MetaWindow* window,
                                               enum io_elementary_pantheon_panel_v1_hide_mode hide_mode);
VALA_EXTERN void gala_panel_window_set_hide_mode (GalaPanelWindow* self,
                                      enum io_elementary_pantheon_panel_v1_hide_mode value);
VALA_EXTERN void gala_shell_clients_manager_request_visible_in_multitasking_view (GalaShellClientsManager* self,
                                                                      MetaWindow* window);
VALA_EXTERN void gala_panel_window_request_visible_in_multitasking_view (GalaPanelWindow* self);
VALA_EXTERN void gala_shell_clients_manager_make_centered (GalaShellClientsManager* self,
                                               MetaWindow* window);
VALA_EXTERN gboolean gala_shell_clients_manager_is_itself_positioned (GalaShellClientsManager* self,
                                                          MetaWindow* window);
VALA_EXTERN GalaExtendedBehaviorWindow* gala_extended_behavior_window_new (MetaWindow* window);
VALA_EXTERN GalaExtendedBehaviorWindow* gala_extended_behavior_window_construct (GType object_type,
                                                                     MetaWindow* window);
VALA_EXTERN GType gala_extended_behavior_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaExtendedBehaviorWindow, g_object_unref)
static void __lambda24_ (GalaShellClientsManager* self,
                  MetaWindow* _window);
static void ___lambda24__meta_window_unmanaging (MetaWindow* _sender,
                                          gpointer self);
static void gala_shell_clients_manager_real_propagate (GalaGestureTarget* base,
                                                GalaGestureTargetUpdateType update_type,
                                                GalaGestureAction action,
                                                gdouble progress);
VALA_EXTERN void gala_shell_window_propagate (GalaShellWindow* self,
                                  GalaGestureTargetUpdateType update_type,
                                  GalaGestureAction action,
                                  gdouble progress);
VALA_EXTERN gboolean gala_notification_stack_is_notification (MetaWindow* window);
VALA_EXTERN gboolean gala_shell_clients_manager_is_positioned_window (GalaShellClientsManager* self,
                                                          MetaWindow* window);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static gboolean __lambda25_ (Block51Data* _data51_,
                      MetaWindow* ancestor);
static gboolean ___lambda25__meta_window_foreach_func (MetaWindow* window,
                                                gpointer self);
static void gala_shell_clients_manager_parse_mutter_hints (GalaShellClientsManager* self,
                                                    MetaWindow* window);
static void gala_shell_clients_manager_set_restore_previous_x11_region (GalaShellClientsManager* self,
                                                                 MetaWindow* window);
VALA_EXTERN void gala_shell_window_set_restore_previous_x11_region (GalaShellWindow* self,
                                                        gboolean value);
VALA_EXTERN MtkRectangle* gala_shell_clients_manager_get_shell_client_rect (GalaShellClientsManager* self);
VALA_EXTERN gboolean gala_panel_window_get_visible_in_multitasking_view (GalaPanelWindow* self);
VALA_EXTERN void gala_panel_window_get_custom_window_rect (GalaPanelWindow* self,
                                               MtkRectangle* result);
static MtkRectangle* _vala_MtkRectangle_copy (MtkRectangle* self);
static void gala_shell_clients_manager_set_wm (GalaShellClientsManager* self,
                                        GalaWindowManager* value);
static GObject * gala_shell_clients_manager_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
VALA_EXTERN GalaNotificationsClient* gala_notifications_client_new (MetaDisplay* display);
VALA_EXTERN GalaNotificationsClient* gala_notifications_client_construct (GType object_type,
                                                              MetaDisplay* display);
static void _gala_shell_clients_manager____lambda26_ (GalaShellClientsManager* self,
                                               MetaWindow* window);
static void __lambda27_ (GalaShellClientsManager* self,
                  GObject* obj,
                  GParamSpec* pspec);
static void ___lambda27__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __gala_shell_clients_manager____lambda26__meta_display_window_created (MetaDisplay* _sender,
                                                                            MetaWindow* object,
                                                                            gpointer self);
static void _gala_shell_clients_manager_on_failsafe_timeout_gsource_once_func (gpointer self);
static void gala_shell_clients_manager_finalize (GObject * obj);
static GType gala_shell_clients_manager_get_type_once (void);
static void _vala_gala_shell_clients_manager_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_gala_shell_clients_manager_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
gala_shell_clients_manager_get_instance_private (GalaShellClientsManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaShellClientsManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

void
gala_shell_clients_manager_init (GalaWindowManager* wm)
{
	GalaShellClientsManager* _tmp0_;
	GalaShellClientsManager* _tmp1_;
	g_return_if_fail (wm != NULL);
	_tmp0_ = gala_shell_clients_manager_instance;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = gala_shell_clients_manager_new (wm);
	_g_object_unref0 (gala_shell_clients_manager_instance);
	gala_shell_clients_manager_instance = _tmp1_;
}

GalaShellClientsManager*
gala_shell_clients_manager_get_instance (void)
{
	GalaShellClientsManager* _tmp0_;
	GalaShellClientsManager* result;
	_tmp0_ = gala_shell_clients_manager_instance;
	result = _tmp0_;
	return result;
}

static GalaShellClientsManager*
gala_shell_clients_manager_construct (GType object_type,
                                      GalaWindowManager* wm)
{
	GalaShellClientsManager * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaShellClientsManager*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

static GalaShellClientsManager*
gala_shell_clients_manager_new (GalaWindowManager* wm)
{
	return gala_shell_clients_manager_construct (GALA_TYPE_SHELL_CLIENTS_MANAGER, wm);
}

static void
gala_shell_clients_manager_start_clients_data_free (gpointer _data)
{
	GalaShellClientsManagerStartClientsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaShellClientsManagerStartClientsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_shell_clients_manager_start_clients (GalaShellClientsManager* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GalaShellClientsManagerStartClientsData* _data_;
	GalaShellClientsManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaShellClientsManagerStartClientsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_shell_clients_manager_start_clients_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gala_shell_clients_manager_start_clients_co (_data_);
}

static void
gala_shell_clients_manager_start_clients_finish (GalaShellClientsManager* self,
                                                 GAsyncResult* _res_)
{
	GalaShellClientsManagerStartClientsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_vala_array_add13 (const gchar** * array,
                   gint* length,
                   gint* size,
                   const gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (const gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
gala_shell_clients_manager_start_clients_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GalaShellClientsManagerStartClientsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_shell_clients_manager_start_clients_co (_data_);
}

static void
_vala_array_add14 (GalaManagedClient** * array,
                   gint* length,
                   gint* size,
                   GalaManagedClient* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GalaManagedClient*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
gala_shell_clients_manager_start_clients_co (GalaShellClientsManagerStartClientsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_get_user_config_dir ();
	_data_->_tmp1_ = g_new0 (const gchar*, 1 + 1);
	_data_->_tmp1_[0] = _data_->_tmp0_;
	_data_->config_dirs = _data_->_tmp1_;
	_data_->config_dirs_length1 = 1;
	_data_->_config_dirs_size_ = _data_->config_dirs_length1;
	_data_->_tmp3_ = _data_->_tmp2_ = g_get_system_config_dirs ();
	{
		_data_->dir_collection_length1 = 0;
		_data_->_dir_collection_size_ = 0;
		_data_->dir_collection = _data_->_tmp3_;
		_data_->dir_collection_length1 = _vala_array_length (_data_->_tmp2_);
		for (_data_->dir_it = 0; _data_->dir_it < _data_->dir_collection_length1; _data_->dir_it = _data_->dir_it + 1) {
			_data_->dir = _data_->dir_collection[_data_->dir_it];
			{
				_data_->_tmp4_ = _data_->dir;
				_vala_array_add13 (&_data_->config_dirs, &_data_->config_dirs_length1, &_data_->_config_dirs_size_, _data_->_tmp4_);
			}
		}
	}
	_data_->path = NULL;
	_data_->_tmp5_ = _data_->config_dirs;
	_data_->_tmp5__length1 = _data_->config_dirs_length1;
	{
		_data_->_vala1_dir_collection_length1 = 0;
		_data_->__vala1_dir_collection_size_ = 0;
		_data_->_vala1_dir_collection = _data_->_tmp5_;
		_data_->_vala1_dir_collection_length1 = _data_->_tmp5__length1;
		for (_data_->_vala1_dir_it = 0; _data_->_vala1_dir_it < _data_->_vala1_dir_collection_length1; _data_->_vala1_dir_it = _data_->_vala1_dir_it + 1) {
			_data_->_vala1_dir = _data_->_vala1_dir_collection[_data_->_vala1_dir_it];
			{
				_data_->_tmp6_ = _data_->_vala1_dir;
				_data_->_tmp7_ = g_build_filename (_data_->_tmp6_, "io.elementary.desktop.wm.shell", NULL);
				_data_->file_path = _data_->_tmp7_;
				_data_->_tmp8_ = _data_->file_path;
				g_warning ("ShellClientsManager.vala:62: %s", _data_->_tmp8_);
				_data_->_tmp9_ = _data_->file_path;
				if (g_file_test (_data_->_tmp9_, G_FILE_TEST_EXISTS)) {
					_data_->_tmp10_ = _data_->file_path;
					_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
					_g_free0 (_data_->path);
					_data_->path = _data_->_tmp11_;
					_g_free0 (_data_->file_path);
					break;
				}
				_g_free0 (_data_->file_path);
			}
		}
	}
	_data_->_tmp12_ = _data_->path;
	if (_data_->_tmp12_ == NULL) {
		g_warning ("ShellClientsManager.vala:70: No shell config file found.");
		_g_free0 (_data_->path);
		_data_->config_dirs = (g_free (_data_->config_dirs), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->path;
	_data_->_tmp14_ = g_file_new_for_path (_data_->_tmp13_);
	_data_->file = _data_->_tmp14_;
	{
		_data_->_tmp16_ = _data_->file;
		_data_->_state_ = 1;
		g_file_load_bytes_async (_data_->_tmp16_, NULL, gala_shell_clients_manager_start_clients_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp17_ = g_file_load_bytes_finish (_data_->_tmp16_, _data_->_res_, NULL, &_data_->_inner_error0_);
		_data_->_tmp15_ = _data_->_tmp17_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp18_ = _data_->_tmp15_;
		_data_->_tmp15_ = NULL;
		_g_bytes_unref0 (_data_->bytes);
		_data_->bytes = _data_->_tmp18_;
		_g_bytes_unref0 (_data_->_tmp15_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->e;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning ("ShellClientsManager.vala:80: Failed to load shell config file: %s", _data_->_tmp20_);
		_g_error_free0 (_data_->e);
		_g_bytes_unref0 (_data_->bytes);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->path);
		_data_->config_dirs = (g_free (_data_->config_dirs), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_bytes_unref0 (_data_->bytes);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->path);
		_data_->config_dirs = (g_free (_data_->config_dirs), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = g_key_file_new ();
	_data_->key_file = _data_->_tmp21_;
	{
		_data_->_tmp22_ = _data_->key_file;
		_data_->_tmp23_ = _data_->bytes;
		g_key_file_load_from_bytes (_data_->_tmp22_, _data_->_tmp23_, G_KEY_FILE_NONE, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp24_ = _data_->_vala1_e;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_warning ("ShellClientsManager.vala:88: Failed to parse shell config file: %s", _data_->_tmp25_);
		_g_error_free0 (_data_->_vala1_e);
		_g_key_file_unref0 (_data_->key_file);
		_g_bytes_unref0 (_data_->bytes);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->path);
		_data_->config_dirs = (g_free (_data_->config_dirs), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_key_file_unref0 (_data_->key_file);
		_g_bytes_unref0 (_data_->bytes);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->path);
		_data_->config_dirs = (g_free (_data_->config_dirs), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp26_ = _data_->key_file;
	_data_->_tmp27_ = 0;
	_data_->_tmp28_ = g_key_file_get_groups (_data_->_tmp26_, &_data_->_tmp27_);
	{
		_data_->group_collection_length1 = 0;
		_data_->_group_collection_size_ = 0;
		_data_->group_collection = _data_->_tmp28_;
		_data_->group_collection_length1 = _data_->_tmp27_;
		for (_data_->group_it = 0; _data_->group_it < _data_->group_collection_length1; _data_->group_it = _data_->group_it + 1) {
			_data_->_tmp29_ = g_strdup (_data_->group_collection[_data_->group_it]);
			_data_->group = _data_->_tmp29_;
			{
				if (!meta_is_wayland_compositor ()) {
					{
						_data_->_tmp31_ = _data_->key_file;
						_data_->_tmp32_ = _data_->group;
						_data_->_tmp30_ = g_key_file_get_boolean (_data_->_tmp31_, _data_->_tmp32_, "launch-on-x", &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
						if (!_data_->_tmp30_) {
							_g_free0 (_data_->group);
							continue;
						}
					}
					goto __finally2;
					__catch2_g_error:
					{
						_data_->_vala2_e = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp33_ = _data_->_vala2_e;
						_data_->_tmp34_ = _data_->_tmp33_->message;
						g_warning ("ShellClientsManager.vala:99: Failed to check whether client should be " \
"launched on x, assuming yes: %s", _data_->_tmp34_);
						_g_error_free0 (_data_->_vala2_e);
					}
					__finally2:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_free0 (_data_->group);
						_data_->group_collection = (_vala_array_free (_data_->group_collection, _data_->group_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (_data_->key_file);
						_g_bytes_unref0 (_data_->bytes);
						_g_object_unref0 (_data_->file);
						_g_free0 (_data_->path);
						_data_->config_dirs = (g_free (_data_->config_dirs), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				{
					_data_->_tmp35_ = _data_->key_file;
					_data_->_tmp36_ = _data_->group;
					_data_->_tmp37_ = 0;
					_data_->_tmp38_ = g_key_file_get_string_list (_data_->_tmp35_, _data_->_tmp36_, "args", &_data_->_tmp37_, &_data_->_inner_error0_);
					_data_->args = _data_->_tmp38_;
					_data_->args_length1 = _data_->_tmp37_;
					_data_->_args_size_ = _data_->args_length1;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch3_g_error;
					}
					_data_->_tmp39_ = _data_->self->priv->_wm;
					_data_->_tmp40_ = meta_plugin_get_display ((MetaPlugin*) _data_->_tmp39_);
					_data_->_tmp41_ = _data_->args;
					_data_->_tmp41__length1 = _data_->args_length1;
					_data_->_tmp42_ = gala_managed_client_new (_data_->_tmp40_, _data_->_tmp41_, _data_->_tmp41__length1);
					_vala_array_add14 (&_data_->self->priv->protocol_clients, &_data_->self->priv->protocol_clients_length1, &_data_->self->priv->_protocol_clients_size_, _data_->_tmp42_);
					_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				}
				goto __finally3;
				__catch3_g_error:
				{
					_data_->_vala3_e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp43_ = _data_->group;
					_data_->_tmp44_ = _data_->_vala3_e;
					_data_->_tmp45_ = _data_->_tmp44_->message;
					g_warning ("ShellClientsManager.vala:107: Failed to load launch args for client %s" \
": %s", _data_->_tmp43_, _data_->_tmp45_);
					_g_error_free0 (_data_->_vala3_e);
				}
				__finally3:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_free0 (_data_->group);
					_data_->group_collection = (_vala_array_free (_data_->group_collection, _data_->group_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_unref0 (_data_->key_file);
					_g_bytes_unref0 (_data_->bytes);
					_g_object_unref0 (_data_->file);
					_g_free0 (_data_->path);
					_data_->config_dirs = (g_free (_data_->config_dirs), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_free0 (_data_->group);
			}
		}
		_data_->group_collection = (_vala_array_free (_data_->group_collection, _data_->group_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_data_->_tmp46_ = _data_->self->priv->protocol_clients;
	_data_->_tmp46__length1 = _data_->self->priv->protocol_clients_length1;
	_data_->self->priv->starting_panels = _data_->_tmp46__length1;
	_g_key_file_unref0 (_data_->key_file);
	_g_bytes_unref0 (_data_->bytes);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->path);
	_data_->config_dirs = (g_free (_data_->config_dirs), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gala_shell_clients_manager_on_failsafe_timeout (GalaShellClientsManager* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->starting_panels > 0) {
		GHashTable* _tmp0_;
		GList* _tmp1_;
		g_warning ("ShellClientsManager.vala:116: %d panels failed to start in time, showi" \
"ng the others", self->priv->starting_panels);
		self->priv->starting_panels = 0;
		_tmp0_ = self->priv->panel_windows;
		_tmp1_ = g_hash_table_get_values (_tmp0_);
		{
			GList* window_collection = NULL;
			GList* window_it = NULL;
			window_collection = _tmp1_;
			for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
				GalaPanelWindow* window = NULL;
				window = (GalaPanelWindow*) window_it->data;
				{
					GalaPanelWindow* _tmp2_;
					_tmp2_ = window;
					gala_panel_window_animate_start (_tmp2_);
				}
			}
			(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
		}
	}
}

void
gala_shell_clients_manager_make_dock (GalaShellClientsManager* self,
                                      MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (meta_is_wayland_compositor ()) {
		gala_shell_clients_manager_make_dock_wayland (self, window);
	} else {
		gala_shell_clients_manager_make_dock_x11 (self, window);
	}
}

static void
gala_shell_clients_manager_make_dock_wayland (GalaShellClientsManager* self,
                                              MetaWindow* window)
{
	GalaManagedClient** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (meta_is_wayland_compositor (), "Meta.Util.is_wayland_compositor ()");
	_tmp0_ = self->priv->protocol_clients;
	_tmp0__length1 = self->priv->protocol_clients_length1;
	{
		GalaManagedClient** client_collection = NULL;
		gint client_collection_length1 = 0;
		gint _client_collection_size_ = 0;
		gint client_it = 0;
		client_collection = _tmp0_;
		client_collection_length1 = _tmp0__length1;
		for (client_it = 0; client_it < client_collection_length1; client_it = client_it + 1) {
			GalaManagedClient* _tmp1_;
			GalaManagedClient* client = NULL;
			_tmp1_ = _g_object_ref0 (client_collection[client_it]);
			client = _tmp1_;
			{
				GalaManagedClient* _tmp2_;
				MetaWaylandClient* _tmp3_;
				MetaWaylandClient* _tmp4_;
				_tmp2_ = client;
				_tmp3_ = gala_managed_client_get_wayland_client (_tmp2_);
				_tmp4_ = _tmp3_;
				if (meta_wayland_client_owns_window (_tmp4_, window)) {
					GalaManagedClient* _tmp5_;
					MetaWaylandClient* _tmp6_;
					MetaWaylandClient* _tmp7_;
					_tmp5_ = client;
					_tmp6_ = gala_managed_client_get_wayland_client (_tmp5_);
					_tmp7_ = _tmp6_;
					meta_wayland_client_make_dock (_tmp7_, window);
					_g_object_unref0 (client);
					break;
				}
				_g_object_unref0 (client);
			}
		}
	}
}

static void
gala_shell_clients_manager_make_dock_x11 (GalaShellClientsManager* self,
                                          MetaWindow* window)
{
	MetaX11Display* x11_display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaX11Display* _tmp2_;
	Window x_window = 0;
	Display* xdisplay = NULL;
	Display* _tmp3_;
	Atom atom = {0};
	Atom dock_atom = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!meta_is_wayland_compositor (), "!Meta.Util.is_wayland_compositor ()");
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_x11_display (_tmp1_);
	x11_display = _tmp2_;
	x_window = meta_x11_display_lookup_xwindow (x11_display, window);
	_tmp3_ = meta_x11_display_get_xdisplay (x11_display);
	xdisplay = _tmp3_;
	atom = XInternAtom (xdisplay, "_NET_WM_WINDOW_TYPE", FALSE);
	dock_atom = XInternAtom (xdisplay, "_NET_WM_WINDOW_TYPE_DOCK", FALSE);
	XChangeProperty (xdisplay, x_window, atom, (Atom) 4, 32, 0, (guchar*) (&dock_atom), 1);
}

static void
_gala_shell_clients_manager_on_panel_ready_gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                                            gpointer self)
{
	gala_shell_clients_manager_on_panel_ready ((GalaShellClientsManager*) self, window_actor);
}

static void
__lambda23_ (GalaShellClientsManager* self,
             MetaWindow* _window)
{
	GHashTable* _tmp0_;
	g_return_if_fail (_window != NULL);
	_tmp0_ = self->priv->panel_windows;
	g_hash_table_remove (_tmp0_, _window);
}

static void
___lambda23__meta_window_unmanaging (MetaWindow* _sender,
                                     gpointer self)
{
	__lambda23_ ((GalaShellClientsManager*) self, _sender);
}

void
gala_shell_clients_manager_set_anchor (GalaShellClientsManager* self,
                                       MetaWindow* window,
                                       enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp3_;
	MetaWindow* _tmp4_;
	GalaWindowManager* _tmp5_;
	GalaPanelWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->panel_windows;
	if (g_hash_table_contains (_tmp0_, window)) {
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->panel_windows;
		_tmp2_ = g_hash_table_lookup (_tmp1_, window);
		gala_panel_window_set_anchor ((GalaPanelWindow*) _tmp2_, anchor);
		return;
	}
	gala_shell_clients_manager_make_dock (self, window);
	_tmp3_ = self->priv->panel_windows;
	_tmp4_ = _g_object_ref0 (window);
	_tmp5_ = self->priv->_wm;
	_tmp6_ = gala_panel_window_new (_tmp5_, window, anchor);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp6_);
	gala_internal_utils_wait_for_window_actor_visible (window, _gala_shell_clients_manager_on_panel_ready_gala_internal_utils_window_actor_ready_callback, g_object_ref (self), g_object_unref);
	g_signal_connect_object (window, "unmanaging", (GCallback) ___lambda23__meta_window_unmanaging, self, G_CONNECT_AFTER);
}

static void
gala_shell_clients_manager_on_panel_ready (GalaShellClientsManager* self,
                                           MetaWindowActor* actor)
{
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	if (self->priv->starting_panels == 0) {
		GHashTable* _tmp0_;
		MetaWindow* _tmp1_;
		MetaWindow* _tmp2_;
		gconstpointer _tmp3_;
		_tmp0_ = self->priv->panel_windows;
		_tmp1_ = meta_window_actor_get_meta_window (actor);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
		gala_panel_window_animate_start ((GalaPanelWindow*) _tmp3_);
		return;
	}
	_tmp4_ = self->priv->starting_panels;
	self->priv->starting_panels = _tmp4_ - 1;
	_vala_assert (self->priv->starting_panels >= 0, "starting_panels >= 0");
	if (self->priv->starting_panels == 0) {
		GHashTable* _tmp5_;
		GList* _tmp6_;
		_tmp5_ = self->priv->panel_windows;
		_tmp6_ = g_hash_table_get_values (_tmp5_);
		{
			GList* window_collection = NULL;
			GList* window_it = NULL;
			window_collection = _tmp6_;
			for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
				GalaPanelWindow* window = NULL;
				window = (GalaPanelWindow*) window_it->data;
				{
					GalaPanelWindow* _tmp7_;
					_tmp7_ = window;
					gala_panel_window_animate_start (_tmp7_);
				}
			}
			(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
		}
	}
}

/**
     * The size given here is only used for the hide mode. I.e. struts
     * and collision detection with other windows use this size. By default
     * or if set to -1 the size of the window is used.
     *
     * TODO: Maybe use for strut only?
     */
void
gala_shell_clients_manager_set_size (GalaShellClientsManager* self,
                                     MetaWindow* window,
                                     gint width,
                                     gint height)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->panel_windows;
	if (!g_hash_table_contains (_tmp0_, window)) {
		g_warning ("ShellClientsManager.vala:211: Set anchor for window before size.");
		return;
	}
	_tmp1_ = self->priv->panel_windows;
	_tmp2_ = g_hash_table_lookup (_tmp1_, window);
	gala_panel_window_set_size ((GalaPanelWindow*) _tmp2_, width, height);
}

void
gala_shell_clients_manager_set_hide_mode (GalaShellClientsManager* self,
                                          MetaWindow* window,
                                          enum io_elementary_pantheon_panel_v1_hide_mode hide_mode)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->panel_windows;
	if (!g_hash_table_contains (_tmp0_, window)) {
		g_warning ("ShellClientsManager.vala:220: Set anchor for window before hide mode.");
		return;
	}
	_tmp1_ = self->priv->panel_windows;
	_tmp2_ = g_hash_table_lookup (_tmp1_, window);
	gala_panel_window_set_hide_mode ((GalaPanelWindow*) _tmp2_, hide_mode);
}

void
gala_shell_clients_manager_request_visible_in_multitasking_view (GalaShellClientsManager* self,
                                                                 MetaWindow* window)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->panel_windows;
	if (!g_hash_table_contains (_tmp0_, window)) {
		g_warning ("ShellClientsManager.vala:229: Set anchor for window before visible in " \
"mutltiasking view.");
		return;
	}
	_tmp1_ = self->priv->panel_windows;
	_tmp2_ = g_hash_table_lookup (_tmp1_, window);
	gala_panel_window_request_visible_in_multitasking_view ((GalaPanelWindow*) _tmp2_);
}

static void
__lambda24_ (GalaShellClientsManager* self,
             MetaWindow* _window)
{
	GHashTable* _tmp0_;
	g_return_if_fail (_window != NULL);
	_tmp0_ = self->priv->positioned_windows;
	g_hash_table_remove (_tmp0_, _window);
}

static void
___lambda24__meta_window_unmanaging (MetaWindow* _sender,
                                     gpointer self)
{
	__lambda24_ ((GalaShellClientsManager*) self, _sender);
}

void
gala_shell_clients_manager_make_centered (GalaShellClientsManager* self,
                                          MetaWindow* window)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	GalaExtendedBehaviorWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!gala_shell_clients_manager_is_itself_positioned (self, window), "!is_itself_positioned (window)");
	_tmp0_ = self->priv->positioned_windows;
	_tmp1_ = _g_object_ref0 (window);
	_tmp2_ = gala_extended_behavior_window_new (window);
	g_hash_table_insert (_tmp0_, _tmp1_, (GalaShellWindow*) _tmp2_);
	g_signal_connect_object (window, "unmanaging", (GCallback) ___lambda24__meta_window_unmanaging, self, G_CONNECT_AFTER);
}

static void
gala_shell_clients_manager_real_propagate (GalaGestureTarget* base,
                                           GalaGestureTargetUpdateType update_type,
                                           GalaGestureAction action,
                                           gdouble progress)
{
	GalaShellClientsManager * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	self = (GalaShellClientsManager*) base;
	_tmp0_ = self->priv->positioned_windows;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GalaShellWindow* window = NULL;
			window = (GalaShellWindow*) window_it->data;
			{
				GalaShellWindow* _tmp2_;
				_tmp2_ = window;
				gala_shell_window_propagate (_tmp2_, update_type, action, progress);
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	_tmp3_ = self->priv->panel_windows;
	_tmp4_ = g_hash_table_get_values (_tmp3_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp4_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GalaPanelWindow* window = NULL;
			window = (GalaPanelWindow*) window_it->data;
			{
				GalaPanelWindow* _tmp5_;
				_tmp5_ = window;
				gala_shell_window_propagate ((GalaShellWindow*) _tmp5_, update_type, action, progress);
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
}

gboolean
gala_shell_clients_manager_is_itself_positioned (GalaShellClientsManager* self,
                                                 MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GHashTable* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	_tmp2_ = self->priv->positioned_windows;
	if (g_hash_table_contains (_tmp2_, window)) {
		_tmp1_ = TRUE;
	} else {
		GHashTable* _tmp3_;
		_tmp3_ = self->priv->panel_windows;
		_tmp1_ = g_hash_table_contains (_tmp3_, window);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gala_notification_stack_is_notification (window);
	}
	result = _tmp0_;
	return result;
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		GalaShellClientsManager* self;
		self = _data51_->self;
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}

static gboolean
__lambda25_ (Block51Data* _data51_,
             MetaWindow* ancestor)
{
	GalaShellClientsManager* self;
	gboolean result;
	self = _data51_->self;
	g_return_val_if_fail (ancestor != NULL, FALSE);
	if (gala_shell_clients_manager_is_itself_positioned (self, ancestor)) {
		_data51_->positioned = TRUE;
	}
	result = !_data51_->positioned;
	return result;
}

static gboolean
___lambda25__meta_window_foreach_func (MetaWindow* window,
                                       gpointer self)
{
	gboolean result;
	result = __lambda25_ (self, window);
	return result;
}

gboolean
gala_shell_clients_manager_is_positioned_window (GalaShellClientsManager* self,
                                                 MetaWindow* window)
{
	Block51Data* _data51_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_data51_->positioned = gala_shell_clients_manager_is_itself_positioned (self, window);
	meta_window_foreach_ancestor (window, ___lambda25__meta_window_foreach_func, _data51_);
	result = _data51_->positioned;
	block51_data_unref (_data51_);
	_data51_ = NULL;
	return result;
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
gala_shell_clients_manager_parse_mutter_hints (GalaShellClientsManager* self,
                                               MetaWindow* window)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** mutter_hints = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint mutter_hints_length1;
	gint _mutter_hints_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!meta_is_wayland_compositor (), "!Meta.Util.is_wayland_compositor ()");
	_tmp0_ = meta_window_get_mutter_hints (window);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = meta_window_get_mutter_hints (window);
	_tmp3_ = _tmp2_;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
	mutter_hints = _tmp5_;
	mutter_hints_length1 = _vala_array_length (_tmp4_);
	_mutter_hints_size_ = mutter_hints_length1;
	_tmp6_ = mutter_hints;
	_tmp6__length1 = mutter_hints_length1;
	{
		gchar** mutter_hint_collection = NULL;
		gint mutter_hint_collection_length1 = 0;
		gint _mutter_hint_collection_size_ = 0;
		gint mutter_hint_it = 0;
		mutter_hint_collection = _tmp6_;
		mutter_hint_collection_length1 = _tmp6__length1;
		for (mutter_hint_it = 0; mutter_hint_it < mutter_hint_collection_length1; mutter_hint_it = mutter_hint_it + 1) {
			gchar* _tmp7_;
			gchar* mutter_hint = NULL;
			_tmp7_ = g_strdup (mutter_hint_collection[mutter_hint_it]);
			mutter_hint = _tmp7_;
			{
				gchar** split = NULL;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gchar** _tmp10_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar* key = NULL;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* val = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GQuark _tmp21_ = 0U;
				static GQuark _tmp20_label0 = 0;
				static GQuark _tmp20_label1 = 0;
				static GQuark _tmp20_label2 = 0;
				static GQuark _tmp20_label3 = 0;
				static GQuark _tmp20_label4 = 0;
				static GQuark _tmp20_label5 = 0;
				_tmp8_ = mutter_hint;
				_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 0);
				split = _tmp10_;
				split_length1 = _vala_array_length (_tmp9_);
				_split_size_ = split_length1;
				_tmp11_ = split;
				_tmp11__length1 = split_length1;
				if (_tmp11__length1 != 2) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (mutter_hint);
					continue;
				}
				_tmp12_ = split;
				_tmp12__length1 = split_length1;
				_tmp13_ = _tmp12_[0];
				_tmp14_ = g_strdup (_tmp13_);
				key = _tmp14_;
				_tmp15_ = split;
				_tmp15__length1 = split_length1;
				_tmp16_ = _tmp15_[1];
				_tmp17_ = g_strdup (_tmp16_);
				val = _tmp17_;
				_tmp18_ = key;
				_tmp19_ = _tmp18_;
				_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
				if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("anchor")))) {
					switch (0) {
						default:
						{
							gint meta_side_parsed = 0;
							gboolean _tmp22_ = FALSE;
							gboolean _tmp23_ = FALSE;
							const gchar* _tmp24_;
							gint _tmp25_ = 0;
							gboolean _tmp26_;
							_tmp24_ = val;
							_tmp26_ = int_try_parse (_tmp24_, &_tmp25_, NULL, (guint) 0);
							meta_side_parsed = _tmp25_;
							if (_tmp26_) {
								_tmp23_ = 0 <= meta_side_parsed;
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								_tmp22_ = meta_side_parsed <= 15;
							} else {
								_tmp22_ = FALSE;
							}
							if (_tmp22_) {
								enum io_elementary_pantheon_panel_v1_anchor parsed = 0;
								parsed = IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP;
								switch ((MetaSide) meta_side_parsed) {
									case META_SIDE_BOTTOM:
									{
										parsed = IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM;
										break;
									}
									case META_SIDE_LEFT:
									{
										parsed = IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT;
										break;
									}
									case META_SIDE_RIGHT:
									{
										parsed = IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT;
										break;
									}
									default:
									{
										break;
									}
								}
								gala_shell_clients_manager_set_anchor (self, window, parsed);
								gala_shell_clients_manager_set_anchor (self, window, parsed);
							} else {
								const gchar* _tmp27_;
								_tmp27_ = val;
								g_warning ("ShellClientsManager.vala:315: Failed to parse %s as anchor", _tmp27_);
							}
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hide-mode")))) {
					switch (0) {
						default:
						{
							gint parsed = 0;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
							const gchar* _tmp30_;
							gint _tmp31_ = 0;
							gboolean _tmp32_;
							_tmp30_ = val;
							_tmp32_ = int_try_parse (_tmp30_, &_tmp31_, NULL, (guint) 0);
							parsed = _tmp31_;
							if (_tmp32_) {
								_tmp29_ = 0 <= parsed;
							} else {
								_tmp29_ = FALSE;
							}
							if (_tmp29_) {
								_tmp28_ = parsed <= 4;
							} else {
								_tmp28_ = FALSE;
							}
							if (_tmp28_) {
								gala_shell_clients_manager_set_hide_mode (self, window, parsed);
							} else {
								const gchar* _tmp33_;
								_tmp33_ = val;
								g_warning ("ShellClientsManager.vala:324: Failed to parse %s as hide mode", _tmp33_);
							}
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label2) ? _tmp20_label2 : (_tmp20_label2 = g_quark_from_static_string ("size")))) {
					switch (0) {
						default:
						{
							gchar** split_val = NULL;
							const gchar* _tmp34_;
							gchar** _tmp35_;
							gchar** _tmp36_;
							gint split_val_length1;
							gint _split_val_size_;
							gchar** _tmp37_;
							gint _tmp37__length1;
							gint parsed_width = 0;
							gint parsed_height = 0;
							gboolean _tmp38_ = FALSE;
							gchar** _tmp39_;
							gint _tmp39__length1;
							const gchar* _tmp40_;
							gint _tmp41_ = 0;
							gboolean _tmp42_;
							_tmp34_ = val;
							_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, ",", 0);
							split_val = _tmp36_;
							split_val_length1 = _vala_array_length (_tmp35_);
							_split_val_size_ = split_val_length1;
							_tmp37_ = split_val;
							_tmp37__length1 = split_val_length1;
							if (_tmp37__length1 != 2) {
								split_val = (_vala_array_free (split_val, split_val_length1, (GDestroyNotify) g_free), NULL);
								break;
							}
							parsed_height = 0;
							_tmp39_ = split_val;
							_tmp39__length1 = split_val_length1;
							_tmp40_ = _tmp39_[0];
							_tmp42_ = int_try_parse (_tmp40_, &_tmp41_, NULL, (guint) 0);
							parsed_width = _tmp41_;
							if (_tmp42_) {
								gchar** _tmp43_;
								gint _tmp43__length1;
								const gchar* _tmp44_;
								gint _tmp45_ = 0;
								gboolean _tmp46_;
								_tmp43_ = split_val;
								_tmp43__length1 = split_val_length1;
								_tmp44_ = _tmp43_[1];
								_tmp46_ = int_try_parse (_tmp44_, &_tmp45_, NULL, (guint) 0);
								parsed_height = _tmp45_;
								_tmp38_ = _tmp46_;
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								gala_shell_clients_manager_set_size (self, window, parsed_width, parsed_height);
							} else {
								const gchar* _tmp47_;
								_tmp47_ = val;
								g_warning ("ShellClientsManager.vala:337: Failed to parse %s as width and height", _tmp47_);
							}
							split_val = (_vala_array_free (split_val, split_val_length1, (GDestroyNotify) g_free), NULL);
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label3) ? _tmp20_label3 : (_tmp20_label3 = g_quark_from_static_string ("visible-in-multitasking-view")))) {
					switch (0) {
						default:
						{
							gala_shell_clients_manager_request_visible_in_multitasking_view (self, window);
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label4) ? _tmp20_label4 : (_tmp20_label4 = g_quark_from_static_string ("centered")))) {
					switch (0) {
						default:
						{
							gala_shell_clients_manager_make_centered (self, window);
							break;
						}
					}
				} else if (_tmp21_ == ((0 != _tmp20_label5) ? _tmp20_label5 : (_tmp20_label5 = g_quark_from_static_string ("restore-previous-region")))) {
					switch (0) {
						default:
						{
							gala_shell_clients_manager_set_restore_previous_x11_region (self, window);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
				_g_free0 (val);
				_g_free0 (key);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (mutter_hint);
			}
		}
	}
	mutter_hints = (_vala_array_free (mutter_hints, mutter_hints_length1, (GDestroyNotify) g_free), NULL);
}

static void
gala_shell_clients_manager_set_restore_previous_x11_region (GalaShellClientsManager* self,
                                                            MetaWindow* window)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_vala_return_if_fail (!meta_is_wayland_compositor (), "!Meta.Util.is_wayland_compositor ()");
	_tmp0_ = self->priv->panel_windows;
	_vala_return_if_fail (g_hash_table_contains (_tmp0_, window), "window in panel_windows");
	_tmp1_ = self->priv->panel_windows;
	_tmp2_ = g_hash_table_lookup (_tmp1_, window);
	gala_shell_window_set_restore_previous_x11_region ((GalaShellWindow*) ((GalaPanelWindow*) _tmp2_), TRUE);
}

static MtkRectangle*
_vala_MtkRectangle_copy (MtkRectangle* self)
{
	return g_boxed_copy (mtk_rectangle_get_type (), self);
}

static gpointer
__vala_MtkRectangle_copy0 (gpointer self)
{
	return self ? _vala_MtkRectangle_copy (self) : NULL;
}

MtkRectangle*
gala_shell_clients_manager_get_shell_client_rect (GalaShellClientsManager* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	MtkRectangle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->panel_windows;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* client_collection = NULL;
		GList* client_it = NULL;
		client_collection = _tmp1_;
		for (client_it = client_collection; client_it != NULL; client_it = client_it->next) {
			GalaPanelWindow* client = NULL;
			client = (GalaPanelWindow*) client_it->data;
			{
				GalaPanelWindow* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = client;
				_tmp3_ = gala_panel_window_get_visible_in_multitasking_view (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					GalaPanelWindow* _tmp5_;
					MtkRectangle _tmp6_ = {0};
					MtkRectangle* _tmp7_;
					_tmp5_ = client;
					gala_panel_window_get_custom_window_rect (_tmp5_, &_tmp6_);
					_tmp7_ = __vala_MtkRectangle_copy0 (&_tmp6_);
					result = _tmp7_;
					(client_collection == NULL) ? NULL : (client_collection = (g_list_free (client_collection), NULL));
					return result;
				}
			}
		}
		(client_collection == NULL) ? NULL : (client_collection = (g_list_free (client_collection), NULL));
	}
	result = NULL;
	return result;
}

GalaWindowManager*
gala_shell_clients_manager_get_wm (GalaShellClientsManager* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_shell_clients_manager_set_wm (GalaShellClientsManager* self,
                                   GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shell_clients_manager_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_shell_clients_manager_properties[GALA_SHELL_CLIENTS_MANAGER_WM_PROPERTY]);
	}
}

static void
__lambda27_ (GalaShellClientsManager* self,
             GObject* obj,
             GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	gala_shell_clients_manager_parse_mutter_hints (self, G_TYPE_CHECK_INSTANCE_CAST (obj, meta_window_get_type (), MetaWindow));
}

static void
___lambda27__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda27_ ((GalaShellClientsManager*) self, _sender, pspec);
}

static void
_gala_shell_clients_manager____lambda26_ (GalaShellClientsManager* self,
                                          MetaWindow* window)
{
	g_return_if_fail (window != NULL);
	g_signal_connect_object ((GObject*) window, "notify::mutter-hints", (GCallback) ___lambda27__g_object_notify, self, 0);
	gala_shell_clients_manager_parse_mutter_hints (self, window);
}

static void
__gala_shell_clients_manager____lambda26__meta_display_window_created (MetaDisplay* _sender,
                                                                       MetaWindow* object,
                                                                       gpointer self)
{
	_gala_shell_clients_manager____lambda26_ ((GalaShellClientsManager*) self, object);
}

static void
_gala_shell_clients_manager_on_failsafe_timeout_gsource_once_func (gpointer self)
{
	gala_shell_clients_manager_on_failsafe_timeout ((GalaShellClientsManager*) self);
}

static GObject *
gala_shell_clients_manager_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaShellClientsManager * self;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaNotificationsClient* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_shell_clients_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = gala_notifications_client_new (_tmp1_);
	_g_object_unref0 (self->priv->notifications_client);
	self->priv->notifications_client = _tmp2_;
	gala_shell_clients_manager_start_clients (self, NULL, NULL);
	if (!meta_is_wayland_compositor ()) {
		GalaWindowManager* _tmp3_;
		MetaDisplay* _tmp4_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
		g_signal_connect_object (_tmp4_, "window-created", (GCallback) __gala_shell_clients_manager____lambda26__meta_display_window_created, self, 0);
	}
	g_timeout_add_seconds_once ((guint) 5, _gala_shell_clients_manager_on_failsafe_timeout_gsource_once_func, self);
	return obj;
}

static void
gala_shell_clients_manager_class_init (GalaShellClientsManagerClass * klass,
                                       gpointer klass_data)
{
	gala_shell_clients_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaShellClientsManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_shell_clients_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_shell_clients_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_shell_clients_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_shell_clients_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHELL_CLIENTS_MANAGER_WM_PROPERTY, gala_shell_clients_manager_properties[GALA_SHELL_CLIENTS_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_shell_clients_manager_gala_gesture_target_interface_init (GalaGestureTargetIface * iface,
                                                               gpointer iface_data)
{
	gala_shell_clients_manager_gala_gesture_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->propagate = (void (*) (GalaGestureTarget*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_shell_clients_manager_real_propagate;
}

static void
gala_shell_clients_manager_instance_init (GalaShellClientsManager * self,
                                          gpointer klass)
{
	GalaManagedClient** _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	self->priv = gala_shell_clients_manager_get_instance_private (self);
	_tmp0_ = g_new0 (GalaManagedClient*, 0 + 1);
	self->priv->protocol_clients = _tmp0_;
	self->priv->protocol_clients_length1 = 0;
	self->priv->_protocol_clients_size_ = self->priv->protocol_clients_length1;
	self->priv->starting_panels = 0;
	_tmp1_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_object_unref0_);
	self->priv->panel_windows = _tmp1_;
	_tmp2_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_object_unref0_);
	self->priv->positioned_windows = _tmp2_;
}

static void
gala_shell_clients_manager_finalize (GObject * obj)
{
	GalaShellClientsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->notifications_client);
	self->priv->protocol_clients = (_vala_array_free (self->priv->protocol_clients, self->priv->protocol_clients_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->panel_windows);
	_g_hash_table_unref0 (self->priv->positioned_windows);
	G_OBJECT_CLASS (gala_shell_clients_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_shell_clients_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaShellClientsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_shell_clients_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaShellClientsManager), 0, (GInstanceInitFunc) gala_shell_clients_manager_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_target_info = { (GInterfaceInitFunc) gala_shell_clients_manager_gala_gesture_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_shell_clients_manager_type_id;
	gala_shell_clients_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaShellClientsManager", &g_define_type_info, 0);
	g_type_add_interface_static (gala_shell_clients_manager_type_id, GALA_TYPE_GESTURE_TARGET, &gala_gesture_target_info);
	GalaShellClientsManager_private_offset = g_type_add_instance_private (gala_shell_clients_manager_type_id, sizeof (GalaShellClientsManagerPrivate));
	return gala_shell_clients_manager_type_id;
}

GType
gala_shell_clients_manager_get_type (void)
{
	static gsize gala_shell_clients_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_shell_clients_manager_type_id__once)) {
		GType gala_shell_clients_manager_type_id;
		gala_shell_clients_manager_type_id = gala_shell_clients_manager_get_type_once ();
		g_once_init_leave (&gala_shell_clients_manager_type_id__once, gala_shell_clients_manager_type_id);
	}
	return gala_shell_clients_manager_type_id__once;
}

static void
_vala_gala_shell_clients_manager_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GalaShellClientsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager);
	switch (property_id) {
		case GALA_SHELL_CLIENTS_MANAGER_WM_PROPERTY:
		g_value_set_object (value, gala_shell_clients_manager_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_shell_clients_manager_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GalaShellClientsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager);
	switch (property_id) {
		case GALA_SHELL_CLIENTS_MANAGER_WM_PROPERTY:
		gala_shell_clients_manager_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

