/* common-contact-store-impl.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from common-contact-store-impl.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_TYPE_CONTACT_STORE_IMPL (geary_contact_store_impl_get_type ())
#define GEARY_CONTACT_STORE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_TYPE_CONTACT_STORE_IMPL, GearyContactStoreImpl))
#define GEARY_CONTACT_STORE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_TYPE_CONTACT_STORE_IMPL, GearyContactStoreImplClass))
#define GEARY_IS_CONTACT_STORE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_TYPE_CONTACT_STORE_IMPL))
#define GEARY_IS_CONTACT_STORE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_TYPE_CONTACT_STORE_IMPL))
#define GEARY_CONTACT_STORE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_TYPE_CONTACT_STORE_IMPL, GearyContactStoreImplClass))

typedef struct _GearyContactStoreImpl GearyContactStoreImpl;
typedef struct _GearyContactStoreImplClass GearyContactStoreImplClass;
typedef struct _GearyContactStoreImplPrivate GearyContactStoreImplPrivate;
enum  {
	GEARY_CONTACT_STORE_IMPL_0_PROPERTY,
	GEARY_CONTACT_STORE_IMPL_NUM_PROPERTIES
};
static GParamSpec* geary_contact_store_impl_properties[GEARY_CONTACT_STORE_IMPL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block19Data Block19Data;
typedef struct _GearyContactStoreImplGetByRfc822Data GearyContactStoreImplGetByRfc822Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block20Data Block20Data;
typedef struct _GearyContactStoreImplSearchData GearyContactStoreImplSearchData;
typedef struct _Block21Data Block21Data;
typedef struct _GearyContactStoreImplUpdateContactsData GearyContactStoreImplUpdateContactsData;

struct _GearyContactStoreImpl {
	GearyBaseObject parent_instance;
	GearyContactStoreImplPrivate * priv;
};

struct _GearyContactStoreImplClass {
	GearyBaseObjectClass parent_class;
};

struct _GearyContactStoreImplPrivate {
	GearyDbDatabase* backing;
};

struct _Block19Data {
	int _ref_count_;
	GearyContactStoreImpl* self;
	GearyContact* contact;
	GearyRFC822MailboxAddress* mailbox;
	gpointer _async_data_;
};

struct _GearyContactStoreImplGetByRfc822Data {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyContactStoreImpl* self;
	GearyRFC822MailboxAddress* mailbox;
	GCancellable* cancellable;
	GearyContact* result;
	Block19Data* _data19_;
	GearyDbDatabase* _tmp0_;
	GearyContact* _tmp1_;
	GError* _inner_error0_;
};

struct _Block20Data {
	int _ref_count_;
	GearyContactStoreImpl* self;
	GeeCollection* contacts;
	gchar* query;
	guint min_importance;
	guint limit;
	gpointer _async_data_;
};

struct _GearyContactStoreImplSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyContactStoreImpl* self;
	gchar* query;
	guint min_importance;
	guint limit;
	GCancellable* cancellable;
	GeeCollection* result;
	Block20Data* _data20_;
	GearyDbDatabase* _tmp0_;
	GeeCollection* _tmp1_;
	GError* _inner_error0_;
};

struct _Block21Data {
	int _ref_count_;
	GearyContactStoreImpl* self;
	GeeCollection* updated;
	gpointer _async_data_;
};

struct _GearyContactStoreImplUpdateContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyContactStoreImpl* self;
	GeeCollection* updated;
	GCancellable* cancellable;
	Block21Data* _data21_;
	GearyDbDatabase* _tmp0_;
	GError* _inner_error0_;
};

static gint GearyContactStoreImpl_private_offset;
static gpointer geary_contact_store_impl_parent_class = NULL;
static GearyContactStoreIface * geary_contact_store_impl_geary_contact_store_parent_iface = NULL;

VALA_EXTERN GType geary_contact_store_impl_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyContactStoreImpl* geary_contact_store_impl_new (GearyDbDatabase* backing);
VALA_EXTERN GearyContactStoreImpl* geary_contact_store_impl_construct (GType object_type,
                                                           GearyDbDatabase* backing);
static void geary_contact_store_impl_real_get_by_rfc822_data_free (gpointer _data);
static void geary_contact_store_impl_real_get_by_rfc822 (GearyContactStore* base,
                                                  GearyRFC822MailboxAddress* mailbox,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean geary_contact_store_impl_real_get_by_rfc822_co (GearyContactStoreImplGetByRfc822Data* _data_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static GearyDbTransactionOutcome __lambda131_ (Block19Data* _data19_,
                                        GearyDbConnection* cx,
                                        GCancellable* cancellable,
                                        GError** error);
static GearyContact* geary_contact_store_impl_do_fetch_contact (GearyContactStoreImpl* self,
                                                         GearyDbConnection* cx,
                                                         const gchar* email,
                                                         GCancellable* cancellable,
                                                         GError** error);
static GearyDbTransactionOutcome ___lambda131__geary_db_transaction_method (GearyDbConnection* cx,
                                                                     GCancellable* cancellable,
                                                                     gpointer self,
                                                                     GError** error);
static void geary_contact_store_impl_get_by_rfc822_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void geary_contact_store_impl_real_search_data_free (gpointer _data);
static void geary_contact_store_impl_real_search (GearyContactStore* base,
                                           const gchar* query,
                                           guint min_importance,
                                           guint limit,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean geary_contact_store_impl_real_search_co (GearyContactStoreImplSearchData* _data_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static GearyDbTransactionOutcome __lambda132_ (Block20Data* _data20_,
                                        GearyDbConnection* cx,
                                        GCancellable* cancellable,
                                        GError** error);
static GeeCollection* geary_contact_store_impl_do_search_contacts (GearyContactStoreImpl* self,
                                                            GearyDbConnection* cx,
                                                            const gchar* query,
                                                            guint min_importance,
                                                            guint limit,
                                                            GCancellable* cancellable,
                                                            GError** error);
static GearyDbTransactionOutcome ___lambda132__geary_db_transaction_method (GearyDbConnection* cx,
                                                                     GCancellable* cancellable,
                                                                     gpointer self,
                                                                     GError** error);
static void geary_contact_store_impl_search_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void geary_contact_store_impl_real_update_contacts_data_free (gpointer _data);
static void geary_contact_store_impl_real_update_contacts (GearyContactStore* base,
                                                    GeeCollection* updated,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean geary_contact_store_impl_real_update_contacts_co (GearyContactStoreImplUpdateContactsData* _data_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static GearyDbTransactionOutcome __lambda133_ (Block21Data* _data21_,
                                        GearyDbConnection* cx,
                                        GCancellable* cancellable,
                                        GError** error);
static void geary_contact_store_impl_do_update_contact (GearyContactStoreImpl* self,
                                                 GearyDbConnection* cx,
                                                 GearyContact* updated,
                                                 GCancellable* cancellable,
                                                 GError** error);
static GearyDbTransactionOutcome ___lambda133__geary_db_transaction_method (GearyDbConnection* cx,
                                                                     GCancellable* cancellable,
                                                                     gpointer self,
                                                                     GError** error);
static void geary_contact_store_impl_update_contacts_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void geary_contact_store_impl_finalize (GObject * obj);
static GType geary_contact_store_impl_get_type_once (void);

static inline gpointer
geary_contact_store_impl_get_instance_private (GearyContactStoreImpl* self)
{
	return G_STRUCT_MEMBER_P (self, GearyContactStoreImpl_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyContactStoreImpl*
geary_contact_store_impl_construct (GType object_type,
                                    GearyDbDatabase* backing)
{
	GearyContactStoreImpl * self = NULL;
	GearyDbDatabase* _tmp0_;
	g_return_val_if_fail (GEARY_DB_IS_DATABASE (backing), NULL);
	self = (GearyContactStoreImpl*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (backing);
	_g_object_unref0 (self->priv->backing);
	self->priv->backing = _tmp0_;
	return self;
}

GearyContactStoreImpl*
geary_contact_store_impl_new (GearyDbDatabase* backing)
{
	return geary_contact_store_impl_construct (GEARY_TYPE_CONTACT_STORE_IMPL, backing);
}

static void
geary_contact_store_impl_real_get_by_rfc822_data_free (gpointer _data)
{
	GearyContactStoreImplGetByRfc822Data* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyContactStoreImplGetByRfc822Data, _data_);
}

static void
geary_contact_store_impl_real_get_by_rfc822 (GearyContactStore* base,
                                             GearyRFC822MailboxAddress* mailbox,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GearyContactStoreImpl * self;
	GearyContactStoreImplGetByRfc822Data* _data_;
	GearyContactStoreImpl* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (mailbox));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_CONTACT_STORE_IMPL, GearyContactStoreImpl);
	_data_ = g_slice_new0 (GearyContactStoreImplGetByRfc822Data);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_contact_store_impl_real_get_by_rfc822_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (mailbox);
	_g_object_unref0 (_data_->mailbox);
	_data_->mailbox = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_contact_store_impl_real_get_by_rfc822_co (_data_);
}

static GearyContact*
geary_contact_store_impl_get_by_rfc822_finish (GearyContactStore* base,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GearyContact* result;
	GearyContactStoreImplGetByRfc822Data* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		GearyContactStoreImpl* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->contact);
		_g_object_unref0 (_data19_->mailbox);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static GearyDbTransactionOutcome
__lambda131_ (Block19Data* _data19_,
              GearyDbConnection* cx,
              GCancellable* cancellable,
              GError** error)
{
	GearyContactStoreImpl* self;
	GearyContact* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GearyContact* _tmp3_;
	GearyContact* _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data19_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), 0);
	_tmp1_ = geary_rf_c822_mailbox_address_get_address (_data19_->mailbox);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_contact_store_impl_do_fetch_contact (self, cx, _tmp2_, cancellable, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (_data19_->contact);
	_data19_->contact = _tmp4_;
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GearyDbTransactionOutcome
___lambda131__geary_db_transaction_method (GearyDbConnection* cx,
                                           GCancellable* cancellable,
                                           gpointer self,
                                           GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda131_ (self, cx, cancellable, error);
	return result;
}

static void
geary_contact_store_impl_get_by_rfc822_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GearyContactStoreImplGetByRfc822Data* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_contact_store_impl_real_get_by_rfc822_co (_data_);
}

static gboolean
geary_contact_store_impl_real_get_by_rfc822_co (GearyContactStoreImplGetByRfc822Data* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data19_ = g_slice_new0 (Block19Data);
	_data_->_data19_->_ref_count_ = 1;
	_data_->_data19_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data19_->mailbox);
	_data_->_data19_->mailbox = _data_->mailbox;
	_data_->_data19_->_async_data_ = _data_;
	_data_->_data19_->contact = NULL;
	_data_->_tmp0_ = _data_->self->priv->backing;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (_data_->_tmp0_, GEARY_DB_TRANSACTION_TYPE_RO, ___lambda131__geary_db_transaction_method, _data_->_data19_, _data_->cancellable, geary_contact_store_impl_get_by_rfc822_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block19_data_unref (_data_->_data19_);
		_data_->_data19_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _g_object_ref0 (_data_->_data19_->contact);
	_data_->result = _data_->_tmp1_;
	block19_data_unref (_data_->_data19_);
	_data_->_data19_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_contact_store_impl_real_search_data_free (gpointer _data)
{
	GearyContactStoreImplSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyContactStoreImplSearchData, _data_);
}

static void
geary_contact_store_impl_real_search (GearyContactStore* base,
                                      const gchar* query,
                                      guint min_importance,
                                      guint limit,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearyContactStoreImpl * self;
	GearyContactStoreImplSearchData* _data_;
	GearyContactStoreImpl* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (query != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_CONTACT_STORE_IMPL, GearyContactStoreImpl);
	_data_ = g_slice_new0 (GearyContactStoreImplSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_contact_store_impl_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query);
	_g_free0 (_data_->query);
	_data_->query = _tmp1_;
	_data_->min_importance = min_importance;
	_data_->limit = limit;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_contact_store_impl_real_search_co (_data_);
}

static GeeCollection*
geary_contact_store_impl_search_finish (GearyContactStore* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GeeCollection* result;
	GearyContactStoreImplSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		GearyContactStoreImpl* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->contacts);
		_g_free0 (_data20_->query);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static GearyDbTransactionOutcome
__lambda132_ (Block20Data* _data20_,
              GearyDbConnection* cx,
              GCancellable* cancellable,
              GError** error)
{
	GearyContactStoreImpl* self;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data20_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), 0);
	_tmp1_ = geary_contact_store_impl_do_search_contacts (self, cx, _data20_->query, _data20_->min_importance, _data20_->limit, cancellable, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (_data20_->contacts);
	_data20_->contacts = _tmp2_;
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GearyDbTransactionOutcome
___lambda132__geary_db_transaction_method (GearyDbConnection* cx,
                                           GCancellable* cancellable,
                                           gpointer self,
                                           GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda132_ (self, cx, cancellable, error);
	return result;
}

static void
geary_contact_store_impl_search_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	GearyContactStoreImplSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_contact_store_impl_real_search_co (_data_);
}

static gboolean
geary_contact_store_impl_real_search_co (GearyContactStoreImplSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data20_ = g_slice_new0 (Block20Data);
	_data_->_data20_->_ref_count_ = 1;
	_data_->_data20_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data20_->query);
	_data_->_data20_->query = _data_->query;
	_data_->_data20_->min_importance = _data_->min_importance;
	_data_->_data20_->limit = _data_->limit;
	_data_->_data20_->_async_data_ = _data_;
	_data_->_data20_->contacts = NULL;
	_data_->_tmp0_ = _data_->self->priv->backing;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (_data_->_tmp0_, GEARY_DB_TRANSACTION_TYPE_RO, ___lambda132__geary_db_transaction_method, _data_->_data20_, _data_->cancellable, geary_contact_store_impl_search_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block20_data_unref (_data_->_data20_);
		_data_->_data20_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _g_object_ref0 (_data_->_data20_->contacts);
	_data_->result = _data_->_tmp1_;
	block20_data_unref (_data_->_data20_);
	_data_->_data20_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_contact_store_impl_real_update_contacts_data_free (gpointer _data)
{
	GearyContactStoreImplUpdateContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyContactStoreImplUpdateContactsData, _data_);
}

static void
geary_contact_store_impl_real_update_contacts (GearyContactStore* base,
                                               GeeCollection* updated,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GearyContactStoreImpl * self;
	GearyContactStoreImplUpdateContactsData* _data_;
	GearyContactStoreImpl* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (updated, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_CONTACT_STORE_IMPL, GearyContactStoreImpl);
	_data_ = g_slice_new0 (GearyContactStoreImplUpdateContactsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_contact_store_impl_real_update_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (updated);
	_g_object_unref0 (_data_->updated);
	_data_->updated = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_contact_store_impl_real_update_contacts_co (_data_);
}

static void
geary_contact_store_impl_update_contacts_finish (GearyContactStore* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GearyContactStoreImplUpdateContactsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		GearyContactStoreImpl* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->updated);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static GearyDbTransactionOutcome
__lambda133_ (Block21Data* _data21_,
              GearyDbConnection* cx,
              GCancellable* cancellable,
              GError** error)
{
	GearyContactStoreImpl* self;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data21_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), 0);
	{
		GeeIterator* _contact_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data21_->updated, GEE_TYPE_ITERABLE, GeeIterable));
		_contact_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GearyContact* contact = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GearyContact* _tmp4_;
			_tmp1_ = _contact_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _contact_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			contact = (GearyContact*) _tmp3_;
			_tmp4_ = contact;
			geary_contact_store_impl_do_update_contact (self, cx, _tmp4_, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (contact);
				_g_object_unref0 (_contact_it);
				return 0;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_it);
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	return result;
}

static GearyDbTransactionOutcome
___lambda133__geary_db_transaction_method (GearyDbConnection* cx,
                                           GCancellable* cancellable,
                                           gpointer self,
                                           GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda133_ (self, cx, cancellable, error);
	return result;
}

static void
geary_contact_store_impl_update_contacts_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GearyContactStoreImplUpdateContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_contact_store_impl_real_update_contacts_co (_data_);
}

static gboolean
geary_contact_store_impl_real_update_contacts_co (GearyContactStoreImplUpdateContactsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data21_ = g_slice_new0 (Block21Data);
	_data_->_data21_->_ref_count_ = 1;
	_data_->_data21_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data21_->updated);
	_data_->_data21_->updated = _data_->updated;
	_data_->_data21_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->backing;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (_data_->_tmp0_, GEARY_DB_TRANSACTION_TYPE_RW, ___lambda133__geary_db_transaction_method, _data_->_data21_, _data_->cancellable, geary_contact_store_impl_update_contacts_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block21_data_unref (_data_->_data21_);
		_data_->_data21_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block21_data_unref (_data_->_data21_);
	_data_->_data21_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GearyContact*
geary_contact_store_impl_do_fetch_contact (GearyContactStoreImpl* self,
                                           GearyDbConnection* cx,
                                           const gchar* email,
                                           GCancellable* cancellable,
                                           GError** error)
{
	gchar* normalised_query = NULL;
	gchar* _tmp0_;
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	const gchar* _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbStatement* _tmp5_;
	GearyDbResult* _result_ = NULL;
	GearyDbStatement* _tmp6_;
	GearyDbResult* _tmp7_;
	GearyContact* contact = NULL;
	GearyDbResult* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GError* _inner_error0_ = NULL;
	GearyContact* result;
	g_return_val_if_fail (GEARY_IS_CONTACT_STORE_IMPL (self), NULL);
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), NULL);
	g_return_val_if_fail (email != NULL, NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = g_utf8_make_valid (email, (gssize) -1);
	normalised_query = _tmp0_;
	_tmp1_ = geary_db_connection_prepare (cx, "SELECT real_name, highest_importance, normalized_email, flags FROM Con" \
"tactTable " "WHERE email=?", &_inner_error0_);
	stmt = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (normalised_query);
		return NULL;
	}
	_tmp2_ = stmt;
	_tmp3_ = normalised_query;
	_tmp4_ = geary_db_statement_bind_string (_tmp2_, 0, _tmp3_, &_inner_error0_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		_g_free0 (normalised_query);
		return NULL;
	}
	_tmp6_ = stmt;
	_tmp7_ = geary_db_statement_exec (_tmp6_, cancellable, &_inner_error0_);
	_result_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		_g_free0 (normalised_query);
		return NULL;
	}
	contact = NULL;
	_tmp8_ = _result_;
	_tmp9_ = geary_db_result_get_finished (_tmp8_);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		const gchar* _tmp11_ = NULL;
		GearyDbResult* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_ = 0;
		GearyDbResult* _tmp15_;
		const gchar* _tmp16_ = NULL;
		GearyDbResult* _tmp17_;
		const gchar* _tmp18_;
		GearyContact* _tmp19_;
		const gchar* _tmp20_ = NULL;
		GearyDbResult* _tmp21_;
		const gchar* _tmp22_;
		GearyContact* _tmp23_;
		GearyContactFlags* _tmp24_;
		GearyContactFlags* _tmp25_;
		_tmp12_ = _result_;
		_tmp13_ = geary_db_result_string_at (_tmp12_, 0, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (contact);
			_g_object_unref0 (_result_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			return NULL;
		}
		_tmp15_ = _result_;
		_tmp14_ = geary_db_result_int_at (_tmp15_, 1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (contact);
			_g_object_unref0 (_result_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			return NULL;
		}
		_tmp17_ = _result_;
		_tmp18_ = geary_db_result_string_at (_tmp17_, 2, &_inner_error0_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (contact);
			_g_object_unref0 (_result_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			return NULL;
		}
		_tmp19_ = geary_contact_new (email, _tmp11_, _tmp14_, _tmp16_);
		_g_object_unref0 (contact);
		contact = _tmp19_;
		_tmp21_ = _result_;
		_tmp22_ = geary_db_result_string_at (_tmp21_, 3, &_inner_error0_);
		_tmp20_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (contact);
			_g_object_unref0 (_result_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			return NULL;
		}
		_tmp23_ = contact;
		_tmp24_ = geary_contact_get_flags (_tmp23_);
		_tmp25_ = _tmp24_;
		geary_contact_flags_deserialize (_tmp25_, _tmp20_);
	}
	result = contact;
	_g_object_unref0 (_result_);
	_g_object_unref0 (stmt);
	_g_free0 (normalised_query);
	return result;
}

static GeeCollection*
geary_contact_store_impl_do_search_contacts (GearyContactStoreImpl* self,
                                             GearyDbConnection* cx,
                                             const gchar* query,
                                             guint min_importance,
                                             guint limit,
                                             GCancellable* cancellable,
                                             GError** error)
{
	GeeCollection* contacts = NULL;
	GeeLinkedList* _tmp0_;
	gchar* normalised_query = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	GeeCollection* result;
	g_return_val_if_fail (GEARY_IS_CONTACT_STORE_IMPL (self), NULL);
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), NULL);
	g_return_val_if_fail (query != NULL, NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = gee_linked_list_new (GEARY_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	contacts = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp1_ = geary_db_normalise_case_insensitive_query (query);
	normalised_query = _tmp1_;
	_tmp2_ = normalised_query;
	if (!geary_string_is_empty (_tmp2_)) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		GearyDbStatement* stmt = NULL;
		GearyDbStatement* _tmp5_;
		GearyDbStatement* _tmp6_;
		GearyDbStatement* _tmp7_;
		GearyDbStatement* _tmp8_;
		GearyDbStatement* _tmp9_;
		const gchar* _tmp10_;
		GearyDbStatement* _tmp11_;
		GearyDbStatement* _tmp12_;
		GearyDbStatement* _tmp13_;
		const gchar* _tmp14_;
		GearyDbStatement* _tmp15_;
		GearyDbStatement* _tmp16_;
		GearyDbStatement* _tmp17_;
		GearyDbStatement* _tmp18_;
		GearyDbStatement* _tmp19_;
		GearyDbResult* _result_ = NULL;
		GearyDbStatement* _tmp20_;
		GearyDbResult* _tmp21_;
		_tmp3_ = normalised_query;
		_tmp4_ = g_strconcat (_tmp3_, "%", NULL);
		_g_free0 (normalised_query);
		normalised_query = _tmp4_;
		_tmp5_ = geary_db_connection_prepare (cx, "\n" \
"                SELECT * FROM ContactTable\n" \
"                WHERE highest_importance >= ? AND (\n" \
"                    UTF8FOLD(real_name) LIKE ? OR\n" \
"                    UTF8FOLD(email) LIKE ?\n" \
"                )\n" \
"                ORDER BY highest_importance DESC,\n" \
"                         real_name IS NULL,\n" \
"                         real_name COLLATE UTF8COLL,\n" \
"                         email COLLATE UTF8COLL\n" \
"                LIMIT ?\n" \
"            ", &_inner_error0_);
		stmt = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (normalised_query);
			_g_object_unref0 (contacts);
			return NULL;
		}
		_tmp6_ = stmt;
		_tmp7_ = geary_db_statement_bind_uint (_tmp6_, 0, min_importance, &_inner_error0_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp8_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			_g_object_unref0 (contacts);
			return NULL;
		}
		_tmp9_ = stmt;
		_tmp10_ = normalised_query;
		_tmp11_ = geary_db_statement_bind_string (_tmp9_, 1, _tmp10_, &_inner_error0_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp12_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			_g_object_unref0 (contacts);
			return NULL;
		}
		_tmp13_ = stmt;
		_tmp14_ = normalised_query;
		_tmp15_ = geary_db_statement_bind_string (_tmp13_, 2, _tmp14_, &_inner_error0_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			_g_object_unref0 (contacts);
			return NULL;
		}
		_tmp17_ = stmt;
		_tmp18_ = geary_db_statement_bind_uint (_tmp17_, 3, limit, &_inner_error0_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp19_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			_g_object_unref0 (contacts);
			return NULL;
		}
		_tmp20_ = stmt;
		_tmp21_ = geary_db_statement_exec (_tmp20_, cancellable, &_inner_error0_);
		_result_ = _tmp21_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stmt);
			_g_free0 (normalised_query);
			_g_object_unref0 (contacts);
			return NULL;
		}
		while (TRUE) {
			GearyDbResult* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			const gchar* _tmp25_ = NULL;
			GearyDbResult* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_ = NULL;
			GearyDbResult* _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_ = 0;
			GearyDbResult* _tmp32_;
			const gchar* _tmp33_ = NULL;
			GearyDbResult* _tmp34_;
			const gchar* _tmp35_;
			GearyContact* contact = NULL;
			GearyContact* _tmp36_;
			const gchar* _tmp37_ = NULL;
			GearyDbResult* _tmp38_;
			const gchar* _tmp39_;
			GearyContact* _tmp40_;
			GearyContactFlags* _tmp41_;
			GearyContactFlags* _tmp42_;
			GeeCollection* _tmp43_;
			GearyContact* _tmp44_;
			GearyDbResult* _tmp45_;
			_tmp22_ = _result_;
			_tmp23_ = geary_db_result_get_finished (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!(!_tmp24_)) {
				break;
			}
			_tmp26_ = _result_;
			_tmp27_ = geary_db_result_string_for (_tmp26_, "email", &_inner_error0_);
			_tmp25_ = _tmp27_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				_g_free0 (normalised_query);
				_g_object_unref0 (contacts);
				return NULL;
			}
			_tmp29_ = _result_;
			_tmp30_ = geary_db_result_string_for (_tmp29_, "real_name", &_inner_error0_);
			_tmp28_ = _tmp30_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				_g_free0 (normalised_query);
				_g_object_unref0 (contacts);
				return NULL;
			}
			_tmp32_ = _result_;
			_tmp31_ = geary_db_result_int_for (_tmp32_, "highest_importance", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				_g_free0 (normalised_query);
				_g_object_unref0 (contacts);
				return NULL;
			}
			_tmp34_ = _result_;
			_tmp35_ = geary_db_result_string_for (_tmp34_, "normalized_email", &_inner_error0_);
			_tmp33_ = _tmp35_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				_g_free0 (normalised_query);
				_g_object_unref0 (contacts);
				return NULL;
			}
			_tmp36_ = geary_contact_new (_tmp25_, _tmp28_, _tmp31_, _tmp33_);
			contact = _tmp36_;
			_tmp38_ = _result_;
			_tmp39_ = geary_db_result_string_for (_tmp38_, "flags", &_inner_error0_);
			_tmp37_ = _tmp39_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (contact);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				_g_free0 (normalised_query);
				_g_object_unref0 (contacts);
				return NULL;
			}
			_tmp40_ = contact;
			_tmp41_ = geary_contact_get_flags (_tmp40_);
			_tmp42_ = _tmp41_;
			geary_contact_flags_deserialize (_tmp42_, _tmp37_);
			_tmp43_ = contacts;
			_tmp44_ = contact;
			gee_collection_add (_tmp43_, _tmp44_);
			_tmp45_ = _result_;
			geary_db_result_next (_tmp45_, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (contact);
				_g_object_unref0 (_result_);
				_g_object_unref0 (stmt);
				_g_free0 (normalised_query);
				_g_object_unref0 (contacts);
				return NULL;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_result_);
		_g_object_unref0 (stmt);
	}
	result = contacts;
	_g_free0 (normalised_query);
	return result;
}

static void
geary_contact_store_impl_do_update_contact (GearyContactStoreImpl* self,
                                            GearyDbConnection* cx,
                                            GearyContact* updated,
                                            GCancellable* cancellable,
                                            GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbStatement* _tmp5_;
	GearyDbStatement* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GearyDbStatement* _tmp11_;
	GearyDbStatement* _tmp12_;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GearyDbStatement* _tmp19_;
	GearyDbStatement* _tmp20_;
	GearyDbStatement* _tmp21_;
	GearyDbStatement* _tmp22_;
	GearyContactFlags* _tmp23_;
	GearyContactFlags* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GearyDbStatement* _tmp27_;
	GearyDbStatement* _tmp28_;
	GearyDbStatement* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GearyDbStatement* _tmp32_;
	GearyDbStatement* _tmp33_;
	GearyDbStatement* _tmp34_;
	GearyDbResult* _tmp35_;
	GearyDbResult* _tmp36_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IS_CONTACT_STORE_IMPL (self));
	g_return_if_fail (GEARY_DB_IS_CONNECTION (cx));
	g_return_if_fail (GEARY_IS_CONTACT (updated));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"            INSERT INTO ContactTable(\n" \
"                normalized_email, email, real_name, flags, highest_imp" \
"ortance\n" \
"            ) VALUES(?, ?, ?, ?, ?)\n" \
"            ON CONFLICT(email) DO UPDATE SET\n" \
"              real_name = excluded.real_name,\n" \
"              flags = excluded.flags,\n" \
"              highest_importance = excluded.highest_importance\n" \
"        ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_contact_get_normalized_email (updated);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_db_statement_bind_string (_tmp1_, 0, _tmp3_, &_inner_error0_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp6_ = stmt;
	_tmp7_ = geary_contact_get_email (updated);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_utf8_make_valid (_tmp8_, (gssize) -1);
	_tmp10_ = _tmp9_;
	_tmp11_ = geary_db_statement_bind_string (_tmp6_, 1, _tmp10_, &_inner_error0_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp14_ = geary_contact_get_real_name (updated);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = geary_contact_get_real_name (updated);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_utf8_make_valid (_tmp17_, (gssize) -1);
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp18_;
	} else {
		_g_free0 (_tmp13_);
		_tmp13_ = NULL;
	}
	_tmp19_ = stmt;
	_tmp20_ = geary_db_statement_bind_string (_tmp19_, 2, _tmp13_, &_inner_error0_);
	_tmp21_ = _tmp20_;
	_g_object_unref0 (_tmp21_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp13_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp22_ = stmt;
	_tmp23_ = geary_contact_get_flags (updated);
	_tmp24_ = _tmp23_;
	_tmp25_ = geary_contact_flags_serialize (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = geary_db_statement_bind_string (_tmp22_, 3, _tmp26_, &_inner_error0_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp28_);
	_g_free0 (_tmp26_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp13_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp29_ = stmt;
	_tmp30_ = geary_contact_get_highest_importance (updated);
	_tmp31_ = _tmp30_;
	_tmp32_ = geary_db_statement_bind_int (_tmp29_, 4, _tmp31_, &_inner_error0_);
	_tmp33_ = _tmp32_;
	_g_object_unref0 (_tmp33_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp13_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp34_ = stmt;
	_tmp35_ = geary_db_statement_exec (_tmp34_, cancellable, &_inner_error0_);
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp36_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp13_);
		_g_object_unref0 (stmt);
		return;
	}
	_g_free0 (_tmp13_);
	_g_object_unref0 (stmt);
}

static void
geary_contact_store_impl_class_init (GearyContactStoreImplClass * klass,
                                     gpointer klass_data)
{
	geary_contact_store_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyContactStoreImpl_private_offset);
	G_OBJECT_CLASS (klass)->finalize = geary_contact_store_impl_finalize;
}

static void
geary_contact_store_impl_geary_contact_store_interface_init (GearyContactStoreIface * iface,
                                                             gpointer iface_data)
{
	geary_contact_store_impl_geary_contact_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_by_rfc822 = (void (*) (GearyContactStore*, GearyRFC822MailboxAddress*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_contact_store_impl_real_get_by_rfc822;
	iface->get_by_rfc822_finish = (GearyContact* (*) (GearyContactStore*, GAsyncResult*, GError**)) geary_contact_store_impl_get_by_rfc822_finish;
	iface->search = (void (*) (GearyContactStore*, const gchar*, guint, guint, GCancellable*, GAsyncReadyCallback, gpointer)) geary_contact_store_impl_real_search;
	iface->search_finish = (GeeCollection* (*) (GearyContactStore*, GAsyncResult*, GError**)) geary_contact_store_impl_search_finish;
	iface->update_contacts = (void (*) (GearyContactStore*, GeeCollection*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_contact_store_impl_real_update_contacts;
	iface->update_contacts_finish = (void (*) (GearyContactStore*, GAsyncResult*, GError**)) geary_contact_store_impl_update_contacts_finish;
}

static void
geary_contact_store_impl_instance_init (GearyContactStoreImpl * self,
                                        gpointer klass)
{
	self->priv = geary_contact_store_impl_get_instance_private (self);
}

static void
geary_contact_store_impl_finalize (GObject * obj)
{
	GearyContactStoreImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_CONTACT_STORE_IMPL, GearyContactStoreImpl);
	_g_object_unref0 (self->priv->backing);
	G_OBJECT_CLASS (geary_contact_store_impl_parent_class)->finalize (obj);
}

/**
 * An database-backed implementation of Geary.Contacts
 */
 G_GNUC_NO_INLINE static GType
geary_contact_store_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyContactStoreImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_contact_store_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyContactStoreImpl), 0, (GInstanceInitFunc) geary_contact_store_impl_instance_init, NULL };
	static const GInterfaceInfo geary_contact_store_info = { (GInterfaceInitFunc) geary_contact_store_impl_geary_contact_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_contact_store_impl_type_id;
	geary_contact_store_impl_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyContactStoreImpl", &g_define_type_info, 0);
	g_type_add_interface_static (geary_contact_store_impl_type_id, GEARY_TYPE_CONTACT_STORE, &geary_contact_store_info);
	GearyContactStoreImpl_private_offset = g_type_add_instance_private (geary_contact_store_impl_type_id, sizeof (GearyContactStoreImplPrivate));
	return geary_contact_store_impl_type_id;
}

GType
geary_contact_store_impl_get_type (void)
{
	static gsize geary_contact_store_impl_type_id__once = 0;
	if (g_once_init_enter (&geary_contact_store_impl_type_id__once)) {
		GType geary_contact_store_impl_type_id;
		geary_contact_store_impl_type_id = geary_contact_store_impl_get_type_once ();
		g_once_init_leave (&geary_contact_store_impl_type_id__once, geary_contact_store_impl_type_id);
	}
	return geary_contact_store_impl_type_id__once;
}

