/* gitg-preferences-interface.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-preferences-interface.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include "libgitg-ext.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksource.h>

#define GITG_PREFERENCES_INTERFACE_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_PREFERENCES_INTERFACE (gitg_preferences_interface_get_type ())
#define GITG_PREFERENCES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PREFERENCES_INTERFACE, GitgPreferencesInterface))
#define GITG_PREFERENCES_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PREFERENCES_INTERFACE, GitgPreferencesInterfaceClass))
#define GITG_IS_PREFERENCES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PREFERENCES_INTERFACE))
#define GITG_IS_PREFERENCES_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PREFERENCES_INTERFACE))
#define GITG_PREFERENCES_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PREFERENCES_INTERFACE, GitgPreferencesInterfaceClass))

typedef struct _GitgPreferencesInterface GitgPreferencesInterface;
typedef struct _GitgPreferencesInterfaceClass GitgPreferencesInterfaceClass;
typedef struct _GitgPreferencesInterfacePrivate GitgPreferencesInterfacePrivate;
enum  {
	GITG_PREFERENCES_INTERFACE_0_PROPERTY,
	GITG_PREFERENCES_INTERFACE_WIDGET_PROPERTY,
	GITG_PREFERENCES_INTERFACE_ID_PROPERTY,
	GITG_PREFERENCES_INTERFACE_DISPLAY_NAME_PROPERTY,
	GITG_PREFERENCES_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* gitg_preferences_interface_properties[GITG_PREFERENCES_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgPreferencesInterface {
	GtkGrid parent_instance;
	GitgPreferencesInterfacePrivate * priv;
};

struct _GitgPreferencesInterfaceClass {
	GtkGridClass parent_class;
};

struct _GitgPreferencesInterfacePrivate {
	gboolean d_block;
	GSettings* d_settings;
	GSettings* d_global_settings;
	GtkCheckButton* d_horizontal_layout_enabled;
	GtkComboBox* d_default_activity;
	GtkCheckButton* d_gravatar_enabled;
	GtkCheckButton* d_monitoring_enabled;
	GtkCheckButton* d_diff_highlighting_enabled;
	GtkComboBox* d_default_style_scheme;
	GtkListStore* d_syntax_scheme_store;
	GtkFontButton* d_font_button;
	GtkGrid* d_font_button_grid;
	GtkCheckButton* d_default_font_checkbutton;
};

static gint GitgPreferencesInterface_private_offset;
static gpointer gitg_preferences_interface_parent_class = NULL;
static GitgExtPreferencesIface * gitg_preferences_interface_gitg_ext_preferences_parent_iface = NULL;

VALA_EXTERN GType gitg_preferences_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgPreferencesInterface, g_object_unref)
static void gitg_preferences_interface_update_system_font_label (GitgPreferencesInterface* self);
static void gitg_preferences_interface_real_dispose (GObject* base);
static void gitg_preferences_interface_orientation_changed (GitgPreferencesInterface* self,
                                                     GSettings* settings,
                                                     const gchar* key);
static void _gitg_preferences_interface_orientation_changed_g_settings_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self);
VALA_EXTERN GitgPreferencesInterface* gitg_preferences_interface_new (void);
VALA_EXTERN GitgPreferencesInterface* gitg_preferences_interface_construct (GType object_type);
static GObject * gitg_preferences_interface_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _gitg_preferences_interface___lambda140_ (GitgPreferencesInterface* self,
                                               GObject* obj,
                                               GParamSpec* spec);
static void __gitg_preferences_interface___lambda140__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _gitg_preferences_interface___lambda141_ (GitgPreferencesInterface* self,
                                               GSettings* s,
                                               const gchar* k);
static void __gitg_preferences_interface___lambda141__g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self);
static void gitg_preferences_interface_finalize (GObject * obj);
static GType gitg_preferences_interface_get_type_once (void);
static void _vala_gitg_preferences_interface_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
gitg_preferences_interface_get_instance_private (GitgPreferencesInterface* self)
{
	return G_STRUCT_MEMBER_P (self, GitgPreferencesInterface_private_offset);
}

static void
gitg_preferences_interface_update_system_font_label (GitgPreferencesInterface* self)
{
	gchar* system_fontname = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* label = NULL;
	gchar* _tmp2_;
	GtkCheckButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_global_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "monospace-font-name");
	system_fontname = _tmp1_;
	_tmp2_ = g_strdup_printf (_ ("_Use the system fixed width font (%s)"), system_fontname);
	label = _tmp2_;
	_tmp3_ = self->priv->d_default_font_checkbutton;
	gtk_button_set_label ((GtkButton*) _tmp3_, label);
	_g_free0 (label);
	_g_free0 (system_fontname);
}

static void
_gitg_preferences_interface_orientation_changed_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self)
{
	gitg_preferences_interface_orientation_changed ((GitgPreferencesInterface*) self, _sender, key);
}

static void
gitg_preferences_interface_real_dispose (GObject* base)
{
	GitgPreferencesInterface * self;
	GSettings* _tmp0_;
	self = (GitgPreferencesInterface*) base;
	_tmp0_ = self->priv->d_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		guint _tmp2_;
		GQuark _tmp3_;
		_tmp1_ = self->priv->d_settings;
		g_signal_parse_name ("changed::orientation", g_settings_get_type (), &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _gitg_preferences_interface_orientation_changed_g_settings_changed, self);
		_g_object_unref0 (self->priv->d_settings);
		self->priv->d_settings = NULL;
	}
	G_OBJECT_CLASS (gitg_preferences_interface_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
}

static void
gitg_preferences_interface_orientation_changed (GitgPreferencesInterface* self,
                                                GSettings* settings,
                                                const gchar* key)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	self->priv->d_block = TRUE;
	_tmp0_ = self->priv->d_horizontal_layout_enabled;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, g_settings_get_enum (settings, key) == 0);
	self->priv->d_block = FALSE;
}

GitgPreferencesInterface*
gitg_preferences_interface_construct (GType object_type)
{
	GitgPreferencesInterface * self = NULL;
	self = (GitgPreferencesInterface*) g_object_new (object_type, NULL);
	return self;
}

GitgPreferencesInterface*
gitg_preferences_interface_new (void)
{
	return gitg_preferences_interface_construct (GITG_TYPE_PREFERENCES_INTERFACE);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
gitg_preferences_interface_real_get_widget (GitgExtPreferences* base)
{
	GtkWidget* result;
	GitgPreferencesInterface* self;
	GtkWidget* _tmp0_;
	self = (GitgPreferencesInterface*) base;
	_tmp0_ = _g_object_ref0 ((GtkWidget*) self);
	result = _tmp0_;
	return result;
}

static gchar*
gitg_preferences_interface_real_get_id (GitgExtPreferences* base)
{
	gchar* result;
	GitgPreferencesInterface* self;
	gchar* _tmp0_;
	self = (GitgPreferencesInterface*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/Preferences/Interface");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_preferences_interface_real_get_display_name (GitgExtPreferences* base)
{
	gchar* result;
	GitgPreferencesInterface* self;
	gchar* _tmp0_;
	self = (GitgPreferencesInterface*) base;
	_tmp0_ = g_strdup (_ ("Interface"));
	result = _tmp0_;
	return result;
}

static void
_gitg_preferences_interface___lambda140_ (GitgPreferencesInterface* self,
                                          GObject* obj,
                                          GParamSpec* spec)
{
	gint _tmp0_ = 0;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	if (self->priv->d_block) {
		return;
	}
	_tmp1_ = self->priv->d_horizontal_layout_enabled;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	_tmp4_ = self->priv->d_settings;
	if (!g_settings_set_enum (_tmp4_, "orientation", _tmp0_)) {
		GtkCheckButton* _tmp5_;
		GSettings* _tmp6_;
		_tmp5_ = self->priv->d_horizontal_layout_enabled;
		_tmp6_ = self->priv->d_settings;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, g_settings_get_enum (_tmp6_, "orientation") == 0);
	}
}

static void
__gitg_preferences_interface___lambda140__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_gitg_preferences_interface___lambda140_ ((GitgPreferencesInterface*) self, _sender, pspec);
}

static void
_gitg_preferences_interface___lambda141_ (GitgPreferencesInterface* self,
                                          GSettings* s,
                                          const gchar* k)
{
	g_return_if_fail (s != NULL);
	g_return_if_fail (k != NULL);
	gitg_preferences_interface_update_system_font_label (self);
}

static void
__gitg_preferences_interface___lambda141__g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self)
{
	_gitg_preferences_interface___lambda141_ ((GitgPreferencesInterface*) self, _sender, key);
}

static GObject *
gitg_preferences_interface_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgPreferencesInterface * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkCheckButton* _tmp2_;
	GSettings* _tmp3_;
	GtkCheckButton* _tmp4_;
	GtkSourceStyleSchemeManager* style_manager = NULL;
	GtkSourceStyleSchemeManager* _tmp5_;
	GtkSourceStyleSchemeManager* _tmp6_;
	GtkTreeIter iter = {0};
	GtkSourceStyleSchemeManager* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	GSettings* _tmp25_;
	GSettings* _tmp26_;
	GtkComboBox* _tmp27_;
	GSettings* _tmp28_;
	GtkCheckButton* _tmp29_;
	GSettings* _tmp30_;
	GtkCheckButton* _tmp31_;
	GSettings* _tmp32_;
	GtkCheckButton* _tmp33_;
	GSettings* _tmp34_;
	GtkComboBox* _tmp35_;
	GSettings* _tmp36_;
	GtkCheckButton* _tmp37_;
	GSettings* _tmp38_;
	GtkGrid* _tmp39_;
	GSettings* _tmp40_;
	GtkFontButton* _tmp41_;
	GSettings* _tmp42_;
	parent_class = G_OBJECT_CLASS (gitg_preferences_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_PREFERENCES_INTERFACE, GitgPreferencesInterface);
	_tmp0_ = g_settings_new (APPLICATION_ID ".preferences.interface");
	_g_object_unref0 (self->priv->d_settings);
	self->priv->d_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->d_global_settings);
	self->priv->d_global_settings = _tmp1_;
	_tmp2_ = self->priv->d_horizontal_layout_enabled;
	_tmp3_ = self->priv->d_settings;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, g_settings_get_enum (_tmp3_, "orientation") == 0);
	_tmp4_ = self->priv->d_horizontal_layout_enabled;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::active", (GCallback) __gitg_preferences_interface___lambda140__g_object_notify, self, 0);
	_tmp5_ = gtk_source_style_scheme_manager_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	style_manager = _tmp6_;
	_tmp7_ = style_manager;
	_tmp9_ = _tmp8_ = gtk_source_style_scheme_manager_get_scheme_ids (_tmp7_);
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp9_;
		id_collection_length1 = _vala_array_length (_tmp8_);
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			gchar* _tmp10_;
			gchar* id = NULL;
			_tmp10_ = g_strdup (id_collection[id_it]);
			id = _tmp10_;
			{
				GtkSourceStyleScheme* scheme = NULL;
				GtkSourceStyleSchemeManager* _tmp11_;
				const gchar* _tmp12_;
				GtkSourceStyleScheme* _tmp13_;
				GtkSourceStyleScheme* _tmp14_;
				GtkListStore* _tmp15_;
				GtkTreeIter _tmp16_ = {0};
				GtkListStore* _tmp17_;
				GtkTreeIter _tmp18_;
				GtkSourceStyleScheme* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				GtkSourceStyleScheme* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				_tmp11_ = style_manager;
				_tmp12_ = id;
				_tmp13_ = gtk_source_style_scheme_manager_get_scheme (_tmp11_, _tmp12_);
				_tmp14_ = _g_object_ref0 (_tmp13_);
				scheme = _tmp14_;
				_tmp15_ = self->priv->d_syntax_scheme_store;
				gtk_list_store_append (_tmp15_, &_tmp16_);
				iter = _tmp16_;
				_tmp17_ = self->priv->d_syntax_scheme_store;
				_tmp18_ = iter;
				_tmp19_ = scheme;
				_tmp20_ = gtk_source_style_scheme_get_name (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = scheme;
				_tmp23_ = gtk_source_style_scheme_get_id (_tmp22_);
				_tmp24_ = _tmp23_;
				gtk_list_store_set (_tmp17_, &_tmp18_, 0, _tmp21_, 1, _tmp24_, -1);
				_g_object_unref0 (scheme);
				_g_free0 (id);
			}
		}
	}
	_tmp25_ = self->priv->d_settings;
	g_signal_connect_object (_tmp25_, "changed::orientation", (GCallback) _gitg_preferences_interface_orientation_changed_g_settings_changed, self, 0);
	_tmp26_ = self->priv->d_settings;
	_tmp27_ = self->priv->d_default_activity;
	g_settings_bind (_tmp26_, "default-activity", (GObject*) _tmp27_, "active-id", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp28_ = self->priv->d_settings;
	_tmp29_ = self->priv->d_gravatar_enabled;
	g_settings_bind (_tmp28_, "use-gravatar", (GObject*) _tmp29_, "active", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp30_ = self->priv->d_settings;
	_tmp31_ = self->priv->d_monitoring_enabled;
	g_settings_bind (_tmp30_, "enable-monitoring", (GObject*) _tmp31_, "active", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp32_ = self->priv->d_settings;
	_tmp33_ = self->priv->d_diff_highlighting_enabled;
	g_settings_bind (_tmp32_, "enable-diff-highlighting", (GObject*) _tmp33_, "active", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp34_ = self->priv->d_settings;
	_tmp35_ = self->priv->d_default_style_scheme;
	g_settings_bind (_tmp34_, "style-scheme", (GObject*) _tmp35_, "active-id", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp36_ = self->priv->d_settings;
	_tmp37_ = self->priv->d_default_font_checkbutton;
	g_settings_bind (_tmp36_, "use-default-font", (GObject*) _tmp37_, "active", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp38_ = self->priv->d_settings;
	_tmp39_ = self->priv->d_font_button_grid;
	g_settings_bind (_tmp38_, "use-default-font", (GObject*) _tmp39_, "sensitive", (G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET) | G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp40_ = self->priv->d_settings;
	_tmp41_ = self->priv->d_font_button;
	g_settings_bind (_tmp40_, "monospace-font-name", (GObject*) _tmp41_, "font", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp42_ = self->priv->d_global_settings;
	g_signal_connect_object (_tmp42_, "changed::monospace-font-name", (GCallback) __gitg_preferences_interface___lambda141__g_settings_changed, self, 0);
	gitg_preferences_interface_update_system_font_label (self);
	_g_object_unref0 (style_manager);
	return obj;
}

static void
gitg_preferences_interface_class_init (GitgPreferencesInterfaceClass * klass,
                                       gpointer klass_data)
{
	gitg_preferences_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgPreferencesInterface_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_preferences_interface_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_preferences_interface_get_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_preferences_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_preferences_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PREFERENCES_INTERFACE_WIDGET_PROPERTY, gitg_preferences_interface_properties[GITG_PREFERENCES_INTERFACE_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PREFERENCES_INTERFACE_ID_PROPERTY, gitg_preferences_interface_properties[GITG_PREFERENCES_INTERFACE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_PREFERENCES_INTERFACE_DISPLAY_NAME_PROPERTY, gitg_preferences_interface_properties[GITG_PREFERENCES_INTERFACE_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-preferences-interface.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "horizontal_layout_enabled", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_horizontal_layout_enabled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "default_activity", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_default_activity));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "gravatar_enabled", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_gravatar_enabled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "monitoring_enabled", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_monitoring_enabled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_highlighting_enabled", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_diff_highlighting_enabled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "default_style_scheme", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_default_style_scheme));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "syntax_scheme_store", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_syntax_scheme_store));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "font_button", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_font_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "font_button_grid", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_font_button_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "default_font_checkbutton", FALSE, GitgPreferencesInterface_private_offset + G_STRUCT_OFFSET (GitgPreferencesInterfacePrivate, d_default_font_checkbutton));
}

static void
gitg_preferences_interface_gitg_ext_preferences_interface_init (GitgExtPreferencesIface * iface,
                                                                gpointer iface_data)
{
	gitg_preferences_interface_gitg_ext_preferences_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_widget = gitg_preferences_interface_real_get_widget;
	iface->get_id = gitg_preferences_interface_real_get_id;
	iface->get_display_name = gitg_preferences_interface_real_get_display_name;
}

static void
gitg_preferences_interface_instance_init (GitgPreferencesInterface * self,
                                          gpointer klass)
{
	self->priv = gitg_preferences_interface_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_preferences_interface_finalize (GObject * obj)
{
	GitgPreferencesInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_PREFERENCES_INTERFACE, GitgPreferencesInterface);
	_g_object_unref0 (self->priv->d_settings);
	_g_object_unref0 (self->priv->d_global_settings);
	G_OBJECT_CLASS (gitg_preferences_interface_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_preferences_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgPreferencesInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_preferences_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgPreferencesInterface), 0, (GInstanceInitFunc) gitg_preferences_interface_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_preferences_info = { (GInterfaceInitFunc) gitg_preferences_interface_gitg_ext_preferences_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_preferences_interface_type_id;
	gitg_preferences_interface_type_id = g_type_register_static (gtk_grid_get_type (), "GitgPreferencesInterface", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_preferences_interface_type_id, GITG_EXT_TYPE_PREFERENCES, &gitg_ext_preferences_info);
	GitgPreferencesInterface_private_offset = g_type_add_instance_private (gitg_preferences_interface_type_id, sizeof (GitgPreferencesInterfacePrivate));
	return gitg_preferences_interface_type_id;
}

GType
gitg_preferences_interface_get_type (void)
{
	static gsize gitg_preferences_interface_type_id__once = 0;
	if (g_once_init_enter (&gitg_preferences_interface_type_id__once)) {
		GType gitg_preferences_interface_type_id;
		gitg_preferences_interface_type_id = gitg_preferences_interface_get_type_once ();
		g_once_init_leave (&gitg_preferences_interface_type_id__once, gitg_preferences_interface_type_id);
	}
	return gitg_preferences_interface_type_id__once;
}

static void
_vala_gitg_preferences_interface_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GitgPreferencesInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_PREFERENCES_INTERFACE, GitgPreferencesInterface);
	switch (property_id) {
		case GITG_PREFERENCES_INTERFACE_WIDGET_PROPERTY:
		g_value_take_object (value, gitg_ext_preferences_get_widget ((GitgExtPreferences*) self));
		break;
		case GITG_PREFERENCES_INTERFACE_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_preferences_get_id ((GitgExtPreferences*) self));
		break;
		case GITG_PREFERENCES_INTERFACE_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_preferences_get_display_name ((GitgExtPreferences*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

