/* gitg-commit.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-commit.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <libgit2-glib/ggit.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_COMMIT_0_PROPERTY,
	GITG_COMMIT_TAG_PROPERTY,
	GITG_COMMIT_MYLANE_PROPERTY,
	GITG_COMMIT_LANE_PROPERTY,
	GITG_COMMIT_FORMAT_PATCH_NAME_PROPERTY,
	GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY_PROPERTY,
	GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY_PROPERTY,
	GITG_COMMIT_NUM_PROPERTIES
};
static GParamSpec* gitg_commit_properties[GITG_COMMIT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_note_unref0(var) ((var == NULL) ? NULL : (var = (ggit_note_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GitgCommitPrivate {
	GitgLaneTag _tag;
	guint d_mylane;
	GSList* d_lanes;
};

static gint GitgCommit_private_offset;
static gpointer gitg_commit_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void gitg_commit_update_lane_tag (GitgCommit* self);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_commit_finalize (GObject * obj);
static GType gitg_commit_get_type_once (void);
static void _vala_gitg_commit_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_gitg_commit_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
gitg_commit_get_instance_private (GitgCommit* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCommit_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GSList*
gitg_commit_get_lanes (GitgCommit* self)
{
	GSList* _tmp0_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_lanes;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GSList*
gitg_commit_insert_lane (GitgCommit* self,
                         GitgLane* lane,
                         gint idx)
{
	GitgLane* _tmp0_;
	GSList* _tmp1_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lane != NULL, NULL);
	_tmp0_ = _g_object_ref0 (lane);
	self->priv->d_lanes = g_slist_insert (self->priv->d_lanes, _tmp0_, idx);
	_tmp1_ = self->priv->d_lanes;
	result = _tmp1_;
	return result;
}

static GSList*
vala_g_slist_remove_full (GSList* self,
                          gconstpointer data,
                          GFreeFunc func)
{
	GSList* l = NULL;
	GSList* result;
	l = self;
	while (TRUE) {
		GSList* _tmp0_;
		GSList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GSList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GSList* _tmp3_;
			GSList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GSList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GSList* _tmp5_;
			gconstpointer _tmp6_;
			GSList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GSList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_slist_delete_link (self, (GSList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

GSList*
gitg_commit_remove_lane (GitgCommit* self,
                         GitgLane* lane)
{
	GSList* _tmp0_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lane != NULL, NULL);
	self->priv->d_lanes = vala_g_slist_remove_full (self->priv->d_lanes, lane, _g_object_unref0_);
	_tmp0_ = self->priv->d_lanes;
	result = _tmp0_;
	return result;
}

static void
gitg_commit_update_lane_tag (GitgCommit* self)
{
	GitgLane* lane = NULL;
	GSList* _tmp0_;
	gconstpointer _tmp1_;
	GitgLane* _tmp2_;
	GitgLane* _tmp3_;
	GitgLane* _tmp4_;
	GitgLaneTag _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_lanes;
	_tmp1_ = g_slist_nth_data (_tmp0_, self->priv->d_mylane);
	lane = (GitgLane*) _tmp1_;
	_tmp2_ = lane;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = lane;
	_tmp4_ = lane;
	_tmp5_ = self->priv->_tag;
	_tmp4_->tag = _tmp4_->tag & ((~((GITG_LANE_TAG_SIGN_STASH | GITG_LANE_TAG_SIGN_STAGED) | GITG_LANE_TAG_SIGN_UNSTAGED)) | _tmp5_);
}

void
gitg_commit_update_lanes (GitgCommit* self,
                          GSList* lanes,
                          gint mylane)
{
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lanes;
	lanes = NULL;
	(self->priv->d_lanes == NULL) ? NULL : (self->priv->d_lanes = (_g_slist_free__g_object_unref0_ (self->priv->d_lanes), NULL));
	self->priv->d_lanes = _tmp0_;
	if (mylane >= 0) {
		self->priv->d_mylane = (guint) ((gushort) mylane);
	}
	gitg_commit_update_lane_tag (self);
	(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
}

GgitDiff*
gitg_commit_get_diff (GitgCommit* self,
                      GgitDiffOptions* options,
                      gint parent)
{
	GgitDiff* diff = NULL;
	GgitRepository* repo = NULL;
	GgitRepository* _tmp0_;
	GgitDiff* _tmp33_;
	GError* _inner_error0_ = NULL;
	GgitDiff* result;
	g_return_val_if_fail (self != NULL, NULL);
	diff = NULL;
	_tmp0_ = ggit_object_get_owner ((GgitObject*) self);
	repo = _tmp0_;
	{
		GgitCommitParents* parents = NULL;
		GgitCommitParents* _tmp1_;
		GgitCommitParents* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		_tmp1_ = ggit_commit_get_parents ((GgitCommit*) self);
		parents = _tmp1_;
		_tmp2_ = parents;
		_tmp3_ = ggit_commit_parents_get_size (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == ((guint) 0)) {
			GgitDiff* _tmp5_ = NULL;
			GgitRepository* _tmp6_;
			GgitTree* _tmp7_;
			GgitTree* _tmp8_;
			GgitDiff* _tmp9_;
			GgitDiff* _tmp10_;
			GgitDiff* _tmp11_;
			_tmp6_ = repo;
			_tmp7_ = ggit_commit_get_tree ((GgitCommit*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = ggit_diff_new_tree_to_tree (_tmp6_, NULL, _tmp8_, options, &_inner_error0_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_tmp5_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parents);
				goto __catch0_g_error;
			}
			_tmp11_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (diff);
			diff = _tmp11_;
			_g_object_unref0 (_tmp5_);
		} else {
			GgitCommitParents* _tmp12_;
			guint _tmp13_;
			guint _tmp14_;
			GgitDiff* _tmp18_ = NULL;
			GgitRepository* _tmp19_;
			GgitCommitParents* _tmp20_;
			GgitCommit* _tmp21_;
			GgitCommit* _tmp22_;
			GgitTree* _tmp23_;
			GgitTree* _tmp24_;
			GgitTree* _tmp25_;
			GgitTree* _tmp26_;
			GgitDiff* _tmp27_;
			GgitDiff* _tmp28_;
			GgitDiff* _tmp29_;
			_tmp12_ = parents;
			_tmp13_ = ggit_commit_parents_get_size (_tmp12_);
			_tmp14_ = _tmp13_;
			if (((guint) parent) >= _tmp14_) {
				GgitCommitParents* _tmp15_;
				guint _tmp16_;
				guint _tmp17_;
				_tmp15_ = parents;
				_tmp16_ = ggit_commit_parents_get_size (_tmp15_);
				_tmp17_ = _tmp16_;
				parent = ((gint) _tmp17_) - 1;
			}
			_tmp19_ = repo;
			_tmp20_ = parents;
			_tmp21_ = ggit_commit_parents_get (_tmp20_, (guint) parent);
			_tmp22_ = _tmp21_;
			_tmp23_ = ggit_commit_get_tree (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = ggit_commit_get_tree ((GgitCommit*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = ggit_diff_new_tree_to_tree (_tmp19_, _tmp24_, _tmp26_, options, &_inner_error0_);
			_tmp28_ = _tmp27_;
			_g_object_unref0 (_tmp26_);
			_g_object_unref0 (_tmp24_);
			_g_object_unref0 (_tmp22_);
			_tmp18_ = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parents);
				goto __catch0_g_error;
			}
			_tmp29_ = _tmp18_;
			_tmp18_ = NULL;
			_g_object_unref0 (diff);
			diff = _tmp29_;
			_g_object_unref0 (_tmp18_);
		}
		_g_object_unref0 (parents);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = stderr;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		fprintf (_tmp30_, "Error when getting diff: %s\n", _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (repo);
		_g_object_unref0 (diff);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp33_ = diff;
	if (_tmp33_ != NULL) {
		{
			GgitDiff* _tmp34_;
			_tmp34_ = diff;
			ggit_diff_find_similar (_tmp34_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repo);
			_g_object_unref0 (diff);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = diff;
	_g_object_unref0 (repo);
	return result;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

GgitNote*
gitg_commit_get_note (GitgCommit* self)
{
	GgitNote* note = NULL;
	GgitRepository* repo = NULL;
	GgitRepository* _tmp0_;
	GError* _inner_error0_ = NULL;
	GgitNote* result;
	g_return_val_if_fail (self != NULL, NULL);
	note = NULL;
	_tmp0_ = ggit_object_get_owner ((GgitObject*) self);
	repo = _tmp0_;
	{
		GgitNote* _tmp1_ = NULL;
		GgitOId* _tmp2_;
		GgitOId* _tmp3_;
		GgitNote* _tmp4_;
		GgitNote* _tmp5_;
		GgitNote* _tmp6_;
		_tmp2_ = ggit_object_get_id ((GgitObject*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = ggit_repository_read_note (repo, NULL, _tmp3_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		__vala_GgitOId_free0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_ggit_note_unref0 (note);
		note = _tmp6_;
		_ggit_note_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (repo);
		_ggit_note_unref0 (note);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = note;
	_g_object_unref0 (repo);
	return result;
}

GitgCommit*
gitg_commit_construct (GType object_type)
{
	GitgCommit * self = NULL;
	self = (GitgCommit*) g_object_new (object_type, NULL);
	return self;
}

GitgCommit*
gitg_commit_new (void)
{
	return gitg_commit_construct (GITG_TYPE_COMMIT);
}

GitgLaneTag
gitg_commit_get_tag (GitgCommit* self)
{
	GitgLaneTag result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_tag;
	return result;
}

void
gitg_commit_set_tag (GitgCommit* self,
                     GitgLaneTag value)
{
	GitgLaneTag old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_get_tag (self);
	if (old_value != value) {
		self->priv->_tag = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_properties[GITG_COMMIT_TAG_PROPERTY]);
	}
}

guint
gitg_commit_get_mylane (GitgCommit* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->d_mylane;
	return result;
}

void
gitg_commit_set_mylane (GitgCommit* self,
                        guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->d_mylane = value;
	gitg_commit_update_lane_tag (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_properties[GITG_COMMIT_MYLANE_PROPERTY]);
}

GitgLane*
gitg_commit_get_lane (GitgCommit* self)
{
	GitgLane* result;
	GSList* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_lanes;
	_tmp1_ = g_slist_nth_data (_tmp0_, self->priv->d_mylane);
	result = (GitgLane*) _tmp1_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
gitg_commit_get_format_patch_name (GitgCommit* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ggit_commit_get_subject ((GgitCommit*) self);
	_tmp1_ = string_replace (_tmp0_, " ", "-");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "/", "-");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

gchar*
gitg_commit_get_committer_date_for_display (GitgCommit* self)
{
	gchar* result;
	GDateTime* dt = NULL;
	GgitSignature* _tmp0_;
	GgitSignature* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GitgDate* _tmp4_;
	GitgDate* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ggit_commit_get_committer ((GgitCommit*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_signature_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	dt = _tmp3_;
	_tmp4_ = gitg_date_new_for_date_time (dt);
	_tmp5_ = _tmp4_;
	_tmp6_ = gitg_date_for_display (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	result = _tmp7_;
	_g_date_time_unref0 (dt);
	return result;
}

gchar*
gitg_commit_get_author_date_for_display (GitgCommit* self)
{
	gchar* result;
	GDateTime* dt = NULL;
	GgitSignature* _tmp0_;
	GgitSignature* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GitgDate* _tmp4_;
	GitgDate* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ggit_commit_get_author ((GgitCommit*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_signature_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	dt = _tmp3_;
	_tmp4_ = gitg_date_new_for_date_time (dt);
	_tmp5_ = _tmp4_;
	_tmp6_ = gitg_date_for_display (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	result = _tmp7_;
	_g_date_time_unref0 (dt);
	return result;
}

static void
gitg_commit_class_init (GitgCommitClass * klass,
                        gpointer klass_data)
{
	gitg_commit_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgCommit_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_commit_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_commit_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_commit_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_TAG_PROPERTY, gitg_commit_properties[GITG_COMMIT_TAG_PROPERTY] = g_param_spec_flags ("tag", "tag", "tag", GITG_TYPE_LANE_TAG, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_MYLANE_PROPERTY, gitg_commit_properties[GITG_COMMIT_MYLANE_PROPERTY] = g_param_spec_uint ("mylane", "mylane", "mylane", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_LANE_PROPERTY, gitg_commit_properties[GITG_COMMIT_LANE_PROPERTY] = g_param_spec_object ("lane", "lane", "lane", GITG_TYPE_LANE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_FORMAT_PATCH_NAME_PROPERTY, gitg_commit_properties[GITG_COMMIT_FORMAT_PATCH_NAME_PROPERTY] = g_param_spec_string ("format-patch-name", "format-patch-name", "format-patch-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY_PROPERTY, gitg_commit_properties[GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY_PROPERTY] = g_param_spec_string ("committer-date-for-display", "committer-date-for-display", "committer-date-for-display", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY_PROPERTY, gitg_commit_properties[GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY_PROPERTY] = g_param_spec_string ("author-date-for-display", "author-date-for-display", "author-date-for-display", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_commit_instance_init (GitgCommit * self,
                           gpointer klass)
{
	self->priv = gitg_commit_get_instance_private (self);
}

static void
gitg_commit_finalize (GObject * obj)
{
	GitgCommit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_COMMIT, GitgCommit);
	(self->priv->d_lanes == NULL) ? NULL : (self->priv->d_lanes = (_g_slist_free__g_object_unref0_ (self->priv->d_lanes), NULL));
	G_OBJECT_CLASS (gitg_commit_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_commit_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCommitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_commit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCommit), 0, (GInstanceInitFunc) gitg_commit_instance_init, NULL };
	GType gitg_commit_type_id;
	gitg_commit_type_id = g_type_register_static (ggit_commit_get_type (), "GitgCommit", &g_define_type_info, 0);
	GitgCommit_private_offset = g_type_add_instance_private (gitg_commit_type_id, sizeof (GitgCommitPrivate));
	return gitg_commit_type_id;
}

GType
gitg_commit_get_type (void)
{
	static gsize gitg_commit_type_id__once = 0;
	if (g_once_init_enter (&gitg_commit_type_id__once)) {
		GType gitg_commit_type_id;
		gitg_commit_type_id = gitg_commit_get_type_once ();
		g_once_init_leave (&gitg_commit_type_id__once, gitg_commit_type_id);
	}
	return gitg_commit_type_id__once;
}

static void
_vala_gitg_commit_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	GitgCommit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT, GitgCommit);
	switch (property_id) {
		case GITG_COMMIT_TAG_PROPERTY:
		g_value_set_flags (value, gitg_commit_get_tag (self));
		break;
		case GITG_COMMIT_MYLANE_PROPERTY:
		g_value_set_uint (value, gitg_commit_get_mylane (self));
		break;
		case GITG_COMMIT_LANE_PROPERTY:
		g_value_set_object (value, gitg_commit_get_lane (self));
		break;
		case GITG_COMMIT_FORMAT_PATCH_NAME_PROPERTY:
		g_value_take_string (value, gitg_commit_get_format_patch_name (self));
		break;
		case GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY_PROPERTY:
		g_value_take_string (value, gitg_commit_get_committer_date_for_display (self));
		break;
		case GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY_PROPERTY:
		g_value_take_string (value, gitg_commit_get_author_date_for_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_commit_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	GitgCommit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT, GitgCommit);
	switch (property_id) {
		case GITG_COMMIT_TAG_PROPERTY:
		gitg_commit_set_tag (self, g_value_get_flags (value));
		break;
		case GITG_COMMIT_MYLANE_PROPERTY:
		gitg_commit_set_mylane (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

