/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_cpm = R"doc(Return the taps for an interpolating FIR filter (gr::filter::interp_fir_filter_fff).)doc";


static const char* __doc_gr_analog_cpm_cpm_0 = R"doc()doc";


static const char* __doc_gr_analog_cpm_cpm_1 = R"doc()doc";


static const char* __doc_gr_analog_cpm_phase_response = R"doc(Return the taps for an interpolating FIR filter (gr::filter::interp_fir_filter_fff).

These taps represent the phase response  for use in a CPM modulator, see also gr_cpmmod_bc.



Output: returns a vector of length  =  x . This can be used directly in an interpolating FIR filter such as gr_interp_fir_filter_fff with interpolation factor .


All phase responses are normalised s.t.  ; this will cause a maximum phase change of   between two symbols, where  is the modulation index.


The following phase responses can be generated:



A short description of all these phase responses can be found in [1].


[1]: Anderson, Aulin and Sundberg; Digital Phase Modulation)doc";
