/*
 * Copyright 2022 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_crc_check = R"doc(Check the CRC at the end of a PDU.

The CRC check block receives a PDU containing a CRC at its end, and checks whether the CRC is correct. The PDU is sent over the ok or fail output ports according to the result of this check. It can support any CRC whose size is a multiple of 8 bits between 8 and 64 bits.

Constructor Specific Documentation:

Build the CRC check block.

Args:
    num_bits : CRC size in bits (must be a multiple of 8)
    poly : CRC polynomial, in MSB-first notation
    initial_value : Initial register value
    final_xor : Final XOR value
    input_reflected : true if the input is LSB-first, false if not
    result_reflected : true if the output is LSB-first, false if not
    swap_endianness : true if the CRC is stored as little-endian in the PDU, false if not
    discard_crc : If true, the CRC is removed from the PDU before sending it to the output port. If false, the CRC is preserved in the output PDU.
    skip_header_bytes : gives the number of header byte to skip in the CRC calculation)doc";


static const char* __doc_gr_digital_crc_check_crc_check = R"doc()doc";


static const char* __doc_gr_digital_crc_check_make = R"doc(Check the CRC at the end of a PDU.

The CRC check block receives a PDU containing a CRC at its end, and checks whether the CRC is correct. The PDU is sent over the ok or fail output ports according to the result of this check. It can support any CRC whose size is a multiple of 8 bits between 8 and 64 bits.

Constructor Specific Documentation:

Build the CRC check block.

Args:
    num_bits : CRC size in bits (must be a multiple of 8)
    poly : CRC polynomial, in MSB-first notation
    initial_value : Initial register value
    final_xor : Final XOR value
    input_reflected : true if the input is LSB-first, false if not
    result_reflected : true if the output is LSB-first, false if not
    swap_endianness : true if the CRC is stored as little-endian in the PDU, false if not
    discard_crc : If true, the CRC is removed from the PDU before sending it to the output port. If false, the CRC is preserved in the output PDU.
    skip_header_bytes : gives the number of header byte to skip in the CRC calculation)doc";
