/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_msk_timing_recovery_cc = R"doc(MSK/GMSK timing recovery.

This block performs timing synchronization on CPM modulations using a fourth-order nonlinearity feedback method which is non-data-aided. The block does not require prior phase synchronization but is relatively sensitive to frequency offset (keep offset to 0.1x symbol rate).


For details on the algorithm, see: A.N. D'Andrea, U. Mengali, R. Reggiannini: A digital approach to clock recovery in generalized minimum shift keying. IEEE Transactions on Vehicular Technology, Vol. 39, Issue 3.

Constructor Specific Documentation:

Make an MSK timing recovery block.

Args:
    sps : Samples per symbol
    gain : Loop gain of timing error filter (try 0.05)
    limit : Relative limit of timing error (try 0.1 for 10% error max)
    osps : Output samples per symbol)doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_msk_timing_recovery_cc_0 =
    R"doc()doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_msk_timing_recovery_cc_1 =
    R"doc()doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_make = R"doc(MSK/GMSK timing recovery.

This block performs timing synchronization on CPM modulations using a fourth-order nonlinearity feedback method which is non-data-aided. The block does not require prior phase synchronization but is relatively sensitive to frequency offset (keep offset to 0.1x symbol rate).


For details on the algorithm, see: A.N. D'Andrea, U. Mengali, R. Reggiannini: A digital approach to clock recovery in generalized minimum shift keying. IEEE Transactions on Vehicular Technology, Vol. 39, Issue 3.

Constructor Specific Documentation:

Make an MSK timing recovery block.

Args:
    sps : Samples per symbol
    gain : Loop gain of timing error filter (try 0.05)
    limit : Relative limit of timing error (try 0.1 for 10% error max)
    osps : Output samples per symbol)doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_set_gain = R"doc()doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_get_gain = R"doc()doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_set_limit = R"doc()doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_get_limit = R"doc()doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_set_sps = R"doc()doc";


static const char* __doc_gr_digital_msk_timing_recovery_cc_get_sps = R"doc()doc";
