/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_ofdm_frame_equalizer_vcvc = R"doc(OFDM frame equalizer.

Performs equalization in one or two dimensions on a tagged OFDM frame.


This does two things: First, it removes the coarse carrier offset. If a tag is found on the first item with the key 'ofdm_sync_carr_offset', this is interpreted as the coarse frequency offset in number of carriers. Next, it performs equalization in one or two dimensions on a tagged OFDM frame. The actual equalization is done by a ofdm_frame_equalizer object, outside of the block.


Note that the tag with the coarse carrier offset is not removed. Blocks downstream from this block must not attempt to also correct this offset.


Input: a tagged series of OFDM symbols. Output: The same as the input, but equalized and frequency-corrected.

Constructor Specific Documentation:



Args:
    equalizer : The equalizer object that will do the actual work
    cp_len : Length of the cyclic prefix in samples (required to correct the frequency offset)
    tsb_key : TSB key
    propagate_channel_state : If true, the channel state after the last symbol will be added to the first symbol as a tag
    fixed_frame_len : Set if the frame length is fixed. When this value is given, the TSB tag key can be left empty, but it is useful even when using tagged streams at the input.)doc";


static const char* __doc_gr_digital_ofdm_frame_equalizer_vcvc_ofdm_frame_equalizer_vcvc =
    R"doc()doc";


static const char* __doc_gr_digital_ofdm_frame_equalizer_vcvc_make = R"doc(OFDM frame equalizer.

Performs equalization in one or two dimensions on a tagged OFDM frame.


This does two things: First, it removes the coarse carrier offset. If a tag is found on the first item with the key 'ofdm_sync_carr_offset', this is interpreted as the coarse frequency offset in number of carriers. Next, it performs equalization in one or two dimensions on a tagged OFDM frame. The actual equalization is done by a ofdm_frame_equalizer object, outside of the block.


Note that the tag with the coarse carrier offset is not removed. Blocks downstream from this block must not attempt to also correct this offset.


Input: a tagged series of OFDM symbols. Output: The same as the input, but equalized and frequency-corrected.

Constructor Specific Documentation:



Args:
    equalizer : The equalizer object that will do the actual work
    cp_len : Length of the cyclic prefix in samples (required to correct the frequency offset)
    tsb_key : TSB key
    propagate_channel_state : If true, the channel state after the last symbol will be added to the first symbol as a tag
    fixed_frame_len : Set if the frame length is fixed. When this value is given, the TSB tag key can be left empty, but it is useful even when using tagged streams at the input.)doc";
