/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvb_bbheader_bb = R"doc(Formats MPEG-2 Transport Stream packets into FEC baseband frames and adds a 10-byte header.

Input: 188-byte MPEG-2 Transport Stream packets. 
Output: Variable length FEC baseband frames (BBFRAME). The output frame length is based on the FEC rate.

Constructor Specific Documentation:

Create a baseband header formatter.

Args:
    standard : DVB standard (DVB-S2 or DVB-T2).
    framesize : FEC frame size (normal, medium or short).
    rate : FEC code rate.
    rolloff : DVB-S2 root-raised-cosine filter roll-off.
    mode : DVB-T2 input processing mode.
    inband : DVB-T2 Type B in-band signalling.
    fecblocks : DVB-T2 number of FEC block for in-band signalling.
    tsrate : DVB-T2 Transport Stream rate for in-band signalling.)doc";


static const char* __doc_gr_dtv_dvb_bbheader_bb_dvb_bbheader_bb = R"doc()doc";


static const char* __doc_gr_dtv_dvb_bbheader_bb_make = R"doc(Formats MPEG-2 Transport Stream packets into FEC baseband frames and adds a 10-byte header.

Input: 188-byte MPEG-2 Transport Stream packets. 
Output: Variable length FEC baseband frames (BBFRAME). The output frame length is based on the FEC rate.

Constructor Specific Documentation:

Create a baseband header formatter.

Args:
    standard : DVB standard (DVB-S2 or DVB-T2).
    framesize : FEC frame size (normal, medium or short).
    rate : FEC code rate.
    rolloff : DVB-S2 root-raised-cosine filter roll-off.
    mode : DVB-T2 input processing mode.
    inband : DVB-T2 Type B in-band signalling.
    fecblocks : DVB-T2 number of FEC block for in-band signalling.
    tsrate : DVB-T2 Transport Stream rate for in-band signalling.)doc";
