/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_energy_descramble = R"doc(Energy descramble.

ETSI EN 300 744 - Clause 4.3.1. 
Input - Randomized MPEG-2 transport packets. 
Output - MPEG-2 transport packets (including sync - 0x47). 
We assume the first byte is a NSYNC. 
First sync in a row of 8 packets is reversed - 0xB8. 
Block size is 188 bytes

Constructor Specific Documentation:

Create DVB-T Energy descramble.

Args:
    nblocks : number of blocks.)doc";


static const char* __doc_gr_dtv_dvbt_energy_descramble_dvbt_energy_descramble =
    R"doc()doc";


static const char* __doc_gr_dtv_dvbt_energy_descramble_make = R"doc(Energy descramble.

ETSI EN 300 744 - Clause 4.3.1. 
Input - Randomized MPEG-2 transport packets. 
Output - MPEG-2 transport packets (including sync - 0x47). 
We assume the first byte is a NSYNC. 
First sync in a row of 8 packets is reversed - 0xB8. 
Block size is 188 bytes

Constructor Specific Documentation:

Create DVB-T Energy descramble.

Args:
    nblocks : number of blocks.)doc";
