/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_ofdm_sym_acquisition = R"doc(OFDM symbol acquisition.

Data input format: 
complex(real(float), imag(float)). 
Data output format: 
complex(real(float), imag(float)).

Constructor Specific Documentation:

Create OFDM symbol acquisition.

Args:
    blocks : Always equal to 1.
    fft_length : FFT size, 2048 or 8192.
    occupied_tones : Active OFDM carriers, 1705 or 6817.
    cp_length : Length of Cyclic Prefix (FFT size / 32, 16, 8 or 4).
    snr : Initial Signal to Noise Ratio.)doc";


static const char* __doc_gr_dtv_dvbt_ofdm_sym_acquisition_dvbt_ofdm_sym_acquisition =
    R"doc()doc";


static const char* __doc_gr_dtv_dvbt_ofdm_sym_acquisition_make = R"doc(OFDM symbol acquisition.

Data input format: 
complex(real(float), imag(float)). 
Data output format: 
complex(real(float), imag(float)).

Constructor Specific Documentation:

Create OFDM symbol acquisition.

Args:
    blocks : Always equal to 1.
    fft_length : FFT size, 2048 or 8192.
    occupied_tones : Active OFDM carriers, 1705 or 6817.
    cp_length : Length of Cyclic Prefix (FFT size / 32, 16, 8 or 4).
    snr : Initial Signal to Noise Ratio.)doc";
