/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_time_sink_f = R"doc(A graphical sink to display multiple signals in time.

This is a QT-based graphical sink the takes set of a float streams and plots them in the time domain. Each signal is plotted with a different color, and the  and  functions can be used to change the label and color for a given input number.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.

Constructor Specific Documentation:

Build floating point time sink.

Args:
    size : number of points to plot at once
    samp_rate : sample rate (used to set x-axis labels)
    name : title for the plot
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_time_sink_f_time_sink_f_0 = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_time_sink_f_1 = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_make = R"doc(A graphical sink to display multiple signals in time.

This is a QT-based graphical sink the takes set of a float streams and plots them in the time domain. Each signal is plotted with a different color, and the  and  functions can be used to change the label and color for a given input number.


The sink supports plotting streaming float data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Float Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of float 32 values (pmt::is_f32vector) or PDUs where the data is a uniform vector of float 32 values.

Constructor Specific Documentation:

Build floating point time sink.

Args:
    size : number of points to plot at once
    samp_rate : sample rate (used to set x-axis labels)
    name : title for the plot
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_time_sink_f_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_y_axis = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_y_label = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_nsamps = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_samp_rate = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_trigger_mode = R"doc(Set up a trigger for the sink to know when to start plotting. Useful to isolate events and avoid noise.


The trigger modes are Free, Auto, Normal, and Tag (see gr::qtgui::trigger_mode). The first three are like a normal oscope trigger function. Free means free running with no trigger, auto will trigger if the trigger event is seen, but will still plot otherwise, and normal will hold until the trigger event is observed. The Tag trigger mode allows us to trigger off a specific stream tag. The tag trigger is based only on the name of the tag, so when a tag of the given name is seen, the trigger is activated.


In auto and normal mode, we look for the slope of the of the signal. Given a gr::qtgui::trigger_slope as either Positive or Negative, if the value between two samples moves in the given direction (x[1] > x[0] for Positive or x[1] < x[0] for Negative), then the trigger is activated.


The  value is specified in time based off the sample rate. If the sample rate of the block is set to 1, the delay is then also the sample number offset. This is the offset from the left-hand y-axis of the plot. It delays the signal to show the trigger event at the given delay along with some portion of the signal before the event. The delay must be within 0 - t_max where t_max is the maximum amount of time displayed on the time plot.)doc";


static const char* __doc_gr_qtgui_time_sink_f_title = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_stem_plot = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_semilogx = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_semilogy = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_control_panel = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_tags_0 = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_tags_1 = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_enable_axis_labels = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_disable_legend = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_nsamps = R"doc()doc";


static const char* __doc_gr_qtgui_time_sink_f_reset = R"doc()doc";
