/* DateTime.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DateTime.vala, do not modify */

/*
 * Copyright 2012-2017 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite-7.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <math.h>
#include <float.h>
#include <glib-object.h>
#include <gio/gio.h>

#define GRANITE_GETTEXT_PACKAGE "granite-7"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GRANITE_PORTAL_TYPE_SETTINGS (granite_portal_settings_get_type ())
#define GRANITE_PORTAL_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_PORTAL_TYPE_SETTINGS, GranitePortalSettings))
#define GRANITE_PORTAL_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_PORTAL_TYPE_SETTINGS))
#define GRANITE_PORTAL_SETTINGS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_PORTAL_TYPE_SETTINGS, GranitePortalSettingsIface))

typedef struct _GranitePortalSettings GranitePortalSettings;
typedef struct _GranitePortalSettingsIface GranitePortalSettingsIface;

#define GRANITE_PORTAL_TYPE_SETTINGS_PROXY (granite_portal_settings_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GranitePortalSettingsIface {
	GTypeInterface parent_iface;
	GHashTable* (*read_all) (GranitePortalSettings* self, gchar** namespaces, gint namespaces_length1, GError** error);
	GVariant* (*read) (GranitePortalSettings* self, const gchar* namespace, const gchar* key, GError** error);
};

 G_GNUC_INTERNAL gboolean granite_date_time_is_clock_format_12h (void);
VALA_EXTERN GType granite_portal_settings_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint granite_portal_settings_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
 G_GNUC_INTERNAL GType granite_portal_settings_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GranitePortalSettings* granite_portal_settings_get (GError** error);
 G_GNUC_INTERNAL GVariant* granite_portal_settings_read (GranitePortalSettings* self,
                                        const gchar* namespace,
                                        const gchar* key,
                                        GError** error);

/**
     * Gets a default translated time format.
     * The function constructs a new string interpreting the //is_12h// and //with_second// parameters
     * so that it can be used with formatting functions like {@link GLib.DateTime.format}.
     *
     * The returned string is formatted and translated. This function is mostly used to display
     * the time in various user interfaces like the time displayed in the top panel.
     *
     * @param is_12h if the returned string should be formatted in 12h format
     * @param with_second if the returned string should include seconds
     *
     * @return the formatted and located time string.
     */
gchar*
granite_date_time_get_default_time_format (gboolean is_12h,
                                           gboolean with_second)
{
	gchar* result;
	if (is_12h == TRUE) {
		if (with_second == TRUE) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("%-l:%M:%S %p"));
			result = _tmp0_;
			return result;
		} else {
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("%-l:%M %p"));
			result = _tmp1_;
			return result;
		}
	} else {
		if (with_second == TRUE) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("%H:%M:%S"));
			result = _tmp2_;
			return result;
		} else {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("%H:%M"));
			result = _tmp3_;
			return result;
		}
	}
}

/**
     * Compares a {@link GLib.DateTime} to {@link GLib.DateTime.now_local} and returns a location, relative date and
     * time string. Results appear as natural-language strings like "Now", "5m ago", "Yesterday"
     *
     * @param date_time a {@link GLib.DateTime} to compare against {@link GLib.DateTime.now_local}
     *
     * @return a localized, relative date and time string
     */
gchar*
granite_date_time_get_relative_datetime (GDateTime* date_time)
{
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GTimeSpan diff = 0LL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* result;
	g_return_val_if_fail (date_time != NULL, NULL);
	if (g_date_time_to_unix (date_time) == ((gint64) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (_ ("Never"));
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = now;
	diff = g_date_time_difference (_tmp2_, date_time);
	_tmp3_ = now;
	if (granite_date_time_is_same_day (date_time, _tmp3_)) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		if (diff > ((GTimeSpan) 0)) {
			if (diff < G_TIME_SPAN_MINUTE) {
				gchar* _tmp4_;
				_tmp4_ = g_strdup (_ ("Now"));
				result = _tmp4_;
				_g_date_time_unref0 (now);
				return result;
			} else {
				if (diff < G_TIME_SPAN_HOUR) {
					GTimeSpan minutes = 0LL;
					gchar* _tmp5_;
					minutes = diff / G_TIME_SPAN_MINUTE;
					_tmp5_ = g_strdup_printf (g_dngettext (GRANITE_GETTEXT_PACKAGE, "%dm ago", "%dm ago", (gulong) minutes), (gint) minutes);
					result = _tmp5_;
					_g_date_time_unref0 (now);
					return result;
				} else {
					if (diff < (12 * G_TIME_SPAN_HOUR)) {
						gint rounded = 0;
						gchar* _tmp6_;
						rounded = (gint) round (((gdouble) diff) / G_TIME_SPAN_HOUR);
						_tmp6_ = g_strdup_printf (g_dngettext (GRANITE_GETTEXT_PACKAGE, "%dh ago", "%dh ago", (gulong) rounded), rounded);
						result = _tmp6_;
						_g_date_time_unref0 (now);
						return result;
					}
				}
			}
		} else {
			diff = -1 * diff;
			if (diff < G_TIME_SPAN_HOUR) {
				GTimeSpan minutes = 0LL;
				gchar* _tmp7_;
				minutes = diff / G_TIME_SPAN_MINUTE;
				_tmp7_ = g_strdup_printf (g_dngettext (GRANITE_GETTEXT_PACKAGE, "in %dm", "in %dm", (gulong) minutes), (gint) minutes);
				result = _tmp7_;
				_g_date_time_unref0 (now);
				return result;
			} else {
				if (diff < (12 * G_TIME_SPAN_HOUR)) {
					gint rounded = 0;
					gchar* _tmp8_;
					rounded = (gint) round (((gdouble) diff) / G_TIME_SPAN_HOUR);
					_tmp8_ = g_strdup_printf (g_dngettext (GRANITE_GETTEXT_PACKAGE, "in %dh", "in %dh", (gulong) rounded), rounded);
					result = _tmp8_;
					_g_date_time_unref0 (now);
					return result;
				}
			}
		}
		_tmp9_ = granite_date_time_get_default_time_format (granite_date_time_is_clock_format_12h (), FALSE);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_date_time_format (date_time, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		result = _tmp12_;
		_g_date_time_unref0 (now);
		return result;
	} else {
		GDateTime* _tmp13_;
		GDateTime* _tmp14_;
		GDateTime* _tmp15_;
		gboolean _tmp16_;
		_tmp13_ = g_date_time_add_days (date_time, 1);
		_tmp14_ = _tmp13_;
		_tmp15_ = now;
		_tmp16_ = granite_date_time_is_same_day (_tmp14_, _tmp15_);
		_g_date_time_unref0 (_tmp14_);
		if (_tmp16_) {
			gchar* _tmp17_;
			_tmp17_ = g_strdup (_ ("Yesterday"));
			result = _tmp17_;
			_g_date_time_unref0 (now);
			return result;
		} else {
			GDateTime* _tmp18_;
			GDateTime* _tmp19_;
			GDateTime* _tmp20_;
			gboolean _tmp21_;
			_tmp18_ = g_date_time_add_days (date_time, -1);
			_tmp19_ = _tmp18_;
			_tmp20_ = now;
			_tmp21_ = granite_date_time_is_same_day (_tmp19_, _tmp20_);
			_g_date_time_unref0 (_tmp19_);
			if (_tmp21_) {
				gchar* _tmp22_;
				_tmp22_ = g_strdup (_ ("Tomorrow"));
				result = _tmp22_;
				_g_date_time_unref0 (now);
				return result;
			} else {
				gboolean _tmp23_ = FALSE;
				if (diff < (6 * G_TIME_SPAN_DAY)) {
					_tmp23_ = diff > (-6 * G_TIME_SPAN_DAY);
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp24_ = granite_date_time_get_default_date_format (TRUE, FALSE, FALSE);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_date_time_format (date_time, _tmp25_);
					_tmp27_ = _tmp26_;
					_g_free0 (_tmp25_);
					result = _tmp27_;
					_g_date_time_unref0 (now);
					return result;
				} else {
					GDateTime* _tmp28_;
					_tmp28_ = now;
					if (g_date_time_get_year (date_time) == g_date_time_get_year (_tmp28_)) {
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						_tmp29_ = granite_date_time_get_default_date_format (FALSE, TRUE, FALSE);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_date_time_format (date_time, _tmp30_);
						_tmp32_ = _tmp31_;
						_g_free0 (_tmp30_);
						result = _tmp32_;
						_g_date_time_unref0 (now);
						return result;
					} else {
						gchar* _tmp33_;
						_tmp33_ = g_date_time_format (date_time, "%x");
						result = _tmp33_;
						_g_date_time_unref0 (now);
						return result;
					}
				}
			}
		}
	}
}

/**
     * Gets the //clock-format// key from //org.gnome.desktop.interface// schema
     * and determines if the clock format is 12h based
     *
     * @return true if the clock format is 12h based, false otherwise.
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

 G_GNUC_INTERNAL gboolean
granite_date_time_is_clock_format_12h (void)
{
	gchar* format = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	format = NULL;
	{
		GranitePortalSettings* portal = NULL;
		GranitePortalSettings* _tmp0_;
		GVariant* _tmp1_ = NULL;
		GranitePortalSettings* _tmp2_;
		GVariant* _tmp3_;
		GVariant* variant = NULL;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = granite_portal_settings_get (&_inner_error0_);
		portal = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = portal;
		_tmp3_ = granite_portal_settings_read (_tmp2_, "org.gnome.desktop.interface", "clock-format", &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (portal);
			goto __catch0_g_error;
		}
		_tmp4_ = g_variant_get_variant (_tmp1_);
		variant = _tmp4_;
		_tmp5_ = variant;
		_tmp6_ = g_variant_get_string (_tmp5_, NULL);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (format);
		format = _tmp7_;
		_g_variant_unref0 (variant);
		_g_variant_unref0 (_tmp1_);
		_g_object_unref0 (portal);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_debug ("DateTime.vala:109: cannot use portal, using GSettings: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_free0 (format);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	_tmp11_ = format;
	if (_tmp11_ == NULL) {
		GSettings* h24_settings = NULL;
		GSettings* _tmp12_;
		GSettings* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = g_settings_new ("org.gnome.desktop.interface");
		h24_settings = _tmp12_;
		_tmp13_ = h24_settings;
		_tmp14_ = g_settings_get_string (_tmp13_, "clock-format");
		_g_free0 (format);
		format = _tmp14_;
		_g_object_unref0 (h24_settings);
	}
	_tmp15_ = format;
	result = string_contains (_tmp15_, "12h");
	_g_free0 (format);
	return result;
}

/**
     * Compare two {@link GLib.DateTime} and return true if they occur on the same day of the same year
     *
     * @param day1 a {@link GLib.DateTime} to compare against day2
     * @param day2 a {@link GLib.DateTime} to compare against day1
     *
     * @return true if day1 and day2 occur on the same day of the same year. False otherwise
     */
gboolean
granite_date_time_is_same_day (GDateTime* day1,
                               GDateTime* day2)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (day1 != NULL, FALSE);
	g_return_val_if_fail (day2 != NULL, FALSE);
	if (g_date_time_get_day_of_year (day1) == g_date_time_get_day_of_year (day2)) {
		_tmp0_ = g_date_time_get_year (day1) == g_date_time_get_year (day2);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
     * Gets the default translated date format.
     * The function constructs a new string interpreting the //with_weekday//, //with_day// and //with_year// parameters
     * so that it can be used with formatting functions like {@link GLib.DateTime.format}.
     *
     * As the {@link Granite.DateTime.get_default_time_format}, the returned string is formatted, translated and is also mostly used to display
     * the date in various user interfaces like the date displayed in the top panel.
     *
     * @param with_weekday if the returned string should contain the abbreviated weekday name
     * @param with_day if the returned string should contain contain the day of the month as a decimal number (range 1 to 31)
     * @param with_year if the returned string should contain the year as a decimal number including the century
     *
     * @return returns the formatted and located date string. If for some reason, the function could not determine the format to use,
     *         an empty string will be returned.
     */
gchar*
granite_date_time_get_default_date_format (gboolean with_weekday,
                                           gboolean with_day,
                                           gboolean with_year)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp24_;
	gchar* result;
	if (with_weekday == TRUE) {
		_tmp1_ = with_day == TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = with_year == TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (_ ("%a, %b %e, %Y"));
		result = _tmp2_;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (with_weekday == FALSE) {
			_tmp4_ = with_day == TRUE;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = with_year == TRUE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("%b %e %Y"));
			result = _tmp5_;
			return result;
		} else {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			if (with_weekday == FALSE) {
				_tmp7_ = with_day == FALSE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = with_year == TRUE;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				gchar* _tmp8_;
				_tmp8_ = g_strdup (_ ("%Y"));
				result = _tmp8_;
				return result;
			} else {
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				if (with_weekday == FALSE) {
					_tmp10_ = with_day == TRUE;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_tmp9_ = with_year == FALSE;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					gchar* _tmp11_;
					_tmp11_ = g_strdup (_ ("%b %e"));
					result = _tmp11_;
					return result;
				} else {
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					if (with_weekday == TRUE) {
						_tmp13_ = with_day == FALSE;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						_tmp12_ = with_year == TRUE;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						gchar* _tmp14_;
						_tmp14_ = g_strdup (_ ("%a %Y"));
						result = _tmp14_;
						return result;
					} else {
						gboolean _tmp15_ = FALSE;
						gboolean _tmp16_ = FALSE;
						if (with_weekday == TRUE) {
							_tmp16_ = with_day == FALSE;
						} else {
							_tmp16_ = FALSE;
						}
						if (_tmp16_) {
							_tmp15_ = with_year == FALSE;
						} else {
							_tmp15_ = FALSE;
						}
						if (_tmp15_) {
							gchar* _tmp17_;
							_tmp17_ = g_strdup (_ ("%a"));
							result = _tmp17_;
							return result;
						} else {
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							if (with_weekday == TRUE) {
								_tmp19_ = with_day == TRUE;
							} else {
								_tmp19_ = FALSE;
							}
							if (_tmp19_) {
								_tmp18_ = with_year == FALSE;
							} else {
								_tmp18_ = FALSE;
							}
							if (_tmp18_) {
								gchar* _tmp20_;
								_tmp20_ = g_strdup (_ ("%a, %b %e"));
								result = _tmp20_;
								return result;
							} else {
								gboolean _tmp21_ = FALSE;
								gboolean _tmp22_ = FALSE;
								if (with_weekday == FALSE) {
									_tmp22_ = with_day == FALSE;
								} else {
									_tmp22_ = FALSE;
								}
								if (_tmp22_) {
									_tmp21_ = with_year == FALSE;
								} else {
									_tmp21_ = FALSE;
								}
								if (_tmp21_) {
									gchar* _tmp23_;
									_tmp23_ = g_strdup (_ ("%b"));
									result = _tmp23_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp24_ = g_strdup ("");
	result = _tmp24_;
	return result;
}

/**
     * Converts seconds into the ISO 8601 standard date format for minutes (e.g. 100s to 01:40).
     * Output of negative seconds is prepended with minus character.
     *
     * @param seconds the number of seconds to convert into ISO 8601
     *
     * @return returns an ISO 8601 formatted string
     */
gchar*
granite_date_time_seconds_to_time (gint seconds)
{
	gint sign = 0;
	gint hours = 0;
	gint min = 0;
	gint sec = 0;
	gchar* result;
	sign = 1;
	if (seconds < 0) {
		seconds = -seconds;
		sign = -1;
	}
	hours = seconds / 3600;
	min = (seconds % 3600) / 60;
	sec = seconds % 60;
	if (hours > 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf ("%d:%02d:%02d", sign * hours, min, sec);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("%02d:%02d", sign * min, sec);
		result = _tmp1_;
		return result;
	}
}

