

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Functions
    ( 

 -- * Methods


-- ** focusTrackerNotify #method:focusTrackerNotify#

    focusTrackerNotify                      ,


-- ** getBinaryAge #method:getBinaryAge#

    getBinaryAge                            ,


-- ** getDefaultRegistry #method:getDefaultRegistry#

    getDefaultRegistry                      ,


-- ** getFocusObject #method:getFocusObject#

    getFocusObject                          ,


-- ** getInterfaceAge #method:getInterfaceAge#

    getInterfaceAge                         ,


-- ** getMajorVersion #method:getMajorVersion#

    getMajorVersion                         ,


-- ** getMicroVersion #method:getMicroVersion#

    getMicroVersion                         ,


-- ** getMinorVersion #method:getMinorVersion#

    getMinorVersion                         ,


-- ** getRoot #method:getRoot#

    getRoot                                 ,


-- ** getToolkitName #method:getToolkitName#

    getToolkitName                          ,


-- ** getToolkitVersion #method:getToolkitVersion#

    getToolkitVersion                       ,


-- ** getVersion #method:getVersion#

    getVersion                              ,


-- ** removeFocusTracker #method:removeFocusTracker#

    removeFocusTracker                      ,


-- ** removeGlobalEventListener #method:removeGlobalEventListener#

    removeGlobalEventListener               ,


-- ** removeKeyEventListener #method:removeKeyEventListener#

    removeKeyEventListener                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.ObjectFactory as Atk.ObjectFactory
import {-# SOURCE #-} qualified GI.Atk.Objects.Registry as Atk.Registry
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Registry as Atk.Registry

#endif

-- function remove_key_event_listener
-- Args: [ Arg
--           { argCName = "listener_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the id of the event listener to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_remove_key_event_listener" atk_remove_key_event_listener :: 
    Word32 ->                               -- listener_id : TBasicType TUInt
    IO ()

-- | /@listenerId@/ is the value returned by @/atk_add_key_event_listener/@
-- when you registered that event listener.
-- 
-- Removes the specified event listener.
removeKeyEventListener ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@listenerId@/: the id of the event listener to remove
    -> m ()
removeKeyEventListener listenerId = liftIO $ do
    atk_remove_key_event_listener listenerId
    return ()


-- function remove_global_event_listener
-- Args: [ Arg
--           { argCName = "listener_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the id of the event listener to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_remove_global_event_listener" atk_remove_global_event_listener :: 
    Word32 ->                               -- listener_id : TBasicType TUInt
    IO ()

-- | /@listenerId@/ is the value returned by @/atk_add_global_event_listener/@
-- when you registered that event listener.
-- 
-- Toolkit implementor note: ATK provides a default implementation for
-- this virtual method. ATK implementors are discouraged from
-- reimplementing this method.
-- 
-- Toolkit implementor note: this method is not intended to be used by
-- ATK implementors but by ATK consumers.
-- 
-- Removes the specified event listener
removeGlobalEventListener ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@listenerId@/: the id of the event listener to remove
    -> m ()
removeGlobalEventListener listenerId = liftIO $ do
    atk_remove_global_event_listener listenerId
    return ()


-- function remove_focus_tracker
-- Args: [ Arg
--           { argCName = "tracker_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the id of the focus tracker to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_remove_focus_tracker" atk_remove_focus_tracker :: 
    Word32 ->                               -- tracker_id : TBasicType TUInt
    IO ()

{-# DEPRECATED removeFocusTracker ["(Since version 2.9.4)","Focus tracking has been dropped as a feature","  to be implemented by ATK itself. If you need focus tracking on your","  implementation, subscribe to the [Object::stateChange](\"GI.Atk.Objects.Object#g:signal:stateChange\") \\\"focused\\\"","  signal."] #-}
-- | Removes the specified focus tracker from the list of functions
-- to be called when any object receives focus.
removeFocusTracker ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@trackerId@/: the id of the focus tracker to remove
    -> m ()
removeFocusTracker trackerId = liftIO $ do
    atk_remove_focus_tracker trackerId
    return ()


-- function get_version
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_version" atk_get_version :: 
    IO CString

-- | Gets the current version for ATK.
-- 
-- /Since: 1.20/
getVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ version string for ATK
getVersion  = liftIO $ do
    result <- atk_get_version
    checkUnexpectedReturnNULL "getVersion" result
    result' <- cstringToText result
    return result'


-- function get_toolkit_version
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_toolkit_version" atk_get_toolkit_version :: 
    IO CString

-- | Gets version string for the GUI toolkit implementing ATK for this application.
getToolkitVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ version string for the GUI toolkit implementing ATK for this application
getToolkitVersion  = liftIO $ do
    result <- atk_get_toolkit_version
    checkUnexpectedReturnNULL "getToolkitVersion" result
    result' <- cstringToText result
    return result'


-- function get_toolkit_name
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_toolkit_name" atk_get_toolkit_name :: 
    IO CString

-- | Gets name string for the GUI toolkit implementing ATK for this application.
getToolkitName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ name string for the GUI toolkit implementing ATK for this application
getToolkitName  = liftIO $ do
    result <- atk_get_toolkit_name
    checkUnexpectedReturnNULL "getToolkitName" result
    result' <- cstringToText result
    return result'


-- function get_root
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_root" atk_get_root :: 
    IO (Ptr Atk.Object.Object)

-- | Gets the root accessible container for the current application.
getRoot ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Atk.Object.Object
    -- ^ __Returns:__ the root accessible container for the current
    -- application
getRoot  = liftIO $ do
    result <- atk_get_root
    checkUnexpectedReturnNULL "getRoot" result
    result' <- (newObject Atk.Object.Object) result
    return result'


-- function get_minor_version
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_minor_version" atk_get_minor_version :: 
    IO Word32

-- | Returns the minor version number of the ATK library.  (e.g. in ATK
-- version 2.7.4 this is 7.)
-- 
-- This function is in the library, so it represents the ATK library
-- your code is are running against. In contrast, the
-- 'GI.Atk.Constants.MINOR_VERSION' macro represents the minor version of the ATK
-- headers you have included when compiling your code.
-- 
-- /Since: 2.8/
getMinorVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the minor version number of the ATK library
getMinorVersion  = liftIO $ do
    result <- atk_get_minor_version
    return result


-- function get_micro_version
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_micro_version" atk_get_micro_version :: 
    IO Word32

-- | Returns the micro version number of the ATK library.  (e.g. in ATK
-- version 2.7.4 this is 4.)
-- 
-- This function is in the library, so it represents the ATK library
-- your code is are running against. In contrast, the
-- 'GI.Atk.Constants.MICRO_VERSION' macro represents the micro version of the ATK
-- headers you have included when compiling your code.
-- 
-- /Since: 2.8/
getMicroVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the micro version number of the ATK library
getMicroVersion  = liftIO $ do
    result <- atk_get_micro_version
    return result


-- function get_major_version
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_major_version" atk_get_major_version :: 
    IO Word32

-- | Returns the major version number of the ATK library.  (e.g. in ATK
-- version 2.7.4 this is 2.)
-- 
-- This function is in the library, so it represents the ATK library
-- your code is running against. In contrast, the 'GI.Atk.Constants.MAJOR_VERSION'
-- macro represents the major version of the ATK headers you have
-- included when compiling your code.
-- 
-- /Since: 2.8/
getMajorVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the major version number of the ATK library
getMajorVersion  = liftIO $ do
    result <- atk_get_major_version
    return result


-- function get_interface_age
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_interface_age" atk_get_interface_age :: 
    IO Word32

-- | Returns the interface age as passed to libtool when building the
-- ATK library the process is running against.
-- 
-- /Since: 2.8/
getInterfaceAge ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the interface age of the ATK library
getInterfaceAge  = liftIO $ do
    result <- atk_get_interface_age
    return result


-- function get_focus_object
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_focus_object" atk_get_focus_object :: 
    IO (Ptr Atk.Object.Object)

-- | Gets the currently focused object.
-- 
-- /Since: 1.6/
getFocusObject ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Atk.Object.Object
    -- ^ __Returns:__ the currently focused object for the current
    -- application
getFocusObject  = liftIO $ do
    result <- atk_get_focus_object
    checkUnexpectedReturnNULL "getFocusObject" result
    result' <- (newObject Atk.Object.Object) result
    return result'


-- function get_default_registry
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Registry" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_default_registry" atk_get_default_registry :: 
    IO (Ptr Atk.Registry.Registry)

-- | Gets a default implementation of the t'GI.Atk.Objects.ObjectFactory.ObjectFactory'\/type
-- registry.
-- Note: For most toolkit maintainers, this will be the correct
-- registry for registering new t'GI.Atk.Objects.Object.Object' factories. Following
-- a call to this function, maintainers may call 'GI.Atk.Objects.Registry.registrySetFactoryType'
-- to associate an t'GI.Atk.Objects.ObjectFactory.ObjectFactory' subclass with the GType of objects
-- for whom accessibility information will be provided.
getDefaultRegistry ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Atk.Registry.Registry
    -- ^ __Returns:__ a default implementation of the
    -- t'GI.Atk.Objects.ObjectFactory.ObjectFactory'\/type registry
getDefaultRegistry  = liftIO $ do
    result <- atk_get_default_registry
    checkUnexpectedReturnNULL "getDefaultRegistry" result
    result' <- (wrapObject Atk.Registry.Registry) result
    return result'


-- function get_binary_age
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_get_binary_age" atk_get_binary_age :: 
    IO Word32

-- | Returns the binary age as passed to libtool when building the ATK
-- library the process is running against.
-- 
-- /Since: 2.8/
getBinaryAge ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the binary age of the ATK library
getBinaryAge  = liftIO $ do
    result <- atk_get_binary_age
    return result


-- function focus_tracker_notify
-- Args: [ Arg
--           { argCName = "object"
--           , argType = TInterface Name { namespace = "Atk" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_focus_tracker_notify" atk_focus_tracker_notify :: 
    Ptr Atk.Object.Object ->                -- object : TInterface (Name {namespace = "Atk", name = "Object"})
    IO ()

{-# DEPRECATED focusTrackerNotify ["(Since version 2.9.4)","Focus tracking has been dropped as a feature","to be implemented by ATK itself. As [Object::focusEvent](\"GI.Atk.Objects.Object#g:signal:focusEvent\") was","deprecated in favor of a [Object::stateChange](\"GI.Atk.Objects.Object#g:signal:stateChange\") signal, in order","to notify a focus change on your implementation, you can use","'GI.Atk.Objects.Object.objectNotifyStateChange' instead."] #-}
-- | Cause the focus tracker functions which have been specified to be
-- executed for the object.
focusTrackerNotify ::
    (B.CallStack.HasCallStack, MonadIO m, Atk.Object.IsObject a) =>
    a
    -- ^ /@object@/: an t'GI.Atk.Objects.Object.Object'
    -> m ()
focusTrackerNotify object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    atk_focus_tracker_notify object'
    touchManagedPtr object
    return ()



