{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An interface for tablet pad devices.
-- 
-- It allows querying the features provided by the pad device.
-- 
-- Tablet pads may contain one or more groups, each containing a subset
-- of the buttons\/rings\/strips available. 'GI.Gdk.Interfaces.DevicePad.devicePadGetNGroups'
-- can be used to obtain the number of groups, 'GI.Gdk.Interfaces.DevicePad.devicePadGetNFeatures'
-- and 'GI.Gdk.Interfaces.DevicePad.devicePadGetFeatureGroup' can be combined to find out
-- the number of buttons\/rings\/strips the device has, and how are they grouped.
-- 
-- Each of those groups have different modes, which may be used to map each
-- individual pad feature to multiple actions. Only one mode is effective
-- (current) for each given group, different groups may have different
-- current modes. The number of available modes in a group can be found
-- out through 'GI.Gdk.Interfaces.DevicePad.devicePadGetGroupNModes', and the current mode
-- for a given group will be notified through events of type @GDK_PAD_GROUP_MODE@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Interfaces.DevicePad
    ( 

-- * Exported types
    DevicePad(..)                           ,
    IsDevicePad                             ,
    toDevicePad                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasBidiLayouts]("GI.Gdk.Objects.Device#g:method:hasBidiLayouts"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActiveLayoutIndex]("GI.Gdk.Objects.Device#g:method:getActiveLayoutIndex"), [getCapsLockState]("GI.Gdk.Objects.Device#g:method:getCapsLockState"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDeviceTool]("GI.Gdk.Objects.Device#g:method:getDeviceTool"), [getDirection]("GI.Gdk.Objects.Device#g:method:getDirection"), [getDisplay]("GI.Gdk.Objects.Device#g:method:getDisplay"), [getFeatureGroup]("GI.Gdk.Interfaces.DevicePad#g:method:getFeatureGroup"), [getGroupNModes]("GI.Gdk.Interfaces.DevicePad#g:method:getGroupNModes"), [getHasCursor]("GI.Gdk.Objects.Device#g:method:getHasCursor"), [getLayoutNames]("GI.Gdk.Objects.Device#g:method:getLayoutNames"), [getModifierState]("GI.Gdk.Objects.Device#g:method:getModifierState"), [getNFeatures]("GI.Gdk.Interfaces.DevicePad#g:method:getNFeatures"), [getNGroups]("GI.Gdk.Interfaces.DevicePad#g:method:getNGroups"), [getName]("GI.Gdk.Objects.Device#g:method:getName"), [getNumLockState]("GI.Gdk.Objects.Device#g:method:getNumLockState"), [getNumTouches]("GI.Gdk.Objects.Device#g:method:getNumTouches"), [getProductId]("GI.Gdk.Objects.Device#g:method:getProductId"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScrollLockState]("GI.Gdk.Objects.Device#g:method:getScrollLockState"), [getSeat]("GI.Gdk.Objects.Device#g:method:getSeat"), [getSource]("GI.Gdk.Objects.Device#g:method:getSource"), [getSurfaceAtPosition]("GI.Gdk.Objects.Device#g:method:getSurfaceAtPosition"), [getTimestamp]("GI.Gdk.Objects.Device#g:method:getTimestamp"), [getVendorId]("GI.Gdk.Objects.Device#g:method:getVendorId").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDevicePadMethod                  ,
#endif

-- ** getFeatureGroup #method:getFeatureGroup#

#if defined(ENABLE_OVERLOADING)
    DevicePadGetFeatureGroupMethodInfo      ,
#endif
    devicePadGetFeatureGroup                ,


-- ** getGroupNModes #method:getGroupNModes#

#if defined(ENABLE_OVERLOADING)
    DevicePadGetGroupNModesMethodInfo       ,
#endif
    devicePadGetGroupNModes                 ,


-- ** getNFeatures #method:getNFeatures#

#if defined(ENABLE_OVERLOADING)
    DevicePadGetNFeaturesMethodInfo         ,
#endif
    devicePadGetNFeatures                   ,


-- ** getNGroups #method:getNGroups#

#if defined(ENABLE_OVERLOADING)
    DevicePadGetNGroupsMethodInfo           ,
#endif
    devicePadGetNGroups                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device

#endif

-- interface DevicePad 
-- | Memory-managed wrapper type.
newtype DevicePad = DevicePad (SP.ManagedPtr DevicePad)
    deriving (Eq)

instance SP.ManagedPtrNewtype DevicePad where
    toManagedPtr (DevicePad p) = p

foreign import ccall "gdk_device_pad_get_type"
    c_gdk_device_pad_get_type :: IO B.Types.GType

instance B.Types.TypedObject DevicePad where
    glibType = c_gdk_device_pad_get_type

instance B.Types.GObject DevicePad

-- | Type class for types which can be safely cast to t'DevicePad', for instance with `toDevicePad`.
class (SP.GObject o, O.IsDescendantOf DevicePad o) => IsDevicePad o
instance (SP.GObject o, O.IsDescendantOf DevicePad o) => IsDevicePad o

instance O.HasParentTypes DevicePad
type instance O.ParentTypes DevicePad = '[Gdk.Device.Device, GObject.Object.Object]

-- | Cast to t'DevicePad', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDevicePad :: (MIO.MonadIO m, IsDevicePad o) => o -> m DevicePad
toDevicePad = MIO.liftIO . B.ManagedPtr.unsafeCastTo DevicePad

-- | Convert t'DevicePad' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DevicePad) where
    gvalueGType_ = c_gdk_device_pad_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DevicePad)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DevicePad)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DevicePad ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DevicePad
type instance O.AttributeList DevicePad = DevicePadAttributeList
type DevicePadAttributeList = ('[ '("activeLayoutIndex", Gdk.Device.DeviceActiveLayoutIndexPropertyInfo), '("capsLockState", Gdk.Device.DeviceCapsLockStatePropertyInfo), '("direction", Gdk.Device.DeviceDirectionPropertyInfo), '("display", Gdk.Device.DeviceDisplayPropertyInfo), '("hasBidiLayouts", Gdk.Device.DeviceHasBidiLayoutsPropertyInfo), '("hasCursor", Gdk.Device.DeviceHasCursorPropertyInfo), '("layoutNames", Gdk.Device.DeviceLayoutNamesPropertyInfo), '("modifierState", Gdk.Device.DeviceModifierStatePropertyInfo), '("nAxes", Gdk.Device.DeviceNAxesPropertyInfo), '("name", Gdk.Device.DeviceNamePropertyInfo), '("numLockState", Gdk.Device.DeviceNumLockStatePropertyInfo), '("numTouches", Gdk.Device.DeviceNumTouchesPropertyInfo), '("productId", Gdk.Device.DeviceProductIdPropertyInfo), '("scrollLockState", Gdk.Device.DeviceScrollLockStatePropertyInfo), '("seat", Gdk.Device.DeviceSeatPropertyInfo), '("source", Gdk.Device.DeviceSourcePropertyInfo), '("tool", Gdk.Device.DeviceToolPropertyInfo), '("vendorId", Gdk.Device.DeviceVendorIdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDevicePadMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDevicePadMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDevicePadMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDevicePadMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDevicePadMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDevicePadMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDevicePadMethod "hasBidiLayouts" o = Gdk.Device.DeviceHasBidiLayoutsMethodInfo
    ResolveDevicePadMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDevicePadMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDevicePadMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDevicePadMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDevicePadMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDevicePadMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDevicePadMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDevicePadMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDevicePadMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDevicePadMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDevicePadMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDevicePadMethod "getActiveLayoutIndex" o = Gdk.Device.DeviceGetActiveLayoutIndexMethodInfo
    ResolveDevicePadMethod "getCapsLockState" o = Gdk.Device.DeviceGetCapsLockStateMethodInfo
    ResolveDevicePadMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDevicePadMethod "getDeviceTool" o = Gdk.Device.DeviceGetDeviceToolMethodInfo
    ResolveDevicePadMethod "getDirection" o = Gdk.Device.DeviceGetDirectionMethodInfo
    ResolveDevicePadMethod "getDisplay" o = Gdk.Device.DeviceGetDisplayMethodInfo
    ResolveDevicePadMethod "getFeatureGroup" o = DevicePadGetFeatureGroupMethodInfo
    ResolveDevicePadMethod "getGroupNModes" o = DevicePadGetGroupNModesMethodInfo
    ResolveDevicePadMethod "getHasCursor" o = Gdk.Device.DeviceGetHasCursorMethodInfo
    ResolveDevicePadMethod "getLayoutNames" o = Gdk.Device.DeviceGetLayoutNamesMethodInfo
    ResolveDevicePadMethod "getModifierState" o = Gdk.Device.DeviceGetModifierStateMethodInfo
    ResolveDevicePadMethod "getNFeatures" o = DevicePadGetNFeaturesMethodInfo
    ResolveDevicePadMethod "getNGroups" o = DevicePadGetNGroupsMethodInfo
    ResolveDevicePadMethod "getName" o = Gdk.Device.DeviceGetNameMethodInfo
    ResolveDevicePadMethod "getNumLockState" o = Gdk.Device.DeviceGetNumLockStateMethodInfo
    ResolveDevicePadMethod "getNumTouches" o = Gdk.Device.DeviceGetNumTouchesMethodInfo
    ResolveDevicePadMethod "getProductId" o = Gdk.Device.DeviceGetProductIdMethodInfo
    ResolveDevicePadMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDevicePadMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDevicePadMethod "getScrollLockState" o = Gdk.Device.DeviceGetScrollLockStateMethodInfo
    ResolveDevicePadMethod "getSeat" o = Gdk.Device.DeviceGetSeatMethodInfo
    ResolveDevicePadMethod "getSource" o = Gdk.Device.DeviceGetSourceMethodInfo
    ResolveDevicePadMethod "getSurfaceAtPosition" o = Gdk.Device.DeviceGetSurfaceAtPositionMethodInfo
    ResolveDevicePadMethod "getTimestamp" o = Gdk.Device.DeviceGetTimestampMethodInfo
    ResolveDevicePadMethod "getVendorId" o = Gdk.Device.DeviceGetVendorIdMethodInfo
    ResolveDevicePadMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDevicePadMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDevicePadMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDevicePadMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDevicePadMethod t DevicePad, O.OverloadedMethod info DevicePad p) => OL.IsLabel t (DevicePad -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDevicePadMethod t DevicePad, O.OverloadedMethod info DevicePad p, R.HasField t DevicePad p) => R.HasField t DevicePad p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDevicePadMethod t DevicePad, O.OverloadedMethodInfo info DevicePad) => OL.IsLabel t (O.MethodProxy info DevicePad) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method DevicePad::get_feature_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pad"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DevicePad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevicePad`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "feature"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DevicePadFeature" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the feature type to get the group from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "feature_idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the index of the feature to get the group from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_pad_get_feature_group" gdk_device_pad_get_feature_group :: 
    Ptr DevicePad ->                        -- pad : TInterface (Name {namespace = "Gdk", name = "DevicePad"})
    CUInt ->                                -- feature : TInterface (Name {namespace = "Gdk", name = "DevicePadFeature"})
    Int32 ->                                -- feature_idx : TBasicType TInt
    IO Int32

-- | Returns the group the given /@feature@/ and /@idx@/ belong to.
-- 
-- f the feature or index do not exist in /@pad@/, -1 is returned.
devicePadGetFeatureGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevicePad a) =>
    a
    -- ^ /@pad@/: a @GdkDevicePad@
    -> Gdk.Enums.DevicePadFeature
    -- ^ /@feature@/: the feature type to get the group from
    -> Int32
    -- ^ /@featureIdx@/: the index of the feature to get the group from
    -> m Int32
    -- ^ __Returns:__ The group number of the queried pad feature.
devicePadGetFeatureGroup pad feature featureIdx = liftIO $ do
    pad' <- unsafeManagedPtrCastPtr pad
    let feature' = (fromIntegral . fromEnum) feature
    result <- gdk_device_pad_get_feature_group pad' feature' featureIdx
    touchManagedPtr pad
    return result

#if defined(ENABLE_OVERLOADING)
data DevicePadGetFeatureGroupMethodInfo
instance (signature ~ (Gdk.Enums.DevicePadFeature -> Int32 -> m Int32), MonadIO m, IsDevicePad a) => O.OverloadedMethod DevicePadGetFeatureGroupMethodInfo a signature where
    overloadedMethod = devicePadGetFeatureGroup

instance O.OverloadedMethodInfo DevicePadGetFeatureGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.DevicePad.devicePadGetFeatureGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-DevicePad.html#v:devicePadGetFeatureGroup"
        })


#endif

-- method DevicePad::get_group_n_modes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pad"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DevicePad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevicePad`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group_idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "group to get the number of available modes from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_pad_get_group_n_modes" gdk_device_pad_get_group_n_modes :: 
    Ptr DevicePad ->                        -- pad : TInterface (Name {namespace = "Gdk", name = "DevicePad"})
    Int32 ->                                -- group_idx : TBasicType TInt
    IO Int32

-- | Returns the number of modes that /@group@/ may have.
devicePadGetGroupNModes ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevicePad a) =>
    a
    -- ^ /@pad@/: a @GdkDevicePad@
    -> Int32
    -- ^ /@groupIdx@/: group to get the number of available modes from
    -> m Int32
    -- ^ __Returns:__ The number of modes available in /@group@/.
devicePadGetGroupNModes pad groupIdx = liftIO $ do
    pad' <- unsafeManagedPtrCastPtr pad
    result <- gdk_device_pad_get_group_n_modes pad' groupIdx
    touchManagedPtr pad
    return result

#if defined(ENABLE_OVERLOADING)
data DevicePadGetGroupNModesMethodInfo
instance (signature ~ (Int32 -> m Int32), MonadIO m, IsDevicePad a) => O.OverloadedMethod DevicePadGetGroupNModesMethodInfo a signature where
    overloadedMethod = devicePadGetGroupNModes

instance O.OverloadedMethodInfo DevicePadGetGroupNModesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.DevicePad.devicePadGetGroupNModes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-DevicePad.html#v:devicePadGetGroupNModes"
        })


#endif

-- method DevicePad::get_n_features
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pad"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DevicePad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevicePad`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "feature"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DevicePadFeature" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pad feature" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_pad_get_n_features" gdk_device_pad_get_n_features :: 
    Ptr DevicePad ->                        -- pad : TInterface (Name {namespace = "Gdk", name = "DevicePad"})
    CUInt ->                                -- feature : TInterface (Name {namespace = "Gdk", name = "DevicePadFeature"})
    IO Int32

-- | Returns the number of features a tablet pad has.
devicePadGetNFeatures ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevicePad a) =>
    a
    -- ^ /@pad@/: a @GdkDevicePad@
    -> Gdk.Enums.DevicePadFeature
    -- ^ /@feature@/: a pad feature
    -> m Int32
    -- ^ __Returns:__ The amount of elements of type /@feature@/ that this pad has.
devicePadGetNFeatures pad feature = liftIO $ do
    pad' <- unsafeManagedPtrCastPtr pad
    let feature' = (fromIntegral . fromEnum) feature
    result <- gdk_device_pad_get_n_features pad' feature'
    touchManagedPtr pad
    return result

#if defined(ENABLE_OVERLOADING)
data DevicePadGetNFeaturesMethodInfo
instance (signature ~ (Gdk.Enums.DevicePadFeature -> m Int32), MonadIO m, IsDevicePad a) => O.OverloadedMethod DevicePadGetNFeaturesMethodInfo a signature where
    overloadedMethod = devicePadGetNFeatures

instance O.OverloadedMethodInfo DevicePadGetNFeaturesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.DevicePad.devicePadGetNFeatures",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-DevicePad.html#v:devicePadGetNFeatures"
        })


#endif

-- method DevicePad::get_n_groups
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pad"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DevicePad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevicePad`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_pad_get_n_groups" gdk_device_pad_get_n_groups :: 
    Ptr DevicePad ->                        -- pad : TInterface (Name {namespace = "Gdk", name = "DevicePad"})
    IO Int32

-- | Returns the number of groups this pad device has.
-- 
-- Pads have at least one group. A pad group is a subcollection of
-- buttons\/strip\/rings that is affected collectively by a same
-- current mode.
devicePadGetNGroups ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevicePad a) =>
    a
    -- ^ /@pad@/: a @GdkDevicePad@
    -> m Int32
    -- ^ __Returns:__ The number of button\/ring\/strip groups in the pad.
devicePadGetNGroups pad = liftIO $ do
    pad' <- unsafeManagedPtrCastPtr pad
    result <- gdk_device_pad_get_n_groups pad'
    touchManagedPtr pad
    return result

#if defined(ENABLE_OVERLOADING)
data DevicePadGetNGroupsMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsDevicePad a) => O.OverloadedMethod DevicePadGetNGroupsMethodInfo a signature where
    overloadedMethod = devicePadGetNGroups

instance O.OverloadedMethodInfo DevicePadGetNGroupsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.DevicePad.devicePadGetNGroups",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-DevicePad.html#v:devicePadGetNGroups"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DevicePad = DevicePadSignalList
type DevicePadSignalList = ('[ '("changed", Gdk.Device.DeviceChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("toolChanged", Gdk.Device.DeviceToolChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif


