{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents an input device, such as a keyboard, mouse or touchpad.
-- 
-- See the t'GI.Gdk.Objects.Seat.Seat' documentation for more information
-- about the various kinds of devices, and their relationships.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Device
    ( 

-- * Exported types
    Device(..)                              ,
    IsDevice                                ,
    toDevice                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasBidiLayouts]("GI.Gdk.Objects.Device#g:method:hasBidiLayouts"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActiveLayoutIndex]("GI.Gdk.Objects.Device#g:method:getActiveLayoutIndex"), [getCapsLockState]("GI.Gdk.Objects.Device#g:method:getCapsLockState"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDeviceTool]("GI.Gdk.Objects.Device#g:method:getDeviceTool"), [getDirection]("GI.Gdk.Objects.Device#g:method:getDirection"), [getDisplay]("GI.Gdk.Objects.Device#g:method:getDisplay"), [getHasCursor]("GI.Gdk.Objects.Device#g:method:getHasCursor"), [getLayoutNames]("GI.Gdk.Objects.Device#g:method:getLayoutNames"), [getModifierState]("GI.Gdk.Objects.Device#g:method:getModifierState"), [getName]("GI.Gdk.Objects.Device#g:method:getName"), [getNumLockState]("GI.Gdk.Objects.Device#g:method:getNumLockState"), [getNumTouches]("GI.Gdk.Objects.Device#g:method:getNumTouches"), [getProductId]("GI.Gdk.Objects.Device#g:method:getProductId"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScrollLockState]("GI.Gdk.Objects.Device#g:method:getScrollLockState"), [getSeat]("GI.Gdk.Objects.Device#g:method:getSeat"), [getSource]("GI.Gdk.Objects.Device#g:method:getSource"), [getSurfaceAtPosition]("GI.Gdk.Objects.Device#g:method:getSurfaceAtPosition"), [getTimestamp]("GI.Gdk.Objects.Device#g:method:getTimestamp"), [getVendorId]("GI.Gdk.Objects.Device#g:method:getVendorId").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDeviceMethod                     ,
#endif

-- ** getActiveLayoutIndex #method:getActiveLayoutIndex#

#if defined(ENABLE_OVERLOADING)
    DeviceGetActiveLayoutIndexMethodInfo    ,
#endif
    deviceGetActiveLayoutIndex              ,


-- ** getCapsLockState #method:getCapsLockState#

#if defined(ENABLE_OVERLOADING)
    DeviceGetCapsLockStateMethodInfo        ,
#endif
    deviceGetCapsLockState                  ,


-- ** getDeviceTool #method:getDeviceTool#

#if defined(ENABLE_OVERLOADING)
    DeviceGetDeviceToolMethodInfo           ,
#endif
    deviceGetDeviceTool                     ,


-- ** getDirection #method:getDirection#

#if defined(ENABLE_OVERLOADING)
    DeviceGetDirectionMethodInfo            ,
#endif
    deviceGetDirection                      ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    DeviceGetDisplayMethodInfo              ,
#endif
    deviceGetDisplay                        ,


-- ** getHasCursor #method:getHasCursor#

#if defined(ENABLE_OVERLOADING)
    DeviceGetHasCursorMethodInfo            ,
#endif
    deviceGetHasCursor                      ,


-- ** getLayoutNames #method:getLayoutNames#

#if defined(ENABLE_OVERLOADING)
    DeviceGetLayoutNamesMethodInfo          ,
#endif
    deviceGetLayoutNames                    ,


-- ** getModifierState #method:getModifierState#

#if defined(ENABLE_OVERLOADING)
    DeviceGetModifierStateMethodInfo        ,
#endif
    deviceGetModifierState                  ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    DeviceGetNameMethodInfo                 ,
#endif
    deviceGetName                           ,


-- ** getNumLockState #method:getNumLockState#

#if defined(ENABLE_OVERLOADING)
    DeviceGetNumLockStateMethodInfo         ,
#endif
    deviceGetNumLockState                   ,


-- ** getNumTouches #method:getNumTouches#

#if defined(ENABLE_OVERLOADING)
    DeviceGetNumTouchesMethodInfo           ,
#endif
    deviceGetNumTouches                     ,


-- ** getProductId #method:getProductId#

#if defined(ENABLE_OVERLOADING)
    DeviceGetProductIdMethodInfo            ,
#endif
    deviceGetProductId                      ,


-- ** getScrollLockState #method:getScrollLockState#

#if defined(ENABLE_OVERLOADING)
    DeviceGetScrollLockStateMethodInfo      ,
#endif
    deviceGetScrollLockState                ,


-- ** getSeat #method:getSeat#

#if defined(ENABLE_OVERLOADING)
    DeviceGetSeatMethodInfo                 ,
#endif
    deviceGetSeat                           ,


-- ** getSource #method:getSource#

#if defined(ENABLE_OVERLOADING)
    DeviceGetSourceMethodInfo               ,
#endif
    deviceGetSource                         ,


-- ** getSurfaceAtPosition #method:getSurfaceAtPosition#

#if defined(ENABLE_OVERLOADING)
    DeviceGetSurfaceAtPositionMethodInfo    ,
#endif
    deviceGetSurfaceAtPosition              ,


-- ** getTimestamp #method:getTimestamp#

#if defined(ENABLE_OVERLOADING)
    DeviceGetTimestampMethodInfo            ,
#endif
    deviceGetTimestamp                      ,


-- ** getVendorId #method:getVendorId#

#if defined(ENABLE_OVERLOADING)
    DeviceGetVendorIdMethodInfo             ,
#endif
    deviceGetVendorId                       ,


-- ** hasBidiLayouts #method:hasBidiLayouts#

#if defined(ENABLE_OVERLOADING)
    DeviceHasBidiLayoutsMethodInfo          ,
#endif
    deviceHasBidiLayouts                    ,




 -- * Properties


-- ** activeLayoutIndex #attr:activeLayoutIndex#
-- | The index of the keyboard active layout of a @GdkDevice@.
-- 
-- Will be -1 if there is no valid active layout.
-- 
-- This is only relevant for keyboard devices.
-- 
-- /Since: 4.18/

#if defined(ENABLE_OVERLOADING)
    DeviceActiveLayoutIndexPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceActiveLayoutIndex                 ,
#endif
    getDeviceActiveLayoutIndex              ,


-- ** capsLockState #attr:capsLockState#
-- | Whether Caps Lock is on.
-- 
-- This is only relevant for keyboard devices.

#if defined(ENABLE_OVERLOADING)
    DeviceCapsLockStatePropertyInfo         ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceCapsLockState                     ,
#endif
    getDeviceCapsLockState                  ,


-- ** direction #attr:direction#
-- | The direction of the current layout.
-- 
-- This is only relevant for keyboard devices.

#if defined(ENABLE_OVERLOADING)
    DeviceDirectionPropertyInfo             ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceDirection                         ,
#endif
    getDeviceDirection                      ,


-- ** display #attr:display#
-- | The @GdkDisplay@ the @GdkDevice@ pertains to.

#if defined(ENABLE_OVERLOADING)
    DeviceDisplayPropertyInfo               ,
#endif
    constructDeviceDisplay                  ,
#if defined(ENABLE_OVERLOADING)
    deviceDisplay                           ,
#endif
    getDeviceDisplay                        ,


-- ** hasBidiLayouts #attr:hasBidiLayouts#
-- | Whether the device has both right-to-left and left-to-right layouts.
-- 
-- This is only relevant for keyboard devices.

#if defined(ENABLE_OVERLOADING)
    DeviceHasBidiLayoutsPropertyInfo        ,
#endif
    getDeviceHasBidiLayouts                 ,


-- ** hasCursor #attr:hasCursor#
-- | Whether the device is represented by a cursor on the screen.

#if defined(ENABLE_OVERLOADING)
    DeviceHasCursorPropertyInfo             ,
#endif
    constructDeviceHasCursor                ,
#if defined(ENABLE_OVERLOADING)
    deviceHasCursor                         ,
#endif
    getDeviceHasCursor                      ,


-- ** layoutNames #attr:layoutNames#
-- | The names of the keyboard layouts of a @GdkDevice@.
-- 
-- This is only relevant for keyboard devices.
-- 
-- /Since: 4.18/

#if defined(ENABLE_OVERLOADING)
    DeviceLayoutNamesPropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceLayoutNames                       ,
#endif
    getDeviceLayoutNames                    ,


-- ** modifierState #attr:modifierState#
-- | The current modifier state of the device.
-- 
-- This is only relevant for keyboard devices.

#if defined(ENABLE_OVERLOADING)
    DeviceModifierStatePropertyInfo         ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceModifierState                     ,
#endif
    getDeviceModifierState                  ,


-- ** nAxes #attr:nAxes#
-- | Number of axes in the device.

#if defined(ENABLE_OVERLOADING)
    DeviceNAxesPropertyInfo                 ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceNAxes                             ,
#endif
    getDeviceNAxes                          ,


-- ** name #attr:name#
-- | The device name.

#if defined(ENABLE_OVERLOADING)
    DeviceNamePropertyInfo                  ,
#endif
    constructDeviceName                     ,
#if defined(ENABLE_OVERLOADING)
    deviceName                              ,
#endif
    getDeviceName                           ,


-- ** numLockState #attr:numLockState#
-- | Whether Num Lock is on.
-- 
-- This is only relevant for keyboard devices.

#if defined(ENABLE_OVERLOADING)
    DeviceNumLockStatePropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceNumLockState                      ,
#endif
    getDeviceNumLockState                   ,


-- ** numTouches #attr:numTouches#
-- | The maximal number of concurrent touches on a touch device.
-- 
-- Will be 0 if the device is not a touch device or if the number
-- of touches is unknown.

#if defined(ENABLE_OVERLOADING)
    DeviceNumTouchesPropertyInfo            ,
#endif
    constructDeviceNumTouches               ,
#if defined(ENABLE_OVERLOADING)
    deviceNumTouches                        ,
#endif
    getDeviceNumTouches                     ,


-- ** productId #attr:productId#
-- | Product ID of this device.
-- 
-- See 'GI.Gdk.Objects.Device.deviceGetProductId'.

#if defined(ENABLE_OVERLOADING)
    DeviceProductIdPropertyInfo             ,
#endif
    constructDeviceProductId                ,
#if defined(ENABLE_OVERLOADING)
    deviceProductId                         ,
#endif
    getDeviceProductId                      ,


-- ** scrollLockState #attr:scrollLockState#
-- | Whether Scroll Lock is on.
-- 
-- This is only relevant for keyboard devices.

#if defined(ENABLE_OVERLOADING)
    DeviceScrollLockStatePropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceScrollLockState                   ,
#endif
    getDeviceScrollLockState                ,


-- ** seat #attr:seat#
-- | @GdkSeat@ of this device.

#if defined(ENABLE_OVERLOADING)
    DeviceSeatPropertyInfo                  ,
#endif
    clearDeviceSeat                         ,
    constructDeviceSeat                     ,
#if defined(ENABLE_OVERLOADING)
    deviceSeat                              ,
#endif
    getDeviceSeat                           ,
    setDeviceSeat                           ,


-- ** source #attr:source#
-- | Source type for the device.

#if defined(ENABLE_OVERLOADING)
    DeviceSourcePropertyInfo                ,
#endif
    constructDeviceSource                   ,
#if defined(ENABLE_OVERLOADING)
    deviceSource                            ,
#endif
    getDeviceSource                         ,


-- ** tool #attr:tool#
-- | The @GdkDeviceTool@ that is currently used with this device.

#if defined(ENABLE_OVERLOADING)
    DeviceToolPropertyInfo                  ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceTool                              ,
#endif
    getDeviceTool                           ,


-- ** vendorId #attr:vendorId#
-- | Vendor ID of this device.
-- 
-- See 'GI.Gdk.Objects.Device.deviceGetVendorId'.

#if defined(ENABLE_OVERLOADING)
    DeviceVendorIdPropertyInfo              ,
#endif
    constructDeviceVendorId                 ,
#if defined(ENABLE_OVERLOADING)
    deviceVendorId                          ,
#endif
    getDeviceVendorId                       ,




 -- * Signals


-- ** changed #signal:changed#

    DeviceChangedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    DeviceChangedSignalInfo                 ,
#endif
    afterDeviceChanged                      ,
    onDeviceChanged                         ,


-- ** toolChanged #signal:toolChanged#

    DeviceToolChangedCallback               ,
#if defined(ENABLE_OVERLOADING)
    DeviceToolChangedSignalInfo             ,
#endif
    afterDeviceToolChanged                  ,
    onDeviceToolChanged                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Pango.Enums as Pango.Enums

#endif

-- | Memory-managed wrapper type.
newtype Device = Device (SP.ManagedPtr Device)
    deriving (Eq)

instance SP.ManagedPtrNewtype Device where
    toManagedPtr (Device p) = p

foreign import ccall "gdk_device_get_type"
    c_gdk_device_get_type :: IO B.Types.GType

instance B.Types.TypedObject Device where
    glibType = c_gdk_device_get_type

instance B.Types.GObject Device

-- | Type class for types which can be safely cast to t'Device', for instance with `toDevice`.
class (SP.GObject o, O.IsDescendantOf Device o) => IsDevice o
instance (SP.GObject o, O.IsDescendantOf Device o) => IsDevice o

instance O.HasParentTypes Device
type instance O.ParentTypes Device = '[GObject.Object.Object]

-- | Cast to t'Device', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDevice :: (MIO.MonadIO m, IsDevice o) => o -> m Device
toDevice = MIO.liftIO . B.ManagedPtr.unsafeCastTo Device

-- | Convert t'Device' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Device) where
    gvalueGType_ = c_gdk_device_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Device)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Device)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Device ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDeviceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDeviceMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDeviceMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDeviceMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDeviceMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDeviceMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDeviceMethod "hasBidiLayouts" o = DeviceHasBidiLayoutsMethodInfo
    ResolveDeviceMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDeviceMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDeviceMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDeviceMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDeviceMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDeviceMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDeviceMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDeviceMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDeviceMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDeviceMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDeviceMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDeviceMethod "getActiveLayoutIndex" o = DeviceGetActiveLayoutIndexMethodInfo
    ResolveDeviceMethod "getCapsLockState" o = DeviceGetCapsLockStateMethodInfo
    ResolveDeviceMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDeviceMethod "getDeviceTool" o = DeviceGetDeviceToolMethodInfo
    ResolveDeviceMethod "getDirection" o = DeviceGetDirectionMethodInfo
    ResolveDeviceMethod "getDisplay" o = DeviceGetDisplayMethodInfo
    ResolveDeviceMethod "getHasCursor" o = DeviceGetHasCursorMethodInfo
    ResolveDeviceMethod "getLayoutNames" o = DeviceGetLayoutNamesMethodInfo
    ResolveDeviceMethod "getModifierState" o = DeviceGetModifierStateMethodInfo
    ResolveDeviceMethod "getName" o = DeviceGetNameMethodInfo
    ResolveDeviceMethod "getNumLockState" o = DeviceGetNumLockStateMethodInfo
    ResolveDeviceMethod "getNumTouches" o = DeviceGetNumTouchesMethodInfo
    ResolveDeviceMethod "getProductId" o = DeviceGetProductIdMethodInfo
    ResolveDeviceMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDeviceMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDeviceMethod "getScrollLockState" o = DeviceGetScrollLockStateMethodInfo
    ResolveDeviceMethod "getSeat" o = DeviceGetSeatMethodInfo
    ResolveDeviceMethod "getSource" o = DeviceGetSourceMethodInfo
    ResolveDeviceMethod "getSurfaceAtPosition" o = DeviceGetSurfaceAtPositionMethodInfo
    ResolveDeviceMethod "getTimestamp" o = DeviceGetTimestampMethodInfo
    ResolveDeviceMethod "getVendorId" o = DeviceGetVendorIdMethodInfo
    ResolveDeviceMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDeviceMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDeviceMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDeviceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDeviceMethod t Device, O.OverloadedMethod info Device p) => OL.IsLabel t (Device -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDeviceMethod t Device, O.OverloadedMethod info Device p, R.HasField t Device p) => R.HasField t Device p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDeviceMethod t Device, O.OverloadedMethodInfo info Device) => OL.IsLabel t (O.MethodProxy info Device) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Device::changed
-- | Emitted either when the number of either axes or keys changes.
-- 
-- On X11 this will normally happen when the physical device
-- routing events through the logical device changes (for
-- example, user switches from the USB mouse to a tablet); in
-- that case the logical device will change to reflect the axes
-- and keys on the new physical device.
type DeviceChangedCallback =
    IO ()

type C_DeviceChangedCallback =
    Ptr Device ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DeviceChangedCallback`.
foreign import ccall "wrapper"
    mk_DeviceChangedCallback :: C_DeviceChangedCallback -> IO (FunPtr C_DeviceChangedCallback)

wrap_DeviceChangedCallback :: 
    GObject a => (a -> DeviceChangedCallback) ->
    C_DeviceChangedCallback
wrap_DeviceChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' device #changed callback
-- @
-- 
-- 
onDeviceChanged :: (IsDevice a, MonadIO m) => a -> ((?self :: a) => DeviceChangedCallback) -> m SignalHandlerId
onDeviceChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DeviceChangedCallback wrapped
    wrapped'' <- mk_DeviceChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' device #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDeviceChanged :: (IsDevice a, MonadIO m) => a -> ((?self :: a) => DeviceChangedCallback) -> m SignalHandlerId
afterDeviceChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DeviceChangedCallback wrapped
    wrapped'' <- mk_DeviceChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DeviceChangedSignalInfo
instance SignalInfo DeviceChangedSignalInfo where
    type HaskellCallbackType DeviceChangedSignalInfo = DeviceChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DeviceChangedCallback cb
        cb'' <- mk_DeviceChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:signal:changed"})

#endif

-- signal Device::tool-changed
-- | Emitted on pen\/eraser devices whenever tools enter or leave proximity.
type DeviceToolChangedCallback =
    Gdk.DeviceTool.DeviceTool
    -- ^ /@tool@/: The new current tool
    -> IO ()

type C_DeviceToolChangedCallback =
    Ptr Device ->                           -- object
    Ptr Gdk.DeviceTool.DeviceTool ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DeviceToolChangedCallback`.
foreign import ccall "wrapper"
    mk_DeviceToolChangedCallback :: C_DeviceToolChangedCallback -> IO (FunPtr C_DeviceToolChangedCallback)

wrap_DeviceToolChangedCallback :: 
    GObject a => (a -> DeviceToolChangedCallback) ->
    C_DeviceToolChangedCallback
wrap_DeviceToolChangedCallback gi'cb gi'selfPtr tool _ = do
    tool' <- (newObject Gdk.DeviceTool.DeviceTool) tool
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  tool'


-- | Connect a signal handler for the [toolChanged](#signal:toolChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' device #toolChanged callback
-- @
-- 
-- 
onDeviceToolChanged :: (IsDevice a, MonadIO m) => a -> ((?self :: a) => DeviceToolChangedCallback) -> m SignalHandlerId
onDeviceToolChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DeviceToolChangedCallback wrapped
    wrapped'' <- mk_DeviceToolChangedCallback wrapped'
    connectSignalFunPtr obj "tool-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toolChanged](#signal:toolChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' device #toolChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDeviceToolChanged :: (IsDevice a, MonadIO m) => a -> ((?self :: a) => DeviceToolChangedCallback) -> m SignalHandlerId
afterDeviceToolChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DeviceToolChangedCallback wrapped
    wrapped'' <- mk_DeviceToolChangedCallback wrapped'
    connectSignalFunPtr obj "tool-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DeviceToolChangedSignalInfo
instance SignalInfo DeviceToolChangedSignalInfo where
    type HaskellCallbackType DeviceToolChangedSignalInfo = DeviceToolChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DeviceToolChangedCallback cb
        cb'' <- mk_DeviceToolChangedCallback cb'
        connectSignalFunPtr obj "tool-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device::tool-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:signal:toolChanged"})

#endif

-- VVV Prop "active-layout-index"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@active-layout-index@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #activeLayoutIndex
-- @
getDeviceActiveLayoutIndex :: (MonadIO m, IsDevice o) => o -> m Int32
getDeviceActiveLayoutIndex obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "active-layout-index"

#if defined(ENABLE_OVERLOADING)
data DeviceActiveLayoutIndexPropertyInfo
instance AttrInfo DeviceActiveLayoutIndexPropertyInfo where
    type AttrAllowedOps DeviceActiveLayoutIndexPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceActiveLayoutIndexPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceActiveLayoutIndexPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceActiveLayoutIndexPropertyInfo = (~) ()
    type AttrTransferType DeviceActiveLayoutIndexPropertyInfo = ()
    type AttrGetType DeviceActiveLayoutIndexPropertyInfo = Int32
    type AttrLabel DeviceActiveLayoutIndexPropertyInfo = "active-layout-index"
    type AttrOrigin DeviceActiveLayoutIndexPropertyInfo = Device
    attrGet = getDeviceActiveLayoutIndex
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.activeLayoutIndex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:activeLayoutIndex"
        })
#endif

-- VVV Prop "caps-lock-state"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@caps-lock-state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #capsLockState
-- @
getDeviceCapsLockState :: (MonadIO m, IsDevice o) => o -> m Bool
getDeviceCapsLockState obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "caps-lock-state"

#if defined(ENABLE_OVERLOADING)
data DeviceCapsLockStatePropertyInfo
instance AttrInfo DeviceCapsLockStatePropertyInfo where
    type AttrAllowedOps DeviceCapsLockStatePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceCapsLockStatePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceCapsLockStatePropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceCapsLockStatePropertyInfo = (~) ()
    type AttrTransferType DeviceCapsLockStatePropertyInfo = ()
    type AttrGetType DeviceCapsLockStatePropertyInfo = Bool
    type AttrLabel DeviceCapsLockStatePropertyInfo = "caps-lock-state"
    type AttrOrigin DeviceCapsLockStatePropertyInfo = Device
    attrGet = getDeviceCapsLockState
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.capsLockState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:capsLockState"
        })
#endif

-- VVV Prop "direction"
   -- Type: TInterface (Name {namespace = "Pango", name = "Direction"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@direction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #direction
-- @
getDeviceDirection :: (MonadIO m, IsDevice o) => o -> m Pango.Enums.Direction
getDeviceDirection obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "direction"

#if defined(ENABLE_OVERLOADING)
data DeviceDirectionPropertyInfo
instance AttrInfo DeviceDirectionPropertyInfo where
    type AttrAllowedOps DeviceDirectionPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceDirectionPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceDirectionPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceDirectionPropertyInfo = (~) ()
    type AttrTransferType DeviceDirectionPropertyInfo = ()
    type AttrGetType DeviceDirectionPropertyInfo = Pango.Enums.Direction
    type AttrLabel DeviceDirectionPropertyInfo = "direction"
    type AttrOrigin DeviceDirectionPropertyInfo = Device
    attrGet = getDeviceDirection
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.direction"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:direction"
        })
#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #display
-- @
getDeviceDisplay :: (MonadIO m, IsDevice o) => o -> m Gdk.Display.Display
getDeviceDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getDeviceDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceDisplay :: (IsDevice o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructDeviceDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceDisplayPropertyInfo
instance AttrInfo DeviceDisplayPropertyInfo where
    type AttrAllowedOps DeviceDisplayPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceDisplayPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint DeviceDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType DeviceDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType DeviceDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel DeviceDisplayPropertyInfo = "display"
    type AttrOrigin DeviceDisplayPropertyInfo = Device
    attrGet = getDeviceDisplay
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructDeviceDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:display"
        })
#endif

-- VVV Prop "has-bidi-layouts"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@has-bidi-layouts@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #hasBidiLayouts
-- @
getDeviceHasBidiLayouts :: (MonadIO m, IsDevice o) => o -> m Bool
getDeviceHasBidiLayouts obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-bidi-layouts"

#if defined(ENABLE_OVERLOADING)
data DeviceHasBidiLayoutsPropertyInfo
instance AttrInfo DeviceHasBidiLayoutsPropertyInfo where
    type AttrAllowedOps DeviceHasBidiLayoutsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceHasBidiLayoutsPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceHasBidiLayoutsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceHasBidiLayoutsPropertyInfo = (~) ()
    type AttrTransferType DeviceHasBidiLayoutsPropertyInfo = ()
    type AttrGetType DeviceHasBidiLayoutsPropertyInfo = Bool
    type AttrLabel DeviceHasBidiLayoutsPropertyInfo = "has-bidi-layouts"
    type AttrOrigin DeviceHasBidiLayoutsPropertyInfo = Device
    attrGet = getDeviceHasBidiLayouts
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.hasBidiLayouts"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:hasBidiLayouts"
        })
#endif

-- VVV Prop "has-cursor"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@has-cursor@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #hasCursor
-- @
getDeviceHasCursor :: (MonadIO m, IsDevice o) => o -> m Bool
getDeviceHasCursor obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-cursor"

-- | Construct a t'GValueConstruct' with valid value for the “@has-cursor@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceHasCursor :: (IsDevice o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructDeviceHasCursor val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-cursor" val

#if defined(ENABLE_OVERLOADING)
data DeviceHasCursorPropertyInfo
instance AttrInfo DeviceHasCursorPropertyInfo where
    type AttrAllowedOps DeviceHasCursorPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceHasCursorPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceHasCursorPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint DeviceHasCursorPropertyInfo = (~) Bool
    type AttrTransferType DeviceHasCursorPropertyInfo = Bool
    type AttrGetType DeviceHasCursorPropertyInfo = Bool
    type AttrLabel DeviceHasCursorPropertyInfo = "has-cursor"
    type AttrOrigin DeviceHasCursorPropertyInfo = Device
    attrGet = getDeviceHasCursor
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceHasCursor
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.hasCursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:hasCursor"
        })
#endif

-- VVV Prop "layout-names"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@layout-names@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #layoutNames
-- @
getDeviceLayoutNames :: (MonadIO m, IsDevice o) => o -> m (Maybe [T.Text])
getDeviceLayoutNames obj = MIO.liftIO $ B.Properties.getObjectPropertyStringArray obj "layout-names"

#if defined(ENABLE_OVERLOADING)
data DeviceLayoutNamesPropertyInfo
instance AttrInfo DeviceLayoutNamesPropertyInfo where
    type AttrAllowedOps DeviceLayoutNamesPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceLayoutNamesPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceLayoutNamesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceLayoutNamesPropertyInfo = (~) ()
    type AttrTransferType DeviceLayoutNamesPropertyInfo = ()
    type AttrGetType DeviceLayoutNamesPropertyInfo = (Maybe [T.Text])
    type AttrLabel DeviceLayoutNamesPropertyInfo = "layout-names"
    type AttrOrigin DeviceLayoutNamesPropertyInfo = Device
    attrGet = getDeviceLayoutNames
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.layoutNames"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:layoutNames"
        })
#endif

-- VVV Prop "modifier-state"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ModifierType"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@modifier-state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #modifierState
-- @
getDeviceModifierState :: (MonadIO m, IsDevice o) => o -> m [Gdk.Flags.ModifierType]
getDeviceModifierState obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "modifier-state"

#if defined(ENABLE_OVERLOADING)
data DeviceModifierStatePropertyInfo
instance AttrInfo DeviceModifierStatePropertyInfo where
    type AttrAllowedOps DeviceModifierStatePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceModifierStatePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceModifierStatePropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceModifierStatePropertyInfo = (~) ()
    type AttrTransferType DeviceModifierStatePropertyInfo = ()
    type AttrGetType DeviceModifierStatePropertyInfo = [Gdk.Flags.ModifierType]
    type AttrLabel DeviceModifierStatePropertyInfo = "modifier-state"
    type AttrOrigin DeviceModifierStatePropertyInfo = Device
    attrGet = getDeviceModifierState
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.modifierState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:modifierState"
        })
#endif

-- VVV Prop "n-axes"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-axes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #nAxes
-- @
getDeviceNAxes :: (MonadIO m, IsDevice o) => o -> m Word32
getDeviceNAxes obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-axes"

#if defined(ENABLE_OVERLOADING)
data DeviceNAxesPropertyInfo
instance AttrInfo DeviceNAxesPropertyInfo where
    type AttrAllowedOps DeviceNAxesPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceNAxesPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceNAxesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceNAxesPropertyInfo = (~) ()
    type AttrTransferType DeviceNAxesPropertyInfo = ()
    type AttrGetType DeviceNAxesPropertyInfo = Word32
    type AttrLabel DeviceNAxesPropertyInfo = "n-axes"
    type AttrOrigin DeviceNAxesPropertyInfo = Device
    attrGet = getDeviceNAxes
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.nAxes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:nAxes"
        })
#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #name
-- @
getDeviceName :: (MonadIO m, IsDevice o) => o -> m T.Text
getDeviceName obj = MIO.liftIO $ checkUnexpectedNothing "getDeviceName" $ B.Properties.getObjectPropertyString obj "name"

-- | Construct a t'GValueConstruct' with valid value for the “@name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceName :: (IsDevice o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDeviceName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceNamePropertyInfo
instance AttrInfo DeviceNamePropertyInfo where
    type AttrAllowedOps DeviceNamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceNamePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DeviceNamePropertyInfo = (~) T.Text
    type AttrTransferType DeviceNamePropertyInfo = T.Text
    type AttrGetType DeviceNamePropertyInfo = T.Text
    type AttrLabel DeviceNamePropertyInfo = "name"
    type AttrOrigin DeviceNamePropertyInfo = Device
    attrGet = getDeviceName
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:name"
        })
#endif

-- VVV Prop "num-lock-state"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@num-lock-state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #numLockState
-- @
getDeviceNumLockState :: (MonadIO m, IsDevice o) => o -> m Bool
getDeviceNumLockState obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "num-lock-state"

#if defined(ENABLE_OVERLOADING)
data DeviceNumLockStatePropertyInfo
instance AttrInfo DeviceNumLockStatePropertyInfo where
    type AttrAllowedOps DeviceNumLockStatePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceNumLockStatePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceNumLockStatePropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceNumLockStatePropertyInfo = (~) ()
    type AttrTransferType DeviceNumLockStatePropertyInfo = ()
    type AttrGetType DeviceNumLockStatePropertyInfo = Bool
    type AttrLabel DeviceNumLockStatePropertyInfo = "num-lock-state"
    type AttrOrigin DeviceNumLockStatePropertyInfo = Device
    attrGet = getDeviceNumLockState
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.numLockState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:numLockState"
        })
#endif

-- VVV Prop "num-touches"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@num-touches@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #numTouches
-- @
getDeviceNumTouches :: (MonadIO m, IsDevice o) => o -> m Word32
getDeviceNumTouches obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "num-touches"

-- | Construct a t'GValueConstruct' with valid value for the “@num-touches@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceNumTouches :: (IsDevice o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructDeviceNumTouches val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "num-touches" val

#if defined(ENABLE_OVERLOADING)
data DeviceNumTouchesPropertyInfo
instance AttrInfo DeviceNumTouchesPropertyInfo where
    type AttrAllowedOps DeviceNumTouchesPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceNumTouchesPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceNumTouchesPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint DeviceNumTouchesPropertyInfo = (~) Word32
    type AttrTransferType DeviceNumTouchesPropertyInfo = Word32
    type AttrGetType DeviceNumTouchesPropertyInfo = Word32
    type AttrLabel DeviceNumTouchesPropertyInfo = "num-touches"
    type AttrOrigin DeviceNumTouchesPropertyInfo = Device
    attrGet = getDeviceNumTouches
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceNumTouches
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.numTouches"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:numTouches"
        })
#endif

-- VVV Prop "product-id"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@product-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #productId
-- @
getDeviceProductId :: (MonadIO m, IsDevice o) => o -> m (Maybe T.Text)
getDeviceProductId obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "product-id"

-- | Construct a t'GValueConstruct' with valid value for the “@product-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceProductId :: (IsDevice o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDeviceProductId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "product-id" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceProductIdPropertyInfo
instance AttrInfo DeviceProductIdPropertyInfo where
    type AttrAllowedOps DeviceProductIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceProductIdPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceProductIdPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DeviceProductIdPropertyInfo = (~) T.Text
    type AttrTransferType DeviceProductIdPropertyInfo = T.Text
    type AttrGetType DeviceProductIdPropertyInfo = (Maybe T.Text)
    type AttrLabel DeviceProductIdPropertyInfo = "product-id"
    type AttrOrigin DeviceProductIdPropertyInfo = Device
    attrGet = getDeviceProductId
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceProductId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.productId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:productId"
        })
#endif

-- VVV Prop "scroll-lock-state"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@scroll-lock-state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #scrollLockState
-- @
getDeviceScrollLockState :: (MonadIO m, IsDevice o) => o -> m Bool
getDeviceScrollLockState obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "scroll-lock-state"

#if defined(ENABLE_OVERLOADING)
data DeviceScrollLockStatePropertyInfo
instance AttrInfo DeviceScrollLockStatePropertyInfo where
    type AttrAllowedOps DeviceScrollLockStatePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceScrollLockStatePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceScrollLockStatePropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceScrollLockStatePropertyInfo = (~) ()
    type AttrTransferType DeviceScrollLockStatePropertyInfo = ()
    type AttrGetType DeviceScrollLockStatePropertyInfo = Bool
    type AttrLabel DeviceScrollLockStatePropertyInfo = "scroll-lock-state"
    type AttrOrigin DeviceScrollLockStatePropertyInfo = Device
    attrGet = getDeviceScrollLockState
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.scrollLockState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:scrollLockState"
        })
#endif

-- VVV Prop "seat"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Seat"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@seat@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #seat
-- @
getDeviceSeat :: (MonadIO m, IsDevice o) => o -> m Gdk.Seat.Seat
getDeviceSeat obj = MIO.liftIO $ checkUnexpectedNothing "getDeviceSeat" $ B.Properties.getObjectPropertyObject obj "seat" Gdk.Seat.Seat

-- | Set the value of the “@seat@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' device [ #seat 'Data.GI.Base.Attributes.:=' value ]
-- @
setDeviceSeat :: (MonadIO m, IsDevice o, Gdk.Seat.IsSeat a) => o -> a -> m ()
setDeviceSeat obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "seat" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@seat@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceSeat :: (IsDevice o, MIO.MonadIO m, Gdk.Seat.IsSeat a) => a -> m (GValueConstruct o)
constructDeviceSeat val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "seat" (P.Just val)

-- | Set the value of the “@seat@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #seat
-- @
clearDeviceSeat :: (MonadIO m, IsDevice o) => o -> m ()
clearDeviceSeat obj = liftIO $ B.Properties.setObjectPropertyObject obj "seat" (Nothing :: Maybe Gdk.Seat.Seat)

#if defined(ENABLE_OVERLOADING)
data DeviceSeatPropertyInfo
instance AttrInfo DeviceSeatPropertyInfo where
    type AttrAllowedOps DeviceSeatPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceSeatPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceSeatPropertyInfo = Gdk.Seat.IsSeat
    type AttrTransferTypeConstraint DeviceSeatPropertyInfo = Gdk.Seat.IsSeat
    type AttrTransferType DeviceSeatPropertyInfo = Gdk.Seat.Seat
    type AttrGetType DeviceSeatPropertyInfo = Gdk.Seat.Seat
    type AttrLabel DeviceSeatPropertyInfo = "seat"
    type AttrOrigin DeviceSeatPropertyInfo = Device
    attrGet = getDeviceSeat
    attrSet = setDeviceSeat
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Seat.Seat v
    attrConstruct = constructDeviceSeat
    attrClear = clearDeviceSeat
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.seat"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:seat"
        })
#endif

-- VVV Prop "source"
   -- Type: TInterface (Name {namespace = "Gdk", name = "InputSource"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@source@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #source
-- @
getDeviceSource :: (MonadIO m, IsDevice o) => o -> m Gdk.Enums.InputSource
getDeviceSource obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "source"

-- | Construct a t'GValueConstruct' with valid value for the “@source@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceSource :: (IsDevice o, MIO.MonadIO m) => Gdk.Enums.InputSource -> m (GValueConstruct o)
constructDeviceSource val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "source" val

#if defined(ENABLE_OVERLOADING)
data DeviceSourcePropertyInfo
instance AttrInfo DeviceSourcePropertyInfo where
    type AttrAllowedOps DeviceSourcePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceSourcePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceSourcePropertyInfo = (~) Gdk.Enums.InputSource
    type AttrTransferTypeConstraint DeviceSourcePropertyInfo = (~) Gdk.Enums.InputSource
    type AttrTransferType DeviceSourcePropertyInfo = Gdk.Enums.InputSource
    type AttrGetType DeviceSourcePropertyInfo = Gdk.Enums.InputSource
    type AttrLabel DeviceSourcePropertyInfo = "source"
    type AttrOrigin DeviceSourcePropertyInfo = Device
    attrGet = getDeviceSource
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceSource
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.source"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:source"
        })
#endif

-- VVV Prop "tool"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DeviceTool"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@tool@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #tool
-- @
getDeviceTool :: (MonadIO m, IsDevice o) => o -> m (Maybe Gdk.DeviceTool.DeviceTool)
getDeviceTool obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "tool" Gdk.DeviceTool.DeviceTool

#if defined(ENABLE_OVERLOADING)
data DeviceToolPropertyInfo
instance AttrInfo DeviceToolPropertyInfo where
    type AttrAllowedOps DeviceToolPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceToolPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceToolPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceToolPropertyInfo = (~) ()
    type AttrTransferType DeviceToolPropertyInfo = ()
    type AttrGetType DeviceToolPropertyInfo = (Maybe Gdk.DeviceTool.DeviceTool)
    type AttrLabel DeviceToolPropertyInfo = "tool"
    type AttrOrigin DeviceToolPropertyInfo = Device
    attrGet = getDeviceTool
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.tool"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:tool"
        })
#endif

-- VVV Prop "vendor-id"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@vendor-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #vendorId
-- @
getDeviceVendorId :: (MonadIO m, IsDevice o) => o -> m (Maybe T.Text)
getDeviceVendorId obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "vendor-id"

-- | Construct a t'GValueConstruct' with valid value for the “@vendor-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceVendorId :: (IsDevice o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDeviceVendorId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "vendor-id" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceVendorIdPropertyInfo
instance AttrInfo DeviceVendorIdPropertyInfo where
    type AttrAllowedOps DeviceVendorIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceVendorIdPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceVendorIdPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DeviceVendorIdPropertyInfo = (~) T.Text
    type AttrTransferType DeviceVendorIdPropertyInfo = T.Text
    type AttrGetType DeviceVendorIdPropertyInfo = (Maybe T.Text)
    type AttrLabel DeviceVendorIdPropertyInfo = "vendor-id"
    type AttrOrigin DeviceVendorIdPropertyInfo = Device
    attrGet = getDeviceVendorId
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceVendorId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.vendorId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#g:attr:vendorId"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Device
type instance O.AttributeList Device = DeviceAttributeList
type DeviceAttributeList = ('[ '("activeLayoutIndex", DeviceActiveLayoutIndexPropertyInfo), '("capsLockState", DeviceCapsLockStatePropertyInfo), '("direction", DeviceDirectionPropertyInfo), '("display", DeviceDisplayPropertyInfo), '("hasBidiLayouts", DeviceHasBidiLayoutsPropertyInfo), '("hasCursor", DeviceHasCursorPropertyInfo), '("layoutNames", DeviceLayoutNamesPropertyInfo), '("modifierState", DeviceModifierStatePropertyInfo), '("nAxes", DeviceNAxesPropertyInfo), '("name", DeviceNamePropertyInfo), '("numLockState", DeviceNumLockStatePropertyInfo), '("numTouches", DeviceNumTouchesPropertyInfo), '("productId", DeviceProductIdPropertyInfo), '("scrollLockState", DeviceScrollLockStatePropertyInfo), '("seat", DeviceSeatPropertyInfo), '("source", DeviceSourcePropertyInfo), '("tool", DeviceToolPropertyInfo), '("vendorId", DeviceVendorIdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
deviceActiveLayoutIndex :: AttrLabelProxy "activeLayoutIndex"
deviceActiveLayoutIndex = AttrLabelProxy

deviceCapsLockState :: AttrLabelProxy "capsLockState"
deviceCapsLockState = AttrLabelProxy

deviceDirection :: AttrLabelProxy "direction"
deviceDirection = AttrLabelProxy

deviceDisplay :: AttrLabelProxy "display"
deviceDisplay = AttrLabelProxy

deviceHasCursor :: AttrLabelProxy "hasCursor"
deviceHasCursor = AttrLabelProxy

deviceLayoutNames :: AttrLabelProxy "layoutNames"
deviceLayoutNames = AttrLabelProxy

deviceModifierState :: AttrLabelProxy "modifierState"
deviceModifierState = AttrLabelProxy

deviceNAxes :: AttrLabelProxy "nAxes"
deviceNAxes = AttrLabelProxy

deviceName :: AttrLabelProxy "name"
deviceName = AttrLabelProxy

deviceNumLockState :: AttrLabelProxy "numLockState"
deviceNumLockState = AttrLabelProxy

deviceNumTouches :: AttrLabelProxy "numTouches"
deviceNumTouches = AttrLabelProxy

deviceProductId :: AttrLabelProxy "productId"
deviceProductId = AttrLabelProxy

deviceScrollLockState :: AttrLabelProxy "scrollLockState"
deviceScrollLockState = AttrLabelProxy

deviceSeat :: AttrLabelProxy "seat"
deviceSeat = AttrLabelProxy

deviceSource :: AttrLabelProxy "source"
deviceSource = AttrLabelProxy

deviceTool :: AttrLabelProxy "tool"
deviceTool = AttrLabelProxy

deviceVendorId :: AttrLabelProxy "vendorId"
deviceVendorId = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Device = DeviceSignalList
type DeviceSignalList = ('[ '("changed", DeviceChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("toolChanged", DeviceToolChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Device::get_active_layout_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_active_layout_index" gdk_device_get_active_layout_index :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO Int32

-- | Retrieves the index of the active layout of the keyboard.
-- 
-- If there is no valid active layout for the @GdkDevice@, this function will
-- return -1;
-- 
-- This is only relevant for keyboard devices.
-- 
-- /Since: 4.18/
deviceGetActiveLayoutIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Int32
    -- ^ __Returns:__ The layout index of the active layout or -1.
deviceGetActiveLayoutIndex device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_active_layout_index device'
    touchManagedPtr device
    return result

#if defined(ENABLE_OVERLOADING)
data DeviceGetActiveLayoutIndexMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetActiveLayoutIndexMethodInfo a signature where
    overloadedMethod = deviceGetActiveLayoutIndex

instance O.OverloadedMethodInfo DeviceGetActiveLayoutIndexMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetActiveLayoutIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetActiveLayoutIndex"
        })


#endif

-- method Device::get_caps_lock_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_caps_lock_state" gdk_device_get_caps_lock_state :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CInt

-- | Retrieves whether the Caps Lock modifier of the keyboard is locked.
-- 
-- This is only relevant for keyboard devices.
deviceGetCapsLockState ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if Caps Lock is on for /@device@/
deviceGetCapsLockState device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_caps_lock_state device'
    let result' = (/= 0) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetCapsLockStateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetCapsLockStateMethodInfo a signature where
    overloadedMethod = deviceGetCapsLockState

instance O.OverloadedMethodInfo DeviceGetCapsLockStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetCapsLockState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetCapsLockState"
        })


#endif

-- method Device::get_device_tool
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DeviceTool" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_device_tool" gdk_device_get_device_tool :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr Gdk.DeviceTool.DeviceTool)

-- | Retrieves the current tool for /@device@/.
deviceGetDeviceTool ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m (Maybe Gdk.DeviceTool.DeviceTool)
    -- ^ __Returns:__ the @GdkDeviceTool@
deviceGetDeviceTool device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_device_tool device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.DeviceTool.DeviceTool) result'
        return result''
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DeviceGetDeviceToolMethodInfo
instance (signature ~ (m (Maybe Gdk.DeviceTool.DeviceTool)), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetDeviceToolMethodInfo a signature where
    overloadedMethod = deviceGetDeviceTool

instance O.OverloadedMethodInfo DeviceGetDeviceToolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetDeviceTool",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetDeviceTool"
        })


#endif

-- method Device::get_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Direction" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_direction" gdk_device_get_direction :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CUInt

-- | Returns the direction of effective layout of the keyboard.
-- 
-- This is only relevant for keyboard devices.
-- 
-- The direction of a layout is the direction of the majority
-- of its symbols. See 'GI.Pango.Functions.unicharDirection'.
deviceGetDirection ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Pango.Enums.Direction
    -- ^ __Returns:__ 'GI.Pango.Enums.DirectionLtr' or 'GI.Pango.Enums.DirectionRtl'
    --   if it can determine the direction. 'GI.Pango.Enums.DirectionNeutral'
    --   otherwise
deviceGetDirection device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_direction device'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetDirectionMethodInfo
instance (signature ~ (m Pango.Enums.Direction), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetDirectionMethodInfo a signature where
    overloadedMethod = deviceGetDirection

instance O.OverloadedMethodInfo DeviceGetDirectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetDirection"
        })


#endif

-- method Device::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_display" gdk_device_get_display :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr Gdk.Display.Display)

-- | Returns the @GdkDisplay@ to which /@device@/ pertains.
deviceGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Gdk.Display.Display
    -- ^ __Returns:__ a @GdkDisplay@
deviceGetDisplay device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_display device'
    checkUnexpectedReturnNULL "deviceGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetDisplayMethodInfo a signature where
    overloadedMethod = deviceGetDisplay

instance O.OverloadedMethodInfo DeviceGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetDisplay"
        })


#endif

-- method Device::get_has_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_has_cursor" gdk_device_get_has_cursor :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CInt

-- | Determines whether the pointer follows device motion.
-- 
-- This is not meaningful for keyboard devices, which
-- don\'t have a pointer.
deviceGetHasCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the pointer follows device motion
deviceGetHasCursor device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_has_cursor device'
    let result' = (/= 0) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetHasCursorMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetHasCursorMethodInfo a signature where
    overloadedMethod = deviceGetHasCursor

instance O.OverloadedMethodInfo DeviceGetHasCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetHasCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetHasCursor"
        })


#endif

-- method Device::get_layout_names
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_layout_names" gdk_device_get_layout_names :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr CString)

-- | Retrieves the names of the layouts of the keyboard.
-- 
-- This is only relevant for keyboard devices.
-- 
-- /Since: 4.18/
deviceGetLayoutNames ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m (Maybe [T.Text])
    -- ^ __Returns:__ 
    --   'P.Nothing'-terminated array of strings of layouts,
deviceGetLayoutNames device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_layout_names device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedUTF8CArray result'
        mapZeroTerminatedCArray freeMem result'
        freeMem result'
        return result''
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DeviceGetLayoutNamesMethodInfo
instance (signature ~ (m (Maybe [T.Text])), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetLayoutNamesMethodInfo a signature where
    overloadedMethod = deviceGetLayoutNames

instance O.OverloadedMethodInfo DeviceGetLayoutNamesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetLayoutNames",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetLayoutNames"
        })


#endif

-- method Device::get_modifier_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ModifierType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_modifier_state" gdk_device_get_modifier_state :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CUInt

-- | Retrieves the current modifier state of the keyboard.
-- 
-- This is only relevant for keyboard devices.
deviceGetModifierState ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m [Gdk.Flags.ModifierType]
    -- ^ __Returns:__ the current modifier state
deviceGetModifierState device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_modifier_state device'
    let result' = wordToGFlags result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetModifierStateMethodInfo
instance (signature ~ (m [Gdk.Flags.ModifierType]), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetModifierStateMethodInfo a signature where
    overloadedMethod = deviceGetModifierState

instance O.OverloadedMethodInfo DeviceGetModifierStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetModifierState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetModifierState"
        })


#endif

-- method Device::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_name" gdk_device_get_name :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CString

-- | The name of the device, suitable for showing in a user interface.
deviceGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a GdkDevice\`
    -> m T.Text
    -- ^ __Returns:__ a name
deviceGetName device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_name device'
    checkUnexpectedReturnNULL "deviceGetName" result
    result' <- cstringToText result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetNameMethodInfo a signature where
    overloadedMethod = deviceGetName

instance O.OverloadedMethodInfo DeviceGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetName"
        })


#endif

-- method Device::get_num_lock_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a ``GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_num_lock_state" gdk_device_get_num_lock_state :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CInt

-- | Retrieves whether the Num Lock modifier of the keyboard is locked.
-- 
-- This is only relevant for keyboard devices.
deviceGetNumLockState ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a \`@GdkDevice@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if Num Lock is on for /@device@/
deviceGetNumLockState device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_num_lock_state device'
    let result' = (/= 0) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetNumLockStateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetNumLockStateMethodInfo a signature where
    overloadedMethod = deviceGetNumLockState

instance O.OverloadedMethodInfo DeviceGetNumLockStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetNumLockState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetNumLockState"
        })


#endif

-- method Device::get_num_touches
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_num_touches" gdk_device_get_num_touches :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO Word32

-- | Retrieves the number of touch points associated to /@device@/.
deviceGetNumTouches ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Word32
    -- ^ __Returns:__ the number of touch points
deviceGetNumTouches device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_num_touches device'
    touchManagedPtr device
    return result

#if defined(ENABLE_OVERLOADING)
data DeviceGetNumTouchesMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetNumTouchesMethodInfo a signature where
    overloadedMethod = deviceGetNumTouches

instance O.OverloadedMethodInfo DeviceGetNumTouchesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetNumTouches",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetNumTouches"
        })


#endif

-- method Device::get_product_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a physical `GdkDevice`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_product_id" gdk_device_get_product_id :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CString

-- | Returns the product ID of this device.
-- 
-- This ID is retrieved from the device, and does not change.
-- See 'GI.Gdk.Objects.Device.deviceGetVendorId' for more information.
deviceGetProductId ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a physical @GdkDevice@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the product ID
deviceGetProductId device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_product_id device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DeviceGetProductIdMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetProductIdMethodInfo a signature where
    overloadedMethod = deviceGetProductId

instance O.OverloadedMethodInfo DeviceGetProductIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetProductId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetProductId"
        })


#endif

-- method Device::get_scroll_lock_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_scroll_lock_state" gdk_device_get_scroll_lock_state :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CInt

-- | Retrieves whether the Scroll Lock modifier of the keyboard is locked.
-- 
-- This is only relevant for keyboard devices.
deviceGetScrollLockState ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if Scroll Lock is on for /@device@/
deviceGetScrollLockState device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_scroll_lock_state device'
    let result' = (/= 0) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetScrollLockStateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetScrollLockStateMethodInfo a signature where
    overloadedMethod = deviceGetScrollLockState

instance O.OverloadedMethodInfo DeviceGetScrollLockStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetScrollLockState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetScrollLockState"
        })


#endif

-- method Device::get_seat
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Seat" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_seat" gdk_device_get_seat :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr Gdk.Seat.Seat)

-- | Returns the @GdkSeat@ the device belongs to.
deviceGetSeat ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: A @GdkDevice@
    -> m Gdk.Seat.Seat
    -- ^ __Returns:__ a @GdkSeat@
deviceGetSeat device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_seat device'
    checkUnexpectedReturnNULL "deviceGetSeat" result
    result' <- (newObject Gdk.Seat.Seat) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetSeatMethodInfo
instance (signature ~ (m Gdk.Seat.Seat), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetSeatMethodInfo a signature where
    overloadedMethod = deviceGetSeat

instance O.OverloadedMethodInfo DeviceGetSeatMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetSeat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetSeat"
        })


#endif

-- method Device::get_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "InputSource" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_source" gdk_device_get_source :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CUInt

-- | Determines the type of the device.
deviceGetSource ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Gdk.Enums.InputSource
    -- ^ __Returns:__ a @GdkInputSource@
deviceGetSource device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_source device'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetSourceMethodInfo
instance (signature ~ (m Gdk.Enums.InputSource), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetSourceMethodInfo a signature where
    overloadedMethod = deviceGetSource

instance O.OverloadedMethodInfo DeviceGetSourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetSource"
        })


#endif

-- method Device::get_surface_at_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer `GdkDevice` to query info to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "win_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the X coordinate\n  of the device location relative to the surface origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "win_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the Y coordinate\n  of the device location relative to the surface origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_surface_at_position" gdk_device_get_surface_at_position :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr CDouble ->                          -- win_x : TBasicType TDouble
    Ptr CDouble ->                          -- win_y : TBasicType TDouble
    IO (Ptr Gdk.Surface.Surface)

-- | Obtains the surface underneath /@device@/, returning the location of the
-- device in /@winX@/ and /@winY@/.
-- 
-- Returns 'P.Nothing' if the surface tree under /@device@/ is not known to GDK
-- (for example, belongs to another application).
deviceGetSurfaceAtPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: pointer @GdkDevice@ to query info to
    -> m ((Maybe Gdk.Surface.Surface, Double, Double))
    -- ^ __Returns:__ the @GdkSurface@ under the
    --   device position
deviceGetSurfaceAtPosition device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    winX <- allocMem :: IO (Ptr CDouble)
    winY <- allocMem :: IO (Ptr CDouble)
    result <- gdk_device_get_surface_at_position device' winX winY
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Surface.Surface) result'
        return result''
    winX' <- peek winX
    let winX'' = realToFrac winX'
    winY' <- peek winY
    let winY'' = realToFrac winY'
    touchManagedPtr device
    freeMem winX
    freeMem winY
    return (maybeResult, winX'', winY'')

#if defined(ENABLE_OVERLOADING)
data DeviceGetSurfaceAtPositionMethodInfo
instance (signature ~ (m ((Maybe Gdk.Surface.Surface, Double, Double))), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetSurfaceAtPositionMethodInfo a signature where
    overloadedMethod = deviceGetSurfaceAtPosition

instance O.OverloadedMethodInfo DeviceGetSurfaceAtPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetSurfaceAtPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetSurfaceAtPosition"
        })


#endif

-- method Device::get_timestamp
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_timestamp" gdk_device_get_timestamp :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO Word32

-- | Returns the timestamp of the last activity for this device.
-- 
-- In practice, this means the timestamp of the last event that was
-- received from the OS for this device. (GTK may occasionally produce
-- events for a device that are not received from the OS, and will not
-- update the timestamp).
-- 
-- /Since: 4.2/
deviceGetTimestamp ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Word32
    -- ^ __Returns:__ the timestamp of the last activity for this device
deviceGetTimestamp device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_timestamp device'
    touchManagedPtr device
    return result

#if defined(ENABLE_OVERLOADING)
data DeviceGetTimestampMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetTimestampMethodInfo a signature where
    overloadedMethod = deviceGetTimestamp

instance O.OverloadedMethodInfo DeviceGetTimestampMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetTimestamp",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetTimestamp"
        })


#endif

-- method Device::get_vendor_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a physical `GdkDevice`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_vendor_id" gdk_device_get_vendor_id :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CString

-- | Returns the vendor ID of this device.
-- 
-- This ID is retrieved from the device, and does not change.
-- 
-- This function, together with 'GI.Gdk.Objects.Device.deviceGetProductId',
-- can be used to eg. compose @GSettings@ paths to store settings
-- for this device.
-- 
-- 
-- === /c code/
-- > static GSettings *
-- > get_device_settings (GdkDevice *device)
-- > {
-- >   const char *vendor, *product;
-- >   GSettings *settings;
-- >   GdkDevice *device;
-- >   char *path;
-- >
-- >   vendor = gdk_device_get_vendor_id (device);
-- >   product = gdk_device_get_product_id (device);
-- >
-- >   path = g_strdup_printf ("/org/example/app/devices/%s:%s/", vendor, product);
-- >   settings = g_settings_new_with_path (DEVICE_SCHEMA, path);
-- >   g_free (path);
-- >
-- >   return settings;
-- > }
deviceGetVendorId ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a physical @GdkDevice@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the vendor ID
deviceGetVendorId device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_vendor_id device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DeviceGetVendorIdMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetVendorIdMethodInfo a signature where
    overloadedMethod = deviceGetVendorId

instance O.OverloadedMethodInfo DeviceGetVendorIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetVendorId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceGetVendorId"
        })


#endif

-- method Device::has_bidi_layouts
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_has_bidi_layouts" gdk_device_has_bidi_layouts :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CInt

-- | Determines if layouts for both right-to-left and
-- left-to-right languages are in use on the keyboard.
-- 
-- This is only relevant for keyboard devices.
deviceHasBidiLayouts ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a @GdkDevice@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if there are layouts with both directions, 'P.False' otherwise
deviceHasBidiLayouts device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_has_bidi_layouts device'
    let result' = (/= 0) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceHasBidiLayoutsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceHasBidiLayoutsMethodInfo a signature where
    overloadedMethod = deviceHasBidiLayouts

instance O.OverloadedMethodInfo DeviceHasBidiLayoutsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceHasBidiLayouts",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Device.html#v:deviceHasBidiLayouts"
        })


#endif


