

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Callbacks
    ( 

 -- * Signals


-- ** EventFunc #signal:EventFunc#

    C_EventFunc                             ,
    EventFunc                               ,
    EventFunc_WithClosures                  ,
    drop_closures_EventFunc                 ,
    dynamic_EventFunc                       ,
    genClosure_EventFunc                    ,
    mk_EventFunc                            ,
    noEventFunc                             ,
    noEventFunc_WithClosures                ,
    wrap_EventFunc                          ,


-- ** FilterFunc #signal:FilterFunc#

    C_FilterFunc                            ,
    FilterFunc                              ,
    FilterFunc_WithClosures                 ,
    drop_closures_FilterFunc                ,
    dynamic_FilterFunc                      ,
    genClosure_FilterFunc                   ,
    mk_FilterFunc                           ,
    noFilterFunc                            ,
    noFilterFunc_WithClosures               ,
    wrap_FilterFunc                         ,


-- ** SeatGrabPrepareFunc #signal:SeatGrabPrepareFunc#

    C_SeatGrabPrepareFunc                   ,
    SeatGrabPrepareFunc                     ,
    SeatGrabPrepareFunc_WithClosures        ,
    drop_closures_SeatGrabPrepareFunc       ,
    dynamic_SeatGrabPrepareFunc             ,
    genClosure_SeatGrabPrepareFunc          ,
    mk_SeatGrabPrepareFunc                  ,
    noSeatGrabPrepareFunc                   ,
    noSeatGrabPrepareFunc_WithClosures      ,
    wrap_SeatGrabPrepareFunc                ,


-- ** WindowChildFunc #signal:WindowChildFunc#

    C_WindowChildFunc                       ,
    WindowChildFunc                         ,
    WindowChildFunc_WithClosures            ,
    drop_closures_WindowChildFunc           ,
    dynamic_WindowChildFunc                 ,
    genClosure_WindowChildFunc              ,
    mk_WindowChildFunc                      ,
    noWindowChildFunc                       ,
    noWindowChildFunc_WithClosures          ,
    wrap_WindowChildFunc                    ,


-- ** WindowInvalidateHandlerFunc #signal:WindowInvalidateHandlerFunc#

    C_WindowInvalidateHandlerFunc           ,
    WindowInvalidateHandlerFunc             ,
    dynamic_WindowInvalidateHandlerFunc     ,
    genClosure_WindowInvalidateHandlerFunc  ,
    mk_WindowInvalidateHandlerFunc          ,
    noWindowInvalidateHandlerFunc           ,
    wrap_WindowInvalidateHandlerFunc        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.Cairo.Structs.Region as Cairo.Region
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event

#endif

-- callback WindowInvalidateHandlerFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "window"
          , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "region"
          , argType =
              TInterface Name { namespace = "cairo" , name = "Region" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #cairo_region_t" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Whenever some area of the window is invalidated (directly in the\nwindow or in a child window) this gets called with @region in\nthe coordinate space of @window. You can use @region to just\nkeep track of the dirty region, or you can actually change\n@region in case you are doing display tricks like showing\na child in multiple places."
        , sinceVersion = Just "3.10"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WindowInvalidateHandlerFunc =
    Ptr Gdk.Window.Window ->
    Ptr Cairo.Region.Region ->
    IO ()

-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #cairo_region_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WindowInvalidateHandlerFunc :: FunPtr C_WindowInvalidateHandlerFunc -> C_WindowInvalidateHandlerFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WindowInvalidateHandlerFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    FunPtr C_WindowInvalidateHandlerFunc
    -> a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Region.Region
    -- ^ /@region@/: a t'GI.Cairo.Structs.Region.Region'
    -> m ()
dynamic_WindowInvalidateHandlerFunc __funPtr window region = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    region' <- unsafeManagedPtrGetPtr region
    (__dynamic_C_WindowInvalidateHandlerFunc __funPtr) window' region'
    touchManagedPtr window
    touchManagedPtr region
    return ()

-- | Generate a function pointer callable from C code, from a `C_WindowInvalidateHandlerFunc`.
foreign import ccall "wrapper"
    mk_WindowInvalidateHandlerFunc :: C_WindowInvalidateHandlerFunc -> IO (FunPtr C_WindowInvalidateHandlerFunc)

-- | Whenever some area of the window is invalidated (directly in the
-- window or in a child window) this gets called with /@region@/ in
-- the coordinate space of /@window@/. You can use /@region@/ to just
-- keep track of the dirty region, or you can actually change
-- /@region@/ in case you are doing display tricks like showing
-- a child in multiple places.
-- 
-- /Since: 3.10/
type WindowInvalidateHandlerFunc =
    Gdk.Window.Window
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Cairo.Region.Region
    -- ^ /@region@/: a t'GI.Cairo.Structs.Region.Region'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WindowInvalidateHandlerFunc`@.
noWindowInvalidateHandlerFunc :: Maybe WindowInvalidateHandlerFunc
noWindowInvalidateHandlerFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WindowInvalidateHandlerFunc :: MonadIO m => WindowInvalidateHandlerFunc -> m (GClosure C_WindowInvalidateHandlerFunc)
genClosure_WindowInvalidateHandlerFunc cb = liftIO $ do
    let cb' = wrap_WindowInvalidateHandlerFunc Nothing cb
    mk_WindowInvalidateHandlerFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `WindowInvalidateHandlerFunc` into a `C_WindowInvalidateHandlerFunc`.
wrap_WindowInvalidateHandlerFunc :: 
    Maybe (Ptr (FunPtr C_WindowInvalidateHandlerFunc)) ->
    WindowInvalidateHandlerFunc ->
    C_WindowInvalidateHandlerFunc
wrap_WindowInvalidateHandlerFunc gi'funptrptr gi'cb window region = do
    window' <- (newObject Gdk.Window.Window) window
    B.ManagedPtr.withTransient  region $ \region' -> do
        gi'cb  window' region'
        maybeReleaseFunPtr gi'funptrptr


-- callback WindowChildFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE to invalidate @window recursively"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "window"
          , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function of this type is passed to gdk_window_invalidate_maybe_recurse().\nIt gets called for each child of the window to determine whether to\nrecursively invalidate it or now."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WindowChildFunc =
    Ptr Gdk.Window.Window ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WindowChildFunc :: FunPtr C_WindowChildFunc -> C_WindowChildFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WindowChildFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    FunPtr C_WindowChildFunc
    -> a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Bool
    -- ^ __Returns:__ 'P.True' to invalidate /@window@/ recursively
dynamic_WindowChildFunc __funPtr window userData = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- (__dynamic_C_WindowChildFunc __funPtr) window' userData
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

-- | Generate a function pointer callable from C code, from a `C_WindowChildFunc`.
foreign import ccall "wrapper"
    mk_WindowChildFunc :: C_WindowChildFunc -> IO (FunPtr C_WindowChildFunc)

-- | A function of this type is passed to 'GI.Gdk.Objects.Window.windowInvalidateMaybeRecurse'.
-- It gets called for each child of the window to determine whether to
-- recursively invalidate it or now.
type WindowChildFunc =
    Gdk.Window.Window
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to invalidate /@window@/ recursively

-- | A convenience synonym for @`Nothing` :: `Maybe` `WindowChildFunc`@.
noWindowChildFunc :: Maybe WindowChildFunc
noWindowChildFunc = Nothing

-- | A function of this type is passed to 'GI.Gdk.Objects.Window.windowInvalidateMaybeRecurse'.
-- It gets called for each child of the window to determine whether to
-- recursively invalidate it or now.
type WindowChildFunc_WithClosures =
    Gdk.Window.Window
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to invalidate /@window@/ recursively

-- | A convenience synonym for @`Nothing` :: `Maybe` `WindowChildFunc_WithClosures`@.
noWindowChildFunc_WithClosures :: Maybe WindowChildFunc_WithClosures
noWindowChildFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_WindowChildFunc :: WindowChildFunc -> WindowChildFunc_WithClosures
drop_closures_WindowChildFunc _f window _ = _f window

-- | Wrap the callback into a `GClosure`.
genClosure_WindowChildFunc :: MonadIO m => WindowChildFunc -> m (GClosure C_WindowChildFunc)
genClosure_WindowChildFunc cb = liftIO $ do
    let cb' = drop_closures_WindowChildFunc cb
    let cb'' = wrap_WindowChildFunc Nothing cb'
    mk_WindowChildFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `WindowChildFunc` into a `C_WindowChildFunc`.
wrap_WindowChildFunc :: 
    Maybe (Ptr (FunPtr C_WindowChildFunc)) ->
    WindowChildFunc_WithClosures ->
    C_WindowChildFunc
wrap_WindowChildFunc gi'funptrptr gi'cb window userData = do
    window' <- (newObject Gdk.Window.Window) window
    result <- gi'cb  window' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback SeatGrabPrepareFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "seat"
          , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GdkSeat being grabbed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "window"
          , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GdkWindow being grabbed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed in gdk_seat_grab()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Type of the callback used to set up @window so it can be\ngrabbed. A typical action would be ensuring the window is\nvisible, although there's room for other initialization\nactions."
        , sinceVersion = Just "3.20"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SeatGrabPrepareFunc =
    Ptr Gdk.Seat.Seat ->
    Ptr Gdk.Window.Window ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "seat"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Seat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkSeat being grabbed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkWindow being grabbed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed in gdk_seat_grab()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SeatGrabPrepareFunc :: FunPtr C_SeatGrabPrepareFunc -> C_SeatGrabPrepareFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SeatGrabPrepareFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Seat.IsSeat a, Gdk.Window.IsWindow b) =>
    FunPtr C_SeatGrabPrepareFunc
    -> a
    -- ^ /@seat@/: the t'GI.Gdk.Objects.Seat.Seat' being grabbed
    -> b
    -- ^ /@window@/: the t'GI.Gdk.Objects.Window.Window' being grabbed
    -> Ptr ()
    -- ^ /@userData@/: user data passed in 'GI.Gdk.Objects.Seat.seatGrab'
    -> m ()
dynamic_SeatGrabPrepareFunc __funPtr seat window userData = liftIO $ do
    seat' <- unsafeManagedPtrCastPtr seat
    window' <- unsafeManagedPtrCastPtr window
    (__dynamic_C_SeatGrabPrepareFunc __funPtr) seat' window' userData
    touchManagedPtr seat
    touchManagedPtr window
    return ()

-- | Generate a function pointer callable from C code, from a `C_SeatGrabPrepareFunc`.
foreign import ccall "wrapper"
    mk_SeatGrabPrepareFunc :: C_SeatGrabPrepareFunc -> IO (FunPtr C_SeatGrabPrepareFunc)

-- | Type of the callback used to set up /@window@/ so it can be
-- grabbed. A typical action would be ensuring the window is
-- visible, although there\'s room for other initialization
-- actions.
-- 
-- /Since: 3.20/
type SeatGrabPrepareFunc =
    Gdk.Seat.Seat
    -- ^ /@seat@/: the t'GI.Gdk.Objects.Seat.Seat' being grabbed
    -> Gdk.Window.Window
    -- ^ /@window@/: the t'GI.Gdk.Objects.Window.Window' being grabbed
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SeatGrabPrepareFunc`@.
noSeatGrabPrepareFunc :: Maybe SeatGrabPrepareFunc
noSeatGrabPrepareFunc = Nothing

-- | Type of the callback used to set up /@window@/ so it can be
-- grabbed. A typical action would be ensuring the window is
-- visible, although there\'s room for other initialization
-- actions.
-- 
-- /Since: 3.20/
type SeatGrabPrepareFunc_WithClosures =
    Gdk.Seat.Seat
    -- ^ /@seat@/: the t'GI.Gdk.Objects.Seat.Seat' being grabbed
    -> Gdk.Window.Window
    -- ^ /@window@/: the t'GI.Gdk.Objects.Window.Window' being grabbed
    -> Ptr ()
    -- ^ /@userData@/: user data passed in 'GI.Gdk.Objects.Seat.seatGrab'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SeatGrabPrepareFunc_WithClosures`@.
noSeatGrabPrepareFunc_WithClosures :: Maybe SeatGrabPrepareFunc_WithClosures
noSeatGrabPrepareFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_SeatGrabPrepareFunc :: SeatGrabPrepareFunc -> SeatGrabPrepareFunc_WithClosures
drop_closures_SeatGrabPrepareFunc _f seat window _ = _f seat window

-- | Wrap the callback into a `GClosure`.
genClosure_SeatGrabPrepareFunc :: MonadIO m => SeatGrabPrepareFunc -> m (GClosure C_SeatGrabPrepareFunc)
genClosure_SeatGrabPrepareFunc cb = liftIO $ do
    let cb' = drop_closures_SeatGrabPrepareFunc cb
    let cb'' = wrap_SeatGrabPrepareFunc Nothing cb'
    mk_SeatGrabPrepareFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `SeatGrabPrepareFunc` into a `C_SeatGrabPrepareFunc`.
wrap_SeatGrabPrepareFunc :: 
    Maybe (Ptr (FunPtr C_SeatGrabPrepareFunc)) ->
    SeatGrabPrepareFunc_WithClosures ->
    C_SeatGrabPrepareFunc
wrap_SeatGrabPrepareFunc gi'funptrptr gi'cb seat window userData = do
    seat' <- (newObject Gdk.Seat.Seat) seat
    window' <- (newObject Gdk.Window.Window) window
    gi'cb  seat' window' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback FilterFunc
{- Callable
  { returnType =
      Just
        (TInterface Name { namespace = "Gdk" , name = "FilterReturn" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a #GdkFilterReturn value."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "xevent"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the native event to filter."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "event"
          , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the GDK event to which the X event will be translated."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data set when the filter was installed."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function used to filter native events before they are\nconverted to GDK events.\n\nWhen a filter is called, @event is unpopulated, except for\n`event->window`. The filter may translate the native\nevent to a GDK event and store the result in @event, or handle it without\ntranslation. If the filter translates the event and processing should\ncontinue, it should return %GDK_FILTER_TRANSLATE."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FilterFunc =
    Ptr () ->
    Ptr Gdk.Event.Event ->
    Ptr () ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "xevent"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the native event to filter."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the GDK event to which the X event will be translated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data set when the filter was installed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "FilterReturn" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FilterFunc :: FunPtr C_FilterFunc -> C_FilterFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FilterFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FilterFunc
    -> Ptr ()
    -- ^ /@xevent@/: the native event to filter.
    -> Gdk.Event.Event
    -- ^ /@event@/: the GDK event to which the X event will be translated.
    -> Ptr ()
    -- ^ /@data@/: user data set when the filter was installed.
    -> m Gdk.Enums.FilterReturn
    -- ^ __Returns:__ a t'GI.Gdk.Enums.FilterReturn' value.
dynamic_FilterFunc __funPtr xevent event data_ = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- (__dynamic_C_FilterFunc __funPtr) xevent event' data_
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

-- | Generate a function pointer callable from C code, from a `C_FilterFunc`.
foreign import ccall "wrapper"
    mk_FilterFunc :: C_FilterFunc -> IO (FunPtr C_FilterFunc)

-- | Specifies the type of function used to filter native events before they are
-- converted to GDK events.
-- 
-- When a filter is called, /@event@/ is unpopulated, except for
-- @event->window@. The filter may translate the native
-- event to a GDK event and store the result in /@event@/, or handle it without
-- translation. If the filter translates the event and processing should
-- continue, it should return 'GI.Gdk.Enums.FilterReturnTranslate'.
type FilterFunc =
    Ptr ()
    -- ^ /@xevent@/: the native event to filter.
    -> Gdk.Event.Event
    -- ^ /@event@/: the GDK event to which the X event will be translated.
    -> IO Gdk.Enums.FilterReturn
    -- ^ __Returns:__ a t'GI.Gdk.Enums.FilterReturn' value.

-- | A convenience synonym for @`Nothing` :: `Maybe` `FilterFunc`@.
noFilterFunc :: Maybe FilterFunc
noFilterFunc = Nothing

-- | Specifies the type of function used to filter native events before they are
-- converted to GDK events.
-- 
-- When a filter is called, /@event@/ is unpopulated, except for
-- @event->window@. The filter may translate the native
-- event to a GDK event and store the result in /@event@/, or handle it without
-- translation. If the filter translates the event and processing should
-- continue, it should return 'GI.Gdk.Enums.FilterReturnTranslate'.
type FilterFunc_WithClosures =
    Ptr ()
    -- ^ /@xevent@/: the native event to filter.
    -> Gdk.Event.Event
    -- ^ /@event@/: the GDK event to which the X event will be translated.
    -> Ptr ()
    -- ^ /@data@/: user data set when the filter was installed.
    -> IO Gdk.Enums.FilterReturn
    -- ^ __Returns:__ a t'GI.Gdk.Enums.FilterReturn' value.

-- | A convenience synonym for @`Nothing` :: `Maybe` `FilterFunc_WithClosures`@.
noFilterFunc_WithClosures :: Maybe FilterFunc_WithClosures
noFilterFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FilterFunc :: FilterFunc -> FilterFunc_WithClosures
drop_closures_FilterFunc _f xevent event _ = _f xevent event

-- | Wrap the callback into a `GClosure`.
genClosure_FilterFunc :: MonadIO m => FilterFunc -> m (GClosure C_FilterFunc)
genClosure_FilterFunc cb = liftIO $ do
    let cb' = drop_closures_FilterFunc cb
    let cb'' = wrap_FilterFunc Nothing cb'
    mk_FilterFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FilterFunc` into a `C_FilterFunc`.
wrap_FilterFunc :: 
    Maybe (Ptr (FunPtr C_FilterFunc)) ->
    FilterFunc_WithClosures ->
    C_FilterFunc
wrap_FilterFunc gi'funptrptr gi'cb xevent event data_ = do
    B.ManagedPtr.withTransient  event $ \event' -> do
        result <- gi'cb  xevent event' data_
        maybeReleaseFunPtr gi'funptrptr
        let result' = (fromIntegral . fromEnum) result
        return result'


-- callback EventFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "event"
          , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GdkEvent to process."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "user data set when the event handler was installed with\n  gdk_event_handler_set()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to gdk_event_handler_set() to\nhandle all GDK events."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_EventFunc =
    Ptr Gdk.Event.Event ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkEvent to process."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data set when the event handler was installed with\n  gdk_event_handler_set()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_EventFunc :: FunPtr C_EventFunc -> C_EventFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_EventFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_EventFunc
    -> Gdk.Event.Event
    -- ^ /@event@/: the t'GI.Gdk.Unions.Event.Event' to process.
    -> Ptr ()
    -- ^ /@data@/: user data set when the event handler was installed with
    --   'GI.Gdk.Functions.eventHandlerSet'.
    -> m ()
dynamic_EventFunc __funPtr event data_ = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    (__dynamic_C_EventFunc __funPtr) event' data_
    touchManagedPtr event
    return ()

-- | Generate a function pointer callable from C code, from a `C_EventFunc`.
foreign import ccall "wrapper"
    mk_EventFunc :: C_EventFunc -> IO (FunPtr C_EventFunc)

-- | Specifies the type of function passed to 'GI.Gdk.Functions.eventHandlerSet' to
-- handle all GDK events.
type EventFunc =
    Gdk.Event.Event
    -- ^ /@event@/: the t'GI.Gdk.Unions.Event.Event' to process.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `EventFunc`@.
noEventFunc :: Maybe EventFunc
noEventFunc = Nothing

-- | Specifies the type of function passed to 'GI.Gdk.Functions.eventHandlerSet' to
-- handle all GDK events.
type EventFunc_WithClosures =
    Gdk.Event.Event
    -- ^ /@event@/: the t'GI.Gdk.Unions.Event.Event' to process.
    -> Ptr ()
    -- ^ /@data@/: user data set when the event handler was installed with
    --   'GI.Gdk.Functions.eventHandlerSet'.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `EventFunc_WithClosures`@.
noEventFunc_WithClosures :: Maybe EventFunc_WithClosures
noEventFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_EventFunc :: EventFunc -> EventFunc_WithClosures
drop_closures_EventFunc _f event _ = _f event

-- | Wrap the callback into a `GClosure`.
genClosure_EventFunc :: MonadIO m => EventFunc -> m (GClosure C_EventFunc)
genClosure_EventFunc cb = liftIO $ do
    let cb' = drop_closures_EventFunc cb
    let cb'' = wrap_EventFunc Nothing cb'
    mk_EventFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `EventFunc` into a `C_EventFunc`.
wrap_EventFunc :: 
    Maybe (Ptr (FunPtr C_EventFunc)) ->
    EventFunc_WithClosures ->
    C_EventFunc
wrap_EventFunc gi'funptrptr gi'cb event data_ = do
    B.ManagedPtr.withTransient  event $ \event' -> do
        gi'cb  event' data_
        maybeReleaseFunPtr gi'funptrptr



