{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.DeviceTool
    ( 

-- * Exported types
    DeviceTool(..)                          ,
    IsDeviceTool                            ,
    toDeviceTool                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getHardwareId]("GI.Gdk.Objects.DeviceTool#g:method:getHardwareId"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSerial]("GI.Gdk.Objects.DeviceTool#g:method:getSerial"), [getToolType]("GI.Gdk.Objects.DeviceTool#g:method:getToolType").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDeviceToolMethod                 ,
#endif

-- ** getHardwareId #method:getHardwareId#

#if defined(ENABLE_OVERLOADING)
    DeviceToolGetHardwareIdMethodInfo       ,
#endif
    deviceToolGetHardwareId                 ,


-- ** getSerial #method:getSerial#

#if defined(ENABLE_OVERLOADING)
    DeviceToolGetSerialMethodInfo           ,
#endif
    deviceToolGetSerial                     ,


-- ** getToolType #method:getToolType#

#if defined(ENABLE_OVERLOADING)
    DeviceToolGetToolTypeMethodInfo         ,
#endif
    deviceToolGetToolType                   ,




 -- * Properties


-- ** axes #attr:axes#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    DeviceToolAxesPropertyInfo              ,
#endif
    constructDeviceToolAxes                 ,
#if defined(ENABLE_OVERLOADING)
    deviceToolAxes                          ,
#endif
    getDeviceToolAxes                       ,


-- ** hardwareId #attr:hardwareId#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    DeviceToolHardwareIdPropertyInfo        ,
#endif
    constructDeviceToolHardwareId           ,
#if defined(ENABLE_OVERLOADING)
    deviceToolHardwareId                    ,
#endif
    getDeviceToolHardwareId                 ,


-- ** serial #attr:serial#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    DeviceToolSerialPropertyInfo            ,
#endif
    constructDeviceToolSerial               ,
#if defined(ENABLE_OVERLOADING)
    deviceToolSerial                        ,
#endif
    getDeviceToolSerial                     ,


-- ** toolType #attr:toolType#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    DeviceToolToolTypePropertyInfo          ,
#endif
    constructDeviceToolToolType             ,
#if defined(ENABLE_OVERLOADING)
    deviceToolToolType                      ,
#endif
    getDeviceToolToolType                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags

#endif

-- | Memory-managed wrapper type.
newtype DeviceTool = DeviceTool (SP.ManagedPtr DeviceTool)
    deriving (Eq)

instance SP.ManagedPtrNewtype DeviceTool where
    toManagedPtr (DeviceTool p) = p

foreign import ccall "gdk_device_tool_get_type"
    c_gdk_device_tool_get_type :: IO B.Types.GType

instance B.Types.TypedObject DeviceTool where
    glibType = c_gdk_device_tool_get_type

instance B.Types.GObject DeviceTool

-- | Type class for types which can be safely cast to t'DeviceTool', for instance with `toDeviceTool`.
class (SP.GObject o, O.IsDescendantOf DeviceTool o) => IsDeviceTool o
instance (SP.GObject o, O.IsDescendantOf DeviceTool o) => IsDeviceTool o

instance O.HasParentTypes DeviceTool
type instance O.ParentTypes DeviceTool = '[GObject.Object.Object]

-- | Cast to t'DeviceTool', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDeviceTool :: (MIO.MonadIO m, IsDeviceTool o) => o -> m DeviceTool
toDeviceTool = MIO.liftIO . B.ManagedPtr.unsafeCastTo DeviceTool

-- | Convert t'DeviceTool' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DeviceTool) where
    gvalueGType_ = c_gdk_device_tool_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DeviceTool)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DeviceTool)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DeviceTool ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDeviceToolMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDeviceToolMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDeviceToolMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDeviceToolMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDeviceToolMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDeviceToolMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDeviceToolMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDeviceToolMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDeviceToolMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDeviceToolMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDeviceToolMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDeviceToolMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDeviceToolMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDeviceToolMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDeviceToolMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDeviceToolMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDeviceToolMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDeviceToolMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDeviceToolMethod "getHardwareId" o = DeviceToolGetHardwareIdMethodInfo
    ResolveDeviceToolMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDeviceToolMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDeviceToolMethod "getSerial" o = DeviceToolGetSerialMethodInfo
    ResolveDeviceToolMethod "getToolType" o = DeviceToolGetToolTypeMethodInfo
    ResolveDeviceToolMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDeviceToolMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDeviceToolMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDeviceToolMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDeviceToolMethod t DeviceTool, O.OverloadedMethod info DeviceTool p) => OL.IsLabel t (DeviceTool -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDeviceToolMethod t DeviceTool, O.OverloadedMethod info DeviceTool p, R.HasField t DeviceTool p) => R.HasField t DeviceTool p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDeviceToolMethod t DeviceTool, O.OverloadedMethodInfo info DeviceTool) => OL.IsLabel t (O.MethodProxy info DeviceTool) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "axes"
   -- Type: TInterface (Name {namespace = "Gdk", name = "AxisFlags"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@axes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' deviceTool #axes
-- @
getDeviceToolAxes :: (MonadIO m, IsDeviceTool o) => o -> m [Gdk.Flags.AxisFlags]
getDeviceToolAxes obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "axes"

-- | Construct a t'GValueConstruct' with valid value for the “@axes@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceToolAxes :: (IsDeviceTool o, MIO.MonadIO m) => [Gdk.Flags.AxisFlags] -> m (GValueConstruct o)
constructDeviceToolAxes val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "axes" val

#if defined(ENABLE_OVERLOADING)
data DeviceToolAxesPropertyInfo
instance AttrInfo DeviceToolAxesPropertyInfo where
    type AttrAllowedOps DeviceToolAxesPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceToolAxesPropertyInfo = IsDeviceTool
    type AttrSetTypeConstraint DeviceToolAxesPropertyInfo = (~) [Gdk.Flags.AxisFlags]
    type AttrTransferTypeConstraint DeviceToolAxesPropertyInfo = (~) [Gdk.Flags.AxisFlags]
    type AttrTransferType DeviceToolAxesPropertyInfo = [Gdk.Flags.AxisFlags]
    type AttrGetType DeviceToolAxesPropertyInfo = [Gdk.Flags.AxisFlags]
    type AttrLabel DeviceToolAxesPropertyInfo = "axes"
    type AttrOrigin DeviceToolAxesPropertyInfo = DeviceTool
    attrGet = getDeviceToolAxes
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceToolAxes
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DeviceTool.axes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DeviceTool.html#g:attr:axes"
        })
#endif

-- VVV Prop "hardware-id"
   -- Type: TBasicType TUInt64
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@hardware-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' deviceTool #hardwareId
-- @
getDeviceToolHardwareId :: (MonadIO m, IsDeviceTool o) => o -> m Word64
getDeviceToolHardwareId obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt64 obj "hardware-id"

-- | Construct a t'GValueConstruct' with valid value for the “@hardware-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceToolHardwareId :: (IsDeviceTool o, MIO.MonadIO m) => Word64 -> m (GValueConstruct o)
constructDeviceToolHardwareId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt64 "hardware-id" val

#if defined(ENABLE_OVERLOADING)
data DeviceToolHardwareIdPropertyInfo
instance AttrInfo DeviceToolHardwareIdPropertyInfo where
    type AttrAllowedOps DeviceToolHardwareIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceToolHardwareIdPropertyInfo = IsDeviceTool
    type AttrSetTypeConstraint DeviceToolHardwareIdPropertyInfo = (~) Word64
    type AttrTransferTypeConstraint DeviceToolHardwareIdPropertyInfo = (~) Word64
    type AttrTransferType DeviceToolHardwareIdPropertyInfo = Word64
    type AttrGetType DeviceToolHardwareIdPropertyInfo = Word64
    type AttrLabel DeviceToolHardwareIdPropertyInfo = "hardware-id"
    type AttrOrigin DeviceToolHardwareIdPropertyInfo = DeviceTool
    attrGet = getDeviceToolHardwareId
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceToolHardwareId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DeviceTool.hardwareId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DeviceTool.html#g:attr:hardwareId"
        })
#endif

-- VVV Prop "serial"
   -- Type: TBasicType TUInt64
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@serial@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' deviceTool #serial
-- @
getDeviceToolSerial :: (MonadIO m, IsDeviceTool o) => o -> m Word64
getDeviceToolSerial obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt64 obj "serial"

-- | Construct a t'GValueConstruct' with valid value for the “@serial@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceToolSerial :: (IsDeviceTool o, MIO.MonadIO m) => Word64 -> m (GValueConstruct o)
constructDeviceToolSerial val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt64 "serial" val

#if defined(ENABLE_OVERLOADING)
data DeviceToolSerialPropertyInfo
instance AttrInfo DeviceToolSerialPropertyInfo where
    type AttrAllowedOps DeviceToolSerialPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceToolSerialPropertyInfo = IsDeviceTool
    type AttrSetTypeConstraint DeviceToolSerialPropertyInfo = (~) Word64
    type AttrTransferTypeConstraint DeviceToolSerialPropertyInfo = (~) Word64
    type AttrTransferType DeviceToolSerialPropertyInfo = Word64
    type AttrGetType DeviceToolSerialPropertyInfo = Word64
    type AttrLabel DeviceToolSerialPropertyInfo = "serial"
    type AttrOrigin DeviceToolSerialPropertyInfo = DeviceTool
    attrGet = getDeviceToolSerial
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceToolSerial
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DeviceTool.serial"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DeviceTool.html#g:attr:serial"
        })
#endif

-- VVV Prop "tool-type"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DeviceToolType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@tool-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' deviceTool #toolType
-- @
getDeviceToolToolType :: (MonadIO m, IsDeviceTool o) => o -> m Gdk.Enums.DeviceToolType
getDeviceToolToolType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "tool-type"

-- | Construct a t'GValueConstruct' with valid value for the “@tool-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceToolToolType :: (IsDeviceTool o, MIO.MonadIO m) => Gdk.Enums.DeviceToolType -> m (GValueConstruct o)
constructDeviceToolToolType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "tool-type" val

#if defined(ENABLE_OVERLOADING)
data DeviceToolToolTypePropertyInfo
instance AttrInfo DeviceToolToolTypePropertyInfo where
    type AttrAllowedOps DeviceToolToolTypePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceToolToolTypePropertyInfo = IsDeviceTool
    type AttrSetTypeConstraint DeviceToolToolTypePropertyInfo = (~) Gdk.Enums.DeviceToolType
    type AttrTransferTypeConstraint DeviceToolToolTypePropertyInfo = (~) Gdk.Enums.DeviceToolType
    type AttrTransferType DeviceToolToolTypePropertyInfo = Gdk.Enums.DeviceToolType
    type AttrGetType DeviceToolToolTypePropertyInfo = Gdk.Enums.DeviceToolType
    type AttrLabel DeviceToolToolTypePropertyInfo = "tool-type"
    type AttrOrigin DeviceToolToolTypePropertyInfo = DeviceTool
    attrGet = getDeviceToolToolType
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceToolToolType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DeviceTool.toolType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DeviceTool.html#g:attr:toolType"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DeviceTool
type instance O.AttributeList DeviceTool = DeviceToolAttributeList
type DeviceToolAttributeList = ('[ '("axes", DeviceToolAxesPropertyInfo), '("hardwareId", DeviceToolHardwareIdPropertyInfo), '("serial", DeviceToolSerialPropertyInfo), '("toolType", DeviceToolToolTypePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
deviceToolAxes :: AttrLabelProxy "axes"
deviceToolAxes = AttrLabelProxy

deviceToolHardwareId :: AttrLabelProxy "hardwareId"
deviceToolHardwareId = AttrLabelProxy

deviceToolSerial :: AttrLabelProxy "serial"
deviceToolSerial = AttrLabelProxy

deviceToolToolType :: AttrLabelProxy "toolType"
deviceToolToolType = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DeviceTool = DeviceToolSignalList
type DeviceToolSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DeviceTool::get_hardware_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tool"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DeviceTool" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDeviceTool" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_tool_get_hardware_id" gdk_device_tool_get_hardware_id :: 
    Ptr DeviceTool ->                       -- tool : TInterface (Name {namespace = "Gdk", name = "DeviceTool"})
    IO Word64

-- | Gets the hardware ID of this tool, or 0 if it\'s not known. When
-- non-zero, the identificator is unique for the given tool model,
-- meaning that two identical tools will share the same /@hardwareId@/,
-- but will have different serial numbers (see 'GI.Gdk.Objects.DeviceTool.deviceToolGetSerial').
-- 
-- This is a more concrete (and device specific) method to identify
-- a t'GI.Gdk.Objects.DeviceTool.DeviceTool' than 'GI.Gdk.Objects.DeviceTool.deviceToolGetToolType', as a tablet
-- may support multiple devices with the same t'GI.Gdk.Enums.DeviceToolType',
-- but having different hardware identificators.
-- 
-- /Since: 3.22/
deviceToolGetHardwareId ::
    (B.CallStack.HasCallStack, MonadIO m, IsDeviceTool a) =>
    a
    -- ^ /@tool@/: a t'GI.Gdk.Objects.DeviceTool.DeviceTool'
    -> m Word64
    -- ^ __Returns:__ The hardware identificator of this tool.
deviceToolGetHardwareId tool = liftIO $ do
    tool' <- unsafeManagedPtrCastPtr tool
    result <- gdk_device_tool_get_hardware_id tool'
    touchManagedPtr tool
    return result

#if defined(ENABLE_OVERLOADING)
data DeviceToolGetHardwareIdMethodInfo
instance (signature ~ (m Word64), MonadIO m, IsDeviceTool a) => O.OverloadedMethod DeviceToolGetHardwareIdMethodInfo a signature where
    overloadedMethod = deviceToolGetHardwareId

instance O.OverloadedMethodInfo DeviceToolGetHardwareIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DeviceTool.deviceToolGetHardwareId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DeviceTool.html#v:deviceToolGetHardwareId"
        })


#endif

-- method DeviceTool::get_serial
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tool"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DeviceTool" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDeviceTool" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_tool_get_serial" gdk_device_tool_get_serial :: 
    Ptr DeviceTool ->                       -- tool : TInterface (Name {namespace = "Gdk", name = "DeviceTool"})
    IO Word64

-- | Gets the serial of this tool, this value can be used to identify a
-- physical tool (eg. a tablet pen) across program executions.
-- 
-- /Since: 3.22/
deviceToolGetSerial ::
    (B.CallStack.HasCallStack, MonadIO m, IsDeviceTool a) =>
    a
    -- ^ /@tool@/: a t'GI.Gdk.Objects.DeviceTool.DeviceTool'
    -> m Word64
    -- ^ __Returns:__ The serial ID for this tool
deviceToolGetSerial tool = liftIO $ do
    tool' <- unsafeManagedPtrCastPtr tool
    result <- gdk_device_tool_get_serial tool'
    touchManagedPtr tool
    return result

#if defined(ENABLE_OVERLOADING)
data DeviceToolGetSerialMethodInfo
instance (signature ~ (m Word64), MonadIO m, IsDeviceTool a) => O.OverloadedMethod DeviceToolGetSerialMethodInfo a signature where
    overloadedMethod = deviceToolGetSerial

instance O.OverloadedMethodInfo DeviceToolGetSerialMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DeviceTool.deviceToolGetSerial",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DeviceTool.html#v:deviceToolGetSerial"
        })


#endif

-- method DeviceTool::get_tool_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tool"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DeviceTool" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDeviceTool" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "DeviceToolType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_tool_get_tool_type" gdk_device_tool_get_tool_type :: 
    Ptr DeviceTool ->                       -- tool : TInterface (Name {namespace = "Gdk", name = "DeviceTool"})
    IO CUInt

-- | Gets the t'GI.Gdk.Enums.DeviceToolType' of the tool.
-- 
-- /Since: 3.22/
deviceToolGetToolType ::
    (B.CallStack.HasCallStack, MonadIO m, IsDeviceTool a) =>
    a
    -- ^ /@tool@/: a t'GI.Gdk.Objects.DeviceTool.DeviceTool'
    -> m Gdk.Enums.DeviceToolType
    -- ^ __Returns:__ The physical type for this tool. This can be used to figure out what
    -- sort of pen is being used, such as an airbrush or a pencil.
deviceToolGetToolType tool = liftIO $ do
    tool' <- unsafeManagedPtrCastPtr tool
    result <- gdk_device_tool_get_tool_type tool'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr tool
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceToolGetToolTypeMethodInfo
instance (signature ~ (m Gdk.Enums.DeviceToolType), MonadIO m, IsDeviceTool a) => O.OverloadedMethod DeviceToolGetToolTypeMethodInfo a signature where
    overloadedMethod = deviceToolGetToolType

instance O.OverloadedMethodInfo DeviceToolGetToolTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DeviceTool.deviceToolGetToolType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DeviceTool.html#v:deviceToolGetToolType"
        })


#endif


