{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gdk.Objects.Screen.Screen' objects are the GDK representation of the screen on
-- which windows can be displayed and on which the pointer moves.
-- X originally identified screens with physical screens, but
-- nowadays it is more common to have a single t'GI.Gdk.Objects.Screen.Screen' which
-- combines several physical monitors (see 'GI.Gdk.Objects.Screen.screenGetNMonitors').
-- 
-- GdkScreen is used throughout GDK and GTK+ to specify which screen
-- the top level windows are to be displayed on. it is also used to
-- query the screen specification and default settings such as
-- the default visual ('GI.Gdk.Objects.Screen.screenGetSystemVisual'), the dimensions
-- of the physical monitors ('GI.Gdk.Objects.Screen.screenGetMonitorGeometry'), etc.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Screen
    ( 

-- * Exported types
    Screen(..)                              ,
    IsScreen                                ,
    toScreen                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isComposited]("GI.Gdk.Objects.Screen#g:method:isComposited"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listVisuals]("GI.Gdk.Objects.Screen#g:method:listVisuals"), [makeDisplayName]("GI.Gdk.Objects.Screen#g:method:makeDisplayName"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActiveWindow]("GI.Gdk.Objects.Screen#g:method:getActiveWindow"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.Screen#g:method:getDisplay"), [getFontOptions]("GI.Gdk.Objects.Screen#g:method:getFontOptions"), [getHeight]("GI.Gdk.Objects.Screen#g:method:getHeight"), [getHeightMm]("GI.Gdk.Objects.Screen#g:method:getHeightMm"), [getMonitorAtPoint]("GI.Gdk.Objects.Screen#g:method:getMonitorAtPoint"), [getMonitorAtWindow]("GI.Gdk.Objects.Screen#g:method:getMonitorAtWindow"), [getMonitorGeometry]("GI.Gdk.Objects.Screen#g:method:getMonitorGeometry"), [getMonitorHeightMm]("GI.Gdk.Objects.Screen#g:method:getMonitorHeightMm"), [getMonitorPlugName]("GI.Gdk.Objects.Screen#g:method:getMonitorPlugName"), [getMonitorScaleFactor]("GI.Gdk.Objects.Screen#g:method:getMonitorScaleFactor"), [getMonitorWidthMm]("GI.Gdk.Objects.Screen#g:method:getMonitorWidthMm"), [getMonitorWorkarea]("GI.Gdk.Objects.Screen#g:method:getMonitorWorkarea"), [getNMonitors]("GI.Gdk.Objects.Screen#g:method:getNMonitors"), [getNumber]("GI.Gdk.Objects.Screen#g:method:getNumber"), [getPrimaryMonitor]("GI.Gdk.Objects.Screen#g:method:getPrimaryMonitor"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getResolution]("GI.Gdk.Objects.Screen#g:method:getResolution"), [getRgbaVisual]("GI.Gdk.Objects.Screen#g:method:getRgbaVisual"), [getRootWindow]("GI.Gdk.Objects.Screen#g:method:getRootWindow"), [getSetting]("GI.Gdk.Objects.Screen#g:method:getSetting"), [getSystemVisual]("GI.Gdk.Objects.Screen#g:method:getSystemVisual"), [getToplevelWindows]("GI.Gdk.Objects.Screen#g:method:getToplevelWindows"), [getWidth]("GI.Gdk.Objects.Screen#g:method:getWidth"), [getWidthMm]("GI.Gdk.Objects.Screen#g:method:getWidthMm"), [getWindowStack]("GI.Gdk.Objects.Screen#g:method:getWindowStack").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFontOptions]("GI.Gdk.Objects.Screen#g:method:setFontOptions"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setResolution]("GI.Gdk.Objects.Screen#g:method:setResolution").

#if defined(ENABLE_OVERLOADING)
    ResolveScreenMethod                     ,
#endif

-- ** getActiveWindow #method:getActiveWindow#

#if defined(ENABLE_OVERLOADING)
    ScreenGetActiveWindowMethodInfo         ,
#endif
    screenGetActiveWindow                   ,


-- ** getDefault #method:getDefault#

    screenGetDefault                        ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    ScreenGetDisplayMethodInfo              ,
#endif
    screenGetDisplay                        ,


-- ** getFontOptions #method:getFontOptions#

#if defined(ENABLE_OVERLOADING)
    ScreenGetFontOptionsMethodInfo          ,
#endif
    screenGetFontOptions                    ,


-- ** getHeight #method:getHeight#

#if defined(ENABLE_OVERLOADING)
    ScreenGetHeightMethodInfo               ,
#endif
    screenGetHeight                         ,


-- ** getHeightMm #method:getHeightMm#

#if defined(ENABLE_OVERLOADING)
    ScreenGetHeightMmMethodInfo             ,
#endif
    screenGetHeightMm                       ,


-- ** getMonitorAtPoint #method:getMonitorAtPoint#

#if defined(ENABLE_OVERLOADING)
    ScreenGetMonitorAtPointMethodInfo       ,
#endif
    screenGetMonitorAtPoint                 ,


-- ** getMonitorAtWindow #method:getMonitorAtWindow#

#if defined(ENABLE_OVERLOADING)
    ScreenGetMonitorAtWindowMethodInfo      ,
#endif
    screenGetMonitorAtWindow                ,


-- ** getMonitorGeometry #method:getMonitorGeometry#

#if defined(ENABLE_OVERLOADING)
    ScreenGetMonitorGeometryMethodInfo      ,
#endif
    screenGetMonitorGeometry                ,


-- ** getMonitorHeightMm #method:getMonitorHeightMm#

#if defined(ENABLE_OVERLOADING)
    ScreenGetMonitorHeightMmMethodInfo      ,
#endif
    screenGetMonitorHeightMm                ,


-- ** getMonitorPlugName #method:getMonitorPlugName#

#if defined(ENABLE_OVERLOADING)
    ScreenGetMonitorPlugNameMethodInfo      ,
#endif
    screenGetMonitorPlugName                ,


-- ** getMonitorScaleFactor #method:getMonitorScaleFactor#

#if defined(ENABLE_OVERLOADING)
    ScreenGetMonitorScaleFactorMethodInfo   ,
#endif
    screenGetMonitorScaleFactor             ,


-- ** getMonitorWidthMm #method:getMonitorWidthMm#

#if defined(ENABLE_OVERLOADING)
    ScreenGetMonitorWidthMmMethodInfo       ,
#endif
    screenGetMonitorWidthMm                 ,


-- ** getMonitorWorkarea #method:getMonitorWorkarea#

#if defined(ENABLE_OVERLOADING)
    ScreenGetMonitorWorkareaMethodInfo      ,
#endif
    screenGetMonitorWorkarea                ,


-- ** getNMonitors #method:getNMonitors#

#if defined(ENABLE_OVERLOADING)
    ScreenGetNMonitorsMethodInfo            ,
#endif
    screenGetNMonitors                      ,


-- ** getNumber #method:getNumber#

#if defined(ENABLE_OVERLOADING)
    ScreenGetNumberMethodInfo               ,
#endif
    screenGetNumber                         ,


-- ** getPrimaryMonitor #method:getPrimaryMonitor#

#if defined(ENABLE_OVERLOADING)
    ScreenGetPrimaryMonitorMethodInfo       ,
#endif
    screenGetPrimaryMonitor                 ,


-- ** getResolution #method:getResolution#

#if defined(ENABLE_OVERLOADING)
    ScreenGetResolutionMethodInfo           ,
#endif
    screenGetResolution                     ,


-- ** getRgbaVisual #method:getRgbaVisual#

#if defined(ENABLE_OVERLOADING)
    ScreenGetRgbaVisualMethodInfo           ,
#endif
    screenGetRgbaVisual                     ,


-- ** getRootWindow #method:getRootWindow#

#if defined(ENABLE_OVERLOADING)
    ScreenGetRootWindowMethodInfo           ,
#endif
    screenGetRootWindow                     ,


-- ** getSetting #method:getSetting#

#if defined(ENABLE_OVERLOADING)
    ScreenGetSettingMethodInfo              ,
#endif
    screenGetSetting                        ,


-- ** getSystemVisual #method:getSystemVisual#

#if defined(ENABLE_OVERLOADING)
    ScreenGetSystemVisualMethodInfo         ,
#endif
    screenGetSystemVisual                   ,


-- ** getToplevelWindows #method:getToplevelWindows#

#if defined(ENABLE_OVERLOADING)
    ScreenGetToplevelWindowsMethodInfo      ,
#endif
    screenGetToplevelWindows                ,


-- ** getWidth #method:getWidth#

#if defined(ENABLE_OVERLOADING)
    ScreenGetWidthMethodInfo                ,
#endif
    screenGetWidth                          ,


-- ** getWidthMm #method:getWidthMm#

#if defined(ENABLE_OVERLOADING)
    ScreenGetWidthMmMethodInfo              ,
#endif
    screenGetWidthMm                        ,


-- ** getWindowStack #method:getWindowStack#

#if defined(ENABLE_OVERLOADING)
    ScreenGetWindowStackMethodInfo          ,
#endif
    screenGetWindowStack                    ,


-- ** height #method:height#

    screenHeight                            ,


-- ** heightMm #method:heightMm#

    screenHeightMm                          ,


-- ** isComposited #method:isComposited#

#if defined(ENABLE_OVERLOADING)
    ScreenIsCompositedMethodInfo            ,
#endif
    screenIsComposited                      ,


-- ** listVisuals #method:listVisuals#

#if defined(ENABLE_OVERLOADING)
    ScreenListVisualsMethodInfo             ,
#endif
    screenListVisuals                       ,


-- ** makeDisplayName #method:makeDisplayName#

#if defined(ENABLE_OVERLOADING)
    ScreenMakeDisplayNameMethodInfo         ,
#endif
    screenMakeDisplayName                   ,


-- ** setFontOptions #method:setFontOptions#

#if defined(ENABLE_OVERLOADING)
    ScreenSetFontOptionsMethodInfo          ,
#endif
    screenSetFontOptions                    ,


-- ** setResolution #method:setResolution#

#if defined(ENABLE_OVERLOADING)
    ScreenSetResolutionMethodInfo           ,
#endif
    screenSetResolution                     ,


-- ** width #method:width#

    screenWidth                             ,


-- ** widthMm #method:widthMm#

    screenWidthMm                           ,




 -- * Properties


-- ** fontOptions #attr:fontOptions#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ScreenFontOptionsPropertyInfo           ,
#endif
    constructScreenFontOptions              ,
    getScreenFontOptions                    ,
#if defined(ENABLE_OVERLOADING)
    screenFontOptions                       ,
#endif
    setScreenFontOptions                    ,


-- ** resolution #attr:resolution#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ScreenResolutionPropertyInfo            ,
#endif
    constructScreenResolution               ,
    getScreenResolution                     ,
#if defined(ENABLE_OVERLOADING)
    screenResolution                        ,
#endif
    setScreenResolution                     ,




 -- * Signals


-- ** compositedChanged #signal:compositedChanged#

    ScreenCompositedChangedCallback         ,
#if defined(ENABLE_OVERLOADING)
    ScreenCompositedChangedSignalInfo       ,
#endif
    afterScreenCompositedChanged            ,
    onScreenCompositedChanged               ,


-- ** monitorsChanged #signal:monitorsChanged#

    ScreenMonitorsChangedCallback           ,
#if defined(ENABLE_OVERLOADING)
    ScreenMonitorsChangedSignalInfo         ,
#endif
    afterScreenMonitorsChanged              ,
    onScreenMonitorsChanged                 ,


-- ** sizeChanged #signal:sizeChanged#

    ScreenSizeChangedCallback               ,
#if defined(ENABLE_OVERLOADING)
    ScreenSizeChangedSignalInfo             ,
#endif
    afterScreenSizeChanged                  ,
    onScreenSizeChanged                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype Screen = Screen (SP.ManagedPtr Screen)
    deriving (Eq)

instance SP.ManagedPtrNewtype Screen where
    toManagedPtr (Screen p) = p

foreign import ccall "gdk_screen_get_type"
    c_gdk_screen_get_type :: IO B.Types.GType

instance B.Types.TypedObject Screen where
    glibType = c_gdk_screen_get_type

instance B.Types.GObject Screen

-- | Type class for types which can be safely cast to t'Screen', for instance with `toScreen`.
class (SP.GObject o, O.IsDescendantOf Screen o) => IsScreen o
instance (SP.GObject o, O.IsDescendantOf Screen o) => IsScreen o

instance O.HasParentTypes Screen
type instance O.ParentTypes Screen = '[GObject.Object.Object]

-- | Cast to t'Screen', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toScreen :: (MIO.MonadIO m, IsScreen o) => o -> m Screen
toScreen = MIO.liftIO . B.ManagedPtr.unsafeCastTo Screen

-- | Convert t'Screen' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Screen) where
    gvalueGType_ = c_gdk_screen_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Screen)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Screen)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Screen ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveScreenMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveScreenMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveScreenMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveScreenMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveScreenMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveScreenMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveScreenMethod "isComposited" o = ScreenIsCompositedMethodInfo
    ResolveScreenMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveScreenMethod "listVisuals" o = ScreenListVisualsMethodInfo
    ResolveScreenMethod "makeDisplayName" o = ScreenMakeDisplayNameMethodInfo
    ResolveScreenMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveScreenMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveScreenMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveScreenMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveScreenMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveScreenMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveScreenMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveScreenMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveScreenMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveScreenMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveScreenMethod "getActiveWindow" o = ScreenGetActiveWindowMethodInfo
    ResolveScreenMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveScreenMethod "getDisplay" o = ScreenGetDisplayMethodInfo
    ResolveScreenMethod "getFontOptions" o = ScreenGetFontOptionsMethodInfo
    ResolveScreenMethod "getHeight" o = ScreenGetHeightMethodInfo
    ResolveScreenMethod "getHeightMm" o = ScreenGetHeightMmMethodInfo
    ResolveScreenMethod "getMonitorAtPoint" o = ScreenGetMonitorAtPointMethodInfo
    ResolveScreenMethod "getMonitorAtWindow" o = ScreenGetMonitorAtWindowMethodInfo
    ResolveScreenMethod "getMonitorGeometry" o = ScreenGetMonitorGeometryMethodInfo
    ResolveScreenMethod "getMonitorHeightMm" o = ScreenGetMonitorHeightMmMethodInfo
    ResolveScreenMethod "getMonitorPlugName" o = ScreenGetMonitorPlugNameMethodInfo
    ResolveScreenMethod "getMonitorScaleFactor" o = ScreenGetMonitorScaleFactorMethodInfo
    ResolveScreenMethod "getMonitorWidthMm" o = ScreenGetMonitorWidthMmMethodInfo
    ResolveScreenMethod "getMonitorWorkarea" o = ScreenGetMonitorWorkareaMethodInfo
    ResolveScreenMethod "getNMonitors" o = ScreenGetNMonitorsMethodInfo
    ResolveScreenMethod "getNumber" o = ScreenGetNumberMethodInfo
    ResolveScreenMethod "getPrimaryMonitor" o = ScreenGetPrimaryMonitorMethodInfo
    ResolveScreenMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveScreenMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveScreenMethod "getResolution" o = ScreenGetResolutionMethodInfo
    ResolveScreenMethod "getRgbaVisual" o = ScreenGetRgbaVisualMethodInfo
    ResolveScreenMethod "getRootWindow" o = ScreenGetRootWindowMethodInfo
    ResolveScreenMethod "getSetting" o = ScreenGetSettingMethodInfo
    ResolveScreenMethod "getSystemVisual" o = ScreenGetSystemVisualMethodInfo
    ResolveScreenMethod "getToplevelWindows" o = ScreenGetToplevelWindowsMethodInfo
    ResolveScreenMethod "getWidth" o = ScreenGetWidthMethodInfo
    ResolveScreenMethod "getWidthMm" o = ScreenGetWidthMmMethodInfo
    ResolveScreenMethod "getWindowStack" o = ScreenGetWindowStackMethodInfo
    ResolveScreenMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveScreenMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveScreenMethod "setFontOptions" o = ScreenSetFontOptionsMethodInfo
    ResolveScreenMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveScreenMethod "setResolution" o = ScreenSetResolutionMethodInfo
    ResolveScreenMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveScreenMethod t Screen, O.OverloadedMethod info Screen p) => OL.IsLabel t (Screen -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveScreenMethod t Screen, O.OverloadedMethod info Screen p, R.HasField t Screen p) => R.HasField t Screen p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveScreenMethod t Screen, O.OverloadedMethodInfo info Screen) => OL.IsLabel t (O.MethodProxy info Screen) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Screen::composited-changed
-- | The [compositedChanged](#g:signal:compositedChanged) signal is emitted when the composited
-- status of the screen changes
-- 
-- /Since: 2.10/
type ScreenCompositedChangedCallback =
    IO ()

type C_ScreenCompositedChangedCallback =
    Ptr Screen ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScreenCompositedChangedCallback`.
foreign import ccall "wrapper"
    mk_ScreenCompositedChangedCallback :: C_ScreenCompositedChangedCallback -> IO (FunPtr C_ScreenCompositedChangedCallback)

wrap_ScreenCompositedChangedCallback :: 
    GObject a => (a -> ScreenCompositedChangedCallback) ->
    C_ScreenCompositedChangedCallback
wrap_ScreenCompositedChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [compositedChanged](#signal:compositedChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' screen #compositedChanged callback
-- @
-- 
-- 
onScreenCompositedChanged :: (IsScreen a, MonadIO m) => a -> ((?self :: a) => ScreenCompositedChangedCallback) -> m SignalHandlerId
onScreenCompositedChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScreenCompositedChangedCallback wrapped
    wrapped'' <- mk_ScreenCompositedChangedCallback wrapped'
    connectSignalFunPtr obj "composited-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [compositedChanged](#signal:compositedChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' screen #compositedChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScreenCompositedChanged :: (IsScreen a, MonadIO m) => a -> ((?self :: a) => ScreenCompositedChangedCallback) -> m SignalHandlerId
afterScreenCompositedChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScreenCompositedChangedCallback wrapped
    wrapped'' <- mk_ScreenCompositedChangedCallback wrapped'
    connectSignalFunPtr obj "composited-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScreenCompositedChangedSignalInfo
instance SignalInfo ScreenCompositedChangedSignalInfo where
    type HaskellCallbackType ScreenCompositedChangedSignalInfo = ScreenCompositedChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScreenCompositedChangedCallback cb
        cb'' <- mk_ScreenCompositedChangedCallback cb'
        connectSignalFunPtr obj "composited-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen::composited-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#g:signal:compositedChanged"})

#endif

-- signal Screen::monitors-changed
-- | The [monitorsChanged](#g:signal:monitorsChanged) signal is emitted when the number, size
-- or position of the monitors attached to the screen change.
-- 
-- Only for X11 and OS X for now. A future implementation for Win32
-- may be a possibility.
-- 
-- /Since: 2.14/
type ScreenMonitorsChangedCallback =
    IO ()

type C_ScreenMonitorsChangedCallback =
    Ptr Screen ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScreenMonitorsChangedCallback`.
foreign import ccall "wrapper"
    mk_ScreenMonitorsChangedCallback :: C_ScreenMonitorsChangedCallback -> IO (FunPtr C_ScreenMonitorsChangedCallback)

wrap_ScreenMonitorsChangedCallback :: 
    GObject a => (a -> ScreenMonitorsChangedCallback) ->
    C_ScreenMonitorsChangedCallback
wrap_ScreenMonitorsChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [monitorsChanged](#signal:monitorsChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' screen #monitorsChanged callback
-- @
-- 
-- 
onScreenMonitorsChanged :: (IsScreen a, MonadIO m) => a -> ((?self :: a) => ScreenMonitorsChangedCallback) -> m SignalHandlerId
onScreenMonitorsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScreenMonitorsChangedCallback wrapped
    wrapped'' <- mk_ScreenMonitorsChangedCallback wrapped'
    connectSignalFunPtr obj "monitors-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [monitorsChanged](#signal:monitorsChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' screen #monitorsChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScreenMonitorsChanged :: (IsScreen a, MonadIO m) => a -> ((?self :: a) => ScreenMonitorsChangedCallback) -> m SignalHandlerId
afterScreenMonitorsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScreenMonitorsChangedCallback wrapped
    wrapped'' <- mk_ScreenMonitorsChangedCallback wrapped'
    connectSignalFunPtr obj "monitors-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScreenMonitorsChangedSignalInfo
instance SignalInfo ScreenMonitorsChangedSignalInfo where
    type HaskellCallbackType ScreenMonitorsChangedSignalInfo = ScreenMonitorsChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScreenMonitorsChangedCallback cb
        cb'' <- mk_ScreenMonitorsChangedCallback cb'
        connectSignalFunPtr obj "monitors-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen::monitors-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#g:signal:monitorsChanged"})

#endif

-- signal Screen::size-changed
-- | The [sizeChanged](#g:signal:sizeChanged) signal is emitted when the pixel width or
-- height of a screen changes.
-- 
-- /Since: 2.2/
type ScreenSizeChangedCallback =
    IO ()

type C_ScreenSizeChangedCallback =
    Ptr Screen ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScreenSizeChangedCallback`.
foreign import ccall "wrapper"
    mk_ScreenSizeChangedCallback :: C_ScreenSizeChangedCallback -> IO (FunPtr C_ScreenSizeChangedCallback)

wrap_ScreenSizeChangedCallback :: 
    GObject a => (a -> ScreenSizeChangedCallback) ->
    C_ScreenSizeChangedCallback
wrap_ScreenSizeChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [sizeChanged](#signal:sizeChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' screen #sizeChanged callback
-- @
-- 
-- 
onScreenSizeChanged :: (IsScreen a, MonadIO m) => a -> ((?self :: a) => ScreenSizeChangedCallback) -> m SignalHandlerId
onScreenSizeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScreenSizeChangedCallback wrapped
    wrapped'' <- mk_ScreenSizeChangedCallback wrapped'
    connectSignalFunPtr obj "size-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [sizeChanged](#signal:sizeChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' screen #sizeChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScreenSizeChanged :: (IsScreen a, MonadIO m) => a -> ((?self :: a) => ScreenSizeChangedCallback) -> m SignalHandlerId
afterScreenSizeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScreenSizeChangedCallback wrapped
    wrapped'' <- mk_ScreenSizeChangedCallback wrapped'
    connectSignalFunPtr obj "size-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScreenSizeChangedSignalInfo
instance SignalInfo ScreenSizeChangedSignalInfo where
    type HaskellCallbackType ScreenSizeChangedSignalInfo = ScreenSizeChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScreenSizeChangedCallback cb
        cb'' <- mk_ScreenSizeChangedCallback cb'
        connectSignalFunPtr obj "size-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen::size-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#g:signal:sizeChanged"})

#endif

-- VVV Prop "font-options"
   -- Type: TBasicType TPtr
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@font-options@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' screen #fontOptions
-- @
getScreenFontOptions :: (MonadIO m, IsScreen o) => o -> m (Ptr ())
getScreenFontOptions obj = MIO.liftIO $ B.Properties.getObjectPropertyPtr obj "font-options"

-- | Set the value of the “@font-options@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' screen [ #fontOptions 'Data.GI.Base.Attributes.:=' value ]
-- @
setScreenFontOptions :: (MonadIO m, IsScreen o) => o -> Ptr () -> m ()
setScreenFontOptions obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyPtr obj "font-options" val

-- | Construct a t'GValueConstruct' with valid value for the “@font-options@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScreenFontOptions :: (IsScreen o, MIO.MonadIO m) => Ptr () -> m (GValueConstruct o)
constructScreenFontOptions val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyPtr "font-options" val

#if defined(ENABLE_OVERLOADING)
data ScreenFontOptionsPropertyInfo
instance AttrInfo ScreenFontOptionsPropertyInfo where
    type AttrAllowedOps ScreenFontOptionsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ScreenFontOptionsPropertyInfo = IsScreen
    type AttrSetTypeConstraint ScreenFontOptionsPropertyInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ScreenFontOptionsPropertyInfo = (~) (Ptr ())
    type AttrTransferType ScreenFontOptionsPropertyInfo = Ptr ()
    type AttrGetType ScreenFontOptionsPropertyInfo = (Ptr ())
    type AttrLabel ScreenFontOptionsPropertyInfo = "font-options"
    type AttrOrigin ScreenFontOptionsPropertyInfo = Screen
    attrGet = getScreenFontOptions
    attrSet = setScreenFontOptions
    attrPut = setScreenFontOptions
    attrTransfer _ v = do
        return v
    attrConstruct = constructScreenFontOptions
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.fontOptions"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#g:attr:fontOptions"
        })
#endif

-- VVV Prop "resolution"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@resolution@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' screen #resolution
-- @
getScreenResolution :: (MonadIO m, IsScreen o) => o -> m Double
getScreenResolution obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "resolution"

-- | Set the value of the “@resolution@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' screen [ #resolution 'Data.GI.Base.Attributes.:=' value ]
-- @
setScreenResolution :: (MonadIO m, IsScreen o) => o -> Double -> m ()
setScreenResolution obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "resolution" val

-- | Construct a t'GValueConstruct' with valid value for the “@resolution@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScreenResolution :: (IsScreen o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructScreenResolution val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "resolution" val

#if defined(ENABLE_OVERLOADING)
data ScreenResolutionPropertyInfo
instance AttrInfo ScreenResolutionPropertyInfo where
    type AttrAllowedOps ScreenResolutionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ScreenResolutionPropertyInfo = IsScreen
    type AttrSetTypeConstraint ScreenResolutionPropertyInfo = (~) Double
    type AttrTransferTypeConstraint ScreenResolutionPropertyInfo = (~) Double
    type AttrTransferType ScreenResolutionPropertyInfo = Double
    type AttrGetType ScreenResolutionPropertyInfo = Double
    type AttrLabel ScreenResolutionPropertyInfo = "resolution"
    type AttrOrigin ScreenResolutionPropertyInfo = Screen
    attrGet = getScreenResolution
    attrSet = setScreenResolution
    attrPut = setScreenResolution
    attrTransfer _ v = do
        return v
    attrConstruct = constructScreenResolution
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.resolution"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#g:attr:resolution"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Screen
type instance O.AttributeList Screen = ScreenAttributeList
type ScreenAttributeList = ('[ '("fontOptions", ScreenFontOptionsPropertyInfo), '("resolution", ScreenResolutionPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
screenFontOptions :: AttrLabelProxy "fontOptions"
screenFontOptions = AttrLabelProxy

screenResolution :: AttrLabelProxy "resolution"
screenResolution = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Screen = ScreenSignalList
type ScreenSignalList = ('[ '("compositedChanged", ScreenCompositedChangedSignalInfo), '("monitorsChanged", ScreenMonitorsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sizeChanged", ScreenSizeChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Screen::get_active_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_active_window" gdk_screen_get_active_window :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr Gdk.Window.Window)

{-# DEPRECATED screenGetActiveWindow ["(Since version 3.22)"] #-}
-- | Returns the screen’s currently active window.
-- 
-- On X11, this is done by inspecting the _NET_ACTIVE_WINDOW property
-- on the root window, as described in the
-- <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints>.
-- If there is no currently currently active
-- window, or the window manager does not support the
-- _NET_ACTIVE_WINDOW hint, this function returns 'P.Nothing'.
-- 
-- On other platforms, this function may return 'P.Nothing', depending on whether
-- it is implementable on that platform.
-- 
-- The returned window should be unrefed using 'GI.GObject.Objects.Object.objectUnref' when
-- no longer needed.
-- 
-- /Since: 2.10/
screenGetActiveWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m (Maybe Gdk.Window.Window)
    -- ^ __Returns:__ the currently active window,
    --   or 'P.Nothing'.
screenGetActiveWindow screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_active_window screen'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gdk.Window.Window) result'
        return result''
    touchManagedPtr screen
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ScreenGetActiveWindowMethodInfo
instance (signature ~ (m (Maybe Gdk.Window.Window)), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetActiveWindowMethodInfo a signature where
    overloadedMethod = screenGetActiveWindow

instance O.OverloadedMethodInfo ScreenGetActiveWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetActiveWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetActiveWindow"
        })


#endif

-- method Screen::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_display" gdk_screen_get_display :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr Gdk.Display.Display)

-- | Gets the display to which the /@screen@/ belongs.
-- 
-- /Since: 2.2/
screenGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Gdk.Display.Display
    -- ^ __Returns:__ the display to which /@screen@/ belongs
screenGetDisplay screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_display screen'
    checkUnexpectedReturnNULL "screenGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data ScreenGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetDisplayMethodInfo a signature where
    overloadedMethod = screenGetDisplay

instance O.OverloadedMethodInfo ScreenGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetDisplay"
        })


#endif

-- method Screen::get_font_options
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "cairo" , name = "FontOptions" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_font_options" gdk_screen_get_font_options :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr Cairo.FontOptions.FontOptions)

-- | Gets any options previously set with 'GI.Gdk.Objects.Screen.screenSetFontOptions'.
-- 
-- /Since: 2.10/
screenGetFontOptions ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m (Maybe Cairo.FontOptions.FontOptions)
    -- ^ __Returns:__ the current font options, or 'P.Nothing' if no
    --  default font options have been set.
screenGetFontOptions screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_font_options screen'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Cairo.FontOptions.FontOptions) result'
        return result''
    touchManagedPtr screen
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ScreenGetFontOptionsMethodInfo
instance (signature ~ (m (Maybe Cairo.FontOptions.FontOptions)), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetFontOptionsMethodInfo a signature where
    overloadedMethod = screenGetFontOptions

instance O.OverloadedMethodInfo ScreenGetFontOptionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetFontOptions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetFontOptions"
        })


#endif

-- method Screen::get_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_height" gdk_screen_get_height :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO Int32

{-# DEPRECATED screenGetHeight ["(Since version 3.22)","Use per-monitor information instead"] #-}
-- | Gets the height of /@screen@/ in pixels. The returned size is in
-- ”application pixels”, not in ”device pixels” (see
-- 'GI.Gdk.Objects.Screen.screenGetMonitorScaleFactor').
-- 
-- /Since: 2.2/
screenGetHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Int32
    -- ^ __Returns:__ the height of /@screen@/ in pixels.
screenGetHeight screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_height screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetHeightMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetHeightMethodInfo a signature where
    overloadedMethod = screenGetHeight

instance O.OverloadedMethodInfo ScreenGetHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetHeight"
        })


#endif

-- method Screen::get_height_mm
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_height_mm" gdk_screen_get_height_mm :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO Int32

{-# DEPRECATED screenGetHeightMm ["(Since version 3.22)","Use per-monitor information instead"] #-}
-- | Returns the height of /@screen@/ in millimeters.
-- 
-- Note that this value is somewhat ill-defined when the screen
-- has multiple monitors of different resolution. It is recommended
-- to use the monitor dimensions instead.
-- 
-- /Since: 2.2/
screenGetHeightMm ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Int32
    -- ^ __Returns:__ the heigth of /@screen@/ in millimeters.
screenGetHeightMm screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_height_mm screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetHeightMmMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetHeightMmMethodInfo a signature where
    overloadedMethod = screenGetHeightMm

instance O.OverloadedMethodInfo ScreenGetHeightMmMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetHeightMm",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetHeightMm"
        })


#endif

-- method Screen::get_monitor_at_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the x coordinate in the virtual screen."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the y coordinate in the virtual screen."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_monitor_at_point" gdk_screen_get_monitor_at_point :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO Int32

{-# DEPRECATED screenGetMonitorAtPoint ["(Since version 3.22)","Use 'GI.Gdk.Objects.Display.displayGetMonitorAtPoint' instead"] #-}
-- | Returns the monitor number in which the point (/@x@/,/@y@/) is located.
-- 
-- /Since: 2.2/
screenGetMonitorAtPoint ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'.
    -> Int32
    -- ^ /@x@/: the x coordinate in the virtual screen.
    -> Int32
    -- ^ /@y@/: the y coordinate in the virtual screen.
    -> m Int32
    -- ^ __Returns:__ the monitor number in which the point (/@x@/,/@y@/) lies, or
    --   a monitor close to (/@x@/,/@y@/) if the point is not in any monitor.
screenGetMonitorAtPoint screen x y = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_monitor_at_point screen' x y
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetMonitorAtPointMethodInfo
instance (signature ~ (Int32 -> Int32 -> m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetMonitorAtPointMethodInfo a signature where
    overloadedMethod = screenGetMonitorAtPoint

instance O.OverloadedMethodInfo ScreenGetMonitorAtPointMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetMonitorAtPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetMonitorAtPoint"
        })


#endif

-- method Screen::get_monitor_at_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_monitor_at_window" gdk_screen_get_monitor_at_window :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO Int32

{-# DEPRECATED screenGetMonitorAtWindow ["(Since version 3.22)","Use 'GI.Gdk.Objects.Display.displayGetMonitorAtWindow' instead"] #-}
-- | Returns the number of the monitor in which the largest area of the
-- bounding rectangle of /@window@/ resides.
-- 
-- /Since: 2.2/
screenGetMonitorAtWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'.
    -> b
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Int32
    -- ^ __Returns:__ the monitor number in which most of /@window@/ is located,
    --     or if /@window@/ does not intersect any monitors, a monitor,
    --     close to /@window@/.
screenGetMonitorAtWindow screen window = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_screen_get_monitor_at_window screen' window'
    touchManagedPtr screen
    touchManagedPtr window
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetMonitorAtWindowMethodInfo
instance (signature ~ (b -> m Int32), MonadIO m, IsScreen a, Gdk.Window.IsWindow b) => O.OverloadedMethod ScreenGetMonitorAtWindowMethodInfo a signature where
    overloadedMethod = screenGetMonitorAtWindow

instance O.OverloadedMethodInfo ScreenGetMonitorAtWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetMonitorAtWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetMonitorAtWindow"
        })


#endif

-- method Screen::get_monitor_geometry
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the monitor number" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GdkRectangle to be filled with\n    the monitor geometry"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_monitor_geometry" gdk_screen_get_monitor_geometry :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- monitor_num : TBasicType TInt
    Ptr Gdk.Rectangle.Rectangle ->          -- dest : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

{-# DEPRECATED screenGetMonitorGeometry ["(Since version 3.22)","Use 'GI.Gdk.Objects.Monitor.monitorGetGeometry' instead"] #-}
-- | Retrieves the t'GI.Gdk.Structs.Rectangle.Rectangle' representing the size and position of
-- the individual monitor within the entire screen area. The returned
-- geometry is in ”application pixels”, not in ”device pixels” (see
-- 'GI.Gdk.Objects.Screen.screenGetMonitorScaleFactor').
-- 
-- Monitor numbers start at 0. To obtain the number of monitors of
-- /@screen@/, use 'GI.Gdk.Objects.Screen.screenGetNMonitors'.
-- 
-- Note that the size of the entire screen area can be retrieved via
-- 'GI.Gdk.Objects.Screen.screenGetWidth' and 'GI.Gdk.Objects.Screen.screenGetHeight'.
-- 
-- /Since: 2.2/
screenGetMonitorGeometry ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> Int32
    -- ^ /@monitorNum@/: the monitor number
    -> m (Gdk.Rectangle.Rectangle)
screenGetMonitorGeometry screen monitorNum = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    dest <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gdk_screen_get_monitor_geometry screen' monitorNum dest
    dest' <- (wrapBoxed Gdk.Rectangle.Rectangle) dest
    touchManagedPtr screen
    return dest'

#if defined(ENABLE_OVERLOADING)
data ScreenGetMonitorGeometryMethodInfo
instance (signature ~ (Int32 -> m (Gdk.Rectangle.Rectangle)), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetMonitorGeometryMethodInfo a signature where
    overloadedMethod = screenGetMonitorGeometry

instance O.OverloadedMethodInfo ScreenGetMonitorGeometryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetMonitorGeometry",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetMonitorGeometry"
        })


#endif

-- method Screen::get_monitor_height_mm
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_monitor_height_mm" gdk_screen_get_monitor_height_mm :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- monitor_num : TBasicType TInt
    IO Int32

{-# DEPRECATED screenGetMonitorHeightMm ["(Since version 3.22)","Use 'GI.Gdk.Objects.Monitor.monitorGetHeightMm' instead"] #-}
-- | Gets the height in millimeters of the specified monitor.
-- 
-- /Since: 2.14/
screenGetMonitorHeightMm ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> Int32
    -- ^ /@monitorNum@/: number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)
    -> m Int32
    -- ^ __Returns:__ the height of the monitor, or -1 if not available
screenGetMonitorHeightMm screen monitorNum = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_monitor_height_mm screen' monitorNum
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetMonitorHeightMmMethodInfo
instance (signature ~ (Int32 -> m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetMonitorHeightMmMethodInfo a signature where
    overloadedMethod = screenGetMonitorHeightMm

instance O.OverloadedMethodInfo ScreenGetMonitorHeightMmMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetMonitorHeightMm",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetMonitorHeightMm"
        })


#endif

-- method Screen::get_monitor_plug_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_monitor_plug_name" gdk_screen_get_monitor_plug_name :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- monitor_num : TBasicType TInt
    IO CString

{-# DEPRECATED screenGetMonitorPlugName ["(Since version 3.22)","Use 'GI.Gdk.Objects.Monitor.monitorGetModel' instead"] #-}
-- | Returns the output name of the specified monitor.
-- Usually something like VGA, DVI, or TV, not the actual
-- product name of the display device.
-- 
-- /Since: 2.14/
screenGetMonitorPlugName ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> Int32
    -- ^ /@monitorNum@/: number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a newly-allocated string containing the name
    --   of the monitor, or 'P.Nothing' if the name cannot be determined
screenGetMonitorPlugName screen monitorNum = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_monitor_plug_name screen' monitorNum
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr screen
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ScreenGetMonitorPlugNameMethodInfo
instance (signature ~ (Int32 -> m (Maybe T.Text)), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetMonitorPlugNameMethodInfo a signature where
    overloadedMethod = screenGetMonitorPlugName

instance O.OverloadedMethodInfo ScreenGetMonitorPlugNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetMonitorPlugName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetMonitorPlugName"
        })


#endif

-- method Screen::get_monitor_scale_factor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "screen to get scale factor for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_monitor_scale_factor" gdk_screen_get_monitor_scale_factor :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- monitor_num : TBasicType TInt
    IO Int32

{-# DEPRECATED screenGetMonitorScaleFactor ["(Since version 3.22)","Use 'GI.Gdk.Objects.Monitor.monitorGetScaleFactor' instead"] #-}
-- | Returns the internal scale factor that maps from monitor coordinates
-- to the actual device pixels. On traditional systems this is 1, but
-- on very high density outputs this can be a higher value (often 2).
-- 
-- This can be used if you want to create pixel based data for a
-- particular monitor, but most of the time you’re drawing to a window
-- where it is better to use 'GI.Gdk.Objects.Window.windowGetScaleFactor' instead.
-- 
-- /Since: 3.10/
screenGetMonitorScaleFactor ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: screen to get scale factor for
    -> Int32
    -- ^ /@monitorNum@/: number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)
    -> m Int32
    -- ^ __Returns:__ the scale factor
screenGetMonitorScaleFactor screen monitorNum = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_monitor_scale_factor screen' monitorNum
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetMonitorScaleFactorMethodInfo
instance (signature ~ (Int32 -> m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetMonitorScaleFactorMethodInfo a signature where
    overloadedMethod = screenGetMonitorScaleFactor

instance O.OverloadedMethodInfo ScreenGetMonitorScaleFactorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetMonitorScaleFactor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetMonitorScaleFactor"
        })


#endif

-- method Screen::get_monitor_width_mm
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_monitor_width_mm" gdk_screen_get_monitor_width_mm :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- monitor_num : TBasicType TInt
    IO Int32

{-# DEPRECATED screenGetMonitorWidthMm ["(Since version 3.22)","Use 'GI.Gdk.Objects.Monitor.monitorGetWidthMm' instead"] #-}
-- | Gets the width in millimeters of the specified monitor, if available.
-- 
-- /Since: 2.14/
screenGetMonitorWidthMm ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> Int32
    -- ^ /@monitorNum@/: number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)
    -> m Int32
    -- ^ __Returns:__ the width of the monitor, or -1 if not available
screenGetMonitorWidthMm screen monitorNum = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_monitor_width_mm screen' monitorNum
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetMonitorWidthMmMethodInfo
instance (signature ~ (Int32 -> m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetMonitorWidthMmMethodInfo a signature where
    overloadedMethod = screenGetMonitorWidthMm

instance O.OverloadedMethodInfo ScreenGetMonitorWidthMmMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetMonitorWidthMm",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetMonitorWidthMm"
        })


#endif

-- method Screen::get_monitor_workarea
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the monitor number" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GdkRectangle to be filled with\n    the monitor workarea"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_monitor_workarea" gdk_screen_get_monitor_workarea :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- monitor_num : TBasicType TInt
    Ptr Gdk.Rectangle.Rectangle ->          -- dest : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

{-# DEPRECATED screenGetMonitorWorkarea ["(Since version 3.22)","Use 'GI.Gdk.Objects.Monitor.monitorGetWorkarea' instead"] #-}
-- | Retrieves the t'GI.Gdk.Structs.Rectangle.Rectangle' representing the size and position of
-- the “work area” on a monitor within the entire screen area. The returned
-- geometry is in ”application pixels”, not in ”device pixels” (see
-- 'GI.Gdk.Objects.Screen.screenGetMonitorScaleFactor').
-- 
-- The work area should be considered when positioning menus and
-- similar popups, to avoid placing them below panels, docks or other
-- desktop components.
-- 
-- Note that not all backends may have a concept of workarea. This
-- function will return the monitor geometry if a workarea is not
-- available, or does not apply.
-- 
-- Monitor numbers start at 0. To obtain the number of monitors of
-- /@screen@/, use 'GI.Gdk.Objects.Screen.screenGetNMonitors'.
-- 
-- /Since: 3.4/
screenGetMonitorWorkarea ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> Int32
    -- ^ /@monitorNum@/: the monitor number
    -> m (Gdk.Rectangle.Rectangle)
screenGetMonitorWorkarea screen monitorNum = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    dest <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gdk_screen_get_monitor_workarea screen' monitorNum dest
    dest' <- (wrapBoxed Gdk.Rectangle.Rectangle) dest
    touchManagedPtr screen
    return dest'

#if defined(ENABLE_OVERLOADING)
data ScreenGetMonitorWorkareaMethodInfo
instance (signature ~ (Int32 -> m (Gdk.Rectangle.Rectangle)), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetMonitorWorkareaMethodInfo a signature where
    overloadedMethod = screenGetMonitorWorkarea

instance O.OverloadedMethodInfo ScreenGetMonitorWorkareaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetMonitorWorkarea",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetMonitorWorkarea"
        })


#endif

-- method Screen::get_n_monitors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_n_monitors" gdk_screen_get_n_monitors :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO Int32

{-# DEPRECATED screenGetNMonitors ["(Since version 3.22)","Use 'GI.Gdk.Objects.Display.displayGetNMonitors' instead"] #-}
-- | Returns the number of monitors which /@screen@/ consists of.
-- 
-- /Since: 2.2/
screenGetNMonitors ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Int32
    -- ^ __Returns:__ number of monitors which /@screen@/ consists of
screenGetNMonitors screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_n_monitors screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetNMonitorsMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetNMonitorsMethodInfo a signature where
    overloadedMethod = screenGetNMonitors

instance O.OverloadedMethodInfo ScreenGetNMonitorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetNMonitors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetNMonitors"
        })


#endif

-- method Screen::get_number
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_number" gdk_screen_get_number :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO Int32

{-# DEPRECATED screenGetNumber ["(Since version 3.22)"] #-}
-- | Gets the index of /@screen@/ among the screens in the display
-- to which it belongs. (See 'GI.Gdk.Objects.Screen.screenGetDisplay')
-- 
-- /Since: 2.2/
screenGetNumber ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Int32
    -- ^ __Returns:__ the index
screenGetNumber screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_number screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetNumberMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetNumberMethodInfo a signature where
    overloadedMethod = screenGetNumber

instance O.OverloadedMethodInfo ScreenGetNumberMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetNumber",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetNumber"
        })


#endif

-- method Screen::get_primary_monitor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_primary_monitor" gdk_screen_get_primary_monitor :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO Int32

{-# DEPRECATED screenGetPrimaryMonitor ["(Since version 3.22)","Use 'GI.Gdk.Objects.Display.displayGetPrimaryMonitor' instead"] #-}
-- | Gets the primary monitor for /@screen@/.  The primary monitor
-- is considered the monitor where the “main desktop” lives.
-- While normal application windows typically allow the window
-- manager to place the windows, specialized desktop applications
-- such as panels should place themselves on the primary monitor.
-- 
-- If no primary monitor is configured by the user, the return value
-- will be 0, defaulting to the first monitor.
-- 
-- /Since: 2.20/
screenGetPrimaryMonitor ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'.
    -> m Int32
    -- ^ __Returns:__ An integer index for the primary monitor, or 0 if none is configured.
screenGetPrimaryMonitor screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_primary_monitor screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetPrimaryMonitorMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetPrimaryMonitorMethodInfo a signature where
    overloadedMethod = screenGetPrimaryMonitor

instance O.OverloadedMethodInfo ScreenGetPrimaryMonitorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetPrimaryMonitor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetPrimaryMonitor"
        })


#endif

-- method Screen::get_resolution
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_resolution" gdk_screen_get_resolution :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO CDouble

-- | Gets the resolution for font handling on the screen; see
-- 'GI.Gdk.Objects.Screen.screenSetResolution' for full details.
-- 
-- /Since: 2.10/
screenGetResolution ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Double
    -- ^ __Returns:__ the current resolution, or -1 if no resolution
    -- has been set.
screenGetResolution screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_resolution screen'
    let result' = realToFrac result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data ScreenGetResolutionMethodInfo
instance (signature ~ (m Double), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetResolutionMethodInfo a signature where
    overloadedMethod = screenGetResolution

instance O.OverloadedMethodInfo ScreenGetResolutionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetResolution",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetResolution"
        })


#endif

-- method Screen::get_rgba_visual
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Visual" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_rgba_visual" gdk_screen_get_rgba_visual :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr Gdk.Visual.Visual)

-- | Gets a visual to use for creating windows with an alpha channel.
-- The windowing system on which GTK+ is running
-- may not support this capability, in which case 'P.Nothing' will
-- be returned. Even if a non-'P.Nothing' value is returned, its
-- possible that the window’s alpha channel won’t be honored
-- when displaying the window on the screen: in particular, for
-- X an appropriate windowing manager and compositing manager
-- must be running to provide appropriate display.
-- 
-- This functionality is not implemented in the Windows backend.
-- 
-- For setting an overall opacity for a top-level window, see
-- 'GI.Gdk.Objects.Window.windowSetOpacity'.
-- 
-- /Since: 2.8/
screenGetRgbaVisual ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m (Maybe Gdk.Visual.Visual)
    -- ^ __Returns:__ a visual to use for windows
    --     with an alpha channel or 'P.Nothing' if the capability is not
    --     available.
screenGetRgbaVisual screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_rgba_visual screen'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Visual.Visual) result'
        return result''
    touchManagedPtr screen
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ScreenGetRgbaVisualMethodInfo
instance (signature ~ (m (Maybe Gdk.Visual.Visual)), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetRgbaVisualMethodInfo a signature where
    overloadedMethod = screenGetRgbaVisual

instance O.OverloadedMethodInfo ScreenGetRgbaVisualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetRgbaVisual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetRgbaVisual"
        })


#endif

-- method Screen::get_root_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_root_window" gdk_screen_get_root_window :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr Gdk.Window.Window)

-- | Gets the root window of /@screen@/.
-- 
-- /Since: 2.2/
screenGetRootWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Gdk.Window.Window
    -- ^ __Returns:__ the root window
screenGetRootWindow screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_root_window screen'
    checkUnexpectedReturnNULL "screenGetRootWindow" result
    result' <- (newObject Gdk.Window.Window) result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data ScreenGetRootWindowMethodInfo
instance (signature ~ (m Gdk.Window.Window), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetRootWindowMethodInfo a signature where
    overloadedMethod = screenGetRootWindow

instance O.OverloadedMethodInfo ScreenGetRootWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetRootWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetRootWindow"
        })


#endif

-- method Screen::get_setting
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkScreen where the setting is located"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the setting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the value of the setting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_setting" gdk_screen_get_setting :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr GValue ->                           -- value : TGValue
    IO CInt

-- | Retrieves a desktop-wide setting such as double-click time
-- for the t'GI.Gdk.Objects.Screen.Screen' /@screen@/.
-- 
-- FIXME needs a list of valid settings here, or a link to
-- more information.
-- 
-- /Since: 2.2/
screenGetSetting ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: the t'GI.Gdk.Objects.Screen.Screen' where the setting is located
    -> T.Text
    -- ^ /@name@/: the name of the setting
    -> GValue
    -- ^ /@value@/: location to store the value of the setting
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the setting existed and a value was stored
    --   in /@value@/, 'P.False' otherwise.
screenGetSetting screen name value = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    name' <- textToCString name
    value' <- unsafeManagedPtrGetPtr value
    result <- gdk_screen_get_setting screen' name' value'
    let result' = (/= 0) result
    touchManagedPtr screen
    touchManagedPtr value
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
data ScreenGetSettingMethodInfo
instance (signature ~ (T.Text -> GValue -> m Bool), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetSettingMethodInfo a signature where
    overloadedMethod = screenGetSetting

instance O.OverloadedMethodInfo ScreenGetSettingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetSetting",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetSetting"
        })


#endif

-- method Screen::get_system_visual
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Visual" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_system_visual" gdk_screen_get_system_visual :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr Gdk.Visual.Visual)

-- | Get the system’s default visual for /@screen@/.
-- This is the visual for the root window of the display.
-- The return value should not be freed.
-- 
-- /Since: 2.2/
screenGetSystemVisual ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'.
    -> m Gdk.Visual.Visual
    -- ^ __Returns:__ the system visual
screenGetSystemVisual screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_system_visual screen'
    checkUnexpectedReturnNULL "screenGetSystemVisual" result
    result' <- (newObject Gdk.Visual.Visual) result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data ScreenGetSystemVisualMethodInfo
instance (signature ~ (m Gdk.Visual.Visual), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetSystemVisualMethodInfo a signature where
    overloadedMethod = screenGetSystemVisual

instance O.OverloadedMethodInfo ScreenGetSystemVisualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetSystemVisual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetSystemVisual"
        })


#endif

-- method Screen::get_toplevel_windows
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #GdkScreen where the toplevels are located."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Window" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_toplevel_windows" gdk_screen_get_toplevel_windows :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr (GList (Ptr Gdk.Window.Window)))

-- | Obtains a list of all toplevel windows known to GDK on the screen /@screen@/.
-- A toplevel window is a child of the root window (see
-- 'GI.Gdk.Functions.getDefaultRootWindow').
-- 
-- The returned list should be freed with @/g_list_free()/@, but
-- its elements need not be freed.
-- 
-- /Since: 2.2/
screenGetToplevelWindows ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: The t'GI.Gdk.Objects.Screen.Screen' where the toplevels are located.
    -> m [Gdk.Window.Window]
    -- ^ __Returns:__ 
    --     list of toplevel windows, free with @/g_list_free()/@
screenGetToplevelWindows screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_toplevel_windows screen'
    result' <- unpackGList result
    result'' <- mapM (newObject Gdk.Window.Window) result'
    g_list_free result
    touchManagedPtr screen
    return result''

#if defined(ENABLE_OVERLOADING)
data ScreenGetToplevelWindowsMethodInfo
instance (signature ~ (m [Gdk.Window.Window]), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetToplevelWindowsMethodInfo a signature where
    overloadedMethod = screenGetToplevelWindows

instance O.OverloadedMethodInfo ScreenGetToplevelWindowsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetToplevelWindows",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetToplevelWindows"
        })


#endif

-- method Screen::get_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_width" gdk_screen_get_width :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO Int32

{-# DEPRECATED screenGetWidth ["(Since version 3.22)","Use per-monitor information instead"] #-}
-- | Gets the width of /@screen@/ in pixels. The returned size is in
-- ”application pixels”, not in ”device pixels” (see
-- 'GI.Gdk.Objects.Screen.screenGetMonitorScaleFactor').
-- 
-- /Since: 2.2/
screenGetWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Int32
    -- ^ __Returns:__ the width of /@screen@/ in pixels.
screenGetWidth screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_width screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetWidthMethodInfo a signature where
    overloadedMethod = screenGetWidth

instance O.OverloadedMethodInfo ScreenGetWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetWidth"
        })


#endif

-- method Screen::get_width_mm
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_width_mm" gdk_screen_get_width_mm :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO Int32

{-# DEPRECATED screenGetWidthMm ["(Since version 3.22)","Use per-monitor information instead"] #-}
-- | Gets the width of /@screen@/ in millimeters.
-- 
-- Note that this value is somewhat ill-defined when the screen
-- has multiple monitors of different resolution. It is recommended
-- to use the monitor dimensions instead.
-- 
-- /Since: 2.2/
screenGetWidthMm ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Int32
    -- ^ __Returns:__ the width of /@screen@/ in millimeters.
screenGetWidthMm screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_width_mm screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data ScreenGetWidthMmMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetWidthMmMethodInfo a signature where
    overloadedMethod = screenGetWidthMm

instance O.OverloadedMethodInfo ScreenGetWidthMmMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetWidthMm",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetWidthMm"
        })


#endif

-- method Screen::get_window_stack
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Window" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_window_stack" gdk_screen_get_window_stack :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr (GList (Ptr Gdk.Window.Window)))

-- | Returns a t'GI.GLib.Structs.List.List' of @/GdkWindows/@ representing the current
-- window stack.
-- 
-- On X11, this is done by inspecting the _NET_CLIENT_LIST_STACKING
-- property on the root window, as described in the
-- <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints>.
-- If the window manager does not support the
-- _NET_CLIENT_LIST_STACKING hint, this function returns 'P.Nothing'.
-- 
-- On other platforms, this function may return 'P.Nothing', depending on whether
-- it is implementable on that platform.
-- 
-- The returned list is newly allocated and owns references to the
-- windows it contains, so it should be freed using @/g_list_free()/@ and
-- its windows unrefed using 'GI.GObject.Objects.Object.objectUnref' when no longer needed.
-- 
-- /Since: 2.10/
screenGetWindowStack ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m [Gdk.Window.Window]
    -- ^ __Returns:__ a
    --     list of @/GdkWindows/@ for the current window stack, or 'P.Nothing'.
screenGetWindowStack screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_get_window_stack screen'
    result' <- unpackGList result
    result'' <- mapM (wrapObject Gdk.Window.Window) result'
    g_list_free result
    touchManagedPtr screen
    return result''

#if defined(ENABLE_OVERLOADING)
data ScreenGetWindowStackMethodInfo
instance (signature ~ (m [Gdk.Window.Window]), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenGetWindowStackMethodInfo a signature where
    overloadedMethod = screenGetWindowStack

instance O.OverloadedMethodInfo ScreenGetWindowStackMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenGetWindowStack",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenGetWindowStack"
        })


#endif

-- method Screen::is_composited
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_is_composited" gdk_screen_is_composited :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO CInt

-- | Returns whether windows with an RGBA visual can reasonably
-- be expected to have their alpha channel drawn correctly on
-- the screen.
-- 
-- On X11 this function returns whether a compositing manager is
-- compositing /@screen@/.
-- 
-- /Since: 2.10/
screenIsComposited ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Bool
    -- ^ __Returns:__ Whether windows with RGBA visuals can reasonably be
    -- expected to have their alpha channels drawn correctly on the screen.
screenIsComposited screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_is_composited screen'
    let result' = (/= 0) result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data ScreenIsCompositedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenIsCompositedMethodInfo a signature where
    overloadedMethod = screenIsComposited

instance O.OverloadedMethodInfo ScreenIsCompositedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenIsComposited",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenIsComposited"
        })


#endif

-- method Screen::list_visuals
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the relevant #GdkScreen."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Visual" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_list_visuals" gdk_screen_list_visuals :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr (GList (Ptr Gdk.Visual.Visual)))

-- | Lists the available visuals for the specified /@screen@/.
-- A visual describes a hardware image data format.
-- For example, a visual might support 24-bit color, or 8-bit color,
-- and might expect pixels to be in a certain format.
-- 
-- Call @/g_list_free()/@ on the return value when you’re finished with it.
-- 
-- /Since: 2.2/
screenListVisuals ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: the relevant t'GI.Gdk.Objects.Screen.Screen'.
    -> m [Gdk.Visual.Visual]
    -- ^ __Returns:__ 
    --     a list of visuals; the list must be freed, but not its contents
screenListVisuals screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_list_visuals screen'
    result' <- unpackGList result
    result'' <- mapM (newObject Gdk.Visual.Visual) result'
    g_list_free result
    touchManagedPtr screen
    return result''

#if defined(ENABLE_OVERLOADING)
data ScreenListVisualsMethodInfo
instance (signature ~ (m [Gdk.Visual.Visual]), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenListVisualsMethodInfo a signature where
    overloadedMethod = screenListVisuals

instance O.OverloadedMethodInfo ScreenListVisualsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenListVisuals",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenListVisuals"
        })


#endif

-- method Screen::make_display_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_make_display_name" gdk_screen_make_display_name :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO CString

{-# DEPRECATED screenMakeDisplayName ["(Since version 3.22)"] #-}
-- | Determines the name to pass to 'GI.Gdk.Objects.Display.displayOpen' to get
-- a t'GI.Gdk.Objects.Display.Display' with this screen as the default screen.
-- 
-- /Since: 2.2/
screenMakeDisplayName ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m T.Text
    -- ^ __Returns:__ a newly allocated string, free with 'GI.GLib.Functions.free'
screenMakeDisplayName screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_screen_make_display_name screen'
    checkUnexpectedReturnNULL "screenMakeDisplayName" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data ScreenMakeDisplayNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenMakeDisplayNameMethodInfo a signature where
    overloadedMethod = screenMakeDisplayName

instance O.OverloadedMethodInfo ScreenMakeDisplayNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenMakeDisplayName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenMakeDisplayName"
        })


#endif

-- method Screen::set_font_options
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "options"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "FontOptions" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #cairo_font_options_t, or %NULL to unset any\n  previously set default font options."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_set_font_options" gdk_screen_set_font_options :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Ptr Cairo.FontOptions.FontOptions ->    -- options : TInterface (Name {namespace = "cairo", name = "FontOptions"})
    IO ()

-- | Sets the default font options for the screen. These
-- options will be set on any t'GI.Pango.Objects.Context.Context'’s newly created
-- with 'GI.Gdk.Functions.pangoContextGetForScreen'. Changing the
-- default set of font options does not affect contexts that
-- have already been created.
-- 
-- /Since: 2.10/
screenSetFontOptions ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> Maybe (Cairo.FontOptions.FontOptions)
    -- ^ /@options@/: a t'GI.Cairo.Structs.FontOptions.FontOptions', or 'P.Nothing' to unset any
    --   previously set default font options.
    -> m ()
screenSetFontOptions screen options = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    maybeOptions <- case options of
        Nothing -> return FP.nullPtr
        Just jOptions -> do
            jOptions' <- unsafeManagedPtrGetPtr jOptions
            return jOptions'
    gdk_screen_set_font_options screen' maybeOptions
    touchManagedPtr screen
    whenJust options touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ScreenSetFontOptionsMethodInfo
instance (signature ~ (Maybe (Cairo.FontOptions.FontOptions) -> m ()), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenSetFontOptionsMethodInfo a signature where
    overloadedMethod = screenSetFontOptions

instance O.OverloadedMethodInfo ScreenSetFontOptionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenSetFontOptions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenSetFontOptions"
        })


#endif

-- method Screen::set_resolution
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dpi"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the resolution in \8220dots per inch\8221. (Physical inches aren\8217t actually\n  involved; the terminology is conventional.)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_set_resolution" gdk_screen_set_resolution :: 
    Ptr Screen ->                           -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    CDouble ->                              -- dpi : TBasicType TDouble
    IO ()

-- | Sets the resolution for font handling on the screen. This is a
-- scale factor between points specified in a t'GI.Pango.Structs.FontDescription.FontDescription'
-- and cairo units. The default value is 96, meaning that a 10 point
-- font will be 13 units high. (10 * 96. \/ 72. = 13.3).
-- 
-- /Since: 2.10/
screenSetResolution ::
    (B.CallStack.HasCallStack, MonadIO m, IsScreen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> Double
    -- ^ /@dpi@/: the resolution in “dots per inch”. (Physical inches aren’t actually
    --   involved; the terminology is conventional.)
    -> m ()
screenSetResolution screen dpi = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    let dpi' = realToFrac dpi
    gdk_screen_set_resolution screen' dpi'
    touchManagedPtr screen
    return ()

#if defined(ENABLE_OVERLOADING)
data ScreenSetResolutionMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsScreen a) => O.OverloadedMethod ScreenSetResolutionMethodInfo a signature where
    overloadedMethod = screenSetResolution

instance O.OverloadedMethodInfo ScreenSetResolutionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Screen.screenSetResolution",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Screen.html#v:screenSetResolution"
        })


#endif

-- method Screen::get_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Screen" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_get_default" gdk_screen_get_default :: 
    IO (Ptr Screen)

-- | Gets the default screen for the default display. (See
-- gdk_display_get_default ()).
-- 
-- /Since: 2.2/
screenGetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe Screen)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Screen.Screen', or 'P.Nothing' if
    --     there is no default display.
screenGetDefault  = liftIO $ do
    result <- gdk_screen_get_default
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Screen) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Screen::height
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_height" gdk_screen_height :: 
    IO Int32

{-# DEPRECATED screenHeight ["(Since version 3.22)","Use per-monitor information"] #-}
-- | Gets the height of the default screen in pixels. The returned
-- size is in ”application pixels”, not in ”device pixels” (see
-- 'GI.Gdk.Objects.Screen.screenGetMonitorScaleFactor').
screenHeight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ the height of the default screen in pixels.
screenHeight  = liftIO $ do
    result <- gdk_screen_height
    return result

#if defined(ENABLE_OVERLOADING)
#endif

-- method Screen::height_mm
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_height_mm" gdk_screen_height_mm :: 
    IO Int32

{-# DEPRECATED screenHeightMm ["(Since version 3.22)","Use per-monitor information"] #-}
-- | Returns the height of the default screen in millimeters.
-- Note that on many X servers this value will not be correct.
screenHeightMm ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ the height of the default screen in millimeters,
    -- though it is not always correct.
screenHeightMm  = liftIO $ do
    result <- gdk_screen_height_mm
    return result

#if defined(ENABLE_OVERLOADING)
#endif

-- method Screen::width
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_width" gdk_screen_width :: 
    IO Int32

{-# DEPRECATED screenWidth ["(Since version 3.22)","Use per-monitor information"] #-}
-- | Gets the width of the default screen in pixels. The returned
-- size is in ”application pixels”, not in ”device pixels” (see
-- 'GI.Gdk.Objects.Screen.screenGetMonitorScaleFactor').
screenWidth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ the width of the default screen in pixels.
screenWidth  = liftIO $ do
    result <- gdk_screen_width
    return result

#if defined(ENABLE_OVERLOADING)
#endif

-- method Screen::width_mm
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_screen_width_mm" gdk_screen_width_mm :: 
    IO Int32

{-# DEPRECATED screenWidthMm ["(Since version 3.22)","Use per-monitor information"] #-}
-- | Returns the width of the default screen in millimeters.
-- Note that on many X servers this value will not be correct.
screenWidthMm ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ the width of the default screen in millimeters,
    -- though it is not always correct.
screenWidthMm  = liftIO $ do
    result <- gdk_screen_width_mm
    return result

#if defined(ENABLE_OVERLOADING)
#endif


