{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated when the owner of a selection changes. On X11, this
-- information is only available if the X server supports the XFIXES
-- extension.
-- 
-- /Since: 2.6/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventOwnerChange
    ( 

-- * Exported types
    EventOwnerChange(..)                    ,
    newZeroEventOwnerChange                 ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventOwnerChangeMethod           ,
#endif



 -- * Properties


-- ** owner #attr:owner#
-- | the new owner of the selection, or 'P.Nothing' if there is none

    clearEventOwnerChangeOwner              ,
#if defined(ENABLE_OVERLOADING)
    eventOwnerChange_owner                  ,
#endif
    getEventOwnerChangeOwner                ,
    setEventOwnerChangeOwner                ,


-- ** reason #attr:reason#
-- | the reason for the ownership change as a t'GI.Gdk.Enums.OwnerChange' value

#if defined(ENABLE_OVERLOADING)
    eventOwnerChange_reason                 ,
#endif
    getEventOwnerChangeReason               ,
    setEventOwnerChangeReason               ,


-- ** selection #attr:selection#
-- | the atom identifying the selection

#if defined(ENABLE_OVERLOADING)
    eventOwnerChange_selection              ,
#endif
    getEventOwnerChangeSelection            ,


-- ** selectionTime #attr:selectionTime#
-- | the time at which the selection ownership was taken
--   over

#if defined(ENABLE_OVERLOADING)
    eventOwnerChange_selectionTime          ,
#endif
    getEventOwnerChangeSelectionTime        ,
    setEventOwnerChangeSelectionTime        ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventOwnerChange_sendEvent              ,
#endif
    getEventOwnerChangeSendEvent            ,
    setEventOwnerChangeSendEvent            ,


-- ** time #attr:time#
-- | the timestamp of the event

#if defined(ENABLE_OVERLOADING)
    eventOwnerChange_time                   ,
#endif
    getEventOwnerChangeTime                 ,
    setEventOwnerChangeTime                 ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeOwnerChange').

#if defined(ENABLE_OVERLOADING)
    eventOwnerChange_type                   ,
#endif
    getEventOwnerChangeType                 ,
    setEventOwnerChangeType                 ,


-- ** window #attr:window#
-- | the window which received the event

    clearEventOwnerChangeWindow             ,
#if defined(ENABLE_OVERLOADING)
    eventOwnerChange_window                 ,
#endif
    getEventOwnerChangeWindow               ,
    setEventOwnerChangeWindow               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom

#endif

-- | Memory-managed wrapper type.
newtype EventOwnerChange = EventOwnerChange (SP.ManagedPtr EventOwnerChange)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventOwnerChange where
    toManagedPtr (EventOwnerChange p) = p

instance BoxedPtr EventOwnerChange where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr EventOwnerChange)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventOwnerChange where
    boxedPtrCalloc = callocBytes 56


-- | Construct a t'EventOwnerChange' struct initialized to zero.
newZeroEventOwnerChange :: MonadIO m => m EventOwnerChange
newZeroEventOwnerChange = liftIO $ boxedPtrCalloc >>= wrapPtr EventOwnerChange

instance tag ~ 'AttrSet => Constructible EventOwnerChange tag where
    new _ attrs = do
        o <- newZeroEventOwnerChange
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventOwnerChange #type
-- @
getEventOwnerChangeType :: MonadIO m => EventOwnerChange -> m Gdk.Enums.EventType
getEventOwnerChangeType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventOwnerChange [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventOwnerChangeType :: MonadIO m => EventOwnerChange -> Gdk.Enums.EventType -> m ()
setEventOwnerChangeType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeTypeFieldInfo
instance AttrInfo EventOwnerChangeTypeFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeTypeFieldInfo = (~) EventOwnerChange
    type AttrAllowedOps EventOwnerChangeTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventOwnerChangeTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventOwnerChangeTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventOwnerChangeTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventOwnerChangeTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventOwnerChangeTypeFieldInfo = "type"
    type AttrOrigin EventOwnerChangeTypeFieldInfo = EventOwnerChange
    attrGet = getEventOwnerChangeType
    attrSet = setEventOwnerChangeType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventOwnerChange.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventOwnerChange.html#g:attr:type"
        })

eventOwnerChange_type :: AttrLabelProxy "type"
eventOwnerChange_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventOwnerChange #window
-- @
getEventOwnerChangeWindow :: MonadIO m => EventOwnerChange -> m (Maybe Gdk.Window.Window)
getEventOwnerChangeWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventOwnerChange [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventOwnerChangeWindow :: MonadIO m => EventOwnerChange -> Ptr Gdk.Window.Window -> m ()
setEventOwnerChangeWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventOwnerChangeWindow :: MonadIO m => EventOwnerChange -> m ()
clearEventOwnerChangeWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeWindowFieldInfo
instance AttrInfo EventOwnerChangeWindowFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeWindowFieldInfo = (~) EventOwnerChange
    type AttrAllowedOps EventOwnerChangeWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventOwnerChangeWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventOwnerChangeWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventOwnerChangeWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventOwnerChangeWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventOwnerChangeWindowFieldInfo = "window"
    type AttrOrigin EventOwnerChangeWindowFieldInfo = EventOwnerChange
    attrGet = getEventOwnerChangeWindow
    attrSet = setEventOwnerChangeWindow
    attrConstruct = undefined
    attrClear = clearEventOwnerChangeWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventOwnerChange.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventOwnerChange.html#g:attr:window"
        })

eventOwnerChange_window :: AttrLabelProxy "window"
eventOwnerChange_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventOwnerChange #sendEvent
-- @
getEventOwnerChangeSendEvent :: MonadIO m => EventOwnerChange -> m Int8
getEventOwnerChangeSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventOwnerChange [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventOwnerChangeSendEvent :: MonadIO m => EventOwnerChange -> Int8 -> m ()
setEventOwnerChangeSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeSendEventFieldInfo
instance AttrInfo EventOwnerChangeSendEventFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeSendEventFieldInfo = (~) EventOwnerChange
    type AttrAllowedOps EventOwnerChangeSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventOwnerChangeSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventOwnerChangeSendEventFieldInfo = (~)Int8
    type AttrTransferType EventOwnerChangeSendEventFieldInfo = Int8
    type AttrGetType EventOwnerChangeSendEventFieldInfo = Int8
    type AttrLabel EventOwnerChangeSendEventFieldInfo = "send_event"
    type AttrOrigin EventOwnerChangeSendEventFieldInfo = EventOwnerChange
    attrGet = getEventOwnerChangeSendEvent
    attrSet = setEventOwnerChangeSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventOwnerChange.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventOwnerChange.html#g:attr:sendEvent"
        })

eventOwnerChange_sendEvent :: AttrLabelProxy "sendEvent"
eventOwnerChange_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@owner@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventOwnerChange #owner
-- @
getEventOwnerChangeOwner :: MonadIO m => EventOwnerChange -> m (Maybe Gdk.Window.Window)
getEventOwnerChangeOwner s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@owner@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventOwnerChange [ #owner 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventOwnerChangeOwner :: MonadIO m => EventOwnerChange -> Ptr Gdk.Window.Window -> m ()
setEventOwnerChangeOwner s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@owner@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #owner
-- @
clearEventOwnerChangeOwner :: MonadIO m => EventOwnerChange -> m ()
clearEventOwnerChangeOwner s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeOwnerFieldInfo
instance AttrInfo EventOwnerChangeOwnerFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeOwnerFieldInfo = (~) EventOwnerChange
    type AttrAllowedOps EventOwnerChangeOwnerFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventOwnerChangeOwnerFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventOwnerChangeOwnerFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventOwnerChangeOwnerFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventOwnerChangeOwnerFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventOwnerChangeOwnerFieldInfo = "owner"
    type AttrOrigin EventOwnerChangeOwnerFieldInfo = EventOwnerChange
    attrGet = getEventOwnerChangeOwner
    attrSet = setEventOwnerChangeOwner
    attrConstruct = undefined
    attrClear = clearEventOwnerChangeOwner
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventOwnerChange.owner"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventOwnerChange.html#g:attr:owner"
        })

eventOwnerChange_owner :: AttrLabelProxy "owner"
eventOwnerChange_owner = AttrLabelProxy

#endif


-- | Get the value of the “@reason@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventOwnerChange #reason
-- @
getEventOwnerChangeReason :: MonadIO m => EventOwnerChange -> m Gdk.Enums.OwnerChange
getEventOwnerChangeReason s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@reason@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventOwnerChange [ #reason 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventOwnerChangeReason :: MonadIO m => EventOwnerChange -> Gdk.Enums.OwnerChange -> m ()
setEventOwnerChangeReason s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 32) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeReasonFieldInfo
instance AttrInfo EventOwnerChangeReasonFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeReasonFieldInfo = (~) EventOwnerChange
    type AttrAllowedOps EventOwnerChangeReasonFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventOwnerChangeReasonFieldInfo = (~) Gdk.Enums.OwnerChange
    type AttrTransferTypeConstraint EventOwnerChangeReasonFieldInfo = (~)Gdk.Enums.OwnerChange
    type AttrTransferType EventOwnerChangeReasonFieldInfo = Gdk.Enums.OwnerChange
    type AttrGetType EventOwnerChangeReasonFieldInfo = Gdk.Enums.OwnerChange
    type AttrLabel EventOwnerChangeReasonFieldInfo = "reason"
    type AttrOrigin EventOwnerChangeReasonFieldInfo = EventOwnerChange
    attrGet = getEventOwnerChangeReason
    attrSet = setEventOwnerChangeReason
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventOwnerChange.reason"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventOwnerChange.html#g:attr:reason"
        })

eventOwnerChange_reason :: AttrLabelProxy "reason"
eventOwnerChange_reason = AttrLabelProxy

#endif


-- | Get the value of the “@selection@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventOwnerChange #selection
-- @
getEventOwnerChangeSelection :: MonadIO m => EventOwnerChange -> m Gdk.Atom.Atom
getEventOwnerChangeSelection s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 40 :: (Ptr Gdk.Atom.Atom)
    val' <- (newPtr Gdk.Atom.Atom) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeSelectionFieldInfo
instance AttrInfo EventOwnerChangeSelectionFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeSelectionFieldInfo = (~) EventOwnerChange
    type AttrAllowedOps EventOwnerChangeSelectionFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventOwnerChangeSelectionFieldInfo = (~) (Ptr Gdk.Atom.Atom)
    type AttrTransferTypeConstraint EventOwnerChangeSelectionFieldInfo = (~)(Ptr Gdk.Atom.Atom)
    type AttrTransferType EventOwnerChangeSelectionFieldInfo = (Ptr Gdk.Atom.Atom)
    type AttrGetType EventOwnerChangeSelectionFieldInfo = Gdk.Atom.Atom
    type AttrLabel EventOwnerChangeSelectionFieldInfo = "selection"
    type AttrOrigin EventOwnerChangeSelectionFieldInfo = EventOwnerChange
    attrGet = getEventOwnerChangeSelection
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventOwnerChange.selection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventOwnerChange.html#g:attr:selection"
        })

eventOwnerChange_selection :: AttrLabelProxy "selection"
eventOwnerChange_selection = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventOwnerChange #time
-- @
getEventOwnerChangeTime :: MonadIO m => EventOwnerChange -> m Word32
getEventOwnerChangeTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventOwnerChange [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventOwnerChangeTime :: MonadIO m => EventOwnerChange -> Word32 -> m ()
setEventOwnerChangeTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeTimeFieldInfo
instance AttrInfo EventOwnerChangeTimeFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeTimeFieldInfo = (~) EventOwnerChange
    type AttrAllowedOps EventOwnerChangeTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventOwnerChangeTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventOwnerChangeTimeFieldInfo = (~)Word32
    type AttrTransferType EventOwnerChangeTimeFieldInfo = Word32
    type AttrGetType EventOwnerChangeTimeFieldInfo = Word32
    type AttrLabel EventOwnerChangeTimeFieldInfo = "time"
    type AttrOrigin EventOwnerChangeTimeFieldInfo = EventOwnerChange
    attrGet = getEventOwnerChangeTime
    attrSet = setEventOwnerChangeTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventOwnerChange.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventOwnerChange.html#g:attr:time"
        })

eventOwnerChange_time :: AttrLabelProxy "time"
eventOwnerChange_time = AttrLabelProxy

#endif


-- | Get the value of the “@selection_time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventOwnerChange #selectionTime
-- @
getEventOwnerChangeSelectionTime :: MonadIO m => EventOwnerChange -> m Word32
getEventOwnerChangeSelectionTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 52) :: IO Word32
    return val

-- | Set the value of the “@selection_time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventOwnerChange [ #selectionTime 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventOwnerChangeSelectionTime :: MonadIO m => EventOwnerChange -> Word32 -> m ()
setEventOwnerChangeSelectionTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 52) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeSelectionTimeFieldInfo
instance AttrInfo EventOwnerChangeSelectionTimeFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeSelectionTimeFieldInfo = (~) EventOwnerChange
    type AttrAllowedOps EventOwnerChangeSelectionTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventOwnerChangeSelectionTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventOwnerChangeSelectionTimeFieldInfo = (~)Word32
    type AttrTransferType EventOwnerChangeSelectionTimeFieldInfo = Word32
    type AttrGetType EventOwnerChangeSelectionTimeFieldInfo = Word32
    type AttrLabel EventOwnerChangeSelectionTimeFieldInfo = "selection_time"
    type AttrOrigin EventOwnerChangeSelectionTimeFieldInfo = EventOwnerChange
    attrGet = getEventOwnerChangeSelectionTime
    attrSet = setEventOwnerChangeSelectionTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventOwnerChange.selectionTime"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventOwnerChange.html#g:attr:selectionTime"
        })

eventOwnerChange_selectionTime :: AttrLabelProxy "selectionTime"
eventOwnerChange_selectionTime = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventOwnerChange
type instance O.AttributeList EventOwnerChange = EventOwnerChangeAttributeList
type EventOwnerChangeAttributeList = ('[ '("type", EventOwnerChangeTypeFieldInfo), '("window", EventOwnerChangeWindowFieldInfo), '("sendEvent", EventOwnerChangeSendEventFieldInfo), '("owner", EventOwnerChangeOwnerFieldInfo), '("reason", EventOwnerChangeReasonFieldInfo), '("selection", EventOwnerChangeSelectionFieldInfo), '("time", EventOwnerChangeTimeFieldInfo), '("selectionTime", EventOwnerChangeSelectionTimeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventOwnerChangeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventOwnerChangeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventOwnerChangeMethod t EventOwnerChange, O.OverloadedMethod info EventOwnerChange p) => OL.IsLabel t (EventOwnerChange -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventOwnerChangeMethod t EventOwnerChange, O.OverloadedMethod info EventOwnerChange p, R.HasField t EventOwnerChange p) => R.HasField t EventOwnerChange p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventOwnerChangeMethod t EventOwnerChange, O.OverloadedMethodInfo info EventOwnerChange) => OL.IsLabel t (O.MethodProxy info EventOwnerChange) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


