

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Enums
    ( 

 -- * Enumerations


-- ** Colorspace #enum:Colorspace#

    Colorspace(..)                          ,


-- ** InterpType #enum:InterpType#

    InterpType(..)                          ,


-- ** PixbufAlphaMode #enum:PixbufAlphaMode#

    PixbufAlphaMode(..)                     ,


-- ** PixbufError #enum:PixbufError#

    PixbufError(..)                         ,
    catchPixbufError                        ,
    handlePixbufError                       ,


-- ** PixbufRotation #enum:PixbufRotation#

    PixbufRotation(..)                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum PixbufRotation
-- | The possible rotations which can be passed to 'GI.GdkPixbuf.Objects.Pixbuf.pixbufRotateSimple'.
-- 
-- To make them easier to use, their numerical values are the actual degrees.
data PixbufRotation = 
      PixbufRotationNone
    -- ^ No rotation.
    | PixbufRotationCounterclockwise
    -- ^ Rotate by 90 degrees.
    | PixbufRotationUpsidedown
    -- ^ Rotate by 180 degrees.
    | PixbufRotationClockwise
    -- ^ Rotate by 270 degrees.
    | AnotherPixbufRotation Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PixbufRotation where
    fromEnum PixbufRotationNone = 0
    fromEnum PixbufRotationCounterclockwise = 90
    fromEnum PixbufRotationUpsidedown = 180
    fromEnum PixbufRotationClockwise = 270
    fromEnum (AnotherPixbufRotation k) = k

    toEnum 0 = PixbufRotationNone
    toEnum 90 = PixbufRotationCounterclockwise
    toEnum 180 = PixbufRotationUpsidedown
    toEnum 270 = PixbufRotationClockwise
    toEnum k = AnotherPixbufRotation k

instance P.Ord PixbufRotation where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PixbufRotation = '[]
instance O.HasParentTypes PixbufRotation

foreign import ccall "gdk_pixbuf_rotation_get_type" c_gdk_pixbuf_rotation_get_type :: 
    IO GType

instance B.Types.TypedObject PixbufRotation where
    glibType = c_gdk_pixbuf_rotation_get_type

instance B.Types.BoxedEnum PixbufRotation

-- Enum PixbufError
-- | An error code in the @GDK_PIXBUF_ERROR@ domain.
-- 
-- Many gdk-pixbuf operations can cause errors in this domain, or in
-- the @G_FILE_ERROR@ domain.
data PixbufError = 
      PixbufErrorCorruptImage
    -- ^ An image file was broken somehow.
    | PixbufErrorInsufficientMemory
    -- ^ Not enough memory.
    | PixbufErrorBadOption
    -- ^ A bad option was passed to a pixbuf save module.
    | PixbufErrorUnknownType
    -- ^ Unknown image type.
    | PixbufErrorUnsupportedOperation
    -- ^ Don\'t know how to perform the
    --  given operation on the type of image at hand.
    | PixbufErrorFailed
    -- ^ Generic failure code, something went wrong.
    | PixbufErrorIncompleteAnimation
    -- ^ Only part of the animation was loaded.
    | AnotherPixbufError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PixbufError where
    fromEnum PixbufErrorCorruptImage = 0
    fromEnum PixbufErrorInsufficientMemory = 1
    fromEnum PixbufErrorBadOption = 2
    fromEnum PixbufErrorUnknownType = 3
    fromEnum PixbufErrorUnsupportedOperation = 4
    fromEnum PixbufErrorFailed = 5
    fromEnum PixbufErrorIncompleteAnimation = 6
    fromEnum (AnotherPixbufError k) = k

    toEnum 0 = PixbufErrorCorruptImage
    toEnum 1 = PixbufErrorInsufficientMemory
    toEnum 2 = PixbufErrorBadOption
    toEnum 3 = PixbufErrorUnknownType
    toEnum 4 = PixbufErrorUnsupportedOperation
    toEnum 5 = PixbufErrorFailed
    toEnum 6 = PixbufErrorIncompleteAnimation
    toEnum k = AnotherPixbufError k

instance P.Ord PixbufError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass PixbufError where
    gerrorClassDomain _ = "gdk-pixbuf-error-quark"

-- | Catch exceptions of type `PixbufError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchPixbufError ::
    IO a ->
    (PixbufError -> GErrorMessage -> IO a) ->
    IO a
catchPixbufError = catchGErrorJustDomain

-- | Handle exceptions of type `PixbufError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handlePixbufError ::
    (PixbufError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handlePixbufError = handleGErrorJustDomain

type instance O.ParentTypes PixbufError = '[]
instance O.HasParentTypes PixbufError

foreign import ccall "gdk_pixbuf_error_get_type" c_gdk_pixbuf_error_get_type :: 
    IO GType

instance B.Types.TypedObject PixbufError where
    glibType = c_gdk_pixbuf_error_get_type

instance B.Types.BoxedEnum PixbufError

-- Enum PixbufAlphaMode
{-# DEPRECATED PixbufAlphaMode ["(Since version 2.42)","There is no user of GdkPixbufAlphaMode in GdkPixbuf,","  and the Xlib utility functions have been split out to their own","  library, gdk-pixbuf-xlib"] #-}
-- | Control the alpha channel for drawables.
-- 
-- These values can be passed to @/gdk_pixbuf_xlib_render_to_drawable_alpha()/@
-- in gdk-pixbuf-xlib to control how the alpha channel of an image should
-- be handled.
-- 
-- This function can create a bilevel clipping mask (black and white) and use
-- it while painting the image.
-- 
-- In the future, when the X Window System gets an alpha channel extension,
-- it will be possible to do full alpha compositing onto arbitrary drawables.
-- For now both cases fall back to a bilevel clipping mask.
data PixbufAlphaMode = 
      PixbufAlphaModeBilevel
    -- ^ A bilevel clipping mask (black and white)
    --  will be created and used to draw the image.  Pixels below 0.5 opacity
    --  will be considered fully transparent, and all others will be
    --  considered fully opaque.
    | PixbufAlphaModeFull
    -- ^ For now falls back to @/GDK_PIXBUF_ALPHA_BILEVEL/@.
    --  In the future it will do full alpha compositing.
    | AnotherPixbufAlphaMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PixbufAlphaMode where
    fromEnum PixbufAlphaModeBilevel = 0
    fromEnum PixbufAlphaModeFull = 1
    fromEnum (AnotherPixbufAlphaMode k) = k

    toEnum 0 = PixbufAlphaModeBilevel
    toEnum 1 = PixbufAlphaModeFull
    toEnum k = AnotherPixbufAlphaMode k

instance P.Ord PixbufAlphaMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PixbufAlphaMode = '[]
instance O.HasParentTypes PixbufAlphaMode

foreign import ccall "gdk_pixbuf_alpha_mode_get_type" c_gdk_pixbuf_alpha_mode_get_type :: 
    IO GType

instance B.Types.TypedObject PixbufAlphaMode where
    glibType = c_gdk_pixbuf_alpha_mode_get_type

instance B.Types.BoxedEnum PixbufAlphaMode

-- Enum InterpType
-- | Interpolation modes for scaling functions.
-- 
-- The @GDK_INTERP_NEAREST@ mode is the fastest scaling method, but has
-- horrible quality when scaling down; @GDK_INTERP_BILINEAR@ is the best
-- choice if you aren\'t sure what to choose, it has a good speed\/quality
-- balance.
-- 
-- __Note__: Cubic filtering is missing from the list; hyperbolic
-- interpolation is just as fast and results in higher quality.
data InterpType = 
      InterpTypeNearest
    -- ^ Nearest neighbor sampling; this is the fastest
    --  and lowest quality mode. Quality is normally unacceptable when scaling
    --  down, but may be OK when scaling up.
    | InterpTypeTiles
    -- ^ This is an accurate simulation of the PostScript
    --  image operator without any interpolation enabled.  Each pixel is
    --  rendered as a tiny parallelogram of solid color, the edges of which
    --  are implemented with antialiasing.  It resembles nearest neighbor for
    --  enlargement, and bilinear for reduction.
    | InterpTypeBilinear
    -- ^ Best quality\/speed balance; use this mode by
    --  default. Bilinear interpolation.  For enlargement, it is
    --  equivalent to point-sampling the ideal bilinear-interpolated image.
    --  For reduction, it is equivalent to laying down small tiles and
    --  integrating over the coverage area.
    | InterpTypeHyper
    -- ^ This is the slowest and highest quality
    --  reconstruction function. It is derived from the hyperbolic filters in
    --  Wolberg\'s \"Digital Image Warping\", and is formally defined as the
    --  hyperbolic-filter sampling the ideal hyperbolic-filter interpolated
    --  image (the filter is designed to be idempotent for 1:1 pixel mapping).
    --  __Deprecated__: this interpolation filter is deprecated, as in reality
    --  it has a lower quality than the /@gDKINTERPBILINEAR@/ filter
    --  (Since: 2.38)
    | AnotherInterpType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InterpType where
    fromEnum InterpTypeNearest = 0
    fromEnum InterpTypeTiles = 1
    fromEnum InterpTypeBilinear = 2
    fromEnum InterpTypeHyper = 3
    fromEnum (AnotherInterpType k) = k

    toEnum 0 = InterpTypeNearest
    toEnum 1 = InterpTypeTiles
    toEnum 2 = InterpTypeBilinear
    toEnum 3 = InterpTypeHyper
    toEnum k = AnotherInterpType k

instance P.Ord InterpType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InterpType = '[]
instance O.HasParentTypes InterpType

foreign import ccall "gdk_interp_type_get_type" c_gdk_interp_type_get_type :: 
    IO GType

instance B.Types.TypedObject InterpType where
    glibType = c_gdk_interp_type_get_type

instance B.Types.BoxedEnum InterpType

-- Enum Colorspace
-- | This enumeration defines the color spaces that are supported by
-- the gdk-pixbuf library.
-- 
-- Currently only RGB is supported.
data Colorspace = 
      ColorspaceRgb
    -- ^ Indicates a red\/green\/blue additive color space.
    | AnotherColorspace Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Colorspace where
    fromEnum ColorspaceRgb = 0
    fromEnum (AnotherColorspace k) = k

    toEnum 0 = ColorspaceRgb
    toEnum k = AnotherColorspace k

instance P.Ord Colorspace where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Colorspace = '[]
instance O.HasParentTypes Colorspace

foreign import ccall "gdk_colorspace_get_type" c_gdk_colorspace_get_type :: 
    IO GType

instance B.Types.TypedObject Colorspace where
    glibType = c_gdk_colorspace_get_type

instance B.Types.BoxedEnum Colorspace


