{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The signature prefix for a module.
-- 
-- The signature of a module is a set of prefixes. Prefixes are encoded as
-- pairs of ordinary strings, where the second string, called the mask, if
-- not @NULL@, must be of the same length as the first one and may contain
-- \' \', \'!\', \'x\', \'z\', and \'n\' to indicate bytes that must be matched,
-- not matched, \"don\'t-care\"-bytes, zeros and non-zeros, respectively.
-- 
-- Each prefix has an associated integer that describes the relevance of
-- the prefix, with 0 meaning a mismatch and 100 a \"perfect match\".
-- 
-- Starting with gdk-pixbuf 2.8, the first byte of the mask may be \'*\',
-- indicating an unanchored pattern that matches not only at the beginning,
-- but also in the middle. Versions prior to 2.8 will interpret the \'*\'
-- like an \'x\'.
-- 
-- The signature of a module is stored as an array of
-- @GdkPixbufModulePatterns@. The array is terminated by a pattern
-- where the @prefix@ is @NULL@.
-- 
-- 
-- === /c code/
-- >GdkPixbufModulePattern *signature[] = {
-- >  { "abcdx", " !x z", 100 },
-- >  { "bla", NULL,  90 },
-- >  { NULL, NULL, 0 }
-- >};
-- 
-- 
-- In the example above, the signature matches e.g. \"auud\\0\" with
-- relevance 100, and \"blau\" with relevance 90.
-- 
-- /Since: 2.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Structs.PixbufModulePattern
    ( 

-- * Exported types
    PixbufModulePattern(..)                 ,
    newZeroPixbufModulePattern              ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolvePixbufModulePatternMethod        ,
#endif



 -- * Properties


-- ** mask #attr:mask#
-- | mask containing bytes which modify how the prefix is matched against
--  test data

    clearPixbufModulePatternMask            ,
    getPixbufModulePatternMask              ,
#if defined(ENABLE_OVERLOADING)
    pixbufModulePattern_mask                ,
#endif
    setPixbufModulePatternMask              ,


-- ** prefix #attr:prefix#
-- | the prefix for this pattern

    clearPixbufModulePatternPrefix          ,
    getPixbufModulePatternPrefix            ,
#if defined(ENABLE_OVERLOADING)
    pixbufModulePattern_prefix              ,
#endif
    setPixbufModulePatternPrefix            ,


-- ** relevance #attr:relevance#
-- | relevance of this pattern

    getPixbufModulePatternRelevance         ,
#if defined(ENABLE_OVERLOADING)
    pixbufModulePattern_relevance           ,
#endif
    setPixbufModulePatternRelevance         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype PixbufModulePattern = PixbufModulePattern (SP.ManagedPtr PixbufModulePattern)
    deriving (Eq)

instance SP.ManagedPtrNewtype PixbufModulePattern where
    toManagedPtr (PixbufModulePattern p) = p

instance BoxedPtr PixbufModulePattern where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr PixbufModulePattern)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr PixbufModulePattern where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'PixbufModulePattern' struct initialized to zero.
newZeroPixbufModulePattern :: MonadIO m => m PixbufModulePattern
newZeroPixbufModulePattern = liftIO $ boxedPtrCalloc >>= wrapPtr PixbufModulePattern

instance tag ~ 'AttrSet => Constructible PixbufModulePattern tag where
    new _ attrs = do
        o <- newZeroPixbufModulePattern
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@prefix@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufModulePattern #prefix
-- @
getPixbufModulePatternPrefix :: MonadIO m => PixbufModulePattern -> m (Maybe T.Text)
getPixbufModulePatternPrefix s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@prefix@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufModulePattern [ #prefix 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufModulePatternPrefix :: MonadIO m => PixbufModulePattern -> CString -> m ()
setPixbufModulePatternPrefix s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@prefix@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #prefix
-- @
clearPixbufModulePatternPrefix :: MonadIO m => PixbufModulePattern -> m ()
clearPixbufModulePatternPrefix s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data PixbufModulePatternPrefixFieldInfo
instance AttrInfo PixbufModulePatternPrefixFieldInfo where
    type AttrBaseTypeConstraint PixbufModulePatternPrefixFieldInfo = (~) PixbufModulePattern
    type AttrAllowedOps PixbufModulePatternPrefixFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufModulePatternPrefixFieldInfo = (~) CString
    type AttrTransferTypeConstraint PixbufModulePatternPrefixFieldInfo = (~)CString
    type AttrTransferType PixbufModulePatternPrefixFieldInfo = CString
    type AttrGetType PixbufModulePatternPrefixFieldInfo = Maybe T.Text
    type AttrLabel PixbufModulePatternPrefixFieldInfo = "prefix"
    type AttrOrigin PixbufModulePatternPrefixFieldInfo = PixbufModulePattern
    attrGet = getPixbufModulePatternPrefix
    attrSet = setPixbufModulePatternPrefix
    attrConstruct = undefined
    attrClear = clearPixbufModulePatternPrefix
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufModulePattern.prefix"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufModulePattern.html#g:attr:prefix"
        })

pixbufModulePattern_prefix :: AttrLabelProxy "prefix"
pixbufModulePattern_prefix = AttrLabelProxy

#endif


-- | Get the value of the “@mask@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufModulePattern #mask
-- @
getPixbufModulePatternMask :: MonadIO m => PixbufModulePattern -> m (Maybe T.Text)
getPixbufModulePatternMask s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@mask@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufModulePattern [ #mask 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufModulePatternMask :: MonadIO m => PixbufModulePattern -> CString -> m ()
setPixbufModulePatternMask s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@mask@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #mask
-- @
clearPixbufModulePatternMask :: MonadIO m => PixbufModulePattern -> m ()
clearPixbufModulePatternMask s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data PixbufModulePatternMaskFieldInfo
instance AttrInfo PixbufModulePatternMaskFieldInfo where
    type AttrBaseTypeConstraint PixbufModulePatternMaskFieldInfo = (~) PixbufModulePattern
    type AttrAllowedOps PixbufModulePatternMaskFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufModulePatternMaskFieldInfo = (~) CString
    type AttrTransferTypeConstraint PixbufModulePatternMaskFieldInfo = (~)CString
    type AttrTransferType PixbufModulePatternMaskFieldInfo = CString
    type AttrGetType PixbufModulePatternMaskFieldInfo = Maybe T.Text
    type AttrLabel PixbufModulePatternMaskFieldInfo = "mask"
    type AttrOrigin PixbufModulePatternMaskFieldInfo = PixbufModulePattern
    attrGet = getPixbufModulePatternMask
    attrSet = setPixbufModulePatternMask
    attrConstruct = undefined
    attrClear = clearPixbufModulePatternMask
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufModulePattern.mask"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufModulePattern.html#g:attr:mask"
        })

pixbufModulePattern_mask :: AttrLabelProxy "mask"
pixbufModulePattern_mask = AttrLabelProxy

#endif


-- | Get the value of the “@relevance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufModulePattern #relevance
-- @
getPixbufModulePatternRelevance :: MonadIO m => PixbufModulePattern -> m Int32
getPixbufModulePatternRelevance s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int32
    return val

-- | Set the value of the “@relevance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufModulePattern [ #relevance 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufModulePatternRelevance :: MonadIO m => PixbufModulePattern -> Int32 -> m ()
setPixbufModulePatternRelevance s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data PixbufModulePatternRelevanceFieldInfo
instance AttrInfo PixbufModulePatternRelevanceFieldInfo where
    type AttrBaseTypeConstraint PixbufModulePatternRelevanceFieldInfo = (~) PixbufModulePattern
    type AttrAllowedOps PixbufModulePatternRelevanceFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PixbufModulePatternRelevanceFieldInfo = (~) Int32
    type AttrTransferTypeConstraint PixbufModulePatternRelevanceFieldInfo = (~)Int32
    type AttrTransferType PixbufModulePatternRelevanceFieldInfo = Int32
    type AttrGetType PixbufModulePatternRelevanceFieldInfo = Int32
    type AttrLabel PixbufModulePatternRelevanceFieldInfo = "relevance"
    type AttrOrigin PixbufModulePatternRelevanceFieldInfo = PixbufModulePattern
    attrGet = getPixbufModulePatternRelevance
    attrSet = setPixbufModulePatternRelevance
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufModulePattern.relevance"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufModulePattern.html#g:attr:relevance"
        })

pixbufModulePattern_relevance :: AttrLabelProxy "relevance"
pixbufModulePattern_relevance = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PixbufModulePattern
type instance O.AttributeList PixbufModulePattern = PixbufModulePatternAttributeList
type PixbufModulePatternAttributeList = ('[ '("prefix", PixbufModulePatternPrefixFieldInfo), '("mask", PixbufModulePatternMaskFieldInfo), '("relevance", PixbufModulePatternRelevanceFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePixbufModulePatternMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePixbufModulePatternMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePixbufModulePatternMethod t PixbufModulePattern, O.OverloadedMethod info PixbufModulePattern p) => OL.IsLabel t (PixbufModulePattern -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePixbufModulePatternMethod t PixbufModulePattern, O.OverloadedMethod info PixbufModulePattern p, R.HasField t PixbufModulePattern p) => R.HasField t PixbufModulePattern p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePixbufModulePatternMethod t PixbufModulePattern, O.OverloadedMethodInfo info PixbufModulePattern) => OL.IsLabel t (O.MethodProxy info PixbufModulePattern) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


