{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- TLS (Transport Layer Security, aka SSL) and DTLS backend. This is an
-- internal type used to coordinate the different classes implemented
-- by a TLS backend.
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.TlsBackend
    ( 

-- * Exported types
    TlsBackend(..)                          ,
    IsTlsBackend                            ,
    toTlsBackend                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [supportsDtls]("GI.Gio.Interfaces.TlsBackend#g:method:supportsDtls"), [supportsTls]("GI.Gio.Interfaces.TlsBackend#g:method:supportsTls"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCertificateType]("GI.Gio.Interfaces.TlsBackend#g:method:getCertificateType"), [getClientConnectionType]("GI.Gio.Interfaces.TlsBackend#g:method:getClientConnectionType"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultDatabase]("GI.Gio.Interfaces.TlsBackend#g:method:getDefaultDatabase"), [getDtlsClientConnectionType]("GI.Gio.Interfaces.TlsBackend#g:method:getDtlsClientConnectionType"), [getDtlsServerConnectionType]("GI.Gio.Interfaces.TlsBackend#g:method:getDtlsServerConnectionType"), [getFileDatabaseType]("GI.Gio.Interfaces.TlsBackend#g:method:getFileDatabaseType"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getServerConnectionType]("GI.Gio.Interfaces.TlsBackend#g:method:getServerConnectionType").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultDatabase]("GI.Gio.Interfaces.TlsBackend#g:method:setDefaultDatabase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveTlsBackendMethod                 ,
#endif

-- ** getCertificateType #method:getCertificateType#

#if defined(ENABLE_OVERLOADING)
    TlsBackendGetCertificateTypeMethodInfo  ,
#endif
    tlsBackendGetCertificateType            ,


-- ** getClientConnectionType #method:getClientConnectionType#

#if defined(ENABLE_OVERLOADING)
    TlsBackendGetClientConnectionTypeMethodInfo,
#endif
    tlsBackendGetClientConnectionType       ,


-- ** getDefault #method:getDefault#

    tlsBackendGetDefault                    ,


-- ** getDefaultDatabase #method:getDefaultDatabase#

#if defined(ENABLE_OVERLOADING)
    TlsBackendGetDefaultDatabaseMethodInfo  ,
#endif
    tlsBackendGetDefaultDatabase            ,


-- ** getDtlsClientConnectionType #method:getDtlsClientConnectionType#

#if defined(ENABLE_OVERLOADING)
    TlsBackendGetDtlsClientConnectionTypeMethodInfo,
#endif
    tlsBackendGetDtlsClientConnectionType   ,


-- ** getDtlsServerConnectionType #method:getDtlsServerConnectionType#

#if defined(ENABLE_OVERLOADING)
    TlsBackendGetDtlsServerConnectionTypeMethodInfo,
#endif
    tlsBackendGetDtlsServerConnectionType   ,


-- ** getFileDatabaseType #method:getFileDatabaseType#

#if defined(ENABLE_OVERLOADING)
    TlsBackendGetFileDatabaseTypeMethodInfo ,
#endif
    tlsBackendGetFileDatabaseType           ,


-- ** getServerConnectionType #method:getServerConnectionType#

#if defined(ENABLE_OVERLOADING)
    TlsBackendGetServerConnectionTypeMethodInfo,
#endif
    tlsBackendGetServerConnectionType       ,


-- ** setDefaultDatabase #method:setDefaultDatabase#

#if defined(ENABLE_OVERLOADING)
    TlsBackendSetDefaultDatabaseMethodInfo  ,
#endif
    tlsBackendSetDefaultDatabase            ,


-- ** supportsDtls #method:supportsDtls#

#if defined(ENABLE_OVERLOADING)
    TlsBackendSupportsDtlsMethodInfo        ,
#endif
    tlsBackendSupportsDtls                  ,


-- ** supportsTls #method:supportsTls#

#if defined(ENABLE_OVERLOADING)
    TlsBackendSupportsTlsMethodInfo         ,
#endif
    tlsBackendSupportsTls                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsCertificate as Gio.TlsCertificate
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsConnection as Gio.TlsConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsInteraction as Gio.TlsInteraction
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsPassword as Gio.TlsPassword
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase

#endif

-- interface TlsBackend 
-- | Memory-managed wrapper type.
newtype TlsBackend = TlsBackend (SP.ManagedPtr TlsBackend)
    deriving (Eq)

instance SP.ManagedPtrNewtype TlsBackend where
    toManagedPtr (TlsBackend p) = p

foreign import ccall "g_tls_backend_get_type"
    c_g_tls_backend_get_type :: IO B.Types.GType

instance B.Types.TypedObject TlsBackend where
    glibType = c_g_tls_backend_get_type

instance B.Types.GObject TlsBackend

-- | Type class for types which can be safely cast to t'TlsBackend', for instance with `toTlsBackend`.
class (SP.GObject o, O.IsDescendantOf TlsBackend o) => IsTlsBackend o
instance (SP.GObject o, O.IsDescendantOf TlsBackend o) => IsTlsBackend o

instance O.HasParentTypes TlsBackend
type instance O.ParentTypes TlsBackend = '[GObject.Object.Object]

-- | Cast to t'TlsBackend', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTlsBackend :: (MIO.MonadIO m, IsTlsBackend o) => o -> m TlsBackend
toTlsBackend = MIO.liftIO . B.ManagedPtr.unsafeCastTo TlsBackend

-- | Convert t'TlsBackend' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TlsBackend) where
    gvalueGType_ = c_g_tls_backend_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TlsBackend)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TlsBackend)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TlsBackend ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TlsBackend
type instance O.AttributeList TlsBackend = TlsBackendAttributeList
type TlsBackendAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTlsBackendMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTlsBackendMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTlsBackendMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTlsBackendMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTlsBackendMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTlsBackendMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTlsBackendMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTlsBackendMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTlsBackendMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTlsBackendMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTlsBackendMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTlsBackendMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTlsBackendMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTlsBackendMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTlsBackendMethod "supportsDtls" o = TlsBackendSupportsDtlsMethodInfo
    ResolveTlsBackendMethod "supportsTls" o = TlsBackendSupportsTlsMethodInfo
    ResolveTlsBackendMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTlsBackendMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTlsBackendMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTlsBackendMethod "getCertificateType" o = TlsBackendGetCertificateTypeMethodInfo
    ResolveTlsBackendMethod "getClientConnectionType" o = TlsBackendGetClientConnectionTypeMethodInfo
    ResolveTlsBackendMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTlsBackendMethod "getDefaultDatabase" o = TlsBackendGetDefaultDatabaseMethodInfo
    ResolveTlsBackendMethod "getDtlsClientConnectionType" o = TlsBackendGetDtlsClientConnectionTypeMethodInfo
    ResolveTlsBackendMethod "getDtlsServerConnectionType" o = TlsBackendGetDtlsServerConnectionTypeMethodInfo
    ResolveTlsBackendMethod "getFileDatabaseType" o = TlsBackendGetFileDatabaseTypeMethodInfo
    ResolveTlsBackendMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTlsBackendMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTlsBackendMethod "getServerConnectionType" o = TlsBackendGetServerConnectionTypeMethodInfo
    ResolveTlsBackendMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTlsBackendMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTlsBackendMethod "setDefaultDatabase" o = TlsBackendSetDefaultDatabaseMethodInfo
    ResolveTlsBackendMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTlsBackendMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTlsBackendMethod t TlsBackend, O.OverloadedMethod info TlsBackend p) => OL.IsLabel t (TlsBackend -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTlsBackendMethod t TlsBackend, O.OverloadedMethod info TlsBackend p, R.HasField t TlsBackend p) => R.HasField t TlsBackend p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTlsBackendMethod t TlsBackend, O.OverloadedMethodInfo info TlsBackend) => OL.IsLabel t (O.MethodProxy info TlsBackend) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method TlsBackend::get_certificate_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_get_certificate_type" g_tls_backend_get_certificate_type :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO CGType

-- | Gets the t'GType' of /@backend@/\'s t'GI.Gio.Objects.TlsCertificate.TlsCertificate' implementation.
-- 
-- /Since: 2.28/
tlsBackendGetCertificateType ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m GType
    -- ^ __Returns:__ the t'GType' of /@backend@/\'s t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    --   implementation.
tlsBackendGetCertificateType backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_get_certificate_type backend'
    let result' = GType result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendGetCertificateTypeMethodInfo
instance (signature ~ (m GType), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendGetCertificateTypeMethodInfo a signature where
    overloadedMethod = tlsBackendGetCertificateType

instance O.OverloadedMethodInfo TlsBackendGetCertificateTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendGetCertificateType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendGetCertificateType"
        })


#endif

-- method TlsBackend::get_client_connection_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_get_client_connection_type" g_tls_backend_get_client_connection_type :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO CGType

-- | Gets the t'GType' of /@backend@/\'s t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection' implementation.
-- 
-- /Since: 2.28/
tlsBackendGetClientConnectionType ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m GType
    -- ^ __Returns:__ the t'GType' of /@backend@/\'s t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    --   implementation.
tlsBackendGetClientConnectionType backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_get_client_connection_type backend'
    let result' = GType result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendGetClientConnectionTypeMethodInfo
instance (signature ~ (m GType), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendGetClientConnectionTypeMethodInfo a signature where
    overloadedMethod = tlsBackendGetClientConnectionType

instance O.OverloadedMethodInfo TlsBackendGetClientConnectionTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendGetClientConnectionType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendGetClientConnectionType"
        })


#endif

-- method TlsBackend::get_default_database
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "TlsDatabase" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_get_default_database" g_tls_backend_get_default_database :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO (Ptr Gio.TlsDatabase.TlsDatabase)

-- | Gets the default t'GI.Gio.Objects.TlsDatabase.TlsDatabase' used to verify TLS connections.
-- 
-- /Since: 2.30/
tlsBackendGetDefaultDatabase ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m Gio.TlsDatabase.TlsDatabase
    -- ^ __Returns:__ the default database, which should be
    --               unreffed when done.
tlsBackendGetDefaultDatabase backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_get_default_database backend'
    checkUnexpectedReturnNULL "tlsBackendGetDefaultDatabase" result
    result' <- (wrapObject Gio.TlsDatabase.TlsDatabase) result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendGetDefaultDatabaseMethodInfo
instance (signature ~ (m Gio.TlsDatabase.TlsDatabase), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendGetDefaultDatabaseMethodInfo a signature where
    overloadedMethod = tlsBackendGetDefaultDatabase

instance O.OverloadedMethodInfo TlsBackendGetDefaultDatabaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendGetDefaultDatabase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendGetDefaultDatabase"
        })


#endif

-- method TlsBackend::get_dtls_client_connection_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_get_dtls_client_connection_type" g_tls_backend_get_dtls_client_connection_type :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO CGType

-- | Gets the t'GType' of /@backend@/’s t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection' implementation.
-- 
-- /Since: 2.48/
tlsBackendGetDtlsClientConnectionType ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m GType
    -- ^ __Returns:__ the t'GType' of /@backend@/’s t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection'
    --   implementation, or @/G_TYPE_INVALID/@ if this backend doesn’t support DTLS.
tlsBackendGetDtlsClientConnectionType backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_get_dtls_client_connection_type backend'
    let result' = GType result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendGetDtlsClientConnectionTypeMethodInfo
instance (signature ~ (m GType), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendGetDtlsClientConnectionTypeMethodInfo a signature where
    overloadedMethod = tlsBackendGetDtlsClientConnectionType

instance O.OverloadedMethodInfo TlsBackendGetDtlsClientConnectionTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendGetDtlsClientConnectionType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendGetDtlsClientConnectionType"
        })


#endif

-- method TlsBackend::get_dtls_server_connection_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_get_dtls_server_connection_type" g_tls_backend_get_dtls_server_connection_type :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO CGType

-- | Gets the t'GType' of /@backend@/’s t'GI.Gio.Interfaces.DtlsServerConnection.DtlsServerConnection' implementation.
-- 
-- /Since: 2.48/
tlsBackendGetDtlsServerConnectionType ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m GType
    -- ^ __Returns:__ the t'GType' of /@backend@/’s t'GI.Gio.Interfaces.DtlsServerConnection.DtlsServerConnection'
    --   implementation, or @/G_TYPE_INVALID/@ if this backend doesn’t support DTLS.
tlsBackendGetDtlsServerConnectionType backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_get_dtls_server_connection_type backend'
    let result' = GType result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendGetDtlsServerConnectionTypeMethodInfo
instance (signature ~ (m GType), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendGetDtlsServerConnectionTypeMethodInfo a signature where
    overloadedMethod = tlsBackendGetDtlsServerConnectionType

instance O.OverloadedMethodInfo TlsBackendGetDtlsServerConnectionTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendGetDtlsServerConnectionType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendGetDtlsServerConnectionType"
        })


#endif

-- method TlsBackend::get_file_database_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_get_file_database_type" g_tls_backend_get_file_database_type :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO CGType

-- | Gets the t'GType' of /@backend@/\'s t'GI.Gio.Interfaces.TlsFileDatabase.TlsFileDatabase' implementation.
-- 
-- /Since: 2.30/
tlsBackendGetFileDatabaseType ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m GType
    -- ^ __Returns:__ the t'GType' of backend\'s t'GI.Gio.Interfaces.TlsFileDatabase.TlsFileDatabase' implementation.
tlsBackendGetFileDatabaseType backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_get_file_database_type backend'
    let result' = GType result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendGetFileDatabaseTypeMethodInfo
instance (signature ~ (m GType), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendGetFileDatabaseTypeMethodInfo a signature where
    overloadedMethod = tlsBackendGetFileDatabaseType

instance O.OverloadedMethodInfo TlsBackendGetFileDatabaseTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendGetFileDatabaseType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendGetFileDatabaseType"
        })


#endif

-- method TlsBackend::get_server_connection_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_get_server_connection_type" g_tls_backend_get_server_connection_type :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO CGType

-- | Gets the t'GType' of /@backend@/\'s t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection' implementation.
-- 
-- /Since: 2.28/
tlsBackendGetServerConnectionType ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m GType
    -- ^ __Returns:__ the t'GType' of /@backend@/\'s t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection'
    --   implementation.
tlsBackendGetServerConnectionType backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_get_server_connection_type backend'
    let result' = GType result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendGetServerConnectionTypeMethodInfo
instance (signature ~ (m GType), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendGetServerConnectionTypeMethodInfo a signature where
    overloadedMethod = tlsBackendGetServerConnectionType

instance O.OverloadedMethodInfo TlsBackendGetServerConnectionTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendGetServerConnectionType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendGetServerConnectionType"
        })


#endif

-- method TlsBackend::set_default_database
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "database"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsDatabase" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsDatabase" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_set_default_database" g_tls_backend_set_default_database :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    Ptr Gio.TlsDatabase.TlsDatabase ->      -- database : TInterface (Name {namespace = "Gio", name = "TlsDatabase"})
    IO ()

-- | Set the default t'GI.Gio.Objects.TlsDatabase.TlsDatabase' used to verify TLS connections
-- 
-- Any subsequent call to 'GI.Gio.Interfaces.TlsBackend.tlsBackendGetDefaultDatabase' will return
-- the database set in this call.  Existing databases and connections are not
-- modified.
-- 
-- Setting a 'P.Nothing' default database will reset to using the system default
-- database as if 'GI.Gio.Interfaces.TlsBackend.tlsBackendSetDefaultDatabase' had never been called.
-- 
-- /Since: 2.60/
tlsBackendSetDefaultDatabase ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a, Gio.TlsDatabase.IsTlsDatabase b) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> Maybe (b)
    -- ^ /@database@/: the t'GI.Gio.Objects.TlsDatabase.TlsDatabase'
    -> m ()
tlsBackendSetDefaultDatabase backend database = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    maybeDatabase <- case database of
        Nothing -> return FP.nullPtr
        Just jDatabase -> do
            jDatabase' <- unsafeManagedPtrCastPtr jDatabase
            return jDatabase'
    g_tls_backend_set_default_database backend' maybeDatabase
    touchManagedPtr backend
    whenJust database touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsBackendSetDefaultDatabaseMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTlsBackend a, Gio.TlsDatabase.IsTlsDatabase b) => O.OverloadedMethod TlsBackendSetDefaultDatabaseMethodInfo a signature where
    overloadedMethod = tlsBackendSetDefaultDatabase

instance O.OverloadedMethodInfo TlsBackendSetDefaultDatabaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendSetDefaultDatabase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendSetDefaultDatabase"
        })


#endif

-- method TlsBackend::supports_dtls
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_supports_dtls" g_tls_backend_supports_dtls :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO CInt

-- | Checks if DTLS is supported. DTLS support may not be available even if TLS
-- support is available, and vice-versa.
-- 
-- /Since: 2.48/
tlsBackendSupportsDtls ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m Bool
    -- ^ __Returns:__ whether DTLS is supported
tlsBackendSupportsDtls backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_supports_dtls backend'
    let result' = (/= 0) result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendSupportsDtlsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendSupportsDtlsMethodInfo a signature where
    overloadedMethod = tlsBackendSupportsDtls

instance O.OverloadedMethodInfo TlsBackendSupportsDtlsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendSupportsDtls",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendSupportsDtls"
        })


#endif

-- method TlsBackend::supports_tls
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsBackend" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_supports_tls" g_tls_backend_supports_tls :: 
    Ptr TlsBackend ->                       -- backend : TInterface (Name {namespace = "Gio", name = "TlsBackend"})
    IO CInt

-- | Checks if TLS is supported; if this returns 'P.False' for the default
-- t'GI.Gio.Interfaces.TlsBackend.TlsBackend', it means no \"real\" TLS backend is available.
-- 
-- /Since: 2.28/
tlsBackendSupportsTls ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsBackend a) =>
    a
    -- ^ /@backend@/: the t'GI.Gio.Interfaces.TlsBackend.TlsBackend'
    -> m Bool
    -- ^ __Returns:__ whether or not TLS is supported
tlsBackendSupportsTls backend = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    result <- g_tls_backend_supports_tls backend'
    let result' = (/= 0) result
    touchManagedPtr backend
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsBackendSupportsTlsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTlsBackend a) => O.OverloadedMethod TlsBackendSupportsTlsMethodInfo a signature where
    overloadedMethod = tlsBackendSupportsTls

instance O.OverloadedMethodInfo TlsBackendSupportsTlsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsBackend.tlsBackendSupportsTls",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-TlsBackend.html#v:tlsBackendSupportsTls"
        })


#endif

-- method TlsBackend::get_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "TlsBackend" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_backend_get_default" g_tls_backend_get_default :: 
    IO (Ptr TlsBackend)

-- | Gets the default t'GI.Gio.Interfaces.TlsBackend.TlsBackend' for the system.
-- 
-- /Since: 2.28/
tlsBackendGetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m TlsBackend
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.TlsBackend.TlsBackend', which will be a
    --     dummy object if no TLS backend is available
tlsBackendGetDefault  = liftIO $ do
    result <- g_tls_backend_get_default
    checkUnexpectedReturnNULL "tlsBackendGetDefault" result
    result' <- (newObject TlsBackend) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TlsBackend = TlsBackendSignalList
type TlsBackendSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


