{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GFileEnumerator@ allows you to operate on a set of t'GI.Gio.Interfaces.File.File' objects,
-- returning a t'GI.Gio.Objects.FileInfo.FileInfo' structure for each file enumerated (e.g.
-- 'GI.Gio.Interfaces.File.fileEnumerateChildren' will return a @GFileEnumerator@ for each
-- of the children within a directory).
-- 
-- To get the next file\'s information from a @GFileEnumerator@, use
-- 'GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFile' or its asynchronous version,
-- 'GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFilesAsync'. Note that the asynchronous
-- version will return a list of t'GI.Gio.Objects.FileInfo.FileInfo' objects, whereas the
-- synchronous will only return the next file in the enumerator.
-- 
-- The ordering of returned files is unspecified for non-Unix
-- platforms; for more information, see 'GI.GLib.Structs.Dir.dirReadName'.  On Unix,
-- when operating on local files, returned files will be sorted by
-- inode number.  Effectively you can assume that the ordering of
-- returned files will be stable between successive calls (and
-- applications) assuming the directory is unchanged.
-- 
-- If your application needs a specific ordering, such as by name or
-- modification time, you will have to implement that in your
-- application code.
-- 
-- To close a @GFileEnumerator@, use 'GI.Gio.Objects.FileEnumerator.fileEnumeratorClose', or
-- its asynchronous version, 'GI.Gio.Objects.FileEnumerator.fileEnumeratorCloseAsync'. Once
-- a @GFileEnumerator@ is closed, no further actions may be performed
-- on it, and it should be freed with 'GI.GObject.Objects.Object.objectUnref'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.FileEnumerator
    ( 

-- * Exported types
    FileEnumerator(..)                      ,
    IsFileEnumerator                        ,
    toFileEnumerator                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [close]("GI.Gio.Objects.FileEnumerator#g:method:close"), [closeAsync]("GI.Gio.Objects.FileEnumerator#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.FileEnumerator#g:method:closeFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.FileEnumerator#g:method:hasPending"), [isClosed]("GI.Gio.Objects.FileEnumerator#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [iterate]("GI.Gio.Objects.FileEnumerator#g:method:iterate"), [nextFile]("GI.Gio.Objects.FileEnumerator#g:method:nextFile"), [nextFilesAsync]("GI.Gio.Objects.FileEnumerator#g:method:nextFilesAsync"), [nextFilesFinish]("GI.Gio.Objects.FileEnumerator#g:method:nextFilesFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChild]("GI.Gio.Objects.FileEnumerator#g:method:getChild"), [getContainer]("GI.Gio.Objects.FileEnumerator#g:method:getContainer"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.FileEnumerator#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFileEnumeratorMethod             ,
#endif

-- ** close #method:close#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorCloseMethodInfo           ,
#endif
    fileEnumeratorClose                     ,


-- ** closeAsync #method:closeAsync#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorCloseAsyncMethodInfo      ,
#endif
    fileEnumeratorCloseAsync                ,


-- ** closeFinish #method:closeFinish#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorCloseFinishMethodInfo     ,
#endif
    fileEnumeratorCloseFinish               ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorGetChildMethodInfo        ,
#endif
    fileEnumeratorGetChild                  ,


-- ** getContainer #method:getContainer#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorGetContainerMethodInfo    ,
#endif
    fileEnumeratorGetContainer              ,


-- ** hasPending #method:hasPending#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorHasPendingMethodInfo      ,
#endif
    fileEnumeratorHasPending                ,


-- ** isClosed #method:isClosed#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorIsClosedMethodInfo        ,
#endif
    fileEnumeratorIsClosed                  ,


-- ** iterate #method:iterate#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorIterateMethodInfo         ,
#endif
    fileEnumeratorIterate                   ,


-- ** nextFile #method:nextFile#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorNextFileMethodInfo        ,
#endif
    fileEnumeratorNextFile                  ,


-- ** nextFilesAsync #method:nextFilesAsync#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorNextFilesAsyncMethodInfo  ,
#endif
    fileEnumeratorNextFilesAsync            ,


-- ** nextFilesFinish #method:nextFilesFinish#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorNextFilesFinishMethodInfo ,
#endif
    fileEnumeratorNextFilesFinish           ,


-- ** setPending #method:setPending#

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorSetPendingMethodInfo      ,
#endif
    fileEnumeratorSetPending                ,




 -- * Properties


-- ** container #attr:container#
-- | The container that is being enumerated.

#if defined(ENABLE_OVERLOADING)
    FileEnumeratorContainerPropertyInfo     ,
#endif
    constructFileEnumeratorContainer        ,
#if defined(ENABLE_OVERLOADING)
    fileEnumeratorContainer                 ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo

#endif

-- | Memory-managed wrapper type.
newtype FileEnumerator = FileEnumerator (SP.ManagedPtr FileEnumerator)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileEnumerator where
    toManagedPtr (FileEnumerator p) = p

foreign import ccall "g_file_enumerator_get_type"
    c_g_file_enumerator_get_type :: IO B.Types.GType

instance B.Types.TypedObject FileEnumerator where
    glibType = c_g_file_enumerator_get_type

instance B.Types.GObject FileEnumerator

-- | Type class for types which can be safely cast to t'FileEnumerator', for instance with `toFileEnumerator`.
class (SP.GObject o, O.IsDescendantOf FileEnumerator o) => IsFileEnumerator o
instance (SP.GObject o, O.IsDescendantOf FileEnumerator o) => IsFileEnumerator o

instance O.HasParentTypes FileEnumerator
type instance O.ParentTypes FileEnumerator = '[GObject.Object.Object]

-- | Cast to t'FileEnumerator', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFileEnumerator :: (MIO.MonadIO m, IsFileEnumerator o) => o -> m FileEnumerator
toFileEnumerator = MIO.liftIO . B.ManagedPtr.unsafeCastTo FileEnumerator

-- | Convert t'FileEnumerator' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileEnumerator) where
    gvalueGType_ = c_g_file_enumerator_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FileEnumerator)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FileEnumerator)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FileEnumerator ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFileEnumeratorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileEnumeratorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFileEnumeratorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFileEnumeratorMethod "close" o = FileEnumeratorCloseMethodInfo
    ResolveFileEnumeratorMethod "closeAsync" o = FileEnumeratorCloseAsyncMethodInfo
    ResolveFileEnumeratorMethod "closeFinish" o = FileEnumeratorCloseFinishMethodInfo
    ResolveFileEnumeratorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFileEnumeratorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFileEnumeratorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFileEnumeratorMethod "hasPending" o = FileEnumeratorHasPendingMethodInfo
    ResolveFileEnumeratorMethod "isClosed" o = FileEnumeratorIsClosedMethodInfo
    ResolveFileEnumeratorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFileEnumeratorMethod "iterate" o = FileEnumeratorIterateMethodInfo
    ResolveFileEnumeratorMethod "nextFile" o = FileEnumeratorNextFileMethodInfo
    ResolveFileEnumeratorMethod "nextFilesAsync" o = FileEnumeratorNextFilesAsyncMethodInfo
    ResolveFileEnumeratorMethod "nextFilesFinish" o = FileEnumeratorNextFilesFinishMethodInfo
    ResolveFileEnumeratorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFileEnumeratorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFileEnumeratorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFileEnumeratorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFileEnumeratorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFileEnumeratorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFileEnumeratorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFileEnumeratorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFileEnumeratorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFileEnumeratorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFileEnumeratorMethod "getChild" o = FileEnumeratorGetChildMethodInfo
    ResolveFileEnumeratorMethod "getContainer" o = FileEnumeratorGetContainerMethodInfo
    ResolveFileEnumeratorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFileEnumeratorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFileEnumeratorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFileEnumeratorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFileEnumeratorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFileEnumeratorMethod "setPending" o = FileEnumeratorSetPendingMethodInfo
    ResolveFileEnumeratorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFileEnumeratorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileEnumeratorMethod t FileEnumerator, O.OverloadedMethod info FileEnumerator p) => OL.IsLabel t (FileEnumerator -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileEnumeratorMethod t FileEnumerator, O.OverloadedMethod info FileEnumerator p, R.HasField t FileEnumerator p) => R.HasField t FileEnumerator p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileEnumeratorMethod t FileEnumerator, O.OverloadedMethodInfo info FileEnumerator) => OL.IsLabel t (O.MethodProxy info FileEnumerator) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "container"
   -- Type: TInterface (Name {namespace = "Gio", name = "File"})
   -- Flags: [PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Construct a t'GValueConstruct' with valid value for the “@container@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileEnumeratorContainer :: (IsFileEnumerator o, MIO.MonadIO m, Gio.File.IsFile a) => a -> m (GValueConstruct o)
constructFileEnumeratorContainer val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "container" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorContainerPropertyInfo
instance AttrInfo FileEnumeratorContainerPropertyInfo where
    type AttrAllowedOps FileEnumeratorContainerPropertyInfo = '[ 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint FileEnumeratorContainerPropertyInfo = IsFileEnumerator
    type AttrSetTypeConstraint FileEnumeratorContainerPropertyInfo = Gio.File.IsFile
    type AttrTransferTypeConstraint FileEnumeratorContainerPropertyInfo = Gio.File.IsFile
    type AttrTransferType FileEnumeratorContainerPropertyInfo = Gio.File.File
    type AttrGetType FileEnumeratorContainerPropertyInfo = ()
    type AttrLabel FileEnumeratorContainerPropertyInfo = "container"
    type AttrOrigin FileEnumeratorContainerPropertyInfo = FileEnumerator
    attrGet = undefined
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.File.File v
    attrConstruct = constructFileEnumeratorContainer
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.container"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#g:attr:container"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileEnumerator
type instance O.AttributeList FileEnumerator = FileEnumeratorAttributeList
type FileEnumeratorAttributeList = ('[ '("container", FileEnumeratorContainerPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fileEnumeratorContainer :: AttrLabelProxy "container"
fileEnumeratorContainer = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FileEnumerator = FileEnumeratorSignalList
type FileEnumeratorSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FileEnumerator::close
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_file_enumerator_close" g_file_enumerator_close :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Releases all resources used by this enumerator, making the
-- enumerator return 'GI.Gio.Enums.IOErrorEnumClosed' on all calls.
-- 
-- This will be automatically called when the last reference
-- is dropped, but you might want to call this function to make
-- sure resources are released as early as possible.
fileEnumeratorClose ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileEnumeratorClose enumerator cancellable = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_file_enumerator_close enumerator' maybeCancellable
        touchManagedPtr enumerator
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorCloseMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod FileEnumeratorCloseMethodInfo a signature where
    overloadedMethod = fileEnumeratorClose

instance O.OverloadedMethodInfo FileEnumeratorCloseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorClose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorClose"
        })


#endif

-- method FileEnumerator::close_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority) of the request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_file_enumerator_close_async" g_file_enumerator_close_async :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously closes the file enumerator.
-- 
-- If /@cancellable@/ is not 'P.Nothing', then the operation can be cancelled by
-- triggering the cancellable object from another thread. If the operation
-- was cancelled, the error 'GI.Gio.Enums.IOErrorEnumCancelled' will be returned in
-- 'GI.Gio.Objects.FileEnumerator.fileEnumeratorCloseFinish'.
fileEnumeratorCloseAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> m ()
fileEnumeratorCloseAsync enumerator ioPriority cancellable callback = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_file_enumerator_close_async enumerator' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr enumerator
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorCloseAsyncMethodInfo
instance (signature ~ (Int32 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod FileEnumeratorCloseAsyncMethodInfo a signature where
    overloadedMethod = fileEnumeratorCloseAsync

instance O.OverloadedMethodInfo FileEnumeratorCloseAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorCloseAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorCloseAsync"
        })


#endif

-- method FileEnumerator::close_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_file_enumerator_close_finish" g_file_enumerator_close_finish :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes closing a file enumerator, started from 'GI.Gio.Objects.FileEnumerator.fileEnumeratorCloseAsync'.
-- 
-- If the file enumerator was already closed when 'GI.Gio.Objects.FileEnumerator.fileEnumeratorCloseAsync'
-- was called, then this function will report 'GI.Gio.Enums.IOErrorEnumClosed' in /@error@/, and
-- return 'P.False'. If the file enumerator had pending operation when the close
-- operation was started, then this function will report 'GI.Gio.Enums.IOErrorEnumPending', and
-- return 'P.False'.  If /@cancellable@/ was not 'P.Nothing', then the operation may have been
-- cancelled by triggering the cancellable object from another thread. If the operation
-- was cancelled, the error 'GI.Gio.Enums.IOErrorEnumCancelled' will be set, and 'P.False' will be
-- returned.
fileEnumeratorCloseFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileEnumeratorCloseFinish enumerator result_ = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_file_enumerator_close_finish enumerator' result_'
        touchManagedPtr enumerator
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorCloseFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileEnumerator a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod FileEnumeratorCloseFinishMethodInfo a signature where
    overloadedMethod = fileEnumeratorCloseFinish

instance O.OverloadedMethodInfo FileEnumeratorCloseFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorCloseFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorCloseFinish"
        })


#endif

-- method FileEnumerator::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GFileInfo gotten from g_file_enumerator_next_file()\n  or the async equivalents."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_enumerator_get_child" g_file_enumerator_get_child :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    Ptr Gio.FileInfo.FileInfo ->            -- info : TInterface (Name {namespace = "Gio", name = "FileInfo"})
    IO (Ptr Gio.File.File)

-- | Return a new t'GI.Gio.Interfaces.File.File' which refers to the file named by /@info@/ in the source
-- directory of /@enumerator@/.  This function is primarily intended to be used
-- inside loops with 'GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFile'.
-- 
-- To use this, 'GI.Gio.Constants.FILE_ATTRIBUTE_STANDARD_NAME' must have been listed in the
-- attributes list used when creating the t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
-- 
-- This is a convenience method that\'s equivalent to:
-- 
-- === /C code/
-- >
-- >  gchar *name = g_file_info_get_name (info);
-- >  GFile *child = g_file_get_child (g_file_enumerator_get_container (enumr),
-- >                                   name);
-- 
-- 
-- /Since: 2.36/
fileEnumeratorGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a, Gio.FileInfo.IsFileInfo b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'
    -> b
    -- ^ /@info@/: a t'GI.Gio.Objects.FileInfo.FileInfo' gotten from 'GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFile'
    --   or the async equivalents.
    -> m Gio.File.File
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File' for the t'GI.Gio.Objects.FileInfo.FileInfo' passed it.
fileEnumeratorGetChild enumerator info = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    info' <- unsafeManagedPtrCastPtr info
    result <- g_file_enumerator_get_child enumerator' info'
    checkUnexpectedReturnNULL "fileEnumeratorGetChild" result
    result' <- (wrapObject Gio.File.File) result
    touchManagedPtr enumerator
    touchManagedPtr info
    return result'

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorGetChildMethodInfo
instance (signature ~ (b -> m Gio.File.File), MonadIO m, IsFileEnumerator a, Gio.FileInfo.IsFileInfo b) => O.OverloadedMethod FileEnumeratorGetChildMethodInfo a signature where
    overloadedMethod = fileEnumeratorGetChild

instance O.OverloadedMethodInfo FileEnumeratorGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorGetChild"
        })


#endif

-- method FileEnumerator::get_container
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_enumerator_get_container" g_file_enumerator_get_container :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    IO (Ptr Gio.File.File)

-- | Get the t'GI.Gio.Interfaces.File.File' container which is being enumerated.
-- 
-- /Since: 2.18/
fileEnumeratorGetContainer ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'
    -> m Gio.File.File
    -- ^ __Returns:__ the t'GI.Gio.Interfaces.File.File' which is being enumerated.
fileEnumeratorGetContainer enumerator = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    result <- g_file_enumerator_get_container enumerator'
    checkUnexpectedReturnNULL "fileEnumeratorGetContainer" result
    result' <- (newObject Gio.File.File) result
    touchManagedPtr enumerator
    return result'

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorGetContainerMethodInfo
instance (signature ~ (m Gio.File.File), MonadIO m, IsFileEnumerator a) => O.OverloadedMethod FileEnumeratorGetContainerMethodInfo a signature where
    overloadedMethod = fileEnumeratorGetContainer

instance O.OverloadedMethodInfo FileEnumeratorGetContainerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorGetContainer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorGetContainer"
        })


#endif

-- method FileEnumerator::has_pending
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_file_enumerator_has_pending" g_file_enumerator_has_pending :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    IO CInt

-- | Checks if the file enumerator has pending operations.
fileEnumeratorHasPending ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@enumerator@/ has pending operations.
fileEnumeratorHasPending enumerator = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    result <- g_file_enumerator_has_pending enumerator'
    let result' = (/= 0) result
    touchManagedPtr enumerator
    return result'

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorHasPendingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFileEnumerator a) => O.OverloadedMethod FileEnumeratorHasPendingMethodInfo a signature where
    overloadedMethod = fileEnumeratorHasPending

instance O.OverloadedMethodInfo FileEnumeratorHasPendingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorHasPending",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorHasPending"
        })


#endif

-- method FileEnumerator::is_closed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_file_enumerator_is_closed" g_file_enumerator_is_closed :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    IO CInt

-- | Checks if the file enumerator has been closed.
fileEnumeratorIsClosed ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@enumerator@/ is closed.
fileEnumeratorIsClosed enumerator = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    result <- g_file_enumerator_is_closed enumerator'
    let result' = (/= 0) result
    touchManagedPtr enumerator
    return result'

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorIsClosedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFileEnumerator a) => O.OverloadedMethod FileEnumeratorIsClosedMethodInfo a signature where
    overloadedMethod = fileEnumeratorIsClosed

instance O.OverloadedMethodInfo FileEnumeratorIsClosedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorIsClosed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorIsClosed"
        })


#endif

-- method FileEnumerator::iterate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "direnum"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an open #GFileEnumerator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileInfo" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Output location for the next #GFileInfo, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_child"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Output location for the next #GFile, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_file_enumerator_iterate" g_file_enumerator_iterate :: 
    Ptr FileEnumerator ->                   -- direnum : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    Ptr (Ptr Gio.FileInfo.FileInfo) ->      -- out_info : TInterface (Name {namespace = "Gio", name = "FileInfo"})
    Ptr (Ptr Gio.File.File) ->              -- out_child : TInterface (Name {namespace = "Gio", name = "File"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | This is a version of 'GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFile' that\'s easier to
-- use correctly from C programs.  With 'GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFile',
-- the gboolean return value signifies \"end of iteration or error\", which
-- requires allocation of a temporary t'GError'.
-- 
-- In contrast, with this function, a 'P.False' return from
-- 'GI.Gio.Objects.FileEnumerator.fileEnumeratorIterate' *always* means
-- \"error\".  End of iteration is signaled by /@outInfo@/ or /@outChild@/ being 'P.Nothing'.
-- 
-- Another crucial difference is that the references for /@outInfo@/ and
-- /@outChild@/ are owned by /@direnum@/ (they are cached as hidden
-- properties).  You must not unref them in your own code.  This makes
-- memory management significantly easier for C code in combination
-- with loops.
-- 
-- Finally, this function optionally allows retrieving a t'GI.Gio.Interfaces.File.File' as
-- well.
-- 
-- You must specify at least one of /@outInfo@/ or /@outChild@/.
-- 
-- The code pattern for correctly using 'GI.Gio.Objects.FileEnumerator.fileEnumeratorIterate' from C
-- is:
-- 
-- 
-- 	
-- >
-- >direnum = g_file_enumerate_children (file, ...);
-- >while (TRUE)
-- >  {
-- >    GFileInfo *info;
-- >    if (!g_file_enumerator_iterate (direnum, &info, NULL, cancellable, error))
-- >      goto out;
-- >    if (!info)
-- >      break;
-- >    ... do stuff with "info"; do not unref it! ...
-- >  }
-- >
-- >out:
-- >  g_object_unref (direnum); // Note: frees the last @info
-- 
-- 
-- /Since: 2.44/
fileEnumeratorIterate ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@direnum@/: an open t'GI.Gio.Objects.FileEnumerator.FileEnumerator'
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable'
    -> m ((Gio.FileInfo.FileInfo, Gio.File.File))
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileEnumeratorIterate direnum cancellable = liftIO $ do
    direnum' <- unsafeManagedPtrCastPtr direnum
    outInfo <- callocMem :: IO (Ptr (Ptr Gio.FileInfo.FileInfo))
    outChild <- callocMem :: IO (Ptr (Ptr Gio.File.File))
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_file_enumerator_iterate direnum' outInfo outChild maybeCancellable
        outInfo' <- peek outInfo
        outInfo'' <- (newObject Gio.FileInfo.FileInfo) outInfo'
        outChild' <- peek outChild
        outChild'' <- (newObject Gio.File.File) outChild'
        touchManagedPtr direnum
        whenJust cancellable touchManagedPtr
        freeMem outInfo
        freeMem outChild
        return (outInfo'', outChild'')
     ) (do
        freeMem outInfo
        freeMem outChild
     )

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorIterateMethodInfo
instance (signature ~ (Maybe (b) -> m ((Gio.FileInfo.FileInfo, Gio.File.File))), MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod FileEnumeratorIterateMethodInfo a signature where
    overloadedMethod = fileEnumeratorIterate

instance O.OverloadedMethodInfo FileEnumeratorIterateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorIterate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorIterate"
        })


#endif

-- method FileEnumerator::next_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "FileInfo" })
-- throws : True
-- Skip return : False

foreign import ccall "g_file_enumerator_next_file" g_file_enumerator_next_file :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.FileInfo.FileInfo)

-- | Returns information for the next file in the enumerated object.
-- Will block until the information is available. The t'GI.Gio.Objects.FileInfo.FileInfo'
-- returned from this function will contain attributes that match the
-- attribute string that was passed when the t'GI.Gio.Objects.FileEnumerator.FileEnumerator' was created.
-- 
-- See the documentation of t'GI.Gio.Objects.FileEnumerator.FileEnumerator' for information about the
-- order of returned files.
-- 
-- On error, returns 'P.Nothing' and sets /@error@/ to the error. If the
-- enumerator is at the end, 'P.Nothing' will be returned and /@error@/ will
-- be unset.
fileEnumeratorNextFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m (Maybe Gio.FileInfo.FileInfo)
    -- ^ __Returns:__ A t'GI.Gio.Objects.FileInfo.FileInfo' or 'P.Nothing' on error
    --    or end of enumerator.  Free the returned object with
    --    'GI.GObject.Objects.Object.objectUnref' when no longer needed. /(Can throw 'Data.GI.Base.GError.GError')/
fileEnumeratorNextFile enumerator cancellable = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_file_enumerator_next_file enumerator' maybeCancellable
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject Gio.FileInfo.FileInfo) result'
            return result''
        touchManagedPtr enumerator
        whenJust cancellable touchManagedPtr
        return maybeResult
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorNextFileMethodInfo
instance (signature ~ (Maybe (b) -> m (Maybe Gio.FileInfo.FileInfo)), MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod FileEnumeratorNextFileMethodInfo a signature where
    overloadedMethod = fileEnumeratorNextFile

instance O.OverloadedMethodInfo FileEnumeratorNextFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorNextFile"
        })


#endif

-- method FileEnumerator::next_files_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "num_files"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of file info objects to request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority) of the request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_file_enumerator_next_files_async" g_file_enumerator_next_files_async :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    Int32 ->                                -- num_files : TBasicType TInt
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Request information for a number of files from the enumerator asynchronously.
-- When all I\/O for the operation is finished the /@callback@/ will be called with
-- the requested information.
-- 
-- See the documentation of t'GI.Gio.Objects.FileEnumerator.FileEnumerator' for information about the
-- order of returned files.
-- 
-- Once the end of the enumerator is reached, or if an error occurs, the
-- /@callback@/ will be called with an empty list. In this case, the previous call
-- to 'GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFilesAsync' will typically have returned fewer
-- than /@numFiles@/ items.
-- 
-- If a request is cancelled the callback will be called with
-- 'GI.Gio.Enums.IOErrorEnumCancelled'.
-- 
-- This leads to the following pseudo-code usage:
-- 
-- 	
-- >
-- >g_autoptr(GFile) dir = get_directory ();
-- >g_autoptr(GFileEnumerator) enumerator = NULL;
-- >g_autolist(GFileInfo) files = NULL;
-- >g_autoptr(GError) local_error = NULL;
-- >
-- >enumerator = yield g_file_enumerate_children_async (dir,
-- >                                                    G_FILE_ATTRIBUTE_STANDARD_NAME ","
-- >                                                    G_FILE_ATTRIBUTE_STANDARD_TYPE,
-- >                                                    G_FILE_QUERY_INFO_NONE,
-- >                                                    G_PRIORITY_DEFAULT,
-- >                                                    cancellable,
-- >                                                    …,
-- >                                                    &local_error);
-- >if (enumerator == NULL)
-- >  g_error ("Error enumerating: %s", local_error->message);
-- >
-- >// Loop until no files are returned, either because the end of the enumerator
-- >// has been reached, or an error was returned.
-- >do
-- >  {
-- >    files = yield g_file_enumerator_next_files_async (enumerator,
-- >                                                      5,  // number of files to request
-- >                                                      G_PRIORITY_DEFAULT,
-- >                                                      cancellable,
-- >                                                      …,
-- >                                                      &local_error);
-- >
-- >    // Process the returned files, but don’t assume that exactly 5 were returned.
-- >    for (GList *l = files; l != NULL; l = l->next)
-- >      {
-- >        GFileInfo *info = l->data;
-- >        handle_file_info (info);
-- >      }
-- >  }
-- >while (files != NULL);
-- >
-- >if (local_error != NULL &&
-- >    !g_error_matches (local_error, G_IO_ERROR, G_IO_ERROR_CANCELLED))
-- >  g_error ("Error while enumerating: %s", local_error->message);
-- 
-- 
-- During an async request no other sync and async calls are allowed, and will
-- result in 'GI.Gio.Enums.IOErrorEnumPending' errors.
-- 
-- Any outstanding I\/O request with higher priority (lower numerical value) will
-- be executed before an outstanding request with lower priority. Default
-- priority is 'GI.GLib.Constants.PRIORITY_DEFAULT'.
fileEnumeratorNextFilesAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> Int32
    -- ^ /@numFiles@/: the number of file info objects to request
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> m ()
fileEnumeratorNextFilesAsync enumerator numFiles ioPriority cancellable callback = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_file_enumerator_next_files_async enumerator' numFiles ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr enumerator
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorNextFilesAsyncMethodInfo
instance (signature ~ (Int32 -> Int32 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsFileEnumerator a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod FileEnumeratorNextFilesAsyncMethodInfo a signature where
    overloadedMethod = fileEnumeratorNextFilesAsync

instance O.OverloadedMethodInfo FileEnumeratorNextFilesAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFilesAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorNextFilesAsync"
        })


#endif

-- method FileEnumerator::next_files_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gio" , name = "FileInfo" }))
-- throws : True
-- Skip return : False

foreign import ccall "g_file_enumerator_next_files_finish" g_file_enumerator_next_files_finish :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr (GList (Ptr Gio.FileInfo.FileInfo)))

-- | Finishes the asynchronous operation started with 'GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFilesAsync'.
fileEnumeratorNextFilesFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m [Gio.FileInfo.FileInfo]
    -- ^ __Returns:__ a t'GI.GLib.Structs.List.List' of @/GFileInfos/@. You must free the list with
    --     @/g_list_free()/@ and unref the infos with 'GI.GObject.Objects.Object.objectUnref' when you\'re
    --     done with them. /(Can throw 'Data.GI.Base.GError.GError')/
fileEnumeratorNextFilesFinish enumerator result_ = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_file_enumerator_next_files_finish enumerator' result_'
        result' <- unpackGList result
        result'' <- mapM (wrapObject Gio.FileInfo.FileInfo) result'
        g_list_free result
        touchManagedPtr enumerator
        touchManagedPtr result_
        return result''
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorNextFilesFinishMethodInfo
instance (signature ~ (b -> m [Gio.FileInfo.FileInfo]), MonadIO m, IsFileEnumerator a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod FileEnumeratorNextFilesFinishMethodInfo a signature where
    overloadedMethod = fileEnumeratorNextFilesFinish

instance O.OverloadedMethodInfo FileEnumeratorNextFilesFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorNextFilesFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorNextFilesFinish"
        })


#endif

-- method FileEnumerator::set_pending
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileEnumerator."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pending"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a boolean value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_file_enumerator_set_pending" g_file_enumerator_set_pending :: 
    Ptr FileEnumerator ->                   -- enumerator : TInterface (Name {namespace = "Gio", name = "FileEnumerator"})
    CInt ->                                 -- pending : TBasicType TBoolean
    IO ()

-- | Sets the file enumerator as having pending operations.
fileEnumeratorSetPending ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileEnumerator a) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.FileEnumerator.FileEnumerator'.
    -> Bool
    -- ^ /@pending@/: a boolean value.
    -> m ()
fileEnumeratorSetPending enumerator pending = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    let pending' = (P.fromIntegral . P.fromEnum) pending
    g_file_enumerator_set_pending enumerator' pending'
    touchManagedPtr enumerator
    return ()

#if defined(ENABLE_OVERLOADING)
data FileEnumeratorSetPendingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFileEnumerator a) => O.OverloadedMethod FileEnumeratorSetPendingMethodInfo a signature where
    overloadedMethod = fileEnumeratorSetPending

instance O.OverloadedMethodInfo FileEnumeratorSetPendingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileEnumerator.fileEnumeratorSetPending",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileEnumerator.html#v:fileEnumeratorSetPending"
        })


#endif


