{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GVolumeMonitor@ is for listing the user interesting devices and volumes
-- on the computer. In other words, what a file selector or file manager
-- would show in a sidebar.
-- 
-- @GVolumeMonitor@ is not
-- thread-default-context aware (see
-- 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault'), and so should not be used
-- other than from the main thread, with no thread-default-context active.
-- 
-- In order to receive updates about volumes and mounts monitored through GVFS,
-- a main loop must be running.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.VolumeMonitor
    ( 

-- * Exported types
    VolumeMonitor(..)                       ,
    IsVolumeMonitor                         ,
    toVolumeMonitor                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getConnectedDrives]("GI.Gio.Objects.VolumeMonitor#g:method:getConnectedDrives"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getMountForUuid]("GI.Gio.Objects.VolumeMonitor#g:method:getMountForUuid"), [getMounts]("GI.Gio.Objects.VolumeMonitor#g:method:getMounts"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getVolumeForUuid]("GI.Gio.Objects.VolumeMonitor#g:method:getVolumeForUuid"), [getVolumes]("GI.Gio.Objects.VolumeMonitor#g:method:getVolumes").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveVolumeMonitorMethod              ,
#endif

-- ** adoptOrphanMount #method:adoptOrphanMount#

    volumeMonitorAdoptOrphanMount           ,


-- ** get #method:get#

    volumeMonitorGet                        ,


-- ** getConnectedDrives #method:getConnectedDrives#

#if defined(ENABLE_OVERLOADING)
    VolumeMonitorGetConnectedDrivesMethodInfo,
#endif
    volumeMonitorGetConnectedDrives         ,


-- ** getMountForUuid #method:getMountForUuid#

#if defined(ENABLE_OVERLOADING)
    VolumeMonitorGetMountForUuidMethodInfo  ,
#endif
    volumeMonitorGetMountForUuid            ,


-- ** getMounts #method:getMounts#

#if defined(ENABLE_OVERLOADING)
    VolumeMonitorGetMountsMethodInfo        ,
#endif
    volumeMonitorGetMounts                  ,


-- ** getVolumeForUuid #method:getVolumeForUuid#

#if defined(ENABLE_OVERLOADING)
    VolumeMonitorGetVolumeForUuidMethodInfo ,
#endif
    volumeMonitorGetVolumeForUuid           ,


-- ** getVolumes #method:getVolumes#

#if defined(ENABLE_OVERLOADING)
    VolumeMonitorGetVolumesMethodInfo       ,
#endif
    volumeMonitorGetVolumes                 ,




 -- * Signals


-- ** driveChanged #signal:driveChanged#

    VolumeMonitorDriveChangedCallback       ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorDriveChangedSignalInfo     ,
#endif
    afterVolumeMonitorDriveChanged          ,
    onVolumeMonitorDriveChanged             ,


-- ** driveConnected #signal:driveConnected#

    VolumeMonitorDriveConnectedCallback     ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorDriveConnectedSignalInfo   ,
#endif
    afterVolumeMonitorDriveConnected        ,
    onVolumeMonitorDriveConnected           ,


-- ** driveDisconnected #signal:driveDisconnected#

    VolumeMonitorDriveDisconnectedCallback  ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorDriveDisconnectedSignalInfo,
#endif
    afterVolumeMonitorDriveDisconnected     ,
    onVolumeMonitorDriveDisconnected        ,


-- ** driveEjectButton #signal:driveEjectButton#

    VolumeMonitorDriveEjectButtonCallback   ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorDriveEjectButtonSignalInfo ,
#endif
    afterVolumeMonitorDriveEjectButton      ,
    onVolumeMonitorDriveEjectButton         ,


-- ** driveStopButton #signal:driveStopButton#

    VolumeMonitorDriveStopButtonCallback    ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorDriveStopButtonSignalInfo  ,
#endif
    afterVolumeMonitorDriveStopButton       ,
    onVolumeMonitorDriveStopButton          ,


-- ** mountAdded #signal:mountAdded#

    VolumeMonitorMountAddedCallback         ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorMountAddedSignalInfo       ,
#endif
    afterVolumeMonitorMountAdded            ,
    onVolumeMonitorMountAdded               ,


-- ** mountChanged #signal:mountChanged#

    VolumeMonitorMountChangedCallback       ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorMountChangedSignalInfo     ,
#endif
    afterVolumeMonitorMountChanged          ,
    onVolumeMonitorMountChanged             ,


-- ** mountPreUnmount #signal:mountPreUnmount#

    VolumeMonitorMountPreUnmountCallback    ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorMountPreUnmountSignalInfo  ,
#endif
    afterVolumeMonitorMountPreUnmount       ,
    onVolumeMonitorMountPreUnmount          ,


-- ** mountRemoved #signal:mountRemoved#

    VolumeMonitorMountRemovedCallback       ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorMountRemovedSignalInfo     ,
#endif
    afterVolumeMonitorMountRemoved          ,
    onVolumeMonitorMountRemoved             ,


-- ** volumeAdded #signal:volumeAdded#

    VolumeMonitorVolumeAddedCallback        ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorVolumeAddedSignalInfo      ,
#endif
    afterVolumeMonitorVolumeAdded           ,
    onVolumeMonitorVolumeAdded              ,


-- ** volumeChanged #signal:volumeChanged#

    VolumeMonitorVolumeChangedCallback      ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorVolumeChangedSignalInfo    ,
#endif
    afterVolumeMonitorVolumeChanged         ,
    onVolumeMonitorVolumeChanged            ,


-- ** volumeRemoved #signal:volumeRemoved#

    VolumeMonitorVolumeRemovedCallback      ,
#if defined(ENABLE_OVERLOADING)
    VolumeMonitorVolumeRemovedSignalInfo    ,
#endif
    afterVolumeMonitorVolumeRemoved         ,
    onVolumeMonitorVolumeRemoved            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume

#endif

-- | Memory-managed wrapper type.
newtype VolumeMonitor = VolumeMonitor (SP.ManagedPtr VolumeMonitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype VolumeMonitor where
    toManagedPtr (VolumeMonitor p) = p

foreign import ccall "g_volume_monitor_get_type"
    c_g_volume_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject VolumeMonitor where
    glibType = c_g_volume_monitor_get_type

instance B.Types.GObject VolumeMonitor

-- | Type class for types which can be safely cast to t'VolumeMonitor', for instance with `toVolumeMonitor`.
class (SP.GObject o, O.IsDescendantOf VolumeMonitor o) => IsVolumeMonitor o
instance (SP.GObject o, O.IsDescendantOf VolumeMonitor o) => IsVolumeMonitor o

instance O.HasParentTypes VolumeMonitor
type instance O.ParentTypes VolumeMonitor = '[GObject.Object.Object]

-- | Cast to t'VolumeMonitor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toVolumeMonitor :: (MIO.MonadIO m, IsVolumeMonitor o) => o -> m VolumeMonitor
toVolumeMonitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo VolumeMonitor

-- | Convert t'VolumeMonitor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe VolumeMonitor) where
    gvalueGType_ = c_g_volume_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr VolumeMonitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr VolumeMonitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject VolumeMonitor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveVolumeMonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveVolumeMonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveVolumeMonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveVolumeMonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveVolumeMonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveVolumeMonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveVolumeMonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveVolumeMonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveVolumeMonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveVolumeMonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveVolumeMonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveVolumeMonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveVolumeMonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveVolumeMonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveVolumeMonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveVolumeMonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveVolumeMonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveVolumeMonitorMethod "getConnectedDrives" o = VolumeMonitorGetConnectedDrivesMethodInfo
    ResolveVolumeMonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveVolumeMonitorMethod "getMountForUuid" o = VolumeMonitorGetMountForUuidMethodInfo
    ResolveVolumeMonitorMethod "getMounts" o = VolumeMonitorGetMountsMethodInfo
    ResolveVolumeMonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveVolumeMonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveVolumeMonitorMethod "getVolumeForUuid" o = VolumeMonitorGetVolumeForUuidMethodInfo
    ResolveVolumeMonitorMethod "getVolumes" o = VolumeMonitorGetVolumesMethodInfo
    ResolveVolumeMonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveVolumeMonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveVolumeMonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveVolumeMonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVolumeMonitorMethod t VolumeMonitor, O.OverloadedMethod info VolumeMonitor p) => OL.IsLabel t (VolumeMonitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveVolumeMonitorMethod t VolumeMonitor, O.OverloadedMethod info VolumeMonitor p, R.HasField t VolumeMonitor p) => R.HasField t VolumeMonitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveVolumeMonitorMethod t VolumeMonitor, O.OverloadedMethodInfo info VolumeMonitor) => OL.IsLabel t (O.MethodProxy info VolumeMonitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal VolumeMonitor::drive-changed
-- | Emitted when a drive changes.
type VolumeMonitorDriveChangedCallback =
    Gio.Drive.Drive
    -- ^ /@drive@/: the drive that changed
    -> IO ()

type C_VolumeMonitorDriveChangedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Drive.Drive ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorDriveChangedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorDriveChangedCallback :: C_VolumeMonitorDriveChangedCallback -> IO (FunPtr C_VolumeMonitorDriveChangedCallback)

wrap_VolumeMonitorDriveChangedCallback :: 
    GObject a => (a -> VolumeMonitorDriveChangedCallback) ->
    C_VolumeMonitorDriveChangedCallback
wrap_VolumeMonitorDriveChangedCallback gi'cb gi'selfPtr drive _ = do
    drive' <- (newObject Gio.Drive.Drive) drive
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drive'


-- | Connect a signal handler for the [driveChanged](#signal:driveChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #driveChanged callback
-- @
-- 
-- 
onVolumeMonitorDriveChanged :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveChangedCallback) -> m SignalHandlerId
onVolumeMonitorDriveChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveChangedCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveChangedCallback wrapped'
    connectSignalFunPtr obj "drive-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [driveChanged](#signal:driveChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #driveChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorDriveChanged :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveChangedCallback) -> m SignalHandlerId
afterVolumeMonitorDriveChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveChangedCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveChangedCallback wrapped'
    connectSignalFunPtr obj "drive-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorDriveChangedSignalInfo
instance SignalInfo VolumeMonitorDriveChangedSignalInfo where
    type HaskellCallbackType VolumeMonitorDriveChangedSignalInfo = VolumeMonitorDriveChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorDriveChangedCallback cb
        cb'' <- mk_VolumeMonitorDriveChangedCallback cb'
        connectSignalFunPtr obj "drive-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::drive-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:driveChanged"})

#endif

-- signal VolumeMonitor::drive-connected
-- | Emitted when a drive is connected to the system.
type VolumeMonitorDriveConnectedCallback =
    Gio.Drive.Drive
    -- ^ /@drive@/: a t'GI.Gio.Interfaces.Drive.Drive' that was connected.
    -> IO ()

type C_VolumeMonitorDriveConnectedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Drive.Drive ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorDriveConnectedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorDriveConnectedCallback :: C_VolumeMonitorDriveConnectedCallback -> IO (FunPtr C_VolumeMonitorDriveConnectedCallback)

wrap_VolumeMonitorDriveConnectedCallback :: 
    GObject a => (a -> VolumeMonitorDriveConnectedCallback) ->
    C_VolumeMonitorDriveConnectedCallback
wrap_VolumeMonitorDriveConnectedCallback gi'cb gi'selfPtr drive _ = do
    drive' <- (newObject Gio.Drive.Drive) drive
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drive'


-- | Connect a signal handler for the [driveConnected](#signal:driveConnected) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #driveConnected callback
-- @
-- 
-- 
onVolumeMonitorDriveConnected :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveConnectedCallback) -> m SignalHandlerId
onVolumeMonitorDriveConnected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveConnectedCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveConnectedCallback wrapped'
    connectSignalFunPtr obj "drive-connected" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [driveConnected](#signal:driveConnected) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #driveConnected callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorDriveConnected :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveConnectedCallback) -> m SignalHandlerId
afterVolumeMonitorDriveConnected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveConnectedCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveConnectedCallback wrapped'
    connectSignalFunPtr obj "drive-connected" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorDriveConnectedSignalInfo
instance SignalInfo VolumeMonitorDriveConnectedSignalInfo where
    type HaskellCallbackType VolumeMonitorDriveConnectedSignalInfo = VolumeMonitorDriveConnectedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorDriveConnectedCallback cb
        cb'' <- mk_VolumeMonitorDriveConnectedCallback cb'
        connectSignalFunPtr obj "drive-connected" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::drive-connected"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:driveConnected"})

#endif

-- signal VolumeMonitor::drive-disconnected
-- | Emitted when a drive is disconnected from the system.
type VolumeMonitorDriveDisconnectedCallback =
    Gio.Drive.Drive
    -- ^ /@drive@/: a t'GI.Gio.Interfaces.Drive.Drive' that was disconnected.
    -> IO ()

type C_VolumeMonitorDriveDisconnectedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Drive.Drive ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorDriveDisconnectedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorDriveDisconnectedCallback :: C_VolumeMonitorDriveDisconnectedCallback -> IO (FunPtr C_VolumeMonitorDriveDisconnectedCallback)

wrap_VolumeMonitorDriveDisconnectedCallback :: 
    GObject a => (a -> VolumeMonitorDriveDisconnectedCallback) ->
    C_VolumeMonitorDriveDisconnectedCallback
wrap_VolumeMonitorDriveDisconnectedCallback gi'cb gi'selfPtr drive _ = do
    drive' <- (newObject Gio.Drive.Drive) drive
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drive'


-- | Connect a signal handler for the [driveDisconnected](#signal:driveDisconnected) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #driveDisconnected callback
-- @
-- 
-- 
onVolumeMonitorDriveDisconnected :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveDisconnectedCallback) -> m SignalHandlerId
onVolumeMonitorDriveDisconnected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveDisconnectedCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveDisconnectedCallback wrapped'
    connectSignalFunPtr obj "drive-disconnected" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [driveDisconnected](#signal:driveDisconnected) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #driveDisconnected callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorDriveDisconnected :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveDisconnectedCallback) -> m SignalHandlerId
afterVolumeMonitorDriveDisconnected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveDisconnectedCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveDisconnectedCallback wrapped'
    connectSignalFunPtr obj "drive-disconnected" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorDriveDisconnectedSignalInfo
instance SignalInfo VolumeMonitorDriveDisconnectedSignalInfo where
    type HaskellCallbackType VolumeMonitorDriveDisconnectedSignalInfo = VolumeMonitorDriveDisconnectedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorDriveDisconnectedCallback cb
        cb'' <- mk_VolumeMonitorDriveDisconnectedCallback cb'
        connectSignalFunPtr obj "drive-disconnected" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::drive-disconnected"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:driveDisconnected"})

#endif

-- signal VolumeMonitor::drive-eject-button
-- | Emitted when the eject button is pressed on /@drive@/.
-- 
-- /Since: 2.18/
type VolumeMonitorDriveEjectButtonCallback =
    Gio.Drive.Drive
    -- ^ /@drive@/: the drive where the eject button was pressed
    -> IO ()

type C_VolumeMonitorDriveEjectButtonCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Drive.Drive ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorDriveEjectButtonCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorDriveEjectButtonCallback :: C_VolumeMonitorDriveEjectButtonCallback -> IO (FunPtr C_VolumeMonitorDriveEjectButtonCallback)

wrap_VolumeMonitorDriveEjectButtonCallback :: 
    GObject a => (a -> VolumeMonitorDriveEjectButtonCallback) ->
    C_VolumeMonitorDriveEjectButtonCallback
wrap_VolumeMonitorDriveEjectButtonCallback gi'cb gi'selfPtr drive _ = do
    drive' <- (newObject Gio.Drive.Drive) drive
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drive'


-- | Connect a signal handler for the [driveEjectButton](#signal:driveEjectButton) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #driveEjectButton callback
-- @
-- 
-- 
onVolumeMonitorDriveEjectButton :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveEjectButtonCallback) -> m SignalHandlerId
onVolumeMonitorDriveEjectButton obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveEjectButtonCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveEjectButtonCallback wrapped'
    connectSignalFunPtr obj "drive-eject-button" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [driveEjectButton](#signal:driveEjectButton) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #driveEjectButton callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorDriveEjectButton :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveEjectButtonCallback) -> m SignalHandlerId
afterVolumeMonitorDriveEjectButton obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveEjectButtonCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveEjectButtonCallback wrapped'
    connectSignalFunPtr obj "drive-eject-button" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorDriveEjectButtonSignalInfo
instance SignalInfo VolumeMonitorDriveEjectButtonSignalInfo where
    type HaskellCallbackType VolumeMonitorDriveEjectButtonSignalInfo = VolumeMonitorDriveEjectButtonCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorDriveEjectButtonCallback cb
        cb'' <- mk_VolumeMonitorDriveEjectButtonCallback cb'
        connectSignalFunPtr obj "drive-eject-button" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::drive-eject-button"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:driveEjectButton"})

#endif

-- signal VolumeMonitor::drive-stop-button
-- | Emitted when the stop button is pressed on /@drive@/.
-- 
-- /Since: 2.22/
type VolumeMonitorDriveStopButtonCallback =
    Gio.Drive.Drive
    -- ^ /@drive@/: the drive where the stop button was pressed
    -> IO ()

type C_VolumeMonitorDriveStopButtonCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Drive.Drive ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorDriveStopButtonCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorDriveStopButtonCallback :: C_VolumeMonitorDriveStopButtonCallback -> IO (FunPtr C_VolumeMonitorDriveStopButtonCallback)

wrap_VolumeMonitorDriveStopButtonCallback :: 
    GObject a => (a -> VolumeMonitorDriveStopButtonCallback) ->
    C_VolumeMonitorDriveStopButtonCallback
wrap_VolumeMonitorDriveStopButtonCallback gi'cb gi'selfPtr drive _ = do
    drive' <- (newObject Gio.Drive.Drive) drive
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drive'


-- | Connect a signal handler for the [driveStopButton](#signal:driveStopButton) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #driveStopButton callback
-- @
-- 
-- 
onVolumeMonitorDriveStopButton :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveStopButtonCallback) -> m SignalHandlerId
onVolumeMonitorDriveStopButton obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveStopButtonCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveStopButtonCallback wrapped'
    connectSignalFunPtr obj "drive-stop-button" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [driveStopButton](#signal:driveStopButton) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #driveStopButton callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorDriveStopButton :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorDriveStopButtonCallback) -> m SignalHandlerId
afterVolumeMonitorDriveStopButton obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorDriveStopButtonCallback wrapped
    wrapped'' <- mk_VolumeMonitorDriveStopButtonCallback wrapped'
    connectSignalFunPtr obj "drive-stop-button" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorDriveStopButtonSignalInfo
instance SignalInfo VolumeMonitorDriveStopButtonSignalInfo where
    type HaskellCallbackType VolumeMonitorDriveStopButtonSignalInfo = VolumeMonitorDriveStopButtonCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorDriveStopButtonCallback cb
        cb'' <- mk_VolumeMonitorDriveStopButtonCallback cb'
        connectSignalFunPtr obj "drive-stop-button" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::drive-stop-button"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:driveStopButton"})

#endif

-- signal VolumeMonitor::mount-added
-- | Emitted when a mount is added.
type VolumeMonitorMountAddedCallback =
    Gio.Mount.Mount
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount' that was added.
    -> IO ()

type C_VolumeMonitorMountAddedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Mount.Mount ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorMountAddedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorMountAddedCallback :: C_VolumeMonitorMountAddedCallback -> IO (FunPtr C_VolumeMonitorMountAddedCallback)

wrap_VolumeMonitorMountAddedCallback :: 
    GObject a => (a -> VolumeMonitorMountAddedCallback) ->
    C_VolumeMonitorMountAddedCallback
wrap_VolumeMonitorMountAddedCallback gi'cb gi'selfPtr mount _ = do
    mount' <- (newObject Gio.Mount.Mount) mount
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  mount'


-- | Connect a signal handler for the [mountAdded](#signal:mountAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #mountAdded callback
-- @
-- 
-- 
onVolumeMonitorMountAdded :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorMountAddedCallback) -> m SignalHandlerId
onVolumeMonitorMountAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorMountAddedCallback wrapped
    wrapped'' <- mk_VolumeMonitorMountAddedCallback wrapped'
    connectSignalFunPtr obj "mount-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [mountAdded](#signal:mountAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #mountAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorMountAdded :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorMountAddedCallback) -> m SignalHandlerId
afterVolumeMonitorMountAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorMountAddedCallback wrapped
    wrapped'' <- mk_VolumeMonitorMountAddedCallback wrapped'
    connectSignalFunPtr obj "mount-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorMountAddedSignalInfo
instance SignalInfo VolumeMonitorMountAddedSignalInfo where
    type HaskellCallbackType VolumeMonitorMountAddedSignalInfo = VolumeMonitorMountAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorMountAddedCallback cb
        cb'' <- mk_VolumeMonitorMountAddedCallback cb'
        connectSignalFunPtr obj "mount-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::mount-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:mountAdded"})

#endif

-- signal VolumeMonitor::mount-changed
-- | Emitted when a mount changes.
type VolumeMonitorMountChangedCallback =
    Gio.Mount.Mount
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount' that changed.
    -> IO ()

type C_VolumeMonitorMountChangedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Mount.Mount ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorMountChangedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorMountChangedCallback :: C_VolumeMonitorMountChangedCallback -> IO (FunPtr C_VolumeMonitorMountChangedCallback)

wrap_VolumeMonitorMountChangedCallback :: 
    GObject a => (a -> VolumeMonitorMountChangedCallback) ->
    C_VolumeMonitorMountChangedCallback
wrap_VolumeMonitorMountChangedCallback gi'cb gi'selfPtr mount _ = do
    mount' <- (newObject Gio.Mount.Mount) mount
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  mount'


-- | Connect a signal handler for the [mountChanged](#signal:mountChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #mountChanged callback
-- @
-- 
-- 
onVolumeMonitorMountChanged :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorMountChangedCallback) -> m SignalHandlerId
onVolumeMonitorMountChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorMountChangedCallback wrapped
    wrapped'' <- mk_VolumeMonitorMountChangedCallback wrapped'
    connectSignalFunPtr obj "mount-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [mountChanged](#signal:mountChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #mountChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorMountChanged :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorMountChangedCallback) -> m SignalHandlerId
afterVolumeMonitorMountChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorMountChangedCallback wrapped
    wrapped'' <- mk_VolumeMonitorMountChangedCallback wrapped'
    connectSignalFunPtr obj "mount-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorMountChangedSignalInfo
instance SignalInfo VolumeMonitorMountChangedSignalInfo where
    type HaskellCallbackType VolumeMonitorMountChangedSignalInfo = VolumeMonitorMountChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorMountChangedCallback cb
        cb'' <- mk_VolumeMonitorMountChangedCallback cb'
        connectSignalFunPtr obj "mount-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::mount-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:mountChanged"})

#endif

-- signal VolumeMonitor::mount-pre-unmount
-- | May be emitted when a mount is about to be removed.
-- 
-- This signal depends on the backend and is only emitted if
-- GIO was used to unmount.
type VolumeMonitorMountPreUnmountCallback =
    Gio.Mount.Mount
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount' that is being unmounted.
    -> IO ()

type C_VolumeMonitorMountPreUnmountCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Mount.Mount ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorMountPreUnmountCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorMountPreUnmountCallback :: C_VolumeMonitorMountPreUnmountCallback -> IO (FunPtr C_VolumeMonitorMountPreUnmountCallback)

wrap_VolumeMonitorMountPreUnmountCallback :: 
    GObject a => (a -> VolumeMonitorMountPreUnmountCallback) ->
    C_VolumeMonitorMountPreUnmountCallback
wrap_VolumeMonitorMountPreUnmountCallback gi'cb gi'selfPtr mount _ = do
    mount' <- (newObject Gio.Mount.Mount) mount
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  mount'


-- | Connect a signal handler for the [mountPreUnmount](#signal:mountPreUnmount) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #mountPreUnmount callback
-- @
-- 
-- 
onVolumeMonitorMountPreUnmount :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorMountPreUnmountCallback) -> m SignalHandlerId
onVolumeMonitorMountPreUnmount obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorMountPreUnmountCallback wrapped
    wrapped'' <- mk_VolumeMonitorMountPreUnmountCallback wrapped'
    connectSignalFunPtr obj "mount-pre-unmount" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [mountPreUnmount](#signal:mountPreUnmount) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #mountPreUnmount callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorMountPreUnmount :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorMountPreUnmountCallback) -> m SignalHandlerId
afterVolumeMonitorMountPreUnmount obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorMountPreUnmountCallback wrapped
    wrapped'' <- mk_VolumeMonitorMountPreUnmountCallback wrapped'
    connectSignalFunPtr obj "mount-pre-unmount" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorMountPreUnmountSignalInfo
instance SignalInfo VolumeMonitorMountPreUnmountSignalInfo where
    type HaskellCallbackType VolumeMonitorMountPreUnmountSignalInfo = VolumeMonitorMountPreUnmountCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorMountPreUnmountCallback cb
        cb'' <- mk_VolumeMonitorMountPreUnmountCallback cb'
        connectSignalFunPtr obj "mount-pre-unmount" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::mount-pre-unmount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:mountPreUnmount"})

#endif

-- signal VolumeMonitor::mount-removed
-- | Emitted when a mount is removed.
type VolumeMonitorMountRemovedCallback =
    Gio.Mount.Mount
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount' that was removed.
    -> IO ()

type C_VolumeMonitorMountRemovedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Mount.Mount ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorMountRemovedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorMountRemovedCallback :: C_VolumeMonitorMountRemovedCallback -> IO (FunPtr C_VolumeMonitorMountRemovedCallback)

wrap_VolumeMonitorMountRemovedCallback :: 
    GObject a => (a -> VolumeMonitorMountRemovedCallback) ->
    C_VolumeMonitorMountRemovedCallback
wrap_VolumeMonitorMountRemovedCallback gi'cb gi'selfPtr mount _ = do
    mount' <- (newObject Gio.Mount.Mount) mount
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  mount'


-- | Connect a signal handler for the [mountRemoved](#signal:mountRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #mountRemoved callback
-- @
-- 
-- 
onVolumeMonitorMountRemoved :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorMountRemovedCallback) -> m SignalHandlerId
onVolumeMonitorMountRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorMountRemovedCallback wrapped
    wrapped'' <- mk_VolumeMonitorMountRemovedCallback wrapped'
    connectSignalFunPtr obj "mount-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [mountRemoved](#signal:mountRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #mountRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorMountRemoved :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorMountRemovedCallback) -> m SignalHandlerId
afterVolumeMonitorMountRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorMountRemovedCallback wrapped
    wrapped'' <- mk_VolumeMonitorMountRemovedCallback wrapped'
    connectSignalFunPtr obj "mount-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorMountRemovedSignalInfo
instance SignalInfo VolumeMonitorMountRemovedSignalInfo where
    type HaskellCallbackType VolumeMonitorMountRemovedSignalInfo = VolumeMonitorMountRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorMountRemovedCallback cb
        cb'' <- mk_VolumeMonitorMountRemovedCallback cb'
        connectSignalFunPtr obj "mount-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::mount-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:mountRemoved"})

#endif

-- signal VolumeMonitor::volume-added
-- | Emitted when a mountable volume is added to the system.
type VolumeMonitorVolumeAddedCallback =
    Gio.Volume.Volume
    -- ^ /@volume@/: a t'GI.Gio.Interfaces.Volume.Volume' that was added.
    -> IO ()

type C_VolumeMonitorVolumeAddedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Volume.Volume ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorVolumeAddedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorVolumeAddedCallback :: C_VolumeMonitorVolumeAddedCallback -> IO (FunPtr C_VolumeMonitorVolumeAddedCallback)

wrap_VolumeMonitorVolumeAddedCallback :: 
    GObject a => (a -> VolumeMonitorVolumeAddedCallback) ->
    C_VolumeMonitorVolumeAddedCallback
wrap_VolumeMonitorVolumeAddedCallback gi'cb gi'selfPtr volume _ = do
    volume' <- (newObject Gio.Volume.Volume) volume
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  volume'


-- | Connect a signal handler for the [volumeAdded](#signal:volumeAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #volumeAdded callback
-- @
-- 
-- 
onVolumeMonitorVolumeAdded :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorVolumeAddedCallback) -> m SignalHandlerId
onVolumeMonitorVolumeAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorVolumeAddedCallback wrapped
    wrapped'' <- mk_VolumeMonitorVolumeAddedCallback wrapped'
    connectSignalFunPtr obj "volume-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [volumeAdded](#signal:volumeAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #volumeAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorVolumeAdded :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorVolumeAddedCallback) -> m SignalHandlerId
afterVolumeMonitorVolumeAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorVolumeAddedCallback wrapped
    wrapped'' <- mk_VolumeMonitorVolumeAddedCallback wrapped'
    connectSignalFunPtr obj "volume-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorVolumeAddedSignalInfo
instance SignalInfo VolumeMonitorVolumeAddedSignalInfo where
    type HaskellCallbackType VolumeMonitorVolumeAddedSignalInfo = VolumeMonitorVolumeAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorVolumeAddedCallback cb
        cb'' <- mk_VolumeMonitorVolumeAddedCallback cb'
        connectSignalFunPtr obj "volume-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::volume-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:volumeAdded"})

#endif

-- signal VolumeMonitor::volume-changed
-- | Emitted when mountable volume is changed.
type VolumeMonitorVolumeChangedCallback =
    Gio.Volume.Volume
    -- ^ /@volume@/: a t'GI.Gio.Interfaces.Volume.Volume' that changed.
    -> IO ()

type C_VolumeMonitorVolumeChangedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Volume.Volume ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorVolumeChangedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorVolumeChangedCallback :: C_VolumeMonitorVolumeChangedCallback -> IO (FunPtr C_VolumeMonitorVolumeChangedCallback)

wrap_VolumeMonitorVolumeChangedCallback :: 
    GObject a => (a -> VolumeMonitorVolumeChangedCallback) ->
    C_VolumeMonitorVolumeChangedCallback
wrap_VolumeMonitorVolumeChangedCallback gi'cb gi'selfPtr volume _ = do
    volume' <- (newObject Gio.Volume.Volume) volume
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  volume'


-- | Connect a signal handler for the [volumeChanged](#signal:volumeChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #volumeChanged callback
-- @
-- 
-- 
onVolumeMonitorVolumeChanged :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorVolumeChangedCallback) -> m SignalHandlerId
onVolumeMonitorVolumeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorVolumeChangedCallback wrapped
    wrapped'' <- mk_VolumeMonitorVolumeChangedCallback wrapped'
    connectSignalFunPtr obj "volume-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [volumeChanged](#signal:volumeChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #volumeChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorVolumeChanged :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorVolumeChangedCallback) -> m SignalHandlerId
afterVolumeMonitorVolumeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorVolumeChangedCallback wrapped
    wrapped'' <- mk_VolumeMonitorVolumeChangedCallback wrapped'
    connectSignalFunPtr obj "volume-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorVolumeChangedSignalInfo
instance SignalInfo VolumeMonitorVolumeChangedSignalInfo where
    type HaskellCallbackType VolumeMonitorVolumeChangedSignalInfo = VolumeMonitorVolumeChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorVolumeChangedCallback cb
        cb'' <- mk_VolumeMonitorVolumeChangedCallback cb'
        connectSignalFunPtr obj "volume-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::volume-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:volumeChanged"})

#endif

-- signal VolumeMonitor::volume-removed
-- | Emitted when a mountable volume is removed from the system.
type VolumeMonitorVolumeRemovedCallback =
    Gio.Volume.Volume
    -- ^ /@volume@/: a t'GI.Gio.Interfaces.Volume.Volume' that was removed.
    -> IO ()

type C_VolumeMonitorVolumeRemovedCallback =
    Ptr VolumeMonitor ->                    -- object
    Ptr Gio.Volume.Volume ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_VolumeMonitorVolumeRemovedCallback`.
foreign import ccall "wrapper"
    mk_VolumeMonitorVolumeRemovedCallback :: C_VolumeMonitorVolumeRemovedCallback -> IO (FunPtr C_VolumeMonitorVolumeRemovedCallback)

wrap_VolumeMonitorVolumeRemovedCallback :: 
    GObject a => (a -> VolumeMonitorVolumeRemovedCallback) ->
    C_VolumeMonitorVolumeRemovedCallback
wrap_VolumeMonitorVolumeRemovedCallback gi'cb gi'selfPtr volume _ = do
    volume' <- (newObject Gio.Volume.Volume) volume
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  volume'


-- | Connect a signal handler for the [volumeRemoved](#signal:volumeRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' volumeMonitor #volumeRemoved callback
-- @
-- 
-- 
onVolumeMonitorVolumeRemoved :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorVolumeRemovedCallback) -> m SignalHandlerId
onVolumeMonitorVolumeRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorVolumeRemovedCallback wrapped
    wrapped'' <- mk_VolumeMonitorVolumeRemovedCallback wrapped'
    connectSignalFunPtr obj "volume-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [volumeRemoved](#signal:volumeRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' volumeMonitor #volumeRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterVolumeMonitorVolumeRemoved :: (IsVolumeMonitor a, MonadIO m) => a -> ((?self :: a) => VolumeMonitorVolumeRemovedCallback) -> m SignalHandlerId
afterVolumeMonitorVolumeRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_VolumeMonitorVolumeRemovedCallback wrapped
    wrapped'' <- mk_VolumeMonitorVolumeRemovedCallback wrapped'
    connectSignalFunPtr obj "volume-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data VolumeMonitorVolumeRemovedSignalInfo
instance SignalInfo VolumeMonitorVolumeRemovedSignalInfo where
    type HaskellCallbackType VolumeMonitorVolumeRemovedSignalInfo = VolumeMonitorVolumeRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_VolumeMonitorVolumeRemovedCallback cb
        cb'' <- mk_VolumeMonitorVolumeRemovedCallback cb'
        connectSignalFunPtr obj "volume-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor::volume-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#g:signal:volumeRemoved"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList VolumeMonitor
type instance O.AttributeList VolumeMonitor = VolumeMonitorAttributeList
type VolumeMonitorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList VolumeMonitor = VolumeMonitorSignalList
type VolumeMonitorSignalList = ('[ '("driveChanged", VolumeMonitorDriveChangedSignalInfo), '("driveConnected", VolumeMonitorDriveConnectedSignalInfo), '("driveDisconnected", VolumeMonitorDriveDisconnectedSignalInfo), '("driveEjectButton", VolumeMonitorDriveEjectButtonSignalInfo), '("driveStopButton", VolumeMonitorDriveStopButtonSignalInfo), '("mountAdded", VolumeMonitorMountAddedSignalInfo), '("mountChanged", VolumeMonitorMountChangedSignalInfo), '("mountPreUnmount", VolumeMonitorMountPreUnmountSignalInfo), '("mountRemoved", VolumeMonitorMountRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("volumeAdded", VolumeMonitorVolumeAddedSignalInfo), '("volumeChanged", VolumeMonitorVolumeChangedSignalInfo), '("volumeRemoved", VolumeMonitorVolumeRemovedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method VolumeMonitor::get_connected_drives
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "volume_monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "VolumeMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVolumeMonitor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gio" , name = "Drive" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_volume_monitor_get_connected_drives" g_volume_monitor_get_connected_drives :: 
    Ptr VolumeMonitor ->                    -- volume_monitor : TInterface (Name {namespace = "Gio", name = "VolumeMonitor"})
    IO (Ptr (GList (Ptr Gio.Drive.Drive)))

-- | Gets a list of drives connected to the system.
-- 
-- The returned list should be freed with @/g_list_free()/@, after
-- its elements have been unreffed with 'GI.GObject.Objects.Object.objectUnref'.
volumeMonitorGetConnectedDrives ::
    (B.CallStack.HasCallStack, MonadIO m, IsVolumeMonitor a) =>
    a
    -- ^ /@volumeMonitor@/: a t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor'.
    -> m [Gio.Drive.Drive]
    -- ^ __Returns:__ a t'GI.GLib.Structs.List.List' of connected t'GI.Gio.Interfaces.Drive.Drive' objects.
volumeMonitorGetConnectedDrives volumeMonitor = liftIO $ do
    volumeMonitor' <- unsafeManagedPtrCastPtr volumeMonitor
    result <- g_volume_monitor_get_connected_drives volumeMonitor'
    result' <- unpackGList result
    result'' <- mapM (wrapObject Gio.Drive.Drive) result'
    g_list_free result
    touchManagedPtr volumeMonitor
    return result''

#if defined(ENABLE_OVERLOADING)
data VolumeMonitorGetConnectedDrivesMethodInfo
instance (signature ~ (m [Gio.Drive.Drive]), MonadIO m, IsVolumeMonitor a) => O.OverloadedMethod VolumeMonitorGetConnectedDrivesMethodInfo a signature where
    overloadedMethod = volumeMonitorGetConnectedDrives

instance O.OverloadedMethodInfo VolumeMonitorGetConnectedDrivesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor.volumeMonitorGetConnectedDrives",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#v:volumeMonitorGetConnectedDrives"
        })


#endif

-- method VolumeMonitor::get_mount_for_uuid
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "volume_monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "VolumeMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVolumeMonitor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uuid"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the UUID to look for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Mount" })
-- throws : False
-- Skip return : False

foreign import ccall "g_volume_monitor_get_mount_for_uuid" g_volume_monitor_get_mount_for_uuid :: 
    Ptr VolumeMonitor ->                    -- volume_monitor : TInterface (Name {namespace = "Gio", name = "VolumeMonitor"})
    CString ->                              -- uuid : TBasicType TUTF8
    IO (Ptr Gio.Mount.Mount)

-- | Finds a t'GI.Gio.Interfaces.Mount.Mount' object by its UUID (see 'GI.Gio.Interfaces.Mount.mountGetUuid')
volumeMonitorGetMountForUuid ::
    (B.CallStack.HasCallStack, MonadIO m, IsVolumeMonitor a) =>
    a
    -- ^ /@volumeMonitor@/: a t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor'.
    -> T.Text
    -- ^ /@uuid@/: the UUID to look for
    -> m (Maybe Gio.Mount.Mount)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Mount.Mount' or 'P.Nothing' if no such mount is available.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
volumeMonitorGetMountForUuid volumeMonitor uuid = liftIO $ do
    volumeMonitor' <- unsafeManagedPtrCastPtr volumeMonitor
    uuid' <- textToCString uuid
    result <- g_volume_monitor_get_mount_for_uuid volumeMonitor' uuid'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.Mount.Mount) result'
        return result''
    touchManagedPtr volumeMonitor
    freeMem uuid'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data VolumeMonitorGetMountForUuidMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gio.Mount.Mount)), MonadIO m, IsVolumeMonitor a) => O.OverloadedMethod VolumeMonitorGetMountForUuidMethodInfo a signature where
    overloadedMethod = volumeMonitorGetMountForUuid

instance O.OverloadedMethodInfo VolumeMonitorGetMountForUuidMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor.volumeMonitorGetMountForUuid",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#v:volumeMonitorGetMountForUuid"
        })


#endif

-- method VolumeMonitor::get_mounts
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "volume_monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "VolumeMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVolumeMonitor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gio" , name = "Mount" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_volume_monitor_get_mounts" g_volume_monitor_get_mounts :: 
    Ptr VolumeMonitor ->                    -- volume_monitor : TInterface (Name {namespace = "Gio", name = "VolumeMonitor"})
    IO (Ptr (GList (Ptr Gio.Mount.Mount)))

-- | Gets a list of the mounts on the system.
-- 
-- The returned list should be freed with @/g_list_free()/@, after
-- its elements have been unreffed with 'GI.GObject.Objects.Object.objectUnref'.
volumeMonitorGetMounts ::
    (B.CallStack.HasCallStack, MonadIO m, IsVolumeMonitor a) =>
    a
    -- ^ /@volumeMonitor@/: a t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor'.
    -> m [Gio.Mount.Mount]
    -- ^ __Returns:__ a t'GI.GLib.Structs.List.List' of t'GI.Gio.Interfaces.Mount.Mount' objects.
volumeMonitorGetMounts volumeMonitor = liftIO $ do
    volumeMonitor' <- unsafeManagedPtrCastPtr volumeMonitor
    result <- g_volume_monitor_get_mounts volumeMonitor'
    result' <- unpackGList result
    result'' <- mapM (wrapObject Gio.Mount.Mount) result'
    g_list_free result
    touchManagedPtr volumeMonitor
    return result''

#if defined(ENABLE_OVERLOADING)
data VolumeMonitorGetMountsMethodInfo
instance (signature ~ (m [Gio.Mount.Mount]), MonadIO m, IsVolumeMonitor a) => O.OverloadedMethod VolumeMonitorGetMountsMethodInfo a signature where
    overloadedMethod = volumeMonitorGetMounts

instance O.OverloadedMethodInfo VolumeMonitorGetMountsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor.volumeMonitorGetMounts",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#v:volumeMonitorGetMounts"
        })


#endif

-- method VolumeMonitor::get_volume_for_uuid
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "volume_monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "VolumeMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVolumeMonitor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uuid"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the UUID to look for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Volume" })
-- throws : False
-- Skip return : False

foreign import ccall "g_volume_monitor_get_volume_for_uuid" g_volume_monitor_get_volume_for_uuid :: 
    Ptr VolumeMonitor ->                    -- volume_monitor : TInterface (Name {namespace = "Gio", name = "VolumeMonitor"})
    CString ->                              -- uuid : TBasicType TUTF8
    IO (Ptr Gio.Volume.Volume)

-- | Finds a t'GI.Gio.Interfaces.Volume.Volume' object by its UUID (see 'GI.Gio.Interfaces.Volume.volumeGetUuid')
volumeMonitorGetVolumeForUuid ::
    (B.CallStack.HasCallStack, MonadIO m, IsVolumeMonitor a) =>
    a
    -- ^ /@volumeMonitor@/: a t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor'.
    -> T.Text
    -- ^ /@uuid@/: the UUID to look for
    -> m (Maybe Gio.Volume.Volume)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Volume.Volume' or 'P.Nothing' if no such volume is available.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
volumeMonitorGetVolumeForUuid volumeMonitor uuid = liftIO $ do
    volumeMonitor' <- unsafeManagedPtrCastPtr volumeMonitor
    uuid' <- textToCString uuid
    result <- g_volume_monitor_get_volume_for_uuid volumeMonitor' uuid'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.Volume.Volume) result'
        return result''
    touchManagedPtr volumeMonitor
    freeMem uuid'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data VolumeMonitorGetVolumeForUuidMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gio.Volume.Volume)), MonadIO m, IsVolumeMonitor a) => O.OverloadedMethod VolumeMonitorGetVolumeForUuidMethodInfo a signature where
    overloadedMethod = volumeMonitorGetVolumeForUuid

instance O.OverloadedMethodInfo VolumeMonitorGetVolumeForUuidMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor.volumeMonitorGetVolumeForUuid",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#v:volumeMonitorGetVolumeForUuid"
        })


#endif

-- method VolumeMonitor::get_volumes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "volume_monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "VolumeMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVolumeMonitor." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gio" , name = "Volume" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_volume_monitor_get_volumes" g_volume_monitor_get_volumes :: 
    Ptr VolumeMonitor ->                    -- volume_monitor : TInterface (Name {namespace = "Gio", name = "VolumeMonitor"})
    IO (Ptr (GList (Ptr Gio.Volume.Volume)))

-- | Gets a list of the volumes on the system.
-- 
-- The returned list should be freed with @/g_list_free()/@, after
-- its elements have been unreffed with 'GI.GObject.Objects.Object.objectUnref'.
volumeMonitorGetVolumes ::
    (B.CallStack.HasCallStack, MonadIO m, IsVolumeMonitor a) =>
    a
    -- ^ /@volumeMonitor@/: a t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor'.
    -> m [Gio.Volume.Volume]
    -- ^ __Returns:__ a t'GI.GLib.Structs.List.List' of t'GI.Gio.Interfaces.Volume.Volume' objects.
volumeMonitorGetVolumes volumeMonitor = liftIO $ do
    volumeMonitor' <- unsafeManagedPtrCastPtr volumeMonitor
    result <- g_volume_monitor_get_volumes volumeMonitor'
    result' <- unpackGList result
    result'' <- mapM (wrapObject Gio.Volume.Volume) result'
    g_list_free result
    touchManagedPtr volumeMonitor
    return result''

#if defined(ENABLE_OVERLOADING)
data VolumeMonitorGetVolumesMethodInfo
instance (signature ~ (m [Gio.Volume.Volume]), MonadIO m, IsVolumeMonitor a) => O.OverloadedMethod VolumeMonitorGetVolumesMethodInfo a signature where
    overloadedMethod = volumeMonitorGetVolumes

instance O.OverloadedMethodInfo VolumeMonitorGetVolumesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.VolumeMonitor.volumeMonitorGetVolumes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-VolumeMonitor.html#v:volumeMonitorGetVolumes"
        })


#endif

-- method VolumeMonitor::adopt_orphan_mount
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount object to find a parent for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Volume" })
-- throws : False
-- Skip return : False

foreign import ccall "g_volume_monitor_adopt_orphan_mount" g_volume_monitor_adopt_orphan_mount :: 
    Ptr Gio.Mount.Mount ->                  -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO (Ptr Gio.Volume.Volume)

{-# DEPRECATED volumeMonitorAdoptOrphanMount ["(Since version 2.20)","Instead of using this function, t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor'","implementations should instead create shadow mounts with the URI of","the mount they intend to adopt. See the proxy volume monitor in","gvfs for an example of this. Also see 'GI.Gio.Interfaces.Mount.mountIsShadowed',","'GI.Gio.Interfaces.Mount.mountShadow' and 'GI.Gio.Interfaces.Mount.mountUnshadow' functions."] #-}
-- | This function should be called by any t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor'
-- implementation when a new t'GI.Gio.Interfaces.Mount.Mount' object is created that is not
-- associated with a t'GI.Gio.Interfaces.Volume.Volume' object. It must be called just before
-- emitting the /@mountAdded@/ signal.
-- 
-- If the return value is not 'P.Nothing', the caller must associate the
-- returned t'GI.Gio.Interfaces.Volume.Volume' object with the t'GI.Gio.Interfaces.Mount.Mount'. This involves returning
-- it in its 'GI.Gio.Interfaces.Mount.mountGetVolume' implementation. The caller must
-- also listen for the \"removed\" signal on the returned object
-- and give up its reference when handling that signal
-- 
-- Similarly, if implementing 'GI.Gio.Objects.VolumeMonitor.volumeMonitorAdoptOrphanMount',
-- the implementor must take a reference to /@mount@/ and return it in
-- its 'GI.Gio.Interfaces.Volume.volumeGetMount' implemented. Also, the implementor must
-- listen for the \"unmounted\" signal on /@mount@/ and give up its
-- reference upon handling that signal.
-- 
-- There are two main use cases for this function.
-- 
-- One is when implementing a user space file system driver that reads
-- blocks of a block device that is already represented by the native
-- volume monitor (for example a CD Audio file system driver). Such
-- a driver will generate its own t'GI.Gio.Interfaces.Mount.Mount' object that needs to be
-- associated with the t'GI.Gio.Interfaces.Volume.Volume' object that represents the volume.
-- 
-- The other is for implementing a t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor' whose sole purpose
-- is to return t'GI.Gio.Interfaces.Volume.Volume' objects representing entries in the users
-- \"favorite servers\" list or similar.
volumeMonitorAdoptOrphanMount ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Mount.IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount' object to find a parent for
    -> m Gio.Volume.Volume
    -- ^ __Returns:__ the t'GI.Gio.Interfaces.Volume.Volume' object that is the parent for /@mount@/ or 'P.Nothing'
    -- if no wants to adopt the t'GI.Gio.Interfaces.Mount.Mount'.
volumeMonitorAdoptOrphanMount mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_volume_monitor_adopt_orphan_mount mount'
    checkUnexpectedReturnNULL "volumeMonitorAdoptOrphanMount" result
    result' <- (wrapObject Gio.Volume.Volume) result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method VolumeMonitor::get
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "VolumeMonitor" })
-- throws : False
-- Skip return : False

foreign import ccall "g_volume_monitor_get" g_volume_monitor_get :: 
    IO (Ptr VolumeMonitor)

-- | Gets the volume monitor used by gio.
volumeMonitorGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m VolumeMonitor
    -- ^ __Returns:__ a reference to the t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor' used by gio. Call
    --    'GI.GObject.Objects.Object.objectUnref' when done with it, after disconnecting any signal handlers.
volumeMonitorGet  = liftIO $ do
    result <- g_volume_monitor_get
    checkUnexpectedReturnNULL "volumeMonitorGet" result
    result' <- (wrapObject VolumeMonitor) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


