{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Struct used in t'GI.Gio.Enums.DBusError'.@/register_error_domain/@().
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusErrorEntry
    ( 

-- * Exported types
    DBusErrorEntry(..)                      ,
    newZeroDBusErrorEntry                   ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveDBusErrorEntryMethod             ,
#endif



 -- * Properties


-- ** dbusErrorName #attr:dbusErrorName#
-- | the D-Bus error name to associate with /@errorCode@/

    clearDBusErrorEntryDbusErrorName        ,
#if defined(ENABLE_OVERLOADING)
    dBusErrorEntry_dbusErrorName            ,
#endif
    getDBusErrorEntryDbusErrorName          ,
    setDBusErrorEntryDbusErrorName          ,


-- ** errorCode #attr:errorCode#
-- | an error code

#if defined(ENABLE_OVERLOADING)
    dBusErrorEntry_errorCode                ,
#endif
    getDBusErrorEntryErrorCode              ,
    setDBusErrorEntryErrorCode              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype DBusErrorEntry = DBusErrorEntry (SP.ManagedPtr DBusErrorEntry)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusErrorEntry where
    toManagedPtr (DBusErrorEntry p) = p

instance BoxedPtr DBusErrorEntry where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr DBusErrorEntry)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr DBusErrorEntry where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'DBusErrorEntry' struct initialized to zero.
newZeroDBusErrorEntry :: MonadIO m => m DBusErrorEntry
newZeroDBusErrorEntry = liftIO $ boxedPtrCalloc >>= wrapPtr DBusErrorEntry

instance tag ~ 'AttrSet => Constructible DBusErrorEntry tag where
    new _ attrs = do
        o <- newZeroDBusErrorEntry
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@error_code@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusErrorEntry #errorCode
-- @
getDBusErrorEntryErrorCode :: MonadIO m => DBusErrorEntry -> m Int32
getDBusErrorEntryErrorCode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@error_code@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusErrorEntry [ #errorCode 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusErrorEntryErrorCode :: MonadIO m => DBusErrorEntry -> Int32 -> m ()
setDBusErrorEntryErrorCode s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data DBusErrorEntryErrorCodeFieldInfo
instance AttrInfo DBusErrorEntryErrorCodeFieldInfo where
    type AttrBaseTypeConstraint DBusErrorEntryErrorCodeFieldInfo = (~) DBusErrorEntry
    type AttrAllowedOps DBusErrorEntryErrorCodeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DBusErrorEntryErrorCodeFieldInfo = (~) Int32
    type AttrTransferTypeConstraint DBusErrorEntryErrorCodeFieldInfo = (~)Int32
    type AttrTransferType DBusErrorEntryErrorCodeFieldInfo = Int32
    type AttrGetType DBusErrorEntryErrorCodeFieldInfo = Int32
    type AttrLabel DBusErrorEntryErrorCodeFieldInfo = "error_code"
    type AttrOrigin DBusErrorEntryErrorCodeFieldInfo = DBusErrorEntry
    attrGet = getDBusErrorEntryErrorCode
    attrSet = setDBusErrorEntryErrorCode
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusErrorEntry.errorCode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusErrorEntry.html#g:attr:errorCode"
        })

dBusErrorEntry_errorCode :: AttrLabelProxy "errorCode"
dBusErrorEntry_errorCode = AttrLabelProxy

#endif


-- | Get the value of the “@dbus_error_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusErrorEntry #dbusErrorName
-- @
getDBusErrorEntryDbusErrorName :: MonadIO m => DBusErrorEntry -> m (Maybe T.Text)
getDBusErrorEntryDbusErrorName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@dbus_error_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusErrorEntry [ #dbusErrorName 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusErrorEntryDbusErrorName :: MonadIO m => DBusErrorEntry -> CString -> m ()
setDBusErrorEntryDbusErrorName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@dbus_error_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #dbusErrorName
-- @
clearDBusErrorEntryDbusErrorName :: MonadIO m => DBusErrorEntry -> m ()
clearDBusErrorEntryDbusErrorName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusErrorEntryDbusErrorNameFieldInfo
instance AttrInfo DBusErrorEntryDbusErrorNameFieldInfo where
    type AttrBaseTypeConstraint DBusErrorEntryDbusErrorNameFieldInfo = (~) DBusErrorEntry
    type AttrAllowedOps DBusErrorEntryDbusErrorNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusErrorEntryDbusErrorNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusErrorEntryDbusErrorNameFieldInfo = (~)CString
    type AttrTransferType DBusErrorEntryDbusErrorNameFieldInfo = CString
    type AttrGetType DBusErrorEntryDbusErrorNameFieldInfo = Maybe T.Text
    type AttrLabel DBusErrorEntryDbusErrorNameFieldInfo = "dbus_error_name"
    type AttrOrigin DBusErrorEntryDbusErrorNameFieldInfo = DBusErrorEntry
    attrGet = getDBusErrorEntryDbusErrorName
    attrSet = setDBusErrorEntryDbusErrorName
    attrConstruct = undefined
    attrClear = clearDBusErrorEntryDbusErrorName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusErrorEntry.dbusErrorName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusErrorEntry.html#g:attr:dbusErrorName"
        })

dBusErrorEntry_dbusErrorName :: AttrLabelProxy "dbusErrorName"
dBusErrorEntry_dbusErrorName = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusErrorEntry
type instance O.AttributeList DBusErrorEntry = DBusErrorEntryAttributeList
type DBusErrorEntryAttributeList = ('[ '("errorCode", DBusErrorEntryErrorCodeFieldInfo), '("dbusErrorName", DBusErrorEntryDbusErrorNameFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusErrorEntryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusErrorEntryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusErrorEntryMethod t DBusErrorEntry, O.OverloadedMethod info DBusErrorEntry p) => OL.IsLabel t (DBusErrorEntry -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusErrorEntryMethod t DBusErrorEntry, O.OverloadedMethod info DBusErrorEntry p, R.HasField t DBusErrorEntry p) => R.HasField t DBusErrorEntry p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusErrorEntryMethod t DBusErrorEntry, O.OverloadedMethodInfo info DBusErrorEntry) => OL.IsLabel t (O.MethodProxy info DBusErrorEntry) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


